/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license;

import com.nxp.s32ds.ext.rcp.license.ILicenseService;
import com.nxp.s32ds.ext.rcp.license.LicenseActivator;
import com.nxp.s32ds.ext.rcp.license.LicenseFeature;
import com.nxp.s32ds.ext.rcp.license.LicenseStatus;
import com.nxp.s32ds.ext.rcp.license.Messages;
import com.nxp.s32ds.ext.rcp.license.WarningMessageDialog;
import com.nxp.s32ds.ext.rcp.license.ui.LicenseWindow;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class StartupVerification
implements IStartup {
    public static final String JOB_NAME = "Licenses verification";

    public void earlyStartup() {
        Job job = new Job(JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                StartupVerification.this.execute(monitor);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family.equals(StartupVerification.JOB_NAME) || super.belongsTo(family);
            }
        };
        job.schedule();
    }

    public void execute(IProgressMonitor monitor) {
        ILicenseService ls = (ILicenseService)PlatformUI.getWorkbench().getService(ILicenseService.class);
        IPreferenceStore store = LicenseActivator.getDefault().getPreferenceStore();
        boolean displayWarningWindow = store.getBoolean("booleanDisplayWarningWindow");
        String delayType = store.getString("choiceDelayType");
        int numberOfDays = store.getInt("intNumberOfDays");
        LicenseFeature[] features = ls.getFeatures();
        boolean licenseMissing = false;
        boolean evaluationEnding = false;
        LicenseFeature[] licenseFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            LicenseFeature feature = licenseFeatureArray[n2];
            LicenseStatus status = feature.getStatus();
            if (!feature.isEnabled()) {
                licenseMissing = true;
            } else if (status == LicenseStatus.EVALUATION) {
                int days = feature.getEvaluationDays();
                int evaluationWarning = feature.getLicenseModel().getEvaluationWarningDays();
                if (delayType.equals("custom")) {
                    evaluationWarning = numberOfDays;
                }
                if (days < evaluationWarning) {
                    evaluationEnding = true;
                }
            }
            ++n2;
        }
        if (licenseMissing || LicenseActivator.isNeedWindow()) {
            LicenseWindow.show();
            LicenseActivator.setWindowNeeded(false);
        } else if (evaluationEnding && displayWarningWindow) {
            this.displayEndingDialog();
        }
    }

    private void runInUI(Runnable runnable) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (!workbench.getDisplay().isDisposed()) {
            workbench.getDisplay().syncExec(runnable);
        }
    }

    private void displayEndingDialog() {
        this.runInUI(new Runnable(){

            @Override
            public void run() {
                String[] buttons = new String[]{Messages.getString("StartupVerification_Yes", null), Messages.getString("StartupVerification_No", null)};
                WarningMessageDialog dialog = new WarningMessageDialog("booleanDisplayWarningWindow", PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.getString("StartupVerification_licensedProd", null), null, Messages.getString("StartupVerification_licenseEnding", null), 3, buttons, 0);
                if (dialog.open() == 0) {
                    LicenseWindow.show();
                }
            }
        });
    }
}

