/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core.makefilegenerator;

import com.nxp.s32ds.ext.cdt.core.makefilegenerator.BaseMakefileGenerator;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.CoreIDEMakefileGenerator;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.FSLPathUtil;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.LinkOrder;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.SourceChainMap;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.VariableRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.macros.IOptionContextData;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BaseCommandLineGenerator2
extends ManagedCommandLineGenerator {
    public static final String DOUBLE_QUOTE = "\"";
    public static final String DOUBLE_DOUBLE_QUOTE = "\"\"";
    private CoreIDEMakefileGenerator coreIDEMakefileGenerator;

    protected String getInputsStr(ITool tool, String[] inputResources) {
        if (inputResources == null) {
            inputResources = new String[]{};
        }
        StringBuilder inputsBuilder = new StringBuilder();
        LinkOrder linkOrder = new LinkOrder(tool);
        if (linkOrder.isEnabled()) {
            IConfiguration configuration = this.getMakefileGenerator().getConfig();
            linkOrder.update(configuration);
            try {
                inputsBuilder.append(BaseCommandLineGenerator2.getCustomLinkOrderInputs(tool, this.coreIDEMakefileGenerator, false));
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
        }
        boolean isCustomLinkOrder = inputsBuilder.length() > 0;
        String[] stringArray = inputResources;
        int n = inputResources.length;
        int n2 = 0;
        while (n2 < n) {
            String resource = stringArray[n2];
            if (!(resource == null || resource.length() == 0 || isCustomLinkOrder && (resource.startsWith("$(OBJS") || resource.startsWith("$(USER_OBJS")))) {
                String quote = resource.indexOf("$(") != 0 ? DOUBLE_QUOTE : "";
                inputsBuilder.append(" ").append(quote).append(resource).append(quote);
            }
            ++n2;
        }
        String inputsStr = inputsBuilder.toString().trim();
        return inputsStr;
    }

    static String convert(CoreIDEMakefileGenerator generator, String variable, String unflaggedPath, boolean useRelativeMakefileFormat) {
        String path;
        String prefix = FSLPathUtil.getPrefixBeforeQuotes(unflaggedPath);
        if (prefix != null) {
            unflaggedPath = unflaggedPath.substring(prefix.length());
        }
        if (FSLPathUtil.removeQuotes(unflaggedPath).length() == 0) {
            return "";
        }
        if (useRelativeMakefileFormat) {
            if (!FSLPathUtil.isQuoted(unflaggedPath)) {
                unflaggedPath = FSLPathUtil.quotePath(unflaggedPath);
            }
            path = VariableRegistry.getDefault().convertToRelativeMakefileFormat(unflaggedPath, "ProjDirPath", BaseCommandLineGenerator2.getProjectLocation(generator), generator.getExistingBuildVariableContainer());
        } else {
            if (FSLPathUtil.isQuoted(unflaggedPath)) {
                unflaggedPath = FSLPathUtil.removeQuotes(unflaggedPath);
            }
            IPath absolutePath = Path.fromOSString((String)unflaggedPath.toString());
            path = generator.getRelativeOutputPath(variable, "", absolutePath, true, false);
        }
        if (!FSLPathUtil.isQuoted(path)) {
            path = FSLPathUtil.quotePath(path);
        }
        if (prefix != null) {
            path = String.valueOf(prefix) + path;
        }
        return path;
    }

    public static String getCustomLinkOrderInputs(ITool linker, CoreIDEMakefileGenerator generator, boolean useRelativeMakefileFormat) throws BuildException {
        SourceChainMap chains = new SourceChainMap(linker);
        StringBuilder args = new StringBuilder();
        LinkOrder linkOrder = new LinkOrder(linker);
        Map<String, String> userObjectMap = BaseCommandLineGenerator2.getUserObjectMap(linker);
        String[] stringArray = linkOrder.get().orElse(new String[0]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String linkOrderItem = stringArray[n2];
            IFile file = generator.getProject().getFile(linkOrderItem);
            if (chains.containsKey(file.getFileExtension())) {
                ArrayList<IPath> paths = new ArrayList<IPath>();
                BaseCommandLineGenerator2.getLinkerInputs(generator, chains, file, paths);
                for (IPath path : paths) {
                    String unflaggedPath = DOUBLE_QUOTE + path.toPortableString() + DOUBLE_QUOTE;
                    BaseCommandLineGenerator2.updateArgs(generator, args, "OBJS_QUOTED", unflaggedPath, useRelativeMakefileFormat);
                }
            } else {
                for (String inputUserObject : userObjectMap.keySet()) {
                    if (!inputUserObject.equals(linkOrderItem)) continue;
                    BaseCommandLineGenerator2.updateArgs(generator, args, "USER_OBJS_QUOTED", userObjectMap.get(inputUserObject), useRelativeMakefileFormat);
                    break;
                }
            }
            ++n2;
        }
        return args.toString().trim();
    }

    protected static String getProjectLocation(CoreIDEMakefileGenerator generator) {
        return generator.getProject().getLocation().toPortableString();
    }

    private static void getLinkerInputs(BaseMakefileGenerator generator, SourceChainMap chains, IFile file, List<IPath> paths) {
        List chain = (List)chains.get(file.getFileExtension());
        if (chain == null) {
            return;
        }
        Vector<IPath> relativeOutputLocations = generator.getRelativeOutputLocations((IResource)file, (ITool)chain.get(0));
        IPath outputDir = generator.getBuildWorkingDirLocation();
        if (chain.size() == 2) {
            for (IPath relativeOutputLocation : relativeOutputLocations) {
                paths.add(outputDir.append(relativeOutputLocation));
            }
            return;
        }
        IProject project = generator.getProject();
        IPath relativeOutputDir = outputDir.removeFirstSegments(project.getLocation().segmentCount());
        for (IPath relativeOutputLocation : relativeOutputLocations) {
            IFile outputFile = project.getFile(relativeOutputDir.append(relativeOutputLocation));
            BaseCommandLineGenerator2.getLinkerInputs(generator, chains, outputFile, paths);
        }
    }

    private static void updateArgs(CoreIDEMakefileGenerator generator, StringBuilder args, String variable, String unflaggedPath, boolean useRelativeMakefileFormat) {
        String convertedPath = BaseCommandLineGenerator2.convert(generator, variable, unflaggedPath, useRelativeMakefileFormat);
        if (convertedPath.length() > 0) {
            args.append(convertedPath).append(" ");
        }
    }

    public static Map<String, String> getUserObjectMap(ITool tool) {
        HashMap<String, String> map = new HashMap<String, String>();
        IBuildMacroProvider buildMacroProvider = ManagedBuildManager.getBuildMacroProvider();
        for (IOption option : BaseCommandLineGenerator2.getOptions(tool, 7)) {
            try {
                String[] unresolvedObjects = option.getUserObjects();
                if (unresolvedObjects == null) continue;
                String[] stringArray = unresolvedObjects;
                int n = unresolvedObjects.length;
                int n2 = 0;
                while (n2 < n) {
                    String unresolvedObject = stringArray[n2];
                    try {
                        String[] resolved = BaseCommandLineGenerator2.resolve(tool, buildMacroProvider, option, unresolvedObject);
                        if (resolved != null && resolved.length > 0) {
                            map.put(unresolvedObject, resolved[0]);
                        }
                    }
                    catch (BuildMacroException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private static String[] resolve(final ITool tool, IBuildMacroProvider buildMacroProvider, final IOption option, String unresolvedObject) throws BuildMacroException {
        IOptionContextData contextData = new IOptionContextData(){

            public IOption getOption() {
                return option;
            }

            public IOptionCategory getOptionCategory() {
                return option.getCategory();
            }

            public IBuildObject getParent() {
                return tool;
            }
        };
        return buildMacroProvider.resolveStringListValueToMakefileFormat(unresolvedObject, "", " ", 2, (Object)contextData);
    }

    private static List<IOption> getOptions(ITool tool, int type) {
        ArrayList<IOption> options = new ArrayList<IOption>();
        IOption[] iOptionArray = tool.getOptions();
        int n = iOptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option = iOptionArray[n2];
            try {
                if (option.getValueType() == type) {
                    options.add(option);
                }
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return options;
    }

    public static Map<String, String> getLibMap(ITool tool, IBuildObject buildObject) {
        HashMap<String, String> map = new HashMap<String, String>();
        IBuildMacroProvider buildMacroProvider = ManagedBuildManager.getBuildMacroProvider();
        for (IOption option : BaseCommandLineGenerator2.getOptions(tool, 6)) {
            try {
                IOptionApplicability applicabilityCalculator = option.getApplicabilityCalculator();
                if (applicabilityCalculator != null && !applicabilityCalculator.isOptionUsedInCommandLine(buildObject, (IHoldsOptions)tool, option)) continue;
                String[] stringArray = option.getLibraries();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String lib = stringArray[n2];
                    try {
                        String[] resolvedLibs = BaseCommandLineGenerator2.resolve(tool, buildMacroProvider, option, lib);
                        if (resolvedLibs != null) {
                            resolvedLibs = BaseCommandLineGenerator2.splitMultipleQuotedEntries(resolvedLibs);
                            map.put(lib, String.valueOf(option.getCommand()) + resolvedLibs[0]);
                        }
                    }
                    catch (BuildMacroException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private static String[] splitMultipleQuotedEntries(String[] resolved) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = resolved;
        int n = resolved.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.startsWith(DOUBLE_DOUBLE_QUOTE) && str.endsWith(DOUBLE_DOUBLE_QUOTE) && str.length() > 2) {
                str = str.substring(1, str.length() - 1);
                int index = str.indexOf(DOUBLE_QUOTE);
                while (index != -1) {
                    if (index > 0) {
                        result.add(str.substring(0, index));
                        str = str.substring(index);
                    }
                    if ((index = str.indexOf(DOUBLE_QUOTE, 1)) != -1) {
                        result.add(str.substring(0, index + 1));
                        str = str.substring(index + 1).trim();
                    }
                    index = str.indexOf(DOUBLE_QUOTE);
                }
            } else {
                result.add(str);
            }
            ++n2;
        }
        return result.toArray(new String[0]);
    }

    public void setMakefileGenerator(CoreIDEMakefileGenerator coreIDEMakefileGenerator) {
        this.coreIDEMakefileGenerator = coreIDEMakefileGenerator;
    }

    public CoreIDEMakefileGenerator getMakefileGenerator() {
        return this.coreIDEMakefileGenerator;
    }
}

