/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.sdkexplorer.processors;

import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class SelectConstructorDialog
extends TitleAreaDialog {
    private List<IMethodDeclaration> constructors;
    private IMethodDeclaration selectedConstructor;
    private IMethodDeclaration result;
    private ComboViewer comboViewer;

    SelectConstructorDialog(Shell parent, List<IMethodDeclaration> constructors) {
        super(parent);
        this.constructors = constructors;
    }

    IMethodDeclaration getResult() {
        return this.result;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select class constructor");
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = new Composite(parentComposite, 0);
        GridDataFactory.fillDefaults().applyTo((Control)contents);
        this.setTitle("Constructors");
        this.setMessage("Please select constructor:");
        contents.setLayout((Layout)new GridLayout(2, false));
        this.setupCombo(contents);
        SelectConstructorDialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.result = this.selectedConstructor;
        super.okPressed();
    }

    private void setupCombo(Composite body) {
        Label label = new Label(body, 0);
        label.setText("Constructor:");
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)label);
        Combo combo = new Combo(body, 12);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)combo);
        this.comboViewer = new ComboViewer(combo);
        this.comboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return SelectConstructorDialog.this.constructors.toArray();
            }
        });
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                String result = "";
                try {
                    result = ((IMethodDeclaration)element).getSignature();
                }
                catch (CModelException e) {
                    e.printStackTrace();
                }
                return result;
            }
        });
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    SelectConstructorDialog.this.selectedConstructor = (IMethodDeclaration)sel.getFirstElement();
                }
            }
        });
        this.comboViewer.setInput(this.constructors);
        this.comboViewer.refresh();
        this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.constructors.get(0)));
    }
}

