/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal.handler;

import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.internal.SDKValidator;
import com.freescale.s32ds.cross.sdk.ui.internal.handler.SDKDialogHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;

public class SDKEditDialogHandler
extends SDKDialogHandler {
    public SDKEditDialogHandler(TitleAreaDialog dialog, IProject project) {
        super(dialog, project);
    }

    public boolean validateName(String sdkName) {
        SDKValidator.Result validationResult = this.validator.validateName(sdkName);
        switch (validationResult) {
            case VALIDATION_OK: {
                return true;
            }
            case FIELD_EMPTY: {
                this.dialog.setErrorMessage(Messages.SDKDialog_empty_name_error_text);
                return false;
            }
            case FIELD_FIRST_LETTER_ERROR: {
                this.dialog.setErrorMessage(Messages.SDKDialog_start_name_error_text);
                return false;
            }
            case FIELD_LENGTH_ERROR: {
                this.dialog.setErrorMessage(Messages.SDKEditDialog_name_too_long);
                return false;
            }
            case FIELD_CHARS_ERROR: {
                this.dialog.setErrorMessage(Messages.SDKDialog_lnu_name_error_text);
                return false;
            }
        }
        return false;
    }

    public boolean validateVersion(String sdkVersion) {
        SDKValidator.Result validationResult = this.validator.validateVersion(sdkVersion);
        switch (validationResult) {
            case VALIDATION_OK: {
                return true;
            }
            case FIELD_EMPTY: {
                this.dialog.setErrorMessage(Messages.SDKDialog_empty_version_error_text);
                return false;
            }
            case FIELD_CHARS_ERROR: {
                this.dialog.setErrorMessage(Messages.SDKEditDialog_VERSION_REQ);
                return false;
            }
        }
        return false;
    }

    public boolean validateExists(String sdkName, String sdkVersion) {
        SDKValidator.Result validationResult = this.validator.validateExists(sdkName, sdkVersion);
        if (SDKValidator.Result.SDK_EXISTS == validationResult) {
            this.dialog.setErrorMessage(Messages.SDKEditDialog_same_name_exists);
            return false;
        }
        return true;
    }

    public boolean validateEnvText(String text) {
        SDKValidator.Result validationResult = this.validator.validateFieldLength(text);
        if (SDKValidator.Result.FIELD_LENGTH_ERROR == validationResult) {
            this.dialog.setErrorMessage(Messages.SDKEditDialog_env_too_long);
            return false;
        }
        return true;
    }

    public boolean validatePathText(String path) {
        SDKValidator.Result validationResult = this.validator.validateFieldIsNullOrEmpty(path);
        if (SDKValidator.Result.FIELD_EMPTY == validationResult) {
            this.dialog.setErrorMessage(Messages.SDKDialog_empty_path_error_text);
            return false;
        }
        return true;
    }

    public boolean validateEnv(String name, boolean isSystem) {
        return this.validateEnv(name, isSystem, true);
    }

    public boolean validateEnv(String name, boolean isSystem, boolean isShowMessage) {
        SDKValidator.Result validationResult = this.validator.validateEnv(name, isSystem);
        switch (validationResult) {
            case VALIDATION_OK: {
                return true;
            }
            case FIELD_EMPTY: {
                if (isShowMessage) {
                    this.dialog.setErrorMessage(Messages.SDKDialog_empty_env_variable_name_error_text);
                }
                return false;
            }
            case FIELD_FIRST_LETTER_ERROR: {
                if (isShowMessage) {
                    this.dialog.setErrorMessage(Messages.SDKEditDialog_env_var_must_start_with_letter);
                }
                return false;
            }
            case FIELD_CHARS_ERROR: {
                if (isShowMessage) {
                    this.dialog.setErrorMessage(Messages.SDKEditDialog_env_name_error);
                }
                return false;
            }
            case ENV_VAR_EXISTS: {
                if (isShowMessage) {
                    this.dialog.setErrorMessage(String.format(Messages.SDKDialog_existing_env_variable_error_text, name));
                }
                return false;
            }
        }
        return false;
    }

    public boolean validateEnvVariableExist(String name) {
        if (SDKValidator.Result.VALIDATION_OK != this.validator.validateEnvVariableExist(name)) {
            this.dialog.setErrorMessage(String.format(Messages.SDKDialog_existing_env_variable_error_text, name));
            return false;
        }
        return true;
    }

    public boolean validatePath(String sdkPath, String envName, boolean isShowMessage) {
        SDKValidator.Result pathValidationResult = this.validator.validatePath(sdkPath, envName);
        if (SDKValidator.Result.VALIDATION_OK != pathValidationResult) {
            if (isShowMessage) {
                if (SDKValidator.Result.PATH_NOT_EXISTS == pathValidationResult) {
                    this.dialog.setErrorMessage(Messages.SDKDialog_path_not_exists_error_text);
                } else if (SDKValidator.Result.PATH_NOT_DIR == pathValidationResult) {
                    this.dialog.setErrorMessage(Messages.SDKDialog_path_is_not_dir_error_text);
                }
            }
            return false;
        }
        return true;
    }
}

