/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.Hardware;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.CoreTypeData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class FilterOptionsEditor {
    private final Composite parent;
    private Button cBtn;
    private Button cppBtn;
    private CheckboxTableViewer toolChainsViewer;
    private CheckboxTreeViewer coresViewer;

    public FilterOptionsEditor(Composite parent, boolean enabled, IFilterOptions options) {
        this.parent = parent;
        this.createWidgets(enabled);
        this.fillData(options);
    }

    private void createWidgets(boolean state) {
        this.parent.setLayout((Layout)new GridLayout(2, true));
        Group coresGroup = new Group(this.parent, 16);
        coresGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        coresGroup.setText("Cores");
        coresGroup.setLayout((Layout)new GridLayout(1, true));
        Button coreRadio = new Button((Composite)coresGroup, 16);
        coreRadio.setText("Core");
        ArrayList coreTypes = new ArrayList();
        ArrayList families = new ArrayList();
        Collection contexts = Hardware.instance().getModels();
        for (HWModel context : contexts) {
            coreTypes.addAll(context.getCoreTypes());
            families.addAll(context.getFamilies());
        }
        coreRadio.setData(coreTypes);
        coreRadio.addSelectionListener((SelectionListener)new ProcCoreSelectionListener());
        coreRadio.setSelection(true);
        coreRadio.setEnabled(state);
        Button procCoreRadio = new Button((Composite)coresGroup, 16);
        procCoreRadio.setText("Processor -> Core");
        Hardware.instance().getModels();
        procCoreRadio.setData(families);
        procCoreRadio.addSelectionListener((SelectionListener)new ProcCoreSelectionListener());
        procCoreRadio.setEnabled(state);
        this.coresViewer = new CheckboxTreeViewer((Composite)coresGroup, 2560);
        this.coresViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.coresViewer.setContentProvider((IContentProvider)new ProcCoreContentProvider());
        this.coresViewer.setLabelProvider((IBaseLabelProvider)new ProcCoreLabelProvider());
        this.coresViewer.getTree().setEnabled(state);
        this.coresViewer.setInput(coreRadio.getData());
        Composite langToolComposite = new Composite(this.parent, 0);
        langToolComposite.setLayout((Layout)new GridLayout(1, true));
        langToolComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Group langsGroup = new Group(langToolComposite, 16);
        langsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        langsGroup.setText("Language");
        langsGroup.setLayout((Layout)new GridLayout(1, true));
        this.cBtn = new Button((Composite)langsGroup, 32);
        this.cBtn.setText("C");
        this.cBtn.setEnabled(state);
        this.cppBtn = new Button((Composite)langsGroup, 32);
        this.cppBtn.setText("C++");
        this.cppBtn.setEnabled(state);
        Group toolchainsGroup = new Group(langToolComposite, 16);
        toolchainsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        toolchainsGroup.setText("ToolChains");
        toolchainsGroup.setLayout((Layout)new GridLayout(1, true));
        this.toolChainsViewer = CheckboxTableViewer.newCheckList((Composite)toolchainsGroup, (int)2560);
        this.toolChainsViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.toolChainsViewer.setContentProvider((IContentProvider)new ToolChainsContentProvider());
        this.toolChainsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.toolChainsViewer.getTable().setEnabled(state);
        this.toolChainsViewer.setInput((Object)ManagedBuildManager.getRealToolChains());
    }

    private void fillData(IFilterOptions options) {
        if (options == null) {
            return;
        }
        IFilterOptions.ELang langs = options.getLang();
        this.cBtn.setSelection(langs == IFilterOptions.ELang.ALL || langs == IFilterOptions.ELang.C);
        this.cppBtn.setSelection(langs == IFilterOptions.ELang.ALL || langs == IFilterOptions.ELang.CPP);
        this.toolChainsViewer.setCheckedElements((Object[])options.getToolChains());
    }

    public IFilterOptions getOptions() {
        boolean cLang = this.cBtn.getSelection();
        boolean cppLang = this.cppBtn.getSelection();
        IFilterOptions.ELang langs = cLang && cppLang ? IFilterOptions.ELang.ALL : (cLang ? IFilterOptions.ELang.C : (cppLang ? IFilterOptions.ELang.CPP : IFilterOptions.ELang.UNKNOWN));
        ArrayList<IToolChain> toolChains = new ArrayList<IToolChain>();
        Object[] objectArray = this.toolChainsViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IToolChain) {
                toolChains.add((IToolChain)element);
            }
            ++n2;
        }
        ArrayList<String> coreIds = new ArrayList<String>();
        Object[] objectArray2 = this.coresViewer.getCheckedElements();
        int n3 = objectArray2.length;
        n = 0;
        while (n < n3) {
            Object element = objectArray2[n];
            if (element instanceof CoreTypeData) {
                CoreTypeData ct = (CoreTypeData)element;
                coreIds.add(ct.getCoreKindId());
            } else {
                boolean cfr_ignored_0 = element instanceof CoreData;
            }
            ++n;
        }
        return new FilterOptions(langs, toolChains.toArray(new IToolChain[0]), coreIds.toArray(new String[0]));
    }

    class ProcCoreContentProvider
    implements ITreeContentProvider {
        ProcCoreContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof FamilyData[]) {
                ArrayList procs = new ArrayList();
                FamilyData[] familyDataArray = (FamilyData[])inputElement;
                int n = familyDataArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FamilyData family = familyDataArray[n2];
                    procs.addAll(family.getProcessors());
                    ++n2;
                }
                return procs.toArray();
            }
            if (inputElement instanceof List) {
                List coreTypes = (List)inputElement;
                Collections.sort(coreTypes, new Comparator<CoreTypeData>(){

                    @Override
                    public int compare(CoreTypeData o1, CoreTypeData o2) {
                        return o1.getId().compareTo(o2.getId());
                    }
                });
                return coreTypes.toArray();
            }
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ProcessorData) {
                List cores = ((ProcessorData)parentElement).getCores();
                return cores.toArray(new CoreData[cores.size()]);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ProcessorData;
        }
    }

    class ProcCoreLabelProvider
    extends LabelProvider {
        ProcCoreLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ProcessorData) {
                return ((ProcessorData)element).getId();
            }
            if (element instanceof CoreData) {
                return ((CoreData)element).getId();
            }
            if (element instanceof CoreTypeData) {
                return ((CoreTypeData)element).getId();
            }
            return super.getText(element);
        }
    }

    class ProcCoreSelectionListener
    implements SelectionListener {
        ProcCoreSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            FilterOptionsEditor.this.coresViewer.setInput(((Button)e.getSource()).getData());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    class ToolChainsContentProvider
    implements IStructuredContentProvider {
        private static final String S32TOOLCHAIN_PREFIX = "com.freescale.s32ds";

        ToolChainsContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IToolChain[]) {
                return this.filterInput((IToolChain[])inputElement);
            }
            return new Object[0];
        }

        private IToolChain[] filterInput(IToolChain[] input) {
            ArrayList<IToolChain> filtered = new ArrayList<IToolChain>();
            IToolChain[] iToolChainArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                IToolChain tc = iToolChainArray[n2];
                if (tc.getBaseId().startsWith(S32TOOLCHAIN_PREFIX)) {
                    filtered.add(tc);
                }
                ++n2;
            }
            return filtered.toArray(new IToolChain[0]);
        }
    }
}

