/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.processors;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.processors.Processor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LinkProcessor
extends Processor {
    public LinkProcessor(ISDK sdk, boolean isBackupFiles) {
        this.sdk = sdk;
        this.isBackupFiles = isBackupFiles;
    }

    @Override
    public void touchFolder(IFolder f) throws Exception {
        if (!f.exists()) {
            f.create(8192, true, null);
        }
    }

    @Override
    public void touchFile(IFile f, IPath path) throws Exception {
        if (f.exists() && ((IExtendedPath)path).isOverride()) {
            if (this.isBackupFiles) {
                this.createPRJBackupFile(f, path);
            } else {
                f.delete(true, null);
            }
        }
        if (!f.exists()) {
            Path sdkRootPath = new Path(SDKSupportPlugin.performStringSubstitution(SDKSupportPlugin.getEnvironment(this.sdk.getEnv().getName()).getValue(), this.sdk.getEnv().getName()));
            IPath p = path.makeRelativeTo((IPath)sdkRootPath);
            if (!path.equals((Object)p)) {
                p = sdkRootPath.append(p);
            }
            try {
                f.createLink(p, 256, null);
            }
            catch (NullPointerException nullPointerException) {
                SDKSupportPlugin.log("NPE caught for createLink " + p);
            }
        }
    }
}

