/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.AbstractSDK;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class ProjectUpdater {
    public static final boolean ADD = false;
    public static final boolean REMOVE = true;
    private static final String ERROR_NO_UPDATER = "Error: no Project Updater found for project %s, SDK %s.";
    private static final String ERROR_MANY_UPDATERS = "Warning: More than one Project Updater found for project %s, SDK %s : %s";
    private static final String MSG_OK = "The Project Updater %s processed the project %s, SDK %s.";
    private static final String QUOTE = "\"";
    private static final String UPDATER = "updater";
    private static final String PROJDIRPATH = "ProjDirPath";
    private static final int OP_C_INCLUDE = 0;
    private static final int OP_C_DEFINE = 1;
    private static final int OP_ASM_INCLUDE = 2;
    private static final int OP_ASM_DEFINE = 3;
    private static final int OP_LINK_LIBS = 4;
    private static final int OP_LINK_PATH = 5;
    private static final int OP_LINK_SCRIPT = 6;
    private static final int OP_CPP_DEFINE = 7;
    private static ProjectUpdater[] updaters = null;
    private final String name;
    private final String[] ops = new String[8];
    private final String libraryPrefix;
    private final String librarySuffix;
    private final String[] tcs;

    private static synchronized ProjectUpdater[] getUpdaters() {
        if (updaters == null) {
            HashMap<String, ProjectUpdater> map = new HashMap<String, ProjectUpdater>();
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.freescale.s32ds.cross.sdk.support.updater");
            if (ep != null) {
                IExtension[] iExtensionArray = ep.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension ext = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ProjectUpdater p;
                        IConfigurationElement ce = iConfigurationElementArray[n4];
                        if (ce.getName().equals(UPDATER) && (p = new ProjectUpdater(ce)).valid()) {
                            map.put(p.name, p);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            updaters = map.values().toArray(new ProjectUpdater[0]);
        }
        return updaters;
    }

    private ProjectUpdater(IConfigurationElement ce) {
        this.name = ce.getAttribute("name");
        this.ops[0] = ce.getAttribute("comInclude");
        this.ops[1] = ce.getAttribute("comDefine");
        this.ops[7] = ce.getAttribute("cppDefine");
        this.ops[2] = ce.getAttribute("asmInclude");
        this.ops[3] = ce.getAttribute("asmDefine");
        this.ops[4] = ce.getAttribute("linkLib");
        this.ops[5] = ce.getAttribute("linkPath");
        this.ops[6] = ce.getAttribute("linkLD");
        String tmp = ce.getAttribute("toolchains");
        this.tcs = tmp == null || tmp.isEmpty() ? null : tmp.split(",");
        this.libraryPrefix = ProjectUpdater.getStringAttribute(ce, "libraryPrefix");
        this.librarySuffix = ProjectUpdater.getStringAttribute(ce, "librarySuffix");
    }

    private boolean valid() {
        return this.tcs != null && this.tcs.length > 0 && this.tcs[0] != null && !this.tcs[0].isEmpty();
    }

    private boolean accept(IToolChain tc) {
        IToolChain tmp = tc;
        while (tmp != null) {
            String[] stringArray = this.tcs;
            int n = this.tcs.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equalsIgnoreCase(tmp.getId()) || s.equalsIgnoreCase(tmp.getBaseId())) {
                    return true;
                }
                tmp = tmp.getSuperClass();
                ++n2;
            }
        }
        return false;
    }

    private static String getStringAttribute(IConfigurationElement ce, String name) {
        String value = ce.getAttribute(name);
        return value != null ? value.trim() : "";
    }

    private boolean update(IConfiguration cfg, ISDK sdk, boolean remove) {
        if (sdk == null || cfg == null) {
            return false;
        }
        String id = cfg.getToolChain().getBaseId();
        LinkedList<String> incs = new LinkedList<String>();
        incs.addAll(Arrays.asList(sdk.getIncludePaths(id)));
        LinkedList<String> libs = new LinkedList<String>();
        libs.addAll(Arrays.asList(sdk.getPaths(sdk.getBinaries(id))));
        HashSet<String> tmp = new HashSet<String>();
        Path root = new Path(sdk.getEnv().getValue());
        IExtendedPath[] iExtendedPathArray = sdk.getLinkerFiles(id);
        int n = iExtendedPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtendedPath p = iExtendedPathArray[n2];
            IPath relative = p.makeRelativeTo((IPath)root);
            if (p.isCopy()) {
                tmp.add(AbstractSDK.generatePathString((IPath)new Path(String.valueOf(sdk.getName()) + '/' + relative.toOSString()), PROJDIRPATH));
            } else {
                tmp.add(AbstractSDK.generatePathString(relative, sdk.getEnv().getName()));
            }
            ++n2;
        }
        String[] lds = tmp.toArray(new String[tmp.size()]);
        String[] def = sdk.getDefSymbols(id);
        String[] inc = incs.toArray(new String[0]);
        String[] lib = libs.toArray(new String[0]);
        ProjectUpdater.updateOption(cfg, this.ops[0], new OptionUpdater(inc, remove));
        ProjectUpdater.updateOption(cfg, this.ops[1], new OptionUpdater(def, remove));
        ProjectUpdater.updateOption(cfg, this.ops[7], new OptionUpdater(def, remove));
        ProjectUpdater.updateOption(cfg, this.ops[2], new OptionUpdater(inc, remove));
        ProjectUpdater.updateOption(cfg, this.ops[3], new OptionUpdater(def, remove));
        ProjectUpdater.updateOption(cfg, this.ops[4], new OptionUpdater(this.makeLibs(this.getBinaryFiles(sdk, id)), remove));
        ProjectUpdater.updateOption(cfg, this.ops[5], new OptionUpdater(lib, remove));
        ProjectUpdater.updateOption(cfg, this.ops[6], new OptionUpdater(lds, remove));
        return true;
    }

    private String[] makeLibs(String[] ss) {
        int i = 0;
        while (i < ss.length) {
            ss[i] = new Path(ss[i]).lastSegment();
            if (ss[i].startsWith(QUOTE)) {
                ss[i] = ss[i].substring(1);
            }
            if (ss[i].endsWith(QUOTE)) {
                ss[i] = ss[i].substring(0, ss[i].length() - 1);
            }
            ss[i] = String.valueOf(this.libraryPrefix) + ss[i] + this.librarySuffix;
            ++i;
        }
        return ss;
    }

    private static void updateOption(IConfiguration cfg, String id, IOptionUpdater updater) {
        if (updater == null || id == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        boolean autoBuilding = workspaceDesc.isAutoBuilding();
        try {
            workspaceDesc.setAutoBuilding(false);
            workspace.setDescription(workspaceDesc);
            if (ProjectUpdater.setOptionValue(cfg, id, updater)) {
                ManagedBuildManager.saveBuildInfo((IProject)((IProject)cfg.getOwner()), (boolean)true);
            }
            workspaceDesc.setAutoBuilding(autoBuilding);
            workspace.setDescription(workspaceDesc);
        }
        catch (BuildException | CoreException e) {
            SDKSupportPlugin.error(e);
        }
    }

    private static boolean setOptionValue(IConfiguration cfg, String id, IOptionUpdater updater) throws BuildException {
        ITool[] tools;
        IProject p = (IProject)cfg.getOwner();
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)p);
        IManagedProject managedProject = buildInfo.getManagedProject();
        if (managedProject == null) {
            return false;
        }
        boolean modified = false;
        IToolChain toolChain = cfg.getToolChain();
        modified |= ProjectUpdater.setOptionForConfig(id, cfg, toolChain.getOptions(), (IHoldsOptions)toolChain, updater);
        ITool[] iToolArray = tools = cfg.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            modified |= ProjectUpdater.setOptionForConfig(id, cfg, tool.getOptions(), (IHoldsOptions)tool, updater);
            ++n2;
        }
        return modified;
    }

    private static boolean setOptionForConfig(String id, IConfiguration config, IOption[] options, IHoldsOptions optionHolder, IOptionUpdater updater) throws BuildException {
        boolean modified = false;
        String lowerId = id.toLowerCase();
        IOption[] iOptionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option = iOptionArray[n2];
            String lowerCaseOptionId = option.getBaseId().toLowerCase();
            if (lowerCaseOptionId.matches(lowerId)) {
                String[] list = null;
                switch (option.getValueType()) {
                    case 4: {
                        list = option.getIncludePaths();
                        break;
                    }
                    case 5: {
                        list = option.getDefinedSymbols();
                        break;
                    }
                    case 9: {
                        list = option.getLibraryPaths();
                        break;
                    }
                    case 6: {
                        list = option.getLibraries();
                        break;
                    }
                    case 3: {
                        list = option.getStringListValue();
                        break;
                    }
                }
                if (list != null) {
                    String[] newValue = updater.update(list);
                    ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)optionHolder, (IOption)option, (String[])newValue);
                    modified = true;
                }
            }
            ++n2;
        }
        return modified;
    }

    public static boolean updateOptions(IConfiguration cfg, ISDK sdk, boolean remove) {
        IToolChain tc = cfg.getToolChain();
        ArrayList<String> used = new ArrayList<String>();
        String name = String.valueOf(cfg.getName()) + " @ " + cfg.getOwner().getName() + (remove ? " (DETACH)" : " (ATTACH)");
        ProjectUpdater[] projectUpdaterArray = ProjectUpdater.getUpdaters();
        int n = projectUpdaterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectUpdater pu = projectUpdaterArray[n2];
            if (pu.accept(tc)) {
                pu.update(cfg, sdk, remove);
                used.add(pu.name);
            }
            ++n2;
        }
        if (used.size() == 0) {
            SDKSupportPlugin.log(String.format(ERROR_NO_UPDATER, name, sdk.getName()));
            return false;
        }
        if (used.size() > 1) {
            SDKSupportPlugin.log(String.format(ERROR_MANY_UPDATERS, name, sdk.getName(), used));
        } else {
            SDKSupportPlugin.log(String.format(MSG_OK, used.get(0), name, sdk.getName()));
        }
        return true;
    }

    public String[] getBinaryFiles(ISDK sdk, String id) {
        HashSet<String> paths = new HashSet<String>();
        IPath root = SDKSupportPlugin.getEclipsePath(sdk);
        IExtendedPath[] iExtendedPathArray = sdk.getBinaries(id);
        int n = iExtendedPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtendedPath p = iExtendedPathArray[n2];
            IPath relative = p.makeRelativeTo(root);
            paths.add(AbstractSDK.generatePathString(relative, sdk.getEnv().getName()));
            ++n2;
        }
        return paths.toArray(new String[paths.size()]);
    }

    static interface IOptionUpdater {
        public String[] update(String[] var1);
    }

    private static class OptionUpdater
    implements IOptionUpdater {
        private final String[] values;
        private final boolean remove;

        private OptionUpdater(String[] values, boolean remove) {
            this.values = values;
            this.remove = remove;
        }

        @Override
        public String[] update(String[] old) {
            ArrayList<String> l = new ArrayList<String>(Arrays.asList(old));
            String[] stringArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (this.remove) {
                    l.remove(value);
                } else if (!l.contains(value)) {
                    l.add(value);
                }
                ++n2;
            }
            return l.toArray(new String[l.size()]);
        }
    }
}

