/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker;

import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.AToolChainFPChecker;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class GHSToolChainFPChecker
extends AToolChainFPChecker {
    private static final String CCNATURE_ID = "org.eclipse.cdt.core.ccnature";
    private static final String GHS_CC_COMPILER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.executable.toolchain.cc_compiler.target_floating_point.floating_point_mode";
    private static final String GHS_CC_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.executable.toolchain.cc_compiler.target_floating_point.floating_point_mode.hardware_single_software_double";
    private static final String GHS_CX_COMPILER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.executable.toolchain.cx_compiler.target_floating_point.floating_point_mode";
    private static final String GHS_CX_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.executable.toolchain.cx_compiler.target_floating_point.floating_point_mode.hardware_single_software_double";
    private static final String GHS_CC_LINKER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.executable.toolchain.cc_linker.target_floating_point.floating_point_mode";
    private static final String GHS_CC_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.executable.toolchain.cc_linker.target_floating_point.floating_point_mode.hardware_single_software_double";
    private static final String GHS_CX_LINKER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.executable.toolchain.cx_linker.target_floating_point.floating_point_mode";
    private static final String GHS_CX_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.executable.toolchain.cx_linker.target_floating_point.floating_point_mode.hardware_single_software_double";
    private IGHSTargetFPCoProcessorOptionsChecker ghsTargetCFPCoProcessorOptionsChecker;
    private IGHSTargetFPCoProcessorOptionsChecker ghsTargetCppFPCoProcessorOptionsChecker;

    GHSToolChainFPChecker() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkToolChainFPOptionsSet(IToolChain tc) {
        try {
            ITool[] tools = tc.getTools();
            int toolsCount = tools.length;
            int i = 0;
            while (true) {
                if (i >= toolsCount) {
                    return true;
                }
                ITool tool = tools[i];
                if (!this.checkOptionValue(tool.getOptionBySuperClassId(GHS_CC_COMPILER_FP_COPROCESSOR_OPTION_ID), GHS_CC_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID)) {
                    return false;
                }
                if (!this.getGHSTargetToolChainFPChecker(tc).checkFPCoProcessorOptions(tc, tool)) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", "GHSToolChainFPChecker exception: " + ce.getMessage()));
            return true;
        }
    }

    private IGHSTargetFPCoProcessorOptionsChecker getGHSTargetToolChainFPChecker(IToolChain tc) throws CoreException {
        if (tc.getParent().getManagedProject().getOwner().getProject().getNature(CCNATURE_ID) != null) {
            if (this.ghsTargetCppFPCoProcessorOptionsChecker == null) {
                this.ghsTargetCppFPCoProcessorOptionsChecker = new GHSTargetCppFPCoProcessorOptionsChecker();
            }
            return this.ghsTargetCppFPCoProcessorOptionsChecker;
        }
        if (this.ghsTargetCFPCoProcessorOptionsChecker == null) {
            this.ghsTargetCFPCoProcessorOptionsChecker = new GHSTargetCFPCoProcessorOptionsChecker();
        }
        return this.ghsTargetCFPCoProcessorOptionsChecker;
    }

    class GHSTargetCFPCoProcessorOptionsChecker
    implements IGHSTargetFPCoProcessorOptionsChecker {
        GHSTargetCFPCoProcessorOptionsChecker() {
        }

        @Override
        public boolean checkFPCoProcessorOptions(IToolChain tc, ITool tool) {
            return GHSToolChainFPChecker.this.checkOptionValue(tool.getOptionBySuperClassId(GHSToolChainFPChecker.GHS_CC_LINKER_FP_COPROCESSOR_OPTION_ID), GHSToolChainFPChecker.GHS_CC_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID);
        }
    }

    class GHSTargetCppFPCoProcessorOptionsChecker
    implements IGHSTargetFPCoProcessorOptionsChecker {
        GHSTargetCppFPCoProcessorOptionsChecker() {
        }

        @Override
        public boolean checkFPCoProcessorOptions(IToolChain tc, ITool tool) {
            boolean isCheckPassed = GHSToolChainFPChecker.this.checkOptionValue(tool.getOptionBySuperClassId(GHSToolChainFPChecker.GHS_CX_COMPILER_FP_COPROCESSOR_OPTION_ID), GHSToolChainFPChecker.GHS_CX_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID);
            if (isCheckPassed) {
                isCheckPassed = GHSToolChainFPChecker.this.checkOptionValue(tool.getOptionBySuperClassId(GHSToolChainFPChecker.GHS_CX_LINKER_FP_COPROCESSOR_OPTION_ID), GHSToolChainFPChecker.GHS_CX_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID);
            }
            return isCheckPassed;
        }
    }

    static interface IGHSTargetFPCoProcessorOptionsChecker {
        public boolean checkFPCoProcessorOptions(IToolChain var1, ITool var2);
    }
}

