/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk;

import com.freescale.s32ds.cross.sdk.IJoinMapper;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ProjectChangeListener;
import com.freescale.s32ds.cross.sdk.SDKAttachListener;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.Environment;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.internal.variables.StringVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IStartup;
import org.osgi.framework.BundleContext;

public class SDKSupportPlugin
extends Plugin
implements IStartup {
    public static final String START_VAR = "${";
    public static final String SRC_XML = "sources.xml";
    public static final int INTERNAL_ERROR = 1200;
    public static final String PLUGIN_ID = "com.freescale.s32ds.cross.sdk.support";
    public static final PathMatcher headersMatcher = FileSystems.getDefault().getPathMatcher("regex:([ \\S]+(\\.(h|hpp|hxx|hh))$)");
    public static final PathMatcher binariesMatcher = FileSystems.getDefault().getPathMatcher("regex:([ \\S]+(\\.(a|so|la))$)");
    public static final PathMatcher sourcesMatcher = FileSystems.getDefault().getPathMatcher("regex:([ \\S]+(\\.(c|cpp|cc|C|cxx))$)");
    private static String reg = "regex:([ \\S]+(?<!(\\.c$|\\.cpp$|\\.cc$|\\.C$|\\.cxx$|\\.h$|\\.hpp$|\\.hxx$|\\.hh$|\\.a$|\\.so$|\\.la$|\\.ld$|\\\\$)))";
    public static final PathMatcher othersMatcher = FileSystems.getDefault().getPathMatcher(reg);
    public static final PathMatcher ldMatcher = FileSystems.getDefault().getPathMatcher("regex:([ \\S]+(\\.ld)$)");
    private static SDKSupportPlugin plugin;

    public SDKSupportPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        VariablesPlugin.getDefault().getStringVariableManager().addValueVariableListener(Environment.vvListener);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)new ProjectChangeListener(), 1);
        workspace.addResourceChangeListener((IResourceChangeListener)new SDKAttachListener(), 32);
    }

    public static <T> String join(List<T> objs, String separator, IJoinMapper<T> mapper) {
        if (objs == null || objs.isEmpty()) {
            return "";
        }
        int size = objs.size();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < size) {
            builder.append(mapper.map(objs.get(i)));
            if (i < size - 1) {
                builder.append(separator);
            }
            ++i;
        }
        return builder.toString();
    }

    public static ICProject findCProject(IProject project) {
        return CoreModel.getDefault().create(project);
    }

    public static String generateVariableExpression(String varName) {
        return VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(varName, null);
    }

    public static IEnvironment createEnvironment(String name, String ver, boolean isSystem, boolean readOnly, String initialPath, String desc) {
        String newname = name.toUpperCase() + "_" + ver + "_PATH";
        return SDKSupportPlugin.createEnvironment(newname, isSystem, readOnly, initialPath, desc);
    }

    public static IEnvironment createEnvironment(String name, boolean isSystem, boolean readOnly, String initialPath, String desc) {
        Environment env = new Environment(name, isSystem);
        if (!env.isSystem() && initialPath != null) {
            env.setValue(initialPath, desc, readOnly);
        }
        return env;
    }

    public static IEnvironment createEnvironment(IEnvironment env, String initialPath, boolean isReadOnly) {
        return SDKSupportPlugin.createEnvironment(env.getName(), env.isSystem(), isReadOnly, initialPath, "");
    }

    public static IEnvironment getEnvironment(String name, String ver) {
        String newname = name.toUpperCase().trim() + '_' + ver.trim() + "_PATH";
        return SDKSupportPlugin.getEnvironment(newname);
    }

    public static IEnvironment getEnvironment(String name) {
        return new Environment(name, false);
    }

    public static IPath getEclipsePath(ISDK sdk) {
        String path = sdk.getEnv().getValue();
        if (path == null) {
            return null;
        }
        String name = sdk.getEnv().getName();
        path = SDKSupportPlugin.performStringSubstitution(path, name);
        return Path.fromOSString((String)path);
    }

    public static boolean isVariableExists(String name) {
        return SDKSupportPlugin.getVariable(name) != null;
    }

    public static IValueVariable getVariable(String name) {
        return VariablesPlugin.getDefault().getStringVariableManager().getValueVariable(name);
    }

    public static String performStringSubstitution(String path, String name) {
        try {
            path = SDKSupportPlugin.substituteSystemVars(path, name, false);
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
        }
        catch (CoreException e) {
            SDKSupportPlugin.log(e.getStatus());
            return "";
        }
    }

    public static String substituteSystemVars(String s) throws CoreException {
        return SDKSupportPlugin.substituteSystemVars(s, null, true);
    }

    public static String substituteSystemVars(String s, String variableName) throws CoreException {
        return SDKSupportPlugin.substituteSystemVars(s, variableName, true);
    }

    private static String substituteSystemVars(String s, String variableName, boolean doThrow) throws CoreException {
        int n = s.indexOf(START_VAR);
        while (n >= 0) {
            int m = s.indexOf(125, n);
            if (m <= 0) {
                SDKSupportPlugin.error("Not correct variable in string: " + s, null);
                break;
            }
            String key = s.substring(n + START_VAR.length(), m);
            if (variableName != null && key.equals(variableName)) {
                String msg = NLS.bind((String)"Recursive declaration for variable {0}", (Object)variableName);
                throw new CoreException((IStatus)new Status(4, PLUGIN_ID, msg));
            }
            String txt = START_VAR + key + '}';
            String val = System.getenv().get(key);
            if (val == null) {
                IStringVariable[] iStringVariableArray = StringVariableManager.getDefault().getVariables();
                int n2 = iStringVariableArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IStringVariable v = iStringVariableArray[n3];
                    if (v.getName().equals(key)) {
                        if (v instanceof IDynamicVariable) {
                            try {
                                val = ((IDynamicVariable)v).getValue(null);
                            }
                            catch (CoreException e) {
                                SDKSupportPlugin.error(e);
                            }
                            break;
                        }
                        if (v instanceof IValueVariable) {
                            val = ((IValueVariable)v).getValue();
                            break;
                        }
                        val = v.getName();
                        break;
                    }
                    ++n3;
                }
            }
            if (val != null) {
                s = s.replace(txt, val);
            } else {
                n += txt.length();
                if (doThrow) {
                    String msg = NLS.bind((String)"Reference to undefined variable: {0}", (Object)key);
                    throw new CoreException((IStatus)new Status(4, PLUGIN_ID, msg));
                }
            }
            n = s.indexOf(START_VAR, n);
        }
        return s;
    }

    public static SDKSupportPlugin getDefault() {
        return plugin;
    }

    public static void error(Throwable t) {
        SDKSupportPlugin.log((IStatus)new Status(4, SDKSupportPlugin.getUniqueIdentifier(), 1200, "Error logged from SDK Support Core: ", t));
    }

    public static void error(String message, Throwable throwable) {
        SDKSupportPlugin.log((IStatus)new Status(4, SDKSupportPlugin.getUniqueIdentifier(), 1200, message, throwable));
    }

    public static void log(String message) {
        SDKSupportPlugin.log((IStatus)new Status(1, SDKSupportPlugin.getUniqueIdentifier(), 0, message, null));
    }

    public static void log(IStatus status) {
        SDKSupportPlugin.getDefault().getLog().log(status);
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public void earlyStartup() {
        WorkspaceJob xz = new WorkspaceJob("Init SDK"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                SDKUtils.init();
                return Status.OK_STATUS;
            }
        };
        xz.schedule();
    }
}

