/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.ui.intrinsics;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.ui.intrinsics.IntrinsicDeclaration;
import com.freescale.s32ds.cross.core.ui.intrinsics.IntrinsicInvocationFormatter;
import com.freescale.s32ds.cross.core.ui.intrinsics.IntrinsicsExplorer;
import com.freescale.s32ds.cross.core.ui.intrinsics.IntrinsicsGroup;
import com.freescale.s32ds.cross.core.ui.intrinsics.ToolchainIntrinsicsHolder;
import com.freescale.s32ds.ui.dndexplorer.ADragSourceListener;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;

class IntrinsicsDragSourceListener
extends ADragSourceListener {
    private String include;

    IntrinsicsDragSourceListener(AbstractTreeViewer abstractTreeViewer, IWorkbenchPartSite workbenchPartSite) {
        super(abstractTreeViewer, workbenchPartSite);
    }

    protected boolean isProcessDataDragAndDrop(Object data) {
        if (data instanceof IntrinsicDeclaration) {
            IntrinsicDeclaration intrinsicDeclaration = (IntrinsicDeclaration)data;
            return this.isDropTargetValid(intrinsicDeclaration);
        }
        return false;
    }

    protected void performDragSetData(DragSourceEvent event, Object data) {
        if (data instanceof IntrinsicDeclaration) {
            IntrinsicDeclaration intrinsicDeclaration = (IntrinsicDeclaration)data;
            event.data = IntrinsicInvocationFormatter.format(intrinsicDeclaration);
            this.include = intrinsicDeclaration.getInclude();
        }
    }

    protected void performDragFinished(DragSourceEvent event) {
        if (this.include != null && !this.include.isEmpty()) {
            IWorkingCopy tuDst = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.getEditorInput());
            try {
                int lastIncludeEndPosition = 0;
                if (tuDst.getInclude(this.include) != null) {
                    return;
                }
                IInclude[] includes = tuDst.getIncludes();
                if (includes.length > 0) {
                    IInclude lastInclude = includes[includes.length - 1];
                    ISourceRange lastIncludeSR = lastInclude.getSourceRange();
                    lastIncludeEndPosition = lastIncludeSR.getStartPos() + lastIncludeSR.getLength();
                }
                tuDst.createInclude(this.include, false, null, null);
                String contents = tuDst.getBuffer().getContents();
                StringBuilder sb = new StringBuilder();
                sb.append(contents.substring(0, lastIncludeEndPosition)).append("\r\n").append(contents.substring(lastIncludeEndPosition).replaceFirst("\n", ""));
                tuDst.getBuffer().setContents(sb.toString());
                this.updateIndex((ICElement)tuDst);
            }
            catch (CoreException e) {
                Activator.log((IStatus)new Status(4, "com.freescale.s32ds.cross.core", "Error while intrinsic drag-n-drop", (Throwable)e));
            }
        }
    }

    private void updateIndex(ICElement element) throws CoreException {
        IIndexManager indexManager = CCorePlugin.getIndexManager();
        indexManager.update(new ICElement[]{element}, 41);
    }

    private boolean isDropTargetValid(IntrinsicDeclaration intrinsicDeclaration) {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput == null) {
            return false;
        }
        IWorkingCopy tuDst = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        IToolChain toolchain = IntrinsicsExplorer.getToolchainFromProject(tuDst.getCProject().getProject());
        if (toolchain == null) {
            return false;
        }
        IntrinsicsGroup ig = (IntrinsicsGroup)intrinsicDeclaration.getHolder();
        if (!ig.check(tuDst.getCProject().getProject())) {
            return false;
        }
        List<ToolchainIntrinsicsHolder> tcHolders = IntrinsicsExplorer.tcRoot.findToolchainIntrinsicsHolders(toolchain);
        String tcBaseId = null;
        if (tcHolders.isEmpty()) {
            tcBaseId = toolchain.getBaseId();
            return IntrinsicsExplorer.tcRoot.isCompatibleWithToolchain(tcBaseId);
        }
        for (ToolchainIntrinsicsHolder tcHolder : tcHolders) {
            if (IntrinsicsExplorer.tcRoot.isCompatibleWithToolchain(tcHolder.getToolchainId())) continue;
            return false;
        }
        return true;
    }
}

