/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.data;

import com.freescale.s32ds.cross.core.model.DataType;
import com.freescale.s32ds.cross.core.model.ModelUtil;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.ValueType;
import com.freescale.s32ds.cross.core.model.data.CoProcessorData;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.CoreKindData;
import com.freescale.s32ds.cross.core.model.data.CoreTypeData;
import com.freescale.s32ds.cross.core.model.data.DataSet;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ObjectData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.core.model.data.SimpleData;
import com.freescale.s32ds.cross.core.model.data.TemplateData;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;

public class DataFactory {
    private DataFactory() {
    }

    public static ConfigurationData createData(IConfigurationElement ce, ConfigurationData parent, ModelRegistry registry) {
        String tag = ce.getName();
        if (tag.toUpperCase().endsWith(DataType.SET.name())) {
            return new DataSet(ce, parent, registry);
        }
        if ("template".equals(tag)) {
            return new TemplateData(ce, parent, registry);
        }
        if ("coreKind".equals(tag)) {
            return new CoreKindData(ce, parent, registry);
        }
        if ("coreType".equals(tag)) {
            return new CoreTypeData(ce, parent, registry);
        }
        if ("core".equals(tag)) {
            return new CoreData(ce, parent, registry);
        }
        if ("family".equals(tag)) {
            return new FamilyData(ce, parent, registry);
        }
        if ("processor".equals(tag)) {
            return new ProcessorData(ce, parent, registry);
        }
        if ("coProcessor".equals(tag)) {
            return new CoProcessorData(ce, parent, registry);
        }
        return new ObjectData(ce, parent, registry);
    }

    public static SimpleData createSimpleData(String tag, Object value, ConfigurationData parent) {
        ParameterType parameterType = parent.getRegistry().getParameterType(tag);
        if (parameterType == null) {
            return null;
        }
        return DataFactory.createSimpleData(parameterType, value, parent);
    }

    public static SimpleData createSimpleData(ParameterType parameterType, Object value, ConfigurationData parent) {
        if (ValueType.BOOLEAN == parameterType.getValueType()) {
            boolean v = value == null ? false : (value instanceof Boolean ? (Boolean)value : ModelUtil.parseBoolean(value.toString()));
            return new SimpleData(parameterType.getTag(), Boolean.toString(v), parent);
        }
        if (ValueType.INTEGER == parameterType.getValueType()) {
            int v = value == null ? 0 : (value instanceof Integer ? (Integer)value : ModelUtil.parseInteger(value.toString()));
            return new SimpleData(parameterType.getTag(), Integer.toString(v), parent);
        }
        if (ValueType.LONG == parameterType.getValueType()) {
            long v = value == null ? 0L : (value instanceof Long ? (Long)value : ModelUtil.parseLong(value.toString(), 16));
            return new SimpleData(parameterType.getTag(), Long.toString(v, 16), parent);
        }
        if (ValueType.STRING == parameterType.getValueType()) {
            String v = value != null ? value.toString() : "";
            return new SimpleData(parameterType.getTag(), v, parent);
        }
        return null;
    }

    public static DataSet createDataSetFrom(DataSet fromDataSet, List<ConfigurationData> newElements) {
        return new DataSet(fromDataSet, newElements);
    }
}

