/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.context;

import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.data.ObjectData;
import com.freescale.s32ds.cross.core.model.registry.ContextDefinition;
import com.freescale.s32ds.cross.core.model.registry.ContextPart;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;

public abstract class ProjectContext
extends AbstractContext {
    private IProject project;
    private final List<ProjectContext> relatedContexts = new ArrayList<ProjectContext>();

    public ProjectContext(ObjectData rootData, ContextDefinition contextDefinition, List<ContextPart> insertionParts, AbstractContext parent, ModelRegistry registry) {
        super(rootData, contextDefinition, insertionParts, registry, parent);
    }

    @Override
    public List<AbstractContext> getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public AbstractContext getMainChildContext() {
        return null;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public List<ProjectContext> getRelatedContexts() {
        return Collections.unmodifiableList(this.relatedContexts);
    }

    public void addRelatedContext(ProjectContext context) {
        if (!this.relatedContexts.contains(context)) {
            this.relatedContexts.add(context);
        }
    }

    public void removeRelatedContext(ProjectContext context) {
        this.relatedContexts.remove(context);
    }

    public abstract String getProjectBaseName();

    public abstract String getProjectName();

    public abstract String getSuffix();

    public abstract boolean isEnabledByDefault();
}

