/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.context;

import com.freescale.s32ds.cross.core.model.AffectType;
import com.freescale.s32ds.cross.core.model.ContextType;
import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.CProjectSlaveContext;
import com.freescale.s32ds.cross.core.model.context.CoreNatureConfiguration;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureSlaveData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.core.model.registry.ContextDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CProjectMasterContext
extends CProjectContext {
    private final Map<String, CProjectSlaveContext> slaveContexts = new HashMap<String, CProjectSlaveContext>();

    public CProjectMasterContext(CoreNatureConfiguration cConfiguration, ContextType contextType, ProcessorContext parent) {
        super(cConfiguration, parent.getRegistry().getContextDefinition(parent.isExecutable() ? ContextType.PROCESSOR_EXECUTABLE : ContextType.PROCESSOR_LIBRARY), CoreNatureConfiguration.getContextParts(cConfiguration, parent.getProcessor(), parent.isExecutable()), parent);
        List<CoreNatureSlaveData> slaves = cConfiguration.getCoreNature().getSlaves();
        for (CoreNatureSlaveData slave : slaves) {
            if (slave == null || !slave.hasProject() || slave.getTemplates().isEmpty()) continue;
            this.slaveContexts.put(slave.getAlias(), new CProjectSlaveContext(slave, this));
        }
        this.setActive(this.isEnabledByDefault());
    }

    @Override
    public ProcessorData getProcessor() {
        return this.getCoreNature().getProcessor();
    }

    @Override
    public ProcessorContext getProcessorContext() {
        return this.getParent();
    }

    @Override
    public ProcessorContext getParent() {
        return (ProcessorContext)super.getParent();
    }

    @Override
    public CoreNatureData getRootData() {
        return super.getRootData();
    }

    @Override
    public boolean isAffected(String tag) {
        Parameter parameter = this.getParameter(tag);
        return AffectType.isAffected(parameter, Arrays.asList(this.getCoreNature()), this.isExecutable());
    }

    @Override
    public boolean isExecutable() {
        return this.getParent().isExecutable();
    }

    @Override
    public List<ProjectContext> getRelatedContexts() {
        ArrayList<ProjectContext> relCts = new ArrayList<ProjectContext>(super.getRelatedContexts());
        if (this.slaveContexts.isEmpty()) {
            return relCts;
        }
        for (String alias : this.slaveContexts.keySet()) {
            CProjectSlaveContext slaveContext = this.slaveContexts.get(alias);
            String enabledTag = String.valueOf(alias) + "CoProcessorEnable";
            boolean enabled = this.getBooleanValue(enabledTag);
            if (enabled && !relCts.contains(slaveContext)) {
                relCts.add(slaveContext);
                continue;
            }
            if (enabled || !relCts.contains(slaveContext)) continue;
            relCts.remove(slaveContext);
        }
        return relCts;
    }

    @Override
    public CoreNatureData getCoreNature() {
        return this.getRootData();
    }

    @Override
    public String getCoreNatureId() {
        return this.getRootData().getId();
    }

    @Override
    public String getCoreNatureName() {
        return this.getRootData().getName();
    }

    @Override
    public String getSuffix() {
        String suffix = this.getCoreNature().getSuffix();
        return suffix != null && !suffix.isEmpty() ? suffix : this.getCoreNature().getId();
    }

    @Override
    public String getProjectName() {
        if (this.getParent().isMultiple()) {
            return String.valueOf(this.getProjectBaseName()) + "_" + this.getSuffix().trim();
        }
        return this.getProjectBaseName();
    }

    protected static ContextDefinition createContextDefinition(ProcessorContext parent) {
        ContextDefinition processorCD = parent.getContextDefinition();
        ContextDefinition projectCD = new ContextDefinition(parent.isExecutable() ? ContextType.PROCESSOR_EXECUTABLE : ContextType.PROCESSOR_LIBRARY);
        projectCD.setDefaultPart(processorCD.getDefaultPart());
        projectCD.setTerminationPart(processorCD.getTerminationPart());
        return projectCD;
    }
}

