/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core;

import com.freescale.s32ds.cdt.core.ICompilationPathResolver;
import com.freescale.s32ds.cdt.core.IErrorParserManagerDelegate;
import com.freescale.s32ds.cdt.core.IErrorParserProcessor;
import com.freescale.s32ds.cdt.core.IFSLErrorParser3;
import com.freescale.s32ds.cdt.core.OutputLine;
import com.freescale.s32ds.cdt.core.OutputLineQueue;
import com.freescale.s32ds.cdt.core.internal.errorparsers.CompilationPathResolverManager;
import com.freescale.s32ds.cdt.core.internal.errorparsers.ErrorParserDelegateManager;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.IErrorParser2;
import org.eclipse.cdt.core.IErrorParser3;
import org.eclipse.cdt.core.IErrorParserNamed;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.errorparsers.ErrorParserNamedWrapper;
import org.eclipse.cdt.core.language.settings.providers.IWorkingDirectoryTracker;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.internal.core.IErrorMarkeredOutputStream;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class FSLErrorParserManagerExt
extends ErrorParserManager
implements IConsoleParser,
IWorkingDirectoryTracker,
IErrorParserProcessor {
    private int lineCounter = 0;
    private IMarkerGenerator fMarkerGeneratorSuper;
    private ArrayList<ProblemMarkerInfo> fErrors;
    private ArrayList<ProblemMarkerInfo> fPendingErrors;
    private ArrayList<IErrorParser> errorParsers = null;
    private IErrorParserManagerDelegate[] fDelegates;
    private ICompilationPathResolver[] fResolvers;
    private OutputStream outputStreamSuper;
    private IFSLErrorParser3 previousErrorParser = null;
    private ArrayList<String> fErrorMsgLines = new ArrayList();
    private boolean fIsErrorMsgComplete;
    private int nOpens;
    private Vector<URI> fDirectoryStackSuper;
    private boolean hasErrors = false;
    private final StringBuilder currentLine = new StringBuilder();
    private String previousLine;
    private final OutputLineQueue outputLineQueue = new OutputLineQueue();

    public FSLErrorParserManagerExt(ACBuilder builder) {
        this(builder.getProject(), (IMarkerGenerator)builder);
    }

    public FSLErrorParserManagerExt(IProject project, IMarkerGenerator markerGenerator) {
        this(project, markerGenerator, null);
    }

    public FSLErrorParserManagerExt(IProject project, IMarkerGenerator markerGenerator, String[] parsersIDs) {
        this(project, (URI)null, markerGenerator, parsersIDs);
    }

    @Deprecated
    public FSLErrorParserManagerExt(IProject project, IPath workingDirectory, IMarkerGenerator markerGenerator, String[] parsersIDs) {
        this(project, workingDirectory == null || workingDirectory.isEmpty() ? null : URIUtil.toURI((IPath)workingDirectory), markerGenerator, parsersIDs);
    }

    public FSLErrorParserManagerExt(IProject project, URI baseDirectoryURI, IMarkerGenerator markerGenerator, String[] parsersIDs) {
        super(project, FSLErrorParserManagerExt.findBaseDirectoryURI(baseDirectoryURI, project), markerGenerator, parsersIDs);
        this.fErrors = new ArrayList();
        this.fPendingErrors = new ArrayList();
        this.fResolvers = CompilationPathResolverManager.getResolvers();
        IErrorParserManagerDelegate[] iErrorParserManagerDelegateArray = this.fDelegates = ErrorParserDelegateManager.getDelegates();
        int n = this.fDelegates.length;
        int n2 = 0;
        while (n2 < n) {
            IErrorParserManagerDelegate delegate = iErrorParserManagerDelegateArray[n2];
            delegate.initialize(this);
            ++n2;
        }
    }

    @Override
    public Collection<IErrorParser> getErrorParsers() {
        if (this.errorParsers == null) {
            this.errorParsers = new ArrayList();
            try {
                Map parsersMap = (Map)this.getSuperField("fErrorParsers");
                for (IErrorParser[] ps : parsersMap.values()) {
                    this.errorParsers.addAll(Arrays.asList(ps));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.errorParsers;
    }

    public void pushDirectory(IPath dir) {
        if (dir != null) {
            URI uri;
            URI workingDirectoryURI = this.getWorkingDirectoryURI();
            if (!dir.isAbsolute()) {
                uri = org.eclipse.core.runtime.URIUtil.append((URI)workingDirectoryURI, (String)dir.toString());
            } else {
                uri = this.toURI(dir);
                if (uri == null) {
                    return;
                }
            }
            this.pushDirectoryURI(uri);
        }
    }

    public IMarkerGenerator getMarkerGenerator() {
        if (this.fMarkerGeneratorSuper == null) {
            this.fMarkerGeneratorSuper = (IMarkerGenerator)this.getSuperField("fMarkerGenerator");
        }
        return this.fMarkerGeneratorSuper;
    }

    protected OutputStream getOutputStreamSuper() {
        if (this.outputStreamSuper == null) {
            this.outputStreamSuper = (OutputStream)this.getSuperField("outputStream");
        }
        return this.outputStreamSuper;
    }

    public void setOutputStream(OutputStream os) {
        this.outputStreamSuper = os;
        super.setOutputStream(os);
    }

    public boolean processLine(String line) {
        this.registerOutputLine(line);
        IErrorParserManagerDelegate[] iErrorParserManagerDelegateArray = this.fDelegates;
        int n = this.fDelegates.length;
        int n2 = 0;
        while (n2 < n) {
            IErrorParserManagerDelegate delegate = iErrorParserManagerDelegateArray[n2];
            if (delegate.processLine(line, this)) {
                return true;
            }
            ++n2;
        }
        return this.processErrorParsers(line, this.getErrorParsers());
    }

    public void registerOutputLine(String line) {
        this.registerOutputLine(line, false);
    }

    public void registerOutputLine(String line, boolean duplicated) {
        this.outputLineQueue.add(new OutputLine(line, duplicated));
    }

    @Override
    public boolean processErrorParsers(String line, Collection<IErrorParser> parsers) {
        String lineTrimmed = line.trim();
        ++this.lineCounter;
        ProblemMarkerInfo marker = null;
        Iterator<IErrorParser> iterator = parsers.iterator();
        while (iterator.hasNext()) {
            IErrorParser parser;
            IErrorParser curr = parser = iterator.next();
            if (parser instanceof ErrorParserNamedWrapper) {
                curr = ((ErrorParserNamedWrapper)parser).getErrorParser();
            }
            int types = 0;
            if (curr instanceof IErrorParser2) {
                types = ((IErrorParser2)curr).getProcessLineBehaviour();
            }
            if ((types & 4) == 0 && lineTrimmed.length() > 1000) continue;
            String lineToParse = lineTrimmed;
            if ((types & 1) != 0) {
                lineToParse = line;
            } else {
                this.outputLineQueue.registerAlias(line, lineTrimmed);
            }
            boolean consume = false;
            try {
                try {
                    consume = curr.processLine(lineToParse, (ErrorParserManager)this);
                }
                catch (Exception e) {
                    String id = "";
                    if (parser instanceof IErrorParserNamed) {
                        id = ((IErrorParserNamed)parser).getId();
                    }
                    String message = "Errorparser " + id + " failed parsing line [" + lineToParse + "]";
                    CCorePlugin.log((String)message, (Throwable)e);
                }
                if (consume) {
                    if (this.previousErrorParser != null && this.previousErrorParser != curr) {
                        ArrayList<ProblemMarkerInfo> temporaryErrors = this.fPendingErrors;
                        this.fPendingErrors = new ArrayList();
                        this.previousErrorParser.flush(this);
                        this.fPendingErrors.addAll(temporaryErrors);
                    }
                    this.previousErrorParser = curr instanceof IFSLErrorParser3 ? (IFSLErrorParser3)curr : null;
                    this.flushPendingErrors();
                    break;
                }
                this.flushPendingErrors();
            }
            finally {
                if (this.fErrors.size() > 0) {
                    if (marker == null) {
                        marker = this.fErrors.get(this.fErrors.size() - 1);
                    }
                    this.fErrors.clear();
                }
            }
        }
        if (parsers.isEmpty()) {
            this.flushPendingErrors();
        }
        if (this.fErrorMsgLines.isEmpty()) {
            this.outputLine(line, marker);
        } else {
            this.outputPendingErrorMessages(marker);
        }
        return false;
    }

    private void outputLine(String line, ProblemMarkerInfo marker) {
        this.outputLineQueue.setDone(line, marker);
        this.outputDoneLines();
    }

    private void outputDoneLines() {
        OutputLine line;
        while ((line = this.outputLineQueue.pollDone()) != null) {
            this.outputALine(line.getLine(), line.getInfo());
        }
    }

    private void outputALine(String line, ProblemMarkerInfo marker) {
        String l = String.valueOf(line) + "\n";
        OutputStream outputStream = this.getOutputStreamSuper();
        if (outputStream == null) {
            return;
        }
        try {
            if (marker != null && outputStream instanceof IErrorMarkeredOutputStream) {
                IErrorMarkeredOutputStream s = (IErrorMarkeredOutputStream)outputStream;
                s.write(l, marker);
            } else {
                byte[] b = l.getBytes();
                outputStream.write(b, 0, b.length);
            }
        }
        catch (IOException e) {
            CCorePlugin.log((Throwable)e);
        }
    }

    public void addErrorMsgLine(String line) {
        this.fErrorMsgLines.add(line);
    }

    public void setErrorMsgComplete(boolean isComplete) {
        this.fIsErrorMsgComplete = isComplete;
    }

    public int getLineCounter() {
        return this.lineCounter;
    }

    protected IFile findFileInWorkspace(IPath path) {
        URI uri;
        if (!path.isAbsolute()) {
            URI workingDirectoryURI = this.getWorkingDirectoryURI();
            uri = EFSExtensionManager.getDefault().append(workingDirectoryURI, path.toString());
        } else {
            uri = this.toURI(path);
            if (uri == null) {
                return null;
            }
        }
        return this.findFileInWorkspace(uri);
    }

    protected IFile findFileInWorkspace(URI uri) {
        IFile f;
        if (!uri.isAbsolute()) {
            uri = org.eclipse.core.runtime.URIUtil.makeAbsolute((URI)uri, (URI)this.getWorkingDirectoryURI());
        }
        if ((f = ResourceLookup.selectFileForLocationURI((URI)uri, (IProject)this.getProject())) != null && f.isAccessible()) {
            return f;
        }
        return null;
    }

    private void outputPendingErrorMessages(ProblemMarkerInfo marker) {
        if (this.fIsErrorMsgComplete) {
            this.fErrorMsgLines.iterator().forEachRemaining(line -> this.outputLine((String)line, marker));
            this.fErrorMsgLines.clear();
            this.fIsErrorMsgComplete = false;
        }
    }

    public void generateExternalMarker(IResource file, int lineNumber, String desc, int severity, String varName, IPath externalPath) {
        if (file == null) {
            file = this.getProject();
        }
        if (externalPath != null && !externalPath.toFile().exists()) {
            ICompilationPathResolver[] iCompilationPathResolverArray = this.fResolvers;
            int n = this.fResolvers.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationPathResolver resolver = iCompilationPathResolverArray[n2];
                IPath path = resolver.resolve(externalPath, this.getProject());
                if (path != null && path.toFile().exists()) {
                    externalPath = path;
                    break;
                }
                ++n2;
            }
        }
        ProblemMarkerInfo problemMarkerInfo = new ProblemMarkerInfo(file, lineNumber, desc, severity, varName, externalPath);
        this.outputPendingErrorMessages(problemMarkerInfo);
        this.fPendingErrors.add(problemMarkerInfo);
    }

    public void addProblemMarker(ProblemMarkerInfo problemMarkerInfo) {
        this.fPendingErrors.add(problemMarkerInfo);
    }

    public void flushPendingErrors() {
        int i = 0;
        while (i < this.fPendingErrors.size()) {
            ProblemMarkerInfo problemMarkerInfo = this.fPendingErrors.get(i);
            this.fErrors.add(problemMarkerInfo);
            this.getMarkerGenerator().addMarker(problemMarkerInfo);
            if (problemMarkerInfo.severity == 2) {
                this.hasErrors = true;
            }
            if (this.fErrorMsgLines.size() > 0) {
                this.outputLine(this.fErrorMsgLines.remove(0), problemMarkerInfo);
            }
            ++i;
        }
        this.fPendingErrors.clear();
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public synchronized void close() throws IOException {
        if (this.previousErrorParser != null) {
            this.previousErrorParser.flush(this);
            this.previousErrorParser = null;
        }
        this.flushPendingErrors();
        if (this.nOpens > 0 && --this.nOpens == 0) {
            this.checkLine(true);
            this.getDirectoryStack().removeAllElements();
        }
        this.outputLineQueue.setAllDone();
        this.outputDoneLines();
    }

    private Vector<URI> getDirectoryStack() {
        if (this.fDirectoryStackSuper == null) {
            this.fDirectoryStackSuper = (Vector)this.getSuperField("fDirectoryStack");
        }
        return this.fDirectoryStackSuper;
    }

    public synchronized void write(int b) throws IOException {
        this.currentLine.append((char)b);
        this.checkLine(false);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off != 0 || len < 0 || len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.currentLine.append(new String(b, 0, len));
        this.checkLine(false);
    }

    private void checkLine(boolean flush) {
        String buffer = this.currentLine.toString();
        int i = 0;
        while ((i = buffer.indexOf(10)) != -1) {
            String line = buffer.substring(0, i);
            if (line.endsWith("\r")) {
                line = line.substring(0, line.length() - 1);
            }
            if (!line.equals(this.previousLine)) {
                this.processLine(line);
            } else {
                this.registerOutputLine(line, true);
                this.outputLine(line, null);
            }
            this.previousLine = line;
            buffer = buffer.substring(i + 1);
        }
        this.currentLine.setLength(0);
        if (flush) {
            if (buffer.length() > 0) {
                this.processLine(buffer);
                this.previousLine = buffer;
            }
        } else {
            this.currentLine.append(buffer);
        }
    }

    private URI toURI(IPath path) {
        URI baseURI = this.getWorkingDirectoryURI();
        String uriString = path.toString();
        if (path.isAbsolute() && uriString.charAt(0) != '/') {
            uriString = String.valueOf('/') + uriString;
        }
        return EFSExtensionManager.getDefault().createNewURIFromPath(baseURI, uriString);
    }

    public void shutdown() {
        this.getErrorParsers().stream().filter(IFSLErrorParser3.class::isInstance).map(IFSLErrorParser3.class::cast).forEach(IErrorParser3::shutdown);
    }

    public IErrorParser getPreviousErrorParser() {
        return this.previousErrorParser;
    }

    public void resetPreviousErrorParser() {
        this.previousErrorParser = null;
    }

    public static URI findBaseDirectoryURI(URI baseDirectoryURI, IProject project) {
        if (baseDirectoryURI != null) {
            return baseDirectoryURI;
        }
        if (project != null) {
            return project.getLocationURI();
        }
        return URIUtil.toURI((String)System.getProperty("user.dir"));
    }

    protected Object getSuperField(String superFieldName) {
        try {
            Field field = ErrorParserManager.class.getDeclaredField(superFieldName);
            field.setAccessible(true);
            Object obj = field.get(this);
            field.setAccessible(false);
            return obj;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

