/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resources;

import com.nxp.s32ds.ext.ide.internal.resources.ResourcesMessages;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ProjectDirectoryFileSystemValidator
implements IValidator {
    private static final ProjectDirectoryFileSystemValidator INSTANCE = new ProjectDirectoryFileSystemValidator();

    public static ProjectDirectoryFileSystemValidator getInstance() {
        return INSTANCE;
    }

    public IStatus validate(Object path) {
        if (path instanceof String) {
            Path fullPath = Paths.get((String)path, new String[0]);
            if (Files.exists(fullPath, new LinkOption[0])) {
                String message = NLS.bind((String)ResourcesMessages.ProjectNameValidator_e_name_already_exists, (Object)fullPath.toString());
                return new Status(4, "com.nxp.s32ds.ext.ide.resources", message);
            }
            return Status.OK_STATUS;
        }
        return new Status(4, "com.nxp.s32ds.ext.ide.resources", ResourcesMessages.ProjectPathValidator_invalid_path);
    }
}

