package com.freescale.s32ds.cross.sdk.s32k116_1_8_7.pexconf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class APExConfig116Adjuster {
    private static final String[] sourceFolders = new String[] { "SDK", "Generated_Code", "Sources" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

    protected IProject project;

    protected APExConfig116Adjuster(IProject project) {
        this.project = project;
    }

    void adjustPExConfiguration() {
        try {
            createSourceEntries();
            adjustOptions();
            cleanupFolders();
            excludeResources();
        } catch (Exception e) {
            Activator.log(e);
        }
    }

    protected void createSourceEntries() throws CoreException {
        Set<ICSourceEntry> additionalSourceEntrires = new HashSet<>();
        for (String sourceFolder : sourceFolders) {
            additionalSourceEntrires.add(new CSourceEntry(project.getFolder(sourceFolder), null, 0));
        }
        ICProjectDescription description = CCorePlugin.getDefault().getProjectDescription(project);
        for (ICConfigurationDescription config : description.getConfigurations()) {
            Set<ICSourceEntry> sourceEntries = new HashSet<>(Arrays.asList(config.getSourceEntries()));
            sourceEntries.addAll(additionalSourceEntrires);
            config.setSourceEntries(sourceEntries.toArray(new ICSourceEntry[sourceEntries.size()]));
        }
        CCorePlugin.getDefault().setProjectDescription(project, description, false, new NullProgressMonitor());
    }

    protected abstract void adjustOptions() throws BuildException;

    protected abstract void cleanupFolders() throws CoreException;

    protected void excludeResources() throws CoreException {
        IFolder linkedFilesFolder = project.getFolder("Project_Settings/Linker_Files"); //$NON-NLS-1$
        IConfiguration[] configs = ManagedBuildManager.getBuildInfo(project).getManagedProject().getConfigurations();
        for (IConfiguration config : configs) {
            IResourceConfiguration resourceConfig = config.getResourceConfiguration(linkedFilesFolder.getFullPath()
                    .toString());
            if (resourceConfig == null) {
                resourceConfig = config.createFileInfo(linkedFilesFolder.getFullPath().removeFirstSegments(1));
            }
            if (resourceConfig != null) {
                resourceConfig.setExclude(true);
            }
        }
    }

    protected void addOptionValue(IOption opt, String value) throws BuildException {
        if (opt == null) {
            return;
        }
        List<String> curValueList = new ArrayList<>(Arrays.asList(opt.getBasicStringListValue()));
        curValueList.add("\"${ProjDirPath}/" + value + "\""); //$NON-NLS-1$ //$NON-NLS-2$
        opt.setValue(curValueList);
    }

}
