package com.nxp.s32ds.cross.sdk.s32k1xx_2_9_0.pexconf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;

class PExConfigk142Adjuster extends APExConfigk1xxAdjuster {

	PExConfigk142Adjuster(IProject project) {
		super(project);
	}

	protected void adjustOptions() throws BuildException {
		IConfiguration[] configs = ManagedBuildManager.getBuildInfo(project).getManagedProject().getConfigurations();
		for (IConfiguration config : configs) {
			ITool[] tools = config.getTools();
			for (ITool tool : tools) {
				String toolBaseId = tool.getBaseId();
				IOption option = null;
				// GCC
				if (toolBaseId.equals("com.nxp.s32ds.cle.arm.mbs.arm32.bare.tool.c.compiler")) { //$NON-NLS-1$
					option = tool.getOptionBySuperClassId("gnu.c.compiler.option.include.paths"); //$NON-NLS-1$
					addOptionValue(option, "Generated_Code"); //$NON-NLS-1$
					addOptionValue(option, "Sources"); //$NON-NLS-1$
				}
								if (toolBaseId.equals("com.nxp.s32ds.cle.arm.mbs.arm32.bare.tool.cpp.compiler")) { //$NON-NLS-1$
					option = tool.getOptionBySuperClassId("gnu.cpp.compiler.option.include.paths"); //$NON-NLS-1$
					addOptionValue(option, "Generated_Code"); //$NON-NLS-1$
					addOptionValue(option, "Sources"); //$NON-NLS-1$
				}
				if (toolBaseId.equals("com.nxp.s32ds.cle.arm.mbs.arm32.bare.tool.assembler")) { //$NON-NLS-1$
					option = tool.getOptionBySuperClassId("gnu.both.asm.option.include.paths"); //$NON-NLS-1$
					addOptionValue(option, "Generated_Code"); //$NON-NLS-1$
					addOptionValue(option, "Sources"); //$NON-NLS-1$
				}
				option = null;
				if (toolBaseId.equals("com.nxp.s32ds.cle.arm.mbs.arm32.bare.tool.c.linker")) { //$NON-NLS-1$
					option = tool.getOptionBySuperClassId(
							"com.freescale.s32ds.cross.gnu.tool.c.linker.option.scriptfile"); //$NON-NLS-1$
				}
				if (toolBaseId.equals("com.nxp.s32ds.cle.arm.mbs.arm32.bare.tool.cpp.linker")) { //$NON-NLS-1$
					option = tool.getOptionBySuperClassId(
							"com.freescale.s32ds.cross.gnu.tool.cpp.linker.option.scriptfile"); //$NON-NLS-1$
				}
				if (option != null) {
					List<String> values = new ArrayList<>(Arrays.asList(option.getBasicStringListValue()));
					values.clear();
					if (config.getName().equals("Debug_RAM")) { //$NON-NLS-1$
						values.add("\"${ProjDirPath}/Project_Settings/Linker_Files/S32K142_32_ram.ld\""); //$NON-NLS-1$
					} else {
						values.add("\"${ProjDirPath}/Project_Settings/Linker_Files/S32K142_32_flash.ld\""); //$NON-NLS-1$
					}
					option.setValue(values);
				}
				// GHS
				if (toolBaseId.equals("ghs.managedmake.arm.executable.debug.toolchain.cc_compiler")) { //$NON-NLS-1$
					option = tool.getOptionBySuperClassId(
							"ghs.managedmake.arm.executable.toolchain.cc_compiler.project.include_directories"); //$NON-NLS-1$
					addOptionValue(option, "Generated_Code"); //$NON-NLS-1$
					addOptionValue(option, "Sources"); //$NON-NLS-1$
				}
				if (toolBaseId.equals("ghs.managedmake.arm.executable.debug.toolchain.cc_linker")) { //$NON-NLS-1$
					option = tool.getOptionBySuperClassId(
							"ghs.managedmake.arm.executable.toolchain.cc_linker.linker_options.linker_directives_directory"); //$NON-NLS-1$
					if (config.getName().equals("Debug_RAM")) { //$NON-NLS-1$
						option.setValue("\"${ProjDirPath}/Project_Settings/Linker_Files/RAM\""); //$NON-NLS-1$
					} else {
						option.setValue("\"${ProjDirPath}/Project_Settings/Linker_Files/Flash\""); //$NON-NLS-1$
					}
				}
				// IAR
				if (toolBaseId.startsWith("iar.arm.toolchain.compiler")) { //$NON-NLS-1$
					for (IOption opt : tool.getOptions()) {
						if (opt.getBaseId().startsWith("iar.arm.toolchain.compiler.option.incPaths")) { //$NON-NLS-1$
							addOptionValue(opt, "Generated_Code"); //$NON-NLS-1$
							addOptionValue(opt, "Sources"); //$NON-NLS-1$
							break;
						}
					}
				}
				if (toolBaseId.startsWith("iar.arm.toolchain.linker")) { //$NON-NLS-1$
					for (IOption opt : tool.getOptions()) {
						if (opt.getBaseId().startsWith("iar.arm.toolchain.linker.option.icfFile")) { //$NON-NLS-1$
							if (config.getName().equals("Debug_RAM")) { //$NON-NLS-1$
								opt.setValue("\"${ProjDirPath}/Project_Settings/Linker_Files/S32K142_32_ram.icf\""); //$NON-NLS-1$
							} else {
								opt.setValue("\"${ProjDirPath}/Project_Settings/Linker_Files/S32K142_32_flash.icf\""); //$NON-NLS-1$
							}
						}
					}
				}
			}
		}
	}

	protected void cleanupFolders() throws CoreException {
		IFolder f1 = project.getFolder("Project_Settings/Linker_Files"); //$NON-NLS-1$
		if (f1.exists() && !f1.isLinked()) {
			for (IResource fx : f1.members()) {
				if (fx instanceof IFile) {
					IPath fullPath = fx.getFullPath();
					if (fullPath.segmentCount() > 0) {
						String lastSegment = fullPath.lastSegment();
						if (!lastSegment.equals("S32K142_32_flash.ld") //$NON-NLS-1$
								&& !lastSegment.equals("S32K142_32_ram.ld") //$NON-NLS-1$
								&& !lastSegment.equals("S32K142_32_flash.icf") //$NON-NLS-1$
								&& !lastSegment.equals("S32K142_32_ram.icf") //$NON-NLS-1$
								&& !lastSegment.equals("default.ld")) { //$NON-NLS-1$
							fx.delete(true, new NullProgressMonitor());
						}
					}
				}
			}
		}
		IFolder f2 = project.getFolder("Project_Settings/Startup_Code"); //$NON-NLS-1$
		if (f2.exists() && !f2.isLinked()) {
			for (IResource fx : f2.members()) {
				IPath fullPath = fx.getFullPath();
				if (fullPath.segmentCount() > 0) {
					String lastSegment = fullPath.lastSegment();
					if (!lastSegment.equals("startup_S32K142.S") //$NON-NLS-1$
							&& !lastSegment.equals("startup_S32K142.s")) { //$NON-NLS-1$
						fx.delete(true, new NullProgressMonitor());
					}
				}
			}
		}
		IFolder f3 = project.getFolder("src"); //$NON-NLS-1$
		if (f3.exists() && !f3.isLinked()) {
			f3.delete(true, new NullProgressMonitor());
		}

		IFolder f4 = project.getFolder("include"); //$NON-NLS-1$
		if (f4.exists() && !f4.isLinked()) {
			for (IResource fx : f4.members()) {
				fx.delete(true, new NullProgressMonitor());
			}
		}
	}
}
