/*========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/
ENTRY(Reset_Handler)

/*
To use "new" operator with EWL in C++ project the following symbol shall be defined
*/
/*EXTERN(_ZN10__cxxabiv119__terminate_handlerE)*/

STACK_SIZE = DEFINED(__stack_size__) ? __stack_size__ : 0x2000;
HEAP_SIZE  = DEFINED(__heap_size__)  ? __heap_size__  : 0x2000;

MEMORY {
    FLASH_A5            : ORIGIN = 0x19008000,              LENGTH = 0x8000
    SRAM                : ORIGIN = 0x3EF00000,              LENGTH = 0x100000
}
   
SECTIONS
{
    
    .startup_a5            : 
	{
	    KEEP (*(.startup_a5))
	}  > FLASH_A5
    
    /* Interrupt vectors area */
    .intvec            : 
	{
	    A5_1_VECTOR_TABLE = .;
		A5_1_VECTOR_RAM = .;
	    *(.vt*)
		A5_1_VECTOR_SIZE = .;
	}  > FLASH_A5
    
    .text :
    {
      . = ALIGN(4);
      *(.text)                 /* .text sections (code) */
      *(.text*)                /* .text* sections (code) */
      *(.rodata)               /* .rodata sections (constants, strings, etc.) */
      *(.rodata*)              /* .rodata* sections (constants, strings, etc.) */
      *(.glue_7)               /* glue arm to thumb code */
      *(.glue_7t)              /* glue thumb to arm code */
      *(.eh_frame)
      KEEP (*(.init))
      KEEP (*(.fini))
      . = ALIGN(4);
    } > FLASH_A5
    
	.ARM.extab        ALIGN(4)             : 
    {
     *(.ARM.extab*)
    } > FLASH_A5
	.ARM.exidx  	  ALIGN(0)             : 
	{
		__exidx_start = .;
		*(.ARM.exidx*)
		__exidx_end = .;
	} > FLASH_A5

    .ctors :
    {
    __CTOR_LIST__ = .;
    /* gcc uses crtbegin.o to find the start of
       the constructors, so we make sure it is
       first.  Because this is a wildcard, it
       doesn't matter if the user does not
       actually link against crtbegin.o; the
       linker won't look for a file to match a
       wildcard.  The wildcard also means that it
       doesn't matter which directory crtbegin.o
       is in.  */
    KEEP (*crtbegin.o(.ctors))
    KEEP (*crtbegin?.o(.ctors))
    /* We don't want to include the .ctor section from
       from the crtend.o file until after the sorted ctors.
       The .ctor section from the crtend file contains the
       end of ctors marker and it must be last */
    KEEP (*(EXCLUDE_FILE(*crtend?.o *crtend.o) .ctors))
    KEEP (*(SORT(.ctors.*)))
    KEEP (*(.ctors))
    __CTOR_END__ = .;
    } > FLASH_A5

    .dtors :
    {
      __DTOR_LIST__ = .;
      KEEP (*crtbegin.o(.dtors))
      KEEP (*crtbegin?.o(.dtors))
      KEEP (*(EXCLUDE_FILE(*crtend?.o *crtend.o) .dtors))
      KEEP (*(SORT(.dtors.*)))
      KEEP (*(.dtors))
      __DTOR_END__ = .;
    } > FLASH_A5
  
    .preinit_array :
    {
      PROVIDE_HIDDEN (__preinit_array_start = .);
      KEEP (*(.preinit_array*))
      PROVIDE_HIDDEN (__preinit_array_end = .);
    } > FLASH_A5
  
    .init_array :
    {
      PROVIDE_HIDDEN (__init_array_start = .);
      KEEP (*(SORT(.init_array.*)))
      KEEP (*(.init_array*))
      PROVIDE_HIDDEN (__init_array_end = .);
    } > FLASH_A5
  
    .fini_array :
    {
      PROVIDE_HIDDEN (__fini_array_start = .);
      KEEP (*(SORT(.fini_array.*)))
      KEEP (*(.fini_array*))
      PROVIDE_HIDDEN (__fini_array_end = .);
    } > FLASH_A5

    __DATA_ROM = .; /* Symbol is used by startup for data initialization */

	.data  :   AT(__DATA_ROM)
	{
        . = ALIGN(4);
   		 __DATA_RAM = .;
  		  __data_start__ = .;      /* create a global symbol at data start */
	    *(.data*)
         KEEP(*(.jcr*))
        . = ALIGN(4);
		__DATA_END = .;
		__data_end__ = .;        /* define a global symbol at data end */
	} > SRAM
	
	__DATA_END = __DATA_ROM + (__data_end__ - __data_start__);
	
	.bss ALIGN(4) :
    {
        __bss_start__ = .;
        *(.bss*)       /* Zero-filled run time allocate data memory */
        *(COMMON)        
        __bss_end__ = .;
    } > SRAM
   
  	/* stack and heap shall be located in the same memory region */
	.heap : 
    {
        . = ALIGN(4);
        __end__ = .;
        PROVIDE(_end = .);
    	PROVIDE(end = .);
    	. += HEAP_SIZE;
    }  > SRAM   

    .stack  :
    {
        . = ALIGN(4);
         _stack_s = .;
        . += STACK_SIZE;
        __StackTop = .;
    } > SRAM

    
    PROVIDE(__stack = __StackTop);
    
	/* Labels required by EWL */
    __START_BSS = __bss_start__;
    __END_BSS = __bss_end__;
    __SP_INIT = __StackTop;  
    
}