/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.arm.mbs.common;

import com.freescale.s32ds.cdt.core.EclipseUtils;
import com.freescale.s32ds.cross.gnu.Activator;
import com.nxp.s32ds.cle.arm.mbs.common.option.core.ToolChainOption;
import com.nxp.s32ds.cle.arm.mbs.common.option.core.ToolChainOptionApplicability;
import com.nxp.s32ds.cle.arm.mbs.common.option.core.ToolChainOptionValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedOptionValueHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class SetDependencyOptions
extends ManagedOptionValueHandler {
    public static final String OPTION_C_INCLUDE_PATH = "gnu.c.compiler.option.include.paths";
    public static final String OPTION_CPP_INCLUDE_PATH = "gnu.cpp.compiler.option.include.paths";
    public static final String OPTION_ASM_INCLUDE_PATH = "gnu.both.asm.option.include.paths";

    public boolean handleValue(IBuildObject configuration, IHoldsOptions holder, IOption option, String extraArgument, int event) {
        if (extraArgument.isEmpty()) {
            return false;
        }
        String ARM_TOOLCHAIN = extraArgument;
        String C_COMPILER_TOOL = String.valueOf(ARM_TOOLCHAIN) + ".tool.c.compiler";
        String CPP_COMPILER_TOOL = String.valueOf(ARM_TOOLCHAIN) + ".tool.cpp.compiler";
        String ASSEMBLER_TOOL = String.valueOf(ARM_TOOLCHAIN) + ".tool.assembler";
        String C_LINKER_TOOL = String.valueOf(ARM_TOOLCHAIN) + ".tool.c.linker";
        String CPP_LINKER_TOOL = String.valueOf(ARM_TOOLCHAIN) + ".tool.cpp.linker";
        if (event == 4 || event == 3) {
            Object objValue;
            IOption srcOption;
            String baseId;
            IToolChain toolChain;
            IProject selectProject;
            ITool[] tools;
            IConfiguration config;
            block30: {
                config = null;
                tools = null;
                selectProject = null;
                if (configuration instanceof IConfiguration) {
                    config = (IConfiguration)configuration;
                    tools = config.getTools();
                } else if (configuration instanceof IFolderInfo) {
                    IFolderInfo oFolderInfo = (IFolderInfo)configuration;
                    config = oFolderInfo.getParent();
                    tools = oFolderInfo.getTools();
                    selectProject = EclipseUtils.getSelectedProject();
                    if (selectProject == null) {
                        return false;
                    }
                }
                if (config == null) {
                    return false;
                }
                toolChain = config.getToolChain();
                baseId = option.getBaseId();
                srcOption = toolChain.getOptionBySuperClassId(baseId);
                objValue = null;
                switch (srcOption.getBasicValueType()) {
                    case 0: {
                        objValue = new Boolean(srcOption.getBooleanValue());
                        break;
                    }
                    case 2: {
                        objValue = srcOption.getStringValue();
                        break;
                    }
                    case 1: {
                        objValue = srcOption.getStringValue();
                    }
                }
                if (objValue != null) break block30;
                return false;
            }
            try {
                String optionName = baseId.substring(ARM_TOOLCHAIN.length() + ".option.target".length(), baseId.length());
                if (objValue instanceof String) {
                    String strValue = (String)objValue;
                    if (!strValue.isEmpty() && srcOption.getBasicValueType() == 1 && strValue.length() > baseId.length()) {
                        objValue = strValue.substring(baseId.length(), strValue.length());
                    }
                } else if (objValue instanceof Boolean) {
                    objValue = (Boolean)objValue;
                }
                ToolChainOptionValidator validator = ToolChainOptionValidator.getInstance();
                ITool[] iToolArray = tools;
                int n = tools.length;
                int n2 = 0;
                while (n2 < n) {
                    ITool tool = iToolArray[n2];
                    String toolName = tool.getBaseId();
                    if (toolName.startsWith(C_COMPILER_TOOL) || toolName.startsWith(CPP_COMPILER_TOOL) || toolName.startsWith(ASSEMBLER_TOOL) || toolName.startsWith(C_LINKER_TOOL) || toolName.startsWith(CPP_LINKER_TOOL)) {
                        SetDependencyOptions.setOption(config, objValue, tool, toolName, optionName);
                    }
                    if (configuration instanceof IFolderInfo) {
                        IOption includeOption = null;
                        String natureProject = "org.eclipse.cdt.core.cnature";
                        if (selectProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                            natureProject = "org.eclipse.cdt.core.ccnature";
                        }
                        if (toolName.startsWith(CPP_COMPILER_TOOL)) {
                            includeOption = tool.getOptionBySuperClassId(OPTION_CPP_INCLUDE_PATH);
                        } else if (toolName.startsWith(C_COMPILER_TOOL)) {
                            includeOption = tool.getOptionBySuperClassId(OPTION_C_INCLUDE_PATH);
                        } else if (toolName.startsWith(ASSEMBLER_TOOL)) {
                            includeOption = tool.getOptionBySuperClassId(OPTION_ASM_INCLUDE_PATH);
                        }
                        if (includeOption != null) {
                            List<Object> includes = new ArrayList();
                            includes = natureProject.equals("org.eclipse.cdt.core.ccnature") ? validator.getEWLCPPIncludes() : validator.getEWLCIncludes();
                            this.checkSysRootOptionValue(config, toolChain, tool, includeOption, includes, baseId, objValue);
                        }
                    }
                    ++n2;
                }
                return true;
            }
            catch (BuildException e) {
                Activator.logWarning((String)("handleValue " + e.getMessage()));
            }
            catch (CoreException e) {
                Activator.log((IStatus)e.getStatus());
            }
        }
        return false;
    }

    private void checkSysRootOptionValue(IConfiguration config, IToolChain toolChain, ITool tool, IOption includeOption, Collection<String> includes, String baseId, Object objValue) throws BuildException {
        ToolChainOptionValidator validator = ToolChainOptionValidator.getInstance();
        for (ToolChainOptionApplicability rule : validator.getSpecificRules()) {
            ToolChainOption applyOption = rule.getApplicWithOption();
            if (!applyOption.getOptBaseId().equals(baseId)) continue;
            String value = SetDependencyOptions.transformValue(objValue);
            if (!applyOption.getOptionValue().equals(value)) continue;
            ToolChainOption ruleOption = rule.getOption();
            IOption sysOption = toolChain.getOptionBySuperClassId(ruleOption.getOptBaseId());
            sysOption.setValue(ruleOption.getOptionValue());
            try {
                this.switchIncludes(config, tool, includeOption, includes, applyOption.isApplyParams());
            }
            catch (CoreException e) {
                Activator.log((IStatus)e.getStatus());
            }
            break;
        }
    }

    private void switchIncludes(IConfiguration config, ITool tool, IOption includeOption, Collection<String> extIncludes, boolean isApply) throws CoreException, BuildException {
        if (extIncludes.isEmpty()) {
            return;
        }
        if (includeOption != null) {
            String[] includes = includeOption.getBasicStringListValue();
            if (isApply) {
                String[] result = this.splitValues(extIncludes, includes);
                config.setOption((IHoldsOptions)tool, includeOption, result);
            } else {
                String[] result = this.unSplitValues(extIncludes, includes);
                config.setOption((IHoldsOptions)tool, includeOption, result);
            }
        }
    }

    private String[] splitValues(Collection<String> addedIncl, String[] currentIncl) {
        ArrayList<String> resultInclLst = new ArrayList<String>();
        List<String> currentIncLst = Arrays.asList(currentIncl);
        for (String incl : addedIncl) {
            if (currentIncLst.contains(incl)) continue;
            resultInclLst.add(incl);
        }
        resultInclLst.addAll(currentIncLst);
        return resultInclLst.toArray(new String[resultInclLst.size()]);
    }

    private String[] unSplitValues(Collection<String> rmvIncl, String[] currentIncl) {
        ArrayList resultInclLst = new ArrayList();
        ArrayList<String> currentIncLst = new ArrayList<String>();
        currentIncLst.addAll(Arrays.asList(currentIncl));
        for (String incl : rmvIncl) {
            if (!currentIncLst.contains(incl)) continue;
            currentIncLst.remove(incl);
        }
        resultInclLst.addAll(currentIncLst);
        return resultInclLst.toArray(new String[resultInclLst.size()]);
    }

    private static String transformValue(Object objValue) {
        String value = "";
        if (objValue instanceof String) {
            value = (String)objValue;
            value = value.substring(1);
        }
        return value;
    }

    public static void setOption(IConfiguration config, Object objValue, ITool tool, String dstOptionId, String optionName) throws BuildException {
        StringBuilder dstOptionValueId = new StringBuilder(dstOptionId);
        dstOptionValueId.append(".option.target" + optionName);
        IOption dstOption = tool.getOptionBySuperClassId(dstOptionValueId.toString());
        String sourceValue = "";
        if (dstOption == null) {
            return;
        }
        switch (dstOption.getBasicValueType()) {
            case 0: {
                boolean boolValue = (Boolean)objValue;
                config.setOption((IHoldsOptions)tool, dstOption, boolValue);
                break;
            }
            case 2: {
                sourceValue = (String)objValue;
                config.setOption((IHoldsOptions)tool, dstOption, sourceValue);
                break;
            }
            case 1: {
                sourceValue = (String)objValue;
                config.setOption((IHoldsOptions)tool, dstOption, dstOptionValueId.append(sourceValue).toString());
            }
        }
    }

    public boolean isEnumValueAppropriate(IBuildObject configuration, IHoldsOptions holder, IOption option, String extraArgument, String enumValue) {
        IConfiguration config = null;
        if (configuration instanceof IConfiguration) {
            config = (IConfiguration)configuration;
        } else if (configuration instanceof IFolderInfo) {
            IFolderInfo oFolderInfo = (IFolderInfo)configuration;
            config = oFolderInfo.getParent();
        }
        if (config == null) {
            return false;
        }
        IToolChain toolChain = config.getToolChain();
        IProject selection = EclipseUtils.getSelectedProject();
        ToolChainOptionValidator validator = ToolChainOptionValidator.getInstance();
        boolean isApplicable = true;
        for (ToolChainOptionApplicability rule : validator.getCommonRules()) {
            if (this.isRuleAdaptive(option, enumValue, rule.getOption()) && (isApplicable = this.isValidDependency(option, enumValue, toolChain, rule.getOption(), rule.getApplicWithOption()))) break;
        }
        if (isApplicable && selection != null) {
            for (ToolChainOptionApplicability rule : validator.getRulesByNature()) {
                try {
                    if (!this.isRuleAdaptive(option, enumValue, rule.getOption())) continue;
                    String natureProject = "org.eclipse.cdt.core.cnature";
                    if (selection.hasNature("org.eclipse.cdt.core.ccnature")) {
                        natureProject = "org.eclipse.cdt.core.ccnature";
                    }
                    if (!(isApplicable = natureProject.equals(rule.getApplicNature()))) continue;
                    break;
                }
                catch (CoreException e) {
                    Activator.log((IStatus)e.getStatus());
                }
            }
        }
        return isApplicable;
    }

    private boolean isRuleAdaptive(IOption cdtOption, String enumValue, ToolChainOption opt) {
        return cdtOption.getBaseId().equals(opt.getOptBaseId()) && enumValue.equals(opt.getOptionEnumValue());
    }

    private boolean isValidDependency(IOption cdtOption, String enumValue, IToolChain toolChain, ToolChainOption opt, ToolChainOption applicOpts) {
        String applicableValue;
        IOption armOption;
        Object curOptionValue;
        boolean isApplicable = false;
        if (cdtOption.getBaseId().equals(opt.getOptBaseId()) && enumValue.equals(opt.getOptionEnumValue()) && (curOptionValue = (armOption = toolChain.getOptionBySuperClassId(applicOpts.getOptBaseId())).getValue()).equals(applicableValue = applicOpts.getOptionIdValue())) {
            isApplicable = true;
        }
        return isApplicable;
    }
}

