/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.gnu.arm.importer;

import com.freescale.s32ds.cross.gnu.arm.Activator;
import com.freescale.s32ds.cross.gnu.arm.Messages;
import com.freescale.s32ds.cross.gnu.arm.importer.ImportAbstract;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;

public class ImportCW
extends ImportAbstract {
    private static final String PATH_0 = "/.project";
    private static final String LIBMODEL = "value=\"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.toolchain.sharedoption.model.";
    private static final String DIRS = "/Project_Settings/Startup_Code/";
    private static final String PE = "ProcessorExpert.ld";
    static final Map<String, String> SUPP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("SKEAZ128_flash.ld", "SKEAZ128M4");
            this.put("SKEAZ64_flash.ld", "SKEAZ64M4");
            this.put("SKEAZN32_flash.ld", "SKEAZN32M2");
            this.put("SKEAZN64_flash.ld", "SKEAZN64M2");
            this.put("SKEAZN8_flash.ld", "SKEAZN8M4");
        }
    };
    private static final String[] OPTS = new String[]{"option.debugging.level", "toolchain.sharedoption.librarian", "option.debugging.other", "org.eclipse.cdt.cross.arm.gnu.c.link.option.otherflags"};
    private static final String EWL_DEFAULT = "<option id=\"com.freescale.s32ds.cross.gnu.arm.cortexm.option.target.libraries.2\" \nsuperClass=\"com.freescale.s32ds.cross.gnu.arm.cortexm.option.target.libraries\" \nvalue=\"com.freescale.s32ds.cross.gnu.arm.cortexm.option.target.libraries.ewl_c_noio\" valueType=\"enumerated\"/>\n</toolChain>\n";
    private static final String INCS = "<listOptionValue builtIn=\"false\" value=\"&quot;${ProjDirPath}//include&quot;\"/> \n<listOptionValue builtIn=\"false\" value=\"&quot;${ProjDirPath}//Project_Settings//Startup_Code&quot;\"/> \n<listOptionValue builtIn=\"false\" value=\"&quot;${eclipse_home}..//S32DS//arm_ewl2//EWL_C//include&quot;\"/> \n<listOptionValue builtIn=\"false\" value=\"&quot;${eclipse_home}..//S32DS//arm_ewl2//EWL_C++//include&quot;\"/> \n<listOptionValue builtIn=\"false\" value=\"&quot;${eclipse_home}..//S32DS//arm_ewl2//EWL_Runtime//include&quot;\"/> \n";
    private static final String INC_FULL = "\n<option id=\"gnu.c.compiler.option.include.paths.1\" superClass=\"gnu.c.compiler.option.include.paths\" > \n<listOptionValue builtIn=\"false\" value=\"&quot;${ProjDirPath}//include&quot;\"/> \n<listOptionValue builtIn=\"false\" value=\"&quot;${ProjDirPath}//Project_Settings//Startup_Code&quot;\"/> \n<listOptionValue builtIn=\"false\" value=\"&quot;${eclipse_home}..//S32DS//arm_ewl2//EWL_C//include&quot;\"/> \n<listOptionValue builtIn=\"false\" value=\"&quot;${eclipse_home}..//S32DS//arm_ewl2//EWL_C++//include&quot;\"/> \n<listOptionValue builtIn=\"false\" value=\"&quot;${eclipse_home}..//S32DS//arm_ewl2//EWL_Runtime//include&quot;\"/> \n</option>\n";
    private static final String[][] FOR_TOOL;
    private static final String[][] FOR_ARM;

    static {
        String[][] stringArrayArray = new String[5][];
        String[] stringArray = new String[3];
        stringArray[0] = "com.freescale.s32ds.cross.gnu.tool.printsize";
        stringArray[2] = "<option id=\"com.freescale.s32ds.cross.gnu.option.printsize.format.1\" name=\"Size format\" superClass=\"com.freescale.s32ds.cross.gnu.option.printsize.format\"/>";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = "com.freescale.s32ds.cross.gnu.tool.createlisting";
        stringArray2[2] = "<option id=\"com.freescale.s32ds.cross.gnu.option.createlisting.source.9\"      name=\"Display source (--source|-S)\"             superClass=\"com.freescale.s32ds.cross.gnu.option.createlisting.source\"      value=\"true\" valueType=\"boolean\"/> <option id=\"com.freescale.s32ds.cross.gnu.option.createlisting.allheaders.1\"  name=\"Display all headers (--all-headers|-x)\"   superClass=\"com.freescale.s32ds.cross.gnu.option.createlisting.allheaders\"  value=\"true\" valueType=\"boolean\"/> <option id=\"com.freescale.s32ds.cross.gnu.option.createlisting.demangle.2\"    name=\"Demangle names (--demangle|-C)\"           superClass=\"com.freescale.s32ds.cross.gnu.option.createlisting.demangle\"    value=\"true\" valueType=\"boolean\"/> <option id=\"com.freescale.s32ds.cross.gnu.option.createlisting.linenumbers.1\" name=\"Display line numbers (--line-numbers|-l)\" superClass=\"com.freescale.s32ds.cross.gnu.option.createlisting.linenumbers\" value=\"true\" valueType=\"boolean\"/> <option id=\"com.freescale.s32ds.cross.gnu.option.createlisting.wide.2\"        name=\"Wide lines (--wide|-w)\"                   superClass=\"com.freescale.s32ds.cross.gnu.option.createlisting.wide\"        value=\"true\" valueType=\"boolean\"/> ";
        stringArrayArray[1] = stringArray2;
        stringArrayArray[2] = new String[]{"com.freescale.s32ds.cross.gnu.tool.cpp.compiler", " \n", "<option id=\"gnu.cpp.compiler.option.include.paths.3\" superClass=\"gnu.cpp.compiler.option.include.paths\" valueType=\"includePath\">  \n<listOptionValue builtIn=\"false\" value=\"&quot;${ProjDirPath}//include&quot;\"/> \n<listOptionValue builtIn=\"false\" value=\"&quot;${ProjDirPath}//Project_Settings//Startup_Code&quot;\"/> \n<listOptionValue builtIn=\"false\" value=\"&quot;${eclipse_home}..//S32DS//arm_ewl2//EWL_C//include&quot;\"/> \n<listOptionValue builtIn=\"false\" value=\"&quot;${eclipse_home}..//S32DS//arm_ewl2//EWL_C++//include&quot;\"/> \n<listOptionValue builtIn=\"false\" value=\"&quot;${eclipse_home}..//S32DS//arm_ewl2//EWL_Runtime//include&quot;\"/> \n</option>"};
        stringArrayArray[3] = new String[]{"com.freescale.s32ds.cross.gnu.arm.cortexm.tool.cpp.linker", " \n", "<option id=\"com.freescale.s32ds.cross.gnu.tool.cpp.linker.option.gcsections.1\" name=\"Remove unused sections (-Xlinker --gc-sections)\" superClass=\"com.freescale.s32ds.cross.gnu.tool.cpp.linker.option.gcsections\" value=\"true\" valueType=\"boolean\" /> <option id=\"com.freescale.s32ds.cross.gnu.arm.cortexm.cpp.linker.option.usenewlibnano.6\" superClass=\"com.freescale.s32ds.cross.gnu.arm.cortexm.cpp.linker.option.usenewlibnano\" value=\"true\" valueType=\"boolean\"/> "};
        stringArrayArray[4] = new String[]{"com.freescale.s32ds.cross.gnu.tool.assembler", " \n", "<option id=\"com.freescale.s32ds.cross.gnu.tool.assembler.usepreprocessor.2\" name=\"Use preprocessor\" superClass=\"com.freescale.s32ds.cross.gnu.tool.assembler.usepreprocessor\" value=\"true\" valueType=\"boolean\"/> <option defaultValue=\"gnu.c.optimization.level.none\" id=\"com.freescale.s32ds.cross.gnu.tool.assembler.option.optimization.level.1\" name=\"Optimization Level\" superClass=\"com.freescale.s32ds.cross.gnu.tool.assembler.option.optimization.level\" valueType=\"enumerated\"/> <option id=\"com.freescale.s32ds.cross.gnu.tool.assembler.option.debugging.level.1\" name=\"Debug Level\" superClass=\"com.freescale.s32ds.cross.gnu.tool.assembler.option.debugging.level\" value=\"gnu.c.debugging.level.max\" valueType=\"enumerated\"/> <option id=\"gnu.both.asm.option.include.paths.1\" superClass=\"gnu.both.asm.option.include.paths\" valueType=\"includePath\"> \t<listOptionValue builtIn=\"false\" value=\"&quot;../include&quot;\"/> \t<listOptionValue builtIn=\"false\" value=\"&quot;${ProjDirPath}/Generated_Code&quot;\"/> </option><option id=\"com.freescale.s32ds.cross.gnu.tool.assembler.option.defs.1\" superClass=\"com.freescale.s32ds.cross.gnu.tool.assembler.option.defs\" valueType=\"definedSymbols\"> \t<listOptionValue builtIn=\"false\" value=\"__STARTUP_CLEAR_BSS\"/> \n </option>\n"};
        FOR_TOOL = stringArrayArray;
        FOR_ARM = new String[][]{{"org.eclipse.cdt.cross.arm.gnu.buildArtefactType.application", "com.freescale.s32ds.cross.gnu.arm.cortexm.buildArtefact.exe"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf.debug", "com.freescale.s32ds.cross.gnu.arm.cortexm.exe.debug"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf.toolchain.", "com.freescale.s32ds.cross.gnu.arm.cortexm.toolChain."}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf.createflash", "com.freescale.s32ds.cross.gnu.arm.cortexm.tool.createflash"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf.createlisting", "com.freescale.s32ds.cross.gnu.tool.createlisting"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf.printsize", "com.freescale.s32ds.cross.gnu.tool.printsize"}, {"com.freescale.cdt.cross.arm.gnu.sourcery.windows.elf.cpp.preprocessor.debug", "com.freescale.s32ds.cross.gnu.cpp.preprocessor"}, {"com.freescale.cdt.cross.arm.gnu.sourcery.windows.elf.preprocessor.debug", "com.freescale.s32ds.cross.gnu.c.preprocessor"}, {"com.freescale.cdt.cross.arm.gnu.sourcery.windows.elf.disassembler.debug", "com.freescale.s32ds.cross.gnu.disassembler"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.option.target.processor", "com.freescale.s32ds.cross.gnu.arm.cortexm.option.target.mcpu"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf.c.compiler.debug", "com.freescale.s32ds.cross.gnu.arm.cortexm.tool.c.compiler"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf.cpp.compiler.debug", "com.freescale.s32ds.cross.gnu.arm.cortexm.tool.cpp.compiler"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.archiver.base", "com.freescale.s32ds.cross.gnu.arm.cortexm.tool.archiver"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf.assembler.debug", "com.freescale.s32ds.cross.gnu.arm.cortexm.tool.assembler"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf.c.linker.debug", "com.freescale.s32ds.cross.gnu.arm.cortexm.tool.c.linker"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf.cpp.linker.debug", "com.freescale.s32ds.cross.gnu.arm.cortexm.tool.cpp.linker"}, {"org.eclipse.cdt.cross.arm.gnu.c.compiler.input.asmSourcePreproc", "cdt.managedbuild.tool.gnu.assembler.input"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.assembler.base.input", "cdt.managedbuild.tool.gnu.assembler.input"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.c.compiler.base.input", "cdt.managedbuild.tool.gnu.c.compiler.input"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.cpp.compiler.base.input", "cdt.managedbuild.tool.gnu.cpp.compiler.input"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.toolchain.sharedoption.model", "com.freescale.s32ds.cross.gnu.arm.cortexm.option.target.libraries"}, {"ewl_cpp_", "ewl_c++_"}, {"org.eclipse.cdt.cross.arm.gnu.cpp.compiler.option.include.paths", "gnu.cpp.compiler.option.include.paths"}, {"org.eclipse.cdt.cross.arm.gnu.cpp.compiler.option.optimization.level", "gnu.cpp.compiler.option.optimization.level"}, {"org.eclipse.cdt.cross.arm.gnu.c.compiler.option.optimization.level", "gnu.c.compiler.option.optimization.level"}, {"org.eclipse.cdt.cross.arm.gnu.c.compiler.option.include.paths", "gnu.c.compiler.option.include.paths"}, {"org.eclipse.cdt.cross.arm.gnu.c.compiler.option.optimization.", "com.freescale.s32ds.cross.gnu.tool.c.compiler.option.optimization."}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf.builder.debug", "com.freescale.s32ds.cross.gnu.builder"}, {"org.eclipse.cdt.cross.arm.gnu.c.link.option.otherflags", "com.freescale.s32ds.cross.gnu.tool.c.linker.option.other"}, {"org.eclipse.cdt.cross.arm.gnu.c.link.option.gcsections", "com.freescale.s32ds.cross.gnu.tool.c.linker.option.gcsections"}, {"org.eclipse.cdt.cross.arm.gnu.c.link.option.libs", "gnu.c.link.option.libs"}, {"org.eclipse.cdt.cross.arm.gnu.c.link.option.paths", "gnu.c.link.option.paths"}, {"org.eclipse.cdt.cross.arm.gnu.c.link.option.scriptfile", "com.freescale.s32ds.cross.gnu.tool.c.linker.option.scriptfile"}, {"org.eclipse.cdt.cross.arm.gnu.cpp.link.option.scriptfile", "com.freescale.s32ds.cross.gnu.tool.cpp.linker.option.scriptfile"}, {"org.eclipse.cdt.cross.arm.gnu.cpp.link.option.otherflags", "com.freescale.s32ds.cross.gnu.tool.cpp.linker.option.other"}, {"org.eclipse.cdt.cross.arm.gnu.cpp.link.option.gcsections", "com.freescale.s32ds.cross.gnu.tool.cpp.linker.option.gcsections"}, {"org.eclipse.cdt.cross.arm.gnu.cpp.link.option.libs", "gnu.cpp.link.option.libs"}, {"org.eclipse.cdt.cross.arm.gnu.cpp.link.option.paths", "gnu.cpp.link.option.paths"}, {"${MCUToolsBaseDir}/ARM_GCC_Support/ewl/", "${eclipse_home}../S32DS/arm_ewl2/"}, {"${MCUToolsBaseDir}/PA_Support/ewl/", "${eclipse_home}../S32DS/e200_ewl2/"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf.platform.debug", "cdt.managedbuild.targetPlatform.gnu.cross"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.option.target.processor", "com.freescale.s32ds.cross.gnu.arm.cortexm.option.target.family"}, {"org.eclipse.cdt.cross.arm.gnu.base.option.mcpu.", "com.freescale.s32ds.cross.gnu.arm.cortexm.option.target.mcpu."}, {"org.eclipse.cdt.cross.arm.gnu.c.compiler.option.optimization.level", "gnu.c.compiler.option.optimization.level"}, {"org.eclipse.cdt.cross.arm.gnu.c.compiler.option.optimization.flags", "gnu.c.compiler.option.optimization.flags"}, {"org.eclipse.cdt.cross.arm.gnu.c.linker.input", "cdt.managedbuild.tool.gnu.c.linker.input"}, {"org.eclipse.cdt.cross.arm.gnu.cpp.linker.input", "cdt.managedbuild.tool.gnu.cpp.linker.input"}, {"org.eclipse.cdt.core.GNU_ELF", "org.eclipse.cdt.core.ELF"}, {"com.freescale.core.ide.cdt.errorParsers.GCCErrorParser", "com.freescale.s32ds.cdt.core.errorParsers.GCCErrorParser"}, {"org.eclipse.cdt.managedbuilder.core.ManagedBuildManager", "com.freescale.s32ds.cdt.core.errorParsers.GmakeErrorParser"}, {"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf.", "com.freescale.s32ds.cross.gnu.arm.cortexm.exe."}, {Messages.ImportCW_148, "unusedChildren=\""}, {"name=\"ARM Ltd Windows GCC ", "unusedChildren=\""}, {"</toolChain>", "\n<option id=\"com.freescale.s32ds.cross.gnu.arm.cortexm.option.target.sysroot.1\" superClass=\"com.freescale.s32ds.cross.gnu.arm.cortexm.option.target.sysroot\" value=\"--sysroot=&quot;${ARM_EWL_DIR}&quot;\" valueType=\"string\"/>\n</toolChain>\n"}, {"Project_Headers", "include"}};
    }

    public String convert(String s, String toolchainString, boolean isPE, String path) {
        String libModel = ImportCW.getLibModel(s);
        if (libModel == null) {
            libModel = "ewl_c_noio";
            s = s.replace("</toolChain>", EWL_DEFAULT);
        }
        if (toolchainString != null) {
            s = s.replace(" superClass=\"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf.toolchain.debug\"", toolchainString);
        }
        String[] stringArray = OPTS;
        int n = OPTS.length;
        int n2 = 0;
        while (n2 < n) {
            String x = stringArray[n2];
            s = ImportCW.replaceOpt(s, "id=\"org.eclipse.cdt.cross.arm.gnu.sourcery.windows." + x, "");
            ++n2;
        }
        int i = 0;
        while (i < FOR_ARM.length) {
            s = s.replace(FOR_ARM[i][0], FOR_ARM[i][1]);
            ++i;
        }
        i = 0;
        while (i < FOR_TOOL.length) {
            s = ImportCW.add(s, FOR_TOOL[i][0], FOR_TOOL[i][2], null);
            ++i;
        }
        s = ImportCW.addInclude(s);
        s = ImportCW.updateBuilder(s);
        s = this.normalize(s, libModel, false, isPE);
        s = this.replaceProjectType(s);
        return s;
    }

    private String replaceProjectType(String xml) {
        return xml.replace("org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf", "com.freescale.s32ds.cross.gnu.arm.cortexm.exe");
    }

    public String fits(String loc, boolean strict, boolean pe) {
        block21: {
            File project = new File(String.valueOf(loc) + PATH_0);
            if (!project.exists()) {
                return Messages.ImportCW_no_prj;
            }
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileReader fr = new FileReader(project);){
                    if (fr.read() != -1) break block21;
                    return Messages.ImportCW_prj_empty;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Activator.log(e);
                return String.valueOf(Messages.ImportCW_error_reading) + e.getMessage();
            }
        }
        File ff = new File(String.valueOf(loc) + "/.cproject");
        String s = this.read(ff);
        if (s == null) {
            return "Failed opening " + ff.toString();
        }
        if (s.contains("id=\"org.eclipse.cdt.cross.arm.gnu.sourcery.windows.elf.toolchain")) {
            if (strict) {
                for (String sup : SUPP.keySet()) {
                    if (!s.contains(sup)) continue;
                    return null;
                }
                if (pe && s.contains(PE)) {
                    ff = new File(String.valueOf(loc) + "/" + "ProcessorExpert.pe");
                    s = this.read(ff);
                    if (s == null) {
                        return "Failed opening " + ff.toString();
                    }
                    for (String sup : SUPP.keySet()) {
                        if (!s.contains(sup.substring(0, sup.indexOf(95)))) continue;
                        return null;
                    }
                }
                return "The project does not contain supported processor type.";
            }
            return null;
        }
        if (s.contains(Messages.ImportCW_170)) {
            return Messages.ImportCW_171;
        }
        return Messages.ImportCW_172;
    }

    private static String updateBuilder(String s) {
        int n = s.indexOf(Messages.ImportCW_173);
        if (n < 0) {
            return s;
        }
        int m = s.indexOf(Messages.ImportCW_174, n);
        if ((n = s.indexOf(Messages.ImportCW_175, n)) < 0) {
            return s;
        }
        if (m < 0 || m > n) {
            return String.valueOf(s.substring(0, n)) + Messages.ImportCW_176 + s.substring(n);
        }
        return s;
    }

    private static String getLibModel(String s) {
        int n = s.indexOf(LIBMODEL);
        if (n < 0) {
            return null;
        }
        int m = s.indexOf("\"", n += LIBMODEL.length());
        if (m < 0) {
            return null;
        }
        return s.substring(n, m).replace("ewl_cpp_", "ewl_c++_");
    }

    private static String addInclude(String s) {
        int n = s.indexOf("gnu.c.compiler.option.include.paths");
        if (n < 0 && (n = s.indexOf("id=\"com.freescale.s32ds.cross.gnu.arm.cortexm.tool.c.compiler")) > 0 && (n = s.indexOf(">", n)) > 0) {
            return String.valueOf(s.substring(0, ++n)) + INC_FULL + s.substring(n);
        }
        return s;
    }

    public boolean postProcess(String path) {
        String root = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocationURI().getPath()) + path;
        File fl = new File(String.valueOf(root) + "/FLASH");
        if (fl.exists() && fl.isDirectory()) {
            File[] fileArray = fl.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                f.delete();
                ++n2;
            }
        }
        return new File(String.valueOf(root) + "/Project_Headers").renameTo(new File(String.valueOf(root) + "/include")) && new File(String.valueOf(root) + DIRS + "__arm_start.c").delete() && new File(String.valueOf(root) + DIRS + "__arm_end.c").delete();
    }

    @Override
    public Map<String, String> getProcessors() {
        return SUPP;
    }
}

