/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.core.updater.service.impl;

import com.nxp.s32ds.ext.ide.core.updater.service.ProjectUpdaterService;
import com.nxp.s32ds.ext.ide.core.updater.service.impl.ProjectUpdaterServiceJob;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.osgi.service.component.annotations.Component;

@Component
public class ProjectUpdaterServiceImpl
implements ProjectUpdaterService {
    private static final long JOB_DELAY = 3000L;
    private ProjectUpdaterServiceListener trakerListener = null;

    public void bindWorkspace(IWorkspace workspace) {
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] projects = root.getProjects();
        ProjectUpdaterServiceJob job = new ProjectUpdaterServiceJob("ToolChain updater job", projects, ".cproject", "com.nxp.s32ds.cle.arm.mbs.arm32.bare.tool\u0441hain", "com.nxp.s32ds.cle.arm.mbs.arm32.bare.toolchain");
        job.setRule((ISchedulingRule)root);
        job.schedule();
        this.trakerListener = new ProjectUpdaterServiceListener(3000L);
        ((Workspace)workspace).addLifecycleListener((ILifecycleListener)this.trakerListener);
    }

    public void unbindWorkspace(IWorkspace workspace) {
        if (this.trakerListener != null) {
            this.trakerListener = null;
        }
    }

    private class ProjectUpdaterServiceListener
    implements ILifecycleListener {
        private final long delay;

        private ProjectUpdaterServiceListener(long delay) {
            this.delay = delay;
        }

        public void handleEvent(LifecycleEvent event) throws CoreException {
            if (event.kind == 32) {
                IProject project = (IProject)event.resource;
                ProjectUpdaterServiceJob job = new ProjectUpdaterServiceJob("ToolChain updater job", new IProject[]{project}, ".cproject", "com.nxp.s32ds.cle.arm.mbs.arm32.bare.tool\u0441hain", "com.nxp.s32ds.cle.arm.mbs.arm32.bare.toolchain");
                job.setRule((ISchedulingRule)project.getWorkspace().getRoot());
                job.schedule(this.delay);
            }
        }
    }
}

