/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.internal.AbstractSDK;
import com.freescale.s32ds.cross.sdk.internal.ContributedSDK;
import com.freescale.s32ds.cross.sdk.internal.ExtendedPath;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class StorableSDK
extends ContributedSDK {
    private static final String SDK_NOT_FOUND = Messages.StorableSDK_NOT_FOUND;
    public static final String GIT_FILES_PREF = "GIT_FILES.";

    public StorableSDK(SDKHeader head, TCHolder root, IFilterOptions filterOptions, TCHolder[] hs) {
        super(head, root, filterOptions, hs);
    }

    protected void copyLists(ISDK src, String path, boolean isDir) {
        AbstractSDK abs = (AbstractSDK)src;
        IExtendedPath p = ExtendedPath.fromOSString(path, isDir);
        this.copyHolder(abs.root, this.root, p);
        this.toolchains = abs.toolchains;
        if (this.toolchains == null) {
            this.toolchains = new TCHolder[0];
        } else {
            int i = 0;
            while (i < this.toolchains.length) {
                this.copyHolder(abs.toolchains[i], this.toolchains[i], p);
                ++i;
            }
        }
    }

    public String setLocalPath(String path, final Shell shell) {
        if (path == null || path.isEmpty()) {
            return "Empty";
        }
        String res = "Bad";
        File f = new File(path);
        if (f.exists() && f.isDirectory() && f.list().length > 0) {
            List<ISDK> sdks;
            this.root.clear();
            File fsdk = new File(f, "sources.xml");
            if (fsdk.exists() && fsdk.canRead() && (sdks = AbstractSDK.load(fsdk, 1)).size() > 0) {
                for (ISDK sdk : sdks) {
                    if (!sdk.getName().equals(this.getName()) || !sdk.getVersion().equals(this.getVersion())) continue;
                    this.copyLists(sdk, path, f.isDirectory());
                    this.saveVars(fsdk.getParent());
                    res = null;
                    break;
                }
                if (res != null) {
                    final String msg = String.format(String.valueOf(Messages.StorableSDK_NO_DESCRIPTION) + Messages.StorableSDK_USE_BROWSE, this.getName(), this.getVersion(), path);
                    SDKSupportPlugin.log(msg);
                    if (shell != null) {
                        new WorkbenchJob("error message"){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                Status status = new Status(4, SDKSupportPlugin.getUniqueIdentifier(), 1, SDK_NOT_FOUND, null);
                                ErrorDialog.openError((Shell)shell, (String)SDK_NOT_FOUND, (String)msg, (IStatus)status);
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                }
            }
        }
        return res;
    }

    private void saveVars(String path) {
        try {
            SDKSupportPlugin.createEnvironment(this.getName(), this.getVersion(), false, false, path, this.getDescription());
            ArrayList<ISDK> lst = new ArrayList<ISDK>();
            lst.add(this);
            String xml = AbstractSDK.getSDKsString(lst);
            IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(SDKSupportPlugin.getUniqueIdentifier());
            prefs.put(GIT_FILES_PREF + this.getName() + '_' + this.getVersion(), xml);
            prefs.flush();
        }
        catch (Exception e) {
            SDKSupportPlugin.error(e);
        }
    }

    private void copyHolder(TCHolder src, TCHolder dst, IExtendedPath path) {
        this.updatePaths(src.srcs, dst.srcs, path, true);
        this.updatePaths(src.hdrs, dst.hdrs, path, true);
        this.updatePaths(src.bins, dst.bins, path, true);
        this.updatePaths(src.oths, dst.oths, path, true);
        this.updatePaths(src.ldfs, dst.ldfs, path, false);
        this.updatePaths(src.srcs, dst.srcs, path, false);
    }

    private void updatePaths(List<IExtendedPath> src, List<IExtendedPath> dst, IExtendedPath sdkRootPath, boolean update) {
        dst.clear();
        for (IExtendedPath p : src) {
            if (!sdkRootPath.isPrefixOf(p)) {
                IExtendedPath newPath = ExtendedPath.fromOSString(sdkRootPath.append(p).toOSString(), p.isCopy(), p.copyPath(), p.renameTo(), p.isPublic(), p.toOpen(), p.isDirectory());
                dst.add(newPath);
                continue;
            }
            dst.add(p);
        }
    }
}

