/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.core.ProjectSettings;
import com.freescale.s32ds.cross.sdk.IProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.AbstractSmartFilter;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class AvailableSDKFilter
extends AbstractSmartFilter {
    private final IProject project;

    public AvailableSDKFilter(IProject project) {
        this.project = project;
    }

    @Override
    public boolean accept(ISDK sdk) {
        if (sdk instanceof IProjectLocalSDK) {
            IProjectLocalSDK pll = (IProjectLocalSDK)sdk;
            return this.project != null && this.project.equals((Object)pll.getProject());
        }
        return true;
    }

    @Override
    public IFilterOptions options() {
        return AvailableSDKFilter.options(this.project);
    }

    public static IFilterOptions options(IProject proj) {
        IConfiguration[] projectConfigs = ManagedBuildManager.getBuildInfo((IResource)proj).getManagedProject().getConfigurations();
        ArrayList<IToolChain> tcs = new ArrayList<IToolChain>();
        IConfiguration[] iConfigurationArray = projectConfigs;
        int n = projectConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            IToolChain tc = config.getToolChain();
            if (FilterOptions.isDigitTail(tc.getId())) {
                tc = tc.getSuperClass();
            }
            tcs.add(tc);
            ++n2;
        }
        ProjectSettings ps = new ProjectSettings(proj, "com.freescale.s32ds.cross.wizard");
        String processorId = ps.load("processor");
        String lang = ps.load("language");
        String coreTypeId = ps.load("coreType");
        String coreKindId = null;
        if (processorId.isEmpty() || coreTypeId.isEmpty()) {
            return null;
        }
        if (coreTypeId.toLowerCase().startsWith(processorId.toLowerCase())) {
            coreKindId = coreTypeId.substring(processorId.length() + 1);
        }
        if (coreKindId == null) {
            coreKindId = SDKUtils.unifyCoreKind(coreTypeId);
        }
        processorId = SDKUtils.unifyProcessor(processorId);
        IFilterOptions.ELang langs = lang.equalsIgnoreCase("c") ? IFilterOptions.ELang.C : (lang.equalsIgnoreCase("c++") ? IFilterOptions.ELang.CPP : IFilterOptions.ELang.UNKNOWN);
        IToolChain[] toolChains = tcs.toArray(new IToolChain[0]);
        String[] cores = new String[]{String.format("%s:%s", processorId, coreKindId)};
        FilterOptions options = new FilterOptions(langs, toolChains, cores);
        return options;
    }
}

