/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker;

import com.freescale.s32ds.cross.sdk.checkers.cproject.UnsupportedProjectTypeException;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.GCCToolChainFPChecker;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.GCC_6_3_ToolChainFPChecker;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.GHSToolChainFPChecker;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.GHSToolChainFPCheckerLib;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.IARToolChainFPChecker;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.IToolChainFPChecker;
import org.eclipse.cdt.managedbuilder.core.IProjectType;

public class ToolChainFPCheckerFactory {
    private static final String GCC_PROJECT_TYPE = "com.freescale.s32ds.cross.gnu.arm.cortexm.exe";
    private static final String GCC_PROJECT_TYPE_LIB = "com.freescale.s32ds.cross.gnu.arm.cortexm.lib";
    private static final String GCC_6_3_PROJECT_TYPE = "com.nxp.s32ds.cle.arm.mbs.arm32.bare.exe";
    private static final String GCC_6_3_PROJECT_TYPE_LIB = "com.nxp.s32ds.cle.arm.mbs.arm32.bare.lib";
    private static final String GHS_PROJECT_TYPE = "ghs.managedmake.arm.executable";
    private static final String GHS_PROJECT_TYPE_LIB = "ghs.managedmake.arm.static_library";
    private static final String IAR_PROJECT_TYPE = "iar.arm.toolchain.project.exe.v5.4.0";
    private static final String IAR_PROJECT_TYPE_LIB = "iar.arm.toolchain.project.library.v5.4.0";

    public static IToolChainFPChecker getToolchainFPChecker(IProjectType projectType) throws UnsupportedProjectTypeException {
        String projectTypeId;
        switch (projectTypeId = projectType.getId()) {
            case "com.freescale.s32ds.cross.gnu.arm.cortexm.exe": {
                return new GCCToolChainFPChecker();
            }
            case "com.nxp.s32ds.cle.arm.mbs.arm32.bare.exe": {
                return new GCC_6_3_ToolChainFPChecker();
            }
            case "com.freescale.s32ds.cross.gnu.arm.cortexm.lib": {
                return new GCCToolChainFPChecker();
            }
            case "com.nxp.s32ds.cle.arm.mbs.arm32.bare.lib": {
                return new GCC_6_3_ToolChainFPChecker();
            }
            case "ghs.managedmake.arm.executable": {
                return new GHSToolChainFPChecker();
            }
            case "ghs.managedmake.arm.static_library": {
                return new GHSToolChainFPCheckerLib();
            }
            case "iar.arm.toolchain.project.exe.v5.4.0": {
                return new IARToolChainFPChecker();
            }
            case "iar.arm.toolchain.project.library.v5.4.0": {
                return new IARToolChainFPChecker();
            }
        }
        throw new UnsupportedProjectTypeException(projectTypeId);
    }
}

