/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKHook;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.checkers.cproject.UnsupportedProjectTypeException;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.IToolChainFPChecker;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.ToolChainFPCheckerFactory;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.ToolChainFPCheckerResult;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SDKCheckFPProjectSettingRequiredHook
implements ISDKHook {
    private static final int MODE = 517;

    @Override
    public void stateChange(int mode, ISDK sdk, Object cfg, String path) {
        if (mode == 517) {
            SDKSupportPlugin.log(String.format("Hook %s is called.", this.getClass().getName()));
            if (sdk != null && cfg != null) {
                try {
                    ToolChainFPCheckerResult checkResult = this.checkFPProjectSettings(sdk, ((IConfiguration)cfg).getManagedProject(), path);
                    if (!checkResult.isCheckPassed()) {
                        this.showMessage(sdk, path, checkResult);
                    }
                }
                catch (UnsupportedProjectTypeException upte) {
                    SDKSupportPlugin.log(upte.getMessage());
                }
            }
        }
    }

    private ToolChainFPCheckerResult checkFPProjectSettings(ISDK sdk, IManagedProject managedProject, String projectName) throws UnsupportedProjectTypeException {
        IToolChainFPChecker tcChecker = ToolChainFPCheckerFactory.getToolchainFPChecker(managedProject.getProjectType());
        IConfiguration[] iConfigurationArray = managedProject.getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolChain tc;
            IConfiguration config = iConfigurationArray[n2];
            if (SDKAttach.isAttached(projectName, config.getName(), sdk.getId()) && !tcChecker.checkToolChainFPOptionsSet(tc = config.getToolChain())) {
                tcChecker.getCheckResult().addConfig(config.getName());
            }
            ++n2;
        }
        return tcChecker.getCheckResult();
    }

    private void showMessage(final ISDK sdk, final String projectName, final ToolChainFPCheckerResult checkResult) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                StringBuilder sb = new StringBuilder();
                checkResult.getInproperConfigs().forEach(c -> {
                    sb.append("- ");
                    sb.append((String)c);
                    sb.append("\n");
                });
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.SDKCheckFPProjectSetting_warning_title, (String)String.format(Messages.SDKCheckFPProjectSetting_warning_message, sdk.getId(), projectName, checkResult.getFpOptionName(), checkResult.getFpOptionValue(), sb.toString()));
            }
        });
    }
}

