/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.tools;

import com.freescale.s32ds.cdt.core.EclipseUtils;
import com.freescale.s32ds.cdt.core.IOUtils;
import com.freescale.s32ds.cross.core.Activator;
import com.nxp.s32ds.ext.ide.examples.core.ProjectSet;
import com.nxp.s32ds.ext.ide.ui.operations.RenameOperation;
import com.nxp.s32ds.ext.rcp.jse.utils.FuncUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.WorkbenchJob;

final class RenameJob
extends WorkbenchJob {
    public static final String EMPTY = "";
    private final ProjectSet projects;
    private final String name;

    public RenameJob(ProjectSet projects, String name) {
        super("Rename S32DS project");
        this.projects = projects;
        this.name = name;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        try {
            new RenameOperation(this.name, this.projects).run(monitor);
            this.projects.getProjects().map(IProjectDescription::getName).map(EclipseUtils::getProjectByName).forEach(FuncUtils.loggingConsumer(p -> p.delete(true, monitor)));
            IOUtils.rm((File)this.projects.getPath().makeAbsolute().toFile());
            return Status.OK_STATUS;
        }
        catch (InterruptedException | InvocationTargetException e) {
            return Activator.log(e);
        }
    }
}

