/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.tools;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.tools.ExtensionLoader;
import com.freescale.s32ds.cross.core.tools.ExternalTool;
import com.freescale.s32ds.cross.core.tools.ExternalToolRunnerHelper;
import com.freescale.s32ds.cross.core.tools.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildCommand;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class Disassembler
extends ExternalTool {
    private static final long ONE_MEGABYTE = 0x100000L;

    public IStatus disassembleFiles(List<IFile> files, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            Map<IProject, List<IFile>> projectMap = Disassembler.arrangeFilesByProject(files);
            monitor.beginTask("", files.size());
            for (List<IFile> filesInProject : projectMap.values()) {
                IProject project = filesInProject.get(0).getProject();
                monitor.subTask(Messages.getString("Disassembler.message.Disassembling_files_in_project", project.getName()));
                this.disassembleFilesForOneProject(filesInProject, monitor);
            }
        }
        finally {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void disassembleFilesForOneProject(List<IFile> files, IProgressMonitor monitor) throws CoreException {
        IProject project = files.get(0).getProject();
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            return;
        }
        IConfiguration configuration = buildInfo.getDefaultConfiguration();
        Map<String, String> environment = Disassembler.calculateEnvironment(configuration);
        IPath pathToWorkingDirectory = configuration.getBuilder().getBuildLocation();
        try {
            ExternalToolRunnerHelper externalToolRunnerHelper = new ExternalToolRunnerHelper(project);
            externalToolRunnerHelper.greeting(Messages.getString("Disassembler.message.Disassembling_selected_files_of_configuration_in_project", new String[]{configuration.toString(), project.getName()}));
            for (IFile file : files) {
                if (monitor.isCanceled()) break;
                ITool disassembler = Disassembler.getDisassembler(configuration, file);
                if (disassembler == null) {
                    return;
                }
                String outputFileExtension = Disassembler.getOutputFileExtension(disassembler);
                IPath pathToInputFile = file.getLocation();
                IPath relativePathToInputFile = pathToInputFile.makeRelativeTo(pathToWorkingDirectory);
                IPath pathToOutputFile = pathToInputFile.removeFileExtension().addFileExtension(outputFileExtension);
                try {
                    String[] disassemblerFlags = disassembler.getToolCommandFlags(pathToInputFile, null);
                    String[] inputResources = new String[]{relativePathToInputFile.toOSString()};
                    IManagedCommandLineGenerator generator = disassembler.getCommandLineGenerator();
                    IManagedCommandLineInfo cmdLineInfo = generator.generateCommandLineInfo(disassembler, disassembler.getToolCommand(), disassemblerFlags, disassembler.getOutputFlag(), disassembler.getOutputPrefix(), pathToOutputFile.toString(), inputResources, disassembler.getCommandLinePattern());
                    String cmdLine = cmdLineInfo.getCommandLine();
                    String resolvedCommandLine = ManagedBuildManager.getBuildMacroProvider().resolveValue(cmdLine, "", " ", 1, (Object)new FileContextData(null, null, null, (IBuildObject)disassembler));
                    IBuildCommand buildCommand = Disassembler.createCommandFromString(resolvedCommandLine, pathToWorkingDirectory, environment);
                    IPath pathToInputFileWithoutExtension = pathToInputFile.removeFileExtension();
                    String inputFileNameWithoutExtension = pathToInputFileWithoutExtension.makeRelativeTo(pathToInputFileWithoutExtension.removeLastSegments(1)).toString();
                    if (inputFileNameWithoutExtension.length() < 3) {
                        inputFileNameWithoutExtension = String.valueOf(inputFileNameWithoutExtension) + "tmp";
                    }
                    File redirectionFile = File.createTempFile(inputFileNameWithoutExtension, "." + outputFileExtension, pathToOutputFile.removeLastSegments(1).toFile());
                    externalToolRunnerHelper.setLaunchParameters((ICommandLauncher)new CommandLauncher(), buildCommand.getCommand(), buildCommand.getArgs(), pathToWorkingDirectory, Disassembler.mapToStringArray(environment));
                    externalToolRunnerHelper.prepareStreams(new FileOutputStream(redirectionFile));
                    int state = externalToolRunnerHelper.execute(monitor);
                    if (state != -1) {
                        externalToolRunnerHelper.refreshProject(configuration.getName());
                        long length = redirectionFile.length();
                        if (length == 0L) {
                            return;
                        }
                        if (length > 0x100000L) {
                            this.openFileInExternalEditor(redirectionFile);
                        } else {
                            this.openFileInEditor(redirectionFile);
                        }
                    }
                }
                catch (BuildException e) {
                    e.printStackTrace();
                }
                monitor.worked(1);
            }
            externalToolRunnerHelper.close();
            externalToolRunnerHelper.goodbye(Messages.getString("Disassembler.message.Disassembling"));
        }
        catch (IOException e) {
            Activator.log(e);
        }
    }

    public static ITool getDisassembler(IConfiguration configuration, IFile file) {
        ITool tool = configuration.getTargetTool();
        if (tool == null) {
            return null;
        }
        ITool defaultDisassembler = null;
        for (String disId : ExtensionLoader.getInstance().getDisassemblers(tool)) {
            IInputType[] inputTypes;
            ITool[] tools = configuration.getToolsBySuperClassId(disId);
            if (tools.length <= 0) continue;
            IInputType[] iInputTypeArray = inputTypes = tools[0].getInputTypes();
            int n = inputTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IInputType inputType = iInputTypeArray[n2];
                if (inputType.getSourceContentType() == null) {
                    if (defaultDisassembler == null) {
                        defaultDisassembler = tools[0];
                    }
                } else {
                    List<String> types = Arrays.asList(inputType.getSourceExtensions(tools[0]));
                    if (types.contains(file.getFileExtension())) {
                        return tools[0];
                    }
                }
                ++n2;
            }
        }
        return defaultDisassembler;
    }
}

