/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model;

import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.core.model.data.SimpleData;

public class MemoryUtil {
    public static ConfigurationData getFlashSize(CoreNatureData core) {
        return MemoryUtil.getMemorySizeElement("flashSize", "flashSizeDefault", core);
    }

    public static ConfigurationData getRamSize(CoreNatureData core) {
        return MemoryUtil.getMemorySizeElement("ramSize", "ramSizeDefault", core);
    }

    public static ConfigurationData getFlashStart(CoreNatureData core) {
        return MemoryUtil.getMemoryStartElement("flashStart", "flashSize", core);
    }

    public static ConfigurationData getRamStart(CoreNatureData core) {
        return MemoryUtil.getMemoryStartElement("ramStart", "ramSize", core);
    }

    private static ConfigurationData getMemorySizeElement(String sizeTag, String sizeDefaultTag, CoreNatureData core) {
        ConfigurationData fsd = core.getAttributesDataMap().get(sizeTag);
        if (fsd != null) {
            return fsd;
        }
        fsd = core.getProcessor().getElement(sizeDefaultTag);
        if (fsd instanceof SimpleData) {
            String v = ((SimpleData)fsd).getStringValue();
            return ConfigurationData.getData(sizeTag, v, core);
        }
        return ConfigurationData.getData(sizeTag, 0L, core);
    }

    private static ConfigurationData getMemoryStartElement(String startTag, String sizeTag, CoreNatureData core) {
        ProcessorData processor = core.getProcessor();
        long memoryOffset = processor.getLongValue(startTag);
        for (CoreData c : processor.getCores()) {
            if (c.equals(core)) {
                ConfigurationData start = ConfigurationData.getData(startTag, memoryOffset, core);
                return start;
            }
            memoryOffset += c.getLongValue(sizeTag);
        }
        return ConfigurationData.getData(startTag, 0L, core);
    }

    public static String calculateUnused(String sizeTag, ProcessorData processor, boolean executable) {
        if (!executable) {
            return "Ox00";
        }
        long all = processor.getLongValue(sizeTag);
        for (CoreNatureData c : processor.getCoreNatures(executable)) {
            long coreMemSize = c.getLongValue(sizeTag);
            all -= coreMemSize;
        }
        return Integer.toString((int)(all / 1024L));
    }

    public static String calculateUnused(String sizeTag, ProcessorContext processorContext) {
        long all = processorContext.getLongValue(sizeTag);
        for (CProjectContext c : processorContext.getActiveProjectContexts()) {
            long coreMemSize = c.getLongValue(sizeTag);
            all -= coreMemSize;
        }
        return Integer.toString((int)(all / 1024L));
    }

    public static String calculateUnused(String sizeTag, ProcessorContext processorContext, CoreNatureData replaceCore, long replaceCoreSizeValue) {
        long all = processorContext.getLongValue(sizeTag);
        for (CProjectContext c : processorContext.getActiveProjectContexts()) {
            long coreMemSize = c.getCoreNature().equals(replaceCore) ? replaceCoreSizeValue : c.getLongValue(sizeTag);
            all -= coreMemSize;
        }
        return Integer.toString((int)(all / 1024L));
    }
}

