/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model;

import com.freescale.s32ds.cross.core.model.data.CoProcessorData;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.CoreTypeData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.core.model.registry.DataRegistry;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class HWModel {
    private final ModelRegistry registry;
    private final List<ProcessorData> processors = new ArrayList<ProcessorData>();
    private final List<FamilyData> families = new ArrayList<FamilyData>();
    private final List<CoreTypeData> coreTypes = new ArrayList<CoreTypeData>();
    private final List<CoreData> cores = new ArrayList<CoreData>();
    private final List<CoProcessorData> coProcessors = new ArrayList<CoProcessorData>();

    public HWModel(ModelRegistry registry) {
        this.registry = registry;
        this.processors.addAll(registry.getDatas("processor"));
        this.families.addAll(registry.getDatas("family"));
        this.coreTypes.addAll(registry.getDatas("coreType"));
        this.cores.addAll(registry.getDatas("core"));
        this.coProcessors.addAll(registry.getDatas("coProcessor"));
    }

    public List<FamilyData> getFamilies() {
        return Collections.unmodifiableList(this.families);
    }

    public List<ProcessorData> getProcessors() {
        return Collections.unmodifiableList(this.processors);
    }

    public List<ProcessorData> getProcessors(String familyId) {
        ArrayList<ProcessorData> result = new ArrayList<ProcessorData>();
        for (ProcessorData processor : this.processors) {
            if (!familyId.equals(processor.getStringValue("family"))) continue;
            result.add(processor);
        }
        return result;
    }

    public List<CoreTypeData> getCoreTypes() {
        return Collections.unmodifiableList(this.coreTypes);
    }

    public List<CoreData> getCores() {
        return Collections.unmodifiableList(this.cores);
    }

    public List<CoProcessorData> getCoPrecessors() {
        return Collections.unmodifiableList(this.coProcessors);
    }

    public List<CoreData> getCores(String familyId) {
        return this.getCoreNatures(familyId, true);
    }

    public List<CoreTypeData> getCoreTypes(String familyId) {
        return this.getCoreNatures(familyId, false);
    }

    public List<CoreNatureData> getCoreNatures(String familyId, boolean executable) {
        ArrayList<CoreNatureData> result = new ArrayList<CoreNatureData>();
        List<ProcessorData> pcs = this.getProcessors(familyId);
        for (ProcessorData processor : pcs) {
            result.addAll(processor.getCoreNatures(executable));
        }
        return result;
    }

    public ModelRegistry getRegistry() {
        return this.registry;
    }

    public List<ConfigurationData> searchDatas(String targetTag, String containsDataTag, Object containsDataValue) {
        ArrayList<ConfigurationData> result = new ArrayList<ConfigurationData>();
        DataRegistry dataRegistry = this.getRegistry().getDataRegistry(targetTag);
        Collection<ConfigurationData> datas = dataRegistry.getDatas();
        for (ConfigurationData data : datas) {
            String v = data.getValue(containsDataTag);
            if (v == null || !v.equals(containsDataValue)) continue;
            result.add(data);
        }
        return result;
    }
}

