/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.ui.dndexplorer;

import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class ADragSourceListener
implements DragSourceListener {
    protected AbstractTreeViewer viewer;
    protected IWorkbenchPartSite workbenchPartSite;

    public ADragSourceListener(AbstractTreeViewer abstractTreeViewer, IWorkbenchPartSite workbenchPartSite) {
        this.viewer = abstractTreeViewer;
        this.workbenchPartSite = workbenchPartSite;
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        event.doit = this.isProcessDataDragAndDrop(selection.getFirstElement());
    }

    public void dragSetData(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object data = selection.getFirstElement();
        if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            this.performDragSetData(event, data);
        }
    }

    public void dragFinished(DragSourceEvent event) {
        this.performDragFinished(event);
    }

    protected abstract boolean isProcessDataDragAndDrop(Object var1);

    protected abstract void performDragSetData(DragSourceEvent var1, Object var2);

    protected abstract void performDragFinished(DragSourceEvent var1);

    protected IEditorInput getEditorInput() {
        IEditorPart editor = this.workbenchPartSite.getWorkbenchWindow().getActivePage().getActiveEditor();
        return editor != null ? editor.getEditorInput() : null;
    }
}

