/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms;

import java.util.ArrayList;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MessageDialog
implements Runnable {
    Shell shell;
    Canvas buttonCanvas;
    Shell parentShell;
    Display disp;
    private Label caption;
    private Label iconLabel;
    private final int ALL = 4096;
    private final int NOTOALL = 8192;
    private final int YESTOALL = 16384;
    private final int CUSTOM = 16;
    private short buttonPressed;
    private String message;
    private short buttons;
    private short msgType;

    public void run() {
        this.disp = PlatformUI.getWorkbench().getDisplay();
        this.parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        this.shell = new Shell(this.parentShell, 67680);
        this.createContents(this.message, this.buttons, this.msgType);
        this.shell.open();
        this.shell.layout();
        this.shell.setActive();
        while (!this.shell.isDisposed()) {
            if (this.disp.readAndDispatch()) continue;
            this.disp.sleep();
        }
    }

    public void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    public void setItems(String message, short buttons, short msgType) {
        this.message = message;
        this.buttons = buttons;
        this.msgType = msgType;
    }

    private short encodeButton(String buttonText) {
        short buttonCode = 256;
        if (buttonText.equalsIgnoreCase("OK")) {
            buttonCode = 32;
        }
        if (buttonText.equalsIgnoreCase("Cancel")) {
            buttonCode = 256;
        }
        if (buttonText.equalsIgnoreCase("Yes")) {
            buttonCode = 64;
        }
        if (buttonText.equalsIgnoreCase("No")) {
            buttonCode = 128;
        }
        if (buttonText.equalsIgnoreCase("Yes To All")) {
            buttonCode = 16384;
        }
        if (buttonText.equalsIgnoreCase("No To All")) {
            buttonCode = 8192;
        }
        if (buttonText.equalsIgnoreCase("Retry")) {
            buttonCode = 1024;
        }
        if (buttonText.equalsIgnoreCase("Ignore")) {
            buttonCode = 2048;
        }
        if (buttonText.equalsIgnoreCase("Abort")) {
            buttonCode = 512;
        }
        if (buttonText.equalsIgnoreCase("All")) {
            buttonCode = 4096;
        }
        return buttonCode;
    }

    private String[] getButtonList(short buttons) {
        ArrayList<Integer> buttonList = new ArrayList<Integer>();
        buttonList.add(32);
        buttonList.add(256);
        buttonList.add(64);
        buttonList.add(16384);
        buttonList.add(128);
        buttonList.add(8192);
        buttonList.add(1024);
        buttonList.add(2048);
        buttonList.add(512);
        buttonList.add(4096);
        int buttonCount = buttonList.size();
        int i = 0;
        while (i < buttonCount) {
            int baseIndex = 32;
            int buttonTest = baseIndex << i;
            boolean buttonAvailable = (buttons & buttonTest) >> i == baseIndex;
            int hi = buttonList.indexOf(buttonTest);
            if (!buttonAvailable) {
                buttonList.remove(hi);
            }
            ++i;
        }
        String[] arrayOfButtons = new String[buttonList.size()];
        i = 0;
        while (i < buttonList.size()) {
            switch ((Integer)buttonList.get(i)) {
                case 32: {
                    arrayOfButtons[i] = "OK";
                    break;
                }
                case 256: {
                    arrayOfButtons[i] = "Cancel";
                    break;
                }
                case 64: {
                    arrayOfButtons[i] = "Yes";
                    break;
                }
                case 16384: {
                    arrayOfButtons[i] = "Yes To All";
                    break;
                }
                case 128: {
                    arrayOfButtons[i] = "No";
                    break;
                }
                case 8192: {
                    arrayOfButtons[i] = "No To All";
                    break;
                }
                case 1024: {
                    arrayOfButtons[i] = "Retry";
                    break;
                }
                case 2048: {
                    arrayOfButtons[i] = "Ignore";
                    break;
                }
                case 512: {
                    arrayOfButtons[i] = "Abort";
                    break;
                }
                case 4096: {
                    arrayOfButtons[i] = "All";
                }
            }
            ++i;
        }
        return arrayOfButtons;
    }

    private short checkForCancelation(String[] buttonArray) {
        int buttonCode = 256;
        int i = 0;
        while (i < buttonArray.length) {
            String buttonText = buttonArray[i];
            if (buttonText.equalsIgnoreCase("Ignore")) {
                buttonCode = 2048;
            }
            if (buttonText.equalsIgnoreCase("No")) {
                buttonCode = 128;
            }
            if (buttonText.equalsIgnoreCase("No To All")) {
                buttonCode = 8192;
            }
            if (buttonText.equalsIgnoreCase("Cancel")) {
                buttonCode = 256;
            }
            if (buttonText.equalsIgnoreCase("Abort")) {
                buttonCode = 512;
            }
            ++i;
        }
        return (short)buttonCode;
    }

    protected void createContents(String message, short buttons, short msgType) {
        Rectangle bounds = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getBounds();
        this.shell.setImage(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getImage());
        GridData canvasData = new GridData(64);
        GridData captionData = new GridData(832);
        captionData.widthHint = 170;
        captionData.horizontalIndent = 20;
        if (msgType == 16) {
            this.shell.setLayout((Layout)new GridLayout(1, true));
        } else {
            this.shell.setLayout((Layout)new GridLayout(2, false));
            canvasData.horizontalSpan = 2;
            this.iconLabel = new Label((Composite)this.shell, 0);
            this.iconLabel.setImage(this.disp.getSystemImage((int)msgType));
        }
        this.caption = new Label((Composite)this.shell, 64);
        this.caption.setLayoutData((Object)captionData);
        switch (msgType) {
            case 1: {
                this.shell.setText("Error");
                break;
            }
            case 8: {
                this.shell.setText("Warning");
                break;
            }
            case 2: {
                this.shell.setText("Information");
                break;
            }
            case 4: {
                this.shell.setText("Confirm");
                break;
            }
            case 16: {
                this.shell.setText("");
                break;
            }
            default: {
                this.shell.setText("ERROR: IN MESSAGE TYPE");
            }
        }
        String[] arrayOfButtons = this.getButtonList(buttons);
        this.caption.setText(message);
        this.buttonCanvas = new Canvas((Composite)this.shell, 0);
        this.buttonCanvas.setLayout((Layout)new GridLayout(arrayOfButtons.length, true));
        this.buttonCanvas.setLayoutData((Object)canvasData);
        int i = 0;
        while (i < arrayOfButtons.length) {
            GridData data = new GridData();
            data.widthHint = 90;
            final Button newButton = new Button((Composite)this.buttonCanvas, 0);
            newButton.setLayoutData((Object)data);
            final String[] tempArrayOfButtons = arrayOfButtons;
            newButton.setText(arrayOfButtons[i]);
            newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MessageDialog.this.setButtonPressed(MessageDialog.this.encodeButton(newButton.getText()));
                    MessageDialog.this.close();
                }
            });
            newButton.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 27) {
                        MessageDialog.this.setButtonPressed(MessageDialog.this.checkForCancelation(tempArrayOfButtons));
                        MessageDialog.this.close();
                    }
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        MessageDialog.this.setButtonPressed(MessageDialog.this.encodeButton(newButton.getText()));
                        MessageDialog.this.close();
                    }
                }
            });
            ++i;
        }
        this.shell.pack();
        this.shell.setLocation(bounds.x + (bounds.width - this.shell.getBounds().width) / 2, bounds.y + (bounds.height - this.shell.getBounds().height) / 2);
    }

    public void setButtonPressed(short buttonPressed) {
        this.buttonPressed = buttonPressed;
    }

    public short getButtonPressed() {
        return this.buttonPressed;
    }
}

