/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class GraphicsUtils {
    public static void drawVerticalText(String string, int x, int y, GC gc, int style) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        Point pt = gc.textExtent(string);
        Image stringImage = new Image((Device)display, pt.x, pt.y);
        GC stringGc = new GC((Drawable)stringImage);
        stringGc.setForeground(gc.getForeground());
        stringGc.setBackground(gc.getBackground());
        stringGc.setFont(gc.getFont());
        stringGc.drawText(string, 0, 0);
        GraphicsUtils.drawVerticalImage(stringImage, x, y, gc, style);
        stringGc.dispose();
        stringImage.dispose();
    }

    public static void drawVerticalImage(Image image, int x, int y, GC gc, int style) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        ImageData sd = image.getImageData();
        ImageData dd = new ImageData(sd.height, sd.width, sd.depth, sd.palette);
        boolean up = (style & 0x80) == 128;
        int sx = 0;
        while (sx < sd.width) {
            int sy = 0;
            while (sy < sd.height) {
                int dx = up ? sy : sd.height - sy - 1;
                int dy = up ? sd.width - sx - 1 : sx;
                dd.setPixel(dx, dy, sd.getPixel(sx, sy));
                ++sy;
            }
            ++sx;
        }
        Image vertical = new Image((Device)display, dd);
        gc.drawImage(vertical, x, y);
        vertical.dispose();
    }

    public static Image createRotatedText(String text, Font font, Color foreground, Color background, int style) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        GC gc = new GC((Drawable)display);
        gc.setFont(font);
        gc.getFontMetrics();
        Point pt = gc.textExtent(text);
        gc.dispose();
        Image stringImage = new Image((Device)display, pt.x, pt.y);
        gc = new GC((Drawable)stringImage);
        gc.setFont(font);
        gc.setForeground(foreground);
        gc.setBackground(background);
        gc.drawText(text, 0, 0);
        Image image = GraphicsUtils.createRotatedImage(stringImage, style);
        gc.dispose();
        stringImage.dispose();
        return image;
    }

    public static Image createRotatedImage(Image image, int style) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        ImageData sd = image.getImageData();
        ImageData dd = new ImageData(sd.height, sd.width, sd.depth, sd.palette);
        boolean up = (style & 0x80) == 128;
        int sx = 0;
        while (sx < sd.width) {
            int sy = 0;
            while (sy < sd.height) {
                int dx = up ? sy : sd.height - sy - 1;
                int dy = up ? sd.width - sx - 1 : sx;
                dd.setPixel(dx, dy, sd.getPixel(sx, sy));
                ++sy;
            }
            ++sx;
        }
        return new Image((Device)display, dd);
    }
}

