/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page2;

import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import java.util.HashMap;
import java.util.Map;

public class MemoryMinimumChecker {
    private static Map<String, String> memoryMinimumMap = new HashMap<String, String>();

    static {
        memoryMinimumMap.put("flashSize", "flashSizeMin");
        memoryMinimumMap.put("ramSize", "ramSizeMin");
    }

    public static String getMinMemoryError(ProcessorContext processorContext) {
        for (CProjectContext pc : processorContext.getActiveProjectContexts()) {
            for (String memTag : memoryMinimumMap.keySet()) {
                Parameter param = pc.getParameter(memTag);
                if (param == null || !param.isVisible() || !pc.containsParameter(param.getTag())) continue;
                long l = pc.getLongValue(param.getTag());
                String minTag = memoryMinimumMap.get(memTag);
                long min = pc.getCoreNature().getLongValue(minTag);
                if (min < 0L) {
                    min = 0L;
                }
                if (l > min) continue;
                return String.valueOf(param.getName()) + " should be more than zero for " + pc.getProjectName();
            }
        }
        return null;
    }
}

