/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page2;

import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;
import com.freescale.s32ds.cross.core.model.context.ContextChange;
import com.freescale.s32ds.cross.wizard.ParameterControl;
import com.freescale.s32ds.cross.wizard.page2.Page2AbstractManager;
import com.freescale.s32ds.cross.wizard.page2.S32DSMultiPageTwo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;

public class CoreActivateListener
extends SelectionAdapter {
    private final S32DSMultiPageTwo wizardPage;
    private final CProjectContext projectContext;
    private final Page2AbstractManager pageManager;
    private long flashCache;
    private long ramCache;

    public CoreActivateListener(Page2AbstractManager pageManager, CProjectContext projectContext, S32DSMultiPageTwo wizardPage) {
        this.projectContext = projectContext;
        this.pageManager = pageManager;
        this.wizardPage = wizardPage;
        this.flashCache = projectContext.getLongValue("flashSize");
        this.ramCache = projectContext.getLongValue("ramSize");
    }

    public void widgetSelected(SelectionEvent event) {
        Button checkBox = (Button)event.getSource();
        if (this.projectContext.isAutoStart()) {
            checkBox.setSelection(true);
            event.doit = false;
            return;
        }
        boolean active = checkBox.getSelection();
        this.projectContext.setActive(active);
        List<ParameterControl> controls = ParameterControl.filterControls(this.projectContext, this.pageManager.getControls());
        for (ParameterControl control : controls) {
            control.updateState();
        }
        ArrayList<ContextChange> changes = new ArrayList<ContextChange>();
        changes.addAll(this.processMemory("flashSize", active));
        changes.addAll(this.processMemory("ramSize", active));
        if (!changes.isEmpty()) {
            this.pageManager.update(new ChangeResult(changes));
        }
        this.wizardPage.setPageComplete(this.wizardPage.validatePage());
    }

    private List<ContextChange> processMemory(String tag, boolean active) {
        ChangeResult r;
        if (!this.projectContext.containsParameter(tag)) {
            return Collections.emptyList();
        }
        if (active) {
            r = this.projectContext.setValue(tag, (Object)this.getMemCache(tag));
        } else {
            this.setMemCache(tag, this.projectContext.getLongValue(tag));
            r = this.projectContext.setValue(tag, (Object)0);
        }
        return r.getContextChanges();
    }

    private void setMemCache(String tag, long l) {
        if ("flashSize".equals(tag)) {
            this.flashCache = l;
        } else {
            this.ramCache = l;
        }
    }

    private long getMemCache(String tag) {
        return "flashSize".equals(tag) ? this.flashCache : this.ramCache;
    }
}

