/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core.makefilegenerator;

import com.nxp.s32ds.ext.cdt.core.makefilegenerator.IMakefileGeneratorContributor;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.IToolConstants;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.MakefileGeneratorContributorRegistry;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.ManagedBuildCoreIDEToolInfo;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.ToolProxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class MakefileGeneratorUtil {
    public static Set<String> getOutputExtensions(ToolInfoHolder h) {
        if (h.outputExtensionsSet == null) {
            h.outputExtensionsSet = new HashSet<String>();
            int i = 0;
            while (i < h.buildTools.length) {
                ITool tool = h.buildTools[i];
                String[] outputs = tool.getAllOutputExtensions();
                if (outputs != null) {
                    h.outputExtensionsSet.addAll(Arrays.asList(outputs));
                }
                ++i;
            }
        }
        return h.outputExtensionsSet;
    }

    public static String createMakefileMacro(String macro) {
        return "$(" + macro + ")";
    }

    public static String massageToRelativePath(String primaryOutputName) {
        IPath path = Path.fromPortableString((String)primaryOutputName);
        if (path.segmentCount() == 1) {
            primaryOutputName = "./" + primaryOutputName;
        }
        return primaryOutputName;
    }

    public static String getFileName(IResource file) {
        String answer = new String();
        String lastSegment = file.getName();
        int extensionSeparator = lastSegment.lastIndexOf(".");
        if (extensionSeparator != -1) {
            answer = lastSegment.substring(0, extensionSeparator);
        }
        return answer;
    }

    public static StringBuffer getSourceMacroName(String extensionName) {
        StringBuffer macroName = new StringBuffer();
        if (extensionName.equals(extensionName.toUpperCase())) {
            macroName.append(String.valueOf(extensionName.toUpperCase()) + "_UPPER");
        } else {
            macroName.append(extensionName.toUpperCase());
        }
        macroName.append("_SRCS");
        return macroName;
    }

    public static IPath resolvePercent(IPath outPath, IPath sourceLocation) {
        String fileName = sourceLocation.removeFileExtension().lastSegment();
        String outName = outPath.toOSString().replaceAll("%", fileName);
        return Path.fromOSString((String)outName);
    }

    public static boolean needCmdArray(ITool tool) {
        ITool sTool = tool;
        while (sTool != null) {
            IOption option = sTool.getOptionBySuperClassId(String.valueOf(sTool.getId()) + ".hidden.needCmdArray");
            if (option != null) {
                Boolean b = (Boolean)option.getValue();
                return b;
            }
            sTool = sTool.getSuperClass();
        }
        return false;
    }

    public static IMakefileGeneratorContributor[] getContributors(IProject project, ITool targetTool) {
        ITool current = targetTool;
        while (current != null) {
            IMakefileGeneratorContributor[] contributors = MakefileGeneratorContributorRegistry.getDefault().getContributors(current.getId());
            if (contributors.length > 0) {
                return contributors;
            }
            current = current.getSuperClass();
        }
        IBuildObject parent = targetTool.getParent();
        if (parent instanceof IToolChain) {
            IConfiguration conf = ((IToolChain)parent).getParent();
            if (conf == null) {
                conf = ManagedBuildManager.getBuildInfo((IResource)project).getDefaultConfiguration();
            }
            return MakefileGeneratorUtil.getContributors(conf);
        }
        return null;
    }

    public static IMakefileGeneratorContributor[] getContributors(IConfiguration targetConf) {
        IConfiguration current = targetConf;
        IProjectType projectType = current.getProjectType();
        while (current != null) {
            IMakefileGeneratorContributor[] contributors = MakefileGeneratorContributorRegistry.getDefault().getContributorsForConfiguration(current.getId());
            if (contributors.length > 0) {
                return contributors;
            }
            if (projectType == null) {
                projectType = current.getProjectType();
            }
            current = current.getParent();
        }
        if (projectType != null) {
            return MakefileGeneratorUtil.getContributors(projectType);
        }
        return null;
    }

    public static IMakefileGeneratorContributor[] getContributors(IProjectType projectType) {
        IMakefileGeneratorContributor[] contributors = MakefileGeneratorContributorRegistry.getDefault().getContributorsForProjectType(projectType.getId());
        if (contributors.length > 0) {
            return contributors;
        }
        return null;
    }

    public static void removeMarkers(IResource file) {
        IMarker[] markers = null;
        try {
            markers = file.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        }
        catch (CoreException coreException) {}
        if (markers != null) {
            try {
                file.getWorkspace().deleteMarkers(markers);
            }
            catch (CoreException coreException) {}
        }
    }

    public static String getReplacementFlag(ITool tool) {
        ITool superTool = tool;
        while (superTool != null) {
            String id = superTool.getId();
            IOption option = tool.getOptionBySuperClassId(String.valueOf(id) + ".option.file_arg");
            if (option != null) {
                String value = null;
                try {
                    value = option.getStringValue();
                    value = value.replaceAll("%20", " ");
                }
                catch (BuildException buildException) {}
                return value;
            }
            superTool = superTool.getSuperClass();
        }
        return null;
    }

    public static boolean supportsMacrosInArgumentFile(ITool tool) {
        return false;
    }

    public static String convertToWildCardFormat(String list) {
        String value = IToolConstants.EMPTY_STRING;
        String[] strings = ToolProxy.mergeLinesWithQuotes(list.split(" "));
        ArrayList<String> genericValues = new ArrayList<String>();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            String ext = str.substring(str.lastIndexOf("."));
            String[] segs = str.split("/");
            str = IToolConstants.EMPTY_STRING;
            int i = 0;
            while (i < segs.length - 1) {
                if (segs[i].equals(".") || segs[i].equals("\".")) {
                    str = String.valueOf(str) + segs[i] + "/";
                } else {
                    if (segs[i].startsWith("\"")) {
                        str = String.valueOf(str) + "\"";
                    }
                    str = String.valueOf(str) + "*/";
                }
                ++i;
            }
            str = ext != null && ext.length() > 0 ? String.valueOf(str) + "*" + ext : String.valueOf(str) + segs[segs.length - 1];
            if (str.length() > 0 && !genericValues.contains(str)) {
                genericValues.add(str);
            }
            ++n2;
        }
        if (!genericValues.isEmpty()) {
            for (String str : genericValues) {
                value = String.valueOf(value) + str + " ";
            }
        }
        return value;
    }

    public static boolean isSecondaryOutputVar(ToolInfoHolder h, IOutputType[] secondaryOutputs, String varName) {
        ITool[] buildTools = h.buildTools;
        int i = 0;
        while (i < buildTools.length) {
            IOutputType[] outTypes = buildTools[i].getOutputTypes();
            if (outTypes != null && outTypes.length > 0) {
                int j = 0;
                while (j < outTypes.length) {
                    IOutputType outType = outTypes[j];
                    int k = 0;
                    while (k < secondaryOutputs.length) {
                        IOutputType matchType = outType;
                        do {
                            if (!matchType.getId().equals(secondaryOutputs[k].getId()) || !outType.getBuildVariable().equals(varName)) continue;
                            return true;
                        } while ((matchType = matchType.getSuperClass()) != null);
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public static String generateUniquePatternRule(String output, Vector<String> otherOutputs) {
        String preferedDelimiters = Path.fromOSString((String)output).lastSegment();
        int index = preferedDelimiters.lastIndexOf(".");
        if (index != -1) {
            preferedDelimiters = "." + preferedDelimiters;
        }
        int i = 0;
        while (i < preferedDelimiters.length()) {
            char commonCharacter = preferedDelimiters.charAt(i);
            boolean characterIsCommonToAllOutputs = true;
            for (String otherOutput : otherOutputs) {
                if (otherOutput.indexOf(commonCharacter) != -1) continue;
                characterIsCommonToAllOutputs = false;
                break;
            }
            if (characterIsCommonToAllOutputs) {
                int indexToReplace = output.lastIndexOf(commonCharacter);
                String newOutput = String.valueOf(output.substring(0, indexToReplace)) + "%";
                if (indexToReplace + 1 < output.length()) {
                    newOutput = String.valueOf(newOutput) + output.substring(indexToReplace + 1);
                }
                return newOutput;
            }
            ++i;
        }
        return output;
    }

    public static Vector<String> generateUniquePatternRuleCache(Vector<String> enumeratedPrimaryOutputs) {
        Vector<String> result = new Vector<String>();
        for (String output : enumeratedPrimaryOutputs) {
            result.add(Path.fromPortableString((String)output).lastSegment());
        }
        return result;
    }

    public static String massageResolvedCommand(String resolvedCommand) {
        if (Platform.getOS().equals("win32")) {
            String buildCmd = resolvedCommand.startsWith("/") ? resolvedCommand.substring(1) : (resolvedCommand.startsWith("\"/") ? "\"" + resolvedCommand.substring(2) : resolvedCommand);
            return buildCmd;
        }
        return resolvedCommand;
    }

    public static String massageCommandLinePattern(ITool tool) {
        String command = tool.getCommandLinePattern();
        Pattern pattern = Pattern.compile(".*?(\\$\\{.*\\})+([/\\\\]*)\\$\\{COMMAND\\}");
        Matcher matcher = pattern.matcher(command);
        if (matcher.find()) {
            String variables = matcher.group(1);
            String separator = matcher.group(2);
            if (separator.isEmpty()) {
                try {
                    String value = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(variables, IToolConstants.EMPTY_STRING, " ", 1, (Object)new FileContextData(null, null, null, (IBuildObject)tool));
                    if (value != null && !value.endsWith("/") && !value.endsWith("\\")) {
                        command = command.replace(variables, String.valueOf(variables) + '/');
                    }
                }
                catch (BuildMacroException buildMacroException) {
                    return command;
                }
            }
        }
        return command;
    }

    public static boolean hasGenMakeBuilder(IProject project) throws CoreException {
        ICommand[] commands;
        ICommand[] iCommandArray = commands = project.getDescription().getBuildSpec();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            String name = command.getBuilderName();
            if (name.equals("org.eclipse.cdt.managedbuilder.core.genmakebuilder")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static class ToolInfoHolder {
        ITool[] buildTools;
        boolean[] buildToolsUsed;
        ManagedBuildCoreIDEToolInfo[] gnuToolInfos;
        Set<String> outputExtensionsSet;
        List<IPath> dependencyMakefiles;
    }
}

