/*
** ###################################################################
**     Processors:          MIMXRT1176AVM8A_cm7
**                          MIMXRT1176CVM8A_cm7
**                          MIMXRT1176DVMAA_cm7
**
**     Compilers:           Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**                          Keil ARM C/C++ Compiler
**                          MCUXpresso Compiler
**
**     Reference manual:    IMXRT1170RM, Rev 1, 02/2021
**     Version:             rev. 1.0, 2020-12-29
**     Build:               b210420
**
**     Abstract:
**         CMSIS Peripheral Access Layer for MIMXRT1176_cm7
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2021 NXP
**     All rights reserved.
**
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 0.1 (2018-03-05)
**         Initial version.
**     - rev. 1.0 (2020-12-29)
**         Update header files to align with IMXRT1170RM Rev.0.
**
** ###################################################################
*/

/*!
 * @file MIMXRT1176_cm7.h
 * @version 1.0
 * @date 2020-12-29
 * @brief CMSIS Peripheral Access Layer for MIMXRT1176_cm7
 *
 * CMSIS Peripheral Access Layer for MIMXRT1176_cm7
 */

#ifndef _MIMXRT1176_CM7_H_
#define _MIMXRT1176_CM7_H_                       /**< Symbol preventing repeated inclusion */

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0100U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0000U

/* ----------------------------------------------------------------------------
   --
   ---------------------------------------------------------------------------- */

/* Extra XRDC2 definition */
#define XRDC2_MAKE_M7_AXI_MATCH(processorID, instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(processorID) << 6U)          | \
     ((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_M4_AHBC_MATCH(processorID, instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(processorID) << 6U)          | \
     ((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_M7_AHB_MATCH(isDebugger, instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(isDebugger) << 6U)           | \
     ((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_M4_AHBS_MATCH(processorID, instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(processorID) << 6U)          | \
     ((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_M7_EDMA_MATCH(dmaChannel, dmaMaster, instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(dmaChannel) << 10U)          | \
     ((uint16_t)(dmaMaster) << 6U)            | \
     ((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_M4_EDMA_MATCH(dmaChannel, dmaMaster, instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(dmaChannel) << 10U)          | \
     ((uint16_t)(dmaMaster) << 6U)            | \
     ((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_CSI_MATCH(instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_LCDIF_MATCH(instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_LCDIFV2_MATCH(instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_PXP_MATCH(instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_GPU_MATCH(instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_USB_MATCH(instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_USDHC1_MATCH(instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_USDHC2_MATCH(instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_ENET_QOS_MATCH(instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_ENET_MATCH(instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_ENET_1G_TX_MATCH(instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_ENET_1G_RX_MATCH(instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_CAAM_MATCH(aricID, instructionFetch, sandbox, regionMatch, regionID) \
    (((uint16_t)(aricID) << 6U)               | \
     ((uint16_t)(regionID) << 0U)             | \
     ((uint16_t)(regionMatch) << 3U)          | \
     ((uint16_t)(sandbox) << 4U)              | \
     ((uint16_t)(instructionFetch) << 5U))
#define XRDC2_MAKE_MEM(mrc, mrgd) (((mrc) << 5U) | mrgd)
#define XRDC2_GET_MRC(mem) ((mem) >> 5U)
#define XRDC2_GET_MRGD(mem) ((mem) & 31U)
#define XRDC2_MAKE_PERIPH(pac, pdac) (((pac) << 8U) | pdac)
#define XRDC2_GET_PAC(periph) ((periph) >> 8U)
#define XRDC2_GET_PDAC(periph) ((periph) & 255U)



/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 234                /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Auxiliary constants */
  NotAvail_IRQn                = -128,             /**< Not available device specific interrupt */

  /* Core interrupts */
  NonMaskableInt_IRQn          = -14,              /**< Non Maskable Interrupt */
  HardFault_IRQn               = -13,              /**< Cortex-M7 SV Hard Fault Interrupt */
  MemoryManagement_IRQn        = -12,              /**< Cortex-M7 Memory Management Interrupt */
  BusFault_IRQn                = -11,              /**< Cortex-M7 Bus Fault Interrupt */
  UsageFault_IRQn              = -10,              /**< Cortex-M7 Usage Fault Interrupt */
  SVCall_IRQn                  = -5,               /**< Cortex-M7 SV Call Interrupt */
  DebugMonitor_IRQn            = -4,               /**< Cortex-M7 Debug Monitor Interrupt */
  PendSV_IRQn                  = -2,               /**< Cortex-M7 Pend SV Interrupt */
  SysTick_IRQn                 = -1,               /**< Cortex-M7 System Tick Interrupt */

  /* Device specific interrupts */
  DMA0_DMA16_IRQn              = 0,                /**< DMA channel 0/16 transfer complete */
  DMA1_DMA17_IRQn              = 1,                /**< DMA channel 1/17 transfer complete */
  DMA2_DMA18_IRQn              = 2,                /**< DMA channel 2/18 transfer complete */
  DMA3_DMA19_IRQn              = 3,                /**< DMA channel 3/19 transfer complete */
  DMA4_DMA20_IRQn              = 4,                /**< DMA channel 4/20 transfer complete */
  DMA5_DMA21_IRQn              = 5,                /**< DMA channel 5/21 transfer complete */
  DMA6_DMA22_IRQn              = 6,                /**< DMA channel 6/22 transfer complete */
  DMA7_DMA23_IRQn              = 7,                /**< DMA channel 7/23 transfer complete */
  DMA8_DMA24_IRQn              = 8,                /**< DMA channel 8/24 transfer complete */
  DMA9_DMA25_IRQn              = 9,                /**< DMA channel 9/25 transfer complete */
  DMA10_DMA26_IRQn             = 10,               /**< DMA channel 10/26 transfer complete */
  DMA11_DMA27_IRQn             = 11,               /**< DMA channel 11/27 transfer complete */
  DMA12_DMA28_IRQn             = 12,               /**< DMA channel 12/28 transfer complete */
  DMA13_DMA29_IRQn             = 13,               /**< DMA channel 13/29 transfer complete */
  DMA14_DMA30_IRQn             = 14,               /**< DMA channel 14/30 transfer complete */
  DMA15_DMA31_IRQn             = 15,               /**< DMA channel 15/31 transfer complete */
  DMA_ERROR_IRQn               = 16,               /**< DMA error interrupt channels 0-15 / 16-31 */
  CTI_TRIGGER_OUT0_IRQn        = 17,               /**< CTI_TRIGGER_OUT0 */
  CTI_TRIGGER_OUT1_IRQn        = 18,               /**< CTI_TRIGGER_OUT1 */
  CORE_IRQn                    = 19,               /**< CorePlatform exception IRQ */
  LPUART1_IRQn                 = 20,               /**< LPUART1 TX interrupt and RX interrupt */
  LPUART2_IRQn                 = 21,               /**< LPUART2 TX interrupt and RX interrupt */
  LPUART3_IRQn                 = 22,               /**< LPUART3 TX interrupt and RX interrupt */
  LPUART4_IRQn                 = 23,               /**< LPUART4 TX interrupt and RX interrupt */
  LPUART5_IRQn                 = 24,               /**< LPUART5 TX interrupt and RX interrupt */
  LPUART6_IRQn                 = 25,               /**< LPUART6 TX interrupt and RX interrupt */
  LPUART7_IRQn                 = 26,               /**< LPUART7 TX interrupt and RX interrupt */
  LPUART8_IRQn                 = 27,               /**< LPUART8 TX interrupt and RX interrupt */
  LPUART9_IRQn                 = 28,               /**< LPUART9 TX interrupt and RX interrupt */
  LPUART10_IRQn                = 29,               /**< LPUART10 TX interrupt and RX interrupt */
  LPUART11_IRQn                = 30,               /**< LPUART11 TX interrupt and RX interrupt */
  LPUART12_IRQn                = 31,               /**< LPUART12 TX interrupt and RX interrupt */
  LPI2C1_IRQn                  = 32,               /**< LPI2C1 interrupt */
  LPI2C2_IRQn                  = 33,               /**< LPI2C2 interrupt */
  LPI2C3_IRQn                  = 34,               /**< LPI2C3 interrupt */
  LPI2C4_IRQn                  = 35,               /**< LPI2C4 interrupt */
  LPI2C5_IRQn                  = 36,               /**< LPI2C5 interrupt */
  LPI2C6_IRQn                  = 37,               /**< LPI2C6 interrupt */
  LPSPI1_IRQn                  = 38,               /**< LPSPI1 interrupt request line to the core */
  LPSPI2_IRQn                  = 39,               /**< LPSPI2 interrupt request line to the core */
  LPSPI3_IRQn                  = 40,               /**< LPSPI3 interrupt request line to the core */
  LPSPI4_IRQn                  = 41,               /**< LPSPI4 interrupt request line to the core */
  LPSPI5_IRQn                  = 42,               /**< LPSPI5 interrupt request line to the core */
  LPSPI6_IRQn                  = 43,               /**< LPSPI6 interrupt request line to the core */
  CAN1_IRQn                    = 44,               /**< CAN1 interrupt */
  CAN1_ERROR_IRQn              = 45,               /**< CAN1 error interrupt */
  CAN2_IRQn                    = 46,               /**< CAN2 interrupt */
  CAN2_ERROR_IRQn              = 47,               /**< CAN2 error interrupt */
  CAN3_IRQn                    = 48,               /**< CAN3 interrupt */
  CAN3_ERROR_IRQn              = 49,               /**< CAN3 erro interrupt */
  FLEXRAM_IRQn                 = 50,               /**< FlexRAM address out of range Or access hit IRQ */
  KPP_IRQn                     = 51,               /**< Keypad nterrupt */
  Reserved68_IRQn              = 52,               /**< Reserved interrupt */
  GPR_IRQ_IRQn                 = 53,               /**< GPR interrupt */
  eLCDIF_IRQn                  = 54,               /**< eLCDIF interrupt */
  LCDIFv2_IRQn                 = 55,               /**< LCDIFv2 interrupt */
  CSI_IRQn                     = 56,               /**< CSI interrupt */
  PXP_IRQn                     = 57,               /**< PXP interrupt */
  MIPI_CSI_IRQn                = 58,               /**< MIPI_CSI interrupt */
  MIPI_DSI_IRQn                = 59,               /**< MIPI_DSI interrupt */
  GPU2D_IRQn                   = 60,               /**< GPU2D interrupt */
  GPIO6_Combined_0_15_IRQn     = 61,               /**< Combined interrupt indication for GPIO6 signal 0 throughout 15 */
  GPIO6_Combined_16_31_IRQn    = 62,               /**< Combined interrupt indication for GPIO6 signal 16 throughout 31 */
  DAC_IRQn                     = 63,               /**< DAC interrupt */
  KEY_MANAGER_IRQn             = 64,               /**< PUF interrupt */
  WDOG2_IRQn                   = 65,               /**< WDOG2 interrupt */
  SNVS_HP_NON_TZ_IRQn          = 66,               /**< SRTC Consolidated Interrupt. Non TZ */
  SNVS_HP_TZ_IRQn              = 67,               /**< SRTC Security Interrupt. TZ */
  SNVS_PULSE_EVENT_IRQn        = 68,               /**< ON-OFF button press shorter than 5 secs (pulse event) */
  CAAM_IRQ0_IRQn               = 69,               /**< CAAM interrupt queue for JQ0 */
  CAAM_IRQ1_IRQn               = 70,               /**< CAAM interrupt queue for JQ1 */
  CAAM_IRQ2_IRQn               = 71,               /**< CAAM interrupt queue for JQ2 */
  CAAM_IRQ3_IRQn               = 72,               /**< CAAM interrupt queue for JQ3 */
  CAAM_RECORVE_ERRPR_IRQn      = 73,               /**< CAAM interrupt for recoverable error */
  CAAM_RTIC_IRQn               = 74,               /**< CAAM interrupt for RTIC */
  CDOG_IRQn                    = 75,               /**< CDOG interrupt */
  SAI1_IRQn                    = 76,               /**< SAI1 interrupt */
  SAI2_IRQn                    = 77,               /**< SAI1 interrupt */
  SAI3_RX_IRQn                 = 78,               /**< SAI3 interrupt */
  SAI3_TX_IRQn                 = 79,               /**< SAI3 interrupt */
  SAI4_RX_IRQn                 = 80,               /**< SAI4 interrupt */
  SAI4_TX_IRQn                 = 81,               /**< SAI4 interrupt */
  SPDIF_IRQn                   = 82,               /**< SPDIF interrupt */
  TMPSNS_INT_IRQn              = 83,               /**< TMPSNS interrupt */
  TMPSNS_LOW_HIGH_IRQn         = 84,               /**< TMPSNS low high interrupt */
  TMPSNS_PANIC_IRQn            = 85,               /**< TMPSNS panic interrupt */
  LPSR_LP8_BROWNOUT_IRQn       = 86,               /**< LPSR 1p8 brownout interrupt */
  LPSR_LP0_BROWNOUT_IRQn       = 87,               /**< LPSR 1p0 brownout interrupt */
  ADC1_IRQn                    = 88,               /**< ADC1 interrupt */
  ADC2_IRQn                    = 89,               /**< ADC2 interrupt */
  USBPHY1_IRQn                 = 90,               /**< USBPHY1 interrupt */
  USBPHY2_IRQn                 = 91,               /**< USBPHY2 interrupt */
  RDC_IRQn                     = 92,               /**< RDC interrupt */
  GPIO13_Combined_0_31_IRQn    = 93,               /**< Combined interrupt indication for GPIO13 signal 0 throughout 31 */
  Reserved110_IRQn             = 94,               /**< Reserved interrupt */
  DCIC1_IRQn                   = 95,               /**< DCIC1 interrupt */
  DCIC2_IRQn                   = 96,               /**< DCIC2 interrupt */
  ASRC_IRQn                    = 97,               /**< ASRC interrupt */
  FLEXRAM_ECC_IRQn             = 98,               /**< FlexRAM ECC fatal interrupt */
  CM7_GPIO2_3_IRQn             = 99,               /**< CM7_GPIO2,CM7_GPIO3 interrupt */
  GPIO1_Combined_0_15_IRQn     = 100,              /**< Combined interrupt indication for GPIO1 signal 0 throughout 15 */
  GPIO1_Combined_16_31_IRQn    = 101,              /**< Combined interrupt indication for GPIO1 signal 16 throughout 31 */
  GPIO2_Combined_0_15_IRQn     = 102,              /**< Combined interrupt indication for GPIO2 signal 0 throughout 15 */
  GPIO2_Combined_16_31_IRQn    = 103,              /**< Combined interrupt indication for GPIO2 signal 16 throughout 31 */
  GPIO3_Combined_0_15_IRQn     = 104,              /**< Combined interrupt indication for GPIO3 signal 0 throughout 15 */
  GPIO3_Combined_16_31_IRQn    = 105,              /**< Combined interrupt indication for GPIO3 signal 16 throughout 31 */
  GPIO4_Combined_0_15_IRQn     = 106,              /**< Combined interrupt indication for GPIO4 signal 0 throughout 15 */
  GPIO4_Combined_16_31_IRQn    = 107,              /**< Combined interrupt indication for GPIO4 signal 16 throughout 31 */
  GPIO5_Combined_0_15_IRQn     = 108,              /**< Combined interrupt indication for GPIO5 signal 0 throughout 15 */
  GPIO5_Combined_16_31_IRQn    = 109,              /**< Combined interrupt indication for GPIO5 signal 16 throughout 31 */
  FLEXIO1_IRQn                 = 110,              /**< FLEXIO1 interrupt */
  FLEXIO2_IRQn                 = 111,              /**< FLEXIO2 interrupt */
  WDOG1_IRQn                   = 112,              /**< WDOG1 interrupt */
  RTWDOG3_IRQn                 = 113,              /**< RTWDOG3 interrupt */
  EWM_IRQn                     = 114,              /**< EWM interrupt */
  OCOTP_READ_FUSE_ERROR_IRQn   = 115,              /**< OCOTP read fuse error interrupt */
  OCOTP_READ_DONE_ERROR_IRQn   = 116,              /**< OCOTP read fuse done interrupt */
  GPC_IRQn                     = 117,              /**< GPC interrupt */
  MUA_IRQn                     = 118,              /**< MUA interrupt */
  GPT1_IRQn                    = 119,              /**< GPT1 interrupt */
  GPT2_IRQn                    = 120,              /**< GPT2 interrupt */
  GPT3_IRQn                    = 121,              /**< GPT3 interrupt */
  GPT4_IRQn                    = 122,              /**< GPT4 interrupt */
  GPT5_IRQn                    = 123,              /**< GPT5 interrupt */
  GPT6_IRQn                    = 124,              /**< GPT6 interrupt */
  PWM1_0_IRQn                  = 125,              /**< PWM1 capture 0, compare 0, or reload 0 interrupt */
  PWM1_1_IRQn                  = 126,              /**< PWM1 capture 1, compare 1, or reload 0 interrupt */
  PWM1_2_IRQn                  = 127,              /**< PWM1 capture 2, compare 2, or reload 0 interrupt */
  PWM1_3_IRQn                  = 128,              /**< PWM1 capture 3, compare 3, or reload 0 interrupt */
  PWM1_FAULT_IRQn              = 129,              /**< PWM1 fault or reload error interrupt */
  FLEXSPI1_IRQn                = 130,              /**< FlexSPI1 interrupt */
  FLEXSPI2_IRQn                = 131,              /**< FlexSPI2 interrupt */
  SEMC_IRQn                    = 132,              /**< SEMC interrupt */
  USDHC1_IRQn                  = 133,              /**< USDHC1 interrupt */
  USDHC2_IRQn                  = 134,              /**< USDHC2 interrupt */
  USB_OTG2_IRQn                = 135,              /**< USBO2 USB OTG2 */
  USB_OTG1_IRQn                = 136,              /**< USBO2 USB OTG1 */
  ENET_IRQn                    = 137,              /**< ENET interrupt */
  ENET_1588_Timer_IRQn         = 138,              /**< ENET_1588_Timer interrupt */
  ENET_1G_MAC0_Tx_Rx_1_IRQn    = 139,              /**< ENET 1G MAC0 transmit/receive 1 */
  ENET_1G_MAC0_Tx_Rx_2_IRQn    = 140,              /**< ENET 1G MAC0 transmit/receive 2 */
  ENET_1G_IRQn                 = 141,              /**< ENET 1G interrupt */
  ENET_1G_1588_Timer_IRQn      = 142,              /**< ENET_1G_1588_Timer interrupt */
  XBAR1_IRQ_0_1_IRQn           = 143,              /**< XBAR1 interrupt */
  XBAR1_IRQ_2_3_IRQn           = 144,              /**< XBAR1 interrupt */
  ADC_ETC_IRQ0_IRQn            = 145,              /**< ADCETC IRQ0 interrupt */
  ADC_ETC_IRQ1_IRQn            = 146,              /**< ADCETC IRQ1 interrupt */
  ADC_ETC_IRQ2_IRQn            = 147,              /**< ADCETC IRQ2 interrupt */
  ADC_ETC_IRQ3_IRQn            = 148,              /**< ADCETC IRQ3 interrupt */
  ADC_ETC_ERROR_IRQ_IRQn       = 149,              /**< ADCETC Error IRQ interrupt */
  Reserved166_IRQn             = 150,              /**< Reserved interrupt */
  Reserved167_IRQn             = 151,              /**< Reserved interrupt */
  Reserved168_IRQn             = 152,              /**< Reserved interrupt */
  Reserved169_IRQn             = 153,              /**< Reserved interrupt */
  Reserved170_IRQn             = 154,              /**< Reserved interrupt */
  PIT1_IRQn                    = 155,              /**< PIT1 interrupt */
  PIT2_IRQn                    = 156,              /**< PIT2 interrupt */
  ACMP1_IRQn                   = 157,              /**< ACMP interrupt */
  ACMP2_IRQn                   = 158,              /**< ACMP interrupt */
  ACMP3_IRQn                   = 159,              /**< ACMP interrupt */
  ACMP4_IRQn                   = 160,              /**< ACMP interrupt */
  Reserved177_IRQn             = 161,              /**< Reserved interrupt */
  Reserved178_IRQn             = 162,              /**< Reserved interrupt */
  Reserved179_IRQn             = 163,              /**< Reserved interrupt */
  Reserved180_IRQn             = 164,              /**< Reserved interrupt */
  ENC1_IRQn                    = 165,              /**< ENC1 interrupt */
  ENC2_IRQn                    = 166,              /**< ENC2 interrupt */
  ENC3_IRQn                    = 167,              /**< ENC3 interrupt */
  ENC4_IRQn                    = 168,              /**< ENC4 interrupt */
  Reserved185_IRQn             = 169,              /**< Reserved interrupt */
  Reserved186_IRQn             = 170,              /**< Reserved interrupt */
  TMR1_IRQn                    = 171,              /**< TMR1 interrupt */
  TMR2_IRQn                    = 172,              /**< TMR2 interrupt */
  TMR3_IRQn                    = 173,              /**< TMR3 interrupt */
  TMR4_IRQn                    = 174,              /**< TMR4 interrupt */
  SEMA4_CP0_IRQn               = 175,              /**< SEMA4 CP0 interrupt */
  SEMA4_CP1_IRQn               = 176,              /**< SEMA4 CP1 interrupt */
  PWM2_0_IRQn                  = 177,              /**< PWM2 capture 0, compare 0, or reload 0 interrupt */
  PWM2_1_IRQn                  = 178,              /**< PWM2 capture 1, compare 1, or reload 0 interrupt */
  PWM2_2_IRQn                  = 179,              /**< PWM2 capture 2, compare 2, or reload 0 interrupt */
  PWM2_3_IRQn                  = 180,              /**< PWM2 capture 3, compare 3, or reload 0 interrupt */
  PWM2_FAULT_IRQn              = 181,              /**< PWM2 fault or reload error interrupt */
  PWM3_0_IRQn                  = 182,              /**< PWM3 capture 0, compare 0, or reload 0 interrupt */
  PWM3_1_IRQn                  = 183,              /**< PWM3 capture 1, compare 1, or reload 0 interrupt */
  PWM3_2_IRQn                  = 184,              /**< PWM3 capture 2, compare 2, or reload 0 interrupt */
  PWM3_3_IRQn                  = 185,              /**< PWM3 capture 3, compare 3, or reload 0 interrupt */
  PWM3_FAULT_IRQn              = 186,              /**< PWM3 fault or reload error interrupt */
  PWM4_0_IRQn                  = 187,              /**< PWM4 capture 0, compare 0, or reload 0 interrupt */
  PWM4_1_IRQn                  = 188,              /**< PWM4 capture 1, compare 1, or reload 0 interrupt */
  PWM4_2_IRQn                  = 189,              /**< PWM4 capture 2, compare 2, or reload 0 interrupt */
  PWM4_3_IRQn                  = 190,              /**< PWM4 capture 3, compare 3, or reload 0 interrupt */
  PWM4_FAULT_IRQn              = 191,              /**< PWM4 fault or reload error interrupt */
  Reserved208_IRQn             = 192,              /**< Reserved interrupt */
  Reserved209_IRQn             = 193,              /**< Reserved interrupt */
  Reserved210_IRQn             = 194,              /**< Reserved interrupt */
  Reserved211_IRQn             = 195,              /**< Reserved interrupt */
  Reserved212_IRQn             = 196,              /**< Reserved interrupt */
  Reserved213_IRQn             = 197,              /**< Reserved interrupt */
  Reserved214_IRQn             = 198,              /**< Reserved interrupt */
  Reserved215_IRQn             = 199,              /**< Reserved interrupt */
  HWVAD_EVENT_IRQn             = 200,              /**< HWVAD event interrupt */
  HWVAD_ERROR_IRQn             = 201,              /**< HWVAD error interrupt */
  PDM_EVENT_IRQn               = 202,              /**< PDM event interrupt */
  PDM_ERROR_IRQn               = 203,              /**< PDM error interrupt */
  EMVSIM1_IRQn                 = 204,              /**< EMVSIM1 interrupt */
  EMVSIM2_IRQn                 = 205,              /**< EMVSIM2 interrupt */
  MECC1_INT_IRQn               = 206,              /**< MECC1 int */
  MECC1_FATAL_INT_IRQn         = 207,              /**< MECC1 fatal int */
  MECC2_INT_IRQn               = 208,              /**< MECC2 int */
  MECC2_FATAL_INT_IRQn         = 209,              /**< MECC2 fatal int */
  XECC_FLEXSPI1_INT_IRQn       = 210,              /**< XECC int */
  XECC_FLEXSPI1_FATAL_INT_IRQn = 211,              /**< XECC fatal int */
  XECC_FLEXSPI2_INT_IRQn       = 212,              /**< XECC int */
  XECC_FLEXSPI2_FATAL_INT_IRQn = 213,              /**< XECC fatal int */
  XECC_SEMC_INT_IRQn           = 214,              /**< XECC int */
  XECC_SEMC_FATAL_INT_IRQn     = 215,              /**< XECC fatal int */
  ENET_QOS_IRQn                = 216,              /**< ENET_QOS interrupt */
  ENET_QOS_PMT_IRQn            = 217               /**< ENET_QOS_PMT interrupt */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Cortex M7 Core Configuration
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Cortex_Core_Configuration Cortex M7 Core Configuration
 * @{
 */

#define __MPU_PRESENT                  1         /**< Defines if an MPU is present or not */
#define __ICACHE_PRESENT               1         /**< Defines if an ICACHE is present or not */
#define __DCACHE_PRESENT               1         /**< Defines if an DCACHE is present or not */
#define __DTCM_PRESENT                 1         /**< Defines if an DTCM is present or not */
#define __NVIC_PRIO_BITS               4         /**< Number of priority bits implemented in the NVIC */
#define __Vendor_SysTickConfig         0         /**< Vendor specific implementation of SysTickConfig is defined */
#define __FPU_PRESENT                  1         /**< Defines if an FPU is present or not */

#include "core_cm7.h"                  /* Core Peripheral Access Layer */
#include "system_MIMXRT1176_cm7.h"     /* Device specific configuration file */

/*!
 * @}
 */ /* end of group Cortex_Core_Configuration */


/* ----------------------------------------------------------------------------
   -- Mapping Information
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Mapping_Information Mapping Information
 * @{
 */

/** Mapping Information */
/*!
 * @addtogroup rdc_mapping
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the RDC mapping
 *
 * Defines the structure for the RDC resource collections.
 */
/*
 * Domain of these masters are not assigned by RDC
 * CM7, CM7_DMA: Always use domain ID 0.
 * CM4, CM4_DMA: Use domain ID 0 in single core case, 1 in dual core case.
 * CAAM: Defined in CAAM mst_a[x]icid[10]
 * LCDIFv2: Defined in LCDIF2 user bit[0]
 * SSARC: Defined in SSARC user bit[0]
 */

typedef enum _rdc_master
{
    kRDC_Master_ENET_1G_TX          = 1U,          /**< ENET_1G_TX */
    kRDC_Master_ENET_1G_RX          = 2U,          /**< ENET_1G_RX */
    kRDC_Master_ENET                = 3U,          /**< ENET */
    kRDC_Master_ENET_QOS            = 4U,          /**< ENET_QOS */
    kRDC_Master_USDHC1              = 5U,          /**< USDHC1 */
    kRDC_Master_USDHC2              = 6U,          /**< USDHC2 */
    kRDC_Master_USB                 = 7U,          /**< USB */
    kRDC_Master_GPU                 = 8U,          /**< GPU */
    kRDC_Master_PXP                 = 9U,          /**< PXP */
    kRDC_Master_LCDIF               = 10U,         /**< LCDIF */
    kRDC_Master_CSI                 = 11U,         /**< CSI */
} rdc_master_t;

typedef enum _rdc_mem
{
    kRDC_Mem_MRC0_0                 = 0U,
    kRDC_Mem_MRC0_1                 = 1U,
    kRDC_Mem_MRC0_2                 = 2U,
    kRDC_Mem_MRC0_3                 = 3U,
    kRDC_Mem_MRC0_4                 = 4U,
    kRDC_Mem_MRC0_5                 = 5U,
    kRDC_Mem_MRC0_6                 = 6U,
    kRDC_Mem_MRC0_7                 = 7U,
    kRDC_Mem_MRC1_0                 = 8U,
    kRDC_Mem_MRC1_1                 = 9U,
    kRDC_Mem_MRC1_2                 = 10U,
    kRDC_Mem_MRC1_3                 = 11U,
    kRDC_Mem_MRC1_4                 = 12U,
    kRDC_Mem_MRC1_5                 = 13U,
    kRDC_Mem_MRC1_6                 = 14U,
    kRDC_Mem_MRC1_7                 = 15U,
    kRDC_Mem_MRC2_0                 = 16U,
    kRDC_Mem_MRC2_1                 = 17U,
    kRDC_Mem_MRC2_2                 = 18U,
    kRDC_Mem_MRC2_3                 = 19U,
    kRDC_Mem_MRC2_4                 = 20U,
    kRDC_Mem_MRC2_5                 = 21U,
    kRDC_Mem_MRC2_6                 = 22U,
    kRDC_Mem_MRC2_7                 = 23U,
    kRDC_Mem_MRC3_0                 = 24U,
    kRDC_Mem_MRC3_1                 = 25U,
    kRDC_Mem_MRC3_2                 = 26U,
    kRDC_Mem_MRC3_3                 = 27U,
    kRDC_Mem_MRC3_4                 = 28U,
    kRDC_Mem_MRC3_5                 = 29U,
    kRDC_Mem_MRC3_6                 = 30U,
    kRDC_Mem_MRC3_7                 = 31U,
    kRDC_Mem_MRC4_0                 = 32U,
    kRDC_Mem_MRC4_1                 = 33U,
    kRDC_Mem_MRC4_2                 = 34U,
    kRDC_Mem_MRC4_3                 = 35U,
    kRDC_Mem_MRC4_4                 = 36U,
    kRDC_Mem_MRC4_5                 = 37U,
    kRDC_Mem_MRC4_6                 = 38U,
    kRDC_Mem_MRC4_7                 = 39U,
    kRDC_Mem_MRC5_0                 = 40U,
    kRDC_Mem_MRC5_1                 = 41U,
    kRDC_Mem_MRC5_2                 = 42U,
    kRDC_Mem_MRC5_3                 = 43U,
    kRDC_Mem_MRC6_0                 = 44U,
    kRDC_Mem_MRC6_1                 = 45U,
    kRDC_Mem_MRC6_2                 = 46U,
    kRDC_Mem_MRC6_3                 = 47U,
    kRDC_Mem_MRC7_0                 = 48U,
    kRDC_Mem_MRC7_1                 = 49U,
    kRDC_Mem_MRC7_2                 = 50U,
    kRDC_Mem_MRC7_3                 = 51U,
    kRDC_Mem_MRC7_4                 = 52U,
    kRDC_Mem_MRC7_5                 = 53U,
    kRDC_Mem_MRC7_6                 = 54U,
    kRDC_Mem_MRC7_7                 = 55U,
    kRDC_Mem_MRC8_0                 = 56U,
    kRDC_Mem_MRC8_1                 = 57U,
    kRDC_Mem_MRC8_2                 = 58U,
} rdc_mem_t;

typedef enum _rdc_periph
{
    kRDC_Periph_MTR                 = 0U,          /**< MTR */
    kRDC_Periph_MECC1               = 1U,          /**< MECC1 */
    kRDC_Periph_MECC2               = 2U,          /**< MECC2 */
    kRDC_Periph_FLEXSPI1            = 3U,          /**< FlexSPI1 */
    kRDC_Periph_FLEXSPI2            = 4U,          /**< FlexSPI2 */
    kRDC_Periph_SEMC                = 5U,          /**< SEMC */
    kRDC_Periph_CM7_IMXRT           = 6U,          /**< CM7_IMXRT */
    kRDC_Periph_EWM                 = 7U,          /**< EWM */
    kRDC_Periph_WDOG1               = 8U,          /**< WDOG1 */
    kRDC_Periph_WDOG2               = 9U,          /**< WDOG2 */
    kRDC_Periph_WDOG3               = 10U,         /**< WDOG3 */
    kRDC_Periph_AOI_XBAR            = 11U,         /**< AOI_XBAR */
    kRDC_Periph_ADC_ETC             = 12U,         /**< ADC_ETC */
    kRDC_Periph_CAAM_1              = 13U,         /**< CAAM_1 */
    kRDC_Periph_ADC1                = 14U,         /**< ADC1 */
    kRDC_Periph_ADC2                = 15U,         /**< ADC2 */
    kRDC_Periph_TSC_DIG             = 16U,         /**< TSC_DIG */
    kRDC_Periph_DAC                 = 17U,         /**< DAC */
    kRDC_Periph_IEE                 = 18U,         /**< IEE */
    kRDC_Periph_DMAMUX              = 19U,         /**< DMAMUX */
    kRDC_Periph_EDMA                = 19U,         /**< EDMA */
    kRDC_Periph_LPUART1             = 20U,         /**< LPUART1 */
    kRDC_Periph_LPUART2             = 21U,         /**< LPUART2 */
    kRDC_Periph_LPUART3             = 22U,         /**< LPUART3 */
    kRDC_Periph_LPUART4             = 23U,         /**< LPUART4 */
    kRDC_Periph_LPUART5             = 24U,         /**< LPUART5 */
    kRDC_Periph_LPUART6             = 25U,         /**< LPUART6 */
    kRDC_Periph_LPUART7             = 26U,         /**< LPUART7 */
    kRDC_Periph_LPUART8             = 27U,         /**< LPUART8 */
    kRDC_Periph_LPUART9             = 28U,         /**< LPUART9 */
    kRDC_Periph_LPUART10            = 29U,         /**< LPUART10 */
    kRDC_Periph_FLEXIO1             = 30U,         /**< FlexIO1 */
    kRDC_Periph_FLEXIO2             = 31U,         /**< FlexIO2 */
    kRDC_Periph_CAN1                = 32U,         /**< CAN1 */
    kRDC_Periph_CAN2                = 33U,         /**< CAN2 */
    kRDC_Periph_PIT1                = 34U,         /**< PIT1 */
    kRDC_Periph_KPP                 = 35U,         /**< KPP */
    kRDC_Periph_IOMUXC_GPR          = 36U,         /**< IOMUXC_GPR */
    kRDC_Periph_IOMUXC              = 37U,         /**< IOMUXC */
    kRDC_Periph_GPT1                = 38U,         /**< GPT1 */
    kRDC_Periph_GPT2                = 39U,         /**< GPT2 */
    kRDC_Periph_GPT3                = 40U,         /**< GPT3 */
    kRDC_Periph_GPT4                = 41U,         /**< GPT4 */
    kRDC_Periph_GPT5                = 42U,         /**< GPT5 */
    kRDC_Periph_GPT6                = 43U,         /**< GPT6 */
    kRDC_Periph_LPI2C1              = 44U,         /**< LPI2C1 */
    kRDC_Periph_LPI2C2              = 45U,         /**< LPI2C2 */
    kRDC_Periph_LPI2C3              = 46U,         /**< LPI2C3 */
    kRDC_Periph_LPI2C4              = 47U,         /**< LPI2C4 */
    kRDC_Periph_LPSPI1              = 48U,         /**< LPSPI1 */
    kRDC_Periph_LPSPI2              = 49U,         /**< LPSPI2 */
    kRDC_Periph_LPSPI3              = 50U,         /**< LPSPI3 */
    kRDC_Periph_LPSPI4              = 51U,         /**< LPSPI4 */
    kRDC_Periph_GPIO_1_6            = 52U,         /**< GPIO_1_6 */
    kRDC_Periph_CCM_OBS             = 53U,         /**< CCM_OBS */
    kRDC_Periph_SIM1                = 54U,         /**< SIM1 */
    kRDC_Periph_SIM2                = 55U,         /**< SIM2 */
    kRDC_Periph_QTIMER1             = 56U,         /**< QTimer1 */
    kRDC_Periph_QTIMER2             = 57U,         /**< QTimer2 */
    kRDC_Periph_QTIMER3             = 58U,         /**< QTimer3 */
    kRDC_Periph_QTIMER4             = 59U,         /**< QTimer4 */
    kRDC_Periph_ENC1                = 60U,         /**< ENC1 */
    kRDC_Periph_ENC2                = 61U,         /**< ENC2 */
    kRDC_Periph_ENC3                = 62U,         /**< ENC3 */
    kRDC_Periph_ENC4                = 63U,         /**< ENC4 */
    kRDC_Periph_FLEXPWM1            = 64U,         /**< FLEXPWM1 */
    kRDC_Periph_FLEXPWM2            = 65U,         /**< FLEXPWM2 */
    kRDC_Periph_FLEXPWM3            = 66U,         /**< FLEXPWM3 */
    kRDC_Periph_FLEXPWM4            = 67U,         /**< FLEXPWM4 */
    kRDC_Periph_CAAM_2              = 68U,         /**< CAAM_2 */
    kRDC_Periph_CAAM_3              = 69U,         /**< CAAM_3 */
    kRDC_Periph_ACMP1               = 70U,         /**< ACMP1 */
    kRDC_Periph_ACMP2               = 71U,         /**< ACMP2 */
    kRDC_Periph_ACMP3               = 72U,         /**< ACMP3 */
    kRDC_Periph_ACMP4               = 73U,         /**< ACMP4 */
    kRDC_Periph_CAAM                = 74U,         /**< CAAM */
    kRDC_Periph_SPDIF               = 75U,         /**< SPDIF */
    kRDC_Periph_SAI1                = 76U,         /**< SAI1 */
    kRDC_Periph_SAI2                = 77U,         /**< SAI2 */
    kRDC_Periph_SAI3                = 78U,         /**< SAI3 */
    kRDC_Periph_ASRC                = 79U,         /**< ASRC */
    kRDC_Periph_USDHC1              = 80U,         /**< USDHC1 */
    kRDC_Periph_USDHC2              = 81U,         /**< USDHC2 */
    kRDC_Periph_ENET_1G             = 82U,         /**< ENET_1G */
    kRDC_Periph_ENET                = 83U,         /**< ENET */
    kRDC_Periph_USB_PL301           = 84U,         /**< USB_PL301 */
    kRDC_Periph_USBPHY2             = 85U,         /**< USBPHY2 */
    kRDC_Periph_USB_OTG2            = 85U,         /**< USB_OTG2 */
    kRDC_Periph_USBPHY1             = 86U,         /**< USBPHY1 */
    kRDC_Periph_USB_OTG1            = 86U,         /**< USB_OTG1 */
    kRDC_Periph_ENET_QOS            = 87U,         /**< ENET_QOS */
    kRDC_Periph_CAAM_5              = 88U,         /**< CAAM_5 */
    kRDC_Periph_CSI                 = 89U,         /**< CSI */
    kRDC_Periph_LCDIF1              = 90U,         /**< LCDIF1 */
    kRDC_Periph_LCDIF2              = 91U,         /**< LCDIF2 */
    kRDC_Periph_MIPI_DSI            = 92U,         /**< MIPI_DSI */
    kRDC_Periph_MIPI_CSI            = 93U,         /**< MIPI_CSI */
    kRDC_Periph_PXP                 = 94U,         /**< PXP */
    kRDC_Periph_VIDEO_MUX           = 95U,         /**< VIDEO_MUX */
    kRDC_Periph_PGMC_SRC_GPC        = 96U,         /**< PGMC_SRC_GPC */
    kRDC_Periph_IOMUXC_LPSR         = 97U,         /**< IOMUXC_LPSR */
    kRDC_Periph_IOMUXC_LPSR_GPR     = 98U,         /**< IOMUXC_LPSR_GPR */
    kRDC_Periph_WDOG4               = 99U,         /**< WDOG4 */
    kRDC_Periph_DMAMUX_LPSR         = 100U,        /**< DMAMUX_LPSR */
    kRDC_Periph_EDMA_LPSR           = 100U,        /**< EDMA_LPSR */
    kRDC_Periph_Reserved            = 101U,        /**< Reserved */
    kRDC_Periph_MIC                 = 102U,        /**< MIC */
    kRDC_Periph_LPUART11            = 103U,        /**< LPUART11 */
    kRDC_Periph_LPUART12            = 104U,        /**< LPUART12 */
    kRDC_Periph_LPSPI5              = 105U,        /**< LPSPI5 */
    kRDC_Periph_LPSPI6              = 106U,        /**< LPSPI6 */
    kRDC_Periph_LPI2C5              = 107U,        /**< LPI2C5 */
    kRDC_Periph_LPI2C6              = 108U,        /**< LPI2C6 */
    kRDC_Periph_CAN3                = 109U,        /**< CAN3 */
    kRDC_Periph_SAI4                = 110U,        /**< SAI4 */
    kRDC_Periph_SEMA1               = 111U,        /**< SEMA1 */
    kRDC_Periph_GPIO_7_12           = 112U,        /**< GPIO_7_12 */
    kRDC_Periph_KEY_MANAGER         = 113U,        /**< KEY_MANAGER */
    kRDC_Periph_ANATOP              = 114U,        /**< ANATOP */
    kRDC_Periph_SNVS_HP_WRAPPER     = 115U,        /**< SNVS_HP_WRAPPER */
    kRDC_Periph_IOMUXC_SNVS         = 116U,        /**< IOMUXC_SNVS */
    kRDC_Periph_IOMUXC_SNVS_GPR     = 117U,        /**< IOMUXC_SNVS_GPR */
    kRDC_Periph_SNVS_SRAM           = 118U,        /**< SNVS_SRAM */
    kRDC_Periph_GPIO13              = 119U,        /**< GPIO13 */
    kRDC_Periph_ROMCP               = 120U,        /**< ROMCP */
    kRDC_Periph_DCDC                = 121U,        /**< DCDC */
    kRDC_Periph_OCOTP_CTRL_WRAPPER  = 122U,        /**< OCOTP_CTRL_WRAPPER */
    kRDC_Periph_PIT2                = 123U,        /**< PIT2 */
    kRDC_Periph_SSARC               = 124U,        /**< SSARC */
    kRDC_Periph_CCM                 = 125U,        /**< CCM */
    kRDC_Periph_CAAM_6              = 126U,        /**< CAAM_6 */
    kRDC_Periph_CAAM_7              = 127U,        /**< CAAM_7 */
} rdc_periph_t;

/* @} */

typedef enum _xbar_input_signal
{
    kXBARA1_InputLogicLow           = 0|0x100U,    /**< LOGIC_LOW output assigned to XBARA1_IN0 input. */
    kXBARA1_InputLogicHigh          = 1|0x100U,    /**< LOGIC_HIGH output assigned to XBARA1_IN1 input. */
    kXBARA1_InputRESERVED2          = 2|0x100U,    /**< XBARA1_IN2 input is reserved. */
    kXBARA1_InputRESERVED3          = 3|0x100U,    /**< XBARA1_IN3 input is reserved. */
    kXBARA1_InputIomuxXbarInout04   = 4|0x100U,    /**< IOMUX_XBAR_INOUT04 output assigned to XBARA1_IN4 input. */
    kXBARA1_InputIomuxXbarInout05   = 5|0x100U,    /**< IOMUX_XBAR_INOUT05 output assigned to XBARA1_IN5 input. */
    kXBARA1_InputIomuxXbarInout06   = 6|0x100U,    /**< IOMUX_XBAR_INOUT06 output assigned to XBARA1_IN6 input. */
    kXBARA1_InputIomuxXbarInout07   = 7|0x100U,    /**< IOMUX_XBAR_INOUT07 output assigned to XBARA1_IN7 input. */
    kXBARA1_InputIomuxXbarInout08   = 8|0x100U,    /**< IOMUX_XBAR_INOUT08 output assigned to XBARA1_IN8 input. */
    kXBARA1_InputIomuxXbarInout09   = 9|0x100U,    /**< IOMUX_XBAR_INOUT09 output assigned to XBARA1_IN9 input. */
    kXBARA1_InputIomuxXbarInout10   = 10|0x100U,   /**< IOMUX_XBAR_INOUT10 output assigned to XBARA1_IN10 input. */
    kXBARA1_InputIomuxXbarInout11   = 11|0x100U,   /**< IOMUX_XBAR_INOUT11 output assigned to XBARA1_IN11 input. */
    kXBARA1_InputIomuxXbarInout12   = 12|0x100U,   /**< IOMUX_XBAR_INOUT12 output assigned to XBARA1_IN12 input. */
    kXBARA1_InputIomuxXbarInout13   = 13|0x100U,   /**< IOMUX_XBAR_INOUT13 output assigned to XBARA1_IN13 input. */
    kXBARA1_InputIomuxXbarInout14   = 14|0x100U,   /**< IOMUX_XBAR_INOUT14 output assigned to XBARA1_IN14 input. */
    kXBARA1_InputIomuxXbarInout15   = 15|0x100U,   /**< IOMUX_XBAR_INOUT15 output assigned to XBARA1_IN15 input. */
    kXBARA1_InputIomuxXbarInout16   = 16|0x100U,   /**< IOMUX_XBAR_INOUT16 output assigned to XBARA1_IN16 input. */
    kXBARA1_InputIomuxXbarInout17   = 17|0x100U,   /**< IOMUX_XBAR_INOUT17 output assigned to XBARA1_IN17 input. */
    kXBARA1_InputIomuxXbarInout18   = 18|0x100U,   /**< IOMUX_XBAR_INOUT18 output assigned to XBARA1_IN18 input. */
    kXBARA1_InputIomuxXbarInout19   = 19|0x100U,   /**< IOMUX_XBAR_INOUT19 output assigned to XBARA1_IN19 input. */
    kXBARA1_InputIomuxXbarInout20   = 20|0x100U,   /**< IOMUX_XBAR_INOUT20 output assigned to XBARA1_IN20 input. */
    kXBARA1_InputIomuxXbarInout21   = 21|0x100U,   /**< IOMUX_XBAR_INOUT21 output assigned to XBARA1_IN21 input. */
    kXBARA1_InputIomuxXbarInout22   = 22|0x100U,   /**< IOMUX_XBAR_INOUT22 output assigned to XBARA1_IN22 input. */
    kXBARA1_InputIomuxXbarInout23   = 23|0x100U,   /**< IOMUX_XBAR_INOUT23 output assigned to XBARA1_IN23 input. */
    kXBARA1_InputIomuxXbarInout24   = 24|0x100U,   /**< IOMUX_XBAR_INOUT24 output assigned to XBARA1_IN24 input. */
    kXBARA1_InputIomuxXbarInout25   = 25|0x100U,   /**< IOMUX_XBAR_INOUT25 output assigned to XBARA1_IN25 input. */
    kXBARA1_InputIomuxXbarInout26   = 26|0x100U,   /**< IOMUX_XBAR_INOUT26 output assigned to XBARA1_IN26 input. */
    kXBARA1_InputIomuxXbarInout27   = 27|0x100U,   /**< IOMUX_XBAR_INOUT27 output assigned to XBARA1_IN27 input. */
    kXBARA1_InputIomuxXbarInout28   = 28|0x100U,   /**< IOMUX_XBAR_INOUT28 output assigned to XBARA1_IN28 input. */
    kXBARA1_InputIomuxXbarInout29   = 29|0x100U,   /**< IOMUX_XBAR_INOUT29 output assigned to XBARA1_IN29 input. */
    kXBARA1_InputIomuxXbarInout30   = 30|0x100U,   /**< IOMUX_XBAR_INOUT30 output assigned to XBARA1_IN30 input. */
    kXBARA1_InputIomuxXbarInout31   = 31|0x100U,   /**< IOMUX_XBAR_INOUT31 output assigned to XBARA1_IN31 input. */
    kXBARA1_InputIomuxXbarInout32   = 32|0x100U,   /**< IOMUX_XBAR_INOUT32 output assigned to XBARA1_IN32 input. */
    kXBARA1_InputIomuxXbarInout33   = 33|0x100U,   /**< IOMUX_XBAR_INOUT33 output assigned to XBARA1_IN33 input. */
    kXBARA1_InputIomuxXbarInout34   = 34|0x100U,   /**< IOMUX_XBAR_INOUT34 output assigned to XBARA1_IN34 input. */
    kXBARA1_InputIomuxXbarInout35   = 35|0x100U,   /**< IOMUX_XBAR_INOUT35 output assigned to XBARA1_IN35 input. */
    kXBARA1_InputIomuxXbarInout36   = 36|0x100U,   /**< IOMUX_XBAR_INOUT36 output assigned to XBARA1_IN36 input. */
    kXBARA1_InputIomuxXbarInout37   = 37|0x100U,   /**< IOMUX_XBAR_INOUT37 output assigned to XBARA1_IN37 input. */
    kXBARA1_InputIomuxXbarInout38   = 38|0x100U,   /**< IOMUX_XBAR_INOUT38 output assigned to XBARA1_IN38 input. */
    kXBARA1_InputIomuxXbarInout39   = 39|0x100U,   /**< IOMUX_XBAR_INOUT39 output assigned to XBARA1_IN39 input. */
    kXBARA1_InputIomuxXbarInout40   = 40|0x100U,   /**< IOMUX_XBAR_INOUT40 output assigned to XBARA1_IN40 input. */
    kXBARA1_InputRESERVED41         = 41|0x100U,   /**< XBARA1_IN41 input is reserved. */
    kXBARA1_InputAcmp1Out           = 42|0x100U,   /**< ACMP1_OUT output assigned to XBARA1_IN42 input. */
    kXBARA1_InputAcmp2Out           = 43|0x100U,   /**< ACMP2_OUT output assigned to XBARA1_IN43 input. */
    kXBARA1_InputAcmp3Out           = 44|0x100U,   /**< ACMP3_OUT output assigned to XBARA1_IN44 input. */
    kXBARA1_InputAcmp4Out           = 45|0x100U,   /**< ACMP4_OUT output assigned to XBARA1_IN45 input. */
    kXBARA1_InputRESERVED46         = 46|0x100U,   /**< XBARA1_IN46 input is reserved. */
    kXBARA1_InputRESERVED47         = 47|0x100U,   /**< XBARA1_IN47 input is reserved. */
    kXBARA1_InputRESERVED48         = 48|0x100U,   /**< XBARA1_IN48 input is reserved. */
    kXBARA1_InputRESERVED49         = 49|0x100U,   /**< XBARA1_IN49 input is reserved. */
    kXBARA1_InputQtimer1Timer0      = 50|0x100U,   /**< QTIMER1_TIMER0 output assigned to XBARA1_IN50 input. */
    kXBARA1_InputQtimer1Timer1      = 51|0x100U,   /**< QTIMER1_TIMER1 output assigned to XBARA1_IN51 input. */
    kXBARA1_InputQtimer1Timer2      = 52|0x100U,   /**< QTIMER1_TIMER2 output assigned to XBARA1_IN52 input. */
    kXBARA1_InputQtimer1Timer3      = 53|0x100U,   /**< QTIMER1_TIMER3 output assigned to XBARA1_IN53 input. */
    kXBARA1_InputQtimer2Timer0      = 54|0x100U,   /**< QTIMER2_TIMER0 output assigned to XBARA1_IN54 input. */
    kXBARA1_InputQtimer2Timer1      = 55|0x100U,   /**< QTIMER2_TIMER1 output assigned to XBARA1_IN55 input. */
    kXBARA1_InputQtimer2Timer2      = 56|0x100U,   /**< QTIMER2_TIMER2 output assigned to XBARA1_IN56 input. */
    kXBARA1_InputQtimer2Timer3      = 57|0x100U,   /**< QTIMER2_TIMER3 output assigned to XBARA1_IN57 input. */
    kXBARA1_InputQtimer3Timer0      = 58|0x100U,   /**< QTIMER3_TIMER0 output assigned to XBARA1_IN58 input. */
    kXBARA1_InputQtimer3Timer1      = 59|0x100U,   /**< QTIMER3_TIMER1 output assigned to XBARA1_IN59 input. */
    kXBARA1_InputQtimer3Timer2      = 60|0x100U,   /**< QTIMER3_TIMER2 output assigned to XBARA1_IN60 input. */
    kXBARA1_InputQtimer3Timer3      = 61|0x100U,   /**< QTIMER3_TIMER3 output assigned to XBARA1_IN61 input. */
    kXBARA1_InputQtimer4Timer0      = 62|0x100U,   /**< QTIMER4_TIMER0 output assigned to XBARA1_IN62 input. */
    kXBARA1_InputQtimer4Timer1      = 63|0x100U,   /**< QTIMER4_TIMER1 output assigned to XBARA1_IN63 input. */
    kXBARA1_InputQtimer4Timer2      = 64|0x100U,   /**< QTIMER4_TIMER2 output assigned to XBARA1_IN64 input. */
    kXBARA1_InputQtimer4Timer3      = 65|0x100U,   /**< QTIMER4_TIMER3 output assigned to XBARA1_IN65 input. */
    kXBARA1_InputRESERVED66         = 66|0x100U,   /**< XBARA1_IN66 input is reserved. */
    kXBARA1_InputRESERVED67         = 67|0x100U,   /**< XBARA1_IN67 input is reserved. */
    kXBARA1_InputRESERVED68         = 68|0x100U,   /**< XBARA1_IN68 input is reserved. */
    kXBARA1_InputRESERVED69         = 69|0x100U,   /**< XBARA1_IN69 input is reserved. */
    kXBARA1_InputRESERVED70         = 70|0x100U,   /**< XBARA1_IN70 input is reserved. */
    kXBARA1_InputRESERVED71         = 71|0x100U,   /**< XBARA1_IN71 input is reserved. */
    kXBARA1_InputRESERVED72         = 72|0x100U,   /**< XBARA1_IN72 input is reserved. */
    kXBARA1_InputRESERVED73         = 73|0x100U,   /**< XBARA1_IN73 input is reserved. */
    kXBARA1_InputFlexpwm1Pwm0OutTrig0 = 74|0x100U, /**< FLEXPWM1_PWM0_OUT_TRIG0 output assigned to XBARA1_IN74 input. */
    kXBARA1_InputFlexpwm1Pwm0OutTrig1 = 75|0x100U, /**< FLEXPWM1_PWM0_OUT_TRIG1 output assigned to XBARA1_IN75 input. */
    kXBARA1_InputFlexpwm1Pwm1OutTrig0 = 76|0x100U, /**< FLEXPWM1_PWM1_OUT_TRIG0 output assigned to XBARA1_IN76 input. */
    kXBARA1_InputFlexpwm1Pwm1OutTrig1 = 77|0x100U, /**< FLEXPWM1_PWM1_OUT_TRIG1 output assigned to XBARA1_IN77 input. */
    kXBARA1_InputFlexpwm1Pwm2OutTrig0 = 78|0x100U, /**< FLEXPWM1_PWM2_OUT_TRIG0 output assigned to XBARA1_IN78 input. */
    kXBARA1_InputFlexpwm1Pwm2OutTrig1 = 79|0x100U, /**< FLEXPWM1_PWM2_OUT_TRIG1 output assigned to XBARA1_IN79 input. */
    kXBARA1_InputFlexpwm1Pwm3OutTrig0 = 80|0x100U, /**< FLEXPWM1_PWM3_OUT_TRIG0 output assigned to XBARA1_IN80 input. */
    kXBARA1_InputFlexpwm1Pwm3OutTrig1 = 81|0x100U, /**< FLEXPWM1_PWM3_OUT_TRIG1 output assigned to XBARA1_IN81 input. */
    kXBARA1_InputFlexpwm2Pwm0OutTrig01 = 82|0x100U, /**< FLEXPWM2_PWM0_OUT_TRIG0_1 output assigned to XBARA1_IN82 input. */
    kXBARA1_InputFlexpwm2Pwm1OutTrig01 = 83|0x100U, /**< FLEXPWM2_PWM1_OUT_TRIG0_1 output assigned to XBARA1_IN83 input. */
    kXBARA1_InputFlexpwm2Pwm2OutTrig01 = 84|0x100U, /**< FLEXPWM2_PWM2_OUT_TRIG0_1 output assigned to XBARA1_IN84 input. */
    kXBARA1_InputFlexpwm2Pwm3OutTrig01 = 85|0x100U, /**< FLEXPWM2_PWM3_OUT_TRIG0_1 output assigned to XBARA1_IN85 input. */
    kXBARA1_InputFlexpwm3Pwm0OutTrig01 = 86|0x100U, /**< FLEXPWM3_PWM0_OUT_TRIG0_1 output assigned to XBARA1_IN86 input. */
    kXBARA1_InputFlexpwm3Pwm1OutTrig01 = 87|0x100U, /**< FLEXPWM3_PWM1_OUT_TRIG0_1 output assigned to XBARA1_IN87 input. */
    kXBARA1_InputFlexpwm3Pwm2OutTrig01 = 88|0x100U, /**< FLEXPWM3_PWM2_OUT_TRIG0_1 output assigned to XBARA1_IN88 input. */
    kXBARA1_InputFlexpwm3Pwm3OutTrig01 = 89|0x100U, /**< FLEXPWM3_PWM3_OUT_TRIG0_1 output assigned to XBARA1_IN89 input. */
    kXBARA1_InputFlexpwm4Pwm0OutTrig01 = 90|0x100U, /**< FLEXPWM4_PWM0_OUT_TRIG0_1 output assigned to XBARA1_IN90 input. */
    kXBARA1_InputFlexpwm4Pwm1OutTrig01 = 91|0x100U, /**< FLEXPWM4_PWM1_OUT_TRIG0_1 output assigned to XBARA1_IN91 input. */
    kXBARA1_InputFlexpwm4Pwm2OutTrig01 = 92|0x100U, /**< FLEXPWM4_PWM2_OUT_TRIG0_1 output assigned to XBARA1_IN92 input. */
    kXBARA1_InputFlexpwm4Pwm3OutTrig01 = 93|0x100U, /**< FLEXPWM4_PWM3_OUT_TRIG0_1 output assigned to XBARA1_IN93 input. */
    kXBARA1_InputRESERVED94         = 94|0x100U,   /**< XBARA1_IN94 input is reserved. */
    kXBARA1_InputRESERVED95         = 95|0x100U,   /**< XBARA1_IN95 input is reserved. */
    kXBARA1_InputRESERVED96         = 96|0x100U,   /**< XBARA1_IN96 input is reserved. */
    kXBARA1_InputRESERVED97         = 97|0x100U,   /**< XBARA1_IN97 input is reserved. */
    kXBARA1_InputRESERVED98         = 98|0x100U,   /**< XBARA1_IN98 input is reserved. */
    kXBARA1_InputRESERVED99         = 99|0x100U,   /**< XBARA1_IN99 input is reserved. */
    kXBARA1_InputRESERVED100        = 100|0x100U,  /**< XBARA1_IN100 input is reserved. */
    kXBARA1_InputRESERVED101        = 101|0x100U,  /**< XBARA1_IN101 input is reserved. */
    kXBARA1_InputPit1Trigger0       = 102|0x100U,  /**< PIT1_TRIGGER0 output assigned to XBARA1_IN102 input. */
    kXBARA1_InputPit1Trigger1       = 103|0x100U,  /**< PIT1_TRIGGER1 output assigned to XBARA1_IN103 input. */
    kXBARA1_InputPit1Trigger2       = 104|0x100U,  /**< PIT1_TRIGGER2 output assigned to XBARA1_IN104 input. */
    kXBARA1_InputPit1Trigger3       = 105|0x100U,  /**< PIT1_TRIGGER3 output assigned to XBARA1_IN105 input. */
    kXBARA1_InputDec1PosMatch       = 106|0x100U,  /**< DEC1_POS_MATCH output assigned to XBARA1_IN106 input. */
    kXBARA1_InputDec2PosMatch       = 107|0x100U,  /**< DEC2_POS_MATCH output assigned to XBARA1_IN107 input. */
    kXBARA1_InputDec3PosMatch       = 108|0x100U,  /**< DEC3_POS_MATCH output assigned to XBARA1_IN108 input. */
    kXBARA1_InputDec4PosMatch       = 109|0x100U,  /**< DEC4_POS_MATCH output assigned to XBARA1_IN109 input. */
    kXBARA1_InputRESERVED110        = 110|0x100U,  /**< XBARA1_IN110 input is reserved. */
    kXBARA1_InputRESERVED111        = 111|0x100U,  /**< XBARA1_IN111 input is reserved. */
    kXBARA1_InputDmaDone0           = 112|0x100U,  /**< DMA_DONE0 output assigned to XBARA1_IN112 input. */
    kXBARA1_InputDmaDone1           = 113|0x100U,  /**< DMA_DONE1 output assigned to XBARA1_IN113 input. */
    kXBARA1_InputDmaDone2           = 114|0x100U,  /**< DMA_DONE2 output assigned to XBARA1_IN114 input. */
    kXBARA1_InputDmaDone3           = 115|0x100U,  /**< DMA_DONE3 output assigned to XBARA1_IN115 input. */
    kXBARA1_InputDmaDone4           = 116|0x100U,  /**< DMA_DONE4 output assigned to XBARA1_IN116 input. */
    kXBARA1_InputDmaDone5           = 117|0x100U,  /**< DMA_DONE5 output assigned to XBARA1_IN117 input. */
    kXBARA1_InputDmaDone6           = 118|0x100U,  /**< DMA_DONE6 output assigned to XBARA1_IN118 input. */
    kXBARA1_InputDmaDone7           = 119|0x100U,  /**< DMA_DONE7 output assigned to XBARA1_IN119 input. */
    kXBARA1_InputDmaLpsrDone0       = 120|0x100U,  /**< DMA_LPSR_DONE0 output assigned to XBARA1_IN120 input. */
    kXBARA1_InputDmaLpsrDone1       = 121|0x100U,  /**< DMA_LPSR_DONE1 output assigned to XBARA1_IN121 input. */
    kXBARA1_InputDmaLpsrDone2       = 122|0x100U,  /**< DMA_LPSR_DONE2 output assigned to XBARA1_IN122 input. */
    kXBARA1_InputDmaLpsrDone3       = 123|0x100U,  /**< DMA_LPSR_DONE3 output assigned to XBARA1_IN123 input. */
    kXBARA1_InputDmaLpsrDone4       = 124|0x100U,  /**< DMA_LPSR_DONE4 output assigned to XBARA1_IN124 input. */
    kXBARA1_InputDmaLpsrDone5       = 125|0x100U,  /**< DMA_LPSR_DONE5 output assigned to XBARA1_IN125 input. */
    kXBARA1_InputDmaLpsrDone6       = 126|0x100U,  /**< DMA_LPSR_DONE6 output assigned to XBARA1_IN126 input. */
    kXBARA1_InputDmaLpsrDone7       = 127|0x100U,  /**< DMA_LPSR_DONE7 output assigned to XBARA1_IN127 input. */
    kXBARA1_InputAoi1Out0           = 128|0x100U,  /**< AOI1_OUT0 output assigned to XBARA1_IN128 input. */
    kXBARA1_InputAoi1Out1           = 129|0x100U,  /**< AOI1_OUT1 output assigned to XBARA1_IN129 input. */
    kXBARA1_InputAoi1Out2           = 130|0x100U,  /**< AOI1_OUT2 output assigned to XBARA1_IN130 input. */
    kXBARA1_InputAoi1Out3           = 131|0x100U,  /**< AOI1_OUT3 output assigned to XBARA1_IN131 input. */
    kXBARA1_InputAoi2Out0           = 132|0x100U,  /**< AOI2_OUT0 output assigned to XBARA1_IN132 input. */
    kXBARA1_InputAoi2Out1           = 133|0x100U,  /**< AOI2_OUT1 output assigned to XBARA1_IN133 input. */
    kXBARA1_InputAoi2Out2           = 134|0x100U,  /**< AOI2_OUT2 output assigned to XBARA1_IN134 input. */
    kXBARA1_InputAoi2Out3           = 135|0x100U,  /**< AOI2_OUT3 output assigned to XBARA1_IN135 input. */
    kXBARA1_InputAdcEtc0Coco0       = 136|0x100U,  /**< ADC_ETC0_COCO0 output assigned to XBARA1_IN136 input. */
    kXBARA1_InputAdcEtc0Coco1       = 137|0x100U,  /**< ADC_ETC0_COCO1 output assigned to XBARA1_IN137 input. */
    kXBARA1_InputAdcEtc0Coco2       = 138|0x100U,  /**< ADC_ETC0_COCO2 output assigned to XBARA1_IN138 input. */
    kXBARA1_InputAdcEtc0Coco3       = 139|0x100U,  /**< ADC_ETC0_COCO3 output assigned to XBARA1_IN139 input. */
    kXBARA1_InputAdcEtc1Coco0       = 140|0x100U,  /**< ADC_ETC1_COCO0 output assigned to XBARA1_IN140 input. */
    kXBARA1_InputAdcEtc1Coco1       = 141|0x100U,  /**< ADC_ETC1_COCO1 output assigned to XBARA1_IN141 input. */
    kXBARA1_InputAdcEtc1Coco2       = 142|0x100U,  /**< ADC_ETC1_COCO2 output assigned to XBARA1_IN142 input. */
    kXBARA1_InputAdcEtc1Coco3       = 143|0x100U,  /**< ADC_ETC1_COCO3 output assigned to XBARA1_IN143 input. */
    kXBARB2_InputLogicLow           = 0|0x200U,    /**< LOGIC_LOW output assigned to XBARB2_IN0 input. */
    kXBARB2_InputLogicHigh          = 1|0x200U,    /**< LOGIC_HIGH output assigned to XBARB2_IN1 input. */
    kXBARB2_InputAcmp1Out           = 2|0x200U,    /**< ACMP1_OUT output assigned to XBARB2_IN2 input. */
    kXBARB2_InputAcmp2Out           = 3|0x200U,    /**< ACMP2_OUT output assigned to XBARB2_IN3 input. */
    kXBARB2_InputAcmp3Out           = 4|0x200U,    /**< ACMP3_OUT output assigned to XBARB2_IN4 input. */
    kXBARB2_InputAcmp4Out           = 5|0x200U,    /**< ACMP4_OUT output assigned to XBARB2_IN5 input. */
    kXBARB2_InputRESERVED6          = 6|0x200U,    /**< XBARB2_IN6 input is reserved. */
    kXBARB2_InputRESERVED7          = 7|0x200U,    /**< XBARB2_IN7 input is reserved. */
    kXBARB2_InputRESERVED8          = 8|0x200U,    /**< XBARB2_IN8 input is reserved. */
    kXBARB2_InputRESERVED9          = 9|0x200U,    /**< XBARB2_IN9 input is reserved. */
    kXBARB2_InputQtimer1Timer0      = 10|0x200U,   /**< QTIMER1_TIMER0 output assigned to XBARB2_IN10 input. */
    kXBARB2_InputQtimer1Timer1      = 11|0x200U,   /**< QTIMER1_TIMER1 output assigned to XBARB2_IN11 input. */
    kXBARB2_InputQtimer1Timer2      = 12|0x200U,   /**< QTIMER1_TIMER2 output assigned to XBARB2_IN12 input. */
    kXBARB2_InputQtimer1Timer3      = 13|0x200U,   /**< QTIMER1_TIMER3 output assigned to XBARB2_IN13 input. */
    kXBARB2_InputQtimer2Timer0      = 14|0x200U,   /**< QTIMER2_TIMER0 output assigned to XBARB2_IN14 input. */
    kXBARB2_InputQtimer2Timer1      = 15|0x200U,   /**< QTIMER2_TIMER1 output assigned to XBARB2_IN15 input. */
    kXBARB2_InputQtimer2Timer2      = 16|0x200U,   /**< QTIMER2_TIMER2 output assigned to XBARB2_IN16 input. */
    kXBARB2_InputQtimer2Timer3      = 17|0x200U,   /**< QTIMER2_TIMER3 output assigned to XBARB2_IN17 input. */
    kXBARB2_InputQtimer3Timer0      = 18|0x200U,   /**< QTIMER3_TIMER0 output assigned to XBARB2_IN18 input. */
    kXBARB2_InputQtimer3Timer1      = 19|0x200U,   /**< QTIMER3_TIMER1 output assigned to XBARB2_IN19 input. */
    kXBARB2_InputQtimer3Timer2      = 20|0x200U,   /**< QTIMER3_TIMER2 output assigned to XBARB2_IN20 input. */
    kXBARB2_InputQtimer3Timer3      = 21|0x200U,   /**< QTIMER3_TIMER3 output assigned to XBARB2_IN21 input. */
    kXBARB2_InputQtimer4Timer0      = 22|0x200U,   /**< QTIMER4_TIMER0 output assigned to XBARB2_IN22 input. */
    kXBARB2_InputQtimer4Timer1      = 23|0x200U,   /**< QTIMER4_TIMER1 output assigned to XBARB2_IN23 input. */
    kXBARB2_InputQtimer4Timer2      = 24|0x200U,   /**< QTIMER4_TIMER2 output assigned to XBARB2_IN24 input. */
    kXBARB2_InputQtimer4Timer3      = 25|0x200U,   /**< QTIMER4_TIMER3 output assigned to XBARB2_IN25 input. */
    kXBARB2_InputRESERVED26         = 26|0x200U,   /**< XBARB2_IN26 input is reserved. */
    kXBARB2_InputRESERVED27         = 27|0x200U,   /**< XBARB2_IN27 input is reserved. */
    kXBARB2_InputRESERVED28         = 28|0x200U,   /**< XBARB2_IN28 input is reserved. */
    kXBARB2_InputRESERVED29         = 29|0x200U,   /**< XBARB2_IN29 input is reserved. */
    kXBARB2_InputRESERVED30         = 30|0x200U,   /**< XBARB2_IN30 input is reserved. */
    kXBARB2_InputRESERVED31         = 31|0x200U,   /**< XBARB2_IN31 input is reserved. */
    kXBARB2_InputRESERVED32         = 32|0x200U,   /**< XBARB2_IN32 input is reserved. */
    kXBARB2_InputRESERVED33         = 33|0x200U,   /**< XBARB2_IN33 input is reserved. */
    kXBARB2_InputFlexpwm1Pwm0OutTrig01 = 34|0x200U, /**< FLEXPWM1_PWM0_OUT_TRIG0_1 output assigned to XBARB2_IN34 input. */
    kXBARB2_InputFlexpwm1Pwm1OutTrig01 = 35|0x200U, /**< FLEXPWM1_PWM1_OUT_TRIG0_1 output assigned to XBARB2_IN35 input. */
    kXBARB2_InputFlexpwm1Pwm2OutTrig01 = 36|0x200U, /**< FLEXPWM1_PWM2_OUT_TRIG0_1 output assigned to XBARB2_IN36 input. */
    kXBARB2_InputFlexpwm1Pwm3OutTrig01 = 37|0x200U, /**< FLEXPWM1_PWM3_OUT_TRIG0_1 output assigned to XBARB2_IN37 input. */
    kXBARB2_InputFlexpwm2Pwm0OutTrig01 = 38|0x200U, /**< FLEXPWM2_PWM0_OUT_TRIG0_1 output assigned to XBARB2_IN38 input. */
    kXBARB2_InputFlexpwm2Pwm1OutTrig01 = 39|0x200U, /**< FLEXPWM2_PWM1_OUT_TRIG0_1 output assigned to XBARB2_IN39 input. */
    kXBARB2_InputFlexpwm2Pwm2OutTrig01 = 40|0x200U, /**< FLEXPWM2_PWM2_OUT_TRIG0_1 output assigned to XBARB2_IN40 input. */
    kXBARB2_InputFlexpwm2Pwm3OutTrig01 = 41|0x200U, /**< FLEXPWM2_PWM3_OUT_TRIG0_1 output assigned to XBARB2_IN41 input. */
    kXBARB2_InputFlexpwm3Pwm0OutTrig01 = 42|0x200U, /**< FLEXPWM3_PWM0_OUT_TRIG0_1 output assigned to XBARB2_IN42 input. */
    kXBARB2_InputFlexpwm3Pwm1OutTrig01 = 43|0x200U, /**< FLEXPWM3_PWM1_OUT_TRIG0_1 output assigned to XBARB2_IN43 input. */
    kXBARB2_InputFlexpwm3Pwm2OutTrig01 = 44|0x200U, /**< FLEXPWM3_PWM2_OUT_TRIG0_1 output assigned to XBARB2_IN44 input. */
    kXBARB2_InputFlexpwm3Pwm3OutTrig01 = 45|0x200U, /**< FLEXPWM3_PWM3_OUT_TRIG0_1 output assigned to XBARB2_IN45 input. */
    kXBARB2_InputFlexpwm4Pwm0OutTrig01 = 46|0x200U, /**< FLEXPWM4_PWM0_OUT_TRIG0_1 output assigned to XBARB2_IN46 input. */
    kXBARB2_InputFlexpwm4Pwm1OutTrig01 = 47|0x200U, /**< FLEXPWM4_PWM1_OUT_TRIG0_1 output assigned to XBARB2_IN47 input. */
    kXBARB2_InputFlexpwm4Pwm2OutTrig01 = 48|0x200U, /**< FLEXPWM4_PWM2_OUT_TRIG0_1 output assigned to XBARB2_IN48 input. */
    kXBARB2_InputFlexpwm4Pwm3OutTrig01 = 49|0x200U, /**< FLEXPWM4_PWM3_OUT_TRIG0_1 output assigned to XBARB2_IN49 input. */
    kXBARB2_InputRESERVED50         = 50|0x200U,   /**< XBARB2_IN50 input is reserved. */
    kXBARB2_InputRESERVED51         = 51|0x200U,   /**< XBARB2_IN51 input is reserved. */
    kXBARB2_InputRESERVED52         = 52|0x200U,   /**< XBARB2_IN52 input is reserved. */
    kXBARB2_InputRESERVED53         = 53|0x200U,   /**< XBARB2_IN53 input is reserved. */
    kXBARB2_InputRESERVED54         = 54|0x200U,   /**< XBARB2_IN54 input is reserved. */
    kXBARB2_InputRESERVED55         = 55|0x200U,   /**< XBARB2_IN55 input is reserved. */
    kXBARB2_InputRESERVED56         = 56|0x200U,   /**< XBARB2_IN56 input is reserved. */
    kXBARB2_InputRESERVED57         = 57|0x200U,   /**< XBARB2_IN57 input is reserved. */
    kXBARB2_InputPit1Trigger0       = 58|0x200U,   /**< PIT1_TRIGGER0 output assigned to XBARB2_IN58 input. */
    kXBARB2_InputPit1Trigger1       = 59|0x200U,   /**< PIT1_TRIGGER1 output assigned to XBARB2_IN59 input. */
    kXBARB2_InputAdcEtc0Coco0       = 60|0x200U,   /**< ADC_ETC0_COCO0 output assigned to XBARB2_IN60 input. */
    kXBARB2_InputAdcEtc0Coco1       = 61|0x200U,   /**< ADC_ETC0_COCO1 output assigned to XBARB2_IN61 input. */
    kXBARB2_InputAdcEtc0Coco2       = 62|0x200U,   /**< ADC_ETC0_COCO2 output assigned to XBARB2_IN62 input. */
    kXBARB2_InputAdcEtc0Coco3       = 63|0x200U,   /**< ADC_ETC0_COCO3 output assigned to XBARB2_IN63 input. */
    kXBARB2_InputAdcEtc1Coco0       = 64|0x200U,   /**< ADC_ETC1_COCO0 output assigned to XBARB2_IN64 input. */
    kXBARB2_InputAdcEtc1Coco1       = 65|0x200U,   /**< ADC_ETC1_COCO1 output assigned to XBARB2_IN65 input. */
    kXBARB2_InputAdcEtc1Coco2       = 66|0x200U,   /**< ADC_ETC1_COCO2 output assigned to XBARB2_IN66 input. */
    kXBARB2_InputAdcEtc1Coco3       = 67|0x200U,   /**< ADC_ETC1_COCO3 output assigned to XBARB2_IN67 input. */
    kXBARB2_InputRESERVED68         = 68|0x200U,   /**< XBARB2_IN68 input is reserved. */
    kXBARB2_InputRESERVED69         = 69|0x200U,   /**< XBARB2_IN69 input is reserved. */
    kXBARB2_InputRESERVED70         = 70|0x200U,   /**< XBARB2_IN70 input is reserved. */
    kXBARB2_InputRESERVED71         = 71|0x200U,   /**< XBARB2_IN71 input is reserved. */
    kXBARB2_InputRESERVED72         = 72|0x200U,   /**< XBARB2_IN72 input is reserved. */
    kXBARB2_InputRESERVED73         = 73|0x200U,   /**< XBARB2_IN73 input is reserved. */
    kXBARB2_InputRESERVED74         = 74|0x200U,   /**< XBARB2_IN74 input is reserved. */
    kXBARB2_InputRESERVED75         = 75|0x200U,   /**< XBARB2_IN75 input is reserved. */
    kXBARB2_InputDec1PosMatch       = 76|0x200U,   /**< DEC1_POS_MATCH output assigned to XBARB2_IN76 input. */
    kXBARB2_InputDec2PosMatch       = 77|0x200U,   /**< DEC2_POS_MATCH output assigned to XBARB2_IN77 input. */
    kXBARB2_InputDec3PosMatch       = 78|0x200U,   /**< DEC3_POS_MATCH output assigned to XBARB2_IN78 input. */
    kXBARB2_InputDec4PosMatch       = 79|0x200U,   /**< DEC4_POS_MATCH output assigned to XBARB2_IN79 input. */
    kXBARB2_InputRESERVED80         = 80|0x200U,   /**< XBARB2_IN80 input is reserved. */
    kXBARB2_InputRESERVED81         = 81|0x200U,   /**< XBARB2_IN81 input is reserved. */
    kXBARB2_InputDmaDone0           = 82|0x200U,   /**< DMA_DONE0 output assigned to XBARB2_IN82 input. */
    kXBARB2_InputDmaDone1           = 83|0x200U,   /**< DMA_DONE1 output assigned to XBARB2_IN83 input. */
    kXBARB2_InputDmaDone2           = 84|0x200U,   /**< DMA_DONE2 output assigned to XBARB2_IN84 input. */
    kXBARB2_InputDmaDone3           = 85|0x200U,   /**< DMA_DONE3 output assigned to XBARB2_IN85 input. */
    kXBARB2_InputDmaDone4           = 86|0x200U,   /**< DMA_DONE4 output assigned to XBARB2_IN86 input. */
    kXBARB2_InputDmaDone5           = 87|0x200U,   /**< DMA_DONE5 output assigned to XBARB2_IN87 input. */
    kXBARB2_InputDmaDone6           = 88|0x200U,   /**< DMA_DONE6 output assigned to XBARB2_IN88 input. */
    kXBARB2_InputDmaDone7           = 89|0x200U,   /**< DMA_DONE7 output assigned to XBARB2_IN89 input. */
    kXBARB2_InputDmaLpsrDone0       = 90|0x200U,   /**< DMA_LPSR_DONE0 output assigned to XBARB2_IN90 input. */
    kXBARB2_InputDmaLpsrDone1       = 91|0x200U,   /**< DMA_LPSR_DONE1 output assigned to XBARB2_IN91 input. */
    kXBARB2_InputDmaLpsrDone2       = 92|0x200U,   /**< DMA_LPSR_DONE2 output assigned to XBARB2_IN92 input. */
    kXBARB2_InputDmaLpsrDone3       = 93|0x200U,   /**< DMA_LPSR_DONE3 output assigned to XBARB2_IN93 input. */
    kXBARB2_InputDmaLpsrDone4       = 94|0x200U,   /**< DMA_LPSR_DONE4 output assigned to XBARB2_IN94 input. */
    kXBARB2_InputDmaLpsrDone5       = 95|0x200U,   /**< DMA_LPSR_DONE5 output assigned to XBARB2_IN95 input. */
    kXBARB2_InputDmaLpsrDone6       = 96|0x200U,   /**< DMA_LPSR_DONE6 output assigned to XBARB2_IN96 input. */
    kXBARB2_InputDmaLpsrDone7       = 97|0x200U,   /**< DMA_LPSR_DONE7 output assigned to XBARB2_IN97 input. */
    kXBARB3_InputLogicLow           = 0|0x300U,    /**< LOGIC_LOW output assigned to XBARB3_IN0 input. */
    kXBARB3_InputLogicHigh          = 1|0x300U,    /**< LOGIC_HIGH output assigned to XBARB3_IN1 input. */
    kXBARB3_InputAcmp1Out           = 2|0x300U,    /**< ACMP1_OUT output assigned to XBARB3_IN2 input. */
    kXBARB3_InputAcmp2Out           = 3|0x300U,    /**< ACMP2_OUT output assigned to XBARB3_IN3 input. */
    kXBARB3_InputAcmp3Out           = 4|0x300U,    /**< ACMP3_OUT output assigned to XBARB3_IN4 input. */
    kXBARB3_InputAcmp4Out           = 5|0x300U,    /**< ACMP4_OUT output assigned to XBARB3_IN5 input. */
    kXBARB3_InputRESERVED6          = 6|0x300U,    /**< XBARB3_IN6 input is reserved. */
    kXBARB3_InputRESERVED7          = 7|0x300U,    /**< XBARB3_IN7 input is reserved. */
    kXBARB3_InputRESERVED8          = 8|0x300U,    /**< XBARB3_IN8 input is reserved. */
    kXBARB3_InputRESERVED9          = 9|0x300U,    /**< XBARB3_IN9 input is reserved. */
    kXBARB3_InputQtimer1Timer0      = 10|0x300U,   /**< QTIMER1_TIMER0 output assigned to XBARB3_IN10 input. */
    kXBARB3_InputQtimer1Timer1      = 11|0x300U,   /**< QTIMER1_TIMER1 output assigned to XBARB3_IN11 input. */
    kXBARB3_InputQtimer1Timer2      = 12|0x300U,   /**< QTIMER1_TIMER2 output assigned to XBARB3_IN12 input. */
    kXBARB3_InputQtimer1Timer3      = 13|0x300U,   /**< QTIMER1_TIMER3 output assigned to XBARB3_IN13 input. */
    kXBARB3_InputQtimer2Timer0      = 14|0x300U,   /**< QTIMER2_TIMER0 output assigned to XBARB3_IN14 input. */
    kXBARB3_InputQtimer2Timer1      = 15|0x300U,   /**< QTIMER2_TIMER1 output assigned to XBARB3_IN15 input. */
    kXBARB3_InputQtimer2Timer2      = 16|0x300U,   /**< QTIMER2_TIMER2 output assigned to XBARB3_IN16 input. */
    kXBARB3_InputQtimer2Timer3      = 17|0x300U,   /**< QTIMER2_TIMER3 output assigned to XBARB3_IN17 input. */
    kXBARB3_InputQtimer3Timer0      = 18|0x300U,   /**< QTIMER3_TIMER0 output assigned to XBARB3_IN18 input. */
    kXBARB3_InputQtimer3Timer1      = 19|0x300U,   /**< QTIMER3_TIMER1 output assigned to XBARB3_IN19 input. */
    kXBARB3_InputQtimer3Timer2      = 20|0x300U,   /**< QTIMER3_TIMER2 output assigned to XBARB3_IN20 input. */
    kXBARB3_InputQtimer3Timer3      = 21|0x300U,   /**< QTIMER3_TIMER3 output assigned to XBARB3_IN21 input. */
    kXBARB3_InputQtimer4Timer0      = 22|0x300U,   /**< QTIMER4_TIMER0 output assigned to XBARB3_IN22 input. */
    kXBARB3_InputQtimer4Timer1      = 23|0x300U,   /**< QTIMER4_TIMER1 output assigned to XBARB3_IN23 input. */
    kXBARB3_InputQtimer4Timer2      = 24|0x300U,   /**< QTIMER4_TIMER2 output assigned to XBARB3_IN24 input. */
    kXBARB3_InputQtimer4Timer3      = 25|0x300U,   /**< QTIMER4_TIMER3 output assigned to XBARB3_IN25 input. */
    kXBARB3_InputRESERVED26         = 26|0x300U,   /**< XBARB3_IN26 input is reserved. */
    kXBARB3_InputRESERVED27         = 27|0x300U,   /**< XBARB3_IN27 input is reserved. */
    kXBARB3_InputRESERVED28         = 28|0x300U,   /**< XBARB3_IN28 input is reserved. */
    kXBARB3_InputRESERVED29         = 29|0x300U,   /**< XBARB3_IN29 input is reserved. */
    kXBARB3_InputRESERVED30         = 30|0x300U,   /**< XBARB3_IN30 input is reserved. */
    kXBARB3_InputRESERVED31         = 31|0x300U,   /**< XBARB3_IN31 input is reserved. */
    kXBARB3_InputRESERVED32         = 32|0x300U,   /**< XBARB3_IN32 input is reserved. */
    kXBARB3_InputRESERVED33         = 33|0x300U,   /**< XBARB3_IN33 input is reserved. */
    kXBARB3_InputFlexpwm1Pwm0OutTrig01 = 34|0x300U, /**< FLEXPWM1_PWM0_OUT_TRIG0_1 output assigned to XBARB3_IN34 input. */
    kXBARB3_InputFlexpwm1Pwm1OutTrig01 = 35|0x300U, /**< FLEXPWM1_PWM1_OUT_TRIG0_1 output assigned to XBARB3_IN35 input. */
    kXBARB3_InputFlexpwm1Pwm2OutTrig01 = 36|0x300U, /**< FLEXPWM1_PWM2_OUT_TRIG0_1 output assigned to XBARB3_IN36 input. */
    kXBARB3_InputFlexpwm1Pwm3OutTrig01 = 37|0x300U, /**< FLEXPWM1_PWM3_OUT_TRIG0_1 output assigned to XBARB3_IN37 input. */
    kXBARB3_InputFlexpwm2Pwm0OutTrig01 = 38|0x300U, /**< FLEXPWM2_PWM0_OUT_TRIG0_1 output assigned to XBARB3_IN38 input. */
    kXBARB3_InputFlexpwm2Pwm1OutTrig01 = 39|0x300U, /**< FLEXPWM2_PWM1_OUT_TRIG0_1 output assigned to XBARB3_IN39 input. */
    kXBARB3_InputFlexpwm2Pwm2OutTrig01 = 40|0x300U, /**< FLEXPWM2_PWM2_OUT_TRIG0_1 output assigned to XBARB3_IN40 input. */
    kXBARB3_InputFlexpwm2Pwm3OutTrig01 = 41|0x300U, /**< FLEXPWM2_PWM3_OUT_TRIG0_1 output assigned to XBARB3_IN41 input. */
    kXBARB3_InputFlexpwm3Pwm0OutTrig01 = 42|0x300U, /**< FLEXPWM3_PWM0_OUT_TRIG0_1 output assigned to XBARB3_IN42 input. */
    kXBARB3_InputFlexpwm3Pwm1OutTrig01 = 43|0x300U, /**< FLEXPWM3_PWM1_OUT_TRIG0_1 output assigned to XBARB3_IN43 input. */
    kXBARB3_InputFlexpwm3Pwm2OutTrig01 = 44|0x300U, /**< FLEXPWM3_PWM2_OUT_TRIG0_1 output assigned to XBARB3_IN44 input. */
    kXBARB3_InputFlexpwm3Pwm3OutTrig01 = 45|0x300U, /**< FLEXPWM3_PWM3_OUT_TRIG0_1 output assigned to XBARB3_IN45 input. */
    kXBARB3_InputFlexpwm4Pwm0OutTrig01 = 46|0x300U, /**< FLEXPWM4_PWM0_OUT_TRIG0_1 output assigned to XBARB3_IN46 input. */
    kXBARB3_InputFlexpwm4Pwm1OutTrig01 = 47|0x300U, /**< FLEXPWM4_PWM1_OUT_TRIG0_1 output assigned to XBARB3_IN47 input. */
    kXBARB3_InputFlexpwm4Pwm2OutTrig01 = 48|0x300U, /**< FLEXPWM4_PWM2_OUT_TRIG0_1 output assigned to XBARB3_IN48 input. */
    kXBARB3_InputFlexpwm4Pwm3OutTrig01 = 49|0x300U, /**< FLEXPWM4_PWM3_OUT_TRIG0_1 output assigned to XBARB3_IN49 input. */
    kXBARB3_InputRESERVED50         = 50|0x300U,   /**< XBARB3_IN50 input is reserved. */
    kXBARB3_InputRESERVED51         = 51|0x300U,   /**< XBARB3_IN51 input is reserved. */
    kXBARB3_InputRESERVED52         = 52|0x300U,   /**< XBARB3_IN52 input is reserved. */
    kXBARB3_InputRESERVED53         = 53|0x300U,   /**< XBARB3_IN53 input is reserved. */
    kXBARB3_InputRESERVED54         = 54|0x300U,   /**< XBARB3_IN54 input is reserved. */
    kXBARB3_InputRESERVED55         = 55|0x300U,   /**< XBARB3_IN55 input is reserved. */
    kXBARB3_InputRESERVED56         = 56|0x300U,   /**< XBARB3_IN56 input is reserved. */
    kXBARB3_InputRESERVED57         = 57|0x300U,   /**< XBARB3_IN57 input is reserved. */
    kXBARB3_InputPit1Trigger0       = 58|0x300U,   /**< PIT1_TRIGGER0 output assigned to XBARB3_IN58 input. */
    kXBARB3_InputPit1Trigger1       = 59|0x300U,   /**< PIT1_TRIGGER1 output assigned to XBARB3_IN59 input. */
    kXBARB3_InputAdcEtc0Coco0       = 60|0x300U,   /**< ADC_ETC0_COCO0 output assigned to XBARB3_IN60 input. */
    kXBARB3_InputAdcEtc0Coco1       = 61|0x300U,   /**< ADC_ETC0_COCO1 output assigned to XBARB3_IN61 input. */
    kXBARB3_InputAdcEtc0Coco2       = 62|0x300U,   /**< ADC_ETC0_COCO2 output assigned to XBARB3_IN62 input. */
    kXBARB3_InputAdcEtc0Coco3       = 63|0x300U,   /**< ADC_ETC0_COCO3 output assigned to XBARB3_IN63 input. */
    kXBARB3_InputAdcEtc1Coco0       = 64|0x300U,   /**< ADC_ETC1_COCO0 output assigned to XBARB3_IN64 input. */
    kXBARB3_InputAdcEtc1Coco1       = 65|0x300U,   /**< ADC_ETC1_COCO1 output assigned to XBARB3_IN65 input. */
    kXBARB3_InputAdcEtc1Coco2       = 66|0x300U,   /**< ADC_ETC1_COCO2 output assigned to XBARB3_IN66 input. */
    kXBARB3_InputAdcEtc1Coco3       = 67|0x300U,   /**< ADC_ETC1_COCO3 output assigned to XBARB3_IN67 input. */
    kXBARB3_InputRESERVED68         = 68|0x300U,   /**< XBARB3_IN68 input is reserved. */
    kXBARB3_InputRESERVED69         = 69|0x300U,   /**< XBARB3_IN69 input is reserved. */
    kXBARB3_InputRESERVED70         = 70|0x300U,   /**< XBARB3_IN70 input is reserved. */
    kXBARB3_InputRESERVED71         = 71|0x300U,   /**< XBARB3_IN71 input is reserved. */
    kXBARB3_InputRESERVED72         = 72|0x300U,   /**< XBARB3_IN72 input is reserved. */
    kXBARB3_InputRESERVED73         = 73|0x300U,   /**< XBARB3_IN73 input is reserved. */
    kXBARB3_InputRESERVED74         = 74|0x300U,   /**< XBARB3_IN74 input is reserved. */
    kXBARB3_InputRESERVED75         = 75|0x300U,   /**< XBARB3_IN75 input is reserved. */
    kXBARB3_InputDec1PosMatch       = 76|0x300U,   /**< DEC1_POS_MATCH output assigned to XBARB3_IN76 input. */
    kXBARB3_InputDec2PosMatch       = 77|0x300U,   /**< DEC2_POS_MATCH output assigned to XBARB3_IN77 input. */
    kXBARB3_InputDec3PosMatch       = 78|0x300U,   /**< DEC3_POS_MATCH output assigned to XBARB3_IN78 input. */
    kXBARB3_InputDec4PosMatch       = 79|0x300U,   /**< DEC4_POS_MATCH output assigned to XBARB3_IN79 input. */
    kXBARB3_InputRESERVED80         = 80|0x300U,   /**< XBARB3_IN80 input is reserved. */
    kXBARB3_InputRESERVED81         = 81|0x300U,   /**< XBARB3_IN81 input is reserved. */
    kXBARB3_InputDmaDone0           = 82|0x300U,   /**< DMA_DONE0 output assigned to XBARB3_IN82 input. */
    kXBARB3_InputDmaDone1           = 83|0x300U,   /**< DMA_DONE1 output assigned to XBARB3_IN83 input. */
    kXBARB3_InputDmaDone2           = 84|0x300U,   /**< DMA_DONE2 output assigned to XBARB3_IN84 input. */
    kXBARB3_InputDmaDone3           = 85|0x300U,   /**< DMA_DONE3 output assigned to XBARB3_IN85 input. */
    kXBARB3_InputDmaDone4           = 86|0x300U,   /**< DMA_DONE4 output assigned to XBARB3_IN86 input. */
    kXBARB3_InputDmaDone5           = 87|0x300U,   /**< DMA_DONE5 output assigned to XBARB3_IN87 input. */
    kXBARB3_InputDmaDone6           = 88|0x300U,   /**< DMA_DONE6 output assigned to XBARB3_IN88 input. */
    kXBARB3_InputDmaDone7           = 89|0x300U,   /**< DMA_DONE7 output assigned to XBARB3_IN89 input. */
    kXBARB3_InputDmaLpsrDone0       = 90|0x300U,   /**< DMA_LPSR_DONE0 output assigned to XBARB3_IN90 input. */
    kXBARB3_InputDmaLpsrDone1       = 91|0x300U,   /**< DMA_LPSR_DONE1 output assigned to XBARB3_IN91 input. */
    kXBARB3_InputDmaLpsrDone2       = 92|0x300U,   /**< DMA_LPSR_DONE2 output assigned to XBARB3_IN92 input. */
    kXBARB3_InputDmaLpsrDone3       = 93|0x300U,   /**< DMA_LPSR_DONE3 output assigned to XBARB3_IN93 input. */
    kXBARB3_InputDmaLpsrDone4       = 94|0x300U,   /**< DMA_LPSR_DONE4 output assigned to XBARB3_IN94 input. */
    kXBARB3_InputDmaLpsrDone5       = 95|0x300U,   /**< DMA_LPSR_DONE5 output assigned to XBARB3_IN95 input. */
    kXBARB3_InputDmaLpsrDone6       = 96|0x300U,   /**< DMA_LPSR_DONE6 output assigned to XBARB3_IN96 input. */
    kXBARB3_InputDmaLpsrDone7       = 97|0x300U,   /**< DMA_LPSR_DONE7 output assigned to XBARB3_IN97 input. */
} xbar_input_signal_t;

typedef enum _xbar_output_signal
{
    kXBARA1_OutputDmaChMuxReq81     = 0|0x100U,    /**< XBARA1_OUT0 output assigned to DMA_CH_MUX_REQ81 */
    kXBARA1_OutputDmaChMuxReq82     = 1|0x100U,    /**< XBARA1_OUT1 output assigned to DMA_CH_MUX_REQ82 */
    kXBARA1_OutputDmaChMuxReq83     = 2|0x100U,    /**< XBARA1_OUT2 output assigned to DMA_CH_MUX_REQ83 */
    kXBARA1_OutputDmaChMuxReq84     = 3|0x100U,    /**< XBARA1_OUT3 output assigned to DMA_CH_MUX_REQ84 */
    kXBARA1_OutputIomuxXbarInout04  = 4|0x100U,    /**< XBARA1_OUT4 output assigned to IOMUX_XBAR_INOUT04 */
    kXBARA1_OutputIomuxXbarInout05  = 5|0x100U,    /**< XBARA1_OUT5 output assigned to IOMUX_XBAR_INOUT05 */
    kXBARA1_OutputIomuxXbarInout06  = 6|0x100U,    /**< XBARA1_OUT6 output assigned to IOMUX_XBAR_INOUT06 */
    kXBARA1_OutputIomuxXbarInout07  = 7|0x100U,    /**< XBARA1_OUT7 output assigned to IOMUX_XBAR_INOUT07 */
    kXBARA1_OutputIomuxXbarInout08  = 8|0x100U,    /**< XBARA1_OUT8 output assigned to IOMUX_XBAR_INOUT08 */
    kXBARA1_OutputIomuxXbarInout09  = 9|0x100U,    /**< XBARA1_OUT9 output assigned to IOMUX_XBAR_INOUT09 */
    kXBARA1_OutputIomuxXbarInout10  = 10|0x100U,   /**< XBARA1_OUT10 output assigned to IOMUX_XBAR_INOUT10 */
    kXBARA1_OutputIomuxXbarInout11  = 11|0x100U,   /**< XBARA1_OUT11 output assigned to IOMUX_XBAR_INOUT11 */
    kXBARA1_OutputIomuxXbarInout12  = 12|0x100U,   /**< XBARA1_OUT12 output assigned to IOMUX_XBAR_INOUT12 */
    kXBARA1_OutputIomuxXbarInout13  = 13|0x100U,   /**< XBARA1_OUT13 output assigned to IOMUX_XBAR_INOUT13 */
    kXBARA1_OutputIomuxXbarInout14  = 14|0x100U,   /**< XBARA1_OUT14 output assigned to IOMUX_XBAR_INOUT14 */
    kXBARA1_OutputIomuxXbarInout15  = 15|0x100U,   /**< XBARA1_OUT15 output assigned to IOMUX_XBAR_INOUT15 */
    kXBARA1_OutputIomuxXbarInout16  = 16|0x100U,   /**< XBARA1_OUT16 output assigned to IOMUX_XBAR_INOUT16 */
    kXBARA1_OutputIomuxXbarInout17  = 17|0x100U,   /**< XBARA1_OUT17 output assigned to IOMUX_XBAR_INOUT17 */
    kXBARA1_OutputIomuxXbarInout18  = 18|0x100U,   /**< XBARA1_OUT18 output assigned to IOMUX_XBAR_INOUT18 */
    kXBARA1_OutputIomuxXbarInout19  = 19|0x100U,   /**< XBARA1_OUT19 output assigned to IOMUX_XBAR_INOUT19 */
    kXBARA1_OutputIomuxXbarInout20  = 20|0x100U,   /**< XBARA1_OUT20 output assigned to IOMUX_XBAR_INOUT20 */
    kXBARA1_OutputIomuxXbarInout21  = 21|0x100U,   /**< XBARA1_OUT21 output assigned to IOMUX_XBAR_INOUT21 */
    kXBARA1_OutputIomuxXbarInout22  = 22|0x100U,   /**< XBARA1_OUT22 output assigned to IOMUX_XBAR_INOUT22 */
    kXBARA1_OutputIomuxXbarInout23  = 23|0x100U,   /**< XBARA1_OUT23 output assigned to IOMUX_XBAR_INOUT23 */
    kXBARA1_OutputIomuxXbarInout24  = 24|0x100U,   /**< XBARA1_OUT24 output assigned to IOMUX_XBAR_INOUT24 */
    kXBARA1_OutputIomuxXbarInout25  = 25|0x100U,   /**< XBARA1_OUT25 output assigned to IOMUX_XBAR_INOUT25 */
    kXBARA1_OutputIomuxXbarInout26  = 26|0x100U,   /**< XBARA1_OUT26 output assigned to IOMUX_XBAR_INOUT26 */
    kXBARA1_OutputIomuxXbarInout27  = 27|0x100U,   /**< XBARA1_OUT27 output assigned to IOMUX_XBAR_INOUT27 */
    kXBARA1_OutputIomuxXbarInout28  = 28|0x100U,   /**< XBARA1_OUT28 output assigned to IOMUX_XBAR_INOUT28 */
    kXBARA1_OutputIomuxXbarInout29  = 29|0x100U,   /**< XBARA1_OUT29 output assigned to IOMUX_XBAR_INOUT29 */
    kXBARA1_OutputIomuxXbarInout30  = 30|0x100U,   /**< XBARA1_OUT30 output assigned to IOMUX_XBAR_INOUT30 */
    kXBARA1_OutputIomuxXbarInout31  = 31|0x100U,   /**< XBARA1_OUT31 output assigned to IOMUX_XBAR_INOUT31 */
    kXBARA1_OutputIomuxXbarInout32  = 32|0x100U,   /**< XBARA1_OUT32 output assigned to IOMUX_XBAR_INOUT32 */
    kXBARA1_OutputIomuxXbarInout33  = 33|0x100U,   /**< XBARA1_OUT33 output assigned to IOMUX_XBAR_INOUT33 */
    kXBARA1_OutputIomuxXbarInout34  = 34|0x100U,   /**< XBARA1_OUT34 output assigned to IOMUX_XBAR_INOUT34 */
    kXBARA1_OutputIomuxXbarInout35  = 35|0x100U,   /**< XBARA1_OUT35 output assigned to IOMUX_XBAR_INOUT35 */
    kXBARA1_OutputIomuxXbarInout36  = 36|0x100U,   /**< XBARA1_OUT36 output assigned to IOMUX_XBAR_INOUT36 */
    kXBARA1_OutputIomuxXbarInout37  = 37|0x100U,   /**< XBARA1_OUT37 output assigned to IOMUX_XBAR_INOUT37 */
    kXBARA1_OutputIomuxXbarInout38  = 38|0x100U,   /**< XBARA1_OUT38 output assigned to IOMUX_XBAR_INOUT38 */
    kXBARA1_OutputIomuxXbarInout39  = 39|0x100U,   /**< XBARA1_OUT39 output assigned to IOMUX_XBAR_INOUT39 */
    kXBARA1_OutputIomuxXbarInout40  = 40|0x100U,   /**< XBARA1_OUT40 output assigned to IOMUX_XBAR_INOUT40 */
    kXBARA1_OutputAcmp1Sample       = 41|0x100U,   /**< XBARA1_OUT41 output assigned to ACMP1_SAMPLE */
    kXBARA1_OutputAcmp2Sample       = 42|0x100U,   /**< XBARA1_OUT42 output assigned to ACMP2_SAMPLE */
    kXBARA1_OutputAcmp3Sample       = 43|0x100U,   /**< XBARA1_OUT43 output assigned to ACMP3_SAMPLE */
    kXBARA1_OutputAcmp4Sample       = 44|0x100U,   /**< XBARA1_OUT44 output assigned to ACMP4_SAMPLE */
    kXBARA1_OutputRESERVED45        = 45|0x100U,   /**< XBARA1_OUT45 output is reserved. */
    kXBARA1_OutputRESERVED46        = 46|0x100U,   /**< XBARA1_OUT46 output is reserved. */
    kXBARA1_OutputRESERVED47        = 47|0x100U,   /**< XBARA1_OUT47 output is reserved. */
    kXBARA1_OutputRESERVED48        = 48|0x100U,   /**< XBARA1_OUT48 output is reserved. */
    kXBARA1_OutputFlexpwm1Pwm0Exta  = 49|0x100U,   /**< XBARA1_OUT49 output assigned to FLEXPWM1_PWM0_EXTA */
    kXBARA1_OutputFlexpwm1Pwm1Exta  = 50|0x100U,   /**< XBARA1_OUT50 output assigned to FLEXPWM1_PWM1_EXTA */
    kXBARA1_OutputFlexpwm1Pwm2Exta  = 51|0x100U,   /**< XBARA1_OUT51 output assigned to FLEXPWM1_PWM2_EXTA */
    kXBARA1_OutputFlexpwm1Pwm3Exta  = 52|0x100U,   /**< XBARA1_OUT52 output assigned to FLEXPWM1_PWM3_EXTA */
    kXBARA1_OutputFlexpwm1Pwm0ExtSync = 53|0x100U, /**< XBARA1_OUT53 output assigned to FLEXPWM1_PWM0_EXT_SYNC */
    kXBARA1_OutputFlexpwm1Pwm1ExtSync = 54|0x100U, /**< XBARA1_OUT54 output assigned to FLEXPWM1_PWM1_EXT_SYNC */
    kXBARA1_OutputFlexpwm1Pwm2ExtSync = 55|0x100U, /**< XBARA1_OUT55 output assigned to FLEXPWM1_PWM2_EXT_SYNC */
    kXBARA1_OutputFlexpwm1Pwm3ExtSync = 56|0x100U, /**< XBARA1_OUT56 output assigned to FLEXPWM1_PWM3_EXT_SYNC */
    kXBARA1_OutputFlexpwm1ExtClk    = 57|0x100U,   /**< XBARA1_OUT57 output assigned to FLEXPWM1_EXT_CLK */
    kXBARA1_OutputFlexpwm1Fault0    = 58|0x100U,   /**< XBARA1_OUT58 output assigned to FLEXPWM1_FAULT0 */
    kXBARA1_OutputFlexpwm1Fault1    = 59|0x100U,   /**< XBARA1_OUT59 output assigned to FLEXPWM1_FAULT1 */
    kXBARA1_OutputFlexpwm1234Fault2 = 60|0x100U,   /**< XBARA1_OUT60 output assigned to FLEXPWM1_2_3_4_FAULT2 */
    kXBARA1_OutputFlexpwm1234Fault3 = 61|0x100U,   /**< XBARA1_OUT61 output assigned to FLEXPWM1_2_3_4_FAULT3 */
    kXBARA1_OutputFlexpwm1ExtForce  = 62|0x100U,   /**< XBARA1_OUT62 output assigned to FLEXPWM1_EXT_FORCE */
    kXBARA1_OutputFlexpwm2Pwm0Exta  = 63|0x100U,   /**< XBARA1_OUT63 output assigned to FLEXPWM2_PWM0_EXTA */
    kXBARA1_OutputFlexpwm2Pwm1Exta  = 64|0x100U,   /**< XBARA1_OUT64 output assigned to FLEXPWM2_PWM1_EXTA */
    kXBARA1_OutputFlexpwm2Pwm2Exta  = 65|0x100U,   /**< XBARA1_OUT65 output assigned to FLEXPWM2_PWM2_EXTA */
    kXBARA1_OutputFlexpwm2Pwm3Exta  = 66|0x100U,   /**< XBARA1_OUT66 output assigned to FLEXPWM2_PWM3_EXTA */
    kXBARA1_OutputFlexpwm2Pwm0ExtSync = 67|0x100U, /**< XBARA1_OUT67 output assigned to FLEXPWM2_PWM0_EXT_SYNC */
    kXBARA1_OutputFlexpwm2Pwm1ExtSync = 68|0x100U, /**< XBARA1_OUT68 output assigned to FLEXPWM2_PWM1_EXT_SYNC */
    kXBARA1_OutputFlexpwm2Pwm2ExtSync = 69|0x100U, /**< XBARA1_OUT69 output assigned to FLEXPWM2_PWM2_EXT_SYNC */
    kXBARA1_OutputFlexpwm2Pwm3ExtSync = 70|0x100U, /**< XBARA1_OUT70 output assigned to FLEXPWM2_PWM3_EXT_SYNC */
    kXBARA1_OutputFlexpwm2ExtClk    = 71|0x100U,   /**< XBARA1_OUT71 output assigned to FLEXPWM2_EXT_CLK */
    kXBARA1_OutputFlexpwm2Fault0    = 72|0x100U,   /**< XBARA1_OUT72 output assigned to FLEXPWM2_FAULT0 */
    kXBARA1_OutputFlexpwm2Fault1    = 73|0x100U,   /**< XBARA1_OUT73 output assigned to FLEXPWM2_FAULT1 */
    kXBARA1_OutputFlexpwm2ExtForce  = 74|0x100U,   /**< XBARA1_OUT74 output assigned to FLEXPWM2_EXT_FORCE */
    kXBARA1_OutputFlexpwm34Pwm0Exta = 75|0x100U,   /**< XBARA1_OUT75 output assigned to FLEXPWM3_4_PWM0_EXTA */
    kXBARA1_OutputFlexpwm34Pwm1Exta = 76|0x100U,   /**< XBARA1_OUT76 output assigned to FLEXPWM3_4_PWM1_EXTA */
    kXBARA1_OutputFlexpwm34Pwm2Exta = 77|0x100U,   /**< XBARA1_OUT77 output assigned to FLEXPWM3_4_PWM2_EXTA */
    kXBARA1_OutputFlexpwm34Pwm3Exta = 78|0x100U,   /**< XBARA1_OUT78 output assigned to FLEXPWM3_4_PWM3_EXTA */
    kXBARA1_OutputFlexpwm34ExtClk   = 79|0x100U,   /**< XBARA1_OUT79 output assigned to FLEXPWM3_4_EXT_CLK */
    kXBARA1_OutputFlexpwm3Pwm0ExtSync = 80|0x100U, /**< XBARA1_OUT80 output assigned to FLEXPWM3_PWM0_EXT_SYNC */
    kXBARA1_OutputFlexpwm3Pwm1ExtSync = 81|0x100U, /**< XBARA1_OUT81 output assigned to FLEXPWM3_PWM1_EXT_SYNC */
    kXBARA1_OutputFlexpwm3Pwm2ExtSync = 82|0x100U, /**< XBARA1_OUT82 output assigned to FLEXPWM3_PWM2_EXT_SYNC */
    kXBARA1_OutputFlexpwm3Pwm3ExtSync = 83|0x100U, /**< XBARA1_OUT83 output assigned to FLEXPWM3_PWM3_EXT_SYNC */
    kXBARA1_OutputFlexpwm3Fault0    = 84|0x100U,   /**< XBARA1_OUT84 output assigned to FLEXPWM3_FAULT0 */
    kXBARA1_OutputFlexpwm3Fault1    = 85|0x100U,   /**< XBARA1_OUT85 output assigned to FLEXPWM3_FAULT1 */
    kXBARA1_OutputFlexpwm3ExtForce  = 86|0x100U,   /**< XBARA1_OUT86 output assigned to FLEXPWM3_EXT_FORCE */
    kXBARA1_OutputFlexpwm4Pwm0ExtSync = 87|0x100U, /**< XBARA1_OUT87 output assigned to FLEXPWM4_PWM0_EXT_SYNC */
    kXBARA1_OutputFlexpwm4Pwm1ExtSync = 88|0x100U, /**< XBARA1_OUT88 output assigned to FLEXPWM4_PWM1_EXT_SYNC */
    kXBARA1_OutputFlexpwm4Pwm2ExtSync = 89|0x100U, /**< XBARA1_OUT89 output assigned to FLEXPWM4_PWM2_EXT_SYNC */
    kXBARA1_OutputFlexpwm4Pwm3ExtSync = 90|0x100U, /**< XBARA1_OUT90 output assigned to FLEXPWM4_PWM3_EXT_SYNC */
    kXBARA1_OutputFlexpwm4Fault0    = 91|0x100U,   /**< XBARA1_OUT91 output assigned to FLEXPWM4_FAULT0 */
    kXBARA1_OutputFlexpwm4Fault1    = 92|0x100U,   /**< XBARA1_OUT92 output assigned to FLEXPWM4_FAULT1 */
    kXBARA1_OutputFlexpwm4ExtForce  = 93|0x100U,   /**< XBARA1_OUT93 output assigned to FLEXPWM4_EXT_FORCE */
    kXBARA1_OutputRESERVED94        = 94|0x100U,   /**< XBARA1_OUT94 output is reserved. */
    kXBARA1_OutputRESERVED95        = 95|0x100U,   /**< XBARA1_OUT95 output is reserved. */
    kXBARA1_OutputRESERVED96        = 96|0x100U,   /**< XBARA1_OUT96 output is reserved. */
    kXBARA1_OutputRESERVED97        = 97|0x100U,   /**< XBARA1_OUT97 output is reserved. */
    kXBARA1_OutputRESERVED98        = 98|0x100U,   /**< XBARA1_OUT98 output is reserved. */
    kXBARA1_OutputRESERVED99        = 99|0x100U,   /**< XBARA1_OUT99 output is reserved. */
    kXBARA1_OutputRESERVED100       = 100|0x100U,  /**< XBARA1_OUT100 output is reserved. */
    kXBARA1_OutputRESERVED101       = 101|0x100U,  /**< XBARA1_OUT101 output is reserved. */
    kXBARA1_OutputRESERVED102       = 102|0x100U,  /**< XBARA1_OUT102 output is reserved. */
    kXBARA1_OutputRESERVED103       = 103|0x100U,  /**< XBARA1_OUT103 output is reserved. */
    kXBARA1_OutputRESERVED104       = 104|0x100U,  /**< XBARA1_OUT104 output is reserved. */
    kXBARA1_OutputRESERVED105       = 105|0x100U,  /**< XBARA1_OUT105 output is reserved. */
    kXBARA1_OutputRESERVED106       = 106|0x100U,  /**< XBARA1_OUT106 output is reserved. */
    kXBARA1_OutputRESERVED107       = 107|0x100U,  /**< XBARA1_OUT107 output is reserved. */
    kXBARA1_OutputDec1Phasea        = 108|0x100U,  /**< XBARA1_OUT108 output assigned to DEC1_PHASEA */
    kXBARA1_OutputDec1Phaseb        = 109|0x100U,  /**< XBARA1_OUT109 output assigned to DEC1_PHASEB */
    kXBARA1_OutputDec1Index         = 110|0x100U,  /**< XBARA1_OUT110 output assigned to DEC1_INDEX */
    kXBARA1_OutputDec1Home          = 111|0x100U,  /**< XBARA1_OUT111 output assigned to DEC1_HOME */
    kXBARA1_OutputDec1Trigger       = 112|0x100U,  /**< XBARA1_OUT112 output assigned to DEC1_TRIGGER */
    kXBARA1_OutputDec2Phasea        = 113|0x100U,  /**< XBARA1_OUT113 output assigned to DEC2_PHASEA */
    kXBARA1_OutputDec2Phaseb        = 114|0x100U,  /**< XBARA1_OUT114 output assigned to DEC2_PHASEB */
    kXBARA1_OutputDec2Index         = 115|0x100U,  /**< XBARA1_OUT115 output assigned to DEC2_INDEX */
    kXBARA1_OutputDec2Home          = 116|0x100U,  /**< XBARA1_OUT116 output assigned to DEC2_HOME */
    kXBARA1_OutputDec2Trigger       = 117|0x100U,  /**< XBARA1_OUT117 output assigned to DEC2_TRIGGER */
    kXBARA1_OutputDec3Phasea        = 118|0x100U,  /**< XBARA1_OUT118 output assigned to DEC3_PHASEA */
    kXBARA1_OutputDec3Phaseb        = 119|0x100U,  /**< XBARA1_OUT119 output assigned to DEC3_PHASEB */
    kXBARA1_OutputDec3Index         = 120|0x100U,  /**< XBARA1_OUT120 output assigned to DEC3_INDEX */
    kXBARA1_OutputDec3Home          = 121|0x100U,  /**< XBARA1_OUT121 output assigned to DEC3_HOME */
    kXBARA1_OutputDec3Trigger       = 122|0x100U,  /**< XBARA1_OUT122 output assigned to DEC3_TRIGGER */
    kXBARA1_OutputDec4Phasea        = 123|0x100U,  /**< XBARA1_OUT123 output assigned to DEC4_PHASEA */
    kXBARA1_OutputDec4Phaseb        = 124|0x100U,  /**< XBARA1_OUT124 output assigned to DEC4_PHASEB */
    kXBARA1_OutputDec4Index         = 125|0x100U,  /**< XBARA1_OUT125 output assigned to DEC4_INDEX */
    kXBARA1_OutputDec4Home          = 126|0x100U,  /**< XBARA1_OUT126 output assigned to DEC4_HOME */
    kXBARA1_OutputDec4Trigger       = 127|0x100U,  /**< XBARA1_OUT127 output assigned to DEC4_TRIGGER */
    kXBARA1_OutputRESERVED128       = 128|0x100U,  /**< XBARA1_OUT128 output is reserved. */
    kXBARA1_OutputRESERVED129       = 129|0x100U,  /**< XBARA1_OUT129 output is reserved. */
    kXBARA1_OutputRESERVED130       = 130|0x100U,  /**< XBARA1_OUT130 output is reserved. */
    kXBARA1_OutputRESERVED131       = 131|0x100U,  /**< XBARA1_OUT131 output is reserved. */
    kXBARA1_OutputCan1              = 132|0x100U,  /**< XBARA1_OUT132 output assigned to CAN1 */
    kXBARA1_OutputCan2              = 133|0x100U,  /**< XBARA1_OUT133 output assigned to CAN2 */
    kXBARA1_OutputRESERVED134       = 134|0x100U,  /**< XBARA1_OUT134 output is reserved. */
    kXBARA1_OutputRESERVED135       = 135|0x100U,  /**< XBARA1_OUT135 output is reserved. */
    kXBARA1_OutputRESERVED136       = 136|0x100U,  /**< XBARA1_OUT136 output is reserved. */
    kXBARA1_OutputRESERVED137       = 137|0x100U,  /**< XBARA1_OUT137 output is reserved. */
    kXBARA1_OutputQtimer1Timer0     = 138|0x100U,  /**< XBARA1_OUT138 output assigned to QTIMER1_TIMER0 */
    kXBARA1_OutputQtimer1Timer1     = 139|0x100U,  /**< XBARA1_OUT139 output assigned to QTIMER1_TIMER1 */
    kXBARA1_OutputQtimer1Timer2     = 140|0x100U,  /**< XBARA1_OUT140 output assigned to QTIMER1_TIMER2 */
    kXBARA1_OutputQtimer1Timer3     = 141|0x100U,  /**< XBARA1_OUT141 output assigned to QTIMER1_TIMER3 */
    kXBARA1_OutputQtimer2Timer0     = 142|0x100U,  /**< XBARA1_OUT142 output assigned to QTIMER2_TIMER0 */
    kXBARA1_OutputQtimer2Timer1     = 143|0x100U,  /**< XBARA1_OUT143 output assigned to QTIMER2_TIMER1 */
    kXBARA1_OutputQtimer2Timer2     = 144|0x100U,  /**< XBARA1_OUT144 output assigned to QTIMER2_TIMER2 */
    kXBARA1_OutputQtimer2Timer3     = 145|0x100U,  /**< XBARA1_OUT145 output assigned to QTIMER2_TIMER3 */
    kXBARA1_OutputQtimer3Timer0     = 146|0x100U,  /**< XBARA1_OUT146 output assigned to QTIMER3_TIMER0 */
    kXBARA1_OutputQtimer3Timer1     = 147|0x100U,  /**< XBARA1_OUT147 output assigned to QTIMER3_TIMER1 */
    kXBARA1_OutputQtimer3Timer2     = 148|0x100U,  /**< XBARA1_OUT148 output assigned to QTIMER3_TIMER2 */
    kXBARA1_OutputQtimer3Timer3     = 149|0x100U,  /**< XBARA1_OUT149 output assigned to QTIMER3_TIMER3 */
    kXBARA1_OutputQtimer4Timer0     = 150|0x100U,  /**< XBARA1_OUT150 output assigned to QTIMER4_TIMER0 */
    kXBARA1_OutputQtimer4Timer1     = 151|0x100U,  /**< XBARA1_OUT151 output assigned to QTIMER4_TIMER1 */
    kXBARA1_OutputQtimer4Timer2     = 152|0x100U,  /**< XBARA1_OUT152 output assigned to QTIMER4_TIMER2 */
    kXBARA1_OutputQtimer4Timer3     = 153|0x100U,  /**< XBARA1_OUT153 output assigned to QTIMER4_TIMER3 */
    kXBARA1_OutputEwmEwmIn          = 154|0x100U,  /**< XBARA1_OUT154 output assigned to EWM_EWM_IN */
    kXBARA1_OutputAdcEtc0Coco0      = 155|0x100U,  /**< XBARA1_OUT155 output assigned to ADC_ETC0_COCO0 */
    kXBARA1_OutputAdcEtc0Coco1      = 156|0x100U,  /**< XBARA1_OUT156 output assigned to ADC_ETC0_COCO1 */
    kXBARA1_OutputAdcEtc0Coco2      = 157|0x100U,  /**< XBARA1_OUT157 output assigned to ADC_ETC0_COCO2 */
    kXBARA1_OutputAdcEtc0Coco3      = 158|0x100U,  /**< XBARA1_OUT158 output assigned to ADC_ETC0_COCO3 */
    kXBARA1_OutputAdcEtc1Coco0      = 159|0x100U,  /**< XBARA1_OUT159 output assigned to ADC_ETC1_COCO0 */
    kXBARA1_OutputAdcEtc1Coco1      = 160|0x100U,  /**< XBARA1_OUT160 output assigned to ADC_ETC1_COCO1 */
    kXBARA1_OutputAdcEtc1Coco2      = 161|0x100U,  /**< XBARA1_OUT161 output assigned to ADC_ETC1_COCO2 */
    kXBARA1_OutputAdcEtc1Coco3      = 162|0x100U,  /**< XBARA1_OUT162 output assigned to ADC_ETC1_COCO3 */
    kXBARA1_OutputRESERVED163       = 163|0x100U,  /**< XBARA1_OUT163 output is reserved. */
    kXBARA1_OutputRESERVED164       = 164|0x100U,  /**< XBARA1_OUT164 output is reserved. */
    kXBARA1_OutputRESERVED165       = 165|0x100U,  /**< XBARA1_OUT165 output is reserved. */
    kXBARA1_OutputRESERVED166       = 166|0x100U,  /**< XBARA1_OUT166 output is reserved. */
    kXBARA1_OutputRESERVED167       = 167|0x100U,  /**< XBARA1_OUT167 output is reserved. */
    kXBARA1_OutputRESERVED168       = 168|0x100U,  /**< XBARA1_OUT168 output is reserved. */
    kXBARA1_OutputRESERVED169       = 169|0x100U,  /**< XBARA1_OUT169 output is reserved. */
    kXBARA1_OutputRESERVED170       = 170|0x100U,  /**< XBARA1_OUT170 output is reserved. */
    kXBARA1_OutputFlexio1TrigIn0    = 171|0x100U,  /**< XBARA1_OUT171 output assigned to FLEXIO1_TRIG_IN0 */
    kXBARA1_OutputFlexio1TrigIn1    = 172|0x100U,  /**< XBARA1_OUT172 output assigned to FLEXIO1_TRIG_IN1 */
    kXBARA1_OutputFlexio2TrigIn0    = 173|0x100U,  /**< XBARA1_OUT173 output assigned to FLEXIO2_TRIG_IN0 */
    kXBARA1_OutputFlexio2TrigIn1    = 174|0x100U,  /**< XBARA1_OUT174 output assigned to FLEXIO2_TRIG_IN1 */
    kXBARB2_OutputAoi1In00          = 0|0x200U,    /**< XBARB2_OUT0 output assigned to AOI1_IN00 */
    kXBARB2_OutputAoi1In01          = 1|0x200U,    /**< XBARB2_OUT1 output assigned to AOI1_IN01 */
    kXBARB2_OutputAoi1In02          = 2|0x200U,    /**< XBARB2_OUT2 output assigned to AOI1_IN02 */
    kXBARB2_OutputAoi1In03          = 3|0x200U,    /**< XBARB2_OUT3 output assigned to AOI1_IN03 */
    kXBARB2_OutputAoi1In04          = 4|0x200U,    /**< XBARB2_OUT4 output assigned to AOI1_IN04 */
    kXBARB2_OutputAoi1In05          = 5|0x200U,    /**< XBARB2_OUT5 output assigned to AOI1_IN05 */
    kXBARB2_OutputAoi1In06          = 6|0x200U,    /**< XBARB2_OUT6 output assigned to AOI1_IN06 */
    kXBARB2_OutputAoi1In07          = 7|0x200U,    /**< XBARB2_OUT7 output assigned to AOI1_IN07 */
    kXBARB2_OutputAoi1In08          = 8|0x200U,    /**< XBARB2_OUT8 output assigned to AOI1_IN08 */
    kXBARB2_OutputAoi1In09          = 9|0x200U,    /**< XBARB2_OUT9 output assigned to AOI1_IN09 */
    kXBARB2_OutputAoi1In10          = 10|0x200U,   /**< XBARB2_OUT10 output assigned to AOI1_IN10 */
    kXBARB2_OutputAoi1In11          = 11|0x200U,   /**< XBARB2_OUT11 output assigned to AOI1_IN11 */
    kXBARB2_OutputAoi1In12          = 12|0x200U,   /**< XBARB2_OUT12 output assigned to AOI1_IN12 */
    kXBARB2_OutputAoi1In13          = 13|0x200U,   /**< XBARB2_OUT13 output assigned to AOI1_IN13 */
    kXBARB2_OutputAoi1In14          = 14|0x200U,   /**< XBARB2_OUT14 output assigned to AOI1_IN14 */
    kXBARB2_OutputAoi1In15          = 15|0x200U,   /**< XBARB2_OUT15 output assigned to AOI1_IN15 */
    kXBARB3_OutputAoi2In00          = 0|0x300U,    /**< XBARB3_OUT0 output assigned to AOI2_IN00 */
    kXBARB3_OutputAoi2In01          = 1|0x300U,    /**< XBARB3_OUT1 output assigned to AOI2_IN01 */
    kXBARB3_OutputAoi2In02          = 2|0x300U,    /**< XBARB3_OUT2 output assigned to AOI2_IN02 */
    kXBARB3_OutputAoi2In03          = 3|0x300U,    /**< XBARB3_OUT3 output assigned to AOI2_IN03 */
    kXBARB3_OutputAoi2In04          = 4|0x300U,    /**< XBARB3_OUT4 output assigned to AOI2_IN04 */
    kXBARB3_OutputAoi2In05          = 5|0x300U,    /**< XBARB3_OUT5 output assigned to AOI2_IN05 */
    kXBARB3_OutputAoi2In06          = 6|0x300U,    /**< XBARB3_OUT6 output assigned to AOI2_IN06 */
    kXBARB3_OutputAoi2In07          = 7|0x300U,    /**< XBARB3_OUT7 output assigned to AOI2_IN07 */
    kXBARB3_OutputAoi2In08          = 8|0x300U,    /**< XBARB3_OUT8 output assigned to AOI2_IN08 */
    kXBARB3_OutputAoi2In09          = 9|0x300U,    /**< XBARB3_OUT9 output assigned to AOI2_IN09 */
    kXBARB3_OutputAoi2In10          = 10|0x300U,   /**< XBARB3_OUT10 output assigned to AOI2_IN10 */
    kXBARB3_OutputAoi2In11          = 11|0x300U,   /**< XBARB3_OUT11 output assigned to AOI2_IN11 */
    kXBARB3_OutputAoi2In12          = 12|0x300U,   /**< XBARB3_OUT12 output assigned to AOI2_IN12 */
    kXBARB3_OutputAoi2In13          = 13|0x300U,   /**< XBARB3_OUT13 output assigned to AOI2_IN13 */
    kXBARB3_OutputAoi2In14          = 14|0x300U,   /**< XBARB3_OUT14 output assigned to AOI2_IN14 */
    kXBARB3_OutputAoi2In15          = 15|0x300U,   /**< XBARB3_OUT15 output assigned to AOI2_IN15 */
} xbar_output_signal_t;

/*!
 * @addtogroup iomuxc_lpsr_pads
 * @{ */

/*******************************************************************************
 * Definitions
*******************************************************************************/

/*!
 * @brief Enumeration for the IOMUXC_LPSR SW_MUX_CTL_PAD
 *
 * Defines the enumeration for the IOMUXC_LPSR SW_MUX_CTL_PAD collections.
 */
typedef enum _iomuxc_lpsr_sw_mux_ctl_pad
{
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_00 = 0U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_01 = 1U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_02 = 2U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_03 = 3U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_04 = 4U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_05 = 5U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_06 = 6U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_07 = 7U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_08 = 8U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_09 = 9U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_10 = 10U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_11 = 11U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_12 = 12U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_13 = 13U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_14 = 14U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_LPSR_SW_MUX_CTL_PAD_GPIO_LPSR_15 = 15U, /**< IOMUXC SW_MUX_CTL_PAD index */
} iomuxc_lpsr_sw_mux_ctl_pad_t;

/* @} */

/*!
 * @addtogroup iomuxc_lpsr_pads
 * @{ */

/*******************************************************************************
 * Definitions
*******************************************************************************/

/*!
 * @brief Enumeration for the IOMUXC_LPSR SW_PAD_CTL_PAD
 *
 * Defines the enumeration for the IOMUXC_LPSR SW_PAD_CTL_PAD collections.
 */
typedef enum _iomuxc_lpsr_sw_pad_ctl_pad
{
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_00 = 0U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_01 = 1U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_02 = 2U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_03 = 3U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_04 = 4U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_05 = 5U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_06 = 6U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_07 = 7U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_08 = 8U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_09 = 9U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_10 = 10U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_11 = 11U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_12 = 12U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_13 = 13U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_14 = 14U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_LPSR_SW_PAD_CTL_PAD_GPIO_LPSR_15 = 15U, /**< IOMUXC SW_PAD_CTL_PAD index */
} iomuxc_lpsr_sw_pad_ctl_pad_t;

/* @} */

/*!
 * @brief Enumeration for the IOMUXC_LPSR select input
 *
 * Defines the enumeration for the IOMUXC_LPSR select input collections.
 */
typedef enum _iomuxc_lpsr_select_input
{
    kIOMUXC_LPSR_CAN3_IPP_IND_CANRX_SELECT_INPUT = 0U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_LPI2C5_IPP_IND_LPI2C_SCL_SELECT_INPUT = 1U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_LPI2C5_IPP_IND_LPI2C_SDA_SELECT_INPUT = 2U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_LPI2C6_IPP_IND_LPI2C_SCL_SELECT_INPUT = 3U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_LPI2C6_IPP_IND_LPI2C_SDA_SELECT_INPUT = 4U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_LPSPI5_IPP_IND_LPSPI_PCS_SELECT_INPUT_0 = 5U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_LPSPI5_IPP_IND_LPSPI_SCK_SELECT_INPUT = 6U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_LPSPI5_IPP_IND_LPSPI_SDI_SELECT_INPUT = 7U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_LPSPI5_IPP_IND_LPSPI_SDO_SELECT_INPUT = 8U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_LPUART11_IPP_IND_LPUART_RXD_SELECT_INPUT = 9U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_LPUART11_IPP_IND_LPUART_TXD_SELECT_INPUT = 10U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_LPUART12_IPP_IND_LPUART_RXD_SELECT_INPUT = 11U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_LPUART12_IPP_IND_LPUART_TXD_SELECT_INPUT = 12U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_MIC_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_0 = 13U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_MIC_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_1 = 14U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_MIC_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_2 = 15U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_MIC_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_3 = 16U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_NMI_GLUE_IPP_IND_NMI_SELECT_INPUT = 17U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_SAI4_IPG_CLK_SAI_MCLK_SELECT_INPUT = 18U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_SAI4_IPP_IND_SAI_RXBCLK_SELECT_INPUT = 19U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_SAI4_IPP_IND_SAI_RXDATA_SELECT_INPUT_0 = 20U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_SAI4_IPP_IND_SAI_RXSYNC_SELECT_INPUT = 21U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_SAI4_IPP_IND_SAI_TXBCLK_SELECT_INPUT = 22U, /**< IOMUXC select input index */
    kIOMUXC_LPSR_SAI4_IPP_IND_SAI_TXSYNC_SELECT_INPUT = 23U, /**< IOMUXC select input index */
} iomuxc_lpsr_select_input_t;

/*!
 * @addtogroup ssarc_mapping
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the SSARC mapping
 *
 * The name of power domain.
 */

typedef enum _ssarc_power_domain_name
{
    kSSARC_MEGAMIXPowerDomain       = 0U,          /**< MEGAMIX Power Domain, request from BPC0. */
    kSSARC_DISPLAYMIXPowerDomain    = 1U,          /**< DISPLAYMIX Power Domain, request from BPC1. */
    kSSARC_WAKEUPMIXPowerDomain     = 2U,          /**< WAKEUPMIX Power Domain, request from BPC2. */
    kSSARC_LPSRMIXPowerDomain       = 3U,          /**< LPSRMIX Power Domain, request from BPC3. */
    kSSARC_PowerDomain4             = 4U,          /**< MIPI PHY Power Domain, request from BPC4. */
    kSSARC_PowerDomain5             = 5U,          /**< Virtual power domain, request from BPC5. */
    kSSARC_PowerDomain6             = 6U,          /**< Virtual power domain, request from BPC6. */
    kSSARC_PowerDomain7             = 7U,          /**< Virtual power domain, request from BPC7. */
} ssarc_power_domain_name_t;

 /*
 * @brief The name of cpu domain.
 */
typedef enum _ssarc_cpu_domain_name
{
    kSSARC_CM7Core                  = 0U,          /**< CM7 Core domain. */
    kSSARC_CM4Core                  = 1U,          /**< CM4 Core domain. */
} ssarc_cpu_domain_name_t;

/* @} */

/*!
 * @addtogroup xrdc2_mapping
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the XRDC2 mapping
 *
 * Defines the structure for the XRDC2 resource collections.
 */

typedef enum _xrdc2_master
{
    kXRDC2_Master_M7_AHB            = 0U,          /**< M7 AHB */
    kXRDC2_Master_M4_AHBC           = 0U,          /**< M4 AHBC */
    kXRDC2_Master_M7_AXI            = 1U,          /**< M7 AXI */
    kXRDC2_Master_M4_AHBS           = 1U,          /**< M4 AHBS */
    kXRDC2_Master_CAAM              = 2U,          /**< CAAM */
    kXRDC2_Master_CSI               = 3U,          /**< CSI */
    kXRDC2_Master_M7_EDMA           = 4U,          /**< M7 EDMA */
    kXRDC2_Master_M4_EDMA           = 4U,          /**< M4 EDMA */
    kXRDC2_Master_ENET              = 5U,          /**< ENET */
    kXRDC2_Master_ENET_1G_RX        = 6U,          /**< ENET_1G_RX */
    kXRDC2_Master_ENET_1G_TX        = 7U,          /**< ENET_1G_TX */
    kXRDC2_Master_ENET_QOS          = 8U,          /**< ENET_QOS */
    kXRDC2_Master_GPU               = 9U,          /**< GPU */
    kXRDC2_Master_LCDIF             = 10U,         /**< LCDIF */
    kXRDC2_Master_LCDIFV2           = 11U,         /**< LCDIFV2 */
    kXRDC2_Master_PXP               = 12U,         /**< PXP */
    kXRDC2_Master_SSARC             = 14U,         /**< SSARC */
    kXRDC2_Master_USB               = 15U,         /**< USB */
    kXRDC2_Master_USDHC1            = 16U,         /**< USDHC1 */
    kXRDC2_Master_USDHC2            = 17U,         /**< USDHC2 */
} xrdc2_master_t;

typedef enum _xrdc2_mem
{
    kXRDC2_Mem_CAAM_Region0         = XRDC2_MAKE_MEM(0, 0), /**< MRC0 Memory 0 */
    kXRDC2_Mem_CAAM_Region1         = XRDC2_MAKE_MEM(0, 1), /**< MRC0 Memory 1 */
    kXRDC2_Mem_CAAM_Region2         = XRDC2_MAKE_MEM(0, 2), /**< MRC0 Memory 2 */
    kXRDC2_Mem_CAAM_Region3         = XRDC2_MAKE_MEM(0, 3), /**< MRC0 Memory 3 */
    kXRDC2_Mem_CAAM_Region4         = XRDC2_MAKE_MEM(0, 4), /**< MRC0 Memory 4 */
    kXRDC2_Mem_CAAM_Region5         = XRDC2_MAKE_MEM(0, 5), /**< MRC0 Memory 5 */
    kXRDC2_Mem_CAAM_Region6         = XRDC2_MAKE_MEM(0, 6), /**< MRC0 Memory 6 */
    kXRDC2_Mem_CAAM_Region7         = XRDC2_MAKE_MEM(0, 7), /**< MRC0 Memory 7 */
    kXRDC2_Mem_CAAM_Region8         = XRDC2_MAKE_MEM(0, 8), /**< MRC0 Memory 8 */
    kXRDC2_Mem_CAAM_Region9         = XRDC2_MAKE_MEM(0, 9), /**< MRC0 Memory 9 */
    kXRDC2_Mem_CAAM_Region10        = XRDC2_MAKE_MEM(0, 10), /**< MRC0 Memory 10 */
    kXRDC2_Mem_CAAM_Region11        = XRDC2_MAKE_MEM(0, 11), /**< MRC0 Memory 11 */
    kXRDC2_Mem_CAAM_Region12        = XRDC2_MAKE_MEM(0, 12), /**< MRC0 Memory 12 */
    kXRDC2_Mem_CAAM_Region13        = XRDC2_MAKE_MEM(0, 13), /**< MRC0 Memory 13 */
    kXRDC2_Mem_CAAM_Region14        = XRDC2_MAKE_MEM(0, 14), /**< MRC0 Memory 14 */
    kXRDC2_Mem_CAAM_Region15        = XRDC2_MAKE_MEM(0, 15), /**< MRC0 Memory 15 */
    kXRDC2_Mem_FLEXSPI1_Region0     = XRDC2_MAKE_MEM(1, 0), /**< MRC1 Memory 0 */
    kXRDC2_Mem_FLEXSPI1_Region1     = XRDC2_MAKE_MEM(1, 1), /**< MRC1 Memory 1 */
    kXRDC2_Mem_FLEXSPI1_Region2     = XRDC2_MAKE_MEM(1, 2), /**< MRC1 Memory 2 */
    kXRDC2_Mem_FLEXSPI1_Region3     = XRDC2_MAKE_MEM(1, 3), /**< MRC1 Memory 3 */
    kXRDC2_Mem_FLEXSPI1_Region4     = XRDC2_MAKE_MEM(1, 4), /**< MRC1 Memory 4 */
    kXRDC2_Mem_FLEXSPI1_Region5     = XRDC2_MAKE_MEM(1, 5), /**< MRC1 Memory 5 */
    kXRDC2_Mem_FLEXSPI1_Region6     = XRDC2_MAKE_MEM(1, 6), /**< MRC1 Memory 6 */
    kXRDC2_Mem_FLEXSPI1_Region7     = XRDC2_MAKE_MEM(1, 7), /**< MRC1 Memory 7 */
    kXRDC2_Mem_FLEXSPI1_Region8     = XRDC2_MAKE_MEM(1, 8), /**< MRC1 Memory 8 */
    kXRDC2_Mem_FLEXSPI1_Region9     = XRDC2_MAKE_MEM(1, 9), /**< MRC1 Memory 9 */
    kXRDC2_Mem_FLEXSPI1_Region10    = XRDC2_MAKE_MEM(1, 10), /**< MRC1 Memory 10 */
    kXRDC2_Mem_FLEXSPI1_Region11    = XRDC2_MAKE_MEM(1, 11), /**< MRC1 Memory 11 */
    kXRDC2_Mem_FLEXSPI1_Region12    = XRDC2_MAKE_MEM(1, 12), /**< MRC1 Memory 12 */
    kXRDC2_Mem_FLEXSPI1_Region13    = XRDC2_MAKE_MEM(1, 13), /**< MRC1 Memory 13 */
    kXRDC2_Mem_FLEXSPI1_Region14    = XRDC2_MAKE_MEM(1, 14), /**< MRC1 Memory 14 */
    kXRDC2_Mem_FLEXSPI1_Region15    = XRDC2_MAKE_MEM(1, 15), /**< MRC1 Memory 15 */
    kXRDC2_Mem_FLEXSPI2_Region0     = XRDC2_MAKE_MEM(2, 0), /**< MRC2 Memory 0 */
    kXRDC2_Mem_FLEXSPI2_Region1     = XRDC2_MAKE_MEM(2, 1), /**< MRC2 Memory 1 */
    kXRDC2_Mem_FLEXSPI2_Region2     = XRDC2_MAKE_MEM(2, 2), /**< MRC2 Memory 2 */
    kXRDC2_Mem_FLEXSPI2_Region3     = XRDC2_MAKE_MEM(2, 3), /**< MRC2 Memory 3 */
    kXRDC2_Mem_FLEXSPI2_Region4     = XRDC2_MAKE_MEM(2, 4), /**< MRC2 Memory 4 */
    kXRDC2_Mem_FLEXSPI2_Region5     = XRDC2_MAKE_MEM(2, 5), /**< MRC2 Memory 5 */
    kXRDC2_Mem_FLEXSPI2_Region6     = XRDC2_MAKE_MEM(2, 6), /**< MRC2 Memory 6 */
    kXRDC2_Mem_FLEXSPI2_Region7     = XRDC2_MAKE_MEM(2, 7), /**< MRC2 Memory 7 */
    kXRDC2_Mem_FLEXSPI2_Region8     = XRDC2_MAKE_MEM(2, 8), /**< MRC2 Memory 8 */
    kXRDC2_Mem_FLEXSPI2_Region9     = XRDC2_MAKE_MEM(2, 9), /**< MRC2 Memory 9 */
    kXRDC2_Mem_FLEXSPI2_Region10    = XRDC2_MAKE_MEM(2, 10), /**< MRC2 Memory 10 */
    kXRDC2_Mem_FLEXSPI2_Region11    = XRDC2_MAKE_MEM(2, 11), /**< MRC2 Memory 11 */
    kXRDC2_Mem_FLEXSPI2_Region12    = XRDC2_MAKE_MEM(2, 12), /**< MRC2 Memory 12 */
    kXRDC2_Mem_FLEXSPI2_Region13    = XRDC2_MAKE_MEM(2, 13), /**< MRC2 Memory 13 */
    kXRDC2_Mem_FLEXSPI2_Region14    = XRDC2_MAKE_MEM(2, 14), /**< MRC2 Memory 14 */
    kXRDC2_Mem_FLEXSPI2_Region15    = XRDC2_MAKE_MEM(2, 15), /**< MRC2 Memory 15 */
    kXRDC2_Mem_M4LMEM_Region0       = XRDC2_MAKE_MEM(3, 0), /**< MRC3 Memory 0 */
    kXRDC2_Mem_M4LMEM_Region1       = XRDC2_MAKE_MEM(3, 1), /**< MRC3 Memory 1 */
    kXRDC2_Mem_M4LMEM_Region2       = XRDC2_MAKE_MEM(3, 2), /**< MRC3 Memory 2 */
    kXRDC2_Mem_M4LMEM_Region3       = XRDC2_MAKE_MEM(3, 3), /**< MRC3 Memory 3 */
    kXRDC2_Mem_M4LMEM_Region4       = XRDC2_MAKE_MEM(3, 4), /**< MRC3 Memory 4 */
    kXRDC2_Mem_M4LMEM_Region5       = XRDC2_MAKE_MEM(3, 5), /**< MRC3 Memory 5 */
    kXRDC2_Mem_M4LMEM_Region6       = XRDC2_MAKE_MEM(3, 6), /**< MRC3 Memory 6 */
    kXRDC2_Mem_M4LMEM_Region7       = XRDC2_MAKE_MEM(3, 7), /**< MRC3 Memory 7 */
    kXRDC2_Mem_M4LMEM_Region8       = XRDC2_MAKE_MEM(3, 8), /**< MRC3 Memory 8 */
    kXRDC2_Mem_M4LMEM_Region9       = XRDC2_MAKE_MEM(3, 9), /**< MRC3 Memory 9 */
    kXRDC2_Mem_M4LMEM_Region10      = XRDC2_MAKE_MEM(3, 10), /**< MRC3 Memory 10 */
    kXRDC2_Mem_M4LMEM_Region11      = XRDC2_MAKE_MEM(3, 11), /**< MRC3 Memory 11 */
    kXRDC2_Mem_M4LMEM_Region12      = XRDC2_MAKE_MEM(3, 12), /**< MRC3 Memory 12 */
    kXRDC2_Mem_M4LMEM_Region13      = XRDC2_MAKE_MEM(3, 13), /**< MRC3 Memory 13 */
    kXRDC2_Mem_M4LMEM_Region14      = XRDC2_MAKE_MEM(3, 14), /**< MRC3 Memory 14 */
    kXRDC2_Mem_M4LMEM_Region15      = XRDC2_MAKE_MEM(3, 15), /**< MRC3 Memory 15 */
    kXRDC2_Mem_M7OC_Region0         = XRDC2_MAKE_MEM(4, 0), /**< MRC4 Memory 0 */
    kXRDC2_Mem_M7OC_Region1         = XRDC2_MAKE_MEM(4, 1), /**< MRC4 Memory 1 */
    kXRDC2_Mem_M7OC_Region2         = XRDC2_MAKE_MEM(4, 2), /**< MRC4 Memory 2 */
    kXRDC2_Mem_M7OC_Region3         = XRDC2_MAKE_MEM(4, 3), /**< MRC4 Memory 3 */
    kXRDC2_Mem_M7OC_Region4         = XRDC2_MAKE_MEM(4, 4), /**< MRC4 Memory 4 */
    kXRDC2_Mem_M7OC_Region5         = XRDC2_MAKE_MEM(4, 5), /**< MRC4 Memory 5 */
    kXRDC2_Mem_M7OC_Region6         = XRDC2_MAKE_MEM(4, 6), /**< MRC4 Memory 6 */
    kXRDC2_Mem_M7OC_Region7         = XRDC2_MAKE_MEM(4, 7), /**< MRC4 Memory 7 */
    kXRDC2_Mem_M7OC_Region8         = XRDC2_MAKE_MEM(4, 8), /**< MRC4 Memory 8 */
    kXRDC2_Mem_M7OC_Region9         = XRDC2_MAKE_MEM(4, 9), /**< MRC4 Memory 9 */
    kXRDC2_Mem_M7OC_Region10        = XRDC2_MAKE_MEM(4, 10), /**< MRC4 Memory 10 */
    kXRDC2_Mem_M7OC_Region11        = XRDC2_MAKE_MEM(4, 11), /**< MRC4 Memory 11 */
    kXRDC2_Mem_M7OC_Region12        = XRDC2_MAKE_MEM(4, 12), /**< MRC4 Memory 12 */
    kXRDC2_Mem_M7OC_Region13        = XRDC2_MAKE_MEM(4, 13), /**< MRC4 Memory 13 */
    kXRDC2_Mem_M7OC_Region14        = XRDC2_MAKE_MEM(4, 14), /**< MRC4 Memory 14 */
    kXRDC2_Mem_M7OC_Region15        = XRDC2_MAKE_MEM(4, 15), /**< MRC4 Memory 15 */
    kXRDC2_Mem_MECC1_Region0        = XRDC2_MAKE_MEM(5, 0), /**< MRC5 Memory 0 */
    kXRDC2_Mem_MECC1_Region1        = XRDC2_MAKE_MEM(5, 1), /**< MRC5 Memory 1 */
    kXRDC2_Mem_MECC1_Region2        = XRDC2_MAKE_MEM(5, 2), /**< MRC5 Memory 2 */
    kXRDC2_Mem_MECC1_Region3        = XRDC2_MAKE_MEM(5, 3), /**< MRC5 Memory 3 */
    kXRDC2_Mem_MECC1_Region4        = XRDC2_MAKE_MEM(5, 4), /**< MRC5 Memory 4 */
    kXRDC2_Mem_MECC1_Region5        = XRDC2_MAKE_MEM(5, 5), /**< MRC5 Memory 5 */
    kXRDC2_Mem_MECC1_Region6        = XRDC2_MAKE_MEM(5, 6), /**< MRC5 Memory 6 */
    kXRDC2_Mem_MECC1_Region7        = XRDC2_MAKE_MEM(5, 7), /**< MRC5 Memory 7 */
    kXRDC2_Mem_MECC1_Region8        = XRDC2_MAKE_MEM(5, 8), /**< MRC5 Memory 8 */
    kXRDC2_Mem_MECC1_Region9        = XRDC2_MAKE_MEM(5, 9), /**< MRC5 Memory 9 */
    kXRDC2_Mem_MECC1_Region10       = XRDC2_MAKE_MEM(5, 10), /**< MRC5 Memory 10 */
    kXRDC2_Mem_MECC1_Region11       = XRDC2_MAKE_MEM(5, 11), /**< MRC5 Memory 11 */
    kXRDC2_Mem_MECC1_Region12       = XRDC2_MAKE_MEM(5, 12), /**< MRC5 Memory 12 */
    kXRDC2_Mem_MECC1_Region13       = XRDC2_MAKE_MEM(5, 13), /**< MRC5 Memory 13 */
    kXRDC2_Mem_MECC1_Region14       = XRDC2_MAKE_MEM(5, 14), /**< MRC5 Memory 14 */
    kXRDC2_Mem_MECC1_Region15       = XRDC2_MAKE_MEM(5, 15), /**< MRC5 Memory 15 */
    kXRDC2_Mem_MECC2_Region0        = XRDC2_MAKE_MEM(6, 0), /**< MRC6 Memory 0 */
    kXRDC2_Mem_MECC2_Region1        = XRDC2_MAKE_MEM(6, 1), /**< MRC6 Memory 1 */
    kXRDC2_Mem_MECC2_Region2        = XRDC2_MAKE_MEM(6, 2), /**< MRC6 Memory 2 */
    kXRDC2_Mem_MECC2_Region3        = XRDC2_MAKE_MEM(6, 3), /**< MRC6 Memory 3 */
    kXRDC2_Mem_MECC2_Region4        = XRDC2_MAKE_MEM(6, 4), /**< MRC6 Memory 4 */
    kXRDC2_Mem_MECC2_Region5        = XRDC2_MAKE_MEM(6, 5), /**< MRC6 Memory 5 */
    kXRDC2_Mem_MECC2_Region6        = XRDC2_MAKE_MEM(6, 6), /**< MRC6 Memory 6 */
    kXRDC2_Mem_MECC2_Region7        = XRDC2_MAKE_MEM(6, 7), /**< MRC6 Memory 7 */
    kXRDC2_Mem_MECC2_Region8        = XRDC2_MAKE_MEM(6, 8), /**< MRC6 Memory 8 */
    kXRDC2_Mem_MECC2_Region9        = XRDC2_MAKE_MEM(6, 9), /**< MRC6 Memory 9 */
    kXRDC2_Mem_MECC2_Region10       = XRDC2_MAKE_MEM(6, 10), /**< MRC6 Memory 10 */
    kXRDC2_Mem_MECC2_Region11       = XRDC2_MAKE_MEM(6, 11), /**< MRC6 Memory 11 */
    kXRDC2_Mem_MECC2_Region12       = XRDC2_MAKE_MEM(6, 12), /**< MRC6 Memory 12 */
    kXRDC2_Mem_MECC2_Region13       = XRDC2_MAKE_MEM(6, 13), /**< MRC6 Memory 13 */
    kXRDC2_Mem_MECC2_Region14       = XRDC2_MAKE_MEM(6, 14), /**< MRC6 Memory 14 */
    kXRDC2_Mem_MECC2_Region15       = XRDC2_MAKE_MEM(6, 15), /**< MRC6 Memory 15 */
    kXRDC2_Mem_SEMC_Region0         = XRDC2_MAKE_MEM(7, 0), /**< MRC7 Memory 0 */
    kXRDC2_Mem_SEMC_Region1         = XRDC2_MAKE_MEM(7, 1), /**< MRC7 Memory 1 */
    kXRDC2_Mem_SEMC_Region2         = XRDC2_MAKE_MEM(7, 2), /**< MRC7 Memory 2 */
    kXRDC2_Mem_SEMC_Region3         = XRDC2_MAKE_MEM(7, 3), /**< MRC7 Memory 3 */
    kXRDC2_Mem_SEMC_Region4         = XRDC2_MAKE_MEM(7, 4), /**< MRC7 Memory 4 */
    kXRDC2_Mem_SEMC_Region5         = XRDC2_MAKE_MEM(7, 5), /**< MRC7 Memory 5 */
    kXRDC2_Mem_SEMC_Region6         = XRDC2_MAKE_MEM(7, 6), /**< MRC7 Memory 6 */
    kXRDC2_Mem_SEMC_Region7         = XRDC2_MAKE_MEM(7, 7), /**< MRC7 Memory 7 */
    kXRDC2_Mem_SEMC_Region8         = XRDC2_MAKE_MEM(7, 8), /**< MRC7 Memory 8 */
    kXRDC2_Mem_SEMC_Region9         = XRDC2_MAKE_MEM(7, 9), /**< MRC7 Memory 9 */
    kXRDC2_Mem_SEMC_Region10        = XRDC2_MAKE_MEM(7, 10), /**< MRC7 Memory 10 */
    kXRDC2_Mem_SEMC_Region11        = XRDC2_MAKE_MEM(7, 11), /**< MRC7 Memory 11 */
    kXRDC2_Mem_SEMC_Region12        = XRDC2_MAKE_MEM(7, 12), /**< MRC7 Memory 12 */
    kXRDC2_Mem_SEMC_Region13        = XRDC2_MAKE_MEM(7, 13), /**< MRC7 Memory 13 */
    kXRDC2_Mem_SEMC_Region14        = XRDC2_MAKE_MEM(7, 14), /**< MRC7 Memory 14 */
    kXRDC2_Mem_SEMC_Region15        = XRDC2_MAKE_MEM(7, 15), /**< MRC7 Memory 15 */
} xrdc2_mem_t;

typedef enum _xrdc2_mem_slot
{
    kXRDC2_MemSlot_GPV0             = 0U,          /**< GPV0 */
    kXRDC2_MemSlot_GPV1             = 1U,          /**< GPV1 */
    kXRDC2_MemSlot_GPV2             = 2U,          /**< GPV2 */
    kXRDC2_MemSlot_ROMCP            = 3U,          /**< ROMCP */
} xrdc2_mem_slot_t;

typedef enum _xrdc2_periph
{
    kXRDC2_Periph_ACMP4             = XRDC2_MAKE_PERIPH(0, 108), /**< ACMP4 */
    kXRDC2_Periph_ACMP3             = XRDC2_MAKE_PERIPH(0, 107), /**< ACMP3 */
    kXRDC2_Periph_ACMP2             = XRDC2_MAKE_PERIPH(0, 106), /**< ACMP2 */
    kXRDC2_Periph_ACMP1             = XRDC2_MAKE_PERIPH(0, 105), /**< ACMP1 */
    kXRDC2_Periph_FLEXPWM4          = XRDC2_MAKE_PERIPH(0, 102), /**< FLEXPWM4 */
    kXRDC2_Periph_FLEXPWM3          = XRDC2_MAKE_PERIPH(0, 101), /**< FLEXPWM3 */
    kXRDC2_Periph_FLEXPWM2          = XRDC2_MAKE_PERIPH(0, 100), /**< FLEXPWM2 */
    kXRDC2_Periph_FLEXPWM1          = XRDC2_MAKE_PERIPH(0, 99 ), /**< FLEXPWM1 */
    kXRDC2_Periph_ENC4              = XRDC2_MAKE_PERIPH(0, 96 ), /**< ENC4 */
    kXRDC2_Periph_ENC3              = XRDC2_MAKE_PERIPH(0, 95 ), /**< ENC3 */
    kXRDC2_Periph_ENC2              = XRDC2_MAKE_PERIPH(0, 94 ), /**< ENC2 */
    kXRDC2_Periph_ENC1              = XRDC2_MAKE_PERIPH(0, 93 ), /**< ENC1 */
    kXRDC2_Periph_QTIMER4           = XRDC2_MAKE_PERIPH(0, 90 ), /**< QTIMER4 */
    kXRDC2_Periph_QTIMER3           = XRDC2_MAKE_PERIPH(0, 89 ), /**< QTIMER3 */
    kXRDC2_Periph_QTIMER2           = XRDC2_MAKE_PERIPH(0, 88 ), /**< QTIMER2 */
    kXRDC2_Periph_QTIMER1           = XRDC2_MAKE_PERIPH(0, 87 ), /**< QTIMER1 */
    kXRDC2_Periph_SIM2              = XRDC2_MAKE_PERIPH(0, 86 ), /**< SIM2 */
    kXRDC2_Periph_SIM1              = XRDC2_MAKE_PERIPH(0, 85 ), /**< SIM1 */
    kXRDC2_Periph_CCM_OBS           = XRDC2_MAKE_PERIPH(0, 84 ), /**< CCM_OBS */
    kXRDC2_Periph_GPIO6             = XRDC2_MAKE_PERIPH(0, 80 ), /**< GPIO6 */
    kXRDC2_Periph_GPIO5             = XRDC2_MAKE_PERIPH(0, 79 ), /**< GPIO5 */
    kXRDC2_Periph_GPIO4             = XRDC2_MAKE_PERIPH(0, 78 ), /**< GPIO4 */
    kXRDC2_Periph_GPIO3             = XRDC2_MAKE_PERIPH(0, 77 ), /**< GPIO3 */
    kXRDC2_Periph_GPIO2             = XRDC2_MAKE_PERIPH(0, 76 ), /**< GPIO2 */
    kXRDC2_Periph_GPIO1             = XRDC2_MAKE_PERIPH(0, 75 ), /**< GPIO1 */
    kXRDC2_Periph_LPSPI4            = XRDC2_MAKE_PERIPH(0, 72 ), /**< LPSPI4 */
    kXRDC2_Periph_LPSPI3            = XRDC2_MAKE_PERIPH(0, 71 ), /**< LPSPI3 */
    kXRDC2_Periph_LPSPI2            = XRDC2_MAKE_PERIPH(0, 70 ), /**< LPSPI2 */
    kXRDC2_Periph_LPSPI1            = XRDC2_MAKE_PERIPH(0, 69 ), /**< LPSPI1 */
    kXRDC2_Periph_LPI2C4            = XRDC2_MAKE_PERIPH(0, 68 ), /**< LPI2C4 */
    kXRDC2_Periph_LPI2C3            = XRDC2_MAKE_PERIPH(0, 67 ), /**< LPI2C3 */
    kXRDC2_Periph_LPI2C2            = XRDC2_MAKE_PERIPH(0, 66 ), /**< LPI2C2 */
    kXRDC2_Periph_LPI2C1            = XRDC2_MAKE_PERIPH(0, 65 ), /**< LPI2C1 */
    kXRDC2_Periph_GPT6              = XRDC2_MAKE_PERIPH(0, 64 ), /**< GPT6 */
    kXRDC2_Periph_GPT5              = XRDC2_MAKE_PERIPH(0, 63 ), /**< GPT5 */
    kXRDC2_Periph_GPT4              = XRDC2_MAKE_PERIPH(0, 62 ), /**< GPT4 */
    kXRDC2_Periph_GPT3              = XRDC2_MAKE_PERIPH(0, 61 ), /**< GPT3 */
    kXRDC2_Periph_GPT2              = XRDC2_MAKE_PERIPH(0, 60 ), /**< GPT2 */
    kXRDC2_Periph_GPT1              = XRDC2_MAKE_PERIPH(0, 59 ), /**< GPT1 */
    kXRDC2_Periph_IOMUXC            = XRDC2_MAKE_PERIPH(0, 58 ), /**< IOMUXC */
    kXRDC2_Periph_IOMUXC_GPR        = XRDC2_MAKE_PERIPH(0, 57 ), /**< IOMUXC_GPR */
    kXRDC2_Periph_KPP               = XRDC2_MAKE_PERIPH(0, 56 ), /**< KPP */
    kXRDC2_Periph_PIT1              = XRDC2_MAKE_PERIPH(0, 54 ), /**< PIT1 */
    kXRDC2_Periph_SEMC              = XRDC2_MAKE_PERIPH(0, 53 ), /**< SEMC */
    kXRDC2_Periph_FLEXSPI2          = XRDC2_MAKE_PERIPH(0, 52 ), /**< FLEXSPI2 */
    kXRDC2_Periph_FLEXSPI1          = XRDC2_MAKE_PERIPH(0, 51 ), /**< FLEXSPI1 */
    kXRDC2_Periph_CAN2              = XRDC2_MAKE_PERIPH(0, 50 ), /**< CAN2 */
    kXRDC2_Periph_CAN1              = XRDC2_MAKE_PERIPH(0, 49 ), /**< CAN1 */
    kXRDC2_Periph_AOI2              = XRDC2_MAKE_PERIPH(0, 47 ), /**< AOI2 */
    kXRDC2_Periph_AOI1              = XRDC2_MAKE_PERIPH(0, 46 ), /**< AOI1 */
    kXRDC2_Periph_FLEXIO2           = XRDC2_MAKE_PERIPH(0, 44 ), /**< FLEXIO2 */
    kXRDC2_Periph_FLEXIO1           = XRDC2_MAKE_PERIPH(0, 43 ), /**< FLEXIO1 */
    kXRDC2_Periph_LPUART10          = XRDC2_MAKE_PERIPH(0, 40 ), /**< LPUART10 */
    kXRDC2_Periph_LPUART9           = XRDC2_MAKE_PERIPH(0, 39 ), /**< LPUART9 */
    kXRDC2_Periph_LPUART8           = XRDC2_MAKE_PERIPH(0, 38 ), /**< LPUART8 */
    kXRDC2_Periph_LPUART7           = XRDC2_MAKE_PERIPH(0, 37 ), /**< LPUART7 */
    kXRDC2_Periph_LPUART6           = XRDC2_MAKE_PERIPH(0, 36 ), /**< LPUART6 */
    kXRDC2_Periph_LPUART5           = XRDC2_MAKE_PERIPH(0, 35 ), /**< LPUART5 */
    kXRDC2_Periph_LPUART4           = XRDC2_MAKE_PERIPH(0, 34 ), /**< LPUART4 */
    kXRDC2_Periph_LPUART3           = XRDC2_MAKE_PERIPH(0, 33 ), /**< LPUART3 */
    kXRDC2_Periph_LPUART2           = XRDC2_MAKE_PERIPH(0, 32 ), /**< LPUART2 */
    kXRDC2_Periph_LPUART1           = XRDC2_MAKE_PERIPH(0, 31 ), /**< LPUART1 */
    kXRDC2_Periph_DMA_CH_MUX        = XRDC2_MAKE_PERIPH(0, 29 ), /**< DMA_CH_MUX */
    kXRDC2_Periph_EDMA              = XRDC2_MAKE_PERIPH(0, 28 ), /**< EDMA */
    kXRDC2_Periph_IEE               = XRDC2_MAKE_PERIPH(0, 27 ), /**< IEE */
    kXRDC2_Periph_DAC               = XRDC2_MAKE_PERIPH(0, 25 ), /**< DAC */
    kXRDC2_Periph_TSC_DIG           = XRDC2_MAKE_PERIPH(0, 23 ), /**< TSC_DIG */
    kXRDC2_Periph_ADC2              = XRDC2_MAKE_PERIPH(0, 21 ), /**< ADC2 */
    kXRDC2_Periph_ADC1              = XRDC2_MAKE_PERIPH(0, 20 ), /**< ADC1 */
    kXRDC2_Periph_ADC_ETC           = XRDC2_MAKE_PERIPH(0, 18 ), /**< ADC_ETC */
    kXRDC2_Periph_XBAR3             = XRDC2_MAKE_PERIPH(0, 17 ), /**< XBAR3 */
    kXRDC2_Periph_XBAR2             = XRDC2_MAKE_PERIPH(0, 16 ), /**< XBAR2 */
    kXRDC2_Periph_XBAR1             = XRDC2_MAKE_PERIPH(0, 15 ), /**< XBAR1 */
    kXRDC2_Periph_WDOG3             = XRDC2_MAKE_PERIPH(0, 14 ), /**< WDOG3 */
    kXRDC2_Periph_WDOG2             = XRDC2_MAKE_PERIPH(0, 13 ), /**< WDOG2 */
    kXRDC2_Periph_WDOG1             = XRDC2_MAKE_PERIPH(0, 12 ), /**< WDOG1 */
    kXRDC2_Periph_EWM               = XRDC2_MAKE_PERIPH(0, 11 ), /**< EWM */
    kXRDC2_Periph_FLEXRAM           = XRDC2_MAKE_PERIPH(0, 10 ), /**< FLEXRAM */
    kXRDC2_Periph_XECC_SEMC         = XRDC2_MAKE_PERIPH(0, 9  ), /**< XECC_SEMC */
    kXRDC2_Periph_XECC_FLEXSPI2     = XRDC2_MAKE_PERIPH(0, 8  ), /**< XECC_FLEXSPI2 */
    kXRDC2_Periph_XECC_FLEXSPI1     = XRDC2_MAKE_PERIPH(0, 7  ), /**< XECC_FLEXSPI1 */
    kXRDC2_Periph_MECC2             = XRDC2_MAKE_PERIPH(0, 6  ), /**< MECC2 */
    kXRDC2_Periph_MECC1             = XRDC2_MAKE_PERIPH(0, 5  ), /**< MECC1 */
    kXRDC2_Periph_MTR               = XRDC2_MAKE_PERIPH(0, 4  ), /**< MTR */
    kXRDC2_Periph_SFA               = XRDC2_MAKE_PERIPH(0, 3  ), /**< SFA */
    kXRDC2_Periph_CAAM_DEBUG_3      = XRDC2_MAKE_PERIPH(1, 51 ), /**< CAAM_DEBUG_3 */
    kXRDC2_Periph_CAAM_DEBUG_2      = XRDC2_MAKE_PERIPH(1, 50 ), /**< CAAM_DEBUG_2 */
    kXRDC2_Periph_CAAM_DEBUG_1      = XRDC2_MAKE_PERIPH(1, 49 ), /**< CAAM_DEBUG_1 */
    kXRDC2_Periph_CAAM_DEBUG_0      = XRDC2_MAKE_PERIPH(1, 48 ), /**< CAAM_DEBUG_0 */
    kXRDC2_Periph_CAAM_RTIC_3       = XRDC2_MAKE_PERIPH(1, 43 ), /**< CAAM_RTIC_3 */
    kXRDC2_Periph_CAAM_RTIC_2       = XRDC2_MAKE_PERIPH(1, 42 ), /**< CAAM_RTIC_2 */
    kXRDC2_Periph_CAAM_RTIC_1       = XRDC2_MAKE_PERIPH(1, 41 ), /**< CAAM_RTIC_1 */
    kXRDC2_Periph_CAAM_RTIC_0       = XRDC2_MAKE_PERIPH(1, 40 ), /**< CAAM_RTIC_0 */
    kXRDC2_Periph_CAAM_JR3_3        = XRDC2_MAKE_PERIPH(1, 35 ), /**< CAAM_JR3_3 */
    kXRDC2_Periph_CAAM_JR3_2        = XRDC2_MAKE_PERIPH(1, 34 ), /**< CAAM_JR3_2 */
    kXRDC2_Periph_CAAM_JR3_1        = XRDC2_MAKE_PERIPH(1, 33 ), /**< CAAM_JR3_1 */
    kXRDC2_Periph_CAAM_JR3_0        = XRDC2_MAKE_PERIPH(1, 32 ), /**< CAAM_JR3_0 */
    kXRDC2_Periph_CAAM_JR2_3        = XRDC2_MAKE_PERIPH(1, 31 ), /**< CAAM_JR2_3 */
    kXRDC2_Periph_CAAM_JR2_2        = XRDC2_MAKE_PERIPH(1, 30 ), /**< CAAM_JR2_2 */
    kXRDC2_Periph_CAAM_JR2_1        = XRDC2_MAKE_PERIPH(1, 29 ), /**< CAAM_JR2_1 */
    kXRDC2_Periph_CAAM_JR2_0        = XRDC2_MAKE_PERIPH(1, 28 ), /**< CAAM_JR2_0 */
    kXRDC2_Periph_CAAM_JR1_3        = XRDC2_MAKE_PERIPH(1, 27 ), /**< CAAM_JR1_3 */
    kXRDC2_Periph_CAAM_JR1_2        = XRDC2_MAKE_PERIPH(1, 26 ), /**< CAAM_JR1_2 */
    kXRDC2_Periph_CAAM_JR1_1        = XRDC2_MAKE_PERIPH(1, 25 ), /**< CAAM_JR1_1 */
    kXRDC2_Periph_CAAM_JR1_0        = XRDC2_MAKE_PERIPH(1, 24 ), /**< CAAM_JR1_0 */
    kXRDC2_Periph_CAAM_JR0_3        = XRDC2_MAKE_PERIPH(1, 23 ), /**< CAAM_JR0_3 */
    kXRDC2_Periph_CAAM_JR0_2        = XRDC2_MAKE_PERIPH(1, 22 ), /**< CAAM_JR0_2 */
    kXRDC2_Periph_CAAM_JR0_1        = XRDC2_MAKE_PERIPH(1, 21 ), /**< CAAM_JR0_1 */
    kXRDC2_Periph_CAAM_JR0_0        = XRDC2_MAKE_PERIPH(1, 20 ), /**< CAAM_JR0_0 */
    kXRDC2_Periph_CAAM_GENERAL_3    = XRDC2_MAKE_PERIPH(1, 19 ), /**< CAAM_GENERAL_3 */
    kXRDC2_Periph_CAAM_GENERAL_2    = XRDC2_MAKE_PERIPH(1, 18 ), /**< CAAM_GENERAL_2 */
    kXRDC2_Periph_CAAM_GENERAL_1    = XRDC2_MAKE_PERIPH(1, 17 ), /**< CAAM_GENERAL_1 */
    kXRDC2_Periph_CAAM_GENERAL_0    = XRDC2_MAKE_PERIPH(1, 16 ), /**< CAAM_GENERAL_0 */
    kXRDC2_Periph_ENET_QOS          = XRDC2_MAKE_PERIPH(1, 15 ), /**< ENET_QOS */
    kXRDC2_Periph_USBPHY2           = XRDC2_MAKE_PERIPH(1, 14 ), /**< USBPHY2 */
    kXRDC2_Periph_USBPHY1           = XRDC2_MAKE_PERIPH(1, 13 ), /**< USBPHY1 */
    kXRDC2_Periph_USB_OTG           = XRDC2_MAKE_PERIPH(1, 12 ), /**< USB_OTG */
    kXRDC2_Periph_USB_OTG2          = XRDC2_MAKE_PERIPH(1, 11 ), /**< USB_OTG2 */
    kXRDC2_Periph_USB_PL301         = XRDC2_MAKE_PERIPH(1, 10 ), /**< USB_PL301 */
    kXRDC2_Periph_ENET              = XRDC2_MAKE_PERIPH(1, 9  ), /**< ENET */
    kXRDC2_Periph_ENET_1G           = XRDC2_MAKE_PERIPH(1, 8  ), /**< ENET_1G */
    kXRDC2_Periph_USDHC2            = XRDC2_MAKE_PERIPH(1, 7  ), /**< USDHC2 */
    kXRDC2_Periph_USDHC1            = XRDC2_MAKE_PERIPH(1, 6  ), /**< USDHC1 */
    kXRDC2_Periph_ASRC              = XRDC2_MAKE_PERIPH(1, 5  ), /**< ASRC */
    kXRDC2_Periph_SAI3              = XRDC2_MAKE_PERIPH(1, 3  ), /**< SAI3 */
    kXRDC2_Periph_SAI2              = XRDC2_MAKE_PERIPH(1, 2  ), /**< SAI2 */
    kXRDC2_Periph_SAI1              = XRDC2_MAKE_PERIPH(1, 1  ), /**< SAI1 */
    kXRDC2_Periph_SPDIF             = XRDC2_MAKE_PERIPH(1, 0  ), /**< SPDIF */
    kXRDC2_Periph_VIDEO_MUX         = XRDC2_MAKE_PERIPH(2, 6  ), /**< VIDEO_MUX */
    kXRDC2_Periph_PXP               = XRDC2_MAKE_PERIPH(2, 5  ), /**< PXP */
    kXRDC2_Periph_MIPI_CSI          = XRDC2_MAKE_PERIPH(2, 4  ), /**< MIPI_CSI */
    kXRDC2_Periph_MIPI_DSI          = XRDC2_MAKE_PERIPH(2, 3  ), /**< MIPI_DSI */
    kXRDC2_Periph_LCDIFV2           = XRDC2_MAKE_PERIPH(2, 2  ), /**< LCDIFV2 */
    kXRDC2_Periph_LCDIF             = XRDC2_MAKE_PERIPH(2, 1  ), /**< LCDIF */
    kXRDC2_Periph_CSI               = XRDC2_MAKE_PERIPH(2, 0  ), /**< CSI */
    kXRDC2_Periph_XRDC2_MGR_M7_3    = XRDC2_MAKE_PERIPH(3, 59 ), /**< XRDC2_MGR_M7_3 */
    kXRDC2_Periph_XRDC2_MGR_M7_2    = XRDC2_MAKE_PERIPH(3, 58 ), /**< XRDC2_MGR_M7_2 */
    kXRDC2_Periph_XRDC2_MGR_M7_1    = XRDC2_MAKE_PERIPH(3, 57 ), /**< XRDC2_MGR_M7_1 */
    kXRDC2_Periph_XRDC2_MGR_M7_0    = XRDC2_MAKE_PERIPH(3, 56 ), /**< XRDC2_MGR_M7_0 */
    kXRDC2_Periph_XRDC2_MGR_M4_3    = XRDC2_MAKE_PERIPH(3, 55 ), /**< XRDC2_MGR_M4_3 */
    kXRDC2_Periph_XRDC2_MGR_M4_2    = XRDC2_MAKE_PERIPH(3, 54 ), /**< XRDC2_MGR_M4_2 */
    kXRDC2_Periph_XRDC2_MGR_M4_1    = XRDC2_MAKE_PERIPH(3, 53 ), /**< XRDC2_MGR_M4_1 */
    kXRDC2_Periph_XRDC2_MGR_M4_0    = XRDC2_MAKE_PERIPH(3, 52 ), /**< XRDC2_MGR_M4_0 */
    kXRDC2_Periph_SEMA2             = XRDC2_MAKE_PERIPH(3, 51 ), /**< SEMA2 */
    kXRDC2_Periph_SEMA_HS           = XRDC2_MAKE_PERIPH(3, 50 ), /**< SEMA_HS */
    kXRDC2_Periph_CCM_1             = XRDC2_MAKE_PERIPH(3, 49 ), /**< CCM_1 */
    kXRDC2_Periph_CCM_0             = XRDC2_MAKE_PERIPH(3, 48 ), /**< CCM_0 */
    kXRDC2_Periph_SSARC_LP          = XRDC2_MAKE_PERIPH(3, 46 ), /**< SSARC_LP */
    kXRDC2_Periph_SSARC_HP          = XRDC2_MAKE_PERIPH(3, 45 ), /**< SSARC_HP */
    kXRDC2_Periph_PIT2              = XRDC2_MAKE_PERIPH(3, 44 ), /**< PIT2 */
    kXRDC2_Periph_OCOTP_CTRL_WRAPPER = XRDC2_MAKE_PERIPH(3, 43 ), /**< OCOTP_CTRL_WRAPPER */
    kXRDC2_Periph_DCDC              = XRDC2_MAKE_PERIPH(3, 42 ), /**< DCDC */
    kXRDC2_Periph_ROMCP             = XRDC2_MAKE_PERIPH(3, 41 ), /**< ROMCP */
    kXRDC2_Periph_GPIO13            = XRDC2_MAKE_PERIPH(3, 40 ), /**< GPIO13 */
    kXRDC2_Periph_SNVS_SRAM         = XRDC2_MAKE_PERIPH(3, 39 ), /**< SNVS_SRAM */
    kXRDC2_Periph_IOMUXC_SNVS_GPR   = XRDC2_MAKE_PERIPH(3, 38 ), /**< IOMUXC_SNVS_GPR */
    kXRDC2_Periph_IOMUXC_SNVS       = XRDC2_MAKE_PERIPH(3, 37 ), /**< IOMUXC_SNVS */
    kXRDC2_Periph_SNVS_HP_WRAPPER   = XRDC2_MAKE_PERIPH(3, 36 ), /**< SNVS_HP_WRAPPER */
    kXRDC2_Periph_PGMC              = XRDC2_MAKE_PERIPH(3, 34 ), /**< PGMC */
    kXRDC2_Periph_ANATOP            = XRDC2_MAKE_PERIPH(3, 33 ), /**< ANATOP */
    kXRDC2_Periph_KEY_MANAGER       = XRDC2_MAKE_PERIPH(3, 32 ), /**< KEY_MANAGER */
    kXRDC2_Periph_RDC               = XRDC2_MAKE_PERIPH(3, 30 ), /**< RDC */
    kXRDC2_Periph_GPIO12            = XRDC2_MAKE_PERIPH(3, 28 ), /**< GPIO12 */
    kXRDC2_Periph_GPIO11            = XRDC2_MAKE_PERIPH(3, 27 ), /**< GPIO11 */
    kXRDC2_Periph_GPIO10            = XRDC2_MAKE_PERIPH(3, 26 ), /**< GPIO10 */
    kXRDC2_Periph_GPIO9             = XRDC2_MAKE_PERIPH(3, 25 ), /**< GPIO9 */
    kXRDC2_Periph_GPIO8             = XRDC2_MAKE_PERIPH(3, 24 ), /**< GPIO8 */
    kXRDC2_Periph_GPIO7             = XRDC2_MAKE_PERIPH(3, 23 ), /**< GPIO7 */
    kXRDC2_Periph_MU_B              = XRDC2_MAKE_PERIPH(3, 19 ), /**< MU_B */
    kXRDC2_Periph_MU_A              = XRDC2_MAKE_PERIPH(3, 18 ), /**< MU_A */
    kXRDC2_Periph_SEMA1             = XRDC2_MAKE_PERIPH(3, 17 ), /**< SEMA1 */
    kXRDC2_Periph_SAI4              = XRDC2_MAKE_PERIPH(3, 16 ), /**< SAI4 */
    kXRDC2_Periph_CAN3              = XRDC2_MAKE_PERIPH(3, 15 ), /**< CAN3 */
    kXRDC2_Periph_LPI2C6            = XRDC2_MAKE_PERIPH(3, 14 ), /**< LPI2C6 */
    kXRDC2_Periph_LPI2C5            = XRDC2_MAKE_PERIPH(3, 13 ), /**< LPI2C5 */
    kXRDC2_Periph_LPSPI6            = XRDC2_MAKE_PERIPH(3, 12 ), /**< LPSPI6 */
    kXRDC2_Periph_LPSPI5            = XRDC2_MAKE_PERIPH(3, 11 ), /**< LPSPI5 */
    kXRDC2_Periph_LPUART12          = XRDC2_MAKE_PERIPH(3, 10 ), /**< LPUART12 */
    kXRDC2_Periph_LPUART11          = XRDC2_MAKE_PERIPH(3, 9  ), /**< LPUART11 */
    kXRDC2_Periph_MIC               = XRDC2_MAKE_PERIPH(3, 8  ), /**< MIC */
    kXRDC2_Periph_DMA_CH_MUX_LPSR   = XRDC2_MAKE_PERIPH(3, 6  ), /**< DMA_CH_MUX_LPSR */
    kXRDC2_Periph_EDMA_LPSR         = XRDC2_MAKE_PERIPH(3, 5  ), /**< EDMA_LPSR */
    kXRDC2_Periph_WDOG4             = XRDC2_MAKE_PERIPH(3, 4  ), /**< WDOG4 */
    kXRDC2_Periph_IOMUXC_LPSR_GPR   = XRDC2_MAKE_PERIPH(3, 3  ), /**< IOMUXC_LPSR_GPR */
    kXRDC2_Periph_IOMUXC_LPSR       = XRDC2_MAKE_PERIPH(3, 2  ), /**< IOMUXC_LPSR */
    kXRDC2_Periph_SRC               = XRDC2_MAKE_PERIPH(3, 1  ), /**< SRC */
    kXRDC2_Periph_GPC               = XRDC2_MAKE_PERIPH(3, 0  ), /**< GPC */
    kXRDC2_Periph_GPU               = XRDC2_MAKE_PERIPH(4, 0  ), /**< GPU */
} xrdc2_periph_t;

/* @} */

/*!
 * @addtogroup edma_request
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the DMA hardware request
 *
 * Defines the structure for the DMA hardware request collections. The user can configure the
 * hardware request into DMAMUX to trigger the DMA transfer accordingly. The index
 * of the hardware request varies according  to the to SoC.
 */
typedef enum _dma_request_source
{
    kDmaRequestMuxFlexIO1Request2Request3 = 1|0x100U, /**< FlexIO1 Request2 and Request3 */
    kDmaRequestMuxFlexIO1Request4Request5 = 2|0x100U, /**< FlexIO1 Request4 and Request5 */
    kDmaRequestMuxFlexIO1Request6Request7 = 3|0x100U, /**< FlexIO1 Request6 and Request7 */
    kDmaRequestMuxFlexIO2Request0Request1 = 4|0x100U, /**< FlexIO2 Request0 and Request1 */
    kDmaRequestMuxFlexIO2Request2Request3 = 5|0x100U, /**< FlexIO2 Request2 and Request3 */
    kDmaRequestMuxFlexIO2Request4Request5 = 6|0x100U, /**< FlexIO2 Request4 and Request5 */
    kDmaRequestMuxFlexIO2Request6Request7 = 7|0x100U, /**< FlexIO2 Request6 and Request7 */
    kDmaRequestMuxLPUART1Tx         = 8|0x100U,    /**< LPUART1 Transmit */
    kDmaRequestMuxLPUART1Rx         = 9|0x100U,    /**< LPUART1 Receive */
    kDmaRequestMuxLPUART2Tx         = 10|0x100U,   /**< LPUART2 Transmit */
    kDmaRequestMuxLPUART2Rx         = 11|0x100U,   /**< LPUART2 Receive */
    kDmaRequestMuxLPUART3Tx         = 12|0x100U,   /**< LPUART3 Transmit */
    kDmaRequestMuxLPUART3Rx         = 13|0x100U,   /**< LPUART3 Receive */
    kDmaRequestMuxLPUART4Tx         = 14|0x100U,   /**< LPUART4 Transmit */
    kDmaRequestMuxLPUART4Rx         = 15|0x100U,   /**< LPUART4 Receive */
    kDmaRequestMuxLPUART5Tx         = 16|0x100U,   /**< LPUART5 Transmit */
    kDmaRequestMuxLPUART5Rx         = 17|0x100U,   /**< LPUART5 Receive */
    kDmaRequestMuxLPUART6Tx         = 18|0x100U,   /**< LPUART6 Transmit */
    kDmaRequestMuxLPUART6Rx         = 19|0x100U,   /**< LPUART6 Receive */
    kDmaRequestMuxLPUART7Tx         = 20|0x100U,   /**< LPUART7 Transmit */
    kDmaRequestMuxLPUART7Rx         = 21|0x100U,   /**< LPUART7 Receive */
    kDmaRequestMuxLPUART8Tx         = 22|0x100U,   /**< LPUART8 Transmit */
    kDmaRequestMuxLPUART8Rx         = 23|0x100U,   /**< LPUART8 Receive */
    kDmaRequestMuxLPUART9Tx         = 24|0x100U,   /**< LPUART9 Transmit */
    kDmaRequestMuxLPUART9Rx         = 25|0x100U,   /**< LPUART9 Receive */
    kDmaRequestMuxLPUART10Tx        = 26|0x100U,   /**< LPUART10 Transmit */
    kDmaRequestMuxLPUART10Rx        = 27|0x100U,   /**< LPUART10 Receive */
    kDmaRequestMuxLPUART11Tx        = 28|0x100U,   /**< LPUART11 Transmit */
    kDmaRequestMuxLPUART11Rx        = 29|0x100U,   /**< LPUART11 Receive */
    kDmaRequestMuxLPUART12Tx        = 30|0x100U,   /**< LPUART12 Transmit */
    kDmaRequestMuxLPUART12Rx        = 31|0x100U,   /**< LPUART12 Receive */
    kDmaRequestMuxCSI               = 32|0x100U,   /**< CSI */
    kDmaRequestMuxPxp               = 33|0x100U,   /**< PXP */
    kDmaRequestMuxeLCDIF            = 34|0x100U,   /**< eLCDIF */
    kDmaRequestMuxLCDIFv2           = 35|0x100U,   /**< LCDIFv2 */
    kDmaRequestMuxLPSPI1Rx          = 36|0x100U,   /**< LPSPI1 Receive */
    kDmaRequestMuxLPSPI1Tx          = 37|0x100U,   /**< LPSPI1 Transmit */
    kDmaRequestMuxLPSPI2Rx          = 38|0x100U,   /**< LPSPI2 Receive */
    kDmaRequestMuxLPSPI2Tx          = 39|0x100U,   /**< LPSPI2 Transmit */
    kDmaRequestMuxLPSPI3Rx          = 40|0x100U,   /**< LPSPI3 Receive */
    kDmaRequestMuxLPSPI3Tx          = 41|0x100U,   /**< LPSPI3 Transmit */
    kDmaRequestMuxLPSPI4Rx          = 42|0x100U,   /**< LPSPI4 Receive */
    kDmaRequestMuxLPSPI4Tx          = 43|0x100U,   /**< LPSPI4 Transmit */
    kDmaRequestMuxLPSPI5Rx          = 44|0x100U,   /**< LPSPI5 Receive */
    kDmaRequestMuxLPSPI5Tx          = 45|0x100U,   /**< LPSPI5 Transmit */
    kDmaRequestMuxLPSPI6Rx          = 46|0x100U,   /**< LPSPI6 Receive */
    kDmaRequestMuxLPSPI6Tx          = 47|0x100U,   /**< LPSPI6 Transmit */
    kDmaRequestMuxLPI2C1            = 48|0x100U,   /**< LPI2C1 */
    kDmaRequestMuxLPI2C2            = 49|0x100U,   /**< LPI2C2 */
    kDmaRequestMuxLPI2C3            = 50|0x100U,   /**< LPI2C3 */
    kDmaRequestMuxLPI2C4            = 51|0x100U,   /**< LPI2C4 */
    kDmaRequestMuxLPI2C5            = 52|0x100U,   /**< LPI2C5 */
    kDmaRequestMuxLPI2C6            = 53|0x100U,   /**< LPI2C6 */
    kDmaRequestMuxSai1Rx            = 54|0x100U,   /**< SAI1 Receive */
    kDmaRequestMuxSai1Tx            = 55|0x100U,   /**< SAI1 Transmit */
    kDmaRequestMuxSai2Rx            = 56|0x100U,   /**< SAI2 Receive */
    kDmaRequestMuxSai2Tx            = 57|0x100U,   /**< SAI2 Transmit */
    kDmaRequestMuxSai3Rx            = 58|0x100U,   /**< SAI3 Receive */
    kDmaRequestMuxSai3Tx            = 59|0x100U,   /**< SAI3 Transmit */
    kDmaRequestMuxSai4Rx            = 60|0x100U,   /**< SAI4 Receive */
    kDmaRequestMuxSai4Tx            = 61|0x100U,   /**< SAI4 Transmit */
    kDmaRequestMuxSpdifRx           = 62|0x100U,   /**< SPDIF Receive */
    kDmaRequestMuxSpdifTx           = 63|0x100U,   /**< SPDIF Transmit */
    kDmaRequestMuxADC_ETC           = 64|0x100U,   /**< ADC_ETC */
    kDmaRequestMuxFlexIO1Request0Request1 = 65|0x100U, /**< FlexIO1 Request0 and Request1 */
    kDmaRequestMuxADC1              = 66|0x100U,   /**< ADC1 */
    kDmaRequestMuxADC2              = 67|0x100U,   /**< ADC2 */
    kDmaRequestMuxACMP1             = 69|0x100U,   /**< ACMP1 */
    kDmaRequestMuxACMP2             = 70|0x100U,   /**< ACMP2 */
    kDmaRequestMuxACMP3             = 71|0x100U,   /**< ACMP3 */
    kDmaRequestMuxACMP4             = 72|0x100U,   /**< ACMP4 */
    kDmaRequestMuxFlexSPI1Rx        = 77|0x100U,   /**< FlexSPI1 Receive */
    kDmaRequestMuxFlexSPI1Tx        = 78|0x100U,   /**< FlexSPI1 Transmit */
    kDmaRequestMuxFlexSPI2Rx        = 79|0x100U,   /**< FlexSPI2 Receive */
    kDmaRequestMuxFlexSPI2Tx        = 80|0x100U,   /**< FlexSPI2 Transmit */
    kDmaRequestMuxXBAR1Request0     = 81|0x100U,   /**< XBAR1 Request 0 */
    kDmaRequestMuxXBAR1Request1     = 82|0x100U,   /**< XBAR1 Request 1 */
    kDmaRequestMuxXBAR1Request2     = 83|0x100U,   /**< XBAR1 Request 2 */
    kDmaRequestMuxXBAR1Request3     = 84|0x100U,   /**< XBAR1 Request 3 */
    kDmaRequestMuxFlexPWM1CaptureSub0 = 85|0x100U, /**< FlexPWM1 Capture sub-module0 */
    kDmaRequestMuxFlexPWM1CaptureSub1 = 86|0x100U, /**< FlexPWM1 Capture sub-module1 */
    kDmaRequestMuxFlexPWM1CaptureSub2 = 87|0x100U, /**< FlexPWM1 Capture sub-module2 */
    kDmaRequestMuxFlexPWM1CaptureSub3 = 88|0x100U, /**< FlexPWM1 Capture sub-module3 */
    kDmaRequestMuxFlexPWM1ValueSub0 = 89|0x100U,   /**< FlexPWM1 Value sub-module 0 */
    kDmaRequestMuxFlexPWM1ValueSub1 = 90|0x100U,   /**< FlexPWM1 Value sub-module 1 */
    kDmaRequestMuxFlexPWM1ValueSub2 = 91|0x100U,   /**< FlexPWM1 Value sub-module 2 */
    kDmaRequestMuxFlexPWM1ValueSub3 = 92|0x100U,   /**< FlexPWM1 Value sub-module 3 */
    kDmaRequestMuxFlexPWM2CaptureSub0 = 93|0x100U, /**< FlexPWM2 Capture sub-module0 */
    kDmaRequestMuxFlexPWM2CaptureSub1 = 94|0x100U, /**< FlexPWM2 Capture sub-module1 */
    kDmaRequestMuxFlexPWM2CaptureSub2 = 95|0x100U, /**< FlexPWM2 Capture sub-module2 */
    kDmaRequestMuxFlexPWM2CaptureSub3 = 96|0x100U, /**< FlexPWM2 Capture sub-module3 */
    kDmaRequestMuxFlexPWM2ValueSub0 = 97|0x100U,   /**< FlexPWM2 Value sub-module 0 */
    kDmaRequestMuxFlexPWM2ValueSub1 = 98|0x100U,   /**< FlexPWM2 Value sub-module 1 */
    kDmaRequestMuxFlexPWM2ValueSub2 = 99|0x100U,   /**< FlexPWM2 Value sub-module 2 */
    kDmaRequestMuxFlexPWM2ValueSub3 = 100|0x100U,  /**< FlexPWM2 Value sub-module 3 */
    kDmaRequestMuxFlexPWM3CaptureSub0 = 101|0x100U, /**< FlexPWM3 Capture sub-module0 */
    kDmaRequestMuxFlexPWM3CaptureSub1 = 102|0x100U, /**< FlexPWM3 Capture sub-module1 */
    kDmaRequestMuxFlexPWM3CaptureSub2 = 103|0x100U, /**< FlexPWM3 Capture sub-module2 */
    kDmaRequestMuxFlexPWM3CaptureSub3 = 104|0x100U, /**< FlexPWM3 Capture sub-module3 */
    kDmaRequestMuxFlexPWM3ValueSub0 = 105|0x100U,  /**< FlexPWM3 Value sub-module 0 */
    kDmaRequestMuxFlexPWM3ValueSub1 = 106|0x100U,  /**< FlexPWM3 Value sub-module 1 */
    kDmaRequestMuxFlexPWM3ValueSub2 = 107|0x100U,  /**< FlexPWM3 Value sub-module 2 */
    kDmaRequestMuxFlexPWM3ValueSub3 = 108|0x100U,  /**< FlexPWM3 Value sub-module 3 */
    kDmaRequestMuxFlexPWM4CaptureSub0 = 109|0x100U, /**< FlexPWM4 Capture sub-module0 */
    kDmaRequestMuxFlexPWM4CaptureSub1 = 110|0x100U, /**< FlexPWM4 Capture sub-module1 */
    kDmaRequestMuxFlexPWM4CaptureSub2 = 111|0x100U, /**< FlexPWM4 Capture sub-module2 */
    kDmaRequestMuxFlexPWM4CaptureSub3 = 112|0x100U, /**< FlexPWM4 Capture sub-module3 */
    kDmaRequestMuxFlexPWM4ValueSub0 = 113|0x100U,  /**< FlexPWM4 Value sub-module 0 */
    kDmaRequestMuxFlexPWM4ValueSub1 = 114|0x100U,  /**< FlexPWM4 Value sub-module 1 */
    kDmaRequestMuxFlexPWM4ValueSub2 = 115|0x100U,  /**< FlexPWM4 Value sub-module 2 */
    kDmaRequestMuxFlexPWM4ValueSub3 = 116|0x100U,  /**< FlexPWM4 Value sub-module 3 */
    kDmaRequestMuxQTIMER1CaptTimer0 = 133|0x100U,  /**< TMR1 Capture timer 0 */
    kDmaRequestMuxQTIMER1CaptTimer1 = 134|0x100U,  /**< TMR1 Capture timer 1 */
    kDmaRequestMuxQTIMER1CaptTimer2 = 135|0x100U,  /**< TMR1 Capture timer 2 */
    kDmaRequestMuxQTIMER1CaptTimer3 = 136|0x100U,  /**< TMR1 Capture timer 3 */
    kDmaRequestMuxQTIMER1Cmpld1Timer0Cmpld2Timer1 = 137|0x100U, /**< TMR1 cmpld1 in timer 0 or cmpld2 in timer 1 */
    kDmaRequestMuxQTIMER1Cmpld1Timer1Cmpld2Timer0 = 138|0x100U, /**< TMR1 cmpld1 in timer 1 or cmpld2 in timer 0 */
    kDmaRequestMuxQTIMER1Cmpld1Timer2Cmpld2Timer3 = 139|0x100U, /**< TMR1 cmpld1 in timer 2 or cmpld2 in timer 3 */
    kDmaRequestMuxQTIMER1Cmpld1Timer3Cmpld2Timer2 = 140|0x100U, /**< TMR1 cmpld1 in timer 3 or cmpld2 in timer 2 */
    kDmaRequestMuxQTIMER2CaptTimer0 = 141|0x100U,  /**< TMR2 Capture timer 0 */
    kDmaRequestMuxQTIMER2CaptTimer1 = 142|0x100U,  /**< TMR2 Capture timer 1 */
    kDmaRequestMuxQTIMER2CaptTimer2 = 143|0x100U,  /**< TMR2 Capture timer 2 */
    kDmaRequestMuxQTIMER2CaptTimer3 = 144|0x100U,  /**< TMR2 Capture timer 3 */
    kDmaRequestMuxQTIMER2Cmpld1Timer0Cmpld2Timer1 = 145|0x100U, /**< TMR2 cmpld1 in timer 0 or cmpld2 in timer 1 */
    kDmaRequestMuxQTIMER2Cmpld1Timer1Cmpld2Timer0 = 146|0x100U, /**< TMR2 cmpld1 in timer 1 or cmpld2 in timer 0 */
    kDmaRequestMuxQTIMER2Cmpld1Timer2Cmpld2Timer3 = 147|0x100U, /**< TMR2 cmpld1 in timer 2 or cmpld2 in timer 3 */
    kDmaRequestMuxQTIMER2Cmpld1Timer3Cmpld2Timer2 = 148|0x100U, /**< TMR2 cmpld1 in timer 3 or cmpld2 in timer 2 */
    kDmaRequestMuxQTIMER3CaptTimer0 = 149|0x100U,  /**< TMR3 Capture timer 0 */
    kDmaRequestMuxQTIMER3CaptTimer1 = 150|0x100U,  /**< TMR3 Capture timer 1 */
    kDmaRequestMuxQTIMER3CaptTimer2 = 151|0x100U,  /**< TMR3 Capture timer 2 */
    kDmaRequestMuxQTIMER3CaptTimer3 = 152|0x100U,  /**< TMR3 Capture timer 3 */
    kDmaRequestMuxQTIMER3Cmpld1Timer0Cmpld2Timer1 = 153|0x100U, /**< TMR3 cmpld1 in timer 0 or cmpld2 in timer 1 */
    kDmaRequestMuxQTIMER3Cmpld1Timer1Cmpld2Timer0 = 154|0x100U, /**< TMR3 cmpld1 in timer 1 or cmpld2 in timer 0 */
    kDmaRequestMuxQTIMER3Cmpld1Timer2Cmpld2Timer3 = 155|0x100U, /**< TMR3 cmpld1 in timer 2 or cmpld2 in timer 3 */
    kDmaRequestMuxQTIMER3Cmpld1Timer3Cmpld2Timer2 = 156|0x100U, /**< TMR3 cmpld1 in timer 3 or cmpld2 in timer 2 */
    kDmaRequestMuxQTIMER4CaptTimer0 = 157|0x100U,  /**< TMR4 Capture timer 0 */
    kDmaRequestMuxQTIMER4CaptTimer1 = 158|0x100U,  /**< TMR4 Capture timer 1 */
    kDmaRequestMuxQTIMER4CaptTimer2 = 159|0x100U,  /**< TMR4 Capture timer 2 */
    kDmaRequestMuxQTIMER4CaptTimer3 = 160|0x100U,  /**< TMR4 Capture timer 3 */
    kDmaRequestMuxQTIMER4Cmpld1Timer0Cmpld2Timer1 = 161|0x100U, /**< TMR4 cmpld1 in timer 0 or cmpld2 in timer 1 */
    kDmaRequestMuxQTIMER4Cmpld1Timer1Cmpld2Timer0 = 162|0x100U, /**< TMR4 cmpld1 in timer 1 or cmpld2 in timer 0 */
    kDmaRequestMuxQTIMER4Cmpld1Timer2Cmpld2Timer3 = 163|0x100U, /**< TMR4 cmpld1 in timer 2 or cmpld2 in timer 3 */
    kDmaRequestMuxQTIMER4Cmpld1Timer3Cmpld2Timer2 = 164|0x100U, /**< TMR4 cmpld1 in timer 3 or cmpld2 in timer 2 */
    kDmaRequestMuxPdm               = 181|0x100U,  /**< PDM */
    kDmaRequestMuxEnetTimer0        = 182|0x100U,  /**< ENET Timer0 */
    kDmaRequestMuxEnetTimer1        = 183|0x100U,  /**< ENET Timer1 */
    kDmaRequestMuxEnet1GTimer0      = 184|0x100U,  /**< ENET 1G Timer0 */
    kDmaRequestMuxEnet1GTimer1      = 185|0x100U,  /**< ENET 1G Timer1 */
    kDmaRequestMuxCAN1              = 186|0x100U,  /**< CAN1 */
    kDmaRequestMuxCAN2              = 187|0x100U,  /**< CAN2 */
    kDmaRequestMuxCAN3              = 188|0x100U,  /**< CAN3 */
    kDmaRequestMuxDAC               = 189|0x100U,  /**< DAC */
    kDmaRequestMuxASRCRequest1      = 191|0x100U,  /**< ASRC request 1 pair A input request */
    kDmaRequestMuxASRCRequest2      = 192|0x100U,  /**< ASRC request 2 pair B input request */
    kDmaRequestMuxASRCRequest3      = 193|0x100U,  /**< ASRC request 3 pair C input request */
    kDmaRequestMuxASRCRequest4      = 194|0x100U,  /**< ASRC request 4 pair A output request */
    kDmaRequestMuxASRCRequest5      = 195|0x100U,  /**< ASRC request 5 pair B output request */
    kDmaRequestMuxASRCRequest6      = 196|0x100U,  /**< ASRC request 6 pair C output request */
    kDmaRequestMuxEmvsim1Tx         = 197|0x100U,  /**< Emvsim1 Transmit */
    kDmaRequestMuxEmvsim1Rx         = 198|0x100U,  /**< Emvsim1 Receive */
    kDmaRequestMuxEmvsim2Tx         = 199|0x100U,  /**< Emvsim2 Transmit */
    kDmaRequestMuxEmvsim2Rx         = 200|0x100U,  /**< Emvsim2 Receive */
    kDmaRequestMuxEnetQosTimer0     = 201|0x100U,  /**< ENET_QOS Timer0 */
    kDmaRequestMuxEnetQosTimer1     = 202|0x100U,  /**< ENET_QOS Timer1 */
} dma_request_source_t;

/* @} */

/*!
 * @addtogroup iomuxc_pads
 * @{ */

/*******************************************************************************
 * Definitions
*******************************************************************************/

/*!
 * @brief Enumeration for the IOMUXC SW_MUX_CTL_PAD
 *
 * Defines the enumeration for the IOMUXC SW_MUX_CTL_PAD collections.
 */
typedef enum _iomuxc_sw_mux_ctl_pad
{
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_00 = 0U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_01 = 1U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_02 = 2U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_03 = 3U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_04 = 4U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_05 = 5U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_06 = 6U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_07 = 7U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_08 = 8U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_09 = 9U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_10 = 10U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_11 = 11U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_12 = 12U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_13 = 13U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_14 = 14U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_15 = 15U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_16 = 16U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_17 = 17U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_18 = 18U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_19 = 19U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_20 = 20U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_21 = 21U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_22 = 22U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_23 = 23U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_24 = 24U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_25 = 25U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_26 = 26U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_27 = 27U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_28 = 28U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_29 = 29U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_30 = 30U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_31 = 31U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_32 = 32U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_33 = 33U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_34 = 34U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_35 = 35U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_36 = 36U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_37 = 37U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_38 = 38U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_39 = 39U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_40 = 40U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B1_41 = 41U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_00 = 42U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_01 = 43U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_02 = 44U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_03 = 45U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_04 = 46U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_05 = 47U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_06 = 48U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_07 = 49U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_08 = 50U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_09 = 51U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_10 = 52U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_11 = 53U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_12 = 54U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_13 = 55U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_14 = 56U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_15 = 57U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_16 = 58U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_17 = 59U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_18 = 60U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_19 = 61U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_B2_20 = 62U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_00 = 63U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_01 = 64U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_02 = 65U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_03 = 66U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_04 = 67U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_05 = 68U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_06 = 69U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_07 = 70U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_08 = 71U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_09 = 72U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_10 = 73U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_11 = 74U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_12 = 75U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_13 = 76U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_14 = 77U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_15 = 78U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_16 = 79U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_17 = 80U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_18 = 81U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_19 = 82U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_20 = 83U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_21 = 84U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_22 = 85U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_23 = 86U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_24 = 87U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_25 = 88U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_26 = 89U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_27 = 90U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_28 = 91U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_29 = 92U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_30 = 93U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_31 = 94U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_32 = 95U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_33 = 96U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_34 = 97U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_AD_35 = 98U,       /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_00 = 99U,    /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_01 = 100U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_02 = 101U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_03 = 102U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_04 = 103U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B1_05 = 104U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B2_00 = 105U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B2_01 = 106U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B2_02 = 107U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B2_03 = 108U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B2_04 = 109U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B2_05 = 110U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B2_06 = 111U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B2_07 = 112U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B2_08 = 113U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B2_09 = 114U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B2_10 = 115U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B2_11 = 116U,   /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B1_00 = 117U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B1_01 = 118U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B1_02 = 119U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B1_03 = 120U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B1_04 = 121U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B1_05 = 122U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B1_06 = 123U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B1_07 = 124U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B1_08 = 125U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B1_09 = 126U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B1_10 = 127U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B1_11 = 128U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_00 = 129U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_01 = 130U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_02 = 131U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_03 = 132U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_04 = 133U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_05 = 134U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_06 = 135U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_07 = 136U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_08 = 137U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_09 = 138U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_10 = 139U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_11 = 140U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_12 = 141U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_13 = 142U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_14 = 143U, /**< IOMUXC SW_MUX_CTL_PAD index */
    kIOMUXC_SW_MUX_CTL_PAD_GPIO_DISP_B2_15 = 144U, /**< IOMUXC SW_MUX_CTL_PAD index */
} iomuxc_sw_mux_ctl_pad_t;

/* @} */

/*!
 * @addtogroup iomuxc_pads
 * @{ */

/*******************************************************************************
 * Definitions
*******************************************************************************/

/*!
 * @brief Enumeration for the IOMUXC SW_PAD_CTL_PAD
 *
 * Defines the enumeration for the IOMUXC SW_PAD_CTL_PAD collections.
 */
typedef enum _iomuxc_sw_pad_ctl_pad
{
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_00 = 0U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_01 = 1U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_02 = 2U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_03 = 3U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_04 = 4U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_05 = 5U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_06 = 6U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_07 = 7U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_08 = 8U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_09 = 9U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_10 = 10U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_11 = 11U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_12 = 12U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_13 = 13U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_14 = 14U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_15 = 15U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_16 = 16U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_17 = 17U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_18 = 18U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_19 = 19U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_20 = 20U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_21 = 21U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_22 = 22U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_23 = 23U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_24 = 24U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_25 = 25U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_26 = 26U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_27 = 27U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_28 = 28U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_29 = 29U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_30 = 30U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_31 = 31U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_32 = 32U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_33 = 33U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_34 = 34U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_35 = 35U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_36 = 36U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_37 = 37U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_38 = 38U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_39 = 39U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_40 = 40U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B1_41 = 41U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_00 = 42U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_01 = 43U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_02 = 44U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_03 = 45U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_04 = 46U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_05 = 47U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_06 = 48U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_07 = 49U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_08 = 50U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_09 = 51U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_10 = 52U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_11 = 53U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_12 = 54U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_13 = 55U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_14 = 56U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_15 = 57U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_16 = 58U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_17 = 59U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_18 = 60U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_19 = 61U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_EMC_B2_20 = 62U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_00 = 63U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_01 = 64U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_02 = 65U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_03 = 66U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_04 = 67U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_05 = 68U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_06 = 69U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_07 = 70U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_08 = 71U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_09 = 72U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_10 = 73U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_11 = 74U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_12 = 75U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_13 = 76U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_14 = 77U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_15 = 78U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_16 = 79U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_17 = 80U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_18 = 81U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_19 = 82U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_20 = 83U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_21 = 84U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_22 = 85U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_23 = 86U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_24 = 87U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_25 = 88U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_26 = 89U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_27 = 90U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_28 = 91U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_29 = 92U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_30 = 93U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_31 = 94U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_32 = 95U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_33 = 96U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_34 = 97U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_AD_35 = 98U,       /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B1_00 = 99U,    /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B1_01 = 100U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B1_02 = 101U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B1_03 = 102U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B1_04 = 103U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B1_05 = 104U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B2_00 = 105U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B2_01 = 106U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B2_02 = 107U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B2_03 = 108U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B2_04 = 109U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B2_05 = 110U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B2_06 = 111U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B2_07 = 112U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B2_08 = 113U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B2_09 = 114U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B2_10 = 115U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_SD_B2_11 = 116U,   /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B1_00 = 117U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B1_01 = 118U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B1_02 = 119U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B1_03 = 120U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B1_04 = 121U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B1_05 = 122U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B1_06 = 123U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B1_07 = 124U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B1_08 = 125U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B1_09 = 126U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B1_10 = 127U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B1_11 = 128U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_00 = 129U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_01 = 130U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_02 = 131U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_03 = 132U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_04 = 133U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_05 = 134U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_06 = 135U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_07 = 136U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_08 = 137U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_09 = 138U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_10 = 139U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_11 = 140U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_12 = 141U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_13 = 142U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_14 = 143U, /**< IOMUXC SW_PAD_CTL_PAD index */
    kIOMUXC_SW_PAD_CTL_PAD_GPIO_DISP_B2_15 = 144U, /**< IOMUXC SW_PAD_CTL_PAD index */
} iomuxc_sw_pad_ctl_pad_t;

/* @} */

/*!
 * @brief Enumeration for the IOMUXC select input
 *
 * Defines the enumeration for the IOMUXC select input collections.
 */
typedef enum _iomuxc_select_input
{
    kIOMUXC_FLEXCAN1_RX_SELECT_INPUT = 0U,         /**< IOMUXC select input index */
    kIOMUXC_FLEXCAN2_RX_SELECT_INPUT = 1U,         /**< IOMUXC select input index */
    kIOMUXC_CCM_ENET_QOS_REF_CLK_SELECT_INPUT = 2U, /**< IOMUXC select input index */
    kIOMUXC_CCM_ENET_QOS_TX_CLK_SELECT_INPUT = 3U, /**< IOMUXC select input index */
    kIOMUXC_ENET_IPG_CLK_RMII_SELECT_INPUT = 4U,   /**< IOMUXC select input index */
    kIOMUXC_ENET_MAC0_MDIO_SELECT_INPUT = 5U,      /**< IOMUXC select input index */
    kIOMUXC_ENET_MAC0_RXDATA_SELECT_INPUT_0 = 6U,  /**< IOMUXC select input index */
    kIOMUXC_ENET_MAC0_RXDATA_SELECT_INPUT_1 = 7U,  /**< IOMUXC select input index */
    kIOMUXC_ENET_MAC0_RXEN_SELECT_INPUT = 8U,      /**< IOMUXC select input index */
    kIOMUXC_ENET_MAC0_RXERR_SELECT_INPUT = 9U,     /**< IOMUXC select input index */
    kIOMUXC_ENET_MAC0_TXCLK_SELECT_INPUT = 10U,    /**< IOMUXC select input index */
    kIOMUXC_ENET_1G_IPG_CLK_RMII_SELECT_INPUT = 11U, /**< IOMUXC select input index */
    kIOMUXC_ENET_1G_MAC0_MDIO_SELECT_INPUT = 12U,  /**< IOMUXC select input index */
    kIOMUXC_ENET_1G_MAC0_RXCLK_SELECT_INPUT = 13U, /**< IOMUXC select input index */
    kIOMUXC_ENET_1G_MAC0_RXDATA_0_SELECT_INPUT = 14U, /**< IOMUXC select input index */
    kIOMUXC_ENET_1G_MAC0_RXDATA_1_SELECT_INPUT = 15U, /**< IOMUXC select input index */
    kIOMUXC_ENET_1G_MAC0_RXDATA_2_SELECT_INPUT = 16U, /**< IOMUXC select input index */
    kIOMUXC_ENET_1G_MAC0_RXDATA_3_SELECT_INPUT = 17U, /**< IOMUXC select input index */
    kIOMUXC_ENET_1G_MAC0_RXEN_SELECT_INPUT = 18U,  /**< IOMUXC select input index */
    kIOMUXC_ENET_1G_MAC0_RXERR_SELECT_INPUT = 19U, /**< IOMUXC select input index */
    kIOMUXC_ENET_1G_MAC0_TXCLK_SELECT_INPUT = 20U, /**< IOMUXC select input index */
    kIOMUXC_ENET_QOS_GMII_MDI_I_SELECT_INPUT = 21U, /**< IOMUXC select input index */
    kIOMUXC_ENET_QOS_PHY_RXD_I_SELECT_INPUT_0 = 22U, /**< IOMUXC select input index */
    kIOMUXC_ENET_QOS_PHY_RXD_I_SELECT_INPUT_1 = 23U, /**< IOMUXC select input index */
    kIOMUXC_ENET_QOS_PHY_RXDV_I_SELECT_INPUT = 24U, /**< IOMUXC select input index */
    kIOMUXC_ENET_QOS_PHY_RXER_I_SELECT_INPUT = 25U, /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM1_PWMA_SELECT_INPUT_0 = 26U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM1_PWMA_SELECT_INPUT_1 = 27U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM1_PWMA_SELECT_INPUT_2 = 28U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM1_PWMB_SELECT_INPUT_0 = 29U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM1_PWMB_SELECT_INPUT_1 = 30U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM1_PWMB_SELECT_INPUT_2 = 31U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM2_PWMA_SELECT_INPUT_0 = 32U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM2_PWMA_SELECT_INPUT_1 = 33U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM2_PWMA_SELECT_INPUT_2 = 34U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM2_PWMB_SELECT_INPUT_0 = 35U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM2_PWMB_SELECT_INPUT_1 = 36U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM2_PWMB_SELECT_INPUT_2 = 37U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM3_PWMA_SELECT_INPUT_0 = 38U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM3_PWMA_SELECT_INPUT_1 = 39U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM3_PWMA_SELECT_INPUT_2 = 40U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM3_PWMA_SELECT_INPUT_3 = 41U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM3_PWMB_SELECT_INPUT_0 = 42U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM3_PWMB_SELECT_INPUT_1 = 43U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM3_PWMB_SELECT_INPUT_2 = 44U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXPWM3_PWMB_SELECT_INPUT_3 = 45U,    /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI1_I_DQS_FA_SELECT_INPUT = 46U,  /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI1_I_IO_FA_SELECT_INPUT_0 = 47U, /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI1_I_IO_FA_SELECT_INPUT_1 = 48U, /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI1_I_IO_FA_SELECT_INPUT_2 = 49U, /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI1_I_IO_FA_SELECT_INPUT_3 = 50U, /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI1_I_IO_FB_SELECT_INPUT_0 = 51U, /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI1_I_IO_FB_SELECT_INPUT_1 = 52U, /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI1_I_IO_FB_SELECT_INPUT_2 = 53U, /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI1_I_IO_FB_SELECT_INPUT_3 = 54U, /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI1_I_SCK_FA_SELECT_INPUT = 55U,  /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI1_I_SCK_FB_SELECT_INPUT = 56U,  /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI2_I_IO_FA_SELECT_INPUT_0 = 57U, /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI2_I_IO_FA_SELECT_INPUT_1 = 58U, /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI2_I_IO_FA_SELECT_INPUT_2 = 59U, /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI2_I_IO_FA_SELECT_INPUT_3 = 60U, /**< IOMUXC select input index */
    kIOMUXC_FLEXSPI2_I_SCK_FA_SELECT_INPUT = 61U,  /**< IOMUXC select input index */
    kIOMUXC_GPT3_CAPIN1_SELECT_INPUT = 62U,        /**< IOMUXC select input index */
    kIOMUXC_GPT3_CAPIN2_SELECT_INPUT = 63U,        /**< IOMUXC select input index */
    kIOMUXC_GPT3_CLKIN_SELECT_INPUT = 64U,         /**< IOMUXC select input index */
    kIOMUXC_KPP_COL_SELECT_INPUT_6  = 65U,         /**< IOMUXC select input index */
    kIOMUXC_KPP_COL_SELECT_INPUT_7  = 66U,         /**< IOMUXC select input index */
    kIOMUXC_KPP_ROW_SELECT_INPUT_6  = 67U,         /**< IOMUXC select input index */
    kIOMUXC_KPP_ROW_SELECT_INPUT_7  = 68U,         /**< IOMUXC select input index */
    kIOMUXC_LPI2C1_LPI2C_SCL_SELECT_INPUT = 69U,   /**< IOMUXC select input index */
    kIOMUXC_LPI2C1_LPI2C_SDA_SELECT_INPUT = 70U,   /**< IOMUXC select input index */
    kIOMUXC_LPI2C2_LPI2C_SCL_SELECT_INPUT = 71U,   /**< IOMUXC select input index */
    kIOMUXC_LPI2C2_LPI2C_SDA_SELECT_INPUT = 72U,   /**< IOMUXC select input index */
    kIOMUXC_LPI2C3_LPI2C_SCL_SELECT_INPUT = 73U,   /**< IOMUXC select input index */
    kIOMUXC_LPI2C3_LPI2C_SDA_SELECT_INPUT = 74U,   /**< IOMUXC select input index */
    kIOMUXC_LPI2C4_LPI2C_SCL_SELECT_INPUT = 75U,   /**< IOMUXC select input index */
    kIOMUXC_LPI2C4_LPI2C_SDA_SELECT_INPUT = 76U,   /**< IOMUXC select input index */
    kIOMUXC_LPSPI1_LPSPI_PCS_SELECT_INPUT_0 = 77U, /**< IOMUXC select input index */
    kIOMUXC_LPSPI1_LPSPI_SCK_SELECT_INPUT = 78U,   /**< IOMUXC select input index */
    kIOMUXC_LPSPI1_LPSPI_SDI_SELECT_INPUT = 79U,   /**< IOMUXC select input index */
    kIOMUXC_LPSPI1_LPSPI_SDO_SELECT_INPUT = 80U,   /**< IOMUXC select input index */
    kIOMUXC_LPSPI2_LPSPI_PCS_SELECT_INPUT_0 = 81U, /**< IOMUXC select input index */
    kIOMUXC_LPSPI2_LPSPI_PCS_SELECT_INPUT_1 = 82U, /**< IOMUXC select input index */
    kIOMUXC_LPSPI2_LPSPI_SCK_SELECT_INPUT = 83U,   /**< IOMUXC select input index */
    kIOMUXC_LPSPI2_LPSPI_SDI_SELECT_INPUT = 84U,   /**< IOMUXC select input index */
    kIOMUXC_LPSPI2_LPSPI_SDO_SELECT_INPUT = 85U,   /**< IOMUXC select input index */
    kIOMUXC_LPSPI3_LPSPI_PCS_SELECT_INPUT_0 = 86U, /**< IOMUXC select input index */
    kIOMUXC_LPSPI3_LPSPI_PCS_SELECT_INPUT_1 = 87U, /**< IOMUXC select input index */
    kIOMUXC_LPSPI3_LPSPI_PCS_SELECT_INPUT_2 = 88U, /**< IOMUXC select input index */
    kIOMUXC_LPSPI3_LPSPI_PCS_SELECT_INPUT_3 = 89U, /**< IOMUXC select input index */
    kIOMUXC_LPSPI3_LPSPI_SCK_SELECT_INPUT = 90U,   /**< IOMUXC select input index */
    kIOMUXC_LPSPI3_LPSPI_SDI_SELECT_INPUT = 91U,   /**< IOMUXC select input index */
    kIOMUXC_LPSPI3_LPSPI_SDO_SELECT_INPUT = 92U,   /**< IOMUXC select input index */
    kIOMUXC_LPSPI4_LPSPI_PCS_SELECT_INPUT_0 = 93U, /**< IOMUXC select input index */
    kIOMUXC_LPSPI4_LPSPI_SCK_SELECT_INPUT = 94U,   /**< IOMUXC select input index */
    kIOMUXC_LPSPI4_LPSPI_SDI_SELECT_INPUT = 95U,   /**< IOMUXC select input index */
    kIOMUXC_LPSPI4_LPSPI_SDO_SELECT_INPUT = 96U,   /**< IOMUXC select input index */
    kIOMUXC_LPUART1_LPUART_RXD_SELECT_INPUT = 97U, /**< IOMUXC select input index */
    kIOMUXC_LPUART1_LPUART_TXD_SELECT_INPUT = 98U, /**< IOMUXC select input index */
    kIOMUXC_LPUART10_LPUART_RXD_SELECT_INPUT = 99U, /**< IOMUXC select input index */
    kIOMUXC_LPUART10_LPUART_TXD_SELECT_INPUT = 100U, /**< IOMUXC select input index */
    kIOMUXC_LPUART7_LPUART_RXD_SELECT_INPUT = 101U, /**< IOMUXC select input index */
    kIOMUXC_LPUART7_LPUART_TXD_SELECT_INPUT = 102U, /**< IOMUXC select input index */
    kIOMUXC_LPUART8_LPUART_RXD_SELECT_INPUT = 103U, /**< IOMUXC select input index */
    kIOMUXC_LPUART8_LPUART_TXD_SELECT_INPUT = 104U, /**< IOMUXC select input index */
    kIOMUXC_QTIMER1_TMR0_INPUT_SELECT_INPUT = 105U, /**< IOMUXC select input index */
    kIOMUXC_QTIMER1_TMR1_INPUT_SELECT_INPUT = 106U, /**< IOMUXC select input index */
    kIOMUXC_QTIMER1_TMR2_INPUT_SELECT_INPUT = 107U, /**< IOMUXC select input index */
    kIOMUXC_QTIMER2_TMR0_INPUT_SELECT_INPUT = 108U, /**< IOMUXC select input index */
    kIOMUXC_QTIMER2_TMR1_INPUT_SELECT_INPUT = 109U, /**< IOMUXC select input index */
    kIOMUXC_QTIMER2_TMR2_INPUT_SELECT_INPUT = 110U, /**< IOMUXC select input index */
    kIOMUXC_QTIMER3_TMR0_INPUT_SELECT_INPUT = 111U, /**< IOMUXC select input index */
    kIOMUXC_QTIMER3_TMR1_INPUT_SELECT_INPUT = 112U, /**< IOMUXC select input index */
    kIOMUXC_QTIMER3_TMR2_INPUT_SELECT_INPUT = 113U, /**< IOMUXC select input index */
    kIOMUXC_QTIMER4_TMR0_INPUT_SELECT_INPUT = 114U, /**< IOMUXC select input index */
    kIOMUXC_QTIMER4_TMR1_INPUT_SELECT_INPUT = 115U, /**< IOMUXC select input index */
    kIOMUXC_QTIMER4_TMR2_INPUT_SELECT_INPUT = 116U, /**< IOMUXC select input index */
    kIOMUXC_SAI1_IPG_CLK_SAI_MCLK_SELECT_INPUT = 117U, /**< IOMUXC select input index */
    kIOMUXC_SAI1_SAI_RXBCLK_SELECT_INPUT = 118U,   /**< IOMUXC select input index */
    kIOMUXC_SAI1_SAI_RXDATA_SELECT_INPUT_0 = 119U, /**< IOMUXC select input index */
    kIOMUXC_SAI1_SAI_RXSYNC_SELECT_INPUT = 120U,   /**< IOMUXC select input index */
    kIOMUXC_SAI1_SAI_TXBCLK_SELECT_INPUT = 121U,   /**< IOMUXC select input index */
    kIOMUXC_SAI1_SAI_TXSYNC_SELECT_INPUT = 122U,   /**< IOMUXC select input index */
    kIOMUXC_EMVSIM1_SIO_SELECT_INPUT = 129U,       /**< IOMUXC select input index */
    kIOMUXC_EMVSIM1_IPP_SIMPD_SELECT_INPUT = 130U, /**< IOMUXC select input index */
    kIOMUXC_EMVSIM1_POWER_FAIL_SELECT_INPUT = 131U, /**< IOMUXC select input index */
    kIOMUXC_EMVSIM2_SIO_SELECT_INPUT = 132U,       /**< IOMUXC select input index */
    kIOMUXC_EMVSIM2_IPP_SIMPD_SELECT_INPUT = 133U, /**< IOMUXC select input index */
    kIOMUXC_EMVSIM2_POWER_FAIL_SELECT_INPUT = 134U, /**< IOMUXC select input index */
    kIOMUXC_SPDIF_SPDIF_IN1_SELECT_INPUT = 135U,   /**< IOMUXC select input index */
    kIOMUXC_USB_OTG2_OC_SELECT_INPUT = 136U,       /**< IOMUXC select input index */
    kIOMUXC_USB_OTG_OC_SELECT_INPUT = 137U,        /**< IOMUXC select input index */
    kIOMUXC_USBPHY1_USB_ID_SELECT_INPUT = 138U,    /**< IOMUXC select input index */
    kIOMUXC_USBPHY2_USB_ID_SELECT_INPUT = 139U,    /**< IOMUXC select input index */
    kIOMUXC_USDHC1_IPP_CARD_DET_SELECT_INPUT = 140U, /**< IOMUXC select input index */
    kIOMUXC_USDHC1_IPP_WP_ON_SELECT_INPUT = 141U,  /**< IOMUXC select input index */
    kIOMUXC_USDHC2_IPP_CARD_DET_SELECT_INPUT = 142U, /**< IOMUXC select input index */
    kIOMUXC_USDHC2_IPP_WP_ON_SELECT_INPUT = 143U,  /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_20 = 144U,       /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_21 = 145U,       /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_22 = 146U,       /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_23 = 147U,       /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_24 = 148U,       /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_25 = 149U,       /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_26 = 150U,       /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_27 = 151U,       /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_28 = 152U,       /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_29 = 153U,       /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_30 = 154U,       /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_31 = 155U,       /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_32 = 156U,       /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_33 = 157U,       /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_34 = 158U,       /**< IOMUXC select input index */
    kIOMUXC_XBAR1_IN_SELECT_INPUT_35 = 159U,       /**< IOMUXC select input index */
} iomuxc_select_input_t;


/*!
 * @}
 */ /* end of group Mapping_Information */


/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__CWCC__)
  #pragma push
  #pragma cpp_extensions on
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
       uint8_t RESERVED_0[8];
  __IO uint32_t CTRL;                              /**< LPADC Control Register, offset: 0x10 */
  __IO uint32_t STAT;                              /**< LPADC Status Register, offset: 0x14 */
  __IO uint32_t IE;                                /**< Interrupt Enable Register, offset: 0x18 */
  __IO uint32_t DE;                                /**< DMA Enable Register, offset: 0x1C */
  __IO uint32_t CFG;                               /**< LPADC Configuration Register, offset: 0x20 */
  __IO uint32_t PAUSE;                             /**< LPADC Pause Register, offset: 0x24 */
       uint8_t RESERVED_1[8];
  __IO uint32_t FCTRL;                             /**< LPADC FIFO Control Register, offset: 0x30 */
  __O  uint32_t SWTRIG;                            /**< Software Trigger Register, offset: 0x34 */
       uint8_t RESERVED_2[136];
  __IO uint32_t TCTRL[8];                          /**< Trigger Control Register, array offset: 0xC0, array step: 0x4 */
       uint8_t RESERVED_3[32];
  struct {                                         /* offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDL;                              /**< LPADC Command Low Buffer Register, array offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDH;                              /**< LPADC Command High Buffer Register, array offset: 0x104, array step: 0x8 */
  } CMD[15];
       uint8_t RESERVED_4[136];
  __IO uint32_t CV[4];                             /**< Compare Value Register, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_5[240];
  __I  uint32_t RESFIFO;                           /**< LPADC Data Result FIFO Register, offset: 0x300 */
} ADC_Type;

/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/*! @name VERID - Version ID Register */
/*! @{ */

#define ADC_VERID_RES_MASK                       (0x1U)
#define ADC_VERID_RES_SHIFT                      (0U)
/*! RES - Resolution
 *  0b0..Up to 13-bit differential/12-bit single ended resolution supported.
 *  0b1..Up to 16-bit differential/15-bit single ended resolution supported.
 */
#define ADC_VERID_RES(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_RES_SHIFT)) & ADC_VERID_RES_MASK)

#define ADC_VERID_DIFFEN_MASK                    (0x2U)
#define ADC_VERID_DIFFEN_SHIFT                   (1U)
/*! DIFFEN - Differential Supported
 *  0b0..Differential operation not supported.
 *  0b1..Differential operation supported. CMDLa[DIFF] and CMDLa[ABSEL] control fields implemented.
 */
#define ADC_VERID_DIFFEN(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_DIFFEN_SHIFT)) & ADC_VERID_DIFFEN_MASK)

#define ADC_VERID_MVI_MASK                       (0x8U)
#define ADC_VERID_MVI_SHIFT                      (3U)
/*! MVI - Multi Vref Implemented
 *  0b0..Single voltage reference input supported.
 *  0b1..Multiple voltage reference inputs supported.
 */
#define ADC_VERID_MVI(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MVI_SHIFT)) & ADC_VERID_MVI_MASK)

#define ADC_VERID_CSW_MASK                       (0x70U)
#define ADC_VERID_CSW_SHIFT                      (4U)
/*! CSW - Channel Scale Width
 *  0b000..Channel scaling not supported.
 *  0b001..Channel scaling supported. 1-bit CSCALE control field.
 *  0b110..Channel scaling supported. 6-bit CSCALE control field.
 */
#define ADC_VERID_CSW(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CSW_SHIFT)) & ADC_VERID_CSW_MASK)

#define ADC_VERID_VR1RNGI_MASK                   (0x100U)
#define ADC_VERID_VR1RNGI_SHIFT                  (8U)
/*! VR1RNGI - Voltage Reference 1 Range Control Bit Implemented
 *  0b0..Range control not required. CFG[VREF1RNG] is not implemented.
 *  0b1..Range control required. CFG[VREF1RNG] is implemented.
 */
#define ADC_VERID_VR1RNGI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_VR1RNGI_SHIFT)) & ADC_VERID_VR1RNGI_MASK)

#define ADC_VERID_IADCKI_MASK                    (0x200U)
#define ADC_VERID_IADCKI_SHIFT                   (9U)
/*! IADCKI - Internal LPADC Clock implemented
 *  0b0..Internal clock source not implemented.
 *  0b1..Internal clock source (and CFG[ADCKEN]) implemented.
 */
#define ADC_VERID_IADCKI(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_IADCKI_SHIFT)) & ADC_VERID_IADCKI_MASK)

#define ADC_VERID_CALOFSI_MASK                   (0x400U)
#define ADC_VERID_CALOFSI_SHIFT                  (10U)
/*! CALOFSI - Calibration Offset Function Implemented
 *  0b0..Offset calibration and offset trimming not implemented.
 *  0b1..Offset calibration and offset trimming implemented.
 */
#define ADC_VERID_CALOFSI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CALOFSI_SHIFT)) & ADC_VERID_CALOFSI_MASK)

#define ADC_VERID_MINOR_MASK                     (0xFF0000U)
#define ADC_VERID_MINOR_SHIFT                    (16U)
/*! MINOR - Minor Version Number
 */
#define ADC_VERID_MINOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MINOR_SHIFT)) & ADC_VERID_MINOR_MASK)

#define ADC_VERID_MAJOR_MASK                     (0xFF000000U)
#define ADC_VERID_MAJOR_SHIFT                    (24U)
/*! MAJOR - Major Version Number
 */
#define ADC_VERID_MAJOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MAJOR_SHIFT)) & ADC_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter Register */
/*! @{ */

#define ADC_PARAM_TRIG_NUM_MASK                  (0xFFU)
#define ADC_PARAM_TRIG_NUM_SHIFT                 (0U)
/*! TRIG_NUM - Trigger Number
 *  0b00001000..8 hardware triggers implemented
 */
#define ADC_PARAM_TRIG_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_TRIG_NUM_SHIFT)) & ADC_PARAM_TRIG_NUM_MASK)

#define ADC_PARAM_FIFOSIZE_MASK                  (0xFF00U)
#define ADC_PARAM_FIFOSIZE_SHIFT                 (8U)
/*! FIFOSIZE - Result FIFO Depth
 *  0b00010000..Result FIFO depth = 16 datawords.
 */
#define ADC_PARAM_FIFOSIZE(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_FIFOSIZE_SHIFT)) & ADC_PARAM_FIFOSIZE_MASK)

#define ADC_PARAM_CV_NUM_MASK                    (0xFF0000U)
#define ADC_PARAM_CV_NUM_SHIFT                   (16U)
/*! CV_NUM - Compare Value Number
 *  0b00000100..4 compare value registers implemented
 */
#define ADC_PARAM_CV_NUM(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CV_NUM_SHIFT)) & ADC_PARAM_CV_NUM_MASK)

#define ADC_PARAM_CMD_NUM_MASK                   (0xFF000000U)
#define ADC_PARAM_CMD_NUM_SHIFT                  (24U)
/*! CMD_NUM - Command Buffer Number
 *  0b00001111..15 command buffers implemented
 */
#define ADC_PARAM_CMD_NUM(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CMD_NUM_SHIFT)) & ADC_PARAM_CMD_NUM_MASK)
/*! @} */

/*! @name CTRL - LPADC Control Register */
/*! @{ */

#define ADC_CTRL_ADCEN_MASK                      (0x1U)
#define ADC_CTRL_ADCEN_SHIFT                     (0U)
/*! ADCEN - LPADC Enable
 *  0b0..LPADC is disabled.
 *  0b1..LPADC is enabled.
 */
#define ADC_CTRL_ADCEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_ADCEN_SHIFT)) & ADC_CTRL_ADCEN_MASK)

#define ADC_CTRL_RST_MASK                        (0x2U)
#define ADC_CTRL_RST_SHIFT                       (1U)
/*! RST - Software Reset
 *  0b0..LPADC logic is not reset.
 *  0b1..LPADC logic is reset.
 */
#define ADC_CTRL_RST(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RST_SHIFT)) & ADC_CTRL_RST_MASK)

#define ADC_CTRL_DOZEN_MASK                      (0x4U)
#define ADC_CTRL_DOZEN_SHIFT                     (2U)
/*! DOZEN - Doze Enable
 *  0b0..LPADC is enabled in Doze mode.
 *  0b1..LPADC is disabled in Doze mode.
 */
#define ADC_CTRL_DOZEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_DOZEN_SHIFT)) & ADC_CTRL_DOZEN_MASK)

#define ADC_CTRL_TRIG_SRC_MASK                   (0x18U)
#define ADC_CTRL_TRIG_SRC_SHIFT                  (3U)
/*! TRIG_SRC - Hardware trigger source selection
 *  0b00..ADC_ETC hw trigger , and HW trigger are enabled
 *  0b01..ADC_ETC hw trigger is enabled
 *  0b10..HW trigger is enabled
 *  0b11..Reserved
 */
#define ADC_CTRL_TRIG_SRC(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_TRIG_SRC_SHIFT)) & ADC_CTRL_TRIG_SRC_MASK)

#define ADC_CTRL_RSTFIFO_MASK                    (0x100U)
#define ADC_CTRL_RSTFIFO_SHIFT                   (8U)
/*! RSTFIFO - Reset FIFO
 *  0b0..No effect.
 *  0b1..FIFO is reset.
 */
#define ADC_CTRL_RSTFIFO(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO_SHIFT)) & ADC_CTRL_RSTFIFO_MASK)
/*! @} */

/*! @name STAT - LPADC Status Register */
/*! @{ */

#define ADC_STAT_RDY_MASK                        (0x1U)
#define ADC_STAT_RDY_SHIFT                       (0U)
/*! RDY - Result FIFO Ready Flag
 *  0b0..Result FIFO data level not above watermark level.
 *  0b1..Result FIFO holding data above watermark level.
 */
#define ADC_STAT_RDY(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY_SHIFT)) & ADC_STAT_RDY_MASK)

#define ADC_STAT_FOF_MASK                        (0x2U)
#define ADC_STAT_FOF_SHIFT                       (1U)
/*! FOF - Result FIFO Overflow Flag
 *  0b0..No result FIFO overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO overflow has occurred since the last time the flag was cleared.
 */
#define ADC_STAT_FOF(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF_SHIFT)) & ADC_STAT_FOF_MASK)

#define ADC_STAT_ADC_ACTIVE_MASK                 (0x100U)
#define ADC_STAT_ADC_ACTIVE_SHIFT                (8U)
/*! ADC_ACTIVE - ADC Active
 *  0b0..The LPADC is IDLE. There are no pending triggers to service and no active commands are being processed.
 *  0b1..The LPADC is processing a conversion, running through the power up delay, or servicing a trigger.
 */
#define ADC_STAT_ADC_ACTIVE(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_STAT_ADC_ACTIVE_SHIFT)) & ADC_STAT_ADC_ACTIVE_MASK)

#define ADC_STAT_TRGACT_MASK                     (0x70000U)
#define ADC_STAT_TRGACT_SHIFT                    (16U)
/*! TRGACT - Trigger Active
 *  0b000..Command (sequence) associated with Trigger 0 currently being executed.
 *  0b001..Command (sequence) associated with Trigger 1 currently being executed.
 *  0b010..Command (sequence) associated with Trigger 2 currently being executed.
 *  0b011-0b111..Command (sequence) from the associated Trigger number is currently being executed.
 */
#define ADC_STAT_TRGACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TRGACT_SHIFT)) & ADC_STAT_TRGACT_MASK)

#define ADC_STAT_CMDACT_MASK                     (0xF000000U)
#define ADC_STAT_CMDACT_SHIFT                    (24U)
/*! CMDACT - Command Active
 *  0b0000..No command is currently in progress.
 *  0b0001..Command 1 currently being executed.
 *  0b0010..Command 2 currently being executed.
 *  0b0011-0b1111..Associated command number is currently being executed.
 */
#define ADC_STAT_CMDACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CMDACT_SHIFT)) & ADC_STAT_CMDACT_MASK)
/*! @} */

/*! @name IE - Interrupt Enable Register */
/*! @{ */

#define ADC_IE_FWMIE_MASK                        (0x1U)
#define ADC_IE_FWMIE_SHIFT                       (0U)
/*! FWMIE - FIFO Watermark Interrupt Enable
 *  0b0..FIFO watermark interrupts are not enabled.
 *  0b1..FIFO watermark interrupts are enabled.
 */
#define ADC_IE_FWMIE(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE_SHIFT)) & ADC_IE_FWMIE_MASK)

#define ADC_IE_FOFIE_MASK                        (0x2U)
#define ADC_IE_FOFIE_SHIFT                       (1U)
/*! FOFIE - Result FIFO Overflow Interrupt Enable
 *  0b0..FIFO overflow interrupts are not enabled.
 *  0b1..FIFO overflow interrupts are enabled.
 */
#define ADC_IE_FOFIE(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE_SHIFT)) & ADC_IE_FOFIE_MASK)
/*! @} */

/*! @name DE - DMA Enable Register */
/*! @{ */

#define ADC_DE_FWMDE_MASK                        (0x1U)
#define ADC_DE_FWMDE_SHIFT                       (0U)
/*! FWMDE - FIFO Watermark DMA Enable
 *  0b0..DMA request disabled.
 *  0b1..DMA request enabled.
 */
#define ADC_DE_FWMDE(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE_SHIFT)) & ADC_DE_FWMDE_MASK)
/*! @} */

/*! @name CFG - LPADC Configuration Register */
/*! @{ */

#define ADC_CFG_TPRICTRL_MASK                    (0x1U)
#define ADC_CFG_TPRICTRL_SHIFT                   (0U)
/*! TPRICTRL - LPADC trigger priority control
 *  0b0..If a higher priority trigger is detected during command processing, the current conversion is aborted and
 *       the new command specified by the trigger is started.
 *  0b1..If a higher priority trigger is received during command processing, the current conversion is completed
 *       (including averaging iterations if enabled) and stored to the RESFIFO before the higher priority
 *       trigger/command is initiated. Note that compare until true commands can be interrupted prior to resulting in a true
 *       conversion.
 */
#define ADC_CFG_TPRICTRL(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TPRICTRL_SHIFT)) & ADC_CFG_TPRICTRL_MASK)

#define ADC_CFG_PWRSEL_MASK                      (0x30U)
#define ADC_CFG_PWRSEL_SHIFT                     (4U)
/*! PWRSEL - Power Configuration Select
 *  0b00..Level 1 (Lowest power setting)
 *  0b01..Level 2
 *  0b10..Level 3
 *  0b11..Level 4 (Highest power setting)
 */
#define ADC_CFG_PWRSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWRSEL_SHIFT)) & ADC_CFG_PWRSEL_MASK)

#define ADC_CFG_REFSEL_MASK                      (0xC0U)
#define ADC_CFG_REFSEL_SHIFT                     (6U)
/*! REFSEL - Voltage Reference Selection
 *  0b00..(Default) Option 1 setting.
 *  0b01..Option 2 setting.
 *  0b10..Option 3 setting.
 *  0b11..Reserved
 */
#define ADC_CFG_REFSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_REFSEL_SHIFT)) & ADC_CFG_REFSEL_MASK)

#define ADC_CFG_PUDLY_MASK                       (0xFF0000U)
#define ADC_CFG_PUDLY_SHIFT                      (16U)
/*! PUDLY - Power Up Delay
 */
#define ADC_CFG_PUDLY(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PUDLY_SHIFT)) & ADC_CFG_PUDLY_MASK)

#define ADC_CFG_PWREN_MASK                       (0x10000000U)
#define ADC_CFG_PWREN_SHIFT                      (28U)
/*! PWREN - LPADC Analog Pre-Enable
 *  0b0..LPADC analog circuits are only enabled while conversions are active. Performance is affected due to analog startup delays.
 *  0b1..LPADC analog circuits are pre-enabled and ready to execute conversions without startup delays (at the
 *       cost of higher DC current consumption). When PWREN is set, the power up delay is enforced such that any
 *       detected trigger does not begin ADC operation until the power up delay time has passed.
 */
#define ADC_CFG_PWREN(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWREN_SHIFT)) & ADC_CFG_PWREN_MASK)
/*! @} */

/*! @name PAUSE - LPADC Pause Register */
/*! @{ */

#define ADC_PAUSE_PAUSEDLY_MASK                  (0x1FFU)
#define ADC_PAUSE_PAUSEDLY_SHIFT                 (0U)
/*! PAUSEDLY - Pause Delay
 */
#define ADC_PAUSE_PAUSEDLY(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEDLY_SHIFT)) & ADC_PAUSE_PAUSEDLY_MASK)

#define ADC_PAUSE_PAUSEEN_MASK                   (0x80000000U)
#define ADC_PAUSE_PAUSEEN_SHIFT                  (31U)
/*! PAUSEEN - PAUSE Option Enable
 *  0b0..Pause operation disabled
 *  0b1..Pause operation enabled
 */
#define ADC_PAUSE_PAUSEEN(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEEN_SHIFT)) & ADC_PAUSE_PAUSEEN_MASK)
/*! @} */

/*! @name FCTRL - LPADC FIFO Control Register */
/*! @{ */

#define ADC_FCTRL_FCOUNT_MASK                    (0x1FU)
#define ADC_FCTRL_FCOUNT_SHIFT                   (0U)
/*! FCOUNT - Result FIFO counter
 *  0b00000..No data stored in FIFO
 *  0b00001..1 dataword stored in FIFO
 *  0b00010..2 datawords stored in FIFO
 *  0b00100..4 datawords stored in FIFO
 *  0b01000..8 datawords stored in FIFO
 *  0b10000..16 datawords stored in FIFO
 */
#define ADC_FCTRL_FCOUNT(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FCOUNT_SHIFT)) & ADC_FCTRL_FCOUNT_MASK)

#define ADC_FCTRL_FWMARK_MASK                    (0xF0000U)
#define ADC_FCTRL_FWMARK_SHIFT                   (16U)
/*! FWMARK - Watermark level selection
 *  0b0000..Generates STAT[RDY] flag after 1st successful conversion - single conversion
 *  0b0001..Generates STAT[RDY] flag after 2nd successful conversion
 *  0b0010..Generates STAT[RDY] flag after 3rd successful conversion
 *  0b0011..Generates STAT[RDY] flag after 4th successful conversion
 *  0b0100..Generates STAT[RDY] flag after 5th successful conversion
 *  0b0101..Generates STAT[RDY] flag after 6th successful conversion
 *  0b0110..Generates STAT[RDY] flag after 7th successful conversion
 *  0b0111..Generates STAT[RDY] flag after 8th successful conversion
 *  0b1000..Generates STAT[RDY] flag after 9th successful conversion
 *  0b1001..Generates STAT[RDY] flag after 10th successful conversion
 *  0b1010..Generates STAT[RDY] flag after 11th successful conversion
 *  0b1011..Generates STAT[RDY] flag after 12th successful conversion
 *  0b1100..Generates STAT[RDY] flag after 13th successful conversion
 *  0b1101..Generates STAT[RDY] flag after 14th successful conversion
 *  0b1110..Generates STAT[RDY] flag after 15th successful conversion
 *  0b1111..Generates STAT[RDY] flag after 16th successful conversion
 */
#define ADC_FCTRL_FWMARK(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FWMARK_SHIFT)) & ADC_FCTRL_FWMARK_MASK)
/*! @} */

/*! @name SWTRIG - Software Trigger Register */
/*! @{ */

#define ADC_SWTRIG_SWT0_MASK                     (0x1U)
#define ADC_SWTRIG_SWT0_SHIFT                    (0U)
/*! SWT0 - Software trigger 0 event
 *  0b0..No trigger 0 event generated.
 *  0b1..Trigger 0 event generated.
 */
#define ADC_SWTRIG_SWT0(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT0_SHIFT)) & ADC_SWTRIG_SWT0_MASK)

#define ADC_SWTRIG_SWT1_MASK                     (0x2U)
#define ADC_SWTRIG_SWT1_SHIFT                    (1U)
/*! SWT1 - Software trigger 1 event
 *  0b0..No trigger 1 event generated.
 *  0b1..Trigger 1 event generated.
 */
#define ADC_SWTRIG_SWT1(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT1_SHIFT)) & ADC_SWTRIG_SWT1_MASK)

#define ADC_SWTRIG_SWT2_MASK                     (0x4U)
#define ADC_SWTRIG_SWT2_SHIFT                    (2U)
/*! SWT2 - Software trigger 2 event
 *  0b0..No trigger 2 event generated.
 *  0b1..Trigger 2 event generated.
 */
#define ADC_SWTRIG_SWT2(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT2_SHIFT)) & ADC_SWTRIG_SWT2_MASK)

#define ADC_SWTRIG_SWT3_MASK                     (0x8U)
#define ADC_SWTRIG_SWT3_SHIFT                    (3U)
/*! SWT3 - Software trigger 3 event
 *  0b0..No trigger 3 event generated.
 *  0b1..Trigger 3 event generated.
 */
#define ADC_SWTRIG_SWT3(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT3_SHIFT)) & ADC_SWTRIG_SWT3_MASK)

#define ADC_SWTRIG_SWT4_MASK                     (0x10U)
#define ADC_SWTRIG_SWT4_SHIFT                    (4U)
/*! SWT4 - Software trigger 4 event
 *  0b0..No trigger 4 event generated.
 *  0b1..Trigger 4 event generated.
 */
#define ADC_SWTRIG_SWT4(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT4_SHIFT)) & ADC_SWTRIG_SWT4_MASK)

#define ADC_SWTRIG_SWT5_MASK                     (0x20U)
#define ADC_SWTRIG_SWT5_SHIFT                    (5U)
/*! SWT5 - Software trigger 5 event
 *  0b0..No trigger 5 event generated.
 *  0b1..Trigger 5 event generated.
 */
#define ADC_SWTRIG_SWT5(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT5_SHIFT)) & ADC_SWTRIG_SWT5_MASK)

#define ADC_SWTRIG_SWT6_MASK                     (0x40U)
#define ADC_SWTRIG_SWT6_SHIFT                    (6U)
/*! SWT6 - Software trigger 6 event
 *  0b0..No trigger 6 event generated.
 *  0b1..Trigger 6 event generated.
 */
#define ADC_SWTRIG_SWT6(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT6_SHIFT)) & ADC_SWTRIG_SWT6_MASK)

#define ADC_SWTRIG_SWT7_MASK                     (0x80U)
#define ADC_SWTRIG_SWT7_SHIFT                    (7U)
/*! SWT7 - Software trigger 7 event
 *  0b0..No trigger 7 event generated.
 *  0b1..Trigger 7 event generated.
 */
#define ADC_SWTRIG_SWT7(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT7_SHIFT)) & ADC_SWTRIG_SWT7_MASK)
/*! @} */

/*! @name TCTRL - Trigger Control Register */
/*! @{ */

#define ADC_TCTRL_HTEN_MASK                      (0x1U)
#define ADC_TCTRL_HTEN_SHIFT                     (0U)
/*! HTEN - Trigger enable
 *  0b0..Hardware trigger source disabled
 *  0b1..Hardware trigger source enabled
 */
#define ADC_TCTRL_HTEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_HTEN_SHIFT)) & ADC_TCTRL_HTEN_MASK)

#define ADC_TCTRL_CMD_SEL_MASK                   (0x2U)
#define ADC_TCTRL_CMD_SEL_SHIFT                  (1U)
/*! CMD_SEL
 *  0b0..TCTRLa[TCMD] will determine the command
 *  0b1..Software TCDM is bypassed , and hardware TCMD from ADC_ETC module will be used. The trigger command is
 *       then defined by ADC hardware trigger command selection field in ADC_ETC->TRIGx_CHAINy_z_n[CSEL].
 */
#define ADC_TCTRL_CMD_SEL(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_CMD_SEL_SHIFT)) & ADC_TCTRL_CMD_SEL_MASK)

#define ADC_TCTRL_TPRI_MASK                      (0x700U)
#define ADC_TCTRL_TPRI_SHIFT                     (8U)
/*! TPRI - Trigger priority setting
 *  0b000..Set to highest priority, Level 1
 *  0b001-0b110..Set to corresponding priority level
 *  0b111..Set to lowest priority, Level 8
 */
#define ADC_TCTRL_TPRI(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TPRI_SHIFT)) & ADC_TCTRL_TPRI_MASK)

#define ADC_TCTRL_TDLY_MASK                      (0xF0000U)
#define ADC_TCTRL_TDLY_SHIFT                     (16U)
/*! TDLY - Trigger delay select
 */
#define ADC_TCTRL_TDLY(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TDLY_SHIFT)) & ADC_TCTRL_TDLY_MASK)

#define ADC_TCTRL_TCMD_MASK                      (0xF000000U)
#define ADC_TCTRL_TCMD_SHIFT                     (24U)
/*! TCMD - Trigger command select
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..CMD1 is executed
 *  0b0010-0b1110..Corresponding CMD is executed
 *  0b1111..CMD15 is executed
 */
#define ADC_TCTRL_TCMD(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TCMD_SHIFT)) & ADC_TCTRL_TCMD_MASK)
/*! @} */

/* The count of ADC_TCTRL */
#define ADC_TCTRL_COUNT                          (8U)

/*! @name CMDL - LPADC Command Low Buffer Register */
/*! @{ */

#define ADC_CMDL_ADCH_MASK                       (0x1FU)
#define ADC_CMDL_ADCH_SHIFT                      (0U)
/*! ADCH - Input channel select
 *  0b00000..Select CH0A or CH0B or CH0A/CH0B pair.
 *  0b00001..Select CH1A or CH1B or CH1A/CH1B pair.
 *  0b00010..Select CH2A or CH2B or CH2A/CH2B pair.
 *  0b00011..Select CH3A or CH3B or CH3A/CH3B pair.
 *  0b00100-0b11101..Select corresponding channel CHnA or CHnB or CHnA/CHnB pair.
 *  0b11110..Select CH30A or CH30B or CH30A/CH30B pair.
 *  0b11111..Select CH31A or CH31B or CH31A/CH31B pair.
 */
#define ADC_CMDL_ADCH(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ADCH_SHIFT)) & ADC_CMDL_ADCH_MASK)

#define ADC_CMDL_ABSEL_MASK                      (0x20U)
#define ADC_CMDL_ABSEL_SHIFT                     (5U)
/*! ABSEL - A-side vs. B-side Select
 *  0b0..When DIFF=0b0, the associated A-side channel is converted as single-ended. When DIFF=0b1, the ADC result is (CHnA-CHnB).
 *  0b1..When DIFF=0b0, the associated B-side channel is converted as single-ended. When DIFF=0b1, the ADC result is (CHnB-CHnA).
 */
#define ADC_CMDL_ABSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ABSEL_SHIFT)) & ADC_CMDL_ABSEL_MASK)

#define ADC_CMDL_DIFF_MASK                       (0x40U)
#define ADC_CMDL_DIFF_SHIFT                      (6U)
/*! DIFF - Differential Mode Enable
 *  0b0..Single-ended mode.
 *  0b1..Differential mode.
 */
#define ADC_CMDL_DIFF(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_DIFF_SHIFT)) & ADC_CMDL_DIFF_MASK)

#define ADC_CMDL_CSCALE_MASK                     (0x2000U)
#define ADC_CMDL_CSCALE_SHIFT                    (13U)
/*! CSCALE - Channel Scale
 *  0b0..Scale selected analog channel (Factor of 30/64)
 *  0b1..(Default) Full scale (Factor of 1)
 */
#define ADC_CMDL_CSCALE(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_CSCALE_SHIFT)) & ADC_CMDL_CSCALE_MASK)
/*! @} */

/* The count of ADC_CMDL */
#define ADC_CMDL_COUNT                           (15U)

/*! @name CMDH - LPADC Command High Buffer Register */
/*! @{ */

#define ADC_CMDH_CMPEN_MASK                      (0x3U)
#define ADC_CMDH_CMPEN_SHIFT                     (0U)
/*! CMPEN - Compare Function Enable
 *  0b00..Compare disabled.
 *  0b01..Reserved
 *  0b10..Compare enabled. Store on true.
 *  0b11..Compare enabled. Repeat channel acquisition (sample/convert/compare) until true.
 */
#define ADC_CMDH_CMPEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_CMPEN_SHIFT)) & ADC_CMDH_CMPEN_MASK)

#define ADC_CMDH_LWI_MASK                        (0x80U)
#define ADC_CMDH_LWI_SHIFT                       (7U)
/*! LWI - Loop with Increment
 *  0b0..Auto channel increment disabled
 *  0b1..Auto channel increment enabled
 */
#define ADC_CMDH_LWI(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LWI_SHIFT)) & ADC_CMDH_LWI_MASK)

#define ADC_CMDH_STS_MASK                        (0x700U)
#define ADC_CMDH_STS_SHIFT                       (8U)
/*! STS - Sample Time Select
 *  0b000..Minimum sample time of 3 ADCK cycles.
 *  0b001..3 + 21 ADCK cycles; 5 ADCK cycles total sample time.
 *  0b010..3 + 22 ADCK cycles; 7 ADCK cycles total sample time.
 *  0b011..3 + 23 ADCK cycles; 11 ADCK cycles total sample time.
 *  0b100..3 + 24 ADCK cycles; 19 ADCK cycles total sample time.
 *  0b101..3 + 25 ADCK cycles; 35 ADCK cycles total sample time.
 *  0b110..3 + 26 ADCK cycles; 67 ADCK cycles total sample time.
 *  0b111..3 + 27 ADCK cycles; 131 ADCK cycles total sample time.
 */
#define ADC_CMDH_STS(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_STS_SHIFT)) & ADC_CMDH_STS_MASK)

#define ADC_CMDH_AVGS_MASK                       (0x7000U)
#define ADC_CMDH_AVGS_SHIFT                      (12U)
/*! AVGS - Hardware Average Select
 *  0b000..Single conversion.
 *  0b001..2 conversions averaged.
 *  0b010..4 conversions averaged.
 *  0b011..8 conversions averaged.
 *  0b100..16 conversions averaged.
 *  0b101..32 conversions averaged.
 *  0b110..64 conversions averaged.
 *  0b111..128 conversions averaged.
 */
#define ADC_CMDH_AVGS(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_AVGS_SHIFT)) & ADC_CMDH_AVGS_MASK)

#define ADC_CMDH_LOOP_MASK                       (0xF0000U)
#define ADC_CMDH_LOOP_SHIFT                      (16U)
/*! LOOP - Loop Count Select
 *  0b0000..Looping not enabled. Command executes 1 time.
 *  0b0001..Loop 1 time. Command executes 2 times.
 *  0b0010..Loop 2 times. Command executes 3 times.
 *  0b0011-0b1110..Loop corresponding number of times. Command executes LOOP+1 times.
 *  0b1111..Loop 15 times. Command executes 16 times.
 */
#define ADC_CMDH_LOOP(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LOOP_SHIFT)) & ADC_CMDH_LOOP_MASK)

#define ADC_CMDH_NEXT_MASK                       (0xF000000U)
#define ADC_CMDH_NEXT_SHIFT                      (24U)
/*! NEXT - Next Command Select
 *  0b0000..No next command defined. Terminate conversions at completion of current command. If lower priority
 *          trigger pending, begin command associated with lower priority trigger.
 *  0b0001..Select CMD1 command buffer register as next command.
 *  0b0010-0b1110..Select corresponding CMD command buffer register as next command
 *  0b1111..Select CMD15 command buffer register as next command.
 */
#define ADC_CMDH_NEXT(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_NEXT_SHIFT)) & ADC_CMDH_NEXT_MASK)
/*! @} */

/* The count of ADC_CMDH */
#define ADC_CMDH_COUNT                           (15U)

/*! @name CV - Compare Value Register */
/*! @{ */

#define ADC_CV_CVL_MASK                          (0xFFFFU)
#define ADC_CV_CVL_SHIFT                         (0U)
/*! CVL - Compare Value Low
 */
#define ADC_CV_CVL(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVL_SHIFT)) & ADC_CV_CVL_MASK)

#define ADC_CV_CVH_MASK                          (0xFFFF0000U)
#define ADC_CV_CVH_SHIFT                         (16U)
/*! CVH - Compare Value High.
 */
#define ADC_CV_CVH(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVH_SHIFT)) & ADC_CV_CVH_MASK)
/*! @} */

/* The count of ADC_CV */
#define ADC_CV_COUNT                             (4U)

/*! @name RESFIFO - LPADC Data Result FIFO Register */
/*! @{ */

#define ADC_RESFIFO_D_MASK                       (0xFFFFU)
#define ADC_RESFIFO_D_SHIFT                      (0U)
/*! D - Data result
 */
#define ADC_RESFIFO_D(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_D_SHIFT)) & ADC_RESFIFO_D_MASK)

#define ADC_RESFIFO_TSRC_MASK                    (0x70000U)
#define ADC_RESFIFO_TSRC_SHIFT                   (16U)
/*! TSRC - Trigger Source
 *  0b000..Trigger source 0 initiated this conversion.
 *  0b001..Trigger source 1 initiated this conversion.
 *  0b010-0b110..Corresponding trigger source initiated this conversion.
 *  0b111..Trigger source 7 initiated this conversion.
 */
#define ADC_RESFIFO_TSRC(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_TSRC_SHIFT)) & ADC_RESFIFO_TSRC_MASK)

#define ADC_RESFIFO_LOOPCNT_MASK                 (0xF00000U)
#define ADC_RESFIFO_LOOPCNT_SHIFT                (20U)
/*! LOOPCNT - Loop count value
 *  0b0000..Result is from initial conversion in command.
 *  0b0001..Result is from second conversion in command.
 *  0b0010-0b1110..Result is from LOOPCNT+1 conversion in command.
 *  0b1111..Result is from 16th conversion in command.
 */
#define ADC_RESFIFO_LOOPCNT(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_LOOPCNT_SHIFT)) & ADC_RESFIFO_LOOPCNT_MASK)

#define ADC_RESFIFO_CMDSRC_MASK                  (0xF000000U)
#define ADC_RESFIFO_CMDSRC_SHIFT                 (24U)
/*! CMDSRC - Command Buffer Source
 *  0b0000..Not a valid value CMDSRC value for a dataword in RESFIFO. 0x0 is only found in initial FIFO state
 *          prior to an ADC conversion result dataword being stored to a RESFIFO buffer.
 *  0b0001..CMD1 buffer used as control settings for this conversion.
 *  0b0010-0b1110..Corresponding command buffer used as control settings for this conversion.
 *  0b1111..CMD15 buffer used as control settings for this conversion.
 */
#define ADC_RESFIFO_CMDSRC(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_CMDSRC_SHIFT)) & ADC_RESFIFO_CMDSRC_MASK)

#define ADC_RESFIFO_VALID_MASK                   (0x80000000U)
#define ADC_RESFIFO_VALID_SHIFT                  (31U)
/*! VALID - FIFO entry is valid
 *  0b0..FIFO is empty. Discard any read from RESFIFO.
 *  0b1..FIFO record read from RESFIFO is valid.
 */
#define ADC_RESFIFO_VALID(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_VALID_SHIFT)) & ADC_RESFIFO_VALID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
/** Peripheral LPADC1 base address */
#define LPADC1_BASE                              (0x40050000u)
/** Peripheral LPADC1 base pointer */
#define LPADC1                                   ((ADC_Type *)LPADC1_BASE)
/** Peripheral LPADC2 base address */
#define LPADC2_BASE                              (0x40054000u)
/** Peripheral LPADC2 base pointer */
#define LPADC2                                   ((ADC_Type *)LPADC2_BASE)
/** Array initializer of ADC peripheral base addresses */
#define ADC_BASE_ADDRS                           { 0u, LPADC1_BASE, LPADC2_BASE }
/** Array initializer of ADC peripheral base pointers */
#define ADC_BASE_PTRS                            { (ADC_Type *)0u, LPADC1, LPADC2 }
/** Interrupt vectors for the ADC peripheral type */
#define ADC_IRQS                                 { NotAvail_IRQn, ADC1_IRQn, ADC2_IRQn }

/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ADC_ETC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_ETC_Peripheral_Access_Layer ADC_ETC Peripheral Access Layer
 * @{
 */

/** ADC_ETC - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< ADC_ETC Global Control Register, offset: 0x0 */
  __IO uint32_t DONE0_1_IRQ;                       /**< ETC DONE0 and DONE1 IRQ State Register, offset: 0x4 */
  __IO uint32_t DONE2_3_ERR_IRQ;                   /**< ETC DONE_2, DONE_3 and DONE_ERR IRQ State Register, offset: 0x8 */
  __IO uint32_t DMA_CTRL;                          /**< ETC DMA control Register, offset: 0xC */
  struct {                                         /* offset: 0x10, array step: 0x28 */
    __IO uint32_t TRIGn_CTRL;                        /**< ETC_TRIG Control Register, array offset: 0x10, array step: 0x28 */
    __IO uint32_t TRIGn_COUNTER;                     /**< ETC_TRIG Counter Register, array offset: 0x14, array step: 0x28 */
    __IO uint32_t TRIGn_CHAIN_1_0;                   /**< ETC_TRIG Chain 0/1 Register, array offset: 0x18, array step: 0x28 */
    __IO uint32_t TRIGn_CHAIN_3_2;                   /**< ETC_TRIG Chain 2/3 Register, array offset: 0x1C, array step: 0x28 */
    __IO uint32_t TRIGn_CHAIN_5_4;                   /**< ETC_TRIG Chain 4/5 Register, array offset: 0x20, array step: 0x28 */
    __IO uint32_t TRIGn_CHAIN_7_6;                   /**< ETC_TRIG Chain 6/7 Register, array offset: 0x24, array step: 0x28 */
    __I  uint32_t TRIGn_RESULT_1_0;                  /**< ETC_TRIG Result Data 1/0 Register, array offset: 0x28, array step: 0x28 */
    __I  uint32_t TRIGn_RESULT_3_2;                  /**< ETC_TRIG Result Data 3/2 Register, array offset: 0x2C, array step: 0x28 */
    __I  uint32_t TRIGn_RESULT_5_4;                  /**< ETC_TRIG Result Data 5/4 Register, array offset: 0x30, array step: 0x28 */
    __I  uint32_t TRIGn_RESULT_7_6;                  /**< ETC_TRIG Result Data 7/6 Register, array offset: 0x34, array step: 0x28 */
  } TRIG[8];
} ADC_ETC_Type;

/* ----------------------------------------------------------------------------
   -- ADC_ETC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_ETC_Register_Masks ADC_ETC Register Masks
 * @{
 */

/*! @name CTRL - ADC_ETC Global Control Register */
/*! @{ */

#define ADC_ETC_CTRL_TRIG_ENABLE_MASK            (0xFFU)
#define ADC_ETC_CTRL_TRIG_ENABLE_SHIFT           (0U)
/*! TRIG_ENABLE
 *  0b00000000..disable all 8 external XBAR triggers.
 *  0b00000001..enable external XBAR trigger0.
 *  0b00000010..enable external XBAR trigger1.
 *  0b00000011..enable external XBAR trigger0 and trigger1.
 *  0b11111111..enable all 8 external XBAR triggers.
 */
#define ADC_ETC_CTRL_TRIG_ENABLE(x)              (((uint32_t)(((uint32_t)(x)) << ADC_ETC_CTRL_TRIG_ENABLE_SHIFT)) & ADC_ETC_CTRL_TRIG_ENABLE_MASK)

#define ADC_ETC_CTRL_PRE_DIVIDER_MASK            (0xFF0000U)
#define ADC_ETC_CTRL_PRE_DIVIDER_SHIFT           (16U)
#define ADC_ETC_CTRL_PRE_DIVIDER(x)              (((uint32_t)(((uint32_t)(x)) << ADC_ETC_CTRL_PRE_DIVIDER_SHIFT)) & ADC_ETC_CTRL_PRE_DIVIDER_MASK)

#define ADC_ETC_CTRL_DMA_MODE_SEL_MASK           (0x20000000U)
#define ADC_ETC_CTRL_DMA_MODE_SEL_SHIFT          (29U)
/*! DMA_MODE_SEL
 *  0b0..Trig DMA_REQ with latched signal, REQ will be cleared when ACK and source request cleared.
 *  0b1..Trig DMA_REQ with pulsed signal, REQ will be cleared by ACK only.
 */
#define ADC_ETC_CTRL_DMA_MODE_SEL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_ETC_CTRL_DMA_MODE_SEL_SHIFT)) & ADC_ETC_CTRL_DMA_MODE_SEL_MASK)

#define ADC_ETC_CTRL_SOFTRST_MASK                (0x80000000U)
#define ADC_ETC_CTRL_SOFTRST_SHIFT               (31U)
/*! SOFTRST
 *  0b0..ADC_ETC works normally.
 *  0b1..All registers inside ADC_ETC will be reset to the default value.
 */
#define ADC_ETC_CTRL_SOFTRST(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_ETC_CTRL_SOFTRST_SHIFT)) & ADC_ETC_CTRL_SOFTRST_MASK)
/*! @} */

/*! @name DONE0_1_IRQ - ETC DONE0 and DONE1 IRQ State Register */
/*! @{ */

#define ADC_ETC_DONE0_1_IRQ_TRIG0_DONE0_MASK     (0x1U)
#define ADC_ETC_DONE0_1_IRQ_TRIG0_DONE0_SHIFT    (0U)
/*! TRIG0_DONE0
 *  0b0..No TRIG0_DONE0 interrupt detected
 *  0b1..TRIG0_DONE0 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG0_DONE0(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG0_DONE0_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG0_DONE0_MASK)

#define ADC_ETC_DONE0_1_IRQ_TRIG1_DONE0_MASK     (0x2U)
#define ADC_ETC_DONE0_1_IRQ_TRIG1_DONE0_SHIFT    (1U)
/*! TRIG1_DONE0
 *  0b0..No TRIG1_DONE0 interrupt detected
 *  0b1..TRIG1_DONE0 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG1_DONE0(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG1_DONE0_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG1_DONE0_MASK)

#define ADC_ETC_DONE0_1_IRQ_TRIG2_DONE0_MASK     (0x4U)
#define ADC_ETC_DONE0_1_IRQ_TRIG2_DONE0_SHIFT    (2U)
/*! TRIG2_DONE0
 *  0b0..No TRIG2_DONE0 interrupt detected
 *  0b1..TRIG2_DONE0 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG2_DONE0(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG2_DONE0_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG2_DONE0_MASK)

#define ADC_ETC_DONE0_1_IRQ_TRIG3_DONE0_MASK     (0x8U)
#define ADC_ETC_DONE0_1_IRQ_TRIG3_DONE0_SHIFT    (3U)
/*! TRIG3_DONE0
 *  0b0..No TRIG3_DONE0 interrupt detected
 *  0b1..TRIG3_DONE0 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG3_DONE0(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG3_DONE0_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG3_DONE0_MASK)

#define ADC_ETC_DONE0_1_IRQ_TRIG4_DONE0_MASK     (0x10U)
#define ADC_ETC_DONE0_1_IRQ_TRIG4_DONE0_SHIFT    (4U)
/*! TRIG4_DONE0
 *  0b0..No TRIG4_DONE0 interrupt detected
 *  0b1..TRIG4_DONE0 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG4_DONE0(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG4_DONE0_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG4_DONE0_MASK)

#define ADC_ETC_DONE0_1_IRQ_TRIG5_DONE0_MASK     (0x20U)
#define ADC_ETC_DONE0_1_IRQ_TRIG5_DONE0_SHIFT    (5U)
/*! TRIG5_DONE0
 *  0b0..No TRIG5_DONE0 interrupt detected
 *  0b1..TRIG5_DONE0 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG5_DONE0(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG5_DONE0_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG5_DONE0_MASK)

#define ADC_ETC_DONE0_1_IRQ_TRIG6_DONE0_MASK     (0x40U)
#define ADC_ETC_DONE0_1_IRQ_TRIG6_DONE0_SHIFT    (6U)
/*! TRIG6_DONE0
 *  0b0..No TRIG6_DONE0 interrupt detected
 *  0b1..TRIG6_DONE0 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG6_DONE0(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG6_DONE0_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG6_DONE0_MASK)

#define ADC_ETC_DONE0_1_IRQ_TRIG7_DONE0_MASK     (0x80U)
#define ADC_ETC_DONE0_1_IRQ_TRIG7_DONE0_SHIFT    (7U)
/*! TRIG7_DONE0
 *  0b0..No TRIG7_DONE0 interrupt detected
 *  0b1..TRIG7_DONE0 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG7_DONE0(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG7_DONE0_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG7_DONE0_MASK)

#define ADC_ETC_DONE0_1_IRQ_TRIG0_DONE1_MASK     (0x10000U)
#define ADC_ETC_DONE0_1_IRQ_TRIG0_DONE1_SHIFT    (16U)
/*! TRIG0_DONE1
 *  0b0..No TRIG0_DONE1 interrupt detected
 *  0b1..TRIG0_DONE1 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG0_DONE1(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG0_DONE1_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG0_DONE1_MASK)

#define ADC_ETC_DONE0_1_IRQ_TRIG1_DONE1_MASK     (0x20000U)
#define ADC_ETC_DONE0_1_IRQ_TRIG1_DONE1_SHIFT    (17U)
/*! TRIG1_DONE1
 *  0b0..No TRIG1_DONE1 interrupt detected
 *  0b1..TRIG1_DONE1 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG1_DONE1(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG1_DONE1_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG1_DONE1_MASK)

#define ADC_ETC_DONE0_1_IRQ_TRIG2_DONE1_MASK     (0x40000U)
#define ADC_ETC_DONE0_1_IRQ_TRIG2_DONE1_SHIFT    (18U)
/*! TRIG2_DONE1
 *  0b0..No TRIG2_DONE1 interrupt detected
 *  0b1..TRIG2_DONE1 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG2_DONE1(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG2_DONE1_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG2_DONE1_MASK)

#define ADC_ETC_DONE0_1_IRQ_TRIG3_DONE1_MASK     (0x80000U)
#define ADC_ETC_DONE0_1_IRQ_TRIG3_DONE1_SHIFT    (19U)
/*! TRIG3_DONE1
 *  0b0..No TRIG3_DONE1 interrupt detected
 *  0b1..TRIG3_DONE1 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG3_DONE1(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG3_DONE1_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG3_DONE1_MASK)

#define ADC_ETC_DONE0_1_IRQ_TRIG4_DONE1_MASK     (0x100000U)
#define ADC_ETC_DONE0_1_IRQ_TRIG4_DONE1_SHIFT    (20U)
/*! TRIG4_DONE1
 *  0b0..No TRIG4_DONE1 interrupt detected
 *  0b1..TRIG4_DONE1 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG4_DONE1(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG4_DONE1_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG4_DONE1_MASK)

#define ADC_ETC_DONE0_1_IRQ_TRIG5_DONE1_MASK     (0x200000U)
#define ADC_ETC_DONE0_1_IRQ_TRIG5_DONE1_SHIFT    (21U)
/*! TRIG5_DONE1
 *  0b0..No TRIG5_DONE1 interrupt detected
 *  0b1..TRIG5_DONE1 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG5_DONE1(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG5_DONE1_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG5_DONE1_MASK)

#define ADC_ETC_DONE0_1_IRQ_TRIG6_DONE1_MASK     (0x400000U)
#define ADC_ETC_DONE0_1_IRQ_TRIG6_DONE1_SHIFT    (22U)
/*! TRIG6_DONE1
 *  0b0..No TRIG6_DONE1 interrupt detected
 *  0b1..TRIG6_DONE1 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG6_DONE1(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG6_DONE1_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG6_DONE1_MASK)

#define ADC_ETC_DONE0_1_IRQ_TRIG7_DONE1_MASK     (0x800000U)
#define ADC_ETC_DONE0_1_IRQ_TRIG7_DONE1_SHIFT    (23U)
/*! TRIG7_DONE1
 *  0b0..No TRIG7_DONE1 interrupt detected
 *  0b1..TRIG7_DONE1 interrupt detected
 */
#define ADC_ETC_DONE0_1_IRQ_TRIG7_DONE1(x)       (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE0_1_IRQ_TRIG7_DONE1_SHIFT)) & ADC_ETC_DONE0_1_IRQ_TRIG7_DONE1_MASK)
/*! @} */

/*! @name DONE2_3_ERR_IRQ - ETC DONE_2, DONE_3 and DONE_ERR IRQ State Register */
/*! @{ */

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG0_DONE2_MASK (0x1U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG0_DONE2_SHIFT (0U)
/*! TRIG0_DONE2
 *  0b0..No TRIG0_DONE2 interrupt detected
 *  0b1..TRIG0_DONE2 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG0_DONE2(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG0_DONE2_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG0_DONE2_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG1_DONE2_MASK (0x2U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG1_DONE2_SHIFT (1U)
/*! TRIG1_DONE2
 *  0b0..No TRIG1_DONE2 interrupt detected
 *  0b1..TRIG1_DONE2 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG1_DONE2(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG1_DONE2_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG1_DONE2_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG2_DONE2_MASK (0x4U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG2_DONE2_SHIFT (2U)
/*! TRIG2_DONE2
 *  0b0..No TRIG2_DONE2 interrupt detected
 *  0b1..TRIG2_DONE2 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG2_DONE2(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG2_DONE2_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG2_DONE2_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG3_DONE2_MASK (0x8U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG3_DONE2_SHIFT (3U)
/*! TRIG3_DONE2
 *  0b0..No TRIG3_DONE2 interrupt detected
 *  0b1..TRIG3_DONE2 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG3_DONE2(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG3_DONE2_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG3_DONE2_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG4_DONE2_MASK (0x10U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG4_DONE2_SHIFT (4U)
/*! TRIG4_DONE2
 *  0b0..No TRIG4_DONE2 interrupt detected
 *  0b1..TRIG4_DONE2 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG4_DONE2(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG4_DONE2_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG4_DONE2_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG5_DONE2_MASK (0x20U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG5_DONE2_SHIFT (5U)
/*! TRIG5_DONE2
 *  0b0..No TRIG5_DONE2 interrupt detected
 *  0b1..TRIG5_DONE2 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG5_DONE2(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG5_DONE2_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG5_DONE2_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG6_DONE2_MASK (0x40U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG6_DONE2_SHIFT (6U)
/*! TRIG6_DONE2
 *  0b0..No TRIG6_DONE2 interrupt detected
 *  0b1..TRIG6_DONE2 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG6_DONE2(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG6_DONE2_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG6_DONE2_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG7_DONE2_MASK (0x80U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG7_DONE2_SHIFT (7U)
/*! TRIG7_DONE2
 *  0b0..No TRIG7_DONE2 interrupt detected
 *  0b1..TRIG7_DONE2 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG7_DONE2(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG7_DONE2_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG7_DONE2_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG0_DONE3_MASK (0x100U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG0_DONE3_SHIFT (8U)
/*! TRIG0_DONE3
 *  0b0..No TRIG0_DONE3 interrupt detected
 *  0b1..TRIG0_DONE3 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG0_DONE3(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG0_DONE3_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG0_DONE3_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG1_DONE3_MASK (0x200U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG1_DONE3_SHIFT (9U)
/*! TRIG1_DONE3
 *  0b0..No TRIG1_DONE3 interrupt detected
 *  0b1..TRIG1_DONE3 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG1_DONE3(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG1_DONE3_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG1_DONE3_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG2_DONE3_MASK (0x400U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG2_DONE3_SHIFT (10U)
/*! TRIG2_DONE3
 *  0b0..No TRIG2_DONE3 interrupt detected
 *  0b1..TRIG2_DONE3 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG2_DONE3(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG2_DONE3_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG2_DONE3_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG3_DONE3_MASK (0x800U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG3_DONE3_SHIFT (11U)
/*! TRIG3_DONE3
 *  0b0..No TRIG3_DONE3 interrupt detected
 *  0b1..TRIG3_DONE3 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG3_DONE3(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG3_DONE3_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG3_DONE3_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG4_DONE3_MASK (0x1000U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG4_DONE3_SHIFT (12U)
/*! TRIG4_DONE3
 *  0b0..No TRIG4_DONE3 interrupt detected
 *  0b1..TRIG4_DONE3 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG4_DONE3(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG4_DONE3_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG4_DONE3_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG5_DONE3_MASK (0x2000U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG5_DONE3_SHIFT (13U)
/*! TRIG5_DONE3
 *  0b0..No TRIG5_DONE3 interrupt detected
 *  0b1..TRIG5_DONE3 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG5_DONE3(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG5_DONE3_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG5_DONE3_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG6_DONE3_MASK (0x4000U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG6_DONE3_SHIFT (14U)
/*! TRIG6_DONE3
 *  0b0..No TRIG6_DONE3 interrupt detected
 *  0b1..TRIG6_DONE3 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG6_DONE3(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG6_DONE3_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG6_DONE3_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG7_DONE3_MASK (0x8000U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG7_DONE3_SHIFT (15U)
/*! TRIG7_DONE3
 *  0b0..No TRIG7_DONE3 interrupt detected
 *  0b1..TRIG7_DONE3 interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG7_DONE3(x)   (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG7_DONE3_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG7_DONE3_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG0_ERR_MASK   (0x10000U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG0_ERR_SHIFT  (16U)
/*! TRIG0_ERR
 *  0b0..No TRIG0_ERR interrupt detected
 *  0b1..TRIG0_ERR interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG0_ERR(x)     (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG0_ERR_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG0_ERR_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG1_ERR_MASK   (0x20000U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG1_ERR_SHIFT  (17U)
/*! TRIG1_ERR
 *  0b0..No TRIG1_ERR interrupt detected
 *  0b1..TRIG1_ERR interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG1_ERR(x)     (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG1_ERR_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG1_ERR_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG2_ERR_MASK   (0x40000U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG2_ERR_SHIFT  (18U)
/*! TRIG2_ERR
 *  0b0..No TRIG2_ERR interrupt detected
 *  0b1..TRIG2_ERR interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG2_ERR(x)     (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG2_ERR_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG2_ERR_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG3_ERR_MASK   (0x80000U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG3_ERR_SHIFT  (19U)
/*! TRIG3_ERR
 *  0b0..No TRIG3_ERR interrupt detected
 *  0b1..TRIG3_ERR interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG3_ERR(x)     (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG3_ERR_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG3_ERR_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG4_ERR_MASK   (0x100000U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG4_ERR_SHIFT  (20U)
/*! TRIG4_ERR
 *  0b0..No TRIG4_ERR interrupt detected
 *  0b1..TRIG4_ERR interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG4_ERR(x)     (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG4_ERR_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG4_ERR_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG5_ERR_MASK   (0x200000U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG5_ERR_SHIFT  (21U)
/*! TRIG5_ERR
 *  0b0..No TRIG5_ERR interrupt detected
 *  0b1..TRIG5_ERR interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG5_ERR(x)     (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG5_ERR_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG5_ERR_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG6_ERR_MASK   (0x400000U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG6_ERR_SHIFT  (22U)
/*! TRIG6_ERR
 *  0b0..No TRIG6_ERR interrupt detected
 *  0b1..TRIG6_ERR interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG6_ERR(x)     (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG6_ERR_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG6_ERR_MASK)

#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG7_ERR_MASK   (0x800000U)
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG7_ERR_SHIFT  (23U)
/*! TRIG7_ERR
 *  0b0..No TRIG7_ERR interrupt detected
 *  0b1..TRIG7_ERR interrupt detected
 */
#define ADC_ETC_DONE2_3_ERR_IRQ_TRIG7_ERR(x)     (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DONE2_3_ERR_IRQ_TRIG7_ERR_SHIFT)) & ADC_ETC_DONE2_3_ERR_IRQ_TRIG7_ERR_MASK)
/*! @} */

/*! @name DMA_CTRL - ETC DMA control Register */
/*! @{ */

#define ADC_ETC_DMA_CTRL_TRIG0_ENABLE_MASK       (0x1U)
#define ADC_ETC_DMA_CTRL_TRIG0_ENABLE_SHIFT      (0U)
/*! TRIG0_ENABLE
 *  0b0..TRIG0 DMA request disabled.
 *  0b1..TRIG0 DMA request enabled.
 */
#define ADC_ETC_DMA_CTRL_TRIG0_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG0_ENABLE_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG0_ENABLE_MASK)

#define ADC_ETC_DMA_CTRL_TRIG1_ENABLE_MASK       (0x2U)
#define ADC_ETC_DMA_CTRL_TRIG1_ENABLE_SHIFT      (1U)
/*! TRIG1_ENABLE
 *  0b0..TRIG1 DMA request disabled.
 *  0b1..TRIG1 DMA request enabled.
 */
#define ADC_ETC_DMA_CTRL_TRIG1_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG1_ENABLE_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG1_ENABLE_MASK)

#define ADC_ETC_DMA_CTRL_TRIG2_ENABLE_MASK       (0x4U)
#define ADC_ETC_DMA_CTRL_TRIG2_ENABLE_SHIFT      (2U)
/*! TRIG2_ENABLE
 *  0b0..TRIG2 DMA request disabled.
 *  0b1..TRIG2 DMA request enabled.
 */
#define ADC_ETC_DMA_CTRL_TRIG2_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG2_ENABLE_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG2_ENABLE_MASK)

#define ADC_ETC_DMA_CTRL_TRIG3_ENABLE_MASK       (0x8U)
#define ADC_ETC_DMA_CTRL_TRIG3_ENABLE_SHIFT      (3U)
/*! TRIG3_ENABLE
 *  0b0..TRIG3 DMA request disabled.
 *  0b1..TRIG3 DMA request enabled.
 */
#define ADC_ETC_DMA_CTRL_TRIG3_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG3_ENABLE_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG3_ENABLE_MASK)

#define ADC_ETC_DMA_CTRL_TRIG4_ENABLE_MASK       (0x10U)
#define ADC_ETC_DMA_CTRL_TRIG4_ENABLE_SHIFT      (4U)
/*! TRIG4_ENABLE
 *  0b0..TRIG4 DMA request disabled.
 *  0b1..TRIG4 DMA request enabled.
 */
#define ADC_ETC_DMA_CTRL_TRIG4_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG4_ENABLE_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG4_ENABLE_MASK)

#define ADC_ETC_DMA_CTRL_TRIG5_ENABLE_MASK       (0x20U)
#define ADC_ETC_DMA_CTRL_TRIG5_ENABLE_SHIFT      (5U)
/*! TRIG5_ENABLE
 *  0b0..TRIG5 DMA request disabled.
 *  0b1..TRIG5 DMA request enabled.
 */
#define ADC_ETC_DMA_CTRL_TRIG5_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG5_ENABLE_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG5_ENABLE_MASK)

#define ADC_ETC_DMA_CTRL_TRIG6_ENABLE_MASK       (0x40U)
#define ADC_ETC_DMA_CTRL_TRIG6_ENABLE_SHIFT      (6U)
/*! TRIG6_ENABLE
 *  0b0..TRIG6 DMA request disabled.
 *  0b1..TRIG6 DMA request enabled.
 */
#define ADC_ETC_DMA_CTRL_TRIG6_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG6_ENABLE_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG6_ENABLE_MASK)

#define ADC_ETC_DMA_CTRL_TRIG7_ENABLE_MASK       (0x80U)
#define ADC_ETC_DMA_CTRL_TRIG7_ENABLE_SHIFT      (7U)
/*! TRIG7_ENABLE
 *  0b0..TRIG7 DMA request disabled.
 *  0b1..TRIG7 DMA request enabled.
 */
#define ADC_ETC_DMA_CTRL_TRIG7_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG7_ENABLE_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG7_ENABLE_MASK)

#define ADC_ETC_DMA_CTRL_TRIG0_REQ_MASK          (0x10000U)
#define ADC_ETC_DMA_CTRL_TRIG0_REQ_SHIFT         (16U)
/*! TRIG0_REQ
 *  0b0..TRIG0_REQ not detected.
 *  0b1..TRIG0_REQ detected.
 */
#define ADC_ETC_DMA_CTRL_TRIG0_REQ(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG0_REQ_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG0_REQ_MASK)

#define ADC_ETC_DMA_CTRL_TRIG1_REQ_MASK          (0x20000U)
#define ADC_ETC_DMA_CTRL_TRIG1_REQ_SHIFT         (17U)
/*! TRIG1_REQ
 *  0b0..TRIG1_REQ not detected.
 *  0b1..TRIG1_REQ detected.
 */
#define ADC_ETC_DMA_CTRL_TRIG1_REQ(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG1_REQ_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG1_REQ_MASK)

#define ADC_ETC_DMA_CTRL_TRIG2_REQ_MASK          (0x40000U)
#define ADC_ETC_DMA_CTRL_TRIG2_REQ_SHIFT         (18U)
/*! TRIG2_REQ
 *  0b0..TRIG2_REQ not detected.
 *  0b1..TRIG2_REQ detected.
 */
#define ADC_ETC_DMA_CTRL_TRIG2_REQ(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG2_REQ_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG2_REQ_MASK)

#define ADC_ETC_DMA_CTRL_TRIG3_REQ_MASK          (0x80000U)
#define ADC_ETC_DMA_CTRL_TRIG3_REQ_SHIFT         (19U)
/*! TRIG3_REQ
 *  0b0..TRIG3_REQ not detected.
 *  0b1..TRIG3_REQ detected.
 */
#define ADC_ETC_DMA_CTRL_TRIG3_REQ(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG3_REQ_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG3_REQ_MASK)

#define ADC_ETC_DMA_CTRL_TRIG4_REQ_MASK          (0x100000U)
#define ADC_ETC_DMA_CTRL_TRIG4_REQ_SHIFT         (20U)
/*! TRIG4_REQ
 *  0b0..TRIG4_REQ not detected.
 *  0b1..TRIG4_REQ detected.
 */
#define ADC_ETC_DMA_CTRL_TRIG4_REQ(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG4_REQ_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG4_REQ_MASK)

#define ADC_ETC_DMA_CTRL_TRIG5_REQ_MASK          (0x200000U)
#define ADC_ETC_DMA_CTRL_TRIG5_REQ_SHIFT         (21U)
/*! TRIG5_REQ
 *  0b0..TRIG5_REQ not detected.
 *  0b1..TRIG5_REQ detected.
 */
#define ADC_ETC_DMA_CTRL_TRIG5_REQ(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG5_REQ_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG5_REQ_MASK)

#define ADC_ETC_DMA_CTRL_TRIG6_REQ_MASK          (0x400000U)
#define ADC_ETC_DMA_CTRL_TRIG6_REQ_SHIFT         (22U)
/*! TRIG6_REQ
 *  0b0..TRIG6_REQ not detected.
 *  0b1..TRIG6_REQ detected.
 */
#define ADC_ETC_DMA_CTRL_TRIG6_REQ(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG6_REQ_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG6_REQ_MASK)

#define ADC_ETC_DMA_CTRL_TRIG7_REQ_MASK          (0x800000U)
#define ADC_ETC_DMA_CTRL_TRIG7_REQ_SHIFT         (23U)
/*! TRIG7_REQ
 *  0b0..TRIG7_REQ not detected.
 *  0b1..TRIG7_REQ detected.
 */
#define ADC_ETC_DMA_CTRL_TRIG7_REQ(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ETC_DMA_CTRL_TRIG7_REQ_SHIFT)) & ADC_ETC_DMA_CTRL_TRIG7_REQ_MASK)
/*! @} */

/*! @name TRIGn_CTRL - ETC_TRIG Control Register */
/*! @{ */

#define ADC_ETC_TRIGn_CTRL_SW_TRIG_MASK          (0x1U)
#define ADC_ETC_TRIGn_CTRL_SW_TRIG_SHIFT         (0U)
/*! SW_TRIG
 *  0b0..No software trigger event generated.
 *  0b1..Software trigger event generated.
 */
#define ADC_ETC_TRIGn_CTRL_SW_TRIG(x)            (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CTRL_SW_TRIG_SHIFT)) & ADC_ETC_TRIGn_CTRL_SW_TRIG_MASK)

#define ADC_ETC_TRIGn_CTRL_TRIG_MODE_MASK        (0x10U)
#define ADC_ETC_TRIGn_CTRL_TRIG_MODE_SHIFT       (4U)
/*! TRIG_MODE
 *  0b0..Hardware trigger. The softerware trigger will be ignored.
 *  0b1..Software trigger. The hardware trigger will be ignored.
 */
#define ADC_ETC_TRIGn_CTRL_TRIG_MODE(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CTRL_TRIG_MODE_SHIFT)) & ADC_ETC_TRIGn_CTRL_TRIG_MODE_MASK)

#define ADC_ETC_TRIGn_CTRL_TRIG_CHAIN_MASK       (0x700U)
#define ADC_ETC_TRIGn_CTRL_TRIG_CHAIN_SHIFT      (8U)
/*! TRIG_CHAIN
 *  0b000..Trigger chain length is 1
 *  0b001..Trigger chain length is 2
 *  0b010..Trigger chain length is 3
 *  0b011..Trigger chain length is 4
 *  0b100..Trigger chain length is 5
 *  0b101..Trigger chain length is 6
 *  0b110..Trigger chain length is 7
 *  0b111..Trigger chain length is 8
 */
#define ADC_ETC_TRIGn_CTRL_TRIG_CHAIN(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CTRL_TRIG_CHAIN_SHIFT)) & ADC_ETC_TRIGn_CTRL_TRIG_CHAIN_MASK)

#define ADC_ETC_TRIGn_CTRL_TRIG_PRIORITY_MASK    (0x7000U)
#define ADC_ETC_TRIGn_CTRL_TRIG_PRIORITY_SHIFT   (12U)
#define ADC_ETC_TRIGn_CTRL_TRIG_PRIORITY(x)      (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CTRL_TRIG_PRIORITY_SHIFT)) & ADC_ETC_TRIGn_CTRL_TRIG_PRIORITY_MASK)

#define ADC_ETC_TRIGn_CTRL_SYNC_MODE_MASK        (0x10000U)
#define ADC_ETC_TRIGn_CTRL_SYNC_MODE_SHIFT       (16U)
/*! SYNC_MODE
 *  0b0..Synchronization mode disabled, TRIGa and TRIG(a+4) are triggered independently.
 *  0b1..Synchronization mode enabled, TRIGa and TRIG(a+4) are triggered by TRIGa source synchronously.
 */
#define ADC_ETC_TRIGn_CTRL_SYNC_MODE(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CTRL_SYNC_MODE_SHIFT)) & ADC_ETC_TRIGn_CTRL_SYNC_MODE_MASK)

#define ADC_ETC_TRIGn_CTRL_CHAINx_DONE_MASK      (0xFF000000U)
#define ADC_ETC_TRIGn_CTRL_CHAINx_DONE_SHIFT     (24U)
/*! CHAINx_DONE
 *  0b00000000..segment x done not detected.
 *  0b00000001..segment x done detected.
 */
#define ADC_ETC_TRIGn_CTRL_CHAINx_DONE(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CTRL_CHAINx_DONE_SHIFT)) & ADC_ETC_TRIGn_CTRL_CHAINx_DONE_MASK)
/*! @} */

/* The count of ADC_ETC_TRIGn_CTRL */
#define ADC_ETC_TRIGn_CTRL_COUNT                 (8U)

/*! @name TRIGn_COUNTER - ETC_TRIG Counter Register */
/*! @{ */

#define ADC_ETC_TRIGn_COUNTER_INIT_DELAY_MASK    (0xFFFFU)
#define ADC_ETC_TRIGn_COUNTER_INIT_DELAY_SHIFT   (0U)
#define ADC_ETC_TRIGn_COUNTER_INIT_DELAY(x)      (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_COUNTER_INIT_DELAY_SHIFT)) & ADC_ETC_TRIGn_COUNTER_INIT_DELAY_MASK)

#define ADC_ETC_TRIGn_COUNTER_SAMPLE_INTERVAL_MASK (0xFFFF0000U)
#define ADC_ETC_TRIGn_COUNTER_SAMPLE_INTERVAL_SHIFT (16U)
#define ADC_ETC_TRIGn_COUNTER_SAMPLE_INTERVAL(x) (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_COUNTER_SAMPLE_INTERVAL_SHIFT)) & ADC_ETC_TRIGn_COUNTER_SAMPLE_INTERVAL_MASK)
/*! @} */

/* The count of ADC_ETC_TRIGn_COUNTER */
#define ADC_ETC_TRIGn_COUNTER_COUNT              (8U)

/*! @name TRIGn_CHAIN_1_0 - ETC_TRIG Chain 0/1 Register */
/*! @{ */

#define ADC_ETC_TRIGn_CHAIN_1_0_CSEL0_MASK       (0xFU)
#define ADC_ETC_TRIGn_CHAIN_1_0_CSEL0_SHIFT      (0U)
/*! CSEL0
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..ADC CMD1 selected.
 *  0b0010..ADC CMD2 selected.
 *  0b0011..ADC CMD3 selected.
 *  0b0100..ADC CMD4 selected.
 *  0b0101..ADC CMD5 selected.
 *  0b0110..ADC CMD6 selected.
 *  0b0111..ADC CMD7 selected.
 *  0b1000..ADC CMD8 selected.
 *  0b1001..ADC CMD9 selected.
 *  0b1010..ADC CMD10 selected.
 *  0b1011..ADC CMD11 selected.
 *  0b1100..ADC CMD12 selected.
 *  0b1101..ADC CMD13 selected.
 *  0b1110..ADC CMD14 selected.
 *  0b1111..ADC CMD15 selected.
 */
#define ADC_ETC_TRIGn_CHAIN_1_0_CSEL0(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_1_0_CSEL0_SHIFT)) & ADC_ETC_TRIGn_CHAIN_1_0_CSEL0_MASK)

#define ADC_ETC_TRIGn_CHAIN_1_0_HWTS0_MASK       (0xFF0U)
#define ADC_ETC_TRIGn_CHAIN_1_0_HWTS0_SHIFT      (4U)
/*! HWTS0
 *  0b00000000..no trigger selected
 *  0b00000001..ADC TRIG0 selected
 *  0b00000010..ADC TRIG1 selected
 *  0b00000100..ADC TRIG2 selected
 *  0b00001000..ADC TRIG3 selected
 *  0b00010000..ADC TRIG4 selected
 *  0b00100000..ADC TRIG5 selected
 *  0b01000000..ADC TRIG6 selected
 *  0b10000000..ADC TRIG7 selected
 */
#define ADC_ETC_TRIGn_CHAIN_1_0_HWTS0(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_1_0_HWTS0_SHIFT)) & ADC_ETC_TRIGn_CHAIN_1_0_HWTS0_MASK)

#define ADC_ETC_TRIGn_CHAIN_1_0_B2B0_MASK        (0x1000U)
#define ADC_ETC_TRIGn_CHAIN_1_0_B2B0_SHIFT       (12U)
/*! B2B0
 *  0b0..Disable B2B. Wait until delay value defined by TRIG0_COUNTER[SAMPLE_INTERVAL] is reached
 *  0b1..Enable B2B. When Segment 0 finished (ADC COCO) then automatically trigger next ADC conversion, no need to wait until interval delay reached.
 */
#define ADC_ETC_TRIGn_CHAIN_1_0_B2B0(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_1_0_B2B0_SHIFT)) & ADC_ETC_TRIGn_CHAIN_1_0_B2B0_MASK)

#define ADC_ETC_TRIGn_CHAIN_1_0_IE0_MASK         (0x6000U)
#define ADC_ETC_TRIGn_CHAIN_1_0_IE0_SHIFT        (13U)
/*! IE0
 *  0b00..Generate interrupt on Done0 when segment 0 finish.
 *  0b01..Generate interrupt on Done1 when segment 0 finish.
 *  0b10..Generate interrupt on Done2 when segment 0 finish.
 *  0b11..Generate interrupt on Done3 when segment 0 finish.
 */
#define ADC_ETC_TRIGn_CHAIN_1_0_IE0(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_1_0_IE0_SHIFT)) & ADC_ETC_TRIGn_CHAIN_1_0_IE0_MASK)

#define ADC_ETC_TRIGn_CHAIN_1_0_IE0_EN_MASK      (0x8000U)
#define ADC_ETC_TRIGn_CHAIN_1_0_IE0_EN_SHIFT     (15U)
/*! IE0_EN
 *  0b0..Interrupt DONE disabled.
 *  0b1..Interrupt DONE enabled. When segment 0 finish, an interrupt will be generated on the specific port configured by the IE0.
 */
#define ADC_ETC_TRIGn_CHAIN_1_0_IE0_EN(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_1_0_IE0_EN_SHIFT)) & ADC_ETC_TRIGn_CHAIN_1_0_IE0_EN_MASK)

#define ADC_ETC_TRIGn_CHAIN_1_0_CSEL1_MASK       (0xF0000U)
#define ADC_ETC_TRIGn_CHAIN_1_0_CSEL1_SHIFT      (16U)
/*! CSEL1
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..ADC CMD1 selected.
 *  0b0010..ADC CMD2 selected.
 *  0b0011..ADC CMD3 selected.
 *  0b0100..ADC CMD4 selected.
 *  0b0101..ADC CMD5 selected.
 *  0b0110..ADC CMD6 selected.
 *  0b0111..ADC CMD7 selected.
 *  0b1000..ADC CMD8 selected.
 *  0b1001..ADC CMD9 selected.
 *  0b1010..ADC CMD10 selected.
 *  0b1011..ADC CMD11 selected.
 *  0b1100..ADC CMD12 selected.
 *  0b1101..ADC CMD13 selected.
 *  0b1110..ADC CMD14 selected.
 *  0b1111..ADC CMD15 selected.
 */
#define ADC_ETC_TRIGn_CHAIN_1_0_CSEL1(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_1_0_CSEL1_SHIFT)) & ADC_ETC_TRIGn_CHAIN_1_0_CSEL1_MASK)

#define ADC_ETC_TRIGn_CHAIN_1_0_HWTS1_MASK       (0xFF00000U)
#define ADC_ETC_TRIGn_CHAIN_1_0_HWTS1_SHIFT      (20U)
/*! HWTS1
 *  0b00000000..no trigger selected
 *  0b00000001..ADC TRIG0 selected
 *  0b00000010..ADC TRIG1 selected
 *  0b00000100..ADC TRIG2 selected
 *  0b00001000..ADC TRIG3 selected
 *  0b00010000..ADC TRIG4 selected
 *  0b00100000..ADC TRIG5 selected
 *  0b01000000..ADC TRIG6 selected
 *  0b10000000..ADC TRIG7 selected
 */
#define ADC_ETC_TRIGn_CHAIN_1_0_HWTS1(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_1_0_HWTS1_SHIFT)) & ADC_ETC_TRIGn_CHAIN_1_0_HWTS1_MASK)

#define ADC_ETC_TRIGn_CHAIN_1_0_B2B1_MASK        (0x10000000U)
#define ADC_ETC_TRIGn_CHAIN_1_0_B2B1_SHIFT       (28U)
/*! B2B1
 *  0b0..Disable B2B. Wait until delay value defined by TRIG1_COUNTER[SAMPLE_INTERVAL] is reached
 *  0b1..Enable B2B. When Segment 0 finished (ADC COCO) then automatically trigger next ADC conversion, no need to wait until interval delay reached.
 */
#define ADC_ETC_TRIGn_CHAIN_1_0_B2B1(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_1_0_B2B1_SHIFT)) & ADC_ETC_TRIGn_CHAIN_1_0_B2B1_MASK)

#define ADC_ETC_TRIGn_CHAIN_1_0_IE1_MASK         (0x60000000U)
#define ADC_ETC_TRIGn_CHAIN_1_0_IE1_SHIFT        (29U)
/*! IE1
 *  0b00..Generate interrupt on Done0 when Segment 1 finish.
 *  0b01..Generate interrupt on Done1 when Segment 1 finish.
 *  0b10..Generate interrupt on Done2 when Segment 1 finish.
 *  0b11..Generate interrupt on Done3 when Segment 1 finish.
 */
#define ADC_ETC_TRIGn_CHAIN_1_0_IE1(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_1_0_IE1_SHIFT)) & ADC_ETC_TRIGn_CHAIN_1_0_IE1_MASK)

#define ADC_ETC_TRIGn_CHAIN_1_0_IE1_EN_MASK      (0x80000000U)
#define ADC_ETC_TRIGn_CHAIN_1_0_IE1_EN_SHIFT     (31U)
/*! IE1_EN
 *  0b0..Interrupt DONE disabled.
 *  0b1..Interrupt DONE enabled. When segment 1 finish, an interrupt will be generated on the specific port configured by the IE1.
 */
#define ADC_ETC_TRIGn_CHAIN_1_0_IE1_EN(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_1_0_IE1_EN_SHIFT)) & ADC_ETC_TRIGn_CHAIN_1_0_IE1_EN_MASK)
/*! @} */

/* The count of ADC_ETC_TRIGn_CHAIN_1_0 */
#define ADC_ETC_TRIGn_CHAIN_1_0_COUNT            (8U)

/*! @name TRIGn_CHAIN_3_2 - ETC_TRIG Chain 2/3 Register */
/*! @{ */

#define ADC_ETC_TRIGn_CHAIN_3_2_CSEL2_MASK       (0xFU)
#define ADC_ETC_TRIGn_CHAIN_3_2_CSEL2_SHIFT      (0U)
/*! CSEL2
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..ADC CMD1 selected.
 *  0b0010..ADC CMD2 selected.
 *  0b0011..ADC CMD3 selected.
 *  0b0100..ADC CMD4 selected.
 *  0b0101..ADC CMD5 selected.
 *  0b0110..ADC CMD6 selected.
 *  0b0111..ADC CMD7 selected.
 *  0b1000..ADC CMD8 selected.
 *  0b1001..ADC CMD9 selected.
 *  0b1010..ADC CMD10 selected.
 *  0b1011..ADC CMD11 selected.
 *  0b1100..ADC CMD12 selected.
 *  0b1101..ADC CMD13 selected.
 *  0b1110..ADC CMD14 selected.
 *  0b1111..ADC CMD15 selected.
 */
#define ADC_ETC_TRIGn_CHAIN_3_2_CSEL2(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_3_2_CSEL2_SHIFT)) & ADC_ETC_TRIGn_CHAIN_3_2_CSEL2_MASK)

#define ADC_ETC_TRIGn_CHAIN_3_2_HWTS2_MASK       (0xFF0U)
#define ADC_ETC_TRIGn_CHAIN_3_2_HWTS2_SHIFT      (4U)
/*! HWTS2
 *  0b00000000..no trigger selected
 *  0b00000001..ADC TRIG0 selected
 *  0b00000010..ADC TRIG1 selected
 *  0b00000100..ADC TRIG2 selected
 *  0b00001000..ADC TRIG3 selected
 *  0b00010000..ADC TRIG4 selected
 *  0b00100000..ADC TRIG5 selected
 *  0b01000000..ADC TRIG6 selected
 *  0b10000000..ADC TRIG7 selected
 */
#define ADC_ETC_TRIGn_CHAIN_3_2_HWTS2(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_3_2_HWTS2_SHIFT)) & ADC_ETC_TRIGn_CHAIN_3_2_HWTS2_MASK)

#define ADC_ETC_TRIGn_CHAIN_3_2_B2B2_MASK        (0x1000U)
#define ADC_ETC_TRIGn_CHAIN_3_2_B2B2_SHIFT       (12U)
/*! B2B2
 *  0b0..Disable B2B. Wait until delay value defined by TRIG2_COUNTER[SAMPLE_INTERVAL] is reached
 *  0b1..Enable B2B. When Segment 0 finished (ADC COCO) then automatically trigger next ADC conversion, no need to wait until interval delay reached.
 */
#define ADC_ETC_TRIGn_CHAIN_3_2_B2B2(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_3_2_B2B2_SHIFT)) & ADC_ETC_TRIGn_CHAIN_3_2_B2B2_MASK)

#define ADC_ETC_TRIGn_CHAIN_3_2_IE2_MASK         (0x6000U)
#define ADC_ETC_TRIGn_CHAIN_3_2_IE2_SHIFT        (13U)
/*! IE2
 *  0b00..Generate interrupt on Done0 when segment 2 finish.
 *  0b01..Generate interrupt on Done1 when segment 2 finish.
 *  0b10..Generate interrupt on Done2 when segment 2 finish.
 *  0b11..Generate interrupt on Done3 when segment 2 finish.
 */
#define ADC_ETC_TRIGn_CHAIN_3_2_IE2(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_3_2_IE2_SHIFT)) & ADC_ETC_TRIGn_CHAIN_3_2_IE2_MASK)

#define ADC_ETC_TRIGn_CHAIN_3_2_IE2_EN_MASK      (0x8000U)
#define ADC_ETC_TRIGn_CHAIN_3_2_IE2_EN_SHIFT     (15U)
/*! IE2_EN
 *  0b0..Interrupt DONE disabled.
 *  0b1..Interrupt DONE enabled. When segment 2 finish, an interrupt will be generated on the specific port configured by the IE2.
 */
#define ADC_ETC_TRIGn_CHAIN_3_2_IE2_EN(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_3_2_IE2_EN_SHIFT)) & ADC_ETC_TRIGn_CHAIN_3_2_IE2_EN_MASK)

#define ADC_ETC_TRIGn_CHAIN_3_2_CSEL3_MASK       (0xF0000U)
#define ADC_ETC_TRIGn_CHAIN_3_2_CSEL3_SHIFT      (16U)
/*! CSEL3
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..ADC CMD1 selected.
 *  0b0010..ADC CMD2 selected.
 *  0b0011..ADC CMD3 selected.
 *  0b0100..ADC CMD4 selected.
 *  0b0101..ADC CMD5 selected.
 *  0b0110..ADC CMD6 selected.
 *  0b0111..ADC CMD7 selected.
 *  0b1000..ADC CMD8 selected.
 *  0b1001..ADC CMD9 selected.
 *  0b1010..ADC CMD10 selected.
 *  0b1011..ADC CMD11 selected.
 *  0b1100..ADC CMD12 selected.
 *  0b1101..ADC CMD13 selected.
 *  0b1110..ADC CMD14 selected.
 *  0b1111..ADC CMD15 selected.
 */
#define ADC_ETC_TRIGn_CHAIN_3_2_CSEL3(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_3_2_CSEL3_SHIFT)) & ADC_ETC_TRIGn_CHAIN_3_2_CSEL3_MASK)

#define ADC_ETC_TRIGn_CHAIN_3_2_HWTS3_MASK       (0xFF00000U)
#define ADC_ETC_TRIGn_CHAIN_3_2_HWTS3_SHIFT      (20U)
/*! HWTS3
 *  0b00000000..no trigger selected
 *  0b00000001..ADC TRIG0 selected
 *  0b00000010..ADC TRIG1 selected
 *  0b00000100..ADC TRIG2 selected
 *  0b00001000..ADC TRIG3 selected
 *  0b00010000..ADC TRIG4 selected
 *  0b00100000..ADC TRIG5 selected
 *  0b01000000..ADC TRIG6 selected
 *  0b10000000..ADC TRIG7 selected
 */
#define ADC_ETC_TRIGn_CHAIN_3_2_HWTS3(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_3_2_HWTS3_SHIFT)) & ADC_ETC_TRIGn_CHAIN_3_2_HWTS3_MASK)

#define ADC_ETC_TRIGn_CHAIN_3_2_B2B3_MASK        (0x10000000U)
#define ADC_ETC_TRIGn_CHAIN_3_2_B2B3_SHIFT       (28U)
/*! B2B3
 *  0b0..Disable B2B. Wait until delay value defined by TRIG3_COUNTER[SAMPLE_INTERVAL] is reached
 *  0b1..Enable B2B. When Segment 0 finished (ADC COCO) then automatically trigger next ADC conversion, no need to wait until interval delay reached.
 */
#define ADC_ETC_TRIGn_CHAIN_3_2_B2B3(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_3_2_B2B3_SHIFT)) & ADC_ETC_TRIGn_CHAIN_3_2_B2B3_MASK)

#define ADC_ETC_TRIGn_CHAIN_3_2_IE3_MASK         (0x60000000U)
#define ADC_ETC_TRIGn_CHAIN_3_2_IE3_SHIFT        (29U)
/*! IE3
 *  0b00..Generate interrupt on Done0 when segment 3 finish.
 *  0b01..Generate interrupt on Done1 when segment 3 finish.
 *  0b10..Generate interrupt on Done2 when segment 3 finish.
 *  0b11..Generate interrupt on Done3 when segment 3 finish.
 */
#define ADC_ETC_TRIGn_CHAIN_3_2_IE3(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_3_2_IE3_SHIFT)) & ADC_ETC_TRIGn_CHAIN_3_2_IE3_MASK)

#define ADC_ETC_TRIGn_CHAIN_3_2_IE3_EN_MASK      (0x80000000U)
#define ADC_ETC_TRIGn_CHAIN_3_2_IE3_EN_SHIFT     (31U)
/*! IE3_EN
 *  0b0..Interrupt DONE disabled.
 *  0b1..Interrupt DONE enabled. When segment 3 finish, an interrupt will be generated on the specific port configured by the IE3.
 */
#define ADC_ETC_TRIGn_CHAIN_3_2_IE3_EN(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_3_2_IE3_EN_SHIFT)) & ADC_ETC_TRIGn_CHAIN_3_2_IE3_EN_MASK)
/*! @} */

/* The count of ADC_ETC_TRIGn_CHAIN_3_2 */
#define ADC_ETC_TRIGn_CHAIN_3_2_COUNT            (8U)

/*! @name TRIGn_CHAIN_5_4 - ETC_TRIG Chain 4/5 Register */
/*! @{ */

#define ADC_ETC_TRIGn_CHAIN_5_4_CSEL4_MASK       (0xFU)
#define ADC_ETC_TRIGn_CHAIN_5_4_CSEL4_SHIFT      (0U)
/*! CSEL4
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..ADC CMD1 selected.
 *  0b0010..ADC CMD2 selected.
 *  0b0011..ADC CMD3 selected.
 *  0b0100..ADC CMD4 selected.
 *  0b0101..ADC CMD5 selected.
 *  0b0110..ADC CMD6 selected.
 *  0b0111..ADC CMD7 selected.
 *  0b1000..ADC CMD8 selected.
 *  0b1001..ADC CMD9 selected.
 *  0b1010..ADC CMD10 selected.
 *  0b1011..ADC CMD11 selected.
 *  0b1100..ADC CMD12 selected.
 *  0b1101..ADC CMD13 selected.
 *  0b1110..ADC CMD14 selected.
 *  0b1111..ADC CMD15 selected.
 */
#define ADC_ETC_TRIGn_CHAIN_5_4_CSEL4(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_5_4_CSEL4_SHIFT)) & ADC_ETC_TRIGn_CHAIN_5_4_CSEL4_MASK)

#define ADC_ETC_TRIGn_CHAIN_5_4_HWTS4_MASK       (0xFF0U)
#define ADC_ETC_TRIGn_CHAIN_5_4_HWTS4_SHIFT      (4U)
/*! HWTS4
 *  0b00000000..no trigger selected
 *  0b00000001..ADC TRIG0 selected
 *  0b00000010..ADC TRIG1 selected
 *  0b00000100..ADC TRIG2 selected
 *  0b00001000..ADC TRIG3 selected
 *  0b00010000..ADC TRIG4 selected
 *  0b00100000..ADC TRIG5 selected
 *  0b01000000..ADC TRIG6 selected
 *  0b10000000..ADC TRIG7 selected
 */
#define ADC_ETC_TRIGn_CHAIN_5_4_HWTS4(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_5_4_HWTS4_SHIFT)) & ADC_ETC_TRIGn_CHAIN_5_4_HWTS4_MASK)

#define ADC_ETC_TRIGn_CHAIN_5_4_B2B4_MASK        (0x1000U)
#define ADC_ETC_TRIGn_CHAIN_5_4_B2B4_SHIFT       (12U)
/*! B2B4
 *  0b0..Disable B2B. Wait until delay value defined by TRIG4_COUNTER[SAMPLE_INTERVAL] is reached
 *  0b1..Enable B2B. When Segment 0 finished (ADC COCO) then automatically trigger next ADC conversion, no need to wait until interval delay reached.
 */
#define ADC_ETC_TRIGn_CHAIN_5_4_B2B4(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_5_4_B2B4_SHIFT)) & ADC_ETC_TRIGn_CHAIN_5_4_B2B4_MASK)

#define ADC_ETC_TRIGn_CHAIN_5_4_IE4_MASK         (0x6000U)
#define ADC_ETC_TRIGn_CHAIN_5_4_IE4_SHIFT        (13U)
/*! IE4
 *  0b00..Generate interrupt on Done0 when segment 4 finish.
 *  0b01..Generate interrupt on Done1 when segment 4 finish.
 *  0b10..Generate interrupt on Done2 when segment 4 finish.
 *  0b11..Generate interrupt on Done3 when segment 4 finish.
 */
#define ADC_ETC_TRIGn_CHAIN_5_4_IE4(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_5_4_IE4_SHIFT)) & ADC_ETC_TRIGn_CHAIN_5_4_IE4_MASK)

#define ADC_ETC_TRIGn_CHAIN_5_4_IE4_EN_MASK      (0x8000U)
#define ADC_ETC_TRIGn_CHAIN_5_4_IE4_EN_SHIFT     (15U)
/*! IE4_EN
 *  0b0..Interrupt DONE disabled.
 *  0b1..Interrupt DONE enabled. When segment 4 finish, an interrupt will be generated on the specific port configured by the IE4.
 */
#define ADC_ETC_TRIGn_CHAIN_5_4_IE4_EN(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_5_4_IE4_EN_SHIFT)) & ADC_ETC_TRIGn_CHAIN_5_4_IE4_EN_MASK)

#define ADC_ETC_TRIGn_CHAIN_5_4_CSEL5_MASK       (0xF0000U)
#define ADC_ETC_TRIGn_CHAIN_5_4_CSEL5_SHIFT      (16U)
/*! CSEL5
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..ADC CMD1 selected.
 *  0b0010..ADC CMD2 selected.
 *  0b0011..ADC CMD3 selected.
 *  0b0100..ADC CMD4 selected.
 *  0b0101..ADC CMD5 selected.
 *  0b0110..ADC CMD6 selected.
 *  0b0111..ADC CMD7 selected.
 *  0b1000..ADC CMD8 selected.
 *  0b1001..ADC CMD9 selected.
 *  0b1010..ADC CMD10 selected.
 *  0b1011..ADC CMD11 selected.
 *  0b1100..ADC CMD12 selected.
 *  0b1101..ADC CMD13 selected.
 *  0b1110..ADC CMD14 selected.
 *  0b1111..ADC CMD15 selected.
 */
#define ADC_ETC_TRIGn_CHAIN_5_4_CSEL5(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_5_4_CSEL5_SHIFT)) & ADC_ETC_TRIGn_CHAIN_5_4_CSEL5_MASK)

#define ADC_ETC_TRIGn_CHAIN_5_4_HWTS5_MASK       (0xFF00000U)
#define ADC_ETC_TRIGn_CHAIN_5_4_HWTS5_SHIFT      (20U)
/*! HWTS5
 *  0b00000000..no trigger selected
 *  0b00000001..ADC TRIG0 selected
 *  0b00000010..ADC TRIG1 selected
 *  0b00000100..ADC TRIG2 selected
 *  0b00001000..ADC TRIG3 selected
 *  0b00010000..ADC TRIG4 selected
 *  0b00100000..ADC TRIG5 selected
 *  0b01000000..ADC TRIG6 selected
 *  0b10000000..ADC TRIG7 selected
 */
#define ADC_ETC_TRIGn_CHAIN_5_4_HWTS5(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_5_4_HWTS5_SHIFT)) & ADC_ETC_TRIGn_CHAIN_5_4_HWTS5_MASK)

#define ADC_ETC_TRIGn_CHAIN_5_4_B2B5_MASK        (0x10000000U)
#define ADC_ETC_TRIGn_CHAIN_5_4_B2B5_SHIFT       (28U)
/*! B2B5
 *  0b0..Disable B2B. Wait until delay value defined by TRIG5_COUNTER[SAMPLE_INTERVAL] is reached
 *  0b1..Enable B2B. When Segment 0 finished (ADC COCO) then automatically trigger next ADC conversion, no need to wait until interval delay reached.
 */
#define ADC_ETC_TRIGn_CHAIN_5_4_B2B5(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_5_4_B2B5_SHIFT)) & ADC_ETC_TRIGn_CHAIN_5_4_B2B5_MASK)

#define ADC_ETC_TRIGn_CHAIN_5_4_IE5_MASK         (0x60000000U)
#define ADC_ETC_TRIGn_CHAIN_5_4_IE5_SHIFT        (29U)
/*! IE5
 *  0b00..Generate interrupt on Done0 when segment 5 finish.
 *  0b01..Generate interrupt on Done1 when segment 5 finish.
 *  0b10..Generate interrupt on Done2 when segment 5 finish.
 *  0b11..Generate interrupt on Done3 when segment 5 finish.
 */
#define ADC_ETC_TRIGn_CHAIN_5_4_IE5(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_5_4_IE5_SHIFT)) & ADC_ETC_TRIGn_CHAIN_5_4_IE5_MASK)

#define ADC_ETC_TRIGn_CHAIN_5_4_IE5_EN_MASK      (0x80000000U)
#define ADC_ETC_TRIGn_CHAIN_5_4_IE5_EN_SHIFT     (31U)
/*! IE5_EN
 *  0b0..Interrupt DONE disabled.
 *  0b1..Interrupt DONE enabled. When segment 5 finish, an interrupt will be generated on the specific port configured by the IE5.
 */
#define ADC_ETC_TRIGn_CHAIN_5_4_IE5_EN(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_5_4_IE5_EN_SHIFT)) & ADC_ETC_TRIGn_CHAIN_5_4_IE5_EN_MASK)
/*! @} */

/* The count of ADC_ETC_TRIGn_CHAIN_5_4 */
#define ADC_ETC_TRIGn_CHAIN_5_4_COUNT            (8U)

/*! @name TRIGn_CHAIN_7_6 - ETC_TRIG Chain 6/7 Register */
/*! @{ */

#define ADC_ETC_TRIGn_CHAIN_7_6_CSEL6_MASK       (0xFU)
#define ADC_ETC_TRIGn_CHAIN_7_6_CSEL6_SHIFT      (0U)
/*! CSEL6
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..ADC CMD1 selected.
 *  0b0010..ADC CMD2 selected.
 *  0b0011..ADC CMD3 selected.
 *  0b0100..ADC CMD4 selected.
 *  0b0101..ADC CMD5 selected.
 *  0b0110..ADC CMD6 selected.
 *  0b0111..ADC CMD7 selected.
 *  0b1000..ADC CMD8 selected.
 *  0b1001..ADC CMD9 selected.
 *  0b1010..ADC CMD10 selected.
 *  0b1011..ADC CMD11 selected.
 *  0b1100..ADC CMD12 selected.
 *  0b1101..ADC CMD13 selected.
 *  0b1110..ADC CMD14 selected.
 *  0b1111..ADC CMD15 selected.
 */
#define ADC_ETC_TRIGn_CHAIN_7_6_CSEL6(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_7_6_CSEL6_SHIFT)) & ADC_ETC_TRIGn_CHAIN_7_6_CSEL6_MASK)

#define ADC_ETC_TRIGn_CHAIN_7_6_HWTS6_MASK       (0xFF0U)
#define ADC_ETC_TRIGn_CHAIN_7_6_HWTS6_SHIFT      (4U)
/*! HWTS6
 *  0b00000000..no trigger selected
 *  0b00000001..ADC TRIG0 selected
 *  0b00000010..ADC TRIG1 selected
 *  0b00000100..ADC TRIG2 selected
 *  0b00001000..ADC TRIG3 selected
 *  0b00010000..ADC TRIG4 selected
 *  0b00100000..ADC TRIG5 selected
 *  0b01000000..ADC TRIG6 selected
 *  0b10000000..ADC TRIG7 selected
 */
#define ADC_ETC_TRIGn_CHAIN_7_6_HWTS6(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_7_6_HWTS6_SHIFT)) & ADC_ETC_TRIGn_CHAIN_7_6_HWTS6_MASK)

#define ADC_ETC_TRIGn_CHAIN_7_6_B2B6_MASK        (0x1000U)
#define ADC_ETC_TRIGn_CHAIN_7_6_B2B6_SHIFT       (12U)
/*! B2B6
 *  0b0..Disable B2B. Wait until delay value defined by TRIG6_COUNTER[SAMPLE_INTERVAL] is reached
 *  0b1..Enable B2B. When Segment 0 finished (ADC COCO) then automatically trigger next ADC conversion, no need to wait until interval delay reached.
 */
#define ADC_ETC_TRIGn_CHAIN_7_6_B2B6(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_7_6_B2B6_SHIFT)) & ADC_ETC_TRIGn_CHAIN_7_6_B2B6_MASK)

#define ADC_ETC_TRIGn_CHAIN_7_6_IE6_MASK         (0x6000U)
#define ADC_ETC_TRIGn_CHAIN_7_6_IE6_SHIFT        (13U)
/*! IE6
 *  0b00..Generate interrupt on Done0 when segment 6 finish.
 *  0b01..Generate interrupt on Done1 when segment 6 finish.
 *  0b10..Generate interrupt on Done2 when segment 6 finish.
 *  0b11..Generate interrupt on Done3 when segment 6 finish.
 */
#define ADC_ETC_TRIGn_CHAIN_7_6_IE6(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_7_6_IE6_SHIFT)) & ADC_ETC_TRIGn_CHAIN_7_6_IE6_MASK)

#define ADC_ETC_TRIGn_CHAIN_7_6_IE6_EN_MASK      (0x8000U)
#define ADC_ETC_TRIGn_CHAIN_7_6_IE6_EN_SHIFT     (15U)
/*! IE6_EN
 *  0b0..Interrupt DONE disabled.
 *  0b1..Interrupt DONE enabled. When segment 6 finish, an interrupt will be generated on the specific port configured by the IE6.
 */
#define ADC_ETC_TRIGn_CHAIN_7_6_IE6_EN(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_7_6_IE6_EN_SHIFT)) & ADC_ETC_TRIGn_CHAIN_7_6_IE6_EN_MASK)

#define ADC_ETC_TRIGn_CHAIN_7_6_CSEL7_MASK       (0xF0000U)
#define ADC_ETC_TRIGn_CHAIN_7_6_CSEL7_SHIFT      (16U)
/*! CSEL7
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..ADC CMD1 selected.
 *  0b0010..ADC CMD2 selected.
 *  0b0011..ADC CMD3 selected.
 *  0b0100..ADC CMD4 selected.
 *  0b0101..ADC CMD5 selected.
 *  0b0110..ADC CMD6 selected.
 *  0b0111..ADC CMD7 selected.
 *  0b1000..ADC CMD8 selected.
 *  0b1001..ADC CMD9 selected.
 *  0b1010..ADC CMD10 selected.
 *  0b1011..ADC CMD11 selected.
 *  0b1100..ADC CMD12 selected.
 *  0b1101..ADC CMD13 selected.
 *  0b1110..ADC CMD14 selected.
 *  0b1111..ADC CMD15 selected.
 */
#define ADC_ETC_TRIGn_CHAIN_7_6_CSEL7(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_7_6_CSEL7_SHIFT)) & ADC_ETC_TRIGn_CHAIN_7_6_CSEL7_MASK)

#define ADC_ETC_TRIGn_CHAIN_7_6_HWTS7_MASK       (0xFF00000U)
#define ADC_ETC_TRIGn_CHAIN_7_6_HWTS7_SHIFT      (20U)
/*! HWTS7
 *  0b00000000..no trigger selected
 *  0b00000001..ADC TRIG0 selected
 *  0b00000010..ADC TRIG1 selected
 *  0b00000100..ADC TRIG2 selected
 *  0b00001000..ADC TRIG3 selected
 *  0b00010000..ADC TRIG4 selected
 *  0b00100000..ADC TRIG5 selected
 *  0b01000000..ADC TRIG6 selected
 *  0b10000000..ADC TRIG7 selected
 */
#define ADC_ETC_TRIGn_CHAIN_7_6_HWTS7(x)         (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_7_6_HWTS7_SHIFT)) & ADC_ETC_TRIGn_CHAIN_7_6_HWTS7_MASK)

#define ADC_ETC_TRIGn_CHAIN_7_6_B2B7_MASK        (0x10000000U)
#define ADC_ETC_TRIGn_CHAIN_7_6_B2B7_SHIFT       (28U)
/*! B2B7
 *  0b0..Disable B2B. Wait until delay value defined by TRIG7_COUNTER[SAMPLE_INTERVAL] is reached
 *  0b1..Enable B2B. When Segment 0 finished (ADC COCO) then automatically trigger next ADC conversion, no need to wait until interval delay reached.
 */
#define ADC_ETC_TRIGn_CHAIN_7_6_B2B7(x)          (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_7_6_B2B7_SHIFT)) & ADC_ETC_TRIGn_CHAIN_7_6_B2B7_MASK)

#define ADC_ETC_TRIGn_CHAIN_7_6_IE7_MASK         (0x60000000U)
#define ADC_ETC_TRIGn_CHAIN_7_6_IE7_SHIFT        (29U)
/*! IE7
 *  0b00..Generate interrupt on Done0 when segment 7 finish.
 *  0b01..Generate interrupt on Done1 when segment 7 finish.
 *  0b10..Generate interrupt on Done2 when segment 7 finish.
 *  0b11..Generate interrupt on Done3 when segment 7 finish.
 */
#define ADC_ETC_TRIGn_CHAIN_7_6_IE7(x)           (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_7_6_IE7_SHIFT)) & ADC_ETC_TRIGn_CHAIN_7_6_IE7_MASK)

#define ADC_ETC_TRIGn_CHAIN_7_6_IE7_EN_MASK      (0x80000000U)
#define ADC_ETC_TRIGn_CHAIN_7_6_IE7_EN_SHIFT     (31U)
/*! IE7_EN
 *  0b0..Interrupt DONE disabled.
 *  0b1..Interrupt DONE enabled. When segment 7 finish, an interrupt will be generated on the specific port configured by the IE7.
 */
#define ADC_ETC_TRIGn_CHAIN_7_6_IE7_EN(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_CHAIN_7_6_IE7_EN_SHIFT)) & ADC_ETC_TRIGn_CHAIN_7_6_IE7_EN_MASK)
/*! @} */

/* The count of ADC_ETC_TRIGn_CHAIN_7_6 */
#define ADC_ETC_TRIGn_CHAIN_7_6_COUNT            (8U)

/*! @name TRIGn_RESULT_1_0 - ETC_TRIG Result Data 1/0 Register */
/*! @{ */

#define ADC_ETC_TRIGn_RESULT_1_0_DATA0_MASK      (0xFFFU)
#define ADC_ETC_TRIGn_RESULT_1_0_DATA0_SHIFT     (0U)
#define ADC_ETC_TRIGn_RESULT_1_0_DATA0(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_RESULT_1_0_DATA0_SHIFT)) & ADC_ETC_TRIGn_RESULT_1_0_DATA0_MASK)

#define ADC_ETC_TRIGn_RESULT_1_0_DATA1_MASK      (0xFFF0000U)
#define ADC_ETC_TRIGn_RESULT_1_0_DATA1_SHIFT     (16U)
#define ADC_ETC_TRIGn_RESULT_1_0_DATA1(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_RESULT_1_0_DATA1_SHIFT)) & ADC_ETC_TRIGn_RESULT_1_0_DATA1_MASK)
/*! @} */

/* The count of ADC_ETC_TRIGn_RESULT_1_0 */
#define ADC_ETC_TRIGn_RESULT_1_0_COUNT           (8U)

/*! @name TRIGn_RESULT_3_2 - ETC_TRIG Result Data 3/2 Register */
/*! @{ */

#define ADC_ETC_TRIGn_RESULT_3_2_DATA2_MASK      (0xFFFU)
#define ADC_ETC_TRIGn_RESULT_3_2_DATA2_SHIFT     (0U)
#define ADC_ETC_TRIGn_RESULT_3_2_DATA2(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_RESULT_3_2_DATA2_SHIFT)) & ADC_ETC_TRIGn_RESULT_3_2_DATA2_MASK)

#define ADC_ETC_TRIGn_RESULT_3_2_DATA3_MASK      (0xFFF0000U)
#define ADC_ETC_TRIGn_RESULT_3_2_DATA3_SHIFT     (16U)
#define ADC_ETC_TRIGn_RESULT_3_2_DATA3(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_RESULT_3_2_DATA3_SHIFT)) & ADC_ETC_TRIGn_RESULT_3_2_DATA3_MASK)
/*! @} */

/* The count of ADC_ETC_TRIGn_RESULT_3_2 */
#define ADC_ETC_TRIGn_RESULT_3_2_COUNT           (8U)

/*! @name TRIGn_RESULT_5_4 - ETC_TRIG Result Data 5/4 Register */
/*! @{ */

#define ADC_ETC_TRIGn_RESULT_5_4_DATA4_MASK      (0xFFFU)
#define ADC_ETC_TRIGn_RESULT_5_4_DATA4_SHIFT     (0U)
#define ADC_ETC_TRIGn_RESULT_5_4_DATA4(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_RESULT_5_4_DATA4_SHIFT)) & ADC_ETC_TRIGn_RESULT_5_4_DATA4_MASK)

#define ADC_ETC_TRIGn_RESULT_5_4_DATA5_MASK      (0xFFF0000U)
#define ADC_ETC_TRIGn_RESULT_5_4_DATA5_SHIFT     (16U)
#define ADC_ETC_TRIGn_RESULT_5_4_DATA5(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_RESULT_5_4_DATA5_SHIFT)) & ADC_ETC_TRIGn_RESULT_5_4_DATA5_MASK)
/*! @} */

/* The count of ADC_ETC_TRIGn_RESULT_5_4 */
#define ADC_ETC_TRIGn_RESULT_5_4_COUNT           (8U)

/*! @name TRIGn_RESULT_7_6 - ETC_TRIG Result Data 7/6 Register */
/*! @{ */

#define ADC_ETC_TRIGn_RESULT_7_6_DATA6_MASK      (0xFFFU)
#define ADC_ETC_TRIGn_RESULT_7_6_DATA6_SHIFT     (0U)
#define ADC_ETC_TRIGn_RESULT_7_6_DATA6(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_RESULT_7_6_DATA6_SHIFT)) & ADC_ETC_TRIGn_RESULT_7_6_DATA6_MASK)

#define ADC_ETC_TRIGn_RESULT_7_6_DATA7_MASK      (0xFFF0000U)
#define ADC_ETC_TRIGn_RESULT_7_6_DATA7_SHIFT     (16U)
#define ADC_ETC_TRIGn_RESULT_7_6_DATA7(x)        (((uint32_t)(((uint32_t)(x)) << ADC_ETC_TRIGn_RESULT_7_6_DATA7_SHIFT)) & ADC_ETC_TRIGn_RESULT_7_6_DATA7_MASK)
/*! @} */

/* The count of ADC_ETC_TRIGn_RESULT_7_6 */
#define ADC_ETC_TRIGn_RESULT_7_6_COUNT           (8U)


/*!
 * @}
 */ /* end of group ADC_ETC_Register_Masks */


/* ADC_ETC - Peripheral instance base addresses */
/** Peripheral ADC_ETC base address */
#define ADC_ETC_BASE                             (0x40048000u)
/** Peripheral ADC_ETC base pointer */
#define ADC_ETC                                  ((ADC_ETC_Type *)ADC_ETC_BASE)
/** Array initializer of ADC_ETC peripheral base addresses */
#define ADC_ETC_BASE_ADDRS                       { ADC_ETC_BASE }
/** Array initializer of ADC_ETC peripheral base pointers */
#define ADC_ETC_BASE_PTRS                        { ADC_ETC }
/** Interrupt vectors for the ADC_ETC peripheral type */
#define ADC_ETC_IRQS                             { { ADC_ETC_IRQ0_IRQn, ADC_ETC_IRQ1_IRQn, ADC_ETC_IRQ2_IRQn, ADC_ETC_IRQ3_IRQn } }
#define ADC_ETC_FAULT_IRQS                       { ADC_ETC_ERROR_IRQ_IRQn }

/*!
 * @}
 */ /* end of group ADC_ETC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ANADIG_LDO_SNVS Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_LDO_SNVS_Peripheral_Access_Layer ANADIG_LDO_SNVS Peripheral Access Layer
 * @{
 */

/** ANADIG_LDO_SNVS - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[1296];
  __IO uint32_t PMU_LDO_LPSR_ANA;                  /**< PMU_LDO_LPSR_ANA_REGISTER, offset: 0x510 */
       uint8_t RESERVED_1[12];
  __IO uint32_t PMU_LDO_LPSR_DIG_2;                /**< PMU_LDO_LPSR_DIG_2_REGISTER, offset: 0x520 */
       uint8_t RESERVED_2[12];
  __IO uint32_t PMU_LDO_LPSR_DIG;                  /**< PMU_LDO_LPSR_DIG_REGISTER, offset: 0x530 */
} ANADIG_LDO_SNVS_Type;

/* ----------------------------------------------------------------------------
   -- ANADIG_LDO_SNVS Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_LDO_SNVS_Register_Masks ANADIG_LDO_SNVS Register Masks
 * @{
 */

/*! @name PMU_LDO_LPSR_ANA - PMU_LDO_LPSR_ANA_REGISTER */
/*! @{ */

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_REG_LP_EN_MASK (0x1U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_REG_LP_EN_SHIFT (0U)
/*! REG_LP_EN - reg_lp_en
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_REG_LP_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_REG_LP_EN_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_REG_LP_EN_MASK)

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_REG_DISABLE_MASK (0x4U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_REG_DISABLE_SHIFT (2U)
/*! REG_DISABLE - reg_disable
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_REG_DISABLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_REG_DISABLE_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_REG_DISABLE_MASK)

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_PULL_DOWN_2MA_EN_MASK (0x8U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_PULL_DOWN_2MA_EN_SHIFT (3U)
/*! PULL_DOWN_2MA_EN - pull_down_2ma_en
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_PULL_DOWN_2MA_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_PULL_DOWN_2MA_EN_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_PULL_DOWN_2MA_EN_MASK)

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_LPSR_ANA_CONTROL_MODE_MASK (0x10U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_LPSR_ANA_CONTROL_MODE_SHIFT (4U)
/*! LPSR_ANA_CONTROL_MODE - LPSR_ANA_CONTROL_MODE
 *  0b0..SW Control
 *  0b1..HW Control
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_LPSR_ANA_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_LPSR_ANA_CONTROL_MODE_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_LPSR_ANA_CONTROL_MODE_MASK)

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_BYPASS_MODE_EN_MASK (0x20U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_BYPASS_MODE_EN_SHIFT (5U)
/*! BYPASS_MODE_EN - bypass_mode_en
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_BYPASS_MODE_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_BYPASS_MODE_EN_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_BYPASS_MODE_EN_MASK)

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_STANDBY_EN_MASK (0x40U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_STANDBY_EN_SHIFT (6U)
/*! STANDBY_EN - standby_en
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_STANDBY_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_STANDBY_EN_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_STANDBY_EN_MASK)

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_ALWAYS_4MA_PULLDOWN_EN_MASK (0x100U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_ALWAYS_4MA_PULLDOWN_EN_SHIFT (8U)
/*! ALWAYS_4MA_PULLDOWN_EN - always_4ma_pulldown_en
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_ALWAYS_4MA_PULLDOWN_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_ALWAYS_4MA_PULLDOWN_EN_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_ALWAYS_4MA_PULLDOWN_EN_MASK)

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_TRACK_MODE_EN_MASK (0x80000U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_TRACK_MODE_EN_SHIFT (19U)
/*! TRACK_MODE_EN - Track Mode Enable
 *  0b0..Normal use
 *  0b1..Switch preparation
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_TRACK_MODE_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_TRACK_MODE_EN_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_TRACK_MODE_EN_MASK)

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_PULL_DOWN_20UA_EN_MASK (0x100000U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_PULL_DOWN_20UA_EN_SHIFT (20U)
/*! PULL_DOWN_20UA_EN - pull_down_20ua_en
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_PULL_DOWN_20UA_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_PULL_DOWN_20UA_EN_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_ANA_PULL_DOWN_20UA_EN_MASK)
/*! @} */

/*! @name PMU_LDO_LPSR_DIG_2 - PMU_LDO_LPSR_DIG_2_REGISTER */
/*! @{ */

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_2_VOLTAGE_STEP_INC_MASK (0x3U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_2_VOLTAGE_STEP_INC_SHIFT (0U)
/*! VOLTAGE_STEP_INC - voltage_step_inc
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_2_VOLTAGE_STEP_INC(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_2_VOLTAGE_STEP_INC_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_2_VOLTAGE_STEP_INC_MASK)
/*! @} */

/*! @name PMU_LDO_LPSR_DIG - PMU_LDO_LPSR_DIG_REGISTER */
/*! @{ */

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_REG_EN_MASK (0x4U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_REG_EN_SHIFT (2U)
/*! REG_EN - ENABLE_ILIMIT
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_REG_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_REG_EN_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_REG_EN_MASK)

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_LPSR_DIG_CONTROL_MODE_MASK (0x20U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_LPSR_DIG_CONTROL_MODE_SHIFT (5U)
/*! LPSR_DIG_CONTROL_MODE - LPSR_DIG_CONTROL_MODE
 *  0b0..SW Control
 *  0b1..HW Control
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_LPSR_DIG_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_LPSR_DIG_CONTROL_MODE_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_LPSR_DIG_CONTROL_MODE_MASK)

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_STANDBY_EN_MASK (0x40U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_STANDBY_EN_SHIFT (6U)
/*! STANDBY_EN - standby_en
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_STANDBY_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_STANDBY_EN_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_STANDBY_EN_MASK)

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_TRACKING_MODE_MASK (0x20000U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_TRACKING_MODE_SHIFT (17U)
/*! TRACKING_MODE - tracking_mode
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_TRACKING_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_TRACKING_MODE_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_TRACKING_MODE_MASK)

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_BYPASS_MODE_MASK (0x40000U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_BYPASS_MODE_SHIFT (18U)
/*! BYPASS_MODE - bypass_mode
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_BYPASS_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_BYPASS_MODE_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_BYPASS_MODE_MASK)

#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_VOLTAGE_SELECT_MASK (0x1F00000U)
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_VOLTAGE_SELECT_SHIFT (20U)
/*! VOLTAGE_SELECT - VOLTAGE_SELECT
 *  0b00000..Stable Voltage (range)
 *  0b00001..Stable Voltage (range)
 *  0b00010..Stable Voltage (range)
 *  0b00011..Stable Voltage (range)
 *  0b00100..Stable Voltage (range)
 *  0b00101..Stable Voltage (range)
 *  0b00110..Stable Voltage (range)
 *  0b00111..Stable Voltage (range)
 *  0b01000..Stable Voltage (range)
 *  0b01001..Stable Voltage (range)
 *  0b01010..Stable Voltage (range)
 *  0b01011..Stable Voltage (range)
 *  0b01100..Stable Voltage (range)
 *  0b01101..Stable Voltage (range)
 *  0b01110..Stable Voltage (range)
 *  0b01111..Stable Voltage (range)
 *  0b10000..Stable Voltage (range)
 *  0b10001..Stable Voltage (range)
 *  0b10010..Stable Voltage (range)
 *  0b10011..Stable Voltage (range)
 *  0b10100..Stable Voltage (range)
 *  0b10101..Stable Voltage (range)
 *  0b10110..Stable Voltage (range)
 *  0b10111..Stable Voltage (range)
 *  0b11000..Stable Voltage (range)
 *  0b11001..Stable Voltage (range)
 *  0b11010..Stable Voltage (range)
 *  0b11011..Stable Voltage (range)
 *  0b11100..Stable Voltage (range)
 *  0b11101..Stable Voltage (range)
 *  0b11110..Stable Voltage (range)
 *  0b11111..Stable Voltage (range)
 */
#define ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_VOLTAGE_SELECT(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_VOLTAGE_SELECT_SHIFT)) & ANADIG_LDO_SNVS_PMU_LDO_LPSR_DIG_VOLTAGE_SELECT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ANADIG_LDO_SNVS_Register_Masks */


/* ANADIG_LDO_SNVS - Peripheral instance base addresses */
/** Peripheral ANADIG_LDO_SNVS base address */
#define ANADIG_LDO_SNVS_BASE                     (0x40C84000u)
/** Peripheral ANADIG_LDO_SNVS base pointer */
#define ANADIG_LDO_SNVS                          ((ANADIG_LDO_SNVS_Type *)ANADIG_LDO_SNVS_BASE)
/** Array initializer of ANADIG_LDO_SNVS peripheral base addresses */
#define ANADIG_LDO_SNVS_BASE_ADDRS               { ANADIG_LDO_SNVS_BASE }
/** Array initializer of ANADIG_LDO_SNVS peripheral base pointers */
#define ANADIG_LDO_SNVS_BASE_PTRS                { ANADIG_LDO_SNVS }

/*!
 * @}
 */ /* end of group ANADIG_LDO_SNVS_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ANADIG_LDO_SNVS_DIG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_LDO_SNVS_DIG_Peripheral_Access_Layer ANADIG_LDO_SNVS_DIG Peripheral Access Layer
 * @{
 */

/** ANADIG_LDO_SNVS_DIG - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[1344];
  __IO uint32_t PMU_LDO_SNVS_DIG;                  /**< PMU_LDO_SNVS_DIG_REGISTER, offset: 0x540 */
} ANADIG_LDO_SNVS_DIG_Type;

/* ----------------------------------------------------------------------------
   -- ANADIG_LDO_SNVS_DIG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_LDO_SNVS_DIG_Register_Masks ANADIG_LDO_SNVS_DIG Register Masks
 * @{
 */

/*! @name PMU_LDO_SNVS_DIG - PMU_LDO_SNVS_DIG_REGISTER */
/*! @{ */

#define ANADIG_LDO_SNVS_DIG_PMU_LDO_SNVS_DIG_REG_LP_EN_MASK (0x1U)
#define ANADIG_LDO_SNVS_DIG_PMU_LDO_SNVS_DIG_REG_LP_EN_SHIFT (0U)
/*! REG_LP_EN - REG_LP_EN
 */
#define ANADIG_LDO_SNVS_DIG_PMU_LDO_SNVS_DIG_REG_LP_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_DIG_PMU_LDO_SNVS_DIG_REG_LP_EN_SHIFT)) & ANADIG_LDO_SNVS_DIG_PMU_LDO_SNVS_DIG_REG_LP_EN_MASK)

#define ANADIG_LDO_SNVS_DIG_PMU_LDO_SNVS_DIG_TEST_OVERRIDE_MASK (0x2U)
#define ANADIG_LDO_SNVS_DIG_PMU_LDO_SNVS_DIG_TEST_OVERRIDE_SHIFT (1U)
/*! TEST_OVERRIDE - test_override
 */
#define ANADIG_LDO_SNVS_DIG_PMU_LDO_SNVS_DIG_TEST_OVERRIDE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_DIG_PMU_LDO_SNVS_DIG_TEST_OVERRIDE_SHIFT)) & ANADIG_LDO_SNVS_DIG_PMU_LDO_SNVS_DIG_TEST_OVERRIDE_MASK)

#define ANADIG_LDO_SNVS_DIG_PMU_LDO_SNVS_DIG_REG_EN_MASK (0x4U)
#define ANADIG_LDO_SNVS_DIG_PMU_LDO_SNVS_DIG_REG_EN_SHIFT (2U)
/*! REG_EN - REG_EN
 */
#define ANADIG_LDO_SNVS_DIG_PMU_LDO_SNVS_DIG_REG_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_LDO_SNVS_DIG_PMU_LDO_SNVS_DIG_REG_EN_SHIFT)) & ANADIG_LDO_SNVS_DIG_PMU_LDO_SNVS_DIG_REG_EN_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ANADIG_LDO_SNVS_DIG_Register_Masks */


/* ANADIG_LDO_SNVS_DIG - Peripheral instance base addresses */
/** Peripheral ANADIG_LDO_SNVS_DIG base address */
#define ANADIG_LDO_SNVS_DIG_BASE                 (0x40C84000u)
/** Peripheral ANADIG_LDO_SNVS_DIG base pointer */
#define ANADIG_LDO_SNVS_DIG                      ((ANADIG_LDO_SNVS_DIG_Type *)ANADIG_LDO_SNVS_DIG_BASE)
/** Array initializer of ANADIG_LDO_SNVS_DIG peripheral base addresses */
#define ANADIG_LDO_SNVS_DIG_BASE_ADDRS           { ANADIG_LDO_SNVS_DIG_BASE }
/** Array initializer of ANADIG_LDO_SNVS_DIG peripheral base pointers */
#define ANADIG_LDO_SNVS_DIG_BASE_PTRS            { ANADIG_LDO_SNVS_DIG }

/*!
 * @}
 */ /* end of group ANADIG_LDO_SNVS_DIG_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ANADIG_MISC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_MISC_Peripheral_Access_Layer ANADIG_MISC Peripheral Access Layer
 * @{
 */

/** ANADIG_MISC - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[2048];
  __I  uint32_t MISC_DIFPROG;                      /**< Chip Silicon Version Register, offset: 0x800 */
       uint8_t RESERVED_1[28];
  __IO uint32_t VDDSOC_AI_CTRL;                    /**< VDDSOC_AI_CTRL_REGISTER, offset: 0x820 */
       uint8_t RESERVED_2[12];
  __IO uint32_t VDDSOC_AI_WDATA;                   /**< VDDSOC_AI_WDATA_REGISTER, offset: 0x830 */
       uint8_t RESERVED_3[12];
  __I  uint32_t VDDSOC_AI_RDATA;                   /**< VDDSOC_AI_RDATA_REGISTER, offset: 0x840 */
       uint8_t RESERVED_4[12];
  __IO uint32_t VDDSOC2PLL_AI_CTRL_1G;             /**< VDDSOC2PLL_AI_CTRL_1G_REGISTER, offset: 0x850 */
       uint8_t RESERVED_5[12];
  __IO uint32_t VDDSOC2PLL_AI_WDATA_1G;            /**< VDDSOC2PLL_AI_WDATA_1G_REGISTER, offset: 0x860 */
       uint8_t RESERVED_6[12];
  __I  uint32_t VDDSOC2PLL_AI_RDATA_1G;            /**< VDDSOC2PLL_AI_RDATA_1G_REGISTER, offset: 0x870 */
       uint8_t RESERVED_7[12];
  __IO uint32_t VDDSOC2PLL_AI_CTRL_AUDIO;          /**< VDDSOC_AI_CTRL_AUDIO_REGISTER, offset: 0x880 */
       uint8_t RESERVED_8[12];
  __IO uint32_t VDDSOC2PLL_AI_WDATA_AUDIO;         /**< VDDSOC_AI_WDATA_AUDIO_REGISTER, offset: 0x890 */
       uint8_t RESERVED_9[12];
  __I  uint32_t VDDSOC2PLL_AI_RDATA_AUDIO;         /**< VDDSOC2PLL_AI_RDATA_REGISTER, offset: 0x8A0 */
       uint8_t RESERVED_10[12];
  __IO uint32_t VDDSOC2PLL_AI_CTRL_VIDEO;          /**< VDDSOC2PLL_AI_CTRL_VIDEO_REGISTER, offset: 0x8B0 */
       uint8_t RESERVED_11[12];
  __IO uint32_t VDDSOC2PLL_AI_WDATA_VIDEO;         /**< VDDSOC2PLL_AI_WDATA_VIDEO_REGISTER, offset: 0x8C0 */
       uint8_t RESERVED_12[12];
  __I  uint32_t VDDSOC2PLL_AI_RDATA_VIDEO;         /**< VDDSOC2PLL_AI_RDATA_VIDEO_REGISTER, offset: 0x8D0 */
       uint8_t RESERVED_13[12];
  __IO uint32_t VDDLPSR_AI_CTRL;                   /**< VDDSOC_AI_CTRL_REGISTER, offset: 0x8E0 */
       uint8_t RESERVED_14[12];
  __IO uint32_t VDDLPSR_AI_WDATA;                  /**< VDDLPSR_AI_WDATA_REGISTER, offset: 0x8F0 */
       uint8_t RESERVED_15[12];
  __I  uint32_t VDDLPSR_AI_RDATA_REFTOP;           /**< VDDLPSR_AI_RDATA_REFTOP_REGISTER, offset: 0x900 */
       uint8_t RESERVED_16[12];
  __I  uint32_t VDDLPSR_AI_RDATA_TMPSNS;           /**< VDDLPSR_AI_RDATA_TMPSNS_REGISTER, offset: 0x910 */
       uint8_t RESERVED_17[12];
  __IO uint32_t VDDLPSR_AI400M_CTRL;               /**< VDDLPSR_AI400M_CTRL_REGISTER, offset: 0x920 */
       uint8_t RESERVED_18[12];
  __IO uint32_t VDDLPSR_AI400M_WDATA;              /**< VDDLPSR_AI400M_WDATA_REGISTER, offset: 0x930 */
       uint8_t RESERVED_19[12];
  __I  uint32_t VDDLPSR_AI400M_RDATA;              /**< VDDLPSR_AI400M_RDATA_REGISTER, offset: 0x940 */
} ANADIG_MISC_Type;

/* ----------------------------------------------------------------------------
   -- ANADIG_MISC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_MISC_Register_Masks ANADIG_MISC Register Masks
 * @{
 */

/*! @name MISC_DIFPROG - Chip Silicon Version Register */
/*! @{ */

#define ANADIG_MISC_MISC_DIFPROG_CHIPID_MASK     (0xFFFFFFFFU)
#define ANADIG_MISC_MISC_DIFPROG_CHIPID_SHIFT    (0U)
/*! CHIPID - Chip ID
 */
#define ANADIG_MISC_MISC_DIFPROG_CHIPID(x)       (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_MISC_DIFPROG_CHIPID_SHIFT)) & ANADIG_MISC_MISC_DIFPROG_CHIPID_MASK)
/*! @} */

/*! @name VDDSOC_AI_CTRL - VDDSOC_AI_CTRL_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDSOC_AI_CTRL_VDDSOC_AI_ADDR_MASK (0xFFU)
#define ANADIG_MISC_VDDSOC_AI_CTRL_VDDSOC_AI_ADDR_SHIFT (0U)
/*! VDDSOC_AI_ADDR - VDDSOC_AI_ADDR
 */
#define ANADIG_MISC_VDDSOC_AI_CTRL_VDDSOC_AI_ADDR(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC_AI_CTRL_VDDSOC_AI_ADDR_SHIFT)) & ANADIG_MISC_VDDSOC_AI_CTRL_VDDSOC_AI_ADDR_MASK)

#define ANADIG_MISC_VDDSOC_AI_CTRL_VDDSOC_AIRWB_MASK (0x10000U)
#define ANADIG_MISC_VDDSOC_AI_CTRL_VDDSOC_AIRWB_SHIFT (16U)
/*! VDDSOC_AIRWB - VDDSOC_AIRWB
 */
#define ANADIG_MISC_VDDSOC_AI_CTRL_VDDSOC_AIRWB(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC_AI_CTRL_VDDSOC_AIRWB_SHIFT)) & ANADIG_MISC_VDDSOC_AI_CTRL_VDDSOC_AIRWB_MASK)
/*! @} */

/*! @name VDDSOC_AI_WDATA - VDDSOC_AI_WDATA_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDSOC_AI_WDATA_VDDSOC_AI_WDATA_MASK (0xFFFFFFFFU)
#define ANADIG_MISC_VDDSOC_AI_WDATA_VDDSOC_AI_WDATA_SHIFT (0U)
/*! VDDSOC_AI_WDATA - VDDSOC_AI_WDATA
 */
#define ANADIG_MISC_VDDSOC_AI_WDATA_VDDSOC_AI_WDATA(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC_AI_WDATA_VDDSOC_AI_WDATA_SHIFT)) & ANADIG_MISC_VDDSOC_AI_WDATA_VDDSOC_AI_WDATA_MASK)
/*! @} */

/*! @name VDDSOC_AI_RDATA - VDDSOC_AI_RDATA_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDSOC_AI_RDATA_VDDSOC_AI_RDATA_MASK (0xFFFFFFFFU)
#define ANADIG_MISC_VDDSOC_AI_RDATA_VDDSOC_AI_RDATA_SHIFT (0U)
/*! VDDSOC_AI_RDATA - VDDSOC_AI_RDATA
 */
#define ANADIG_MISC_VDDSOC_AI_RDATA_VDDSOC_AI_RDATA(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC_AI_RDATA_VDDSOC_AI_RDATA_SHIFT)) & ANADIG_MISC_VDDSOC_AI_RDATA_VDDSOC_AI_RDATA_MASK)
/*! @} */

/*! @name VDDSOC2PLL_AI_CTRL_1G - VDDSOC2PLL_AI_CTRL_1G_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AIADDR_1G_MASK (0xFFU)
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AIADDR_1G_SHIFT (0U)
/*! VDDSOC2PLL_AIADDR_1G - VDDSOC2PLL_AIADDR_1G
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AIADDR_1G(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AIADDR_1G_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AIADDR_1G_MASK)

#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AITOGGLE_1G_MASK (0x100U)
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AITOGGLE_1G_SHIFT (8U)
/*! VDDSOC2PLL_AITOGGLE_1G - VDDSOC2PLL_AITOGGLE_1G
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AITOGGLE_1G(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AITOGGLE_1G_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AITOGGLE_1G_MASK)

#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AITOGGLE_DONE_1G_MASK (0x200U)
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AITOGGLE_DONE_1G_SHIFT (9U)
/*! VDDSOC2PLL_AITOGGLE_DONE_1G - VDDSOC2PLL_AITOGGLE_DONE_1G
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AITOGGLE_DONE_1G(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AITOGGLE_DONE_1G_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AITOGGLE_DONE_1G_MASK)

#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AIRWB_1G_MASK (0x10000U)
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AIRWB_1G_SHIFT (16U)
/*! VDDSOC2PLL_AIRWB_1G - VDDSOC2PLL_AIRWB_1G
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AIRWB_1G(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AIRWB_1G_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_CTRL_1G_VDDSOC2PLL_AIRWB_1G_MASK)
/*! @} */

/*! @name VDDSOC2PLL_AI_WDATA_1G - VDDSOC2PLL_AI_WDATA_1G_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDSOC2PLL_AI_WDATA_1G_VDDSOC2PLL_AI_WDATA_1G_MASK (0xFFFFFFFFU)
#define ANADIG_MISC_VDDSOC2PLL_AI_WDATA_1G_VDDSOC2PLL_AI_WDATA_1G_SHIFT (0U)
/*! VDDSOC2PLL_AI_WDATA_1G - VDDSOC2PLL_AI_WDATA_1G
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_WDATA_1G_VDDSOC2PLL_AI_WDATA_1G(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_WDATA_1G_VDDSOC2PLL_AI_WDATA_1G_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_WDATA_1G_VDDSOC2PLL_AI_WDATA_1G_MASK)
/*! @} */

/*! @name VDDSOC2PLL_AI_RDATA_1G - VDDSOC2PLL_AI_RDATA_1G_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDSOC2PLL_AI_RDATA_1G_VDDSOC2PLL_AI_RDATA_1G_MASK (0xFFFFFFFFU)
#define ANADIG_MISC_VDDSOC2PLL_AI_RDATA_1G_VDDSOC2PLL_AI_RDATA_1G_SHIFT (0U)
/*! VDDSOC2PLL_AI_RDATA_1G - VDDSOC2PLL_AI_RDATA_1G
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_RDATA_1G_VDDSOC2PLL_AI_RDATA_1G(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_RDATA_1G_VDDSOC2PLL_AI_RDATA_1G_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_RDATA_1G_VDDSOC2PLL_AI_RDATA_1G_MASK)
/*! @} */

/*! @name VDDSOC2PLL_AI_CTRL_AUDIO - VDDSOC_AI_CTRL_AUDIO_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AI_ADDR_AUDIO_MASK (0xFFU)
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AI_ADDR_AUDIO_SHIFT (0U)
/*! VDDSOC2PLL_AI_ADDR_AUDIO - VDDSOC2PLL_AI_ADDR_AUDIO
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AI_ADDR_AUDIO(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AI_ADDR_AUDIO_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AI_ADDR_AUDIO_MASK)

#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AITOGGLE_AUDIO_MASK (0x100U)
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AITOGGLE_AUDIO_SHIFT (8U)
/*! VDDSOC2PLL_AITOGGLE_AUDIO - VDDSOC2PLL_AITOGGLE_AUDIO
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AITOGGLE_AUDIO(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AITOGGLE_AUDIO_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AITOGGLE_AUDIO_MASK)

#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AITOGGLE_DONE_AUDIO_MASK (0x200U)
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AITOGGLE_DONE_AUDIO_SHIFT (9U)
/*! VDDSOC2PLL_AITOGGLE_DONE_AUDIO - VDDSOC2PLL_AITOGGLE_DONE_AUDIO
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AITOGGLE_DONE_AUDIO(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AITOGGLE_DONE_AUDIO_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AITOGGLE_DONE_AUDIO_MASK)

#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AIRWB_AUDIO_MASK (0x10000U)
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AIRWB_AUDIO_SHIFT (16U)
/*! VDDSOC2PLL_AIRWB_AUDIO - VDDSOC_AIRWB
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AIRWB_AUDIO(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AIRWB_AUDIO_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_CTRL_AUDIO_VDDSOC2PLL_AIRWB_AUDIO_MASK)
/*! @} */

/*! @name VDDSOC2PLL_AI_WDATA_AUDIO - VDDSOC_AI_WDATA_AUDIO_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDSOC2PLL_AI_WDATA_AUDIO_VDDSOC2PLL_AI_WDATA_AUDIO_MASK (0xFFFFFFFFU)
#define ANADIG_MISC_VDDSOC2PLL_AI_WDATA_AUDIO_VDDSOC2PLL_AI_WDATA_AUDIO_SHIFT (0U)
/*! VDDSOC2PLL_AI_WDATA_AUDIO - VDDSOC2PLL_AI_WDATA_AUDIO
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_WDATA_AUDIO_VDDSOC2PLL_AI_WDATA_AUDIO(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_WDATA_AUDIO_VDDSOC2PLL_AI_WDATA_AUDIO_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_WDATA_AUDIO_VDDSOC2PLL_AI_WDATA_AUDIO_MASK)
/*! @} */

/*! @name VDDSOC2PLL_AI_RDATA_AUDIO - VDDSOC2PLL_AI_RDATA_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDSOC2PLL_AI_RDATA_AUDIO_VDDSOC2PLL_AI_RDATA_AUDIO_MASK (0xFFFFFFFFU)
#define ANADIG_MISC_VDDSOC2PLL_AI_RDATA_AUDIO_VDDSOC2PLL_AI_RDATA_AUDIO_SHIFT (0U)
/*! VDDSOC2PLL_AI_RDATA_AUDIO - VDDSOC2PLL_AI_RDATA_AUDIO
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_RDATA_AUDIO_VDDSOC2PLL_AI_RDATA_AUDIO(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_RDATA_AUDIO_VDDSOC2PLL_AI_RDATA_AUDIO_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_RDATA_AUDIO_VDDSOC2PLL_AI_RDATA_AUDIO_MASK)
/*! @} */

/*! @name VDDSOC2PLL_AI_CTRL_VIDEO - VDDSOC2PLL_AI_CTRL_VIDEO_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AIADDR_VIDEO_MASK (0xFFU)
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AIADDR_VIDEO_SHIFT (0U)
/*! VDDSOC2PLL_AIADDR_VIDEO - VDDSOC2PLL_AIADDR_VIDEO
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AIADDR_VIDEO(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AIADDR_VIDEO_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AIADDR_VIDEO_MASK)

#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AITOGGLE_VIDEO_MASK (0x100U)
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AITOGGLE_VIDEO_SHIFT (8U)
/*! VDDSOC2PLL_AITOGGLE_VIDEO - VDDSOC2PLL_AITOGGLE_VIDEO
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AITOGGLE_VIDEO(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AITOGGLE_VIDEO_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AITOGGLE_VIDEO_MASK)

#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AITOGGLE_DONE_VIDEO_MASK (0x200U)
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AITOGGLE_DONE_VIDEO_SHIFT (9U)
/*! VDDSOC2PLL_AITOGGLE_DONE_VIDEO - VDDSOC2PLL_AITOGGLE_DONE_VIDEO
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AITOGGLE_DONE_VIDEO(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AITOGGLE_DONE_VIDEO_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AITOGGLE_DONE_VIDEO_MASK)

#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AIRWB_VIDEO_MASK (0x10000U)
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AIRWB_VIDEO_SHIFT (16U)
/*! VDDSOC2PLL_AIRWB_VIDEO - VDDSOC2PLL_AIRWB_VIDEO
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AIRWB_VIDEO(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AIRWB_VIDEO_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_CTRL_VIDEO_VDDSOC2PLL_AIRWB_VIDEO_MASK)
/*! @} */

/*! @name VDDSOC2PLL_AI_WDATA_VIDEO - VDDSOC2PLL_AI_WDATA_VIDEO_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDSOC2PLL_AI_WDATA_VIDEO_VDDSOC2PLL_AI_WDATA_VIDEO_MASK (0xFFFFFFFFU)
#define ANADIG_MISC_VDDSOC2PLL_AI_WDATA_VIDEO_VDDSOC2PLL_AI_WDATA_VIDEO_SHIFT (0U)
/*! VDDSOC2PLL_AI_WDATA_VIDEO - VDDSOC2PLL_AI_WDATA_VIDEO
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_WDATA_VIDEO_VDDSOC2PLL_AI_WDATA_VIDEO(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_WDATA_VIDEO_VDDSOC2PLL_AI_WDATA_VIDEO_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_WDATA_VIDEO_VDDSOC2PLL_AI_WDATA_VIDEO_MASK)
/*! @} */

/*! @name VDDSOC2PLL_AI_RDATA_VIDEO - VDDSOC2PLL_AI_RDATA_VIDEO_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDSOC2PLL_AI_RDATA_VIDEO_VDDSOC2PLL_AI_RDATA_VIDEO_MASK (0xFFFFFFFFU)
#define ANADIG_MISC_VDDSOC2PLL_AI_RDATA_VIDEO_VDDSOC2PLL_AI_RDATA_VIDEO_SHIFT (0U)
/*! VDDSOC2PLL_AI_RDATA_VIDEO - VDDSOC2PLL_AI_RDATA_VIDEO
 */
#define ANADIG_MISC_VDDSOC2PLL_AI_RDATA_VIDEO_VDDSOC2PLL_AI_RDATA_VIDEO(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDSOC2PLL_AI_RDATA_VIDEO_VDDSOC2PLL_AI_RDATA_VIDEO_SHIFT)) & ANADIG_MISC_VDDSOC2PLL_AI_RDATA_VIDEO_VDDSOC2PLL_AI_RDATA_VIDEO_MASK)
/*! @} */

/*! @name VDDLPSR_AI_CTRL - VDDSOC_AI_CTRL_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDLPSR_AI_CTRL_VDDLPSR_AI_ADDR_MASK (0xFFU)
#define ANADIG_MISC_VDDLPSR_AI_CTRL_VDDLPSR_AI_ADDR_SHIFT (0U)
/*! VDDLPSR_AI_ADDR - VDDLPSR_AI_ADDR
 */
#define ANADIG_MISC_VDDLPSR_AI_CTRL_VDDLPSR_AI_ADDR(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDLPSR_AI_CTRL_VDDLPSR_AI_ADDR_SHIFT)) & ANADIG_MISC_VDDLPSR_AI_CTRL_VDDLPSR_AI_ADDR_MASK)

#define ANADIG_MISC_VDDLPSR_AI_CTRL_VDDLPSR_AIRWB_MASK (0x10000U)
#define ANADIG_MISC_VDDLPSR_AI_CTRL_VDDLPSR_AIRWB_SHIFT (16U)
/*! VDDLPSR_AIRWB - VDDLPSR_AIRWB
 */
#define ANADIG_MISC_VDDLPSR_AI_CTRL_VDDLPSR_AIRWB(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDLPSR_AI_CTRL_VDDLPSR_AIRWB_SHIFT)) & ANADIG_MISC_VDDLPSR_AI_CTRL_VDDLPSR_AIRWB_MASK)
/*! @} */

/*! @name VDDLPSR_AI_WDATA - VDDLPSR_AI_WDATA_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDLPSR_AI_WDATA_VDDLPSR_AI_WDATA_MASK (0xFFFFFFFFU)
#define ANADIG_MISC_VDDLPSR_AI_WDATA_VDDLPSR_AI_WDATA_SHIFT (0U)
/*! VDDLPSR_AI_WDATA - VDD_LPSR_AI_WDATA
 */
#define ANADIG_MISC_VDDLPSR_AI_WDATA_VDDLPSR_AI_WDATA(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDLPSR_AI_WDATA_VDDLPSR_AI_WDATA_SHIFT)) & ANADIG_MISC_VDDLPSR_AI_WDATA_VDDLPSR_AI_WDATA_MASK)
/*! @} */

/*! @name VDDLPSR_AI_RDATA_REFTOP - VDDLPSR_AI_RDATA_REFTOP_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDLPSR_AI_RDATA_REFTOP_VDDLPSR_AI_RDATA_REFTOP_MASK (0xFFFFFFFFU)
#define ANADIG_MISC_VDDLPSR_AI_RDATA_REFTOP_VDDLPSR_AI_RDATA_REFTOP_SHIFT (0U)
/*! VDDLPSR_AI_RDATA_REFTOP - VDDLPSR_AI_RDATA_REFTOP
 */
#define ANADIG_MISC_VDDLPSR_AI_RDATA_REFTOP_VDDLPSR_AI_RDATA_REFTOP(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDLPSR_AI_RDATA_REFTOP_VDDLPSR_AI_RDATA_REFTOP_SHIFT)) & ANADIG_MISC_VDDLPSR_AI_RDATA_REFTOP_VDDLPSR_AI_RDATA_REFTOP_MASK)
/*! @} */

/*! @name VDDLPSR_AI_RDATA_TMPSNS - VDDLPSR_AI_RDATA_TMPSNS_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDLPSR_AI_RDATA_TMPSNS_VDDLPSR_AI_RDATA_TMPSNS_MASK (0xFFFFFFFFU)
#define ANADIG_MISC_VDDLPSR_AI_RDATA_TMPSNS_VDDLPSR_AI_RDATA_TMPSNS_SHIFT (0U)
/*! VDDLPSR_AI_RDATA_TMPSNS - VDDLPSR_AI_RDATA_TMPSNS
 */
#define ANADIG_MISC_VDDLPSR_AI_RDATA_TMPSNS_VDDLPSR_AI_RDATA_TMPSNS(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDLPSR_AI_RDATA_TMPSNS_VDDLPSR_AI_RDATA_TMPSNS_SHIFT)) & ANADIG_MISC_VDDLPSR_AI_RDATA_TMPSNS_VDDLPSR_AI_RDATA_TMPSNS_MASK)
/*! @} */

/*! @name VDDLPSR_AI400M_CTRL - VDDLPSR_AI400M_CTRL_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AI400M_ADDR_MASK (0xFFU)
#define ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AI400M_ADDR_SHIFT (0U)
/*! VDDLPSR_AI400M_ADDR - VDDLPSR_AI400M_ADDR
 */
#define ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AI400M_ADDR(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AI400M_ADDR_SHIFT)) & ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AI400M_ADDR_MASK)

#define ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AITOGGLE_400M_MASK (0x100U)
#define ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AITOGGLE_400M_SHIFT (8U)
/*! VDDLPSR_AITOGGLE_400M - VDDLPSR_AITOGGLE_400M
 */
#define ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AITOGGLE_400M(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AITOGGLE_400M_SHIFT)) & ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AITOGGLE_400M_MASK)

#define ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AITOGGLE_DONE_400M_MASK (0x200U)
#define ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AITOGGLE_DONE_400M_SHIFT (9U)
/*! VDDLPSR_AITOGGLE_DONE_400M - VDDLPSR_AITOGGLE_DONE_400M
 */
#define ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AITOGGLE_DONE_400M(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AITOGGLE_DONE_400M_SHIFT)) & ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AITOGGLE_DONE_400M_MASK)

#define ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AI400M_RWB_MASK (0x10000U)
#define ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AI400M_RWB_SHIFT (16U)
/*! VDDLPSR_AI400M_RWB - VDDLPSR_AI400M_RWB
 */
#define ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AI400M_RWB(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AI400M_RWB_SHIFT)) & ANADIG_MISC_VDDLPSR_AI400M_CTRL_VDDLPSR_AI400M_RWB_MASK)
/*! @} */

/*! @name VDDLPSR_AI400M_WDATA - VDDLPSR_AI400M_WDATA_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDLPSR_AI400M_WDATA_VDDLPSR_AI400M_WDATA_MASK (0xFFFFFFFFU)
#define ANADIG_MISC_VDDLPSR_AI400M_WDATA_VDDLPSR_AI400M_WDATA_SHIFT (0U)
/*! VDDLPSR_AI400M_WDATA - VDDLPSR_AI400M_WDATA
 */
#define ANADIG_MISC_VDDLPSR_AI400M_WDATA_VDDLPSR_AI400M_WDATA(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDLPSR_AI400M_WDATA_VDDLPSR_AI400M_WDATA_SHIFT)) & ANADIG_MISC_VDDLPSR_AI400M_WDATA_VDDLPSR_AI400M_WDATA_MASK)
/*! @} */

/*! @name VDDLPSR_AI400M_RDATA - VDDLPSR_AI400M_RDATA_REGISTER */
/*! @{ */

#define ANADIG_MISC_VDDLPSR_AI400M_RDATA_VDDLPSR_AI400M_RDATA_MASK (0xFFFFFFFFU)
#define ANADIG_MISC_VDDLPSR_AI400M_RDATA_VDDLPSR_AI400M_RDATA_SHIFT (0U)
/*! VDDLPSR_AI400M_RDATA - VDDLPSR_AI400M_RDATA
 */
#define ANADIG_MISC_VDDLPSR_AI400M_RDATA_VDDLPSR_AI400M_RDATA(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_MISC_VDDLPSR_AI400M_RDATA_VDDLPSR_AI400M_RDATA_SHIFT)) & ANADIG_MISC_VDDLPSR_AI400M_RDATA_VDDLPSR_AI400M_RDATA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ANADIG_MISC_Register_Masks */


/* ANADIG_MISC - Peripheral instance base addresses */
/** Peripheral ANADIG_MISC base address */
#define ANADIG_MISC_BASE                         (0x40C84000u)
/** Peripheral ANADIG_MISC base pointer */
#define ANADIG_MISC                              ((ANADIG_MISC_Type *)ANADIG_MISC_BASE)
/** Array initializer of ANADIG_MISC peripheral base addresses */
#define ANADIG_MISC_BASE_ADDRS                   { ANADIG_MISC_BASE }
/** Array initializer of ANADIG_MISC peripheral base pointers */
#define ANADIG_MISC_BASE_PTRS                    { ANADIG_MISC }

/*!
 * @}
 */ /* end of group ANADIG_MISC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ANADIG_OSC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_OSC_Peripheral_Access_Layer ANADIG_OSC Peripheral Access Layer
 * @{
 */

/** ANADIG_OSC - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  __IO uint32_t OSC_48M_CTRL;                      /**< 48MHz RCOSC Control Register, offset: 0x10 */
       uint8_t RESERVED_1[12];
  __IO uint32_t OSC_24M_CTRL;                      /**< 24MHz OSC Control Register, offset: 0x20 */
       uint8_t RESERVED_2[28];
  __I  uint32_t OSC_400M_CTRL0;                    /**< 400MHz RCOSC Control0 Register, offset: 0x40 */
       uint8_t RESERVED_3[12];
  __IO uint32_t OSC_400M_CTRL1;                    /**< 400MHz RCOSC Control1 Register, offset: 0x50 */
       uint8_t RESERVED_4[12];
  __IO uint32_t OSC_400M_CTRL2;                    /**< 400MHz RCOSC Control2 Register, offset: 0x60 */
       uint8_t RESERVED_5[92];
  __IO uint32_t OSC_16M_CTRL;                      /**< 16MHz RCOSC Control Register, offset: 0xC0 */
} ANADIG_OSC_Type;

/* ----------------------------------------------------------------------------
   -- ANADIG_OSC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_OSC_Register_Masks ANADIG_OSC Register Masks
 * @{
 */

/*! @name OSC_48M_CTRL - 48MHz RCOSC Control Register */
/*! @{ */

#define ANADIG_OSC_OSC_48M_CTRL_TEN_MASK         (0x2U)
#define ANADIG_OSC_OSC_48M_CTRL_TEN_SHIFT        (1U)
/*! TEN - 48MHz RCOSC Enable
 *  0b0..Power down
 *  0b1..Power up
 */
#define ANADIG_OSC_OSC_48M_CTRL_TEN(x)           (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_48M_CTRL_TEN_SHIFT)) & ANADIG_OSC_OSC_48M_CTRL_TEN_MASK)

#define ANADIG_OSC_OSC_48M_CTRL_RC_48M_DIV2_EN_MASK (0x1000000U)
#define ANADIG_OSC_OSC_48M_CTRL_RC_48M_DIV2_EN_SHIFT (24U)
/*! RC_48M_DIV2_EN - RCOSC_48M_DIV2 Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ANADIG_OSC_OSC_48M_CTRL_RC_48M_DIV2_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_48M_CTRL_RC_48M_DIV2_EN_SHIFT)) & ANADIG_OSC_OSC_48M_CTRL_RC_48M_DIV2_EN_MASK)

#define ANADIG_OSC_OSC_48M_CTRL_RC_48M_DIV2_CONTROL_MODE_MASK (0x40000000U)
#define ANADIG_OSC_OSC_48M_CTRL_RC_48M_DIV2_CONTROL_MODE_SHIFT (30U)
/*! RC_48M_DIV2_CONTROL_MODE - RCOSC_48M_DIV2 Control Mode
 *  0b0..Software mode (default)
 *  0b1..GPC mode (Setpoint)
 */
#define ANADIG_OSC_OSC_48M_CTRL_RC_48M_DIV2_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_48M_CTRL_RC_48M_DIV2_CONTROL_MODE_SHIFT)) & ANADIG_OSC_OSC_48M_CTRL_RC_48M_DIV2_CONTROL_MODE_MASK)

#define ANADIG_OSC_OSC_48M_CTRL_RC_48M_CONTROL_MODE_MASK (0x80000000U)
#define ANADIG_OSC_OSC_48M_CTRL_RC_48M_CONTROL_MODE_SHIFT (31U)
/*! RC_48M_CONTROL_MODE - 48MHz RCOSC Control Mode
 *  0b0..Software mode (default)
 *  0b1..GPC mode (Setpoint)
 */
#define ANADIG_OSC_OSC_48M_CTRL_RC_48M_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_48M_CTRL_RC_48M_CONTROL_MODE_SHIFT)) & ANADIG_OSC_OSC_48M_CTRL_RC_48M_CONTROL_MODE_MASK)
/*! @} */

/*! @name OSC_24M_CTRL - 24MHz OSC Control Register */
/*! @{ */

#define ANADIG_OSC_OSC_24M_CTRL_BYPASS_CLK_MASK  (0x1U)
#define ANADIG_OSC_OSC_24M_CTRL_BYPASS_CLK_SHIFT (0U)
/*! BYPASS_CLK - 24MHz OSC Bypass Clock
 */
#define ANADIG_OSC_OSC_24M_CTRL_BYPASS_CLK(x)    (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_24M_CTRL_BYPASS_CLK_SHIFT)) & ANADIG_OSC_OSC_24M_CTRL_BYPASS_CLK_MASK)

#define ANADIG_OSC_OSC_24M_CTRL_BYPASS_EN_MASK   (0x2U)
#define ANADIG_OSC_OSC_24M_CTRL_BYPASS_EN_SHIFT  (1U)
/*! BYPASS_EN - 24MHz OSC Bypass Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ANADIG_OSC_OSC_24M_CTRL_BYPASS_EN(x)     (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_24M_CTRL_BYPASS_EN_SHIFT)) & ANADIG_OSC_OSC_24M_CTRL_BYPASS_EN_MASK)

#define ANADIG_OSC_OSC_24M_CTRL_LP_EN_MASK       (0x4U)
#define ANADIG_OSC_OSC_24M_CTRL_LP_EN_SHIFT      (2U)
/*! LP_EN - 24MHz OSC Low-Power Mode Enable
 *  0b0..High Gain mode (HP)
 *  0b1..Low-power mode (LP)
 */
#define ANADIG_OSC_OSC_24M_CTRL_LP_EN(x)         (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_24M_CTRL_LP_EN_SHIFT)) & ANADIG_OSC_OSC_24M_CTRL_LP_EN_MASK)

#define ANADIG_OSC_OSC_24M_CTRL_OSC_COMP_MODE_MASK (0x8U)
#define ANADIG_OSC_OSC_24M_CTRL_OSC_COMP_MODE_SHIFT (3U)
/*! OSC_COMP_MODE - 24MHz OSC Comparator Mode
 *  0b0..Single-ended mode (default)
 *  0b1..Differential mode (test mode)
 */
#define ANADIG_OSC_OSC_24M_CTRL_OSC_COMP_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_24M_CTRL_OSC_COMP_MODE_SHIFT)) & ANADIG_OSC_OSC_24M_CTRL_OSC_COMP_MODE_MASK)

#define ANADIG_OSC_OSC_24M_CTRL_OSC_EN_MASK      (0x10U)
#define ANADIG_OSC_OSC_24M_CTRL_OSC_EN_SHIFT     (4U)
/*! OSC_EN - 24MHz OSC Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ANADIG_OSC_OSC_24M_CTRL_OSC_EN(x)        (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_24M_CTRL_OSC_EN_SHIFT)) & ANADIG_OSC_OSC_24M_CTRL_OSC_EN_MASK)

#define ANADIG_OSC_OSC_24M_CTRL_OSC_24M_GATE_MASK (0x80U)
#define ANADIG_OSC_OSC_24M_CTRL_OSC_24M_GATE_SHIFT (7U)
/*! OSC_24M_GATE - 24MHz OSC Gate Control
 *  0b0..Not Gated
 *  0b1..Gated
 */
#define ANADIG_OSC_OSC_24M_CTRL_OSC_24M_GATE(x)  (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_24M_CTRL_OSC_24M_GATE_SHIFT)) & ANADIG_OSC_OSC_24M_CTRL_OSC_24M_GATE_MASK)

#define ANADIG_OSC_OSC_24M_CTRL_OSC_24M_STABLE_MASK (0x40000000U)
#define ANADIG_OSC_OSC_24M_CTRL_OSC_24M_STABLE_SHIFT (30U)
/*! OSC_24M_STABLE - 24MHz OSC Stable
 *  0b0..Not Stable
 *  0b1..Stable
 */
#define ANADIG_OSC_OSC_24M_CTRL_OSC_24M_STABLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_24M_CTRL_OSC_24M_STABLE_SHIFT)) & ANADIG_OSC_OSC_24M_CTRL_OSC_24M_STABLE_MASK)

#define ANADIG_OSC_OSC_24M_CTRL_OSC_24M_CONTROL_MODE_MASK (0x80000000U)
#define ANADIG_OSC_OSC_24M_CTRL_OSC_24M_CONTROL_MODE_SHIFT (31U)
/*! OSC_24M_CONTROL_MODE - 24MHz OSC Control Mode
 *  0b0..Software mode (default)
 *  0b1..GPC mode (Setpoint)
 */
#define ANADIG_OSC_OSC_24M_CTRL_OSC_24M_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_24M_CTRL_OSC_24M_CONTROL_MODE_SHIFT)) & ANADIG_OSC_OSC_24M_CTRL_OSC_24M_CONTROL_MODE_MASK)
/*! @} */

/*! @name OSC_400M_CTRL0 - 400MHz RCOSC Control0 Register */
/*! @{ */

#define ANADIG_OSC_OSC_400M_CTRL0_OSC400M_AI_BUSY_MASK (0x80000000U)
#define ANADIG_OSC_OSC_400M_CTRL0_OSC400M_AI_BUSY_SHIFT (31U)
/*! OSC400M_AI_BUSY - 400MHz OSC AI BUSY
 */
#define ANADIG_OSC_OSC_400M_CTRL0_OSC400M_AI_BUSY(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_400M_CTRL0_OSC400M_AI_BUSY_SHIFT)) & ANADIG_OSC_OSC_400M_CTRL0_OSC400M_AI_BUSY_MASK)
/*! @} */

/*! @name OSC_400M_CTRL1 - 400MHz RCOSC Control1 Register */
/*! @{ */

#define ANADIG_OSC_OSC_400M_CTRL1_PWD_MASK       (0x1U)
#define ANADIG_OSC_OSC_400M_CTRL1_PWD_SHIFT      (0U)
/*! PWD - Power down control for 400MHz RCOSC
 *  0b0..No Power down
 *  0b1..Power down
 */
#define ANADIG_OSC_OSC_400M_CTRL1_PWD(x)         (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_400M_CTRL1_PWD_SHIFT)) & ANADIG_OSC_OSC_400M_CTRL1_PWD_MASK)

#define ANADIG_OSC_OSC_400M_CTRL1_CLKGATE_400MEG_MASK (0x2U)
#define ANADIG_OSC_OSC_400M_CTRL1_CLKGATE_400MEG_SHIFT (1U)
/*! CLKGATE_400MEG - Clock gate control for 400MHz RCOSC
 *  0b0..Not Gated
 *  0b1..Gated
 */
#define ANADIG_OSC_OSC_400M_CTRL1_CLKGATE_400MEG(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_400M_CTRL1_CLKGATE_400MEG_SHIFT)) & ANADIG_OSC_OSC_400M_CTRL1_CLKGATE_400MEG_MASK)

#define ANADIG_OSC_OSC_400M_CTRL1_RC_400M_CONTROL_MODE_MASK (0x80000000U)
#define ANADIG_OSC_OSC_400M_CTRL1_RC_400M_CONTROL_MODE_SHIFT (31U)
/*! RC_400M_CONTROL_MODE - 400MHz RCOSC Control mode
 *  0b0..Software mode (default)
 *  0b1..GPC mode (Setpoint)
 */
#define ANADIG_OSC_OSC_400M_CTRL1_RC_400M_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_400M_CTRL1_RC_400M_CONTROL_MODE_SHIFT)) & ANADIG_OSC_OSC_400M_CTRL1_RC_400M_CONTROL_MODE_MASK)
/*! @} */

/*! @name OSC_400M_CTRL2 - 400MHz RCOSC Control2 Register */
/*! @{ */

#define ANADIG_OSC_OSC_400M_CTRL2_ENABLE_CLK_MASK (0x1U)
#define ANADIG_OSC_OSC_400M_CTRL2_ENABLE_CLK_SHIFT (0U)
/*! ENABLE_CLK - Clock enable
 *  0b0..Clock is disabled before entering GPC mode
 *  0b1..Clock is enabled before entering GPC mode
 */
#define ANADIG_OSC_OSC_400M_CTRL2_ENABLE_CLK(x)  (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_400M_CTRL2_ENABLE_CLK_SHIFT)) & ANADIG_OSC_OSC_400M_CTRL2_ENABLE_CLK_MASK)

#define ANADIG_OSC_OSC_400M_CTRL2_TUNE_BYP_MASK  (0x400U)
#define ANADIG_OSC_OSC_400M_CTRL2_TUNE_BYP_SHIFT (10U)
/*! TUNE_BYP - Bypass tuning logic
 *  0b0..Use the output of tuning logic to run the oscillator
 *  0b1..Bypass the tuning logic and use the programmed OSC_TUNE_VAL to run the oscillator
 */
#define ANADIG_OSC_OSC_400M_CTRL2_TUNE_BYP(x)    (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_400M_CTRL2_TUNE_BYP_SHIFT)) & ANADIG_OSC_OSC_400M_CTRL2_TUNE_BYP_MASK)

#define ANADIG_OSC_OSC_400M_CTRL2_OSC_TUNE_VAL_MASK (0xFF000000U)
#define ANADIG_OSC_OSC_400M_CTRL2_OSC_TUNE_VAL_SHIFT (24U)
/*! OSC_TUNE_VAL - Oscillator Tune Value
 */
#define ANADIG_OSC_OSC_400M_CTRL2_OSC_TUNE_VAL(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_400M_CTRL2_OSC_TUNE_VAL_SHIFT)) & ANADIG_OSC_OSC_400M_CTRL2_OSC_TUNE_VAL_MASK)
/*! @} */

/*! @name OSC_16M_CTRL - 16MHz RCOSC Control Register */
/*! @{ */

#define ANADIG_OSC_OSC_16M_CTRL_EN_IRC4M16M_MASK (0x2U)
#define ANADIG_OSC_OSC_16M_CTRL_EN_IRC4M16M_SHIFT (1U)
/*! EN_IRC4M16M - Enable Clock Output
 *  0b0..Disable
 *  0b1..Enable
 */
#define ANADIG_OSC_OSC_16M_CTRL_EN_IRC4M16M(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_16M_CTRL_EN_IRC4M16M_SHIFT)) & ANADIG_OSC_OSC_16M_CTRL_EN_IRC4M16M_MASK)

#define ANADIG_OSC_OSC_16M_CTRL_EN_POWER_SAVE_MASK (0x8U)
#define ANADIG_OSC_OSC_16M_CTRL_EN_POWER_SAVE_SHIFT (3U)
/*! EN_POWER_SAVE - Power Save Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ANADIG_OSC_OSC_16M_CTRL_EN_POWER_SAVE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_16M_CTRL_EN_POWER_SAVE_SHIFT)) & ANADIG_OSC_OSC_16M_CTRL_EN_POWER_SAVE_MASK)

#define ANADIG_OSC_OSC_16M_CTRL_SOURCE_SEL_16M_MASK (0x100U)
#define ANADIG_OSC_OSC_16M_CTRL_SOURCE_SEL_16M_SHIFT (8U)
/*! SOURCE_SEL_16M - Source select
 *  0b0..16MHz Oscillator
 *  0b1..24MHz Oscillator
 */
#define ANADIG_OSC_OSC_16M_CTRL_SOURCE_SEL_16M(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_16M_CTRL_SOURCE_SEL_16M_SHIFT)) & ANADIG_OSC_OSC_16M_CTRL_SOURCE_SEL_16M_MASK)

#define ANADIG_OSC_OSC_16M_CTRL_RC_16M_CONTROL_MODE_MASK (0x80000000U)
#define ANADIG_OSC_OSC_16M_CTRL_RC_16M_CONTROL_MODE_SHIFT (31U)
/*! RC_16M_CONTROL_MODE - Control Mode for 16MHz Oscillator
 *  0b0..Software mode (default)
 *  0b1..GPC mode (Setpoint)
 */
#define ANADIG_OSC_OSC_16M_CTRL_RC_16M_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_OSC_OSC_16M_CTRL_RC_16M_CONTROL_MODE_SHIFT)) & ANADIG_OSC_OSC_16M_CTRL_RC_16M_CONTROL_MODE_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ANADIG_OSC_Register_Masks */


/* ANADIG_OSC - Peripheral instance base addresses */
/** Peripheral ANADIG_OSC base address */
#define ANADIG_OSC_BASE                          (0x40C84000u)
/** Peripheral ANADIG_OSC base pointer */
#define ANADIG_OSC                               ((ANADIG_OSC_Type *)ANADIG_OSC_BASE)
/** Array initializer of ANADIG_OSC peripheral base addresses */
#define ANADIG_OSC_BASE_ADDRS                    { ANADIG_OSC_BASE }
/** Array initializer of ANADIG_OSC peripheral base pointers */
#define ANADIG_OSC_BASE_PTRS                     { ANADIG_OSC }

/*!
 * @}
 */ /* end of group ANADIG_OSC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ANADIG_PLL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_PLL_Peripheral_Access_Layer ANADIG_PLL Peripheral Access Layer
 * @{
 */

/** ANADIG_PLL - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[512];
  __IO uint32_t ARM_PLL_CTRL;                      /**< ARM_PLL_CTRL_REGISTER, offset: 0x200 */
       uint8_t RESERVED_1[12];
  __IO uint32_t SYS_PLL3_CTRL;                     /**< SYS_PLL3_CTRL_REGISTER, offset: 0x210 */
       uint8_t RESERVED_2[12];
  __IO uint32_t SYS_PLL3_UPDATE;                   /**< SYS_PLL3_UPDATE_REGISTER, offset: 0x220 */
       uint8_t RESERVED_3[12];
  __IO uint32_t SYS_PLL3_PFD;                      /**< SYS_PLL3_PFD_REGISTER, offset: 0x230 */
       uint8_t RESERVED_4[12];
  __IO uint32_t SYS_PLL2_CTRL;                     /**< SYS_PLL2_CTRL_REGISTER, offset: 0x240 */
       uint8_t RESERVED_5[12];
  __IO uint32_t SYS_PLL2_UPDATE;                   /**< SYS_PLL2_UPDATE_REGISTER, offset: 0x250 */
       uint8_t RESERVED_6[12];
  __IO uint32_t SYS_PLL2_SS;                       /**< SYS_PLL2_SS_REGISTER, offset: 0x260 */
       uint8_t RESERVED_7[12];
  __IO uint32_t SYS_PLL2_PFD;                      /**< SYS_PLL2_PFD_REGISTER, offset: 0x270 */
       uint8_t RESERVED_8[44];
  __IO uint32_t SYS_PLL2_MFD;                      /**< SYS_PLL2_MFD_REGISTER, offset: 0x2A0 */
       uint8_t RESERVED_9[12];
  __IO uint32_t SYS_PLL1_SS;                       /**< SYS_PLL1_SS_REGISTER, offset: 0x2B0 */
       uint8_t RESERVED_10[12];
  __IO uint32_t SYS_PLL1_CTRL;                     /**< SYS_PLL1_CTRL_REGISTER, offset: 0x2C0 */
       uint8_t RESERVED_11[12];
  __IO uint32_t SYS_PLL1_DENOMINATOR;              /**< SYS_PLL1_DENOMINATOR_REGISTER, offset: 0x2D0 */
       uint8_t RESERVED_12[12];
  __IO uint32_t SYS_PLL1_NUMERATOR;                /**< SYS_PLL1_NUMERATOR_REGISTER, offset: 0x2E0 */
       uint8_t RESERVED_13[12];
  __IO uint32_t SYS_PLL1_DIV_SELECT;               /**< SYS_PLL1_DIV_SELECT_REGISTER, offset: 0x2F0 */
       uint8_t RESERVED_14[12];
  __IO uint32_t PLL_AUDIO_CTRL;                    /**< PLL_AUDIO_CTRL_REGISTER, offset: 0x300 */
       uint8_t RESERVED_15[12];
  __IO uint32_t PLL_AUDIO_SS;                      /**< PLL_AUDIO_SS_REGISTER, offset: 0x310 */
       uint8_t RESERVED_16[12];
  __IO uint32_t PLL_AUDIO_DENOMINATOR;             /**< PLL_AUDIO_DENOMINATOR_REGISTER, offset: 0x320 */
       uint8_t RESERVED_17[12];
  __IO uint32_t PLL_AUDIO_NUMERATOR;               /**< PLL_AUDIO_NUMERATOR_REGISTER, offset: 0x330 */
       uint8_t RESERVED_18[12];
  __IO uint32_t PLL_AUDIO_DIV_SELECT;              /**< PLL_AUDIO_DIV_SELECT_REGISTER, offset: 0x340 */
       uint8_t RESERVED_19[12];
  __IO uint32_t PLL_VIDEO_CTRL;                    /**< PLL_VIDEO_CTRL_REGISTER, offset: 0x350 */
       uint8_t RESERVED_20[12];
  __IO uint32_t PLL_VIDEO_SS;                      /**< PLL_VIDEO_SS_REGISTER, offset: 0x360 */
       uint8_t RESERVED_21[12];
  __IO uint32_t PLL_VIDEO_DENOMINATOR;             /**< PLL_VIDEO_DENOMINATOR_REGISTER, offset: 0x370 */
       uint8_t RESERVED_22[12];
  __IO uint32_t PLL_VIDEO_NUMERATOR;               /**< PLL_VIDEO_NUMERATOR_REGISTER, offset: 0x380 */
       uint8_t RESERVED_23[12];
  __IO uint32_t PLL_VIDEO_DIV_SELECT;              /**< PLL_VIDEO_DIV_SELECT_REGISTER, offset: 0x390 */
} ANADIG_PLL_Type;

/* ----------------------------------------------------------------------------
   -- ANADIG_PLL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_PLL_Register_Masks ANADIG_PLL Register Masks
 * @{
 */

/*! @name ARM_PLL_CTRL - ARM_PLL_CTRL_REGISTER */
/*! @{ */

#define ANADIG_PLL_ARM_PLL_CTRL_DIV_SELECT_MASK  (0xFFU)
#define ANADIG_PLL_ARM_PLL_CTRL_DIV_SELECT_SHIFT (0U)
/*! DIV_SELECT - DIV_SELECT
 */
#define ANADIG_PLL_ARM_PLL_CTRL_DIV_SELECT(x)    (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_ARM_PLL_CTRL_DIV_SELECT_SHIFT)) & ANADIG_PLL_ARM_PLL_CTRL_DIV_SELECT_MASK)

#define ANADIG_PLL_ARM_PLL_CTRL_HOLD_RING_OFF_MASK (0x1000U)
#define ANADIG_PLL_ARM_PLL_CTRL_HOLD_RING_OFF_SHIFT (12U)
/*! HOLD_RING_OFF - PLL Start up initialization
 *  0b0..Normal operation
 *  0b1..Initialize PLL start up
 */
#define ANADIG_PLL_ARM_PLL_CTRL_HOLD_RING_OFF(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_ARM_PLL_CTRL_HOLD_RING_OFF_SHIFT)) & ANADIG_PLL_ARM_PLL_CTRL_HOLD_RING_OFF_MASK)

#define ANADIG_PLL_ARM_PLL_CTRL_POWERUP_MASK     (0x2000U)
#define ANADIG_PLL_ARM_PLL_CTRL_POWERUP_SHIFT    (13U)
/*! POWERUP - Powers up the PLL.
 *  0b1..Power Up the PLL
 *  0b0..Power down the PLL
 */
#define ANADIG_PLL_ARM_PLL_CTRL_POWERUP(x)       (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_ARM_PLL_CTRL_POWERUP_SHIFT)) & ANADIG_PLL_ARM_PLL_CTRL_POWERUP_MASK)

#define ANADIG_PLL_ARM_PLL_CTRL_ENABLE_CLK_MASK  (0x4000U)
#define ANADIG_PLL_ARM_PLL_CTRL_ENABLE_CLK_SHIFT (14U)
/*! ENABLE_CLK - Enable the clock output.
 *  0b0..Disable the clock
 *  0b1..Enable the clock
 */
#define ANADIG_PLL_ARM_PLL_CTRL_ENABLE_CLK(x)    (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_ARM_PLL_CTRL_ENABLE_CLK_SHIFT)) & ANADIG_PLL_ARM_PLL_CTRL_ENABLE_CLK_MASK)

#define ANADIG_PLL_ARM_PLL_CTRL_POST_DIV_SEL_MASK (0x18000U)
#define ANADIG_PLL_ARM_PLL_CTRL_POST_DIV_SEL_SHIFT (15U)
/*! POST_DIV_SEL - POST_DIV_SEL
 *  0b00..Divide by 2
 *  0b01..Divide by 4
 *  0b10..Divide by 8
 *  0b11..Divide by 1
 */
#define ANADIG_PLL_ARM_PLL_CTRL_POST_DIV_SEL(x)  (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_ARM_PLL_CTRL_POST_DIV_SEL_SHIFT)) & ANADIG_PLL_ARM_PLL_CTRL_POST_DIV_SEL_MASK)

#define ANADIG_PLL_ARM_PLL_CTRL_BYPASS_MASK      (0x20000U)
#define ANADIG_PLL_ARM_PLL_CTRL_BYPASS_SHIFT     (17U)
/*! BYPASS - Bypass the pll.
 *  0b1..Bypass Mode
 *  0b0..Function mode
 */
#define ANADIG_PLL_ARM_PLL_CTRL_BYPASS(x)        (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_ARM_PLL_CTRL_BYPASS_SHIFT)) & ANADIG_PLL_ARM_PLL_CTRL_BYPASS_MASK)

#define ANADIG_PLL_ARM_PLL_CTRL_ARM_PLL_STABLE_MASK (0x20000000U)
#define ANADIG_PLL_ARM_PLL_CTRL_ARM_PLL_STABLE_SHIFT (29U)
/*! ARM_PLL_STABLE - ARM_PLL_STABLE
 *  0b1..ARM PLL is stable
 *  0b0..ARM PLL is not stable
 */
#define ANADIG_PLL_ARM_PLL_CTRL_ARM_PLL_STABLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_ARM_PLL_CTRL_ARM_PLL_STABLE_SHIFT)) & ANADIG_PLL_ARM_PLL_CTRL_ARM_PLL_STABLE_MASK)

#define ANADIG_PLL_ARM_PLL_CTRL_ARM_PLL_GATE_MASK (0x40000000U)
#define ANADIG_PLL_ARM_PLL_CTRL_ARM_PLL_GATE_SHIFT (30U)
/*! ARM_PLL_GATE - ARM_PLL_GATE
 *  0b1..Clock is gated
 *  0b0..Clock is not gated
 */
#define ANADIG_PLL_ARM_PLL_CTRL_ARM_PLL_GATE(x)  (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_ARM_PLL_CTRL_ARM_PLL_GATE_SHIFT)) & ANADIG_PLL_ARM_PLL_CTRL_ARM_PLL_GATE_MASK)

#define ANADIG_PLL_ARM_PLL_CTRL_ARM_PLL_CONTROL_MODE_MASK (0x80000000U)
#define ANADIG_PLL_ARM_PLL_CTRL_ARM_PLL_CONTROL_MODE_SHIFT (31U)
/*! ARM_PLL_CONTROL_MODE - pll_arm_control_mode
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_ARM_PLL_CTRL_ARM_PLL_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_ARM_PLL_CTRL_ARM_PLL_CONTROL_MODE_SHIFT)) & ANADIG_PLL_ARM_PLL_CTRL_ARM_PLL_CONTROL_MODE_MASK)
/*! @} */

/*! @name SYS_PLL3_CTRL - SYS_PLL3_CTRL_REGISTER */
/*! @{ */

#define ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_DIV2_MASK (0x8U)
#define ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_DIV2_SHIFT (3U)
/*! SYS_PLL3_DIV2 - SYS PLL3 DIV2 gate
 */
#define ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_DIV2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_DIV2_SHIFT)) & ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_DIV2_MASK)

#define ANADIG_PLL_SYS_PLL3_CTRL_PLL_REG_EN_MASK (0x10U)
#define ANADIG_PLL_SYS_PLL3_CTRL_PLL_REG_EN_SHIFT (4U)
/*! PLL_REG_EN - Enable Internal PLL Regulator
 */
#define ANADIG_PLL_SYS_PLL3_CTRL_PLL_REG_EN(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_CTRL_PLL_REG_EN_SHIFT)) & ANADIG_PLL_SYS_PLL3_CTRL_PLL_REG_EN_MASK)

#define ANADIG_PLL_SYS_PLL3_CTRL_HOLD_RING_OFF_MASK (0x800U)
#define ANADIG_PLL_SYS_PLL3_CTRL_HOLD_RING_OFF_SHIFT (11U)
/*! HOLD_RING_OFF - PLL Start up initialization
 *  0b0..Normal operation
 *  0b1..Initialize PLL start up
 */
#define ANADIG_PLL_SYS_PLL3_CTRL_HOLD_RING_OFF(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_CTRL_HOLD_RING_OFF_SHIFT)) & ANADIG_PLL_SYS_PLL3_CTRL_HOLD_RING_OFF_MASK)

#define ANADIG_PLL_SYS_PLL3_CTRL_ENABLE_CLK_MASK (0x2000U)
#define ANADIG_PLL_SYS_PLL3_CTRL_ENABLE_CLK_SHIFT (13U)
/*! ENABLE_CLK - Enable the clock output.
 *  0b0..Disable the clock
 *  0b1..Enable the clock
 */
#define ANADIG_PLL_SYS_PLL3_CTRL_ENABLE_CLK(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_CTRL_ENABLE_CLK_SHIFT)) & ANADIG_PLL_SYS_PLL3_CTRL_ENABLE_CLK_MASK)

#define ANADIG_PLL_SYS_PLL3_CTRL_BYPASS_MASK     (0x10000U)
#define ANADIG_PLL_SYS_PLL3_CTRL_BYPASS_SHIFT    (16U)
/*! BYPASS - BYPASS
 *  0b1..Bypass Mode
 *  0b0..Function mode
 */
#define ANADIG_PLL_SYS_PLL3_CTRL_BYPASS(x)       (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_CTRL_BYPASS_SHIFT)) & ANADIG_PLL_SYS_PLL3_CTRL_BYPASS_MASK)

#define ANADIG_PLL_SYS_PLL3_CTRL_POWERUP_MASK    (0x200000U)
#define ANADIG_PLL_SYS_PLL3_CTRL_POWERUP_SHIFT   (21U)
/*! POWERUP - Powers up the PLL.
 *  0b1..Power Up the PLL
 *  0b0..Power down the PLL
 */
#define ANADIG_PLL_SYS_PLL3_CTRL_POWERUP(x)      (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_CTRL_POWERUP_SHIFT)) & ANADIG_PLL_SYS_PLL3_CTRL_POWERUP_MASK)

#define ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_DIV2_CONTROL_MODE_MASK (0x10000000U)
#define ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_DIV2_CONTROL_MODE_SHIFT (28U)
/*! SYS_PLL3_DIV2_CONTROL_MODE - SYS_PLL3_DIV2_CONTROL_MODE
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_DIV2_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_DIV2_CONTROL_MODE_SHIFT)) & ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_DIV2_CONTROL_MODE_MASK)

#define ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_STABLE_MASK (0x20000000U)
#define ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_STABLE_SHIFT (29U)
/*! SYS_PLL3_STABLE - SYS_PLL3_STABLE
 */
#define ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_STABLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_STABLE_SHIFT)) & ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_STABLE_MASK)

#define ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_GATE_MASK (0x40000000U)
#define ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_GATE_SHIFT (30U)
/*! SYS_PLL3_GATE - SYS_PLL3_GATE
 *  0b1..Clock is gated
 *  0b0..Clock is not gated
 */
#define ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_GATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_GATE_SHIFT)) & ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_GATE_MASK)

#define ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_CONTROL_MODE_MASK (0x80000000U)
#define ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_CONTROL_MODE_SHIFT (31U)
/*! SYS_PLL3_CONTROL_MODE - SYS_PLL3_control_mode
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_CONTROL_MODE_SHIFT)) & ANADIG_PLL_SYS_PLL3_CTRL_SYS_PLL3_CONTROL_MODE_MASK)
/*! @} */

/*! @name SYS_PLL3_UPDATE - SYS_PLL3_UPDATE_REGISTER */
/*! @{ */

#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD0_UPDATE_MASK (0x2U)
#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD0_UPDATE_SHIFT (1U)
/*! PFD0_UPDATE - PFD0_OVERRIDE
 */
#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD0_UPDATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_UPDATE_PFD0_UPDATE_SHIFT)) & ANADIG_PLL_SYS_PLL3_UPDATE_PFD0_UPDATE_MASK)

#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD1_UPDATE_MASK (0x4U)
#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD1_UPDATE_SHIFT (2U)
/*! PFD1_UPDATE - PFD1_OVERRIDE
 */
#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD1_UPDATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_UPDATE_PFD1_UPDATE_SHIFT)) & ANADIG_PLL_SYS_PLL3_UPDATE_PFD1_UPDATE_MASK)

#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD2_UPDATE_MASK (0x8U)
#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD2_UPDATE_SHIFT (3U)
/*! PFD2_UPDATE - PFD2_OVERRIDE
 */
#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD2_UPDATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_UPDATE_PFD2_UPDATE_SHIFT)) & ANADIG_PLL_SYS_PLL3_UPDATE_PFD2_UPDATE_MASK)

#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD3_UPDATE_MASK (0x10U)
#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD3_UPDATE_SHIFT (4U)
/*! PFD3_UPDATE - PFD3_UPDATE
 */
#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD3_UPDATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_UPDATE_PFD3_UPDATE_SHIFT)) & ANADIG_PLL_SYS_PLL3_UPDATE_PFD3_UPDATE_MASK)

#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD0_CONTROL_MODE_MASK (0x20U)
#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD0_CONTROL_MODE_SHIFT (5U)
/*! PFD0_CONTROL_MODE - pfd0_control_mode
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD0_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_UPDATE_PFD0_CONTROL_MODE_SHIFT)) & ANADIG_PLL_SYS_PLL3_UPDATE_PFD0_CONTROL_MODE_MASK)

#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD1_CONTROL_MODE_MASK (0x40U)
#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD1_CONTROL_MODE_SHIFT (6U)
/*! PFD1_CONTROL_MODE - pfd1_control_mode
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD1_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_UPDATE_PFD1_CONTROL_MODE_SHIFT)) & ANADIG_PLL_SYS_PLL3_UPDATE_PFD1_CONTROL_MODE_MASK)

#define ANADIG_PLL_SYS_PLL3_UPDATE_PDF2_CONTROL_MODE_MASK (0x80U)
#define ANADIG_PLL_SYS_PLL3_UPDATE_PDF2_CONTROL_MODE_SHIFT (7U)
/*! PDF2_CONTROL_MODE - pdf2_control_mode
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_SYS_PLL3_UPDATE_PDF2_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_UPDATE_PDF2_CONTROL_MODE_SHIFT)) & ANADIG_PLL_SYS_PLL3_UPDATE_PDF2_CONTROL_MODE_MASK)

#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD3_CONTROL_MODE_MASK (0x100U)
#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD3_CONTROL_MODE_SHIFT (8U)
/*! PFD3_CONTROL_MODE - pfd3_control_mode
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_SYS_PLL3_UPDATE_PFD3_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_UPDATE_PFD3_CONTROL_MODE_SHIFT)) & ANADIG_PLL_SYS_PLL3_UPDATE_PFD3_CONTROL_MODE_MASK)
/*! @} */

/*! @name SYS_PLL3_PFD - SYS_PLL3_PFD_REGISTER */
/*! @{ */

#define ANADIG_PLL_SYS_PLL3_PFD_PFD0_FRAC_MASK   (0x3FU)
#define ANADIG_PLL_SYS_PLL3_PFD_PFD0_FRAC_SHIFT  (0U)
/*! PFD0_FRAC - PFD0_FRAC
 */
#define ANADIG_PLL_SYS_PLL3_PFD_PFD0_FRAC(x)     (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_PFD_PFD0_FRAC_SHIFT)) & ANADIG_PLL_SYS_PLL3_PFD_PFD0_FRAC_MASK)

#define ANADIG_PLL_SYS_PLL3_PFD_PFD0_STABLE_MASK (0x40U)
#define ANADIG_PLL_SYS_PLL3_PFD_PFD0_STABLE_SHIFT (6U)
/*! PFD0_STABLE - PFD0_STABLE
 */
#define ANADIG_PLL_SYS_PLL3_PFD_PFD0_STABLE(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_PFD_PFD0_STABLE_SHIFT)) & ANADIG_PLL_SYS_PLL3_PFD_PFD0_STABLE_MASK)

#define ANADIG_PLL_SYS_PLL3_PFD_PFD0_DIV1_CLKGATE_MASK (0x80U)
#define ANADIG_PLL_SYS_PLL3_PFD_PFD0_DIV1_CLKGATE_SHIFT (7U)
/*! PFD0_DIV1_CLKGATE - PFD0_DIV1_CLKGATE
 *  0b1..Fractional divider clock (reference ref_pfd0) is off (power savings
 *  0b0..ref_pfd0 fractional divider clock is enabled
 */
#define ANADIG_PLL_SYS_PLL3_PFD_PFD0_DIV1_CLKGATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_PFD_PFD0_DIV1_CLKGATE_SHIFT)) & ANADIG_PLL_SYS_PLL3_PFD_PFD0_DIV1_CLKGATE_MASK)

#define ANADIG_PLL_SYS_PLL3_PFD_PFD1_FRAC_MASK   (0x3F00U)
#define ANADIG_PLL_SYS_PLL3_PFD_PFD1_FRAC_SHIFT  (8U)
/*! PFD1_FRAC - PFD1_FRAC
 */
#define ANADIG_PLL_SYS_PLL3_PFD_PFD1_FRAC(x)     (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_PFD_PFD1_FRAC_SHIFT)) & ANADIG_PLL_SYS_PLL3_PFD_PFD1_FRAC_MASK)

#define ANADIG_PLL_SYS_PLL3_PFD_PFD1_STABLE_MASK (0x4000U)
#define ANADIG_PLL_SYS_PLL3_PFD_PFD1_STABLE_SHIFT (14U)
/*! PFD1_STABLE - PFD1_STABLE
 */
#define ANADIG_PLL_SYS_PLL3_PFD_PFD1_STABLE(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_PFD_PFD1_STABLE_SHIFT)) & ANADIG_PLL_SYS_PLL3_PFD_PFD1_STABLE_MASK)

#define ANADIG_PLL_SYS_PLL3_PFD_PFD1_DIV1_CLKGATE_MASK (0x8000U)
#define ANADIG_PLL_SYS_PLL3_PFD_PFD1_DIV1_CLKGATE_SHIFT (15U)
/*! PFD1_DIV1_CLKGATE - PFD1_DIV1_CLKGATE
 *  0b1..Fractional divider clock (reference ref_pfd1) is off (power savings)
 *  0b0..ref_pfd1 fractional divider clock is enabled
 */
#define ANADIG_PLL_SYS_PLL3_PFD_PFD1_DIV1_CLKGATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_PFD_PFD1_DIV1_CLKGATE_SHIFT)) & ANADIG_PLL_SYS_PLL3_PFD_PFD1_DIV1_CLKGATE_MASK)

#define ANADIG_PLL_SYS_PLL3_PFD_PFD2_FRAC_MASK   (0x3F0000U)
#define ANADIG_PLL_SYS_PLL3_PFD_PFD2_FRAC_SHIFT  (16U)
/*! PFD2_FRAC - PFD2_FRAC
 */
#define ANADIG_PLL_SYS_PLL3_PFD_PFD2_FRAC(x)     (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_PFD_PFD2_FRAC_SHIFT)) & ANADIG_PLL_SYS_PLL3_PFD_PFD2_FRAC_MASK)

#define ANADIG_PLL_SYS_PLL3_PFD_PFD2_STABLE_MASK (0x400000U)
#define ANADIG_PLL_SYS_PLL3_PFD_PFD2_STABLE_SHIFT (22U)
/*! PFD2_STABLE - PFD2_STABLE
 */
#define ANADIG_PLL_SYS_PLL3_PFD_PFD2_STABLE(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_PFD_PFD2_STABLE_SHIFT)) & ANADIG_PLL_SYS_PLL3_PFD_PFD2_STABLE_MASK)

#define ANADIG_PLL_SYS_PLL3_PFD_PFD2_DIV1_CLKGATE_MASK (0x800000U)
#define ANADIG_PLL_SYS_PLL3_PFD_PFD2_DIV1_CLKGATE_SHIFT (23U)
/*! PFD2_DIV1_CLKGATE - PFD2_DIV1_CLKGATE
 *  0b1..Fractional divider clock (reference ref_pfd2) is off (power savings)
 *  0b0..ref_pfd2 fractional divider clock is enabled
 */
#define ANADIG_PLL_SYS_PLL3_PFD_PFD2_DIV1_CLKGATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_PFD_PFD2_DIV1_CLKGATE_SHIFT)) & ANADIG_PLL_SYS_PLL3_PFD_PFD2_DIV1_CLKGATE_MASK)

#define ANADIG_PLL_SYS_PLL3_PFD_PFD3_FRAC_MASK   (0x3F000000U)
#define ANADIG_PLL_SYS_PLL3_PFD_PFD3_FRAC_SHIFT  (24U)
/*! PFD3_FRAC - PFD3_FRAC
 */
#define ANADIG_PLL_SYS_PLL3_PFD_PFD3_FRAC(x)     (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_PFD_PFD3_FRAC_SHIFT)) & ANADIG_PLL_SYS_PLL3_PFD_PFD3_FRAC_MASK)

#define ANADIG_PLL_SYS_PLL3_PFD_PFD3_STABLE_MASK (0x40000000U)
#define ANADIG_PLL_SYS_PLL3_PFD_PFD3_STABLE_SHIFT (30U)
/*! PFD3_STABLE - PFD3_STABLE
 */
#define ANADIG_PLL_SYS_PLL3_PFD_PFD3_STABLE(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_PFD_PFD3_STABLE_SHIFT)) & ANADIG_PLL_SYS_PLL3_PFD_PFD3_STABLE_MASK)

#define ANADIG_PLL_SYS_PLL3_PFD_PFD3_DIV1_CLKGATE_MASK (0x80000000U)
#define ANADIG_PLL_SYS_PLL3_PFD_PFD3_DIV1_CLKGATE_SHIFT (31U)
/*! PFD3_DIV1_CLKGATE - PFD3_DIV1_CLKGATE
 *  0b1..Fractional divider clock (reference ref_pfd3) is off (power savings)
 *  0b0..ref_pfd3 fractional divider clock is enabled
 */
#define ANADIG_PLL_SYS_PLL3_PFD_PFD3_DIV1_CLKGATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL3_PFD_PFD3_DIV1_CLKGATE_SHIFT)) & ANADIG_PLL_SYS_PLL3_PFD_PFD3_DIV1_CLKGATE_MASK)
/*! @} */

/*! @name SYS_PLL2_CTRL - SYS_PLL2_CTRL_REGISTER */
/*! @{ */

#define ANADIG_PLL_SYS_PLL2_CTRL_PLL_REG_EN_MASK (0x8U)
#define ANADIG_PLL_SYS_PLL2_CTRL_PLL_REG_EN_SHIFT (3U)
/*! PLL_REG_EN - Enable Internal PLL Regulator
 */
#define ANADIG_PLL_SYS_PLL2_CTRL_PLL_REG_EN(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_CTRL_PLL_REG_EN_SHIFT)) & ANADIG_PLL_SYS_PLL2_CTRL_PLL_REG_EN_MASK)

#define ANADIG_PLL_SYS_PLL2_CTRL_HOLD_RING_OFF_MASK (0x800U)
#define ANADIG_PLL_SYS_PLL2_CTRL_HOLD_RING_OFF_SHIFT (11U)
/*! HOLD_RING_OFF - PLL Start up initialization
 *  0b0..Normal operation
 *  0b1..Initialize PLL start up
 */
#define ANADIG_PLL_SYS_PLL2_CTRL_HOLD_RING_OFF(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_CTRL_HOLD_RING_OFF_SHIFT)) & ANADIG_PLL_SYS_PLL2_CTRL_HOLD_RING_OFF_MASK)

#define ANADIG_PLL_SYS_PLL2_CTRL_ENABLE_CLK_MASK (0x2000U)
#define ANADIG_PLL_SYS_PLL2_CTRL_ENABLE_CLK_SHIFT (13U)
/*! ENABLE_CLK - Enable the clock output.
 *  0b0..Disable the clock
 *  0b1..Enable the clock
 */
#define ANADIG_PLL_SYS_PLL2_CTRL_ENABLE_CLK(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_CTRL_ENABLE_CLK_SHIFT)) & ANADIG_PLL_SYS_PLL2_CTRL_ENABLE_CLK_MASK)

#define ANADIG_PLL_SYS_PLL2_CTRL_BYPASS_MASK     (0x10000U)
#define ANADIG_PLL_SYS_PLL2_CTRL_BYPASS_SHIFT    (16U)
/*! BYPASS - Bypass the pll.
 *  0b1..Bypass Mode
 *  0b0..Function mode
 */
#define ANADIG_PLL_SYS_PLL2_CTRL_BYPASS(x)       (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_CTRL_BYPASS_SHIFT)) & ANADIG_PLL_SYS_PLL2_CTRL_BYPASS_MASK)

#define ANADIG_PLL_SYS_PLL2_CTRL_DITHER_ENABLE_MASK (0x20000U)
#define ANADIG_PLL_SYS_PLL2_CTRL_DITHER_ENABLE_SHIFT (17U)
/*! DITHER_ENABLE - DITHER_ENABLE
 *  0b0..Disable Dither
 *  0b1..Enable Dither
 */
#define ANADIG_PLL_SYS_PLL2_CTRL_DITHER_ENABLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_CTRL_DITHER_ENABLE_SHIFT)) & ANADIG_PLL_SYS_PLL2_CTRL_DITHER_ENABLE_MASK)

#define ANADIG_PLL_SYS_PLL2_CTRL_PFD_OFFSET_EN_MASK (0x40000U)
#define ANADIG_PLL_SYS_PLL2_CTRL_PFD_OFFSET_EN_SHIFT (18U)
/*! PFD_OFFSET_EN - PFD_OFFSET_EN
 */
#define ANADIG_PLL_SYS_PLL2_CTRL_PFD_OFFSET_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_CTRL_PFD_OFFSET_EN_SHIFT)) & ANADIG_PLL_SYS_PLL2_CTRL_PFD_OFFSET_EN_MASK)

#define ANADIG_PLL_SYS_PLL2_CTRL_PLL_DDR_OVERRIDE_MASK (0x80000U)
#define ANADIG_PLL_SYS_PLL2_CTRL_PLL_DDR_OVERRIDE_SHIFT (19U)
/*! PLL_DDR_OVERRIDE - PLL_DDR_OVERRIDE
 */
#define ANADIG_PLL_SYS_PLL2_CTRL_PLL_DDR_OVERRIDE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_CTRL_PLL_DDR_OVERRIDE_SHIFT)) & ANADIG_PLL_SYS_PLL2_CTRL_PLL_DDR_OVERRIDE_MASK)

#define ANADIG_PLL_SYS_PLL2_CTRL_POWERUP_MASK    (0x800000U)
#define ANADIG_PLL_SYS_PLL2_CTRL_POWERUP_SHIFT   (23U)
/*! POWERUP - Powers up the PLL.
 *  0b1..Power Up the PLL
 *  0b0..Power down the PLL
 */
#define ANADIG_PLL_SYS_PLL2_CTRL_POWERUP(x)      (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_CTRL_POWERUP_SHIFT)) & ANADIG_PLL_SYS_PLL2_CTRL_POWERUP_MASK)

#define ANADIG_PLL_SYS_PLL2_CTRL_SYS_PLL2_STABLE_MASK (0x20000000U)
#define ANADIG_PLL_SYS_PLL2_CTRL_SYS_PLL2_STABLE_SHIFT (29U)
/*! SYS_PLL2_STABLE - SYS_PLL2_STABLE
 */
#define ANADIG_PLL_SYS_PLL2_CTRL_SYS_PLL2_STABLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_CTRL_SYS_PLL2_STABLE_SHIFT)) & ANADIG_PLL_SYS_PLL2_CTRL_SYS_PLL2_STABLE_MASK)

#define ANADIG_PLL_SYS_PLL2_CTRL_SYS_PLL2_GATE_MASK (0x40000000U)
#define ANADIG_PLL_SYS_PLL2_CTRL_SYS_PLL2_GATE_SHIFT (30U)
/*! SYS_PLL2_GATE - SYS_PLL2_GATE
 *  0b1..Clock is gated
 *  0b0..Clock is not gated
 */
#define ANADIG_PLL_SYS_PLL2_CTRL_SYS_PLL2_GATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_CTRL_SYS_PLL2_GATE_SHIFT)) & ANADIG_PLL_SYS_PLL2_CTRL_SYS_PLL2_GATE_MASK)

#define ANADIG_PLL_SYS_PLL2_CTRL_SYS_PLL2_CONTROL_MODE_MASK (0x80000000U)
#define ANADIG_PLL_SYS_PLL2_CTRL_SYS_PLL2_CONTROL_MODE_SHIFT (31U)
/*! SYS_PLL2_CONTROL_MODE - SYS_PLL2_control_mode
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_SYS_PLL2_CTRL_SYS_PLL2_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_CTRL_SYS_PLL2_CONTROL_MODE_SHIFT)) & ANADIG_PLL_SYS_PLL2_CTRL_SYS_PLL2_CONTROL_MODE_MASK)
/*! @} */

/*! @name SYS_PLL2_UPDATE - SYS_PLL2_UPDATE_REGISTER */
/*! @{ */

#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD0_UPDATE_MASK (0x2U)
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD0_UPDATE_SHIFT (1U)
/*! PFD0_UPDATE - PFD0_UPDATE
 */
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD0_UPDATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_UPDATE_PFD0_UPDATE_SHIFT)) & ANADIG_PLL_SYS_PLL2_UPDATE_PFD0_UPDATE_MASK)

#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD1_UPDATE_MASK (0x4U)
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD1_UPDATE_SHIFT (2U)
/*! PFD1_UPDATE - PFD1_UPDATE
 */
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD1_UPDATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_UPDATE_PFD1_UPDATE_SHIFT)) & ANADIG_PLL_SYS_PLL2_UPDATE_PFD1_UPDATE_MASK)

#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD2_UPDATE_MASK (0x8U)
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD2_UPDATE_SHIFT (3U)
/*! PFD2_UPDATE - PFD2_UPDATE
 */
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD2_UPDATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_UPDATE_PFD2_UPDATE_SHIFT)) & ANADIG_PLL_SYS_PLL2_UPDATE_PFD2_UPDATE_MASK)

#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD3_UPDATE_MASK (0x10U)
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD3_UPDATE_SHIFT (4U)
/*! PFD3_UPDATE - PFD3_UPDATE
 */
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD3_UPDATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_UPDATE_PFD3_UPDATE_SHIFT)) & ANADIG_PLL_SYS_PLL2_UPDATE_PFD3_UPDATE_MASK)

#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD0_CONTROL_MODE_MASK (0x20U)
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD0_CONTROL_MODE_SHIFT (5U)
/*! PFD0_CONTROL_MODE - pfd0_control_mode
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD0_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_UPDATE_PFD0_CONTROL_MODE_SHIFT)) & ANADIG_PLL_SYS_PLL2_UPDATE_PFD0_CONTROL_MODE_MASK)

#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD1_CONTROL_MODE_MASK (0x40U)
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD1_CONTROL_MODE_SHIFT (6U)
/*! PFD1_CONTROL_MODE - pfd1_control_mode
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD1_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_UPDATE_PFD1_CONTROL_MODE_SHIFT)) & ANADIG_PLL_SYS_PLL2_UPDATE_PFD1_CONTROL_MODE_MASK)

#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD2_CONTROL_MODE_MASK (0x80U)
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD2_CONTROL_MODE_SHIFT (7U)
/*! PFD2_CONTROL_MODE - pfd2_control_mode
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD2_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_UPDATE_PFD2_CONTROL_MODE_SHIFT)) & ANADIG_PLL_SYS_PLL2_UPDATE_PFD2_CONTROL_MODE_MASK)

#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD3_CONTROL_MODE_MASK (0x100U)
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD3_CONTROL_MODE_SHIFT (8U)
/*! PFD3_CONTROL_MODE - pfd3_control_mode
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_SYS_PLL2_UPDATE_PFD3_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_UPDATE_PFD3_CONTROL_MODE_SHIFT)) & ANADIG_PLL_SYS_PLL2_UPDATE_PFD3_CONTROL_MODE_MASK)
/*! @} */

/*! @name SYS_PLL2_SS - SYS_PLL2_SS_REGISTER */
/*! @{ */

#define ANADIG_PLL_SYS_PLL2_SS_STEP_MASK         (0x7FFFU)
#define ANADIG_PLL_SYS_PLL2_SS_STEP_SHIFT        (0U)
/*! STEP - STEP
 */
#define ANADIG_PLL_SYS_PLL2_SS_STEP(x)           (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_SS_STEP_SHIFT)) & ANADIG_PLL_SYS_PLL2_SS_STEP_MASK)

#define ANADIG_PLL_SYS_PLL2_SS_ENABLE_MASK       (0x8000U)
#define ANADIG_PLL_SYS_PLL2_SS_ENABLE_SHIFT      (15U)
/*! ENABLE - ENABLE
 *  0b1..Enable Spread Spectrum
 *  0b0..Disable Spread Spectrum
 */
#define ANADIG_PLL_SYS_PLL2_SS_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_SS_ENABLE_SHIFT)) & ANADIG_PLL_SYS_PLL2_SS_ENABLE_MASK)

#define ANADIG_PLL_SYS_PLL2_SS_STOP_MASK         (0xFFFF0000U)
#define ANADIG_PLL_SYS_PLL2_SS_STOP_SHIFT        (16U)
/*! STOP - STOP
 */
#define ANADIG_PLL_SYS_PLL2_SS_STOP(x)           (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_SS_STOP_SHIFT)) & ANADIG_PLL_SYS_PLL2_SS_STOP_MASK)
/*! @} */

/*! @name SYS_PLL2_PFD - SYS_PLL2_PFD_REGISTER */
/*! @{ */

#define ANADIG_PLL_SYS_PLL2_PFD_PFD0_FRAC_MASK   (0x3FU)
#define ANADIG_PLL_SYS_PLL2_PFD_PFD0_FRAC_SHIFT  (0U)
/*! PFD0_FRAC - PFD0_FRAC
 */
#define ANADIG_PLL_SYS_PLL2_PFD_PFD0_FRAC(x)     (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_PFD_PFD0_FRAC_SHIFT)) & ANADIG_PLL_SYS_PLL2_PFD_PFD0_FRAC_MASK)

#define ANADIG_PLL_SYS_PLL2_PFD_PFD0_STABLE_MASK (0x40U)
#define ANADIG_PLL_SYS_PLL2_PFD_PFD0_STABLE_SHIFT (6U)
/*! PFD0_STABLE - PFD0_STABLE
 */
#define ANADIG_PLL_SYS_PLL2_PFD_PFD0_STABLE(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_PFD_PFD0_STABLE_SHIFT)) & ANADIG_PLL_SYS_PLL2_PFD_PFD0_STABLE_MASK)

#define ANADIG_PLL_SYS_PLL2_PFD_PFD0_DIV1_CLKGATE_MASK (0x80U)
#define ANADIG_PLL_SYS_PLL2_PFD_PFD0_DIV1_CLKGATE_SHIFT (7U)
/*! PFD0_DIV1_CLKGATE - PFD0_DIV1_CLKGATE
 */
#define ANADIG_PLL_SYS_PLL2_PFD_PFD0_DIV1_CLKGATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_PFD_PFD0_DIV1_CLKGATE_SHIFT)) & ANADIG_PLL_SYS_PLL2_PFD_PFD0_DIV1_CLKGATE_MASK)

#define ANADIG_PLL_SYS_PLL2_PFD_PFD1_FRAC_MASK   (0x3F00U)
#define ANADIG_PLL_SYS_PLL2_PFD_PFD1_FRAC_SHIFT  (8U)
/*! PFD1_FRAC - PFD1_FRAC
 */
#define ANADIG_PLL_SYS_PLL2_PFD_PFD1_FRAC(x)     (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_PFD_PFD1_FRAC_SHIFT)) & ANADIG_PLL_SYS_PLL2_PFD_PFD1_FRAC_MASK)

#define ANADIG_PLL_SYS_PLL2_PFD_PFD1_STABLE_MASK (0x4000U)
#define ANADIG_PLL_SYS_PLL2_PFD_PFD1_STABLE_SHIFT (14U)
/*! PFD1_STABLE - PFD1_STABLE
 */
#define ANADIG_PLL_SYS_PLL2_PFD_PFD1_STABLE(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_PFD_PFD1_STABLE_SHIFT)) & ANADIG_PLL_SYS_PLL2_PFD_PFD1_STABLE_MASK)

#define ANADIG_PLL_SYS_PLL2_PFD_PFD1_DIV1_CLKGATE_MASK (0x8000U)
#define ANADIG_PLL_SYS_PLL2_PFD_PFD1_DIV1_CLKGATE_SHIFT (15U)
/*! PFD1_DIV1_CLKGATE - PFD1_DIV1_CLKGATE
 */
#define ANADIG_PLL_SYS_PLL2_PFD_PFD1_DIV1_CLKGATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_PFD_PFD1_DIV1_CLKGATE_SHIFT)) & ANADIG_PLL_SYS_PLL2_PFD_PFD1_DIV1_CLKGATE_MASK)

#define ANADIG_PLL_SYS_PLL2_PFD_PFD2_FRAC_MASK   (0x3F0000U)
#define ANADIG_PLL_SYS_PLL2_PFD_PFD2_FRAC_SHIFT  (16U)
/*! PFD2_FRAC - PFD2_FRAC
 */
#define ANADIG_PLL_SYS_PLL2_PFD_PFD2_FRAC(x)     (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_PFD_PFD2_FRAC_SHIFT)) & ANADIG_PLL_SYS_PLL2_PFD_PFD2_FRAC_MASK)

#define ANADIG_PLL_SYS_PLL2_PFD_PFD2_STABLE_MASK (0x400000U)
#define ANADIG_PLL_SYS_PLL2_PFD_PFD2_STABLE_SHIFT (22U)
/*! PFD2_STABLE - PFD2_STABLE
 */
#define ANADIG_PLL_SYS_PLL2_PFD_PFD2_STABLE(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_PFD_PFD2_STABLE_SHIFT)) & ANADIG_PLL_SYS_PLL2_PFD_PFD2_STABLE_MASK)

#define ANADIG_PLL_SYS_PLL2_PFD_PFD2_DIV1_CLKGATE_MASK (0x800000U)
#define ANADIG_PLL_SYS_PLL2_PFD_PFD2_DIV1_CLKGATE_SHIFT (23U)
/*! PFD2_DIV1_CLKGATE - PFD2_DIV1_CLKGATE
 */
#define ANADIG_PLL_SYS_PLL2_PFD_PFD2_DIV1_CLKGATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_PFD_PFD2_DIV1_CLKGATE_SHIFT)) & ANADIG_PLL_SYS_PLL2_PFD_PFD2_DIV1_CLKGATE_MASK)

#define ANADIG_PLL_SYS_PLL2_PFD_PFD3_FRAC_MASK   (0x3F000000U)
#define ANADIG_PLL_SYS_PLL2_PFD_PFD3_FRAC_SHIFT  (24U)
/*! PFD3_FRAC - PFD3_FRAC
 */
#define ANADIG_PLL_SYS_PLL2_PFD_PFD3_FRAC(x)     (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_PFD_PFD3_FRAC_SHIFT)) & ANADIG_PLL_SYS_PLL2_PFD_PFD3_FRAC_MASK)

#define ANADIG_PLL_SYS_PLL2_PFD_PFD3_STABLE_MASK (0x40000000U)
#define ANADIG_PLL_SYS_PLL2_PFD_PFD3_STABLE_SHIFT (30U)
/*! PFD3_STABLE - PFD3_STABLE
 */
#define ANADIG_PLL_SYS_PLL2_PFD_PFD3_STABLE(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_PFD_PFD3_STABLE_SHIFT)) & ANADIG_PLL_SYS_PLL2_PFD_PFD3_STABLE_MASK)

#define ANADIG_PLL_SYS_PLL2_PFD_PFD3_DIV1_CLKGATE_MASK (0x80000000U)
#define ANADIG_PLL_SYS_PLL2_PFD_PFD3_DIV1_CLKGATE_SHIFT (31U)
/*! PFD3_DIV1_CLKGATE - PFD3_DIV1_CLKGATE
 */
#define ANADIG_PLL_SYS_PLL2_PFD_PFD3_DIV1_CLKGATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_PFD_PFD3_DIV1_CLKGATE_SHIFT)) & ANADIG_PLL_SYS_PLL2_PFD_PFD3_DIV1_CLKGATE_MASK)
/*! @} */

/*! @name SYS_PLL2_MFD - SYS_PLL2_MFD_REGISTER */
/*! @{ */

#define ANADIG_PLL_SYS_PLL2_MFD_MFD_MASK         (0x3FFFFFFFU)
#define ANADIG_PLL_SYS_PLL2_MFD_MFD_SHIFT        (0U)
/*! MFD - Denominator
 */
#define ANADIG_PLL_SYS_PLL2_MFD_MFD(x)           (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL2_MFD_MFD_SHIFT)) & ANADIG_PLL_SYS_PLL2_MFD_MFD_MASK)
/*! @} */

/*! @name SYS_PLL1_SS - SYS_PLL1_SS_REGISTER */
/*! @{ */

#define ANADIG_PLL_SYS_PLL1_SS_STEP_MASK         (0x7FFFU)
#define ANADIG_PLL_SYS_PLL1_SS_STEP_SHIFT        (0U)
/*! STEP - STEP
 */
#define ANADIG_PLL_SYS_PLL1_SS_STEP(x)           (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL1_SS_STEP_SHIFT)) & ANADIG_PLL_SYS_PLL1_SS_STEP_MASK)

#define ANADIG_PLL_SYS_PLL1_SS_ENABLE_MASK       (0x8000U)
#define ANADIG_PLL_SYS_PLL1_SS_ENABLE_SHIFT      (15U)
/*! ENABLE - ENABLE
 *  0b1..Enable Spread Spectrum
 *  0b0..Disable Spread Spectrum
 */
#define ANADIG_PLL_SYS_PLL1_SS_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL1_SS_ENABLE_SHIFT)) & ANADIG_PLL_SYS_PLL1_SS_ENABLE_MASK)

#define ANADIG_PLL_SYS_PLL1_SS_STOP_MASK         (0xFFFF0000U)
#define ANADIG_PLL_SYS_PLL1_SS_STOP_SHIFT        (16U)
/*! STOP - STOP
 */
#define ANADIG_PLL_SYS_PLL1_SS_STOP(x)           (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL1_SS_STOP_SHIFT)) & ANADIG_PLL_SYS_PLL1_SS_STOP_MASK)
/*! @} */

/*! @name SYS_PLL1_CTRL - SYS_PLL1_CTRL_REGISTER */
/*! @{ */

#define ANADIG_PLL_SYS_PLL1_CTRL_ENABLE_CLK_MASK (0x2000U)
#define ANADIG_PLL_SYS_PLL1_CTRL_ENABLE_CLK_SHIFT (13U)
/*! ENABLE_CLK - ENABLE_CLK
 */
#define ANADIG_PLL_SYS_PLL1_CTRL_ENABLE_CLK(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL1_CTRL_ENABLE_CLK_SHIFT)) & ANADIG_PLL_SYS_PLL1_CTRL_ENABLE_CLK_MASK)

#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_GATE_MASK (0x4000U)
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_GATE_SHIFT (14U)
/*! SYS_PLL1_GATE - SYS_PLL1_GATE
 *  0b1..Gate the output
 *  0b0..No gate
 */
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_GATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_GATE_SHIFT)) & ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_GATE_MASK)

#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV2_MASK (0x2000000U)
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV2_SHIFT (25U)
/*! SYS_PLL1_DIV2 - SYS_PLL1_DIV2
 */
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV2_SHIFT)) & ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV2_MASK)

#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV5_MASK (0x4000000U)
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV5_SHIFT (26U)
/*! SYS_PLL1_DIV5 - SYS_PLL1_DIV5
 */
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV5_SHIFT)) & ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV5_MASK)

#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV5_CONTROL_MODE_MASK (0x8000000U)
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV5_CONTROL_MODE_SHIFT (27U)
/*! SYS_PLL1_DIV5_CONTROL_MODE - SYS_PLL1_DIV5_CONTROL_MODE
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV5_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV5_CONTROL_MODE_SHIFT)) & ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV5_CONTROL_MODE_MASK)

#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV2_CONTROL_MODE_MASK (0x10000000U)
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV2_CONTROL_MODE_SHIFT (28U)
/*! SYS_PLL1_DIV2_CONTROL_MODE - SYS_PLL1_DIV2_CONTROL_MODE
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV2_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV2_CONTROL_MODE_SHIFT)) & ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_DIV2_CONTROL_MODE_MASK)

#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_STABLE_MASK (0x20000000U)
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_STABLE_SHIFT (29U)
/*! SYS_PLL1_STABLE - SYS_PLL1_STABLE
 */
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_STABLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_STABLE_SHIFT)) & ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_STABLE_MASK)

#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_AI_BUSY_MASK (0x40000000U)
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_AI_BUSY_SHIFT (30U)
/*! SYS_PLL1_AI_BUSY - SYS_PLL1_AI_BUSY
 */
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_AI_BUSY(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_AI_BUSY_SHIFT)) & ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_AI_BUSY_MASK)

#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_CONTROL_MODE_MASK (0x80000000U)
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_CONTROL_MODE_SHIFT (31U)
/*! SYS_PLL1_CONTROL_MODE - SYS_PLL1_CONTROL_MODE
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_CONTROL_MODE_SHIFT)) & ANADIG_PLL_SYS_PLL1_CTRL_SYS_PLL1_CONTROL_MODE_MASK)
/*! @} */

/*! @name SYS_PLL1_DENOMINATOR - SYS_PLL1_DENOMINATOR_REGISTER */
/*! @{ */

#define ANADIG_PLL_SYS_PLL1_DENOMINATOR_DENOM_MASK (0x3FFFFFFFU)
#define ANADIG_PLL_SYS_PLL1_DENOMINATOR_DENOM_SHIFT (0U)
/*! DENOM - DENOM
 */
#define ANADIG_PLL_SYS_PLL1_DENOMINATOR_DENOM(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL1_DENOMINATOR_DENOM_SHIFT)) & ANADIG_PLL_SYS_PLL1_DENOMINATOR_DENOM_MASK)
/*! @} */

/*! @name SYS_PLL1_NUMERATOR - SYS_PLL1_NUMERATOR_REGISTER */
/*! @{ */

#define ANADIG_PLL_SYS_PLL1_NUMERATOR_NUM_MASK   (0x3FFFFFFFU)
#define ANADIG_PLL_SYS_PLL1_NUMERATOR_NUM_SHIFT  (0U)
/*! NUM - NUM
 */
#define ANADIG_PLL_SYS_PLL1_NUMERATOR_NUM(x)     (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL1_NUMERATOR_NUM_SHIFT)) & ANADIG_PLL_SYS_PLL1_NUMERATOR_NUM_MASK)
/*! @} */

/*! @name SYS_PLL1_DIV_SELECT - SYS_PLL1_DIV_SELECT_REGISTER */
/*! @{ */

#define ANADIG_PLL_SYS_PLL1_DIV_SELECT_DIV_SELECT_MASK (0x7FU)
#define ANADIG_PLL_SYS_PLL1_DIV_SELECT_DIV_SELECT_SHIFT (0U)
/*! DIV_SELECT - DIV_SELECT
 */
#define ANADIG_PLL_SYS_PLL1_DIV_SELECT_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_SYS_PLL1_DIV_SELECT_DIV_SELECT_SHIFT)) & ANADIG_PLL_SYS_PLL1_DIV_SELECT_DIV_SELECT_MASK)
/*! @} */

/*! @name PLL_AUDIO_CTRL - PLL_AUDIO_CTRL_REGISTER */
/*! @{ */

#define ANADIG_PLL_PLL_AUDIO_CTRL_ENABLE_CLK_MASK (0x2000U)
#define ANADIG_PLL_PLL_AUDIO_CTRL_ENABLE_CLK_SHIFT (13U)
/*! ENABLE_CLK - ENABLE_CLK
 */
#define ANADIG_PLL_PLL_AUDIO_CTRL_ENABLE_CLK(x)  (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_AUDIO_CTRL_ENABLE_CLK_SHIFT)) & ANADIG_PLL_PLL_AUDIO_CTRL_ENABLE_CLK_MASK)

#define ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_GATE_MASK (0x4000U)
#define ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_GATE_SHIFT (14U)
/*! PLL_AUDIO_GATE - PLL_AUDIO_GATE
 *  0b1..Gate the output
 *  0b0..No gate
 */
#define ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_GATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_GATE_SHIFT)) & ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_GATE_MASK)

#define ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_STABLE_MASK (0x20000000U)
#define ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_STABLE_SHIFT (29U)
/*! PLL_AUDIO_STABLE - PLL_AUDIO_STABLE
 */
#define ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_STABLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_STABLE_SHIFT)) & ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_STABLE_MASK)

#define ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_AI_BUSY_MASK (0x40000000U)
#define ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_AI_BUSY_SHIFT (30U)
/*! PLL_AUDIO_AI_BUSY - pll_audio_ai_busy
 */
#define ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_AI_BUSY(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_AI_BUSY_SHIFT)) & ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_AI_BUSY_MASK)

#define ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_CONTROL_MODE_MASK (0x80000000U)
#define ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_CONTROL_MODE_SHIFT (31U)
/*! PLL_AUDIO_CONTROL_MODE - pll_audio_control_mode
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_CONTROL_MODE_SHIFT)) & ANADIG_PLL_PLL_AUDIO_CTRL_PLL_AUDIO_CONTROL_MODE_MASK)
/*! @} */

/*! @name PLL_AUDIO_SS - PLL_AUDIO_SS_REGISTER */
/*! @{ */

#define ANADIG_PLL_PLL_AUDIO_SS_STEP_MASK        (0x7FFFU)
#define ANADIG_PLL_PLL_AUDIO_SS_STEP_SHIFT       (0U)
/*! STEP - STEP
 */
#define ANADIG_PLL_PLL_AUDIO_SS_STEP(x)          (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_AUDIO_SS_STEP_SHIFT)) & ANADIG_PLL_PLL_AUDIO_SS_STEP_MASK)

#define ANADIG_PLL_PLL_AUDIO_SS_ENABLE_MASK      (0x8000U)
#define ANADIG_PLL_PLL_AUDIO_SS_ENABLE_SHIFT     (15U)
/*! ENABLE - ENABLE
 *  0b1..Enable Spread Spectrum
 *  0b0..Disable Spread Spectrum
 */
#define ANADIG_PLL_PLL_AUDIO_SS_ENABLE(x)        (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_AUDIO_SS_ENABLE_SHIFT)) & ANADIG_PLL_PLL_AUDIO_SS_ENABLE_MASK)

#define ANADIG_PLL_PLL_AUDIO_SS_STOP_MASK        (0xFFFF0000U)
#define ANADIG_PLL_PLL_AUDIO_SS_STOP_SHIFT       (16U)
/*! STOP - STOP
 */
#define ANADIG_PLL_PLL_AUDIO_SS_STOP(x)          (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_AUDIO_SS_STOP_SHIFT)) & ANADIG_PLL_PLL_AUDIO_SS_STOP_MASK)
/*! @} */

/*! @name PLL_AUDIO_DENOMINATOR - PLL_AUDIO_DENOMINATOR_REGISTER */
/*! @{ */

#define ANADIG_PLL_PLL_AUDIO_DENOMINATOR_DENOM_MASK (0x3FFFFFFFU)
#define ANADIG_PLL_PLL_AUDIO_DENOMINATOR_DENOM_SHIFT (0U)
/*! DENOM - DENOM
 */
#define ANADIG_PLL_PLL_AUDIO_DENOMINATOR_DENOM(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_AUDIO_DENOMINATOR_DENOM_SHIFT)) & ANADIG_PLL_PLL_AUDIO_DENOMINATOR_DENOM_MASK)
/*! @} */

/*! @name PLL_AUDIO_NUMERATOR - PLL_AUDIO_NUMERATOR_REGISTER */
/*! @{ */

#define ANADIG_PLL_PLL_AUDIO_NUMERATOR_NUM_MASK  (0x3FFFFFFFU)
#define ANADIG_PLL_PLL_AUDIO_NUMERATOR_NUM_SHIFT (0U)
/*! NUM - NUM
 */
#define ANADIG_PLL_PLL_AUDIO_NUMERATOR_NUM(x)    (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_AUDIO_NUMERATOR_NUM_SHIFT)) & ANADIG_PLL_PLL_AUDIO_NUMERATOR_NUM_MASK)
/*! @} */

/*! @name PLL_AUDIO_DIV_SELECT - PLL_AUDIO_DIV_SELECT_REGISTER */
/*! @{ */

#define ANADIG_PLL_PLL_AUDIO_DIV_SELECT_PLL_AUDIO_DIV_SELECT_MASK (0x7FU)
#define ANADIG_PLL_PLL_AUDIO_DIV_SELECT_PLL_AUDIO_DIV_SELECT_SHIFT (0U)
/*! PLL_AUDIO_DIV_SELECT - PLL_AUDIO_DIV_SELECT
 */
#define ANADIG_PLL_PLL_AUDIO_DIV_SELECT_PLL_AUDIO_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_AUDIO_DIV_SELECT_PLL_AUDIO_DIV_SELECT_SHIFT)) & ANADIG_PLL_PLL_AUDIO_DIV_SELECT_PLL_AUDIO_DIV_SELECT_MASK)
/*! @} */

/*! @name PLL_VIDEO_CTRL - PLL_VIDEO_CTRL_REGISTER */
/*! @{ */

#define ANADIG_PLL_PLL_VIDEO_CTRL_ENABLE_CLK_MASK (0x2000U)
#define ANADIG_PLL_PLL_VIDEO_CTRL_ENABLE_CLK_SHIFT (13U)
/*! ENABLE_CLK - ENABLE_CLK
 */
#define ANADIG_PLL_PLL_VIDEO_CTRL_ENABLE_CLK(x)  (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_VIDEO_CTRL_ENABLE_CLK_SHIFT)) & ANADIG_PLL_PLL_VIDEO_CTRL_ENABLE_CLK_MASK)

#define ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_GATE_MASK (0x4000U)
#define ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_GATE_SHIFT (14U)
/*! PLL_VIDEO_GATE - PLL_VIDEO_GATE
 *  0b1..Gate the output
 *  0b0..No gate
 */
#define ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_GATE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_GATE_SHIFT)) & ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_GATE_MASK)

#define ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_COUNTER_CLR_MASK (0x1000000U)
#define ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_COUNTER_CLR_SHIFT (24U)
/*! PLL_VIDEO_COUNTER_CLR - pll_video_counter_clr
 */
#define ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_COUNTER_CLR(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_COUNTER_CLR_SHIFT)) & ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_COUNTER_CLR_MASK)

#define ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_STABLE_MASK (0x20000000U)
#define ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_STABLE_SHIFT (29U)
/*! PLL_VIDEO_STABLE - PLL_VIDEO_STABLE
 */
#define ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_STABLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_STABLE_SHIFT)) & ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_STABLE_MASK)

#define ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_AI_BUSY_MASK (0x40000000U)
#define ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_AI_BUSY_SHIFT (30U)
/*! PLL_VIDEO_AI_BUSY - pll_video_ai_busy
 */
#define ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_AI_BUSY(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_AI_BUSY_SHIFT)) & ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_AI_BUSY_MASK)

#define ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_CONTROL_MODE_MASK (0x80000000U)
#define ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_CONTROL_MODE_SHIFT (31U)
/*! PLL_VIDEO_CONTROL_MODE - pll_video_control_mode
 *  0b0..Software Mode (Default)
 *  0b1..GPC Mode
 */
#define ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_CONTROL_MODE_SHIFT)) & ANADIG_PLL_PLL_VIDEO_CTRL_PLL_VIDEO_CONTROL_MODE_MASK)
/*! @} */

/*! @name PLL_VIDEO_SS - PLL_VIDEO_SS_REGISTER */
/*! @{ */

#define ANADIG_PLL_PLL_VIDEO_SS_STEP_MASK        (0x7FFFU)
#define ANADIG_PLL_PLL_VIDEO_SS_STEP_SHIFT       (0U)
/*! STEP - STEP
 */
#define ANADIG_PLL_PLL_VIDEO_SS_STEP(x)          (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_VIDEO_SS_STEP_SHIFT)) & ANADIG_PLL_PLL_VIDEO_SS_STEP_MASK)

#define ANADIG_PLL_PLL_VIDEO_SS_ENABLE_MASK      (0x8000U)
#define ANADIG_PLL_PLL_VIDEO_SS_ENABLE_SHIFT     (15U)
/*! ENABLE - ENABLE
 *  0b1..Enable Spread Spectrum
 *  0b0..Disable Spread Spectrum
 */
#define ANADIG_PLL_PLL_VIDEO_SS_ENABLE(x)        (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_VIDEO_SS_ENABLE_SHIFT)) & ANADIG_PLL_PLL_VIDEO_SS_ENABLE_MASK)

#define ANADIG_PLL_PLL_VIDEO_SS_STOP_MASK        (0xFFFF0000U)
#define ANADIG_PLL_PLL_VIDEO_SS_STOP_SHIFT       (16U)
/*! STOP - STOP
 */
#define ANADIG_PLL_PLL_VIDEO_SS_STOP(x)          (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_VIDEO_SS_STOP_SHIFT)) & ANADIG_PLL_PLL_VIDEO_SS_STOP_MASK)
/*! @} */

/*! @name PLL_VIDEO_DENOMINATOR - PLL_VIDEO_DENOMINATOR_REGISTER */
/*! @{ */

#define ANADIG_PLL_PLL_VIDEO_DENOMINATOR_DENOM_MASK (0x3FFFFFFFU)
#define ANADIG_PLL_PLL_VIDEO_DENOMINATOR_DENOM_SHIFT (0U)
/*! DENOM - DENOM
 */
#define ANADIG_PLL_PLL_VIDEO_DENOMINATOR_DENOM(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_VIDEO_DENOMINATOR_DENOM_SHIFT)) & ANADIG_PLL_PLL_VIDEO_DENOMINATOR_DENOM_MASK)
/*! @} */

/*! @name PLL_VIDEO_NUMERATOR - PLL_VIDEO_NUMERATOR_REGISTER */
/*! @{ */

#define ANADIG_PLL_PLL_VIDEO_NUMERATOR_NUM_MASK  (0x3FFFFFFFU)
#define ANADIG_PLL_PLL_VIDEO_NUMERATOR_NUM_SHIFT (0U)
/*! NUM - NUM
 */
#define ANADIG_PLL_PLL_VIDEO_NUMERATOR_NUM(x)    (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_VIDEO_NUMERATOR_NUM_SHIFT)) & ANADIG_PLL_PLL_VIDEO_NUMERATOR_NUM_MASK)
/*! @} */

/*! @name PLL_VIDEO_DIV_SELECT - PLL_VIDEO_DIV_SELECT_REGISTER */
/*! @{ */

#define ANADIG_PLL_PLL_VIDEO_DIV_SELECT_DIV_SELECT_MASK (0x7FU)
#define ANADIG_PLL_PLL_VIDEO_DIV_SELECT_DIV_SELECT_SHIFT (0U)
/*! DIV_SELECT - DIV_SELECT
 */
#define ANADIG_PLL_PLL_VIDEO_DIV_SELECT_DIV_SELECT(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PLL_PLL_VIDEO_DIV_SELECT_DIV_SELECT_SHIFT)) & ANADIG_PLL_PLL_VIDEO_DIV_SELECT_DIV_SELECT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ANADIG_PLL_Register_Masks */


/* ANADIG_PLL - Peripheral instance base addresses */
/** Peripheral ANADIG_PLL base address */
#define ANADIG_PLL_BASE                          (0x40C84000u)
/** Peripheral ANADIG_PLL base pointer */
#define ANADIG_PLL                               ((ANADIG_PLL_Type *)ANADIG_PLL_BASE)
/** Array initializer of ANADIG_PLL peripheral base addresses */
#define ANADIG_PLL_BASE_ADDRS                    { ANADIG_PLL_BASE }
/** Array initializer of ANADIG_PLL peripheral base pointers */
#define ANADIG_PLL_BASE_PTRS                     { ANADIG_PLL }

/*!
 * @}
 */ /* end of group ANADIG_PLL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ANADIG_PMU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_PMU_Peripheral_Access_Layer ANADIG_PMU Peripheral Access Layer
 * @{
 */

/** ANADIG_PMU - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[1280];
  __IO uint32_t PMU_LDO_PLL;                       /**< PMU_LDO_PLL_REGISTER, offset: 0x500 */
       uint8_t RESERVED_1[76];
  __IO uint32_t PMU_BIAS_CTRL;                     /**< PMU_BIAS_CTRL_REGISTER, offset: 0x550 */
       uint8_t RESERVED_2[12];
  __IO uint32_t PMU_BIAS_CTRL2;                    /**< PMU_BIAS_CTRL2_REGISTER, offset: 0x560 */
       uint8_t RESERVED_3[12];
  __IO uint32_t PMU_REF_CTRL;                      /**< PMU_REF_CTRL_REGISTER, offset: 0x570 */
       uint8_t RESERVED_4[12];
  __IO uint32_t PMU_POWER_DETECT_CTRL;             /**< PMU_POWER_DETECT_CTRL_REGISTER, offset: 0x580 */
       uint8_t RESERVED_5[124];
  __IO uint32_t LDO_PLL_ENABLE_SP;                 /**< LDO_PLL_ENABLE_SP_REGISTER, offset: 0x600 */
       uint8_t RESERVED_6[12];
  __IO uint32_t LDO_LPSR_ANA_ENABLE_SP;            /**< LDO_LPSR_ANA_ENABLE_SP_REGISTER, offset: 0x610 */
       uint8_t RESERVED_7[12];
  __IO uint32_t LDO_LPSR_ANA_LP_MODE_SP;           /**< LDO_LPSR_ANA_LP_MODE_SP_REGISTER, offset: 0x620 */
       uint8_t RESERVED_8[12];
  __IO uint32_t LDO_LPSR_ANA_TRACKING_EN_SP;       /**< LDO_LPSR_ANA_TRACKING_EN_SP_REGISTER, offset: 0x630 */
       uint8_t RESERVED_9[12];
  __IO uint32_t LDO_LPSR_ANA_BYPASS_EN_SP;         /**< LDO_LPSR_ANA_BYPASS_EN_SP_REGISTER, offset: 0x640 */
       uint8_t RESERVED_10[12];
  __IO uint32_t LDO_LPSR_ANA_STBY_EN_SP;           /**< LDO_LPSR_ANA_STBY_EN_SP_REGISTER, offset: 0x650 */
       uint8_t RESERVED_11[12];
  __IO uint32_t LDO_LPSR_DIG_ENABLE_SP;            /**< LDO_LPSR_DIG_ENABLE_SP_REGISTER, offset: 0x660 */
       uint8_t RESERVED_12[12];
  __IO uint32_t LDO_LPSR_DIG_TRG_SP0;              /**< LDO_LPSR_DIG_TRG_SP0_REGISTER, offset: 0x670 */
       uint8_t RESERVED_13[12];
  __IO uint32_t LDO_LPSR_DIG_TRG_SP1;              /**< LDO_LPSR_DIG_TRG_SP1_REGISTER, offset: 0x680 */
       uint8_t RESERVED_14[12];
  __IO uint32_t LDO_LPSR_DIG_TRG_SP2;              /**< LDO_LPSR_DIG_TRG_SP2_REGISTER, offset: 0x690 */
       uint8_t RESERVED_15[12];
  __IO uint32_t LDO_LPSR_DIG_TRG_SP3;              /**< LDO_LPSR_DIG_TRG_SP3_REGISTER, offset: 0x6A0 */
       uint8_t RESERVED_16[12];
  __IO uint32_t LDO_LPSR_DIG_LP_MODE_SP;           /**< LDO_LPSR_DIG_LP_MODE_SP_REGISTER, offset: 0x6B0 */
       uint8_t RESERVED_17[12];
  __IO uint32_t LDO_LPSR_DIG_TRACKING_EN_SP;       /**< LDO_LPSR_DIG_TRACKING_EN_SP_REGISTER, offset: 0x6C0 */
       uint8_t RESERVED_18[12];
  __IO uint32_t LDO_LPSR_DIG_BYPASS_EN_SP;         /**< LDO_LPSR_DIG_BYPASS_EN_SP_REGISTER, offset: 0x6D0 */
       uint8_t RESERVED_19[12];
  __IO uint32_t LDO_LPSR_DIG_STBY_EN_SP;           /**< LDO_LPSR_DIG_STBY_EN_SP_REGISTER, offset: 0x6E0 */
       uint8_t RESERVED_20[12];
  __IO uint32_t BANDGAP_ENABLE_SP;                 /**< BANDGAP_ENABLE_SP_REGISTER, offset: 0x6F0 */
       uint8_t RESERVED_21[12];
  __IO uint32_t FBB_M7_ENABLE_SP;                  /**< FBB_M7_ENABLE_SP_REGISTER, offset: 0x700 */
       uint8_t RESERVED_22[12];
  __IO uint32_t RBB_SOC_ENABLE_SP;                 /**< RBB_SOC_ENABLE_SP_REGISTER, offset: 0x710 */
       uint8_t RESERVED_23[12];
  __IO uint32_t RBB_LPSR_ENABLE_SP;                /**< RBB_LPSR_ENABLE_SP_REGISTER, offset: 0x720 */
       uint8_t RESERVED_24[12];
  __IO uint32_t BANDGAP_STBY_EN_SP;                /**< BANDGAP_STBY_EN_SP_REGISTER, offset: 0x730 */
       uint8_t RESERVED_25[12];
  __IO uint32_t PLL_LDO_STBY_EN_SP;                /**< PLL_LDO_STBY_EN_SP_REGISTER, offset: 0x740 */
       uint8_t RESERVED_26[12];
  __IO uint32_t FBB_M7_STBY_EN_SP;                 /**< FBB_M7_STBY_EN_SP_REGISTER, offset: 0x750 */
       uint8_t RESERVED_27[12];
  __IO uint32_t RBB_SOC_STBY_EN_SP;                /**< RBB_SOC_STBY_EN_SP_REGISTER, offset: 0x760 */
       uint8_t RESERVED_28[12];
  __IO uint32_t RBB_LPSR_STBY_EN_SP;               /**< RBB_LPSR_STBY_EN_SP_REGISTER, offset: 0x770 */
       uint8_t RESERVED_29[12];
  __IO uint32_t FBB_M7_CONFIGURE;                  /**< FBB_M7_CONFIGURE_REGISTER, offset: 0x780 */
       uint8_t RESERVED_30[12];
  __IO uint32_t RBB_LPSR_CONFIGURE;                /**< RBB_LPSR_CONFIGURE_REGISTER, offset: 0x790 */
       uint8_t RESERVED_31[12];
  __IO uint32_t RBB_SOC_CONFIGURE;                 /**< RBB_SOC_CONFIGURE_REGISTER, offset: 0x7A0 */
       uint8_t RESERVED_32[12];
  __I  uint32_t REFTOP_OTP_TRIM_VALUE;             /**< REFTOP_OTP_TRIM_VALUE_REGISTER, offset: 0x7B0 */
       uint8_t RESERVED_33[28];
  __I  uint32_t LPSR_1P8_LDO_OTP_TRIM_VALUE;       /**< LPSR_1P8_LDO_OTP_TRIM_VALUE_REGISTER, offset: 0x7D0 */
} ANADIG_PMU_Type;

/* ----------------------------------------------------------------------------
   -- ANADIG_PMU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_PMU_Register_Masks ANADIG_PMU Register Masks
 * @{
 */

/*! @name PMU_LDO_PLL - PMU_LDO_PLL_REGISTER */
/*! @{ */

#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_ENABLE_MASK (0x1U)
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_ENABLE_SHIFT (0U)
/*! LDO_PLL_ENABLE - LDO_PLL_ENABLE
 */
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_ENABLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_ENABLE_SHIFT)) & ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_ENABLE_MASK)

#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_CONTROL_MODE_MASK (0x2U)
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_CONTROL_MODE_SHIFT (1U)
/*! LDO_PLL_CONTROL_MODE - LDO_PLL_CONTROL_MODE
 *  0b0..SW Control
 *  0b1..HW Control
 */
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_CONTROL_MODE_SHIFT)) & ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_CONTROL_MODE_MASK)

#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_TOGGLE_MASK (0x10000U)
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_TOGGLE_SHIFT (16U)
/*! LDO_PLL_AI_TOGGLE - ldo_pll_ai_toggle
 */
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_TOGGLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_TOGGLE_SHIFT)) & ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_TOGGLE_MASK)

#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_BUSY_MASK (0x40000000U)
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_BUSY_SHIFT (30U)
/*! LDO_PLL_AI_BUSY - ldo_pll_busy
 */
#define ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_BUSY(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_BUSY_SHIFT)) & ANADIG_PMU_PMU_LDO_PLL_LDO_PLL_AI_BUSY_MASK)
/*! @} */

/*! @name PMU_BIAS_CTRL - PMU_BIAS_CTRL_REGISTER */
/*! @{ */

#define ANADIG_PMU_PMU_BIAS_CTRL_WB_CFG_1P8_MASK (0x1FFFU)
#define ANADIG_PMU_PMU_BIAS_CTRL_WB_CFG_1P8_SHIFT (0U)
/*! WB_CFG_1P8 - wb_cfg_1p8
 */
#define ANADIG_PMU_PMU_BIAS_CTRL_WB_CFG_1P8(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL_WB_CFG_1P8_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL_WB_CFG_1P8_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL_WB_VDD_SEL_1P8_MASK (0x4000U)
#define ANADIG_PMU_PMU_BIAS_CTRL_WB_VDD_SEL_1P8_SHIFT (14U)
/*! WB_VDD_SEL_1P8 - wb_vdd_sel_1p8
 *  0b0..VDD_LV1
 *  0b1..VDD_LV2
 */
#define ANADIG_PMU_PMU_BIAS_CTRL_WB_VDD_SEL_1P8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL_WB_VDD_SEL_1P8_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL_WB_VDD_SEL_1P8_MASK)
/*! @} */

/*! @name PMU_BIAS_CTRL2 - PMU_BIAS_CTRL2_REGISTER */
/*! @{ */

#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_MD_MASK (0x3FEU)
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_MD_SHIFT (1U)
/*! WB_TST_MD - TMOD_wb_tst_md_1p8
 */
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_MD(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_MD_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_MD_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_PWR_SW_EN_1P8_MASK (0x1C00U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_PWR_SW_EN_1P8_SHIFT (10U)
/*! WB_PWR_SW_EN_1P8 - MODSEL_wb_tst_md_1p8
 *  0b001..No BB
 *  0b010..BB
 *  0b100..BB
 */
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_PWR_SW_EN_1P8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_WB_PWR_SW_EN_1P8_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_WB_PWR_SW_EN_1P8_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_ADJ_1P8_MASK (0x1FE000U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_ADJ_1P8_SHIFT (13U)
/*! WB_ADJ_1P8 - wb_adj_1p8
 *  0b00000000..Cref= 0fF Cspl= 0fF DeltaC= 0fF
 *  0b00000001..Cref= 0fF Cspl= 30fF DeltaC= -30fF
 *  0b00000010..Cref= 0fF Cspl= 43fF DeltaC= -43fF
 *  0b00000011..Cref= 0fF Cspl= 62fF DeltaC=-62fF
 *  0b00000100..Cref= 0fF Cspl=105fF DeltaC=-105fF
 *  0b00000101..Cref= 30fF Cspl= 0fF DeltaC= 30fF
 *  0b00000110..Cref= 30fF Cspl= 43fF DeltaC= -12fF
 *  0b00000111..Cref= 30fF Cspl=105fF DeltaC= -75fF
 *  0b00001000..Cref= 43fF Cspl= 0fF DeltaC= 43fF
 *  0b00001001..Cref= 43fF Cspl= 30fF DeltaC= 13fF
 *  0b00001010..Cref= 43fF Cspl= 62fF DeltaC= -19fF
 *  0b00001011..Cref= 62fF Cspl= 0fF DeltaC= 62fF
 *  0b00001100..Cref= 62fF Cspl= 43fF DeltaC= 19fF
 *  0b00001101..Cref=105fF Cspl= 0fF DeltaC= 105fF
 *  0b00001110..Cref=105fF Cspl=30fF DeltaC= 75fF
 *  0b00001111..Cref=0fF Cspl=0fF DeltaC= 0fF
 */
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_ADJ_1P8(x)  (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_WB_ADJ_1P8_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_WB_ADJ_1P8_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_FBB_M7_CONTROL_MODE_MASK (0x200000U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_FBB_M7_CONTROL_MODE_SHIFT (21U)
/*! FBB_M7_CONTROL_MODE - FBB_M7_CONTROL_MODE
 *  0b0..SW Control
 *  0b1..HW Control
 */
#define ANADIG_PMU_PMU_BIAS_CTRL2_FBB_M7_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_FBB_M7_CONTROL_MODE_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_FBB_M7_CONTROL_MODE_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_RBB_SOC_CONTROL_MODE_MASK (0x400000U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_RBB_SOC_CONTROL_MODE_SHIFT (22U)
/*! RBB_SOC_CONTROL_MODE - RBB_SOC_CONTROL_MODE
 *  0b0..SW Control
 *  0b1..HW Control
 */
#define ANADIG_PMU_PMU_BIAS_CTRL2_RBB_SOC_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_RBB_SOC_CONTROL_MODE_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_RBB_SOC_CONTROL_MODE_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_RBB_LPSR_CONTROL_MODE_MASK (0x800000U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_RBB_LPSR_CONTROL_MODE_SHIFT (23U)
/*! RBB_LPSR_CONTROL_MODE - RBB_LPSR_CONTROL_MODE
 *  0b0..SW Control
 *  0b1..HW Control
 */
#define ANADIG_PMU_PMU_BIAS_CTRL2_RBB_LPSR_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_RBB_LPSR_CONTROL_MODE_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_RBB_LPSR_CONTROL_MODE_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_EN_MASK     (0x1000000U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_EN_SHIFT    (24U)
/*! WB_EN - wb_en
 */
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_EN(x)       (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_WB_EN_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_WB_EN_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_DIG_OUT_MASK (0x2000000U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_DIG_OUT_SHIFT (25U)
/*! WB_TST_DIG_OUT - Digital output
 */
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_DIG_OUT(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_DIG_OUT_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_WB_TST_DIG_OUT_MASK)

#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_OK_MASK     (0x4000000U)
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_OK_SHIFT    (26U)
/*! WB_OK - Digital Output pin.
 */
#define ANADIG_PMU_PMU_BIAS_CTRL2_WB_OK(x)       (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_BIAS_CTRL2_WB_OK_SHIFT)) & ANADIG_PMU_PMU_BIAS_CTRL2_WB_OK_MASK)
/*! @} */

/*! @name PMU_REF_CTRL - PMU_REF_CTRL_REGISTER */
/*! @{ */

#define ANADIG_PMU_PMU_REF_CTRL_REF_AI_TOGGLE_MASK (0x1U)
#define ANADIG_PMU_PMU_REF_CTRL_REF_AI_TOGGLE_SHIFT (0U)
/*! REF_AI_TOGGLE - ref_ai_toggle
 */
#define ANADIG_PMU_PMU_REF_CTRL_REF_AI_TOGGLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_REF_CTRL_REF_AI_TOGGLE_SHIFT)) & ANADIG_PMU_PMU_REF_CTRL_REF_AI_TOGGLE_MASK)

#define ANADIG_PMU_PMU_REF_CTRL_REF_AI_BUSY_MASK (0x2U)
#define ANADIG_PMU_PMU_REF_CTRL_REF_AI_BUSY_SHIFT (1U)
/*! REF_AI_BUSY - ref_ai_busy
 */
#define ANADIG_PMU_PMU_REF_CTRL_REF_AI_BUSY(x)   (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_REF_CTRL_REF_AI_BUSY_SHIFT)) & ANADIG_PMU_PMU_REF_CTRL_REF_AI_BUSY_MASK)

#define ANADIG_PMU_PMU_REF_CTRL_REF_ENABLE_MASK  (0x4U)
#define ANADIG_PMU_PMU_REF_CTRL_REF_ENABLE_SHIFT (2U)
/*! REF_ENABLE - REF_ENABLE
 */
#define ANADIG_PMU_PMU_REF_CTRL_REF_ENABLE(x)    (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_REF_CTRL_REF_ENABLE_SHIFT)) & ANADIG_PMU_PMU_REF_CTRL_REF_ENABLE_MASK)

#define ANADIG_PMU_PMU_REF_CTRL_REF_CONTROL_MODE_MASK (0x8U)
#define ANADIG_PMU_PMU_REF_CTRL_REF_CONTROL_MODE_SHIFT (3U)
/*! REF_CONTROL_MODE - REF_CONTROL_MODE
 *  0b0..SW Control
 *  0b1..HW Control
 */
#define ANADIG_PMU_PMU_REF_CTRL_REF_CONTROL_MODE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_REF_CTRL_REF_CONTROL_MODE_SHIFT)) & ANADIG_PMU_PMU_REF_CTRL_REF_CONTROL_MODE_MASK)

#define ANADIG_PMU_PMU_REF_CTRL_EN_PLL_VOL_REF_BUFFER_MASK (0x10U)
#define ANADIG_PMU_PMU_REF_CTRL_EN_PLL_VOL_REF_BUFFER_SHIFT (4U)
/*! EN_PLL_VOL_REF_BUFFER - en_pll_vol_ref_buffer
 */
#define ANADIG_PMU_PMU_REF_CTRL_EN_PLL_VOL_REF_BUFFER(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_REF_CTRL_EN_PLL_VOL_REF_BUFFER_SHIFT)) & ANADIG_PMU_PMU_REF_CTRL_EN_PLL_VOL_REF_BUFFER_MASK)
/*! @} */

/*! @name PMU_POWER_DETECT_CTRL - PMU_POWER_DETECT_CTRL_REGISTER */
/*! @{ */

#define ANADIG_PMU_PMU_POWER_DETECT_CTRL_CKGB_LPSR1P0_MASK (0x100U)
#define ANADIG_PMU_PMU_POWER_DETECT_CTRL_CKGB_LPSR1P0_SHIFT (8U)
/*! CKGB_LPSR1P0 - ckgb_lpsr1p0
 */
#define ANADIG_PMU_PMU_POWER_DETECT_CTRL_CKGB_LPSR1P0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PMU_POWER_DETECT_CTRL_CKGB_LPSR1P0_SHIFT)) & ANADIG_PMU_PMU_POWER_DETECT_CTRL_CKGB_LPSR1P0_MASK)
/*! @} */

/*! @name LDO_PLL_ENABLE_SP - LDO_PLL_ENABLE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT (0U)
/*! ON_OFF_SETPOINT0 - ON_OFF_SETPOINT0
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT (1U)
/*! ON_OFF_SETPOINT1 - ON_OFF_SETPOINT1
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT (2U)
/*! ON_OFF_SETPOINT2 - ON_OFF_SETPOINT2
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT (3U)
/*! ON_OFF_SETPOINT3 - ON_OFF_SETPOINT3
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT (4U)
/*! ON_OFF_SETPOINT4 - ON_OFF_SETPOINT4
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT (5U)
/*! ON_OFF_SETPOINT5 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT (6U)
/*! ON_OFF_SETPOINT6 - ON_OFF_SETPOINT6
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT (7U)
/*! ON_OFF_SETPOINT7 - ON_OFF_SETPOINT7
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT (8U)
/*! ON_OFF_SETPOINT8 - ON_OFF_SETPOINT8
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT (9U)
/*! ON_OFF_SETPOINT9 - ON_OFF_SETPOINT9
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT (10U)
/*! ON_OFF_SETPOINT10 - ON_OFF_SETPOINT10
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT (11U)
/*! ON_OFF_SETPOINT11 - ON_OFF_SETPOINT11
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT (12U)
/*! ON_OFF_SETPOINT12 - ON_OFF_SETPOINT12
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT (13U)
/*! ON_OFF_SETPOINT13 - ON_OFF_SETPOINT13
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT (14U)
/*! ON_OFF_SETPOINT14 - ON_OFF_SETPOINT14
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT (15U)
/*! ON_OFF_SETPOINT15 - ON_OFF_SETPOINT15
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_PLL_ENABLE_SP_ON_OFF_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_ANA_ENABLE_SP - LDO_LPSR_ANA_ENABLE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT (0U)
/*! ON_OFF_SETPOINT0 - ON_OFF_SETPOINT0
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT (1U)
/*! ON_OFF_SETPOINT1 - ON_OFF_SETPOINT1
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT (2U)
/*! ON_OFF_SETPOINT2 - ON_OFF_SETPOINT2
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT (3U)
/*! ON_OFF_SETPOINT3 - ON_OFF_SETPOINT3
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT (4U)
/*! ON_OFF_SETPOINT4 - ON_OFF_SETPOINT4
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT (5U)
/*! ON_OFF_SETPOINT5 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT (6U)
/*! ON_OFF_SETPOINT6 - ON_OFF_SETPOINT6
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT (7U)
/*! ON_OFF_SETPOINT7 - ON_OFF_SETPOINT7
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT (8U)
/*! ON_OFF_SETPOINT8 - ON_OFF_SETPOINT8
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT (9U)
/*! ON_OFF_SETPOINT9 - ON_OFF_SETPOINT9
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT (10U)
/*! ON_OFF_SETPOINT10 - ON_OFF_SETPOINT10
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT (11U)
/*! ON_OFF_SETPOINT11 - ON_OFF_SETPOINT11
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT (12U)
/*! ON_OFF_SETPOINT12 - ON_OFF_SETPOINT12
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT (13U)
/*! ON_OFF_SETPOINT13 - ON_OFF_SETPOINT13
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT (14U)
/*! ON_OFF_SETPOINT14 - ON_OFF_SETPOINT14
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT (15U)
/*! ON_OFF_SETPOINT15 - ON_OFF_SETPOINT15
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_ENABLE_SP_ON_OFF_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_ANA_LP_MODE_SP - LDO_LPSR_ANA_LP_MODE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT0_SHIFT (0U)
/*! LP_MODE_SETPOINT0 - LP_MODE_SETPOINT0
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT1_SHIFT (1U)
/*! LP_MODE_SETPOINT1 - LP_MODE_SETPOINT1
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT2_SHIFT (2U)
/*! LP_MODE_SETPONIT2 - LP_MODE_SETPOINT2
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT2_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT3_SHIFT (3U)
/*! LP_MODE_SETPONIT3 - LP_MODE_SETPOINT3
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT3_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT4_SHIFT (4U)
/*! LP_MODE_SETPONIT4 - LP_MODE_SETPOINT4
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT4_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT5_SHIFT (5U)
/*! LP_MODE_SETPONIT5 - LP_MODE_SETPOINT5
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT5_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT6_SHIFT (6U)
/*! LP_MODE_SETPONIT6 - LP_MODE_SETPOINT6
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT6_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT7_SHIFT (7U)
/*! LP_MODE_SETPONIT7 - LP_MODE_SETPOINT7
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT7_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT8_SHIFT (8U)
/*! LP_MODE_SETPONIT8 - LP_MODE_SETPOINT8
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT8_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT9_SHIFT (9U)
/*! LP_MODE_SETPONIT9 - LP_MODE_SETPOINT9
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT9_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT10_SHIFT (10U)
/*! LP_MODE_SETPONIT10 - LP_MODE_SETPOINT10
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT10_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT11_SHIFT (11U)
/*! LP_MODE_SETPONIT11 - LP_MODE_SETPOINT11
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT11_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT12_SHIFT (12U)
/*! LP_MODE_SETPONIT12 - LP_MODE_SETPOINT12
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT12_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT13_SHIFT (13U)
/*! LP_MODE_SETPONIT13 - LP_MODE_SETPOINT13
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT13_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT14_SHIFT (14U)
/*! LP_MODE_SETPONIT14 - LP_MODE_SETPOINT14
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT14_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT15_SHIFT (15U)
/*! LP_MODE_SETPONIT15 - LP_MODE_SETPOINT15
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_LP_MODE_SP_LP_MODE_SETPONIT15_MASK)
/*! @} */

/*! @name LDO_LPSR_ANA_TRACKING_EN_SP - LDO_LPSR_ANA_TRACKING_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_SHIFT (0U)
/*! TRACKING_EN_SETPOINT0 - TRACKING_EN_SETPOINT0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_SHIFT (1U)
/*! TRACKING_EN_SETPOINT1 - TRACKING_EN_SETPOINT1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_SHIFT (2U)
/*! TRACKING_EN_SETPOINT2 - TRACKING_EN_SETPOINT2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_SHIFT (3U)
/*! TRACKING_EN_SETPOINT3 - TRACKING_EN_SETPOINT3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_SHIFT (4U)
/*! TRACKING_EN_SETPOINT4 - TRACKING_EN_SETPOINT4
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_SHIFT (5U)
/*! TRACKING_EN_SETPOINT5 - TRACKING_EN_SETPOINT5
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_SHIFT (6U)
/*! TRACKING_EN_SETPOINT6 - TRACKING_EN_SETPOINT6
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_SHIFT (7U)
/*! TRACKING_EN_SETPOINT7 - TRACKING_EN_SETPOINT7
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_SHIFT (8U)
/*! TRACKING_EN_SETPOINT8 - TRACKING_EN_SETPOINT8
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_SHIFT (9U)
/*! TRACKING_EN_SETPOINT9 - TRACKING_EN_SETPOINT9
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_SHIFT (10U)
/*! TRACKING_EN_SETPOINT10 - TRACKING_EN_SETPOINT10
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_SHIFT (11U)
/*! TRACKING_EN_SETPOINT11 - TRACKING_EN_SETPOINT11
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_SHIFT (12U)
/*! TRACKING_EN_SETPOINT12 - TRACKING_EN_SETPOINT12
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_SHIFT (13U)
/*! TRACKING_EN_SETPOINT13 - TRACKING_EN_SETPOINT13
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_SHIFT (14U)
/*! TRACKING_EN_SETPOINT14 - TRACKING_EN_SETPOINT14
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_SHIFT (15U)
/*! TRACKING_EN_SETPOINT15 - TRACKING_EN_SETPOINT15
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_ANA_BYPASS_EN_SP - LDO_LPSR_ANA_BYPASS_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_SHIFT (0U)
/*! BYPASS_EN_SETPOINT0 - BYPASS_EN_SETPOINT0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_SHIFT (1U)
/*! BYPASS_EN_SETPOINT1 - BYPASS_EN_SETPOINT1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_SHIFT (2U)
/*! BYPASS_EN_SETPOINT2 - BYPASS_EN_SETPOINT2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_SHIFT (3U)
/*! BYPASS_EN_SETPOINT3 - BYPASS_EN_SETPOINT3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_SHIFT (4U)
/*! BYPASS_EN_SETPOINT4 - BYPASS_EN_SETPOINT4
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_SHIFT (5U)
/*! BYPASS_EN_SETPOINT5 - BYPASS_EN_SETPOINT5
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_SHIFT (6U)
/*! BYPASS_EN_SETPOINT6 - BYPASS_EN_SETPOINT6
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_SHIFT (7U)
/*! BYPASS_EN_SETPOINT7 - BYPASS_EN_SETPOINT7
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_SHIFT (8U)
/*! BYPASS_EN_SETPOINT8 - BYPASS_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_SHIFT (9U)
/*! BYPASS_EN_SETPOINT9 - BYPASS_EN_SETPOINT9
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_SHIFT (10U)
/*! BYPASS_EN_SETPOINT10 - BYPASS_EN_SETPOINT10
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_SHIFT (11U)
/*! BYPASS_EN_SETPOINT11 - BYPASS_EN_SETPOINT11
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_SHIFT (12U)
/*! BYPASS_EN_SETPOINT12 - BYPASS_EN_SETPOINT12
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_SHIFT (13U)
/*! BYPASS_EN_SETPOINT13 - BYPASS_EN_SETPOINT13
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_SHIFT (14U)
/*! BYPASS_EN_SETPOINT14 - BYPASS_EN_SETPOINT14
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_SHIFT (15U)
/*! BYPASS_EN_SETPOINT15 - BYPASS_EN_SETPOINT15
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_ANA_STBY_EN_SP - LDO_LPSR_ANA_STBY_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT (0U)
/*! STBY_EN_SETPOINT0 - STBY_EN_SETPOINT0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT (1U)
/*! STBY_EN_SETPOINT1 - STBY_EN_SETPOINT1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT (2U)
/*! STBY_EN_SETPOINT2 - STBY_EN_SETPOINT2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT (3U)
/*! STBY_EN_SETPOINT3 - STBY_EN_SETPOINT3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT (4U)
/*! STBY_EN_SETPOINT4 - STBY_EN_SETPOINT4
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT (5U)
/*! STBY_EN_SETPOINT5 - STBY_EN_SETPOINT5
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT (6U)
/*! STBY_EN_SETPOINT6 - STBY_EN_SETPOINT6
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT (7U)
/*! STBY_EN_SETPOINT7 - STBY_EN_SETPOINT7
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT (8U)
/*! STBY_EN_SETPOINT8 - STBY_EN_SETPOINT8
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT (9U)
/*! STBY_EN_SETPOINT9 - STBY_EN_SETPOINT9
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT (10U)
/*! STBY_EN_SETPOINT10 - STBY_EN_SETPOINT10
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT (11U)
/*! STBY_EN_SETPOINT11 - STBY_EN_SETPOINT11
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT (12U)
/*! STBY_EN_SETPOINT12 - STBY_EN_SETPOINT12
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT (13U)
/*! STBY_EN_SETPOINT13 - STBY_EN_SETPOINT13
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT (14U)
/*! STBY_EN_SETPOINT14 - STBY_EN_SETPOINT14
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT (15U)
/*! STBY_EN_SETPOINT15 - STBY_EN_SETPOINT15
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_ANA_STBY_EN_SP_STBY_EN_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_ENABLE_SP - LDO_LPSR_DIG_ENABLE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT (0U)
/*! ON_OFF_SETPOINT0 - ON_OFF_SETPOINT0
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT (1U)
/*! ON_OFF_SETPOINT1 - ON_OFF_SETPOINT1
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT (2U)
/*! ON_OFF_SETPOINT2 - ON_OFF_SETPOINT2
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT (3U)
/*! ON_OFF_SETPOINT3 - ON_OFF_SETPOINT3
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT (4U)
/*! ON_OFF_SETPOINT4 - ON_OFF_SETPOINT4
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT (5U)
/*! ON_OFF_SETPOINT5 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT (6U)
/*! ON_OFF_SETPOINT6 - ON_OFF_SETPOINT6
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT (7U)
/*! ON_OFF_SETPOINT7 - ON_OFF_SETPOINT7
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT (8U)
/*! ON_OFF_SETPOINT8 - ON_OFF_SETPOINT8
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT (9U)
/*! ON_OFF_SETPOINT9 - ON_OFF_SETPOINT9
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT (10U)
/*! ON_OFF_SETPOINT10 - ON_OFF_SETPOINT10
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT (11U)
/*! ON_OFF_SETPOINT11 - ON_OFF_SETPOINT11
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT (12U)
/*! ON_OFF_SETPOINT12 - ON_OFF_SETPOINT12
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT (13U)
/*! ON_OFF_SETPOINT13 - ON_OFF_SETPOINT13
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT (14U)
/*! ON_OFF_SETPOINT14 - ON_OFF_SETPOINT14
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT (15U)
/*! ON_OFF_SETPOINT15 - ON_OFF_SETPOINT15
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_ENABLE_SP_ON_OFF_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_TRG_SP0 - LDO_LPSR_DIG_TRG_SP0_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT0_MASK (0xFFU)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT0_SHIFT (0U)
/*! VOLTAGE_SETPOINT0 - VOLTAGE_SETPOINT0
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT1_MASK (0xFF00U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT1_SHIFT (8U)
/*! VOLTAGE_SETPOINT1 - VOLTAGE_SETPOINT1
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT2_MASK (0xFF0000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT2_SHIFT (16U)
/*! VOLTAGE_SETPOINT2 - VOLTAGE_SETPOINT2
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT3_MASK (0xFF000000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT3_SHIFT (24U)
/*! VOLTAGE_SETPOINT3 - VOLTAGE_SETPOINT3
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP0_VOLTAGE_SETPOINT3_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_TRG_SP1 - LDO_LPSR_DIG_TRG_SP1_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT4_MASK (0xFFU)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT4_SHIFT (0U)
/*! VOLTAGE_SETPOINT4 - VOLTAGE_SETPOINT4
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT5_MASK (0xFF00U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT5_SHIFT (8U)
/*! VOLTAGE_SETPOINT5 - VOLTAGE_SETPOINT5
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT6_MASK (0xFF0000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT6_SHIFT (16U)
/*! VOLTAGE_SETPOINT6 - VOLTAGE_SETPOINT6
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT7_MASK (0xFF000000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT7_SHIFT (24U)
/*! VOLTAGE_SETPOINT7 - VOLTAGE_SETPOINT7
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP1_VOLTAGE_SETPOINT7_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_TRG_SP2 - LDO_LPSR_DIG_TRG_SP2_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT8_MASK (0xFFU)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT8_SHIFT (0U)
/*! VOLTAGE_SETPOINT8 - VOLTAGE_SETPOINT8
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT9_MASK (0xFF00U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT9_SHIFT (8U)
/*! VOLTAGE_SETPOINT9 - VOLTAGE_SETPOINT9
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT10_MASK (0xFF0000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT10_SHIFT (16U)
/*! VOLTAGE_SETPOINT10 - VOLTAGE_SETPOINT10
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT11_MASK (0xFF000000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT11_SHIFT (24U)
/*! VOLTAGE_SETPOINT11 - VOLTAGE_SETPOINT11
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP2_VOLTAGE_SETPOINT11_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_TRG_SP3 - LDO_LPSR_DIG_TRG_SP3_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT12_MASK (0xFFU)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT12_SHIFT (0U)
/*! VOLTAGE_SETPOINT12 - VOLTAGE_SETPOINT12
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT13_MASK (0xFF00U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT13_SHIFT (8U)
/*! VOLTAGE_SETPOINT13 - VOLTAGE_SETPOINT13
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT14_MASK (0xFF0000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT14_SHIFT (16U)
/*! VOLTAGE_SETPOINT14 - VOLTAGE_SETPOINT14
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT15_MASK (0xFF000000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT15_SHIFT (24U)
/*! VOLTAGE_SETPOINT15 - VOLTAGE_SETPOINT15
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRG_SP3_VOLTAGE_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_LP_MODE_SP - LDO_LPSR_DIG_LP_MODE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT0_SHIFT (0U)
/*! LP_MODE_SETPOINT0 - LP_MODE_SETPOINT0
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT1_SHIFT (1U)
/*! LP_MODE_SETPOINT1 - LP_MODE_SETPOINT1
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT2_SHIFT (2U)
/*! LP_MODE_SETPOINT2 - LP_MODE_SETPOINT2
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT3_SHIFT (3U)
/*! LP_MODE_SETPOINT3 - LP_MODE_SETPOINT3
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT4_SHIFT (4U)
/*! LP_MODE_SETPOINT4 - LP_MODE_SETPOINT4
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT5_SHIFT (5U)
/*! LP_MODE_SETPOINT5 - LP_MODE_SETPOINT5
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT6_SHIFT (6U)
/*! LP_MODE_SETPOINT6 - LP_MODE_SETPOINT6
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT7_SHIFT (7U)
/*! LP_MODE_SETPOINT7 - LP_MODE_SETPOINT7
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT8_SHIFT (8U)
/*! LP_MODE_SETPOINT8 - LP_MODE_SETPOINT8
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT9_SHIFT (9U)
/*! LP_MODE_SETPOINT9 - LP_MODE_SETPOINT9
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT10_SHIFT (10U)
/*! LP_MODE_SETPOINT10 - LP_MODE_SETPOINT10
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT11_SHIFT (11U)
/*! LP_MODE_SETPOINT11 - LP_MODE_SETPOINT11
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT12_SHIFT (12U)
/*! LP_MODE_SETPOINT12 - LP_MODE_SETPOINT12
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT13_SHIFT (13U)
/*! LP_MODE_SETPOINT13 - LP_MODE_SETPOINT13
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT14_SHIFT (14U)
/*! LP_MODE_SETPOINT14 - LP_MODE_SETPOINT14
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT15_SHIFT (15U)
/*! LP_MODE_SETPOINT15 - LP_MODE_SETPOINT15
 *  0b0..LP
 *  0b1..HP
 */
#define ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_LP_MODE_SP_LP_MODE_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_TRACKING_EN_SP - LDO_LPSR_DIG_TRACKING_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_SHIFT (0U)
/*! TRACKING_EN_SETPOINT0 - TRACKING_EN_SETPOINT0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_SHIFT (1U)
/*! TRACKING_EN_SETPOINT1 - TRACKING_EN_SETPOINT1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_SHIFT (2U)
/*! TRACKING_EN_SETPOINT2 - TRACKING_EN_SETPOINT2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_SHIFT (3U)
/*! TRACKING_EN_SETPOINT3 - TRACKING_EN_SETPOINT3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_SHIFT (4U)
/*! TRACKING_EN_SETPOINT4 - TRACKING_EN_SETPOINT4
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_SHIFT (5U)
/*! TRACKING_EN_SETPOINT5 - TRACKING_EN_SETPOINT5
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_SHIFT (6U)
/*! TRACKING_EN_SETPOINT6 - TRACKING_EN_SETPOINT6
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_SHIFT (7U)
/*! TRACKING_EN_SETPOINT7 - TRACKING_EN_SETPOINT7
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_SHIFT (8U)
/*! TRACKING_EN_SETPOINT8 - TRACKING_EN_SETPOINT8
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_SHIFT (9U)
/*! TRACKING_EN_SETPOINT9 - TRACKING_EN_SETPOINT9
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_SHIFT (10U)
/*! TRACKING_EN_SETPOINT10 - TRACKING_EN_SETPOINT10
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_SHIFT (11U)
/*! TRACKING_EN_SETPOINT11 - TRACKING_EN_SETPOINT11
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_SHIFT (12U)
/*! TRACKING_EN_SETPOINT12 - TRACKING_EN_SETPOINT12
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_SHIFT (13U)
/*! TRACKING_EN_SETPOINT13 - TRACKING_EN_SETPOINT13
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_SHIFT (14U)
/*! TRACKING_EN_SETPOINT14 - TRACKING_EN_SETPOINT14
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_SHIFT (15U)
/*! TRACKING_EN_SETPOINT15 - TRACKING_EN_SETPOINT15
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_TRACKING_EN_SP_TRACKING_EN_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_BYPASS_EN_SP - LDO_LPSR_DIG_BYPASS_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_SHIFT (0U)
/*! BYPASS_EN_SETPOINT0 - BYPASS_EN_SETPOINT0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_SHIFT (1U)
/*! BYPASS_EN_SETPOINT1 - BYPASS_EN_SETPOINT1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_SHIFT (2U)
/*! BYPASS_EN_SETPOINT2 - BYPASS_EN_SETPOINT2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_SHIFT (3U)
/*! BYPASS_EN_SETPOINT3 - BYPASS_EN_SETPOINT3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_SHIFT (4U)
/*! BYPASS_EN_SETPOINT4 - BYPASS_EN_SETPOINT4
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_SHIFT (5U)
/*! BYPASS_EN_SETPOINT5 - BYPASS_EN_SETPOINT5
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_SHIFT (6U)
/*! BYPASS_EN_SETPOINT6 - BYPASS_EN_SETPOINT6
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_SHIFT (7U)
/*! BYPASS_EN_SETPOINT7 - BYPASS_EN_SETPOINT7
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_SHIFT (8U)
/*! BYPASS_EN_SETPOINT8 - BYPASS_EN_SETPOINT8
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_SHIFT (9U)
/*! BYPASS_EN_SETPOINT9 - BYPASS_EN_SETPOINT9
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_SHIFT (10U)
/*! BYPASS_EN_SETPOINT10 - BYPASS_EN_SETPOINT10
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_SHIFT (11U)
/*! BYPASS_EN_SETPOINT11 - BYPASS_EN_SETPOINT11
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_SHIFT (12U)
/*! BYPASS_EN_SETPOINT12 - BYPASS_EN_SETPOINT12
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_SHIFT (13U)
/*! BYPASS_EN_SETPOINT13 - BYPASS_EN_SETPOINT13
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_SHIFT (14U)
/*! BYPASS_EN_SETPOINT14 - BYPASS_EN_SETPOINT14
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_SHIFT (15U)
/*! BYPASS_EN_SETPOINT15 - BYPASS_EN_SETPOINT15
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_BYPASS_EN_SP_BYPASS_EN_SETPOINT15_MASK)
/*! @} */

/*! @name LDO_LPSR_DIG_STBY_EN_SP - LDO_LPSR_DIG_STBY_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT (0U)
/*! STBY_EN_SETPOINT0 - STBY_EN_SETPOINT0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT0_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT (1U)
/*! STBY_EN_SETPOINT1 - STBY_EN_SETPOINT1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT1_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT (2U)
/*! STBY_EN_SETPOINT2 - STBY_EN_SETPOINT2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT2_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT (3U)
/*! STBY_EN_SETPOINT3 - STBY_EN_SETPOINT3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT3_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT (4U)
/*! STBY_EN_SETPOINT4 - STBY_EN_SETPOINT4
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT4_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT (5U)
/*! STBY_EN_SETPOINT5 - STBY_EN_SETPOINT5
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT5_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT (6U)
/*! STBY_EN_SETPOINT6 - STBY_EN_SETPOINT6
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT6_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT (7U)
/*! STBY_EN_SETPOINT7 - STBY_EN_SETPOINT7
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT7_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT (8U)
/*! STBY_EN_SETPOINT8 - STBY_EN_SETPOINT8
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT8_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT (9U)
/*! STBY_EN_SETPOINT9 - STBY_EN_SETPOINT9
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT9_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT (10U)
/*! STBY_EN_SETPOINT10 - STBY_EN_SETPOINT10
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT10_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT (11U)
/*! STBY_EN_SETPOINT11 - STBY_EN_SETPOINT11
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT11_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT (12U)
/*! STBY_EN_SETPOINT12 - STBY_EN_SETPOINT12
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT12_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT (13U)
/*! STBY_EN_SETPOINT13 - STBY_EN_SETPOINT13
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT13_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT (14U)
/*! STBY_EN_SETPOINT14 - STBY_EN_SETPOINT14
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT14_MASK)

#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT (15U)
/*! STBY_EN_SETPOINT15 - STBY_EN_SETPOINT15
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_LDO_LPSR_DIG_STBY_EN_SP_STBY_EN_SETPOINT15_MASK)
/*! @} */

/*! @name BANDGAP_ENABLE_SP - BANDGAP_ENABLE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT (0U)
/*! ON_OFF_SETPOINT0 - ON_OFF_SETPOINT0
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT0_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT (1U)
/*! ON_OFF_SETPOINT1 - ON_OFF_SETPOINT1
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT1_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT (2U)
/*! ON_OFF_SETPOINT2 - ON_OFF_SETPOINT2
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT2_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT (3U)
/*! ON_OFF_SETPOINT3 - ON_OFF_SETPOINT3
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT3_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT (4U)
/*! ON_OFF_SETPOINT4 - ON_OFF_SETPOINT4
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT4_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT (5U)
/*! ON_OFF_SETPOINT5 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT5_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT (6U)
/*! ON_OFF_SETPOINT6 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT6_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT (7U)
/*! ON_OFF_SETPOINT7 - ON_OFF_SETPOINT7
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT7_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT (8U)
/*! ON_OFF_SETPOINT8 - ON_OFF_SETPOINT8
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT8_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT (9U)
/*! ON_OFF_SETPOINT9 - ON_OFF_SETPOINT9
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT9_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT (10U)
/*! ON_OFF_SETPOINT10 - ON_OFF_SETPOINT10
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT10_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT (11U)
/*! ON_OFF_SETPOINT11 - ON_OFF_SETPOINT11
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT11_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT (12U)
/*! ON_OFF_SETPOINT12 - ON_OFF_SETPOINT12
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT12_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT (13U)
/*! ON_OFF_SETPOINT13 - ON_OFF_SETPOINT13
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT13_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT (14U)
/*! ON_OFF_SETPOINT14 - ON_OFF_SETPOINT14
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT14_MASK)

#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT (15U)
/*! ON_OFF_SETPOINT15 - ON_OFF_SETPOINT15
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT)) & ANADIG_PMU_BANDGAP_ENABLE_SP_ON_OFF_SETPOINT15_MASK)
/*! @} */

/*! @name FBB_M7_ENABLE_SP - FBB_M7_ENABLE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT (0U)
/*! ON_OFF_SETPOINT0 - ON_OFF_SETPOINT0
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT0_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT (1U)
/*! ON_OFF_SETPOINT1 - ON_OFF_SETPOINT1
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT1_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT (2U)
/*! ON_OFF_SETPOINT2 - ON_OFF_SETPOINT2
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT2_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT (3U)
/*! ON_OFF_SETPOINT3 - ON_OFF_SETPOINT3
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT3_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT (4U)
/*! ON_OFF_SETPOINT4 - ON_OFF_SETPOINT4
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT4_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT (5U)
/*! ON_OFF_SETPOINT5 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT5_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT (6U)
/*! ON_OFF_SETPOINT6 - ON_OFF_SETPOINT6
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT6_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT (7U)
/*! ON_OFF_SETPOINT7 - ON_OFF_SETPOINT7
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT7_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT (8U)
/*! ON_OFF_SETPOINT8 - ON_OFF_SETPOINT8
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT8_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT (9U)
/*! ON_OFF_SETPOINT9 - ON_OFF_SETPOINT9
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT9_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT (10U)
/*! ON_OFF_SETPOINT10 - ON_OFF_SETPOINT10
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT10_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT (11U)
/*! ON_OFF_SETPOINT11 - ON_OFF_SETPOINT11
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT11_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT (12U)
/*! ON_OFF_SETPOINT12 - ON_OFF_SETPOINT12
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT12_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT (13U)
/*! ON_OFF_SETPOINT13 - ON_OFF_SETPOINT13
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT13_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT (14U)
/*! ON_OFF_SETPOINT14 - ON_OFF_SETPOINT14
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT14_MASK)

#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT (15U)
/*! ON_OFF_SETPOINT15 - ON_OFF_SETPOINT15
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT)) & ANADIG_PMU_FBB_M7_ENABLE_SP_ON_OFF_SETPOINT15_MASK)
/*! @} */

/*! @name RBB_SOC_ENABLE_SP - RBB_SOC_ENABLE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT (0U)
/*! ON_OFF_SETPOINT0 - ON_OFF_SETPOINT0
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT0_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT (1U)
/*! ON_OFF_SETPOINT1 - ON_OFF_SETPOINT1
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT1_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT (2U)
/*! ON_OFF_SETPOINT2 - ON_OFF_SETPOINT2
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT2_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT (3U)
/*! ON_OFF_SETPOINT3 - ON_OFF_SETPOINT3
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT3_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT (4U)
/*! ON_OFF_SETPOINT4 - ON_OFF_SETPOINT4
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT4_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT (5U)
/*! ON_OFF_SETPOINT5 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT5_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT (6U)
/*! ON_OFF_SETPOINT6 - ON_OFF_SETPOINT6
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT6_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT (7U)
/*! ON_OFF_SETPOINT7 - ON_OFF_SETPOINT7
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT7_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT (8U)
/*! ON_OFF_SETPOINT8 - ON_OFF_SETPOINT8
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT8_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT (9U)
/*! ON_OFF_SETPOINT9 - ON_OFF_SETPOINT9
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT9_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT (10U)
/*! ON_OFF_SETPOINT10 - ON_OFF_SETPOINT10
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT10_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT (11U)
/*! ON_OFF_SETPOINT11 - ON_OFF_SETPOINT11
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT11_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT (12U)
/*! ON_OFF_SETPOINT12 - ON_OFF_SETPOINT12
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT12_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT (13U)
/*! ON_OFF_SETPOINT13 - ON_OFF_SETPOINT13
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT13_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT (14U)
/*! ON_OFF_SETPOINT14 - ON_OFF_SETPOINT14
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT14_MASK)

#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT (15U)
/*! ON_OFF_SETPOINT15 - ON_OFF_SETPOINT15
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT)) & ANADIG_PMU_RBB_SOC_ENABLE_SP_ON_OFF_SETPOINT15_MASK)
/*! @} */

/*! @name RBB_LPSR_ENABLE_SP - RBB_LPSR_ENABLE_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT (0U)
/*! ON_OFF_SETPOINT0 - ON_OFF_SETPOINT0
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT0_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT0_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT (1U)
/*! ON_OFF_SETPOINT1 - ON_OFF_SETPOINT1
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT1_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT1_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT (2U)
/*! ON_OFF_SETPOINT2 - ON_OFF_SETPOINT2
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT2_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT2_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT (3U)
/*! ON_OFF_SETPOINT3 - ON_OFF_SETPOINT3
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT3_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT3_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT (4U)
/*! ON_OFF_SETPOINT4 - ON_OFF_SETPOINT4
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT4_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT4_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT (5U)
/*! ON_OFF_SETPOINT5 - ON_OFF_SETPOINT5
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT5_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT5_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT (6U)
/*! ON_OFF_SETPOINT6 - ON_OFF_SETPOINT6
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT6_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT6_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT (7U)
/*! ON_OFF_SETPOINT7 - ON_OFF_SETPOINT7
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT7_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT7_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT (8U)
/*! ON_OFF_SETPOINT8 - ON_OFF_SETPOINT8
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT8_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT8_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT (9U)
/*! ON_OFF_SETPOINT9 - ON_OFF_SETPOINT9
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT9_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT9_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT (10U)
/*! ON_OFF_SETPOINT10 - ON_OFF_SETPOINT10
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT10_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT10_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT (11U)
/*! ON_OFF_SETPOINT11 - ON_OFF_SETPOINT11
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT11_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT11_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT (12U)
/*! ON_OFF_SETPOINT12 - ON_OFF_SETPOINT12
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT12_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT12_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT (13U)
/*! ON_OFF_SETPOINT13 - ON_OFF_SETPOINT13
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT13_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT13_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT (14U)
/*! ON_OFF_SETPOINT14 - ON_OFF_SETPOINT14
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT14_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT14_MASK)

#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT (15U)
/*! ON_OFF_SETPOINT15 - ON_OFF_SETPOINT15
 *  0b0..ON
 *  0b1..OFF
 */
#define ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT15_SHIFT)) & ANADIG_PMU_RBB_LPSR_ENABLE_SP_ON_OFF_SETPOINT15_MASK)
/*! @} */

/*! @name BANDGAP_STBY_EN_SP - BANDGAP_STBY_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT (0U)
/*! STBY_EN_SETPOINT0 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT0_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT (1U)
/*! STBY_EN_SETPOINT1 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT1_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT (2U)
/*! STBY_EN_SETPOINT2 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT2_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT (3U)
/*! STBY_EN_SETPOINT3 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT3_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT (4U)
/*! STBY_EN_SETPOINT4 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT4_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT (5U)
/*! STBY_EN_SETPOINT5 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT5_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT (6U)
/*! STBY_EN_SETPOINT6 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT6_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT (7U)
/*! STBY_EN_SETPOINT7 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT7_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT (8U)
/*! STBY_EN_SETPOINT8 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT8_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT (9U)
/*! STBY_EN_SETPOINT9 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT9_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT (10U)
/*! STBY_EN_SETPOINT10 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT10_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT (11U)
/*! STBY_EN_SETPOINT11 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT11_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT (12U)
/*! STBY_EN_SETPOINT12 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT12_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT (13U)
/*! STBY_EN_SETPOINT13 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT13_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT (14U)
/*! STBY_EN_SETPOINT14 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT14_MASK)

#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT (15U)
/*! STBY_EN_SETPOINT15 - STBY_EN_SETPOINT
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_BANDGAP_STBY_EN_SP_STBY_EN_SETPOINT15_MASK)
/*! @} */

/*! @name PLL_LDO_STBY_EN_SP - PLL_LDO_STBY_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT (0U)
/*! STBY_EN_SETPOINT0 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT0_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT (1U)
/*! STBY_EN_SETPOINT1 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT1_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT (2U)
/*! STBY_EN_SETPOINT2 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT2_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT (3U)
/*! STBY_EN_SETPOINT3 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT3_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT (4U)
/*! STBY_EN_SETPOINT4 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT4_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT (5U)
/*! STBY_EN_SETPOINT5 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT5_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT (6U)
/*! STBY_EN_SETPOINT6 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT6_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT (7U)
/*! STBY_EN_SETPOINT7 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT7_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT (8U)
/*! STBY_EN_SETPOINT8 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT8_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT (9U)
/*! STBY_EN_SETPOINT9 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT9_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT (10U)
/*! STBY_EN_SETPOINT10 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT10_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT (11U)
/*! STBY_EN_SETPOINT11 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT11_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT (12U)
/*! STBY_EN_SETPOINT12 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT12_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT (13U)
/*! STBY_EN_SETPOINT13 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT13_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT (14U)
/*! STBY_EN_SETPOINT14 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT14_MASK)

#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT (15U)
/*! STBY_EN_SETPOINT15 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_PLL_LDO_STBY_EN_SP_STBY_EN_SETPOINT15_MASK)
/*! @} */

/*! @name FBB_M7_STBY_EN_SP - FBB_M7_STBY_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT (0U)
/*! STBY_EN_SETPOINT0 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT0_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT (1U)
/*! STBY_EN_SETPOINT1 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT1_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT (2U)
/*! STBY_EN_SETPOINT2 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT2_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT (3U)
/*! STBY_EN_SETPOINT3 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT3_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT (4U)
/*! STBY_EN_SETPOINT4 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT4_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT (5U)
/*! STBY_EN_SETPOINT5 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT5_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT (6U)
/*! STBY_EN_SETPOINT6 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT6_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT (7U)
/*! STBY_EN_SETPOINT7 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT7_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT (8U)
/*! STBY_EN_SETPOINT8 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT8_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT (9U)
/*! STBY_EN_SETPOINT9 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT9_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT (10U)
/*! STBY_EN_SETPOINT10 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT10_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT (11U)
/*! STBY_EN_SETPOINT11 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT11_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT (12U)
/*! STBY_EN_SETPOINT12 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT12_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT (13U)
/*! STBY_EN_SETPOINT13 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT13_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT (14U)
/*! STBY_EN_SETPOINT14 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT14_MASK)

#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT (15U)
/*! STBY_EN_SETPOINT15 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_FBB_M7_STBY_EN_SP_STBY_EN_SETPOINT15_MASK)
/*! @} */

/*! @name RBB_SOC_STBY_EN_SP - RBB_SOC_STBY_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT (0U)
/*! STBY_EN_SETPOINT0 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT0_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT (1U)
/*! STBY_EN_SETPOINT1 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT1_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT (2U)
/*! STBY_EN_SETPOINT2 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT2_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT (3U)
/*! STBY_EN_SETPOINT3 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT3_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT (4U)
/*! STBY_EN_SETPOINT4 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT4_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT (5U)
/*! STBY_EN_SETPOINT5 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT5_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT (6U)
/*! STBY_EN_SETPOINT6 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT6_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT (7U)
/*! STBY_EN_SETPOINT7 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT7_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT (8U)
/*! STBY_EN_SETPOINT8 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT8_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT (9U)
/*! STBY_EN_SETPOINT9 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT9_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT (10U)
/*! STBY_EN_SETPOINT10 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT10_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT (11U)
/*! STBY_EN_SETPOINT11 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT11_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT (12U)
/*! STBY_EN_SETPOINT12 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT12_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT (13U)
/*! STBY_EN_SETPOINT13 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT13_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT (14U)
/*! STBY_EN_SETPOINT14 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT14_MASK)

#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT (15U)
/*! STBY_EN_SETPOINT15 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_RBB_SOC_STBY_EN_SP_STBY_EN_SETPOINT15_MASK)
/*! @} */

/*! @name RBB_LPSR_STBY_EN_SP - RBB_LPSR_STBY_EN_SP_REGISTER */
/*! @{ */

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT0_MASK (0x1U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT (0U)
/*! STBY_EN_SETPOINT0 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT0(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT0_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT0_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT1_MASK (0x2U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT (1U)
/*! STBY_EN_SETPOINT1 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT1(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT1_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT1_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT2_MASK (0x4U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT (2U)
/*! STBY_EN_SETPOINT2 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT2(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT2_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT2_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT3_MASK (0x8U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT (3U)
/*! STBY_EN_SETPOINT3 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT3(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT3_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT3_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT4_MASK (0x10U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT (4U)
/*! STBY_EN_SETPOINT4 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT4(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT4_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT4_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT5_MASK (0x20U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT (5U)
/*! STBY_EN_SETPOINT5 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT5(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT5_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT5_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT6_MASK (0x40U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT (6U)
/*! STBY_EN_SETPOINT6 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT6(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT6_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT6_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT7_MASK (0x80U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT (7U)
/*! STBY_EN_SETPOINT7 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT7(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT7_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT7_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT8_MASK (0x100U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT (8U)
/*! STBY_EN_SETPOINT8 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT8(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT8_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT8_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT9_MASK (0x200U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT (9U)
/*! STBY_EN_SETPOINT9 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT9(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT9_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT9_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT10_MASK (0x400U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT (10U)
/*! STBY_EN_SETPOINT10 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT10(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT10_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT10_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT11_MASK (0x800U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT (11U)
/*! STBY_EN_SETPOINT11 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT11(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT11_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT11_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT12_MASK (0x1000U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT (12U)
/*! STBY_EN_SETPOINT12 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT12(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT12_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT12_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT13_MASK (0x2000U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT (13U)
/*! STBY_EN_SETPOINT13 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT13(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT13_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT13_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT14_MASK (0x4000U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT (14U)
/*! STBY_EN_SETPOINT14 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT14(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT14_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT14_MASK)

#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT15_MASK (0x8000U)
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT (15U)
/*! STBY_EN_SETPOINT15 - Standby mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT15(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT15_SHIFT)) & ANADIG_PMU_RBB_LPSR_STBY_EN_SP_STBY_EN_SETPOINT15_MASK)
/*! @} */

/*! @name FBB_M7_CONFIGURE - FBB_M7_CONFIGURE_REGISTER */
/*! @{ */

#define ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_PW_MASK (0xFU)
#define ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_PW_SHIFT (0U)
/*! WB_CFG_PW - wb_cfg_pw
 */
#define ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_PW(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_PW_SHIFT)) & ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_PW_MASK)

#define ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_NW_MASK (0xF0U)
#define ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_NW_SHIFT (4U)
/*! WB_CFG_NW - wb_cfg_nw
 */
#define ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_NW(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_NW_SHIFT)) & ANADIG_PMU_FBB_M7_CONFIGURE_WB_CFG_NW_MASK)

#define ANADIG_PMU_FBB_M7_CONFIGURE_OSCILLATOR_BITS_MASK (0x700U)
#define ANADIG_PMU_FBB_M7_CONFIGURE_OSCILLATOR_BITS_SHIFT (8U)
/*! OSCILLATOR_BITS - oscillator_bits
 */
#define ANADIG_PMU_FBB_M7_CONFIGURE_OSCILLATOR_BITS(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_CONFIGURE_OSCILLATOR_BITS_SHIFT)) & ANADIG_PMU_FBB_M7_CONFIGURE_OSCILLATOR_BITS_MASK)

#define ANADIG_PMU_FBB_M7_CONFIGURE_REGULATOR_STRENGTH_MASK (0x3800U)
#define ANADIG_PMU_FBB_M7_CONFIGURE_REGULATOR_STRENGTH_SHIFT (11U)
/*! REGULATOR_STRENGTH - regulator_strength
 */
#define ANADIG_PMU_FBB_M7_CONFIGURE_REGULATOR_STRENGTH(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_FBB_M7_CONFIGURE_REGULATOR_STRENGTH_SHIFT)) & ANADIG_PMU_FBB_M7_CONFIGURE_REGULATOR_STRENGTH_MASK)
/*! @} */

/*! @name RBB_LPSR_CONFIGURE - RBB_LPSR_CONFIGURE_REGISTER */
/*! @{ */

#define ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_PW_MASK (0xFU)
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_PW_SHIFT (0U)
/*! WB_CFG_PW - wb_cfg_pw
 */
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_PW(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_PW_SHIFT)) & ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_PW_MASK)

#define ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_NW_MASK (0xF0U)
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_NW_SHIFT (4U)
/*! WB_CFG_NW - wb_cfg_nw
 */
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_NW(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_NW_SHIFT)) & ANADIG_PMU_RBB_LPSR_CONFIGURE_WB_CFG_NW_MASK)

#define ANADIG_PMU_RBB_LPSR_CONFIGURE_OSCILLATOR_BITS_MASK (0x700U)
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_OSCILLATOR_BITS_SHIFT (8U)
/*! OSCILLATOR_BITS - oscillator_bits
 */
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_OSCILLATOR_BITS(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_CONFIGURE_OSCILLATOR_BITS_SHIFT)) & ANADIG_PMU_RBB_LPSR_CONFIGURE_OSCILLATOR_BITS_MASK)

#define ANADIG_PMU_RBB_LPSR_CONFIGURE_REGULATOR_STRENGTH_MASK (0x3800U)
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_REGULATOR_STRENGTH_SHIFT (11U)
/*! REGULATOR_STRENGTH - regulator_strength
 */
#define ANADIG_PMU_RBB_LPSR_CONFIGURE_REGULATOR_STRENGTH(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_LPSR_CONFIGURE_REGULATOR_STRENGTH_SHIFT)) & ANADIG_PMU_RBB_LPSR_CONFIGURE_REGULATOR_STRENGTH_MASK)
/*! @} */

/*! @name RBB_SOC_CONFIGURE - RBB_SOC_CONFIGURE_REGISTER */
/*! @{ */

#define ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_PW_MASK (0xFU)
#define ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_PW_SHIFT (0U)
/*! WB_CFG_PW - wb_cfg_pw
 */
#define ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_PW(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_PW_SHIFT)) & ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_PW_MASK)

#define ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_NW_MASK (0xF0U)
#define ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_NW_SHIFT (4U)
/*! WB_CFG_NW - wb_cfg_nw
 */
#define ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_NW(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_NW_SHIFT)) & ANADIG_PMU_RBB_SOC_CONFIGURE_WB_CFG_NW_MASK)

#define ANADIG_PMU_RBB_SOC_CONFIGURE_OSCILLATOR_BITS_MASK (0x700U)
#define ANADIG_PMU_RBB_SOC_CONFIGURE_OSCILLATOR_BITS_SHIFT (8U)
/*! OSCILLATOR_BITS - oscillator_bits
 */
#define ANADIG_PMU_RBB_SOC_CONFIGURE_OSCILLATOR_BITS(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_CONFIGURE_OSCILLATOR_BITS_SHIFT)) & ANADIG_PMU_RBB_SOC_CONFIGURE_OSCILLATOR_BITS_MASK)

#define ANADIG_PMU_RBB_SOC_CONFIGURE_REGULATOR_STRENGTH_MASK (0x3800U)
#define ANADIG_PMU_RBB_SOC_CONFIGURE_REGULATOR_STRENGTH_SHIFT (11U)
/*! REGULATOR_STRENGTH - regulator_strength
 */
#define ANADIG_PMU_RBB_SOC_CONFIGURE_REGULATOR_STRENGTH(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_RBB_SOC_CONFIGURE_REGULATOR_STRENGTH_SHIFT)) & ANADIG_PMU_RBB_SOC_CONFIGURE_REGULATOR_STRENGTH_MASK)
/*! @} */

/*! @name REFTOP_OTP_TRIM_VALUE - REFTOP_OTP_TRIM_VALUE_REGISTER */
/*! @{ */

#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_IBZTCADJ_MASK (0x7U)
#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_IBZTCADJ_SHIFT (0U)
/*! REFTOP_IBZTCADJ - REFTOP_IBZTCADJ
 */
#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_IBZTCADJ(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_IBZTCADJ_SHIFT)) & ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_IBZTCADJ_MASK)

#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_VBGADJ_MASK (0x38U)
#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_VBGADJ_SHIFT (3U)
/*! REFTOP_VBGADJ - REFTOP_VBGADJ
 */
#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_VBGADJ(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_VBGADJ_SHIFT)) & ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_VBGADJ_MASK)

#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_TRIM_EN_MASK (0x40U)
#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_TRIM_EN_SHIFT (6U)
/*! REFTOP_TRIM_EN - REFTOP_TRIM_EN
 */
#define ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_TRIM_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_TRIM_EN_SHIFT)) & ANADIG_PMU_REFTOP_OTP_TRIM_VALUE_REFTOP_TRIM_EN_MASK)
/*! @} */

/*! @name LPSR_1P8_LDO_OTP_TRIM_VALUE - LPSR_1P8_LDO_OTP_TRIM_VALUE_REGISTER */
/*! @{ */

#define ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_MASK (0x3U)
#define ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_SHIFT (0U)
/*! LPSR_LDO_1P8_TRIM - LPSR_LDO_1P8_TRIM
 */
#define ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_SHIFT)) & ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_MASK)

#define ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_EN_MASK (0x4U)
#define ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_EN_SHIFT (2U)
/*! LPSR_LDO_1P8_TRIM_EN - LPSR_LDO_1P8_TRIM_EN
 */
#define ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_EN(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_EN_SHIFT)) & ANADIG_PMU_LPSR_1P8_LDO_OTP_TRIM_VALUE_LPSR_LDO_1P8_TRIM_EN_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ANADIG_PMU_Register_Masks */


/* ANADIG_PMU - Peripheral instance base addresses */
/** Peripheral ANADIG_PMU base address */
#define ANADIG_PMU_BASE                          (0x40C84000u)
/** Peripheral ANADIG_PMU base pointer */
#define ANADIG_PMU                               ((ANADIG_PMU_Type *)ANADIG_PMU_BASE)
/** Array initializer of ANADIG_PMU peripheral base addresses */
#define ANADIG_PMU_BASE_ADDRS                    { ANADIG_PMU_BASE }
/** Array initializer of ANADIG_PMU peripheral base pointers */
#define ANADIG_PMU_BASE_PTRS                     { ANADIG_PMU }

/*!
 * @}
 */ /* end of group ANADIG_PMU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ANADIG_TEMPSENSOR Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_TEMPSENSOR_Peripheral_Access_Layer ANADIG_TEMPSENSOR Peripheral Access Layer
 * @{
 */

/** ANADIG_TEMPSENSOR - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[1024];
  __IO uint32_t TEMPSENSOR;                        /**< Tempsensor Register, offset: 0x400 */
       uint8_t RESERVED_1[44];
  __I  uint32_t TEMPSNS_OTP_TRIM_VALUE;            /**< TEMPSNS_OTP_TRIM_VALUE_REGISTER, offset: 0x430 */
} ANADIG_TEMPSENSOR_Type;

/* ----------------------------------------------------------------------------
   -- ANADIG_TEMPSENSOR Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANADIG_TEMPSENSOR_Register_Masks ANADIG_TEMPSENSOR Register Masks
 * @{
 */

/*! @name TEMPSENSOR - Tempsensor Register */
/*! @{ */

#define ANADIG_TEMPSENSOR_TEMPSENSOR_TEMPSNS_AI_TOGGLE_MASK (0x8000U)
#define ANADIG_TEMPSENSOR_TEMPSENSOR_TEMPSNS_AI_TOGGLE_SHIFT (15U)
/*! TEMPSNS_AI_TOGGLE - AI toggle
 */
#define ANADIG_TEMPSENSOR_TEMPSENSOR_TEMPSNS_AI_TOGGLE(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_TEMPSENSOR_TEMPSENSOR_TEMPSNS_AI_TOGGLE_SHIFT)) & ANADIG_TEMPSENSOR_TEMPSENSOR_TEMPSNS_AI_TOGGLE_MASK)

#define ANADIG_TEMPSENSOR_TEMPSENSOR_TEMPSNS_AI_BUSY_MASK (0x10000U)
#define ANADIG_TEMPSENSOR_TEMPSENSOR_TEMPSNS_AI_BUSY_SHIFT (16U)
/*! TEMPSNS_AI_BUSY - AI Busy monitor
 */
#define ANADIG_TEMPSENSOR_TEMPSENSOR_TEMPSNS_AI_BUSY(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_TEMPSENSOR_TEMPSENSOR_TEMPSNS_AI_BUSY_SHIFT)) & ANADIG_TEMPSENSOR_TEMPSENSOR_TEMPSNS_AI_BUSY_MASK)
/*! @} */

/*! @name TEMPSNS_OTP_TRIM_VALUE - TEMPSNS_OTP_TRIM_VALUE_REGISTER */
/*! @{ */

#define ANADIG_TEMPSENSOR_TEMPSNS_OTP_TRIM_VALUE_TEMPSNS_TEMP_VAL_MASK (0x3FFC00U)
#define ANADIG_TEMPSENSOR_TEMPSNS_OTP_TRIM_VALUE_TEMPSNS_TEMP_VAL_SHIFT (10U)
/*! TEMPSNS_TEMP_VAL - Temperature Value at 25C
 */
#define ANADIG_TEMPSENSOR_TEMPSNS_OTP_TRIM_VALUE_TEMPSNS_TEMP_VAL(x) (((uint32_t)(((uint32_t)(x)) << ANADIG_TEMPSENSOR_TEMPSNS_OTP_TRIM_VALUE_TEMPSNS_TEMP_VAL_SHIFT)) & ANADIG_TEMPSENSOR_TEMPSNS_OTP_TRIM_VALUE_TEMPSNS_TEMP_VAL_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ANADIG_TEMPSENSOR_Register_Masks */


/* ANADIG_TEMPSENSOR - Peripheral instance base addresses */
/** Peripheral ANADIG_TEMPSENSOR base address */
#define ANADIG_TEMPSENSOR_BASE                   (0x40C84000u)
/** Peripheral ANADIG_TEMPSENSOR base pointer */
#define ANADIG_TEMPSENSOR                        ((ANADIG_TEMPSENSOR_Type *)ANADIG_TEMPSENSOR_BASE)
/** Array initializer of ANADIG_TEMPSENSOR peripheral base addresses */
#define ANADIG_TEMPSENSOR_BASE_ADDRS             { ANADIG_TEMPSENSOR_BASE }
/** Array initializer of ANADIG_TEMPSENSOR peripheral base pointers */
#define ANADIG_TEMPSENSOR_BASE_PTRS              { ANADIG_TEMPSENSOR }

/*!
 * @}
 */ /* end of group ANADIG_TEMPSENSOR_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AOI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AOI_Peripheral_Access_Layer AOI Peripheral Access Layer
 * @{
 */

/** AOI - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x4 */
    __IO uint16_t BFCRT01;                           /**< Boolean Function Term 0 and 1 Configuration Register for EVENTn, array offset: 0x0, array step: 0x4 */
    __IO uint16_t BFCRT23;                           /**< Boolean Function Term 2 and 3 Configuration Register for EVENTn, array offset: 0x2, array step: 0x4 */
  } BFCRT[4];
} AOI_Type;

/* ----------------------------------------------------------------------------
   -- AOI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AOI_Register_Masks AOI Register Masks
 * @{
 */

/*! @name BFCRT01 - Boolean Function Term 0 and 1 Configuration Register for EVENTn */
/*! @{ */

#define AOI_BFCRT01_PT1_DC_MASK                  (0x3U)
#define AOI_BFCRT01_PT1_DC_SHIFT                 (0U)
/*! PT1_DC - Product term 1, D input configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define AOI_BFCRT01_PT1_DC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT1_DC_SHIFT)) & AOI_BFCRT01_PT1_DC_MASK)

#define AOI_BFCRT01_PT1_CC_MASK                  (0xCU)
#define AOI_BFCRT01_PT1_CC_SHIFT                 (2U)
/*! PT1_CC - Product term 1, C input configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define AOI_BFCRT01_PT1_CC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT1_CC_SHIFT)) & AOI_BFCRT01_PT1_CC_MASK)

#define AOI_BFCRT01_PT1_BC_MASK                  (0x30U)
#define AOI_BFCRT01_PT1_BC_SHIFT                 (4U)
/*! PT1_BC - Product term 1, B input configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define AOI_BFCRT01_PT1_BC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT1_BC_SHIFT)) & AOI_BFCRT01_PT1_BC_MASK)

#define AOI_BFCRT01_PT1_AC_MASK                  (0xC0U)
#define AOI_BFCRT01_PT1_AC_SHIFT                 (6U)
/*! PT1_AC - Product term 1, A input configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define AOI_BFCRT01_PT1_AC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT1_AC_SHIFT)) & AOI_BFCRT01_PT1_AC_MASK)

#define AOI_BFCRT01_PT0_DC_MASK                  (0x300U)
#define AOI_BFCRT01_PT0_DC_SHIFT                 (8U)
/*! PT0_DC - Product term 0, D input configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define AOI_BFCRT01_PT0_DC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT0_DC_SHIFT)) & AOI_BFCRT01_PT0_DC_MASK)

#define AOI_BFCRT01_PT0_CC_MASK                  (0xC00U)
#define AOI_BFCRT01_PT0_CC_SHIFT                 (10U)
/*! PT0_CC - Product term 0, C input configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define AOI_BFCRT01_PT0_CC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT0_CC_SHIFT)) & AOI_BFCRT01_PT0_CC_MASK)

#define AOI_BFCRT01_PT0_BC_MASK                  (0x3000U)
#define AOI_BFCRT01_PT0_BC_SHIFT                 (12U)
/*! PT0_BC - Product term 0, B input configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define AOI_BFCRT01_PT0_BC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT0_BC_SHIFT)) & AOI_BFCRT01_PT0_BC_MASK)

#define AOI_BFCRT01_PT0_AC_MASK                  (0xC000U)
#define AOI_BFCRT01_PT0_AC_SHIFT                 (14U)
/*! PT0_AC - Product term 0, A input configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define AOI_BFCRT01_PT0_AC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT01_PT0_AC_SHIFT)) & AOI_BFCRT01_PT0_AC_MASK)
/*! @} */

/* The count of AOI_BFCRT01 */
#define AOI_BFCRT01_COUNT                        (4U)

/*! @name BFCRT23 - Boolean Function Term 2 and 3 Configuration Register for EVENTn */
/*! @{ */

#define AOI_BFCRT23_PT3_DC_MASK                  (0x3U)
#define AOI_BFCRT23_PT3_DC_SHIFT                 (0U)
/*! PT3_DC - Product term 3, D input configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define AOI_BFCRT23_PT3_DC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT3_DC_SHIFT)) & AOI_BFCRT23_PT3_DC_MASK)

#define AOI_BFCRT23_PT3_CC_MASK                  (0xCU)
#define AOI_BFCRT23_PT3_CC_SHIFT                 (2U)
/*! PT3_CC - Product term 3, C input configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define AOI_BFCRT23_PT3_CC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT3_CC_SHIFT)) & AOI_BFCRT23_PT3_CC_MASK)

#define AOI_BFCRT23_PT3_BC_MASK                  (0x30U)
#define AOI_BFCRT23_PT3_BC_SHIFT                 (4U)
/*! PT3_BC - Product term 3, B input configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define AOI_BFCRT23_PT3_BC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT3_BC_SHIFT)) & AOI_BFCRT23_PT3_BC_MASK)

#define AOI_BFCRT23_PT3_AC_MASK                  (0xC0U)
#define AOI_BFCRT23_PT3_AC_SHIFT                 (6U)
/*! PT3_AC - Product term 3, A input configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define AOI_BFCRT23_PT3_AC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT3_AC_SHIFT)) & AOI_BFCRT23_PT3_AC_MASK)

#define AOI_BFCRT23_PT2_DC_MASK                  (0x300U)
#define AOI_BFCRT23_PT2_DC_SHIFT                 (8U)
/*! PT2_DC - Product term 2, D input configuration
 *  0b00..Force the D input in this product term to a logical zero
 *  0b01..Pass the D input in this product term
 *  0b10..Complement the D input in this product term
 *  0b11..Force the D input in this product term to a logical one
 */
#define AOI_BFCRT23_PT2_DC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT2_DC_SHIFT)) & AOI_BFCRT23_PT2_DC_MASK)

#define AOI_BFCRT23_PT2_CC_MASK                  (0xC00U)
#define AOI_BFCRT23_PT2_CC_SHIFT                 (10U)
/*! PT2_CC - Product term 2, C input configuration
 *  0b00..Force the C input in this product term to a logical zero
 *  0b01..Pass the C input in this product term
 *  0b10..Complement the C input in this product term
 *  0b11..Force the C input in this product term to a logical one
 */
#define AOI_BFCRT23_PT2_CC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT2_CC_SHIFT)) & AOI_BFCRT23_PT2_CC_MASK)

#define AOI_BFCRT23_PT2_BC_MASK                  (0x3000U)
#define AOI_BFCRT23_PT2_BC_SHIFT                 (12U)
/*! PT2_BC - Product term 2, B input configuration
 *  0b00..Force the B input in this product term to a logical zero
 *  0b01..Pass the B input in this product term
 *  0b10..Complement the B input in this product term
 *  0b11..Force the B input in this product term to a logical one
 */
#define AOI_BFCRT23_PT2_BC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT2_BC_SHIFT)) & AOI_BFCRT23_PT2_BC_MASK)

#define AOI_BFCRT23_PT2_AC_MASK                  (0xC000U)
#define AOI_BFCRT23_PT2_AC_SHIFT                 (14U)
/*! PT2_AC - Product term 2, A input configuration
 *  0b00..Force the A input in this product term to a logical zero
 *  0b01..Pass the A input in this product term
 *  0b10..Complement the A input in this product term
 *  0b11..Force the A input in this product term to a logical one
 */
#define AOI_BFCRT23_PT2_AC(x)                    (((uint16_t)(((uint16_t)(x)) << AOI_BFCRT23_PT2_AC_SHIFT)) & AOI_BFCRT23_PT2_AC_MASK)
/*! @} */

/* The count of AOI_BFCRT23 */
#define AOI_BFCRT23_COUNT                        (4U)


/*!
 * @}
 */ /* end of group AOI_Register_Masks */


/* AOI - Peripheral instance base addresses */
/** Peripheral AOI1 base address */
#define AOI1_BASE                                (0x400B8000u)
/** Peripheral AOI1 base pointer */
#define AOI1                                     ((AOI_Type *)AOI1_BASE)
/** Peripheral AOI2 base address */
#define AOI2_BASE                                (0x400BC000u)
/** Peripheral AOI2 base pointer */
#define AOI2                                     ((AOI_Type *)AOI2_BASE)
/** Array initializer of AOI peripheral base addresses */
#define AOI_BASE_ADDRS                           { 0u, AOI1_BASE, AOI2_BASE }
/** Array initializer of AOI peripheral base pointers */
#define AOI_BASE_PTRS                            { (AOI_Type *)0u, AOI1, AOI2 }

/*!
 * @}
 */ /* end of group AOI_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ASRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ASRC_Peripheral_Access_Layer ASRC Peripheral Access Layer
 * @{
 */

/** ASRC - Register Layout Typedef */
typedef struct {
  __IO uint32_t ASRCTR;                            /**< ASRC Control Register, offset: 0x0 */
  __IO uint32_t ASRIER;                            /**< ASRC Interrupt Enable Register, offset: 0x4 */
       uint8_t RESERVED_0[4];
  __IO uint32_t ASRCNCR;                           /**< ASRC Channel Number Configuration Register, offset: 0xC */
  __IO uint32_t ASRCFG;                            /**< ASRC Filter Configuration Status Register, offset: 0x10 */
  __IO uint32_t ASRCSR;                            /**< ASRC Clock Source Register, offset: 0x14 */
  __IO uint32_t ASRCDR1;                           /**< ASRC Clock Divider Register 1, offset: 0x18 */
  __IO uint32_t ASRCDR2;                           /**< ASRC Clock Divider Register 2, offset: 0x1C */
  __I  uint32_t ASRSTR;                            /**< ASRC Status Register, offset: 0x20 */
       uint8_t RESERVED_1[28];
  __IO uint32_t ASRPM[5];                          /**< ASRC Parameter Register n, array offset: 0x40, array step: 0x4 */
  __IO uint32_t ASRTFR1;                           /**< ASRC Task Queue FIFO Register 1, offset: 0x54 */
       uint8_t RESERVED_2[4];
  __IO uint32_t ASRCCR;                            /**< ASRC Channel Counter Register, offset: 0x5C */
  __O  uint32_t ASRDIA;                            /**< ASRC Data Input Register for Pair x, offset: 0x60 */
  __I  uint32_t ASRDOA;                            /**< ASRC Data Output Register for Pair x, offset: 0x64 */
  __O  uint32_t ASRDIB;                            /**< ASRC Data Input Register for Pair x, offset: 0x68 */
  __I  uint32_t ASRDOB;                            /**< ASRC Data Output Register for Pair x, offset: 0x6C */
  __O  uint32_t ASRDIC;                            /**< ASRC Data Input Register for Pair x, offset: 0x70 */
  __I  uint32_t ASRDOC;                            /**< ASRC Data Output Register for Pair x, offset: 0x74 */
       uint8_t RESERVED_3[8];
  __IO uint32_t ASRIDRHA;                          /**< ASRC Ideal Ratio for Pair A-High Part, offset: 0x80 */
  __IO uint32_t ASRIDRLA;                          /**< ASRC Ideal Ratio for Pair A -Low Part, offset: 0x84 */
  __IO uint32_t ASRIDRHB;                          /**< ASRC Ideal Ratio for Pair B-High Part, offset: 0x88 */
  __IO uint32_t ASRIDRLB;                          /**< ASRC Ideal Ratio for Pair B-Low Part, offset: 0x8C */
  __IO uint32_t ASRIDRHC;                          /**< ASRC Ideal Ratio for Pair C-High Part, offset: 0x90 */
  __IO uint32_t ASRIDRLC;                          /**< ASRC Ideal Ratio for Pair C-Low Part, offset: 0x94 */
  __IO uint32_t ASR76K;                            /**< ASRC 76 kHz Period in terms of ASRC processing clock, offset: 0x98 */
  __IO uint32_t ASR56K;                            /**< ASRC 56 kHz Period in terms of ASRC processing clock, offset: 0x9C */
  __IO uint32_t ASRMCRA;                           /**< ASRC Misc Control Register for Pair A, offset: 0xA0 */
  __I  uint32_t ASRFSTA;                           /**< ASRC FIFO Status Register for Pair A, offset: 0xA4 */
  __IO uint32_t ASRMCRB;                           /**< ASRC Misc Control Register for Pair B, offset: 0xA8 */
  __I  uint32_t ASRFSTB;                           /**< ASRC FIFO Status Register for Pair B, offset: 0xAC */
  __IO uint32_t ASRMCRC;                           /**< ASRC Misc Control Register for Pair C, offset: 0xB0 */
  __I  uint32_t ASRFSTC;                           /**< ASRC FIFO Status Register for Pair C, offset: 0xB4 */
       uint8_t RESERVED_4[8];
  __IO uint32_t ASRMCR1[3];                        /**< ASRC Misc Control Register 1 for Pair X, array offset: 0xC0, array step: 0x4 */
} ASRC_Type;

/* ----------------------------------------------------------------------------
   -- ASRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ASRC_Register_Masks ASRC Register Masks
 * @{
 */

/*! @name ASRCTR - ASRC Control Register */
/*! @{ */

#define ASRC_ASRCTR_ASRCEN_MASK                  (0x1U)
#define ASRC_ASRCTR_ASRCEN_SHIFT                 (0U)
/*! ASRCEN - ASRCEN
 *  0b0..operation of ASRC disabled
 *  0b1..operation ASRC is enabled
 */
#define ASRC_ASRCTR_ASRCEN(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_ASRCEN_SHIFT)) & ASRC_ASRCTR_ASRCEN_MASK)

#define ASRC_ASRCTR_ASREA_MASK                   (0x2U)
#define ASRC_ASRCTR_ASREA_SHIFT                  (1U)
/*! ASREA - ASREA
 *  0b0..operation of conversion A is disabled
 *  0b1..operation of conversion A is enabled
 */
#define ASRC_ASRCTR_ASREA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_ASREA_SHIFT)) & ASRC_ASRCTR_ASREA_MASK)

#define ASRC_ASRCTR_ASREB_MASK                   (0x4U)
#define ASRC_ASRCTR_ASREB_SHIFT                  (2U)
/*! ASREB - ASREB
 *  0b0..operation of conversion B is disabled
 *  0b1..operation of conversion B is enabled
 */
#define ASRC_ASRCTR_ASREB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_ASREB_SHIFT)) & ASRC_ASRCTR_ASREB_MASK)

#define ASRC_ASRCTR_ASREC_MASK                   (0x8U)
#define ASRC_ASRCTR_ASREC_SHIFT                  (3U)
/*! ASREC - ASREC
 *  0b0..operation of conversion C is disabled
 *  0b1..operation of conversion C is enabled
 */
#define ASRC_ASRCTR_ASREC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_ASREC_SHIFT)) & ASRC_ASRCTR_ASREC_MASK)

#define ASRC_ASRCTR_SRST_MASK                    (0x10U)
#define ASRC_ASRCTR_SRST_SHIFT                   (4U)
/*! SRST - SRST
 *  0b0..ASRC Software reset cleared
 *  0b1..ASRC Software reset generated. NOTE: This is a self-clear bit
 */
#define ASRC_ASRCTR_SRST(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_SRST_SHIFT)) & ASRC_ASRCTR_SRST_MASK)

#define ASRC_ASRCTR_IDRA_MASK                    (0x2000U)
#define ASRC_ASRCTR_IDRA_SHIFT                   (13U)
/*! IDRA - IDRA
 *  0b0..ASRC internal measured ratio is used
 *  0b1..Ideal ratio from the interface register ASRIDRHA, ASRIDRLA is used
 */
#define ASRC_ASRCTR_IDRA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_IDRA_SHIFT)) & ASRC_ASRCTR_IDRA_MASK)

#define ASRC_ASRCTR_USRA_MASK                    (0x4000U)
#define ASRC_ASRCTR_USRA_SHIFT                   (14U)
/*! USRA - USRA
 *  0b1..Use ratio as the input to ASRC for pair A
 *  0b0..Do not use ratio as the input to ASRC for pair A
 */
#define ASRC_ASRCTR_USRA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_USRA_SHIFT)) & ASRC_ASRCTR_USRA_MASK)

#define ASRC_ASRCTR_IDRB_MASK                    (0x8000U)
#define ASRC_ASRCTR_IDRB_SHIFT                   (15U)
/*! IDRB - IDRB
 *  0b0..ASRC internal measured ratio is used
 *  0b1..Ideal ratio from the interface register ASRIDRHB, ASRIDRLB is used
 */
#define ASRC_ASRCTR_IDRB(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_IDRB_SHIFT)) & ASRC_ASRCTR_IDRB_MASK)

#define ASRC_ASRCTR_USRB_MASK                    (0x10000U)
#define ASRC_ASRCTR_USRB_SHIFT                   (16U)
/*! USRB - USRB
 *  0b1..Use ratio as the input to ASRC for pair B
 *  0b0..Do not use ratio as the input to ASRC for pair B
 */
#define ASRC_ASRCTR_USRB(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_USRB_SHIFT)) & ASRC_ASRCTR_USRB_MASK)

#define ASRC_ASRCTR_IDRC_MASK                    (0x20000U)
#define ASRC_ASRCTR_IDRC_SHIFT                   (17U)
/*! IDRC - IDRC
 *  0b0..ASRC internal measured ratio is used
 *  0b1..Ideal ratio from the interface register ASRIDRHC, ASRIDRLC is used
 */
#define ASRC_ASRCTR_IDRC(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_IDRC_SHIFT)) & ASRC_ASRCTR_IDRC_MASK)

#define ASRC_ASRCTR_USRC_MASK                    (0x40000U)
#define ASRC_ASRCTR_USRC_SHIFT                   (18U)
/*! USRC - USRC
 *  0b1..Use ratio as the input to ASRC for pair C
 *  0b0..Do not use ratio as the input to ASRC for pair C
 */
#define ASRC_ASRCTR_USRC(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_USRC_SHIFT)) & ASRC_ASRCTR_USRC_MASK)

#define ASRC_ASRCTR_ATSA_MASK                    (0x100000U)
#define ASRC_ASRCTR_ATSA_SHIFT                   (20U)
/*! ATSA - ATSA
 *  0b1..Pair A automatically updates its pre-processing and post-processing options
 *  0b0..Pair A does not automatically update its pre-processing and post-processing options
 */
#define ASRC_ASRCTR_ATSA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_ATSA_SHIFT)) & ASRC_ASRCTR_ATSA_MASK)

#define ASRC_ASRCTR_ATSB_MASK                    (0x200000U)
#define ASRC_ASRCTR_ATSB_SHIFT                   (21U)
/*! ATSB - ATSB
 *  0b1..Pair B automatically updates its pre-processing and post-processing options
 *  0b0..Pair B does not automatically update its pre-processing and post-processing options
 */
#define ASRC_ASRCTR_ATSB(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_ATSB_SHIFT)) & ASRC_ASRCTR_ATSB_MASK)

#define ASRC_ASRCTR_ATSC_MASK                    (0x400000U)
#define ASRC_ASRCTR_ATSC_SHIFT                   (22U)
/*! ATSC - ATSC
 *  0b1..Pair C automatically updates its pre-processing and post-processing options
 *  0b0..Pair C does not automatically update its pre-processing and post-processing options
 */
#define ASRC_ASRCTR_ATSC(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCTR_ATSC_SHIFT)) & ASRC_ASRCTR_ATSC_MASK)
/*! @} */

/*! @name ASRIER - ASRC Interrupt Enable Register */
/*! @{ */

#define ASRC_ASRIER_ADIEA_MASK                   (0x1U)
#define ASRC_ASRIER_ADIEA_SHIFT                  (0U)
/*! ADIEA - ADIEA
 *  0b1..interrupt enabled
 *  0b0..interrupt disabled
 */
#define ASRC_ASRIER_ADIEA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_ADIEA_SHIFT)) & ASRC_ASRIER_ADIEA_MASK)

#define ASRC_ASRIER_ADIEB_MASK                   (0x2U)
#define ASRC_ASRIER_ADIEB_SHIFT                  (1U)
/*! ADIEB - ADIEB
 *  0b1..interrupt enabled
 *  0b0..interrupt disabled
 */
#define ASRC_ASRIER_ADIEB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_ADIEB_SHIFT)) & ASRC_ASRIER_ADIEB_MASK)

#define ASRC_ASRIER_ADIEC_MASK                   (0x4U)
#define ASRC_ASRIER_ADIEC_SHIFT                  (2U)
/*! ADIEC - ADIEC
 *  0b1..interrupt enabled
 *  0b0..interrupt disabled
 */
#define ASRC_ASRIER_ADIEC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_ADIEC_SHIFT)) & ASRC_ASRIER_ADIEC_MASK)

#define ASRC_ASRIER_ADOEA_MASK                   (0x8U)
#define ASRC_ASRIER_ADOEA_SHIFT                  (3U)
/*! ADOEA - ADOEA
 *  0b1..interrupt enabled
 *  0b0..interrupt disabled
 */
#define ASRC_ASRIER_ADOEA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_ADOEA_SHIFT)) & ASRC_ASRIER_ADOEA_MASK)

#define ASRC_ASRIER_ADOEB_MASK                   (0x10U)
#define ASRC_ASRIER_ADOEB_SHIFT                  (4U)
/*! ADOEB - ADOEB
 *  0b1..interrupt enabled
 *  0b0..interrupt disabled
 */
#define ASRC_ASRIER_ADOEB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_ADOEB_SHIFT)) & ASRC_ASRIER_ADOEB_MASK)

#define ASRC_ASRIER_ADOEC_MASK                   (0x20U)
#define ASRC_ASRIER_ADOEC_SHIFT                  (5U)
/*! ADOEC - ADOEC
 *  0b1..interrupt enabled
 *  0b0..interrupt disabled
 */
#define ASRC_ASRIER_ADOEC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_ADOEC_SHIFT)) & ASRC_ASRIER_ADOEC_MASK)

#define ASRC_ASRIER_AOLIE_MASK                   (0x40U)
#define ASRC_ASRIER_AOLIE_SHIFT                  (6U)
/*! AOLIE - AOLIE
 *  0b1..interrupt enabled
 *  0b0..interrupt disabled
 */
#define ASRC_ASRIER_AOLIE(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_AOLIE_SHIFT)) & ASRC_ASRIER_AOLIE_MASK)

#define ASRC_ASRIER_AFPWE_MASK                   (0x80U)
#define ASRC_ASRIER_AFPWE_SHIFT                  (7U)
/*! AFPWE - AFPWE
 *  0b1..interrupt enabled
 *  0b0..interrupt disabled
 */
#define ASRC_ASRIER_AFPWE(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIER_AFPWE_SHIFT)) & ASRC_ASRIER_AFPWE_MASK)
/*! @} */

/*! @name ASRCNCR - ASRC Channel Number Configuration Register */
/*! @{ */

#define ASRC_ASRCNCR_ANCA_MASK                   (0xFU)
#define ASRC_ASRCNCR_ANCA_SHIFT                  (0U)
/*! ANCA - ANCA
 *  0b0000..0 channels in A (Pair A is disabled)
 *  0b0001..1 channel in A
 *  0b0010..2 channels in A
 *  0b0011..3 channels in A
 *  0b0100..4 channels in A
 *  0b0101..5 channels in A
 *  0b0110..6 channels in A
 *  0b0111..7 channels in A
 *  0b1000..8 channels in A
 *  0b1001..9 channels in A
 *  0b1010..10 channels in A
 *  0b1011-0b1111..Should not be used.
 */
#define ASRC_ASRCNCR_ANCA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCNCR_ANCA_SHIFT)) & ASRC_ASRCNCR_ANCA_MASK)

#define ASRC_ASRCNCR_ANCB_MASK                   (0xF0U)
#define ASRC_ASRCNCR_ANCB_SHIFT                  (4U)
/*! ANCB - ANCB
 *  0b0000..0 channels in B (Pair B is disabled)
 *  0b0001..1 channel in B
 *  0b0010..2 channels in B
 *  0b0011..3 channels in B
 *  0b0100..4 channels in B
 *  0b0101..5 channels in B
 *  0b0110..6 channels in B
 *  0b0111..7 channels in B
 *  0b1000..8 channels in B
 *  0b1001..9 channels in B
 *  0b1010..10 channels in B
 *  0b1011-0b1111..Should not be used.
 */
#define ASRC_ASRCNCR_ANCB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCNCR_ANCB_SHIFT)) & ASRC_ASRCNCR_ANCB_MASK)

#define ASRC_ASRCNCR_ANCC_MASK                   (0xF00U)
#define ASRC_ASRCNCR_ANCC_SHIFT                  (8U)
/*! ANCC - ANCC
 *  0b0000..0 channels in C (Pair C is disabled)
 *  0b0001..1 channel in C
 *  0b0010..2 channels in C
 *  0b0011..3 channels in C
 *  0b0100..4 channels in C
 *  0b0101..5 channels in C
 *  0b0110..6 channels in C
 *  0b0111..7 channels in C
 *  0b1000..8 channels in C
 *  0b1001..9 channels in C
 *  0b1010..10 channels in C
 *  0b1011-0b1111..Should not be used.
 */
#define ASRC_ASRCNCR_ANCC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCNCR_ANCC_SHIFT)) & ASRC_ASRCNCR_ANCC_MASK)
/*! @} */

/*! @name ASRCFG - ASRC Filter Configuration Status Register */
/*! @{ */

#define ASRC_ASRCFG_PREMODA_MASK                 (0xC0U)
#define ASRC_ASRCFG_PREMODA_SHIFT                (6U)
/*! PREMODA - PREMODA
 *  0b00..Select Upsampling-by-2
 *  0b01..Select Direct-Connection
 *  0b10..Select Downsampling-by-2
 *  0b11..Select passthrough mode. In this case, POSTMODA[1:0] have no use.
 */
#define ASRC_ASRCFG_PREMODA(x)                   (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_PREMODA_SHIFT)) & ASRC_ASRCFG_PREMODA_MASK)

#define ASRC_ASRCFG_POSTMODA_MASK                (0x300U)
#define ASRC_ASRCFG_POSTMODA_SHIFT               (8U)
/*! POSTMODA - POSTMODA
 *  0b00..Select Upsampling-by-2
 *  0b01..Select Direct-Connection
 *  0b10..Select Downsampling-by-2
 *  0b11..Reserved.
 */
#define ASRC_ASRCFG_POSTMODA(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_POSTMODA_SHIFT)) & ASRC_ASRCFG_POSTMODA_MASK)

#define ASRC_ASRCFG_PREMODB_MASK                 (0xC00U)
#define ASRC_ASRCFG_PREMODB_SHIFT                (10U)
/*! PREMODB - PREMODB
 *  0b00..Select Upsampling-by-2
 *  0b01..Select Direct-Connection
 *  0b10..Select Downsampling-by-2
 *  0b11..Select passthrough mode. In this case, POSTMODB[1:0] have no use.
 */
#define ASRC_ASRCFG_PREMODB(x)                   (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_PREMODB_SHIFT)) & ASRC_ASRCFG_PREMODB_MASK)

#define ASRC_ASRCFG_POSTMODB_MASK                (0x3000U)
#define ASRC_ASRCFG_POSTMODB_SHIFT               (12U)
/*! POSTMODB - POSTMODB
 *  0b00..Select Upsampling-by-2
 *  0b01..Select Direct-Connection
 *  0b10..Select Downsampling-by-2
 *  0b11..Reserved.
 */
#define ASRC_ASRCFG_POSTMODB(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_POSTMODB_SHIFT)) & ASRC_ASRCFG_POSTMODB_MASK)

#define ASRC_ASRCFG_PREMODC_MASK                 (0xC000U)
#define ASRC_ASRCFG_PREMODC_SHIFT                (14U)
/*! PREMODC - PREMODC
 *  0b00..Select Upsampling-by-2
 *  0b01..Select Direct-Connection
 *  0b10..Select Downsampling-by-2
 *  0b11..Select passthrough mode. In this case, POSTMODC[1:0] have no use.
 */
#define ASRC_ASRCFG_PREMODC(x)                   (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_PREMODC_SHIFT)) & ASRC_ASRCFG_PREMODC_MASK)

#define ASRC_ASRCFG_POSTMODC_MASK                (0x30000U)
#define ASRC_ASRCFG_POSTMODC_SHIFT               (16U)
/*! POSTMODC - POSTMODC
 *  0b00..Select Upsampling-by-2 as defined in Signal Processing Flow.
 *  0b01..Select Direct-Connection as defined in Signal Processing Flow.
 *  0b10..Select Downsampling-by-2 as defined in Signal Processing Flow.
 *  0b11..Reserved.
 */
#define ASRC_ASRCFG_POSTMODC(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_POSTMODC_SHIFT)) & ASRC_ASRCFG_POSTMODC_MASK)

#define ASRC_ASRCFG_NDPRA_MASK                   (0x40000U)
#define ASRC_ASRCFG_NDPRA_SHIFT                  (18U)
/*! NDPRA - NDPRA
 *  0b0..Use default parameters for RAM-stored parameters. Override any parameters already in RAM.
 *  0b1..Don't use default parameters for RAM-stored parameters. Use the parameters already stored in RAM.
 */
#define ASRC_ASRCFG_NDPRA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_NDPRA_SHIFT)) & ASRC_ASRCFG_NDPRA_MASK)

#define ASRC_ASRCFG_NDPRB_MASK                   (0x80000U)
#define ASRC_ASRCFG_NDPRB_SHIFT                  (19U)
/*! NDPRB - NDPRB
 *  0b0..Use default parameters for RAM-stored parameters. Override any parameters already in RAM.
 *  0b1..Don't use default parameters for RAM-stored parameter. Use the parameters already stored in RAM.
 */
#define ASRC_ASRCFG_NDPRB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_NDPRB_SHIFT)) & ASRC_ASRCFG_NDPRB_MASK)

#define ASRC_ASRCFG_NDPRC_MASK                   (0x100000U)
#define ASRC_ASRCFG_NDPRC_SHIFT                  (20U)
/*! NDPRC - NDPRC
 *  0b0..Use default parameters for RAM-stored parameters. Override any parameters already in RAM.
 *  0b1..Don't use default parameters for RAM-stored parameters. Use the parameters already stored in RAM.
 */
#define ASRC_ASRCFG_NDPRC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_NDPRC_SHIFT)) & ASRC_ASRCFG_NDPRC_MASK)

#define ASRC_ASRCFG_INIRQA_MASK                  (0x200000U)
#define ASRC_ASRCFG_INIRQA_SHIFT                 (21U)
/*! INIRQA - INIRQA
 *  0b0..Initialization for Conversion Pair A not served
 *  0b1..Initialization for Conversion Pair A served
 */
#define ASRC_ASRCFG_INIRQA(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_INIRQA_SHIFT)) & ASRC_ASRCFG_INIRQA_MASK)

#define ASRC_ASRCFG_INIRQB_MASK                  (0x400000U)
#define ASRC_ASRCFG_INIRQB_SHIFT                 (22U)
/*! INIRQB - INIRQB
 *  0b0..Initialization for Conversion Pair B not served
 *  0b1..Initialization for Conversion Pair B served
 */
#define ASRC_ASRCFG_INIRQB(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_INIRQB_SHIFT)) & ASRC_ASRCFG_INIRQB_MASK)

#define ASRC_ASRCFG_INIRQC_MASK                  (0x800000U)
#define ASRC_ASRCFG_INIRQC_SHIFT                 (23U)
/*! INIRQC - INIRQC
 *  0b0..Initialization for Conversion Pair C not served
 *  0b1..Initialization for Conversion Pair C served
 */
#define ASRC_ASRCFG_INIRQC(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCFG_INIRQC_SHIFT)) & ASRC_ASRCFG_INIRQC_MASK)
/*! @} */

/*! @name ASRCSR - ASRC Clock Source Register */
/*! @{ */

#define ASRC_ASRCSR_AICSA_MASK                   (0xFU)
#define ASRC_ASRCSR_AICSA_SHIFT                  (0U)
/*! AICSA - AICSA
 *  0b0000..bit clock 0
 *  0b0001..bit clock 1
 *  0b0010..bit clock 2
 *  0b0011..bit clock 3
 *  0b0100..bit clock 4
 *  0b0101..bit clock 5
 *  0b0110..bit clock 6
 *  0b0111..bit clock 7
 *  0b1000..bit clock 8
 *  0b1001..bit clock 9
 *  0b1010..bit clock A
 *  0b1011..bit clock B
 *  0b1100..bit clock C
 *  0b1101..bit clock D
 *  0b1110..bit clock E
 *  0b1111..clock disabled, connected to zero
 */
#define ASRC_ASRCSR_AICSA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCSR_AICSA_SHIFT)) & ASRC_ASRCSR_AICSA_MASK)

#define ASRC_ASRCSR_AICSB_MASK                   (0xF0U)
#define ASRC_ASRCSR_AICSB_SHIFT                  (4U)
/*! AICSB - AICSB
 *  0b0000..bit clock 0
 *  0b0001..bit clock 1
 *  0b0010..bit clock 2
 *  0b0011..bit clock 3
 *  0b0100..bit clock 4
 *  0b0101..bit clock 5
 *  0b0110..bit clock 6
 *  0b0111..bit clock 7
 *  0b1000..bit clock 8
 *  0b1001..bit clock 9
 *  0b1010..bit clock A
 *  0b1011..bit clock B
 *  0b1100..bit clock C
 *  0b1101..bit clock D
 *  0b1110..bit clock E
 *  0b1111..clock disabled, connected to zero
 */
#define ASRC_ASRCSR_AICSB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCSR_AICSB_SHIFT)) & ASRC_ASRCSR_AICSB_MASK)

#define ASRC_ASRCSR_AICSC_MASK                   (0xF00U)
#define ASRC_ASRCSR_AICSC_SHIFT                  (8U)
/*! AICSC - AICSC
 *  0b0000..bit clock 0
 *  0b0001..bit clock 1
 *  0b0010..bit clock 2
 *  0b0011..bit clock 3
 *  0b0100..bit clock 4
 *  0b0101..bit clock 5
 *  0b0110..bit clock 6
 *  0b0111..bit clock 7
 *  0b1000..bit clock 8
 *  0b1001..bit clock 9
 *  0b1010..bit clock A
 *  0b1011..bit clock B
 *  0b1100..bit clock C
 *  0b1101..bit clock D
 *  0b1110..bit clock E
 *  0b1111..clock disabled, connected to zero
 */
#define ASRC_ASRCSR_AICSC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCSR_AICSC_SHIFT)) & ASRC_ASRCSR_AICSC_MASK)

#define ASRC_ASRCSR_AOCSA_MASK                   (0xF000U)
#define ASRC_ASRCSR_AOCSA_SHIFT                  (12U)
/*! AOCSA - AOCSA
 *  0b0000..bit clock 0
 *  0b0001..bit clock 1
 *  0b0010..bit clock 2
 *  0b0011..bit clock 3
 *  0b0100..bit clock 4
 *  0b0101..bit clock 5
 *  0b0110..bit clock 6
 *  0b0111..bit clock 7
 *  0b1000..bit clock 8
 *  0b1001..bit clock 9
 *  0b1010..bit clock A
 *  0b1011..bit clock B
 *  0b1100..bit clock C
 *  0b1101..bit clock D
 *  0b1110..bit clock E
 *  0b1111..clock disabled, connected to zero
 */
#define ASRC_ASRCSR_AOCSA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCSR_AOCSA_SHIFT)) & ASRC_ASRCSR_AOCSA_MASK)

#define ASRC_ASRCSR_AOCSB_MASK                   (0xF0000U)
#define ASRC_ASRCSR_AOCSB_SHIFT                  (16U)
/*! AOCSB - AOCSB
 *  0b0000..bit clock 0
 *  0b0001..bit clock 1
 *  0b0010..bit clock 2
 *  0b0011..bit clock 3
 *  0b0100..bit clock 4
 *  0b0101..bit clock 5
 *  0b0110..bit clock 6
 *  0b0111..bit clock 7
 *  0b1000..bit clock 8
 *  0b1001..bit clock 9
 *  0b1010..bit clock A
 *  0b1011..bit clock B
 *  0b1100..bit clock C
 *  0b1101..bit clock D
 *  0b1110..bit clock E
 *  0b1111..clock disabled, connected to zero
 */
#define ASRC_ASRCSR_AOCSB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCSR_AOCSB_SHIFT)) & ASRC_ASRCSR_AOCSB_MASK)

#define ASRC_ASRCSR_AOCSC_MASK                   (0xF00000U)
#define ASRC_ASRCSR_AOCSC_SHIFT                  (20U)
/*! AOCSC - AOCSC
 *  0b0000..bit clock 0
 *  0b0001..bit clock 1
 *  0b0010..bit clock 2
 *  0b0011..bit clock 3
 *  0b0100..bit clock 4
 *  0b0101..bit clock 5
 *  0b0110..bit clock 6
 *  0b0111..bit clock 7
 *  0b1000..bit clock 8
 *  0b1001..bit clock 9
 *  0b1010..bit clock A
 *  0b1011..bit clock B
 *  0b1100..bit clock C
 *  0b1101..bit clock D
 *  0b1110..bit clock E
 *  0b1111..clock disabled, connected to zero
 */
#define ASRC_ASRCSR_AOCSC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCSR_AOCSC_SHIFT)) & ASRC_ASRCSR_AOCSC_MASK)
/*! @} */

/*! @name ASRCDR1 - ASRC Clock Divider Register 1 */
/*! @{ */

#define ASRC_ASRCDR1_AICPA_MASK                  (0x7U)
#define ASRC_ASRCDR1_AICPA_SHIFT                 (0U)
/*! AICPA - AICPA
 */
#define ASRC_ASRCDR1_AICPA(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AICPA_SHIFT)) & ASRC_ASRCDR1_AICPA_MASK)

#define ASRC_ASRCDR1_AICDA_MASK                  (0x38U)
#define ASRC_ASRCDR1_AICDA_SHIFT                 (3U)
/*! AICDA - AICDA
 */
#define ASRC_ASRCDR1_AICDA(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AICDA_SHIFT)) & ASRC_ASRCDR1_AICDA_MASK)

#define ASRC_ASRCDR1_AICPB_MASK                  (0x1C0U)
#define ASRC_ASRCDR1_AICPB_SHIFT                 (6U)
/*! AICPB - AICPB
 */
#define ASRC_ASRCDR1_AICPB(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AICPB_SHIFT)) & ASRC_ASRCDR1_AICPB_MASK)

#define ASRC_ASRCDR1_AICDB_MASK                  (0xE00U)
#define ASRC_ASRCDR1_AICDB_SHIFT                 (9U)
/*! AICDB - AICDB
 */
#define ASRC_ASRCDR1_AICDB(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AICDB_SHIFT)) & ASRC_ASRCDR1_AICDB_MASK)

#define ASRC_ASRCDR1_AOCPA_MASK                  (0x7000U)
#define ASRC_ASRCDR1_AOCPA_SHIFT                 (12U)
/*! AOCPA - AOCPA
 */
#define ASRC_ASRCDR1_AOCPA(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AOCPA_SHIFT)) & ASRC_ASRCDR1_AOCPA_MASK)

#define ASRC_ASRCDR1_AOCDA_MASK                  (0x38000U)
#define ASRC_ASRCDR1_AOCDA_SHIFT                 (15U)
/*! AOCDA - AOCDA
 */
#define ASRC_ASRCDR1_AOCDA(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AOCDA_SHIFT)) & ASRC_ASRCDR1_AOCDA_MASK)

#define ASRC_ASRCDR1_AOCPB_MASK                  (0x1C0000U)
#define ASRC_ASRCDR1_AOCPB_SHIFT                 (18U)
/*! AOCPB - AOCPB
 */
#define ASRC_ASRCDR1_AOCPB(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AOCPB_SHIFT)) & ASRC_ASRCDR1_AOCPB_MASK)

#define ASRC_ASRCDR1_AOCDB_MASK                  (0xE00000U)
#define ASRC_ASRCDR1_AOCDB_SHIFT                 (21U)
/*! AOCDB - AOCDB
 */
#define ASRC_ASRCDR1_AOCDB(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR1_AOCDB_SHIFT)) & ASRC_ASRCDR1_AOCDB_MASK)
/*! @} */

/*! @name ASRCDR2 - ASRC Clock Divider Register 2 */
/*! @{ */

#define ASRC_ASRCDR2_AICPC_MASK                  (0x7U)
#define ASRC_ASRCDR2_AICPC_SHIFT                 (0U)
/*! AICPC - AICPC
 */
#define ASRC_ASRCDR2_AICPC(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR2_AICPC_SHIFT)) & ASRC_ASRCDR2_AICPC_MASK)

#define ASRC_ASRCDR2_AICDC_MASK                  (0x38U)
#define ASRC_ASRCDR2_AICDC_SHIFT                 (3U)
/*! AICDC - AICDC
 */
#define ASRC_ASRCDR2_AICDC(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR2_AICDC_SHIFT)) & ASRC_ASRCDR2_AICDC_MASK)

#define ASRC_ASRCDR2_AOCPC_MASK                  (0x1C0U)
#define ASRC_ASRCDR2_AOCPC_SHIFT                 (6U)
/*! AOCPC - AOCPC
 */
#define ASRC_ASRCDR2_AOCPC(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR2_AOCPC_SHIFT)) & ASRC_ASRCDR2_AOCPC_MASK)

#define ASRC_ASRCDR2_AOCDC_MASK                  (0xE00U)
#define ASRC_ASRCDR2_AOCDC_SHIFT                 (9U)
/*! AOCDC - AOCDC
 */
#define ASRC_ASRCDR2_AOCDC(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCDR2_AOCDC_SHIFT)) & ASRC_ASRCDR2_AOCDC_MASK)
/*! @} */

/*! @name ASRSTR - ASRC Status Register */
/*! @{ */

#define ASRC_ASRSTR_AIDEA_MASK                   (0x1U)
#define ASRC_ASRSTR_AIDEA_SHIFT                  (0U)
/*! AIDEA - AIDEA
 *  0b1..When AIDEA is set, the ASRC generates data input A interrupt request to the processor if ASRIER[AIDEA] = 1
 *  0b0..The threshold has been met and no data input A interrupt is generated
 */
#define ASRC_ASRSTR_AIDEA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIDEA_SHIFT)) & ASRC_ASRSTR_AIDEA_MASK)

#define ASRC_ASRSTR_AIDEB_MASK                   (0x2U)
#define ASRC_ASRSTR_AIDEB_SHIFT                  (1U)
/*! AIDEB - AIDEB
 *  0b1..When AIDEB is set, the ASRC generates data input B interrupt request to the processor if ASRIER[AIDEB] = 1
 *  0b0..The threshold has been met and no data input B interrupt is generated
 */
#define ASRC_ASRSTR_AIDEB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIDEB_SHIFT)) & ASRC_ASRSTR_AIDEB_MASK)

#define ASRC_ASRSTR_AIDEC_MASK                   (0x4U)
#define ASRC_ASRSTR_AIDEC_SHIFT                  (2U)
/*! AIDEC - AIDEC
 *  0b1..When AIDEC is set, the ASRC generates data input C interrupt request to the processor if ASRIER[AIDEC] = 1
 *  0b0..The threshold has been met and no data input C interrupt is generated
 */
#define ASRC_ASRSTR_AIDEC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIDEC_SHIFT)) & ASRC_ASRSTR_AIDEC_MASK)

#define ASRC_ASRSTR_AODFA_MASK                   (0x8U)
#define ASRC_ASRSTR_AODFA_SHIFT                  (3U)
/*! AODFA - AODFA
 *  0b1..When AODFA is set, the ASRC generates data output A interrupt request to the processor if ASRIER[ADOEA] = 1
 *  0b0..The threshold has not yet been met and no data output A interrupt is generated
 */
#define ASRC_ASRSTR_AODFA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AODFA_SHIFT)) & ASRC_ASRSTR_AODFA_MASK)

#define ASRC_ASRSTR_AODFB_MASK                   (0x10U)
#define ASRC_ASRSTR_AODFB_SHIFT                  (4U)
/*! AODFB - AODFB
 *  0b1..When AODFB is set, the ASRC generates data output B interrupt request to the processor if ASRIER[ADOEB] = 1
 *  0b0..The threshold has not yet been met and no data output B interrupt is generated
 */
#define ASRC_ASRSTR_AODFB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AODFB_SHIFT)) & ASRC_ASRSTR_AODFB_MASK)

#define ASRC_ASRSTR_AODFC_MASK                   (0x20U)
#define ASRC_ASRSTR_AODFC_SHIFT                  (5U)
/*! AODFC - AODFC
 *  0b1..When AODFC is set, the ASRC generates data output C interrupt request to the processor if ASRIER[ADOEC] = 1
 *  0b0..The threshold has not yet been met and no data output C interrupt is generated
 */
#define ASRC_ASRSTR_AODFC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AODFC_SHIFT)) & ASRC_ASRSTR_AODFC_MASK)

#define ASRC_ASRSTR_AOLE_MASK                    (0x40U)
#define ASRC_ASRSTR_AOLE_SHIFT                   (6U)
/*! AOLE - AOLE
 *  0b1..Task rate is too high
 *  0b0..No overload
 */
#define ASRC_ASRSTR_AOLE(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AOLE_SHIFT)) & ASRC_ASRSTR_AOLE_MASK)

#define ASRC_ASRSTR_FPWT_MASK                    (0x80U)
#define ASRC_ASRSTR_FPWT_SHIFT                   (7U)
/*! FPWT - FPWT
 *  0b0..ASRC is not in wait state
 *  0b1..ASRC is in wait state
 */
#define ASRC_ASRSTR_FPWT(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_FPWT_SHIFT)) & ASRC_ASRSTR_FPWT_MASK)

#define ASRC_ASRSTR_AIDUA_MASK                   (0x100U)
#define ASRC_ASRSTR_AIDUA_SHIFT                  (8U)
/*! AIDUA - AIDUA
 *  0b0..No Underflow in Input data buffer A
 *  0b1..Underflow in Input data buffer A
 */
#define ASRC_ASRSTR_AIDUA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIDUA_SHIFT)) & ASRC_ASRSTR_AIDUA_MASK)

#define ASRC_ASRSTR_AIDUB_MASK                   (0x200U)
#define ASRC_ASRSTR_AIDUB_SHIFT                  (9U)
/*! AIDUB - AIDUB
 *  0b0..No Underflow in Input data buffer B
 *  0b1..Underflow in Input data buffer B
 */
#define ASRC_ASRSTR_AIDUB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIDUB_SHIFT)) & ASRC_ASRSTR_AIDUB_MASK)

#define ASRC_ASRSTR_AIDUC_MASK                   (0x400U)
#define ASRC_ASRSTR_AIDUC_SHIFT                  (10U)
/*! AIDUC - AIDUC
 *  0b0..No Underflow in Input data buffer C
 *  0b1..Underflow in Input data buffer C
 */
#define ASRC_ASRSTR_AIDUC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIDUC_SHIFT)) & ASRC_ASRSTR_AIDUC_MASK)

#define ASRC_ASRSTR_AODOA_MASK                   (0x800U)
#define ASRC_ASRSTR_AODOA_SHIFT                  (11U)
/*! AODOA - AODOA
 *  0b0..No Overflow in Output data buffer A
 *  0b1..Overflow in Output data buffer A
 */
#define ASRC_ASRSTR_AODOA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AODOA_SHIFT)) & ASRC_ASRSTR_AODOA_MASK)

#define ASRC_ASRSTR_AODOB_MASK                   (0x1000U)
#define ASRC_ASRSTR_AODOB_SHIFT                  (12U)
/*! AODOB - AODOB
 *  0b0..No Overflow in Output data buffer B
 *  0b1..Overflow in Output data buffer B
 */
#define ASRC_ASRSTR_AODOB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AODOB_SHIFT)) & ASRC_ASRSTR_AODOB_MASK)

#define ASRC_ASRSTR_AODOC_MASK                   (0x2000U)
#define ASRC_ASRSTR_AODOC_SHIFT                  (13U)
/*! AODOC - AODOC
 *  0b0..No Overflow in Output data buffer C
 *  0b1..Overflow in Output data buffer C
 */
#define ASRC_ASRSTR_AODOC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AODOC_SHIFT)) & ASRC_ASRSTR_AODOC_MASK)

#define ASRC_ASRSTR_AIOLA_MASK                   (0x4000U)
#define ASRC_ASRSTR_AIOLA_SHIFT                  (14U)
/*! AIOLA - AIOLA
 *  0b0..Pair A input task is not oveloaded
 *  0b1..Pair A input task is oveloaded
 */
#define ASRC_ASRSTR_AIOLA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIOLA_SHIFT)) & ASRC_ASRSTR_AIOLA_MASK)

#define ASRC_ASRSTR_AIOLB_MASK                   (0x8000U)
#define ASRC_ASRSTR_AIOLB_SHIFT                  (15U)
/*! AIOLB - AIOLB
 *  0b0..Pair B input task is not oveloaded
 *  0b1..Pair B input task is oveloaded
 */
#define ASRC_ASRSTR_AIOLB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIOLB_SHIFT)) & ASRC_ASRSTR_AIOLB_MASK)

#define ASRC_ASRSTR_AIOLC_MASK                   (0x10000U)
#define ASRC_ASRSTR_AIOLC_SHIFT                  (16U)
/*! AIOLC - AIOLC
 *  0b0..Pair C input task is not oveloaded
 *  0b1..Pair C input task is oveloaded
 */
#define ASRC_ASRSTR_AIOLC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AIOLC_SHIFT)) & ASRC_ASRSTR_AIOLC_MASK)

#define ASRC_ASRSTR_AOOLA_MASK                   (0x20000U)
#define ASRC_ASRSTR_AOOLA_SHIFT                  (17U)
/*! AOOLA - AOOLA
 *  0b0..Pair A output task is not oveloaded
 *  0b1..Pair A output task is oveloaded
 */
#define ASRC_ASRSTR_AOOLA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AOOLA_SHIFT)) & ASRC_ASRSTR_AOOLA_MASK)

#define ASRC_ASRSTR_AOOLB_MASK                   (0x40000U)
#define ASRC_ASRSTR_AOOLB_SHIFT                  (18U)
/*! AOOLB - AOOLB
 *  0b0..Pair B output task is not oveloaded
 *  0b1..Pair B output task is oveloaded
 */
#define ASRC_ASRSTR_AOOLB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AOOLB_SHIFT)) & ASRC_ASRSTR_AOOLB_MASK)

#define ASRC_ASRSTR_AOOLC_MASK                   (0x80000U)
#define ASRC_ASRSTR_AOOLC_SHIFT                  (19U)
/*! AOOLC - AOOLC
 *  0b0..Pair C output task is not oveloaded
 *  0b1..Pair C output task is oveloaded
 */
#define ASRC_ASRSTR_AOOLC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_AOOLC_SHIFT)) & ASRC_ASRSTR_AOOLC_MASK)

#define ASRC_ASRSTR_ATQOL_MASK                   (0x100000U)
#define ASRC_ASRSTR_ATQOL_SHIFT                  (20U)
/*! ATQOL - ATQOL
 *  0b0..Task queue FIFO logic is not oveloaded
 *  0b1..Task queue FIFO logic is oveloaded
 */
#define ASRC_ASRSTR_ATQOL(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_ATQOL_SHIFT)) & ASRC_ASRSTR_ATQOL_MASK)

#define ASRC_ASRSTR_DSLCNT_MASK                  (0x200000U)
#define ASRC_ASRSTR_DSLCNT_SHIFT                 (21U)
/*! DSLCNT - DSLCNT
 *  0b0..New DSL counter information is in the process of storage into the internal ASRC FIFO
 *  0b1..New DSL counter information is stored in the internal ASRC FIFO
 */
#define ASRC_ASRSTR_DSLCNT(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASRSTR_DSLCNT_SHIFT)) & ASRC_ASRSTR_DSLCNT_MASK)
/*! @} */

/*! @name ASRPM - ASRC Parameter Register n */
/*! @{ */

#define ASRC_ASRPM_PARAMETER_VALUE_MASK          (0xFFFFFFU)
#define ASRC_ASRPM_PARAMETER_VALUE_SHIFT         (0U)
/*! PARAMETER_VALUE - PARAMETER_VALUE
 */
#define ASRC_ASRPM_PARAMETER_VALUE(x)            (((uint32_t)(((uint32_t)(x)) << ASRC_ASRPM_PARAMETER_VALUE_SHIFT)) & ASRC_ASRPM_PARAMETER_VALUE_MASK)
/*! @} */

/* The count of ASRC_ASRPM */
#define ASRC_ASRPM_COUNT                         (5U)

/*! @name ASRTFR1 - ASRC Task Queue FIFO Register 1 */
/*! @{ */

#define ASRC_ASRTFR1_TF_BASE_MASK                (0x1FC0U)
#define ASRC_ASRTFR1_TF_BASE_SHIFT               (6U)
/*! TF_BASE - TF_BASE
 */
#define ASRC_ASRTFR1_TF_BASE(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRTFR1_TF_BASE_SHIFT)) & ASRC_ASRTFR1_TF_BASE_MASK)

#define ASRC_ASRTFR1_TF_FILL_MASK                (0xFE000U)
#define ASRC_ASRTFR1_TF_FILL_SHIFT               (13U)
/*! TF_FILL - TF_FILL
 */
#define ASRC_ASRTFR1_TF_FILL(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRTFR1_TF_FILL_SHIFT)) & ASRC_ASRTFR1_TF_FILL_MASK)
/*! @} */

/*! @name ASRCCR - ASRC Channel Counter Register */
/*! @{ */

#define ASRC_ASRCCR_ACIA_MASK                    (0xFU)
#define ASRC_ASRCCR_ACIA_SHIFT                   (0U)
/*! ACIA - ACIA
 */
#define ASRC_ASRCCR_ACIA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCCR_ACIA_SHIFT)) & ASRC_ASRCCR_ACIA_MASK)

#define ASRC_ASRCCR_ACIB_MASK                    (0xF0U)
#define ASRC_ASRCCR_ACIB_SHIFT                   (4U)
/*! ACIB - ACIB
 */
#define ASRC_ASRCCR_ACIB(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCCR_ACIB_SHIFT)) & ASRC_ASRCCR_ACIB_MASK)

#define ASRC_ASRCCR_ACIC_MASK                    (0xF00U)
#define ASRC_ASRCCR_ACIC_SHIFT                   (8U)
/*! ACIC - ACIC
 */
#define ASRC_ASRCCR_ACIC(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCCR_ACIC_SHIFT)) & ASRC_ASRCCR_ACIC_MASK)

#define ASRC_ASRCCR_ACOA_MASK                    (0xF000U)
#define ASRC_ASRCCR_ACOA_SHIFT                   (12U)
/*! ACOA - ACOA
 */
#define ASRC_ASRCCR_ACOA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCCR_ACOA_SHIFT)) & ASRC_ASRCCR_ACOA_MASK)

#define ASRC_ASRCCR_ACOB_MASK                    (0xF0000U)
#define ASRC_ASRCCR_ACOB_SHIFT                   (16U)
/*! ACOB - ACOB
 */
#define ASRC_ASRCCR_ACOB(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCCR_ACOB_SHIFT)) & ASRC_ASRCCR_ACOB_MASK)

#define ASRC_ASRCCR_ACOC_MASK                    (0xF00000U)
#define ASRC_ASRCCR_ACOC_SHIFT                   (20U)
/*! ACOC - ACOC
 */
#define ASRC_ASRCCR_ACOC(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRCCR_ACOC_SHIFT)) & ASRC_ASRCCR_ACOC_MASK)
/*! @} */

/*! @name ASRDIA - ASRC Data Input Register for Pair x */
/*! @{ */

#define ASRC_ASRDIA_DATA_MASK                    (0xFFFFFFU)
#define ASRC_ASRDIA_DATA_SHIFT                   (0U)
/*! DATA - DATA
 */
#define ASRC_ASRDIA_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRDIA_DATA_SHIFT)) & ASRC_ASRDIA_DATA_MASK)
/*! @} */

/*! @name ASRDOA - ASRC Data Output Register for Pair x */
/*! @{ */

#define ASRC_ASRDOA_DATA_MASK                    (0xFFFFFFU)
#define ASRC_ASRDOA_DATA_SHIFT                   (0U)
/*! DATA - DATA
 */
#define ASRC_ASRDOA_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRDOA_DATA_SHIFT)) & ASRC_ASRDOA_DATA_MASK)
/*! @} */

/*! @name ASRDIB - ASRC Data Input Register for Pair x */
/*! @{ */

#define ASRC_ASRDIB_DATA_MASK                    (0xFFFFFFU)
#define ASRC_ASRDIB_DATA_SHIFT                   (0U)
/*! DATA - DATA
 */
#define ASRC_ASRDIB_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRDIB_DATA_SHIFT)) & ASRC_ASRDIB_DATA_MASK)
/*! @} */

/*! @name ASRDOB - ASRC Data Output Register for Pair x */
/*! @{ */

#define ASRC_ASRDOB_DATA_MASK                    (0xFFFFFFU)
#define ASRC_ASRDOB_DATA_SHIFT                   (0U)
/*! DATA - DATA
 */
#define ASRC_ASRDOB_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRDOB_DATA_SHIFT)) & ASRC_ASRDOB_DATA_MASK)
/*! @} */

/*! @name ASRDIC - ASRC Data Input Register for Pair x */
/*! @{ */

#define ASRC_ASRDIC_DATA_MASK                    (0xFFFFFFU)
#define ASRC_ASRDIC_DATA_SHIFT                   (0U)
/*! DATA - DATA
 */
#define ASRC_ASRDIC_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRDIC_DATA_SHIFT)) & ASRC_ASRDIC_DATA_MASK)
/*! @} */

/*! @name ASRDOC - ASRC Data Output Register for Pair x */
/*! @{ */

#define ASRC_ASRDOC_DATA_MASK                    (0xFFFFFFU)
#define ASRC_ASRDOC_DATA_SHIFT                   (0U)
/*! DATA - DATA
 */
#define ASRC_ASRDOC_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRDOC_DATA_SHIFT)) & ASRC_ASRDOC_DATA_MASK)
/*! @} */

/*! @name ASRIDRHA - ASRC Ideal Ratio for Pair A-High Part */
/*! @{ */

#define ASRC_ASRIDRHA_IDRATIOA_H_MASK            (0xFFU)
#define ASRC_ASRIDRHA_IDRATIOA_H_SHIFT           (0U)
/*! IDRATIOA_H - IDRATIOA_H
 */
#define ASRC_ASRIDRHA_IDRATIOA_H(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIDRHA_IDRATIOA_H_SHIFT)) & ASRC_ASRIDRHA_IDRATIOA_H_MASK)
/*! @} */

/*! @name ASRIDRLA - ASRC Ideal Ratio for Pair A -Low Part */
/*! @{ */

#define ASRC_ASRIDRLA_IDRATIOA_L_MASK            (0xFFFFFFU)
#define ASRC_ASRIDRLA_IDRATIOA_L_SHIFT           (0U)
/*! IDRATIOA_L - IDRATIOA_L
 */
#define ASRC_ASRIDRLA_IDRATIOA_L(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIDRLA_IDRATIOA_L_SHIFT)) & ASRC_ASRIDRLA_IDRATIOA_L_MASK)
/*! @} */

/*! @name ASRIDRHB - ASRC Ideal Ratio for Pair B-High Part */
/*! @{ */

#define ASRC_ASRIDRHB_IDRATIOB_H_MASK            (0xFFU)
#define ASRC_ASRIDRHB_IDRATIOB_H_SHIFT           (0U)
/*! IDRATIOB_H - IDRATIOB_H
 */
#define ASRC_ASRIDRHB_IDRATIOB_H(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIDRHB_IDRATIOB_H_SHIFT)) & ASRC_ASRIDRHB_IDRATIOB_H_MASK)
/*! @} */

/*! @name ASRIDRLB - ASRC Ideal Ratio for Pair B-Low Part */
/*! @{ */

#define ASRC_ASRIDRLB_IDRATIOB_L_MASK            (0xFFFFFFU)
#define ASRC_ASRIDRLB_IDRATIOB_L_SHIFT           (0U)
/*! IDRATIOB_L - IDRATIOB_L
 */
#define ASRC_ASRIDRLB_IDRATIOB_L(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIDRLB_IDRATIOB_L_SHIFT)) & ASRC_ASRIDRLB_IDRATIOB_L_MASK)
/*! @} */

/*! @name ASRIDRHC - ASRC Ideal Ratio for Pair C-High Part */
/*! @{ */

#define ASRC_ASRIDRHC_IDRATIOC_H_MASK            (0xFFU)
#define ASRC_ASRIDRHC_IDRATIOC_H_SHIFT           (0U)
/*! IDRATIOC_H - IDRATIOC_H
 */
#define ASRC_ASRIDRHC_IDRATIOC_H(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIDRHC_IDRATIOC_H_SHIFT)) & ASRC_ASRIDRHC_IDRATIOC_H_MASK)
/*! @} */

/*! @name ASRIDRLC - ASRC Ideal Ratio for Pair C-Low Part */
/*! @{ */

#define ASRC_ASRIDRLC_IDRATIOC_L_MASK            (0xFFFFFFU)
#define ASRC_ASRIDRLC_IDRATIOC_L_SHIFT           (0U)
/*! IDRATIOC_L - IDRATIOC_L
 */
#define ASRC_ASRIDRLC_IDRATIOC_L(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRIDRLC_IDRATIOC_L_SHIFT)) & ASRC_ASRIDRLC_IDRATIOC_L_MASK)
/*! @} */

/*! @name ASR76K - ASRC 76 kHz Period in terms of ASRC processing clock */
/*! @{ */

#define ASRC_ASR76K_ASR76K_MASK                  (0x1FFFFU)
#define ASRC_ASR76K_ASR76K_SHIFT                 (0U)
/*! ASR76K - ASR76K
 */
#define ASRC_ASR76K_ASR76K(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASR76K_ASR76K_SHIFT)) & ASRC_ASR76K_ASR76K_MASK)
/*! @} */

/*! @name ASR56K - ASRC 56 kHz Period in terms of ASRC processing clock */
/*! @{ */

#define ASRC_ASR56K_ASR56K_MASK                  (0x1FFFFU)
#define ASRC_ASR56K_ASR56K_SHIFT                 (0U)
/*! ASR56K - ASR56K
 */
#define ASRC_ASR56K_ASR56K(x)                    (((uint32_t)(((uint32_t)(x)) << ASRC_ASR56K_ASR56K_SHIFT)) & ASRC_ASR56K_ASR56K_MASK)
/*! @} */

/*! @name ASRMCRA - ASRC Misc Control Register for Pair A */
/*! @{ */

#define ASRC_ASRMCRA_INFIFO_THRESHOLDA_MASK      (0x3FU)
#define ASRC_ASRMCRA_INFIFO_THRESHOLDA_SHIFT     (0U)
/*! INFIFO_THRESHOLDA - INFIFO_THRESHOLDA
 */
#define ASRC_ASRMCRA_INFIFO_THRESHOLDA(x)        (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_INFIFO_THRESHOLDA_SHIFT)) & ASRC_ASRMCRA_INFIFO_THRESHOLDA_MASK)

#define ASRC_ASRMCRA_RSYNOFA_MASK                (0x400U)
#define ASRC_ASRMCRA_RSYNOFA_SHIFT               (10U)
/*! RSYNOFA - RSYNOFA
 *  0b1..Force ASRCCR[ACOA]=0
 *  0b0..Do not touch ASRCCR[ACOA]
 */
#define ASRC_ASRMCRA_RSYNOFA(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_RSYNOFA_SHIFT)) & ASRC_ASRMCRA_RSYNOFA_MASK)

#define ASRC_ASRMCRA_RSYNIFA_MASK                (0x800U)
#define ASRC_ASRMCRA_RSYNIFA_SHIFT               (11U)
/*! RSYNIFA - RSYNIFA
 *  0b1..Force ASRCCR[ACIA]=0
 *  0b0..Do not touch ASRCCR[ACIA]
 */
#define ASRC_ASRMCRA_RSYNIFA(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_RSYNIFA_SHIFT)) & ASRC_ASRMCRA_RSYNIFA_MASK)

#define ASRC_ASRMCRA_OUTFIFO_THRESHOLDA_MASK     (0x3F000U)
#define ASRC_ASRMCRA_OUTFIFO_THRESHOLDA_SHIFT    (12U)
/*! OUTFIFO_THRESHOLDA - OUTFIFO_THRESHOLDA
 */
#define ASRC_ASRMCRA_OUTFIFO_THRESHOLDA(x)       (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_OUTFIFO_THRESHOLDA_SHIFT)) & ASRC_ASRMCRA_OUTFIFO_THRESHOLDA_MASK)

#define ASRC_ASRMCRA_BYPASSPOLYA_MASK            (0x100000U)
#define ASRC_ASRMCRA_BYPASSPOLYA_SHIFT           (20U)
/*! BYPASSPOLYA - BYPASSPOLYA
 *  0b1..Bypass polyphase filtering.
 *  0b0..Don't bypass polyphase filtering.
 */
#define ASRC_ASRMCRA_BYPASSPOLYA(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_BYPASSPOLYA_SHIFT)) & ASRC_ASRMCRA_BYPASSPOLYA_MASK)

#define ASRC_ASRMCRA_BUFSTALLA_MASK              (0x200000U)
#define ASRC_ASRMCRA_BUFSTALLA_SHIFT             (21U)
/*! BUFSTALLA - BUFSTALLA
 *  0b1..Stall Pair A conversion in case of near empty/full FIFO conditions.
 *  0b0..Don't stall Pair A conversion even in case of near empty/full FIFO conditions.
 */
#define ASRC_ASRMCRA_BUFSTALLA(x)                (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_BUFSTALLA_SHIFT)) & ASRC_ASRMCRA_BUFSTALLA_MASK)

#define ASRC_ASRMCRA_EXTTHRSHA_MASK              (0x400000U)
#define ASRC_ASRMCRA_EXTTHRSHA_SHIFT             (22U)
/*! EXTTHRSHA - EXTTHRSHA
 *  0b1..Use external defined thresholds.
 *  0b0..Use default thresholds.
 */
#define ASRC_ASRMCRA_EXTTHRSHA(x)                (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_EXTTHRSHA_SHIFT)) & ASRC_ASRMCRA_EXTTHRSHA_MASK)

#define ASRC_ASRMCRA_ZEROBUFA_MASK               (0x800000U)
#define ASRC_ASRMCRA_ZEROBUFA_SHIFT              (23U)
/*! ZEROBUFA - ZEROBUFA
 *  0b1..Don't zeroize the buffer
 *  0b0..Zeroize the buffer
 */
#define ASRC_ASRMCRA_ZEROBUFA(x)                 (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRA_ZEROBUFA_SHIFT)) & ASRC_ASRMCRA_ZEROBUFA_MASK)
/*! @} */

/*! @name ASRFSTA - ASRC FIFO Status Register for Pair A */
/*! @{ */

#define ASRC_ASRFSTA_INFIFO_FILLA_MASK           (0x7FU)
#define ASRC_ASRFSTA_INFIFO_FILLA_SHIFT          (0U)
/*! INFIFO_FILLA - INFIFO_FILLA
 */
#define ASRC_ASRFSTA_INFIFO_FILLA(x)             (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTA_INFIFO_FILLA_SHIFT)) & ASRC_ASRFSTA_INFIFO_FILLA_MASK)

#define ASRC_ASRFSTA_IAEA_MASK                   (0x800U)
#define ASRC_ASRFSTA_IAEA_SHIFT                  (11U)
/*! IAEA - IAEA
 *  0b1..Input FIFO is near empty for Pair A
 *  0b0..Input FIFO is not near empty for Pair A
 */
#define ASRC_ASRFSTA_IAEA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTA_IAEA_SHIFT)) & ASRC_ASRFSTA_IAEA_MASK)

#define ASRC_ASRFSTA_OUTFIFO_FILLA_MASK          (0x7F000U)
#define ASRC_ASRFSTA_OUTFIFO_FILLA_SHIFT         (12U)
/*! OUTFIFO_FILLA - OUTFIFO_FILLA
 */
#define ASRC_ASRFSTA_OUTFIFO_FILLA(x)            (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTA_OUTFIFO_FILLA_SHIFT)) & ASRC_ASRFSTA_OUTFIFO_FILLA_MASK)

#define ASRC_ASRFSTA_OAFA_MASK                   (0x800000U)
#define ASRC_ASRFSTA_OAFA_SHIFT                  (23U)
/*! OAFA - OAFA
 *  0b1..Output FIFO is near full for Pair A
 *  0b0..Output FIFO is not near full for Pair A
 */
#define ASRC_ASRFSTA_OAFA(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTA_OAFA_SHIFT)) & ASRC_ASRFSTA_OAFA_MASK)
/*! @} */

/*! @name ASRMCRB - ASRC Misc Control Register for Pair B */
/*! @{ */

#define ASRC_ASRMCRB_INFIFO_THRESHOLDB_MASK      (0x3FU)
#define ASRC_ASRMCRB_INFIFO_THRESHOLDB_SHIFT     (0U)
/*! INFIFO_THRESHOLDB - INFIFO_THRESHOLDB
 */
#define ASRC_ASRMCRB_INFIFO_THRESHOLDB(x)        (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_INFIFO_THRESHOLDB_SHIFT)) & ASRC_ASRMCRB_INFIFO_THRESHOLDB_MASK)

#define ASRC_ASRMCRB_RSYNOFB_MASK                (0x400U)
#define ASRC_ASRMCRB_RSYNOFB_SHIFT               (10U)
/*! RSYNOFB - RSYNOFB
 *  0b1..Force ASRCCR[ACOB]=0
 *  0b0..Do not touch ASRCCR[ACOB]
 */
#define ASRC_ASRMCRB_RSYNOFB(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_RSYNOFB_SHIFT)) & ASRC_ASRMCRB_RSYNOFB_MASK)

#define ASRC_ASRMCRB_RSYNIFB_MASK                (0x800U)
#define ASRC_ASRMCRB_RSYNIFB_SHIFT               (11U)
/*! RSYNIFB - RSYNIFB
 *  0b1..Force ASRCCR[ACIB]=0
 *  0b0..Do not touch ASRCCR[ACIB]
 */
#define ASRC_ASRMCRB_RSYNIFB(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_RSYNIFB_SHIFT)) & ASRC_ASRMCRB_RSYNIFB_MASK)

#define ASRC_ASRMCRB_OUTFIFO_THRESHOLDB_MASK     (0x3F000U)
#define ASRC_ASRMCRB_OUTFIFO_THRESHOLDB_SHIFT    (12U)
/*! OUTFIFO_THRESHOLDB - OUTFIFO_THRESHOLDB
 */
#define ASRC_ASRMCRB_OUTFIFO_THRESHOLDB(x)       (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_OUTFIFO_THRESHOLDB_SHIFT)) & ASRC_ASRMCRB_OUTFIFO_THRESHOLDB_MASK)

#define ASRC_ASRMCRB_BYPASSPOLYB_MASK            (0x100000U)
#define ASRC_ASRMCRB_BYPASSPOLYB_SHIFT           (20U)
/*! BYPASSPOLYB - BYPASSPOLYB
 *  0b1..Bypass polyphase filtering.
 *  0b0..Don't bypass polyphase filtering.
 */
#define ASRC_ASRMCRB_BYPASSPOLYB(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_BYPASSPOLYB_SHIFT)) & ASRC_ASRMCRB_BYPASSPOLYB_MASK)

#define ASRC_ASRMCRB_BUFSTALLB_MASK              (0x200000U)
#define ASRC_ASRMCRB_BUFSTALLB_SHIFT             (21U)
/*! BUFSTALLB - BUFSTALLB
 *  0b1..Stall Pair B conversion in case of near empty/full FIFO conditions.
 *  0b0..Don't stall Pair B conversion even in case of near empty/full FIFO conditions.
 */
#define ASRC_ASRMCRB_BUFSTALLB(x)                (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_BUFSTALLB_SHIFT)) & ASRC_ASRMCRB_BUFSTALLB_MASK)

#define ASRC_ASRMCRB_EXTTHRSHB_MASK              (0x400000U)
#define ASRC_ASRMCRB_EXTTHRSHB_SHIFT             (22U)
/*! EXTTHRSHB - EXTTHRSHB
 *  0b1..Use external defined thresholds.
 *  0b0..Use default thresholds.
 */
#define ASRC_ASRMCRB_EXTTHRSHB(x)                (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_EXTTHRSHB_SHIFT)) & ASRC_ASRMCRB_EXTTHRSHB_MASK)

#define ASRC_ASRMCRB_ZEROBUFB_MASK               (0x800000U)
#define ASRC_ASRMCRB_ZEROBUFB_SHIFT              (23U)
/*! ZEROBUFB - ZEROBUFB
 *  0b1..Don't zeroize the buffer
 *  0b0..Zeroize the buffer
 */
#define ASRC_ASRMCRB_ZEROBUFB(x)                 (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRB_ZEROBUFB_SHIFT)) & ASRC_ASRMCRB_ZEROBUFB_MASK)
/*! @} */

/*! @name ASRFSTB - ASRC FIFO Status Register for Pair B */
/*! @{ */

#define ASRC_ASRFSTB_INFIFO_FILLB_MASK           (0x7FU)
#define ASRC_ASRFSTB_INFIFO_FILLB_SHIFT          (0U)
/*! INFIFO_FILLB - INFIFO_FILLB
 */
#define ASRC_ASRFSTB_INFIFO_FILLB(x)             (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTB_INFIFO_FILLB_SHIFT)) & ASRC_ASRFSTB_INFIFO_FILLB_MASK)

#define ASRC_ASRFSTB_IAEB_MASK                   (0x800U)
#define ASRC_ASRFSTB_IAEB_SHIFT                  (11U)
/*! IAEB - IAEB
 *  0b1..Input FIFO is near empty for Pair B
 *  0b0..Input FIFO is not near empty for Pair B
 */
#define ASRC_ASRFSTB_IAEB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTB_IAEB_SHIFT)) & ASRC_ASRFSTB_IAEB_MASK)

#define ASRC_ASRFSTB_OUTFIFO_FILLB_MASK          (0x7F000U)
#define ASRC_ASRFSTB_OUTFIFO_FILLB_SHIFT         (12U)
/*! OUTFIFO_FILLB - OUTFIFO_FILLB
 */
#define ASRC_ASRFSTB_OUTFIFO_FILLB(x)            (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTB_OUTFIFO_FILLB_SHIFT)) & ASRC_ASRFSTB_OUTFIFO_FILLB_MASK)

#define ASRC_ASRFSTB_OAFB_MASK                   (0x800000U)
#define ASRC_ASRFSTB_OAFB_SHIFT                  (23U)
/*! OAFB - OAFB
 *  0b1..Output FIFO is near full for Pair B
 *  0b0..Output FIFO is not near full for Pair B
 */
#define ASRC_ASRFSTB_OAFB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTB_OAFB_SHIFT)) & ASRC_ASRFSTB_OAFB_MASK)
/*! @} */

/*! @name ASRMCRC - ASRC Misc Control Register for Pair C */
/*! @{ */

#define ASRC_ASRMCRC_INFIFO_THRESHOLDC_MASK      (0x3FU)
#define ASRC_ASRMCRC_INFIFO_THRESHOLDC_SHIFT     (0U)
/*! INFIFO_THRESHOLDC - INFIFO_THRESHOLDC
 */
#define ASRC_ASRMCRC_INFIFO_THRESHOLDC(x)        (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_INFIFO_THRESHOLDC_SHIFT)) & ASRC_ASRMCRC_INFIFO_THRESHOLDC_MASK)

#define ASRC_ASRMCRC_RSYNOFC_MASK                (0x400U)
#define ASRC_ASRMCRC_RSYNOFC_SHIFT               (10U)
/*! RSYNOFC - RSYNOFC
 *  0b1..Force ASRCCR[ACOC]=0
 *  0b0..Do not touch ASRCCR[ACOC]
 */
#define ASRC_ASRMCRC_RSYNOFC(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_RSYNOFC_SHIFT)) & ASRC_ASRMCRC_RSYNOFC_MASK)

#define ASRC_ASRMCRC_RSYNIFC_MASK                (0x800U)
#define ASRC_ASRMCRC_RSYNIFC_SHIFT               (11U)
/*! RSYNIFC - RSYNIFC
 *  0b1..Force ASRCCR[ACIC]=0
 *  0b0..Do not touch ASRCCR[ACIC]
 */
#define ASRC_ASRMCRC_RSYNIFC(x)                  (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_RSYNIFC_SHIFT)) & ASRC_ASRMCRC_RSYNIFC_MASK)

#define ASRC_ASRMCRC_OUTFIFO_THRESHOLDC_MASK     (0x3F000U)
#define ASRC_ASRMCRC_OUTFIFO_THRESHOLDC_SHIFT    (12U)
/*! OUTFIFO_THRESHOLDC - OUTFIFO_THRESHOLDC
 */
#define ASRC_ASRMCRC_OUTFIFO_THRESHOLDC(x)       (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_OUTFIFO_THRESHOLDC_SHIFT)) & ASRC_ASRMCRC_OUTFIFO_THRESHOLDC_MASK)

#define ASRC_ASRMCRC_BYPASSPOLYC_MASK            (0x100000U)
#define ASRC_ASRMCRC_BYPASSPOLYC_SHIFT           (20U)
/*! BYPASSPOLYC - BYPASSPOLYC
 *  0b1..Bypass polyphase filtering.
 *  0b0..Don't bypass polyphase filtering.
 */
#define ASRC_ASRMCRC_BYPASSPOLYC(x)              (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_BYPASSPOLYC_SHIFT)) & ASRC_ASRMCRC_BYPASSPOLYC_MASK)

#define ASRC_ASRMCRC_BUFSTALLC_MASK              (0x200000U)
#define ASRC_ASRMCRC_BUFSTALLC_SHIFT             (21U)
/*! BUFSTALLC - BUFSTALLC
 *  0b1..Stall Pair C conversion in case of near empty/full FIFO conditions.
 *  0b0..Don't stall Pair C conversion even in case of near empty/full FIFO conditions.
 */
#define ASRC_ASRMCRC_BUFSTALLC(x)                (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_BUFSTALLC_SHIFT)) & ASRC_ASRMCRC_BUFSTALLC_MASK)

#define ASRC_ASRMCRC_EXTTHRSHC_MASK              (0x400000U)
#define ASRC_ASRMCRC_EXTTHRSHC_SHIFT             (22U)
/*! EXTTHRSHC - EXTTHRSHC
 *  0b1..Use external defined thresholds.
 *  0b0..Use default thresholds.
 */
#define ASRC_ASRMCRC_EXTTHRSHC(x)                (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_EXTTHRSHC_SHIFT)) & ASRC_ASRMCRC_EXTTHRSHC_MASK)

#define ASRC_ASRMCRC_ZEROBUFC_MASK               (0x800000U)
#define ASRC_ASRMCRC_ZEROBUFC_SHIFT              (23U)
/*! ZEROBUFC - ZEROBUFC
 *  0b1..Don't zeroize the buffer
 *  0b0..Zeroize the buffer
 */
#define ASRC_ASRMCRC_ZEROBUFC(x)                 (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCRC_ZEROBUFC_SHIFT)) & ASRC_ASRMCRC_ZEROBUFC_MASK)
/*! @} */

/*! @name ASRFSTC - ASRC FIFO Status Register for Pair C */
/*! @{ */

#define ASRC_ASRFSTC_INFIFO_FILLC_MASK           (0x7FU)
#define ASRC_ASRFSTC_INFIFO_FILLC_SHIFT          (0U)
/*! INFIFO_FILLC - INFIFO_FILLC
 */
#define ASRC_ASRFSTC_INFIFO_FILLC(x)             (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTC_INFIFO_FILLC_SHIFT)) & ASRC_ASRFSTC_INFIFO_FILLC_MASK)

#define ASRC_ASRFSTC_IAEC_MASK                   (0x800U)
#define ASRC_ASRFSTC_IAEC_SHIFT                  (11U)
/*! IAEC - IAEC
 *  0b1..Input FIFO is near empty for Pair C
 *  0b0..Input FIFO is not near empty for Pair C
 */
#define ASRC_ASRFSTC_IAEC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTC_IAEC_SHIFT)) & ASRC_ASRFSTC_IAEC_MASK)

#define ASRC_ASRFSTC_OUTFIFO_FILLC_MASK          (0x7F000U)
#define ASRC_ASRFSTC_OUTFIFO_FILLC_SHIFT         (12U)
/*! OUTFIFO_FILLC - OUTFIFO_FILLC
 */
#define ASRC_ASRFSTC_OUTFIFO_FILLC(x)            (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTC_OUTFIFO_FILLC_SHIFT)) & ASRC_ASRFSTC_OUTFIFO_FILLC_MASK)

#define ASRC_ASRFSTC_OAFC_MASK                   (0x800000U)
#define ASRC_ASRFSTC_OAFC_SHIFT                  (23U)
/*! OAFC - OAFC
 *  0b1..Output FIFO is near full for Pair C
 *  0b0..Output FIFO is not near full for Pair C
 */
#define ASRC_ASRFSTC_OAFC(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRFSTC_OAFC_SHIFT)) & ASRC_ASRFSTC_OAFC_MASK)
/*! @} */

/*! @name ASRMCR1 - ASRC Misc Control Register 1 for Pair X */
/*! @{ */

#define ASRC_ASRMCR1_OW16_MASK                   (0x1U)
#define ASRC_ASRMCR1_OW16_SHIFT                  (0U)
/*! OW16 - OW16
 *  0b1..16-bit output data
 *  0b0..24-bit output data.
 */
#define ASRC_ASRMCR1_OW16(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCR1_OW16_SHIFT)) & ASRC_ASRMCR1_OW16_MASK)

#define ASRC_ASRMCR1_OSGN_MASK                   (0x2U)
#define ASRC_ASRMCR1_OSGN_SHIFT                  (1U)
/*! OSGN - OSGN
 *  0b1..Sign extension.
 *  0b0..No sign extension.
 */
#define ASRC_ASRMCR1_OSGN(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCR1_OSGN_SHIFT)) & ASRC_ASRMCR1_OSGN_MASK)

#define ASRC_ASRMCR1_OMSB_MASK                   (0x4U)
#define ASRC_ASRMCR1_OMSB_SHIFT                  (2U)
/*! OMSB - OMSB
 *  0b1..MSB aligned.
 *  0b0..LSB aligned.
 */
#define ASRC_ASRMCR1_OMSB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCR1_OMSB_SHIFT)) & ASRC_ASRMCR1_OMSB_MASK)

#define ASRC_ASRMCR1_IMSB_MASK                   (0x100U)
#define ASRC_ASRMCR1_IMSB_SHIFT                  (8U)
/*! IMSB - IMSB
 *  0b1..MSB aligned.
 *  0b0..LSB aligned.
 */
#define ASRC_ASRMCR1_IMSB(x)                     (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCR1_IMSB_SHIFT)) & ASRC_ASRMCR1_IMSB_MASK)

#define ASRC_ASRMCR1_IWD_MASK                    (0x600U)
#define ASRC_ASRMCR1_IWD_SHIFT                   (9U)
/*! IWD - IWD
 *  0b00..24-bit audio data.
 *  0b01..16-bit audio data.
 *  0b10..8-bit audio data.
 *  0b11..Reserved.
 */
#define ASRC_ASRMCR1_IWD(x)                      (((uint32_t)(((uint32_t)(x)) << ASRC_ASRMCR1_IWD_SHIFT)) & ASRC_ASRMCR1_IWD_MASK)
/*! @} */

/* The count of ASRC_ASRMCR1 */
#define ASRC_ASRMCR1_COUNT                       (3U)


/*!
 * @}
 */ /* end of group ASRC_Register_Masks */


/* ASRC - Peripheral instance base addresses */
/** Peripheral ASRC base address */
#define ASRC_BASE                                (0x40414000u)
/** Peripheral ASRC base pointer */
#define ASRC                                     ((ASRC_Type *)ASRC_BASE)
/** Array initializer of ASRC peripheral base addresses */
#define ASRC_BASE_ADDRS                          { ASRC_BASE }
/** Array initializer of ASRC peripheral base pointers */
#define ASRC_BASE_PTRS                           { ASRC }
/** Interrupt vectors for the ASRC peripheral type */
#define ASRC_IRQS                                { ASRC_IRQn }

/*!
 * @}
 */ /* end of group ASRC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AUDIO_PLL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AUDIO_PLL_Peripheral_Access_Layer AUDIO_PLL Peripheral Access Layer
 * @{
 */

/** AUDIO_PLL - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0 */
    __IO uint32_t RW;                                /**< Fractional PLL Control Register, offset: 0x0 */
    __IO uint32_t SET;                               /**< Fractional PLL Control Register, offset: 0x4 */
    __IO uint32_t CLR;                               /**< Fractional PLL Control Register, offset: 0x8 */
    __IO uint32_t TOG;                               /**< Fractional PLL Control Register, offset: 0xC */
  } CTRL0;
  struct {                                         /* offset: 0x10 */
    __IO uint32_t RW;                                /**< Fractional PLL Spread Spectrum Control Register, offset: 0x10 */
    __IO uint32_t SET;                               /**< Fractional PLL Spread Spectrum Control Register, offset: 0x14 */
    __IO uint32_t CLR;                               /**< Fractional PLL Spread Spectrum Control Register, offset: 0x18 */
    __IO uint32_t TOG;                               /**< Fractional PLL Spread Spectrum Control Register, offset: 0x1C */
  } SPREAD_SPECTRUM;
  struct {                                         /* offset: 0x20 */
    __IO uint32_t RW;                                /**< Fractional PLL Numerator Control Register, offset: 0x20 */
    __IO uint32_t SET;                               /**< Fractional PLL Numerator Control Register, offset: 0x24 */
    __IO uint32_t CLR;                               /**< Fractional PLL Numerator Control Register, offset: 0x28 */
    __IO uint32_t TOG;                               /**< Fractional PLL Numerator Control Register, offset: 0x2C */
  } NUMERATOR;
  struct {                                         /* offset: 0x30 */
    __IO uint32_t RW;                                /**< Fractional PLL Denominator Control Register, offset: 0x30 */
    __IO uint32_t SET;                               /**< Fractional PLL Denominator Control Register, offset: 0x34 */
    __IO uint32_t CLR;                               /**< Fractional PLL Denominator Control Register, offset: 0x38 */
    __IO uint32_t TOG;                               /**< Fractional PLL Denominator Control Register, offset: 0x3C */
  } DENOMINATOR;
} AUDIO_PLL_Type;

/* ----------------------------------------------------------------------------
   -- AUDIO_PLL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AUDIO_PLL_Register_Masks AUDIO_PLL Register Masks
 * @{
 */

/*! @name CTRL0 - Fractional PLL Control Register */
/*! @{ */

#define AUDIO_PLL_CTRL0_DIV_SELECT_MASK          (0x7FU)
#define AUDIO_PLL_CTRL0_DIV_SELECT_SHIFT         (0U)
/*! DIV_SELECT - DIV_SELECT
 */
#define AUDIO_PLL_CTRL0_DIV_SELECT(x)            (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_CTRL0_DIV_SELECT_SHIFT)) & AUDIO_PLL_CTRL0_DIV_SELECT_MASK)

#define AUDIO_PLL_CTRL0_ENABLE_ALT_MASK          (0x100U)
#define AUDIO_PLL_CTRL0_ENABLE_ALT_SHIFT         (8U)
/*! ENABLE_ALT - ENABLE_ALT
 *  0b0..Disable the alternate clock output
 *  0b1..Enable the alternate clock output which is the output of the post_divider, and cannot be bypassed
 */
#define AUDIO_PLL_CTRL0_ENABLE_ALT(x)            (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_CTRL0_ENABLE_ALT_SHIFT)) & AUDIO_PLL_CTRL0_ENABLE_ALT_MASK)

#define AUDIO_PLL_CTRL0_HOLD_RING_OFF_MASK       (0x2000U)
#define AUDIO_PLL_CTRL0_HOLD_RING_OFF_SHIFT      (13U)
/*! HOLD_RING_OFF - PLL Start up initialization
 *  0b0..Normal operation
 *  0b1..Initialize PLL start up
 */
#define AUDIO_PLL_CTRL0_HOLD_RING_OFF(x)         (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_CTRL0_HOLD_RING_OFF_SHIFT)) & AUDIO_PLL_CTRL0_HOLD_RING_OFF_MASK)

#define AUDIO_PLL_CTRL0_POWERUP_MASK             (0x4000U)
#define AUDIO_PLL_CTRL0_POWERUP_SHIFT            (14U)
/*! POWERUP - POWERUP
 *  0b1..Power Up the PLL
 *  0b0..Power down the PLL
 */
#define AUDIO_PLL_CTRL0_POWERUP(x)               (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_CTRL0_POWERUP_SHIFT)) & AUDIO_PLL_CTRL0_POWERUP_MASK)

#define AUDIO_PLL_CTRL0_ENABLE_MASK              (0x8000U)
#define AUDIO_PLL_CTRL0_ENABLE_SHIFT             (15U)
/*! ENABLE - ENABLE
 *  0b1..Enable the clock output
 *  0b0..Disable the clock output
 */
#define AUDIO_PLL_CTRL0_ENABLE(x)                (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_CTRL0_ENABLE_SHIFT)) & AUDIO_PLL_CTRL0_ENABLE_MASK)

#define AUDIO_PLL_CTRL0_BYPASS_MASK              (0x10000U)
#define AUDIO_PLL_CTRL0_BYPASS_SHIFT             (16U)
/*! BYPASS - BYPASS
 *  0b1..Bypass the PLL
 *  0b0..No Bypass
 */
#define AUDIO_PLL_CTRL0_BYPASS(x)                (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_CTRL0_BYPASS_SHIFT)) & AUDIO_PLL_CTRL0_BYPASS_MASK)

#define AUDIO_PLL_CTRL0_DITHER_EN_MASK           (0x20000U)
#define AUDIO_PLL_CTRL0_DITHER_EN_SHIFT          (17U)
/*! DITHER_EN - DITHER_EN
 *  0b0..Disable Dither
 *  0b1..Enable Dither
 */
#define AUDIO_PLL_CTRL0_DITHER_EN(x)             (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_CTRL0_DITHER_EN_SHIFT)) & AUDIO_PLL_CTRL0_DITHER_EN_MASK)

#define AUDIO_PLL_CTRL0_BIAS_TRIM_MASK           (0x380000U)
#define AUDIO_PLL_CTRL0_BIAS_TRIM_SHIFT          (19U)
/*! BIAS_TRIM - BIAS_TRIM
 */
#define AUDIO_PLL_CTRL0_BIAS_TRIM(x)             (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_CTRL0_BIAS_TRIM_SHIFT)) & AUDIO_PLL_CTRL0_BIAS_TRIM_MASK)

#define AUDIO_PLL_CTRL0_PLL_REG_EN_MASK          (0x400000U)
#define AUDIO_PLL_CTRL0_PLL_REG_EN_SHIFT         (22U)
/*! PLL_REG_EN - PLL_REG_EN
 */
#define AUDIO_PLL_CTRL0_PLL_REG_EN(x)            (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_CTRL0_PLL_REG_EN_SHIFT)) & AUDIO_PLL_CTRL0_PLL_REG_EN_MASK)

#define AUDIO_PLL_CTRL0_POST_DIV_SEL_MASK        (0xE000000U)
#define AUDIO_PLL_CTRL0_POST_DIV_SEL_SHIFT       (25U)
/*! POST_DIV_SEL - Post Divide Select
 *  0b000..Divide by 1
 *  0b001..Divide by 2
 *  0b010..Divide by 4
 *  0b011..Divide by 8
 *  0b100..Divide by 16
 *  0b101..Divide by 32
 */
#define AUDIO_PLL_CTRL0_POST_DIV_SEL(x)          (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_CTRL0_POST_DIV_SEL_SHIFT)) & AUDIO_PLL_CTRL0_POST_DIV_SEL_MASK)

#define AUDIO_PLL_CTRL0_BIAS_SELECT_MASK         (0x20000000U)
#define AUDIO_PLL_CTRL0_BIAS_SELECT_SHIFT        (29U)
/*! BIAS_SELECT - BIAS_SELECT
 *  0b0..Used in SoCs with a bias current of 10uA
 *  0b1..Used in SoCs with a bias current of 2uA
 */
#define AUDIO_PLL_CTRL0_BIAS_SELECT(x)           (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_CTRL0_BIAS_SELECT_SHIFT)) & AUDIO_PLL_CTRL0_BIAS_SELECT_MASK)
/*! @} */

/*! @name SPREAD_SPECTRUM - Fractional PLL Spread Spectrum Control Register */
/*! @{ */

#define AUDIO_PLL_SPREAD_SPECTRUM_STEP_MASK      (0x7FFFU)
#define AUDIO_PLL_SPREAD_SPECTRUM_STEP_SHIFT     (0U)
/*! STEP - Step
 */
#define AUDIO_PLL_SPREAD_SPECTRUM_STEP(x)        (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_SPREAD_SPECTRUM_STEP_SHIFT)) & AUDIO_PLL_SPREAD_SPECTRUM_STEP_MASK)

#define AUDIO_PLL_SPREAD_SPECTRUM_ENABLE_MASK    (0x8000U)
#define AUDIO_PLL_SPREAD_SPECTRUM_ENABLE_SHIFT   (15U)
/*! ENABLE - Enable
 */
#define AUDIO_PLL_SPREAD_SPECTRUM_ENABLE(x)      (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_SPREAD_SPECTRUM_ENABLE_SHIFT)) & AUDIO_PLL_SPREAD_SPECTRUM_ENABLE_MASK)

#define AUDIO_PLL_SPREAD_SPECTRUM_STOP_MASK      (0xFFFF0000U)
#define AUDIO_PLL_SPREAD_SPECTRUM_STOP_SHIFT     (16U)
/*! STOP - Stop
 */
#define AUDIO_PLL_SPREAD_SPECTRUM_STOP(x)        (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_SPREAD_SPECTRUM_STOP_SHIFT)) & AUDIO_PLL_SPREAD_SPECTRUM_STOP_MASK)
/*! @} */

/*! @name NUMERATOR - Fractional PLL Numerator Control Register */
/*! @{ */

#define AUDIO_PLL_NUMERATOR_NUM_MASK             (0x3FFFFFFFU)
#define AUDIO_PLL_NUMERATOR_NUM_SHIFT            (0U)
/*! NUM - Numerator
 */
#define AUDIO_PLL_NUMERATOR_NUM(x)               (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_NUMERATOR_NUM_SHIFT)) & AUDIO_PLL_NUMERATOR_NUM_MASK)
/*! @} */

/*! @name DENOMINATOR - Fractional PLL Denominator Control Register */
/*! @{ */

#define AUDIO_PLL_DENOMINATOR_DENOM_MASK         (0x3FFFFFFFU)
#define AUDIO_PLL_DENOMINATOR_DENOM_SHIFT        (0U)
/*! DENOM - Denominator
 */
#define AUDIO_PLL_DENOMINATOR_DENOM(x)           (((uint32_t)(((uint32_t)(x)) << AUDIO_PLL_DENOMINATOR_DENOM_SHIFT)) & AUDIO_PLL_DENOMINATOR_DENOM_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group AUDIO_PLL_Register_Masks */


/* AUDIO_PLL - Peripheral instance base addresses */
/** Peripheral AUDIO_PLL base address */
#define AUDIO_PLL_BASE                           (0u)
/** Peripheral AUDIO_PLL base pointer */
#define AUDIO_PLL                                ((AUDIO_PLL_Type *)AUDIO_PLL_BASE)
/** Array initializer of AUDIO_PLL peripheral base addresses */
#define AUDIO_PLL_BASE_ADDRS                     { AUDIO_PLL_BASE }
/** Array initializer of AUDIO_PLL peripheral base pointers */
#define AUDIO_PLL_BASE_PTRS                      { AUDIO_PLL }

/*!
 * @}
 */ /* end of group AUDIO_PLL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CAAM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAAM_Peripheral_Access_Layer CAAM Peripheral Access Layer
 * @{
 */

/** CAAM - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[4];
  __IO uint32_t MCFGR;                             /**< Master Configuration Register, offset: 0x4 */
  __IO uint32_t PAGE0_SDID;                        /**< Page 0 SDID Register, offset: 0x8 */
  __IO uint32_t SCFGR;                             /**< Security Configuration Register, offset: 0xC */
  struct {                                         /* offset: 0x10, array step: 0x8 */
    __IO uint32_t JRDID_MS;                          /**< Job Ring 0 DID Register - most significant half..Job Ring 3 DID Register - most significant half, array offset: 0x10, array step: 0x8 */
    __IO uint32_t JRDID_LS;                          /**< Job Ring 0 DID Register - least significant half..Job Ring 3 DID Register - least significant half, array offset: 0x14, array step: 0x8 */
  } JRADID[4];
       uint8_t RESERVED_1[40];
  __IO uint32_t DEBUGCTL;                          /**< Debug Control Register, offset: 0x58 */
  __IO uint32_t JRSTARTR;                          /**< Job Ring Start Register, offset: 0x5C */
  __IO uint32_t RTIC_OWN;                          /**< RTIC OWN Register, offset: 0x60 */
  struct {                                         /* offset: 0x64, array step: 0x8 */
    __IO uint32_t RTIC_DID;                          /**< RTIC DID Register for Block A..RTIC DID Register for Block D, array offset: 0x64, array step: 0x8 */
         uint8_t RESERVED_0[4];
  } RTICADID[4];
       uint8_t RESERVED_2[16];
  __IO uint32_t DECORSR;                           /**< DECO Request Source Register, offset: 0x94 */
       uint8_t RESERVED_3[4];
  __IO uint32_t DECORR;                            /**< DECO Request Register, offset: 0x9C */
  struct {                                         /* offset: 0xA0, array step: 0x8 */
    __IO uint32_t DECODID_MS;                        /**< DECO0 DID Register - most significant half, array offset: 0xA0, array step: 0x8 */
    __IO uint32_t DECODID_LS;                        /**< DECO0 DID Register - least significant half, array offset: 0xA4, array step: 0x8 */
  } DECONDID[1];
       uint8_t RESERVED_4[120];
  __IO uint32_t DAR;                               /**< DECO Availability Register, offset: 0x120 */
  __O  uint32_t DRR;                               /**< DECO Reset Register, offset: 0x124 */
       uint8_t RESERVED_5[92];
  struct {                                         /* offset: 0x184, array step: 0x8 */
    __IO uint32_t JRSMVBAR;                          /**< Job Ring 0 Secure Memory Virtual Base Address Register..Job Ring 3 Secure Memory Virtual Base Address Register, array offset: 0x184, array step: 0x8 */
         uint8_t RESERVED_0[4];
  } JRNSMVBAR[4];
       uint8_t RESERVED_6[124];
  __IO uint32_t PBSL;                              /**< Peak Bandwidth Smoothing Limit Register, offset: 0x220 */
       uint8_t RESERVED_7[28];
  struct {                                         /* offset: 0x240, array step: 0x10 */
    __I  uint32_t DMA_AIDL_MAP_MS;                   /**< DMA0_AIDL_MAP_MS, array offset: 0x240, array step: 0x10 */
    __I  uint32_t DMA_AIDL_MAP_LS;                   /**< DMA0_AIDL_MAP_LS, array offset: 0x244, array step: 0x10 */
    __I  uint32_t DMA_AIDM_MAP_MS;                   /**< DMA0_AIDM_MAP_MS, array offset: 0x248, array step: 0x10 */
    __I  uint32_t DMA_AIDM_MAP_LS;                   /**< DMA0_AIDM_MAP_LS, array offset: 0x24C, array step: 0x10 */
  } AID_CNTS[1];
  __I  uint32_t DMA0_AID_ENB;                      /**< DMA0 AXI ID Enable Register, offset: 0x250 */
       uint8_t RESERVED_8[12];
  __IO uint64_t DMA0_ARD_TC;                       /**< DMA0 AXI Read Timing Check Register, offset: 0x260 */
       uint8_t RESERVED_9[4];
  __IO uint32_t DMA0_ARD_LAT;                      /**< DMA0 Read Timing Check Latency Register, offset: 0x26C */
  __IO uint64_t DMA0_AWR_TC;                       /**< DMA0 AXI Write Timing Check Register, offset: 0x270 */
       uint8_t RESERVED_10[4];
  __IO uint32_t DMA0_AWR_LAT;                      /**< DMA0 Write Timing Check Latency Register, offset: 0x27C */
       uint8_t RESERVED_11[128];
  __IO uint8_t MPPKR[64];                          /**< Manufacturing Protection Private Key Register, array offset: 0x300, array step: 0x1 */
       uint8_t RESERVED_12[64];
  __IO uint8_t MPMR[32];                           /**< Manufacturing Protection Message Register, array offset: 0x380, array step: 0x1 */
       uint8_t RESERVED_13[32];
  __I  uint8_t MPTESTR[32];                        /**< Manufacturing Protection Test Register, array offset: 0x3C0, array step: 0x1 */
       uint8_t RESERVED_14[24];
  __I  uint32_t MPECC;                             /**< Manufacturing Protection ECC Register, offset: 0x3F8 */
       uint8_t RESERVED_15[4];
  __IO uint32_t JDKEKR[8];                         /**< Job Descriptor Key Encryption Key Register, array offset: 0x400, array step: 0x4 */
  __IO uint32_t TDKEKR[8];                         /**< Trusted Descriptor Key Encryption Key Register, array offset: 0x420, array step: 0x4 */
  __IO uint32_t TDSKR[8];                          /**< Trusted Descriptor Signing Key Register, array offset: 0x440, array step: 0x4 */
       uint8_t RESERVED_16[128];
  __IO uint64_t SKNR;                              /**< Secure Key Nonce Register, offset: 0x4E0 */
       uint8_t RESERVED_17[36];
  __I  uint32_t DMA_STA;                           /**< DMA Status Register, offset: 0x50C */
  __I  uint32_t DMA_X_AID_7_4_MAP;                 /**< DMA_X_AID_7_4_MAP, offset: 0x510 */
  __I  uint32_t DMA_X_AID_3_0_MAP;                 /**< DMA_X_AID_3_0_MAP, offset: 0x514 */
  __I  uint32_t DMA_X_AID_15_12_MAP;               /**< DMA_X_AID_15_12_MAP, offset: 0x518 */
  __I  uint32_t DMA_X_AID_11_8_MAP;                /**< DMA_X_AID_11_8_MAP, offset: 0x51C */
       uint8_t RESERVED_18[4];
  __I  uint32_t DMA_X_AID_15_0_EN;                 /**< DMA_X AXI ID Map Enable Register, offset: 0x524 */
       uint8_t RESERVED_19[8];
  __IO uint32_t DMA_X_ARTC_CTL;                    /**< DMA_X AXI Read Timing Check Control Register, offset: 0x530 */
  __IO uint32_t DMA_X_ARTC_LC;                     /**< DMA_X AXI Read Timing Check Late Count Register, offset: 0x534 */
  __IO uint32_t DMA_X_ARTC_SC;                     /**< DMA_X AXI Read Timing Check Sample Count Register, offset: 0x538 */
  __IO uint32_t DMA_X_ARTC_LAT;                    /**< DMA_X Read Timing Check Latency Register, offset: 0x53C */
  __IO uint32_t DMA_X_AWTC_CTL;                    /**< DMA_X AXI Write Timing Check Control Register, offset: 0x540 */
  __IO uint32_t DMA_X_AWTC_LC;                     /**< DMA_X AXI Write Timing Check Late Count Register, offset: 0x544 */
  __IO uint32_t DMA_X_AWTC_SC;                     /**< DMA_X AXI Write Timing Check Sample Count Register, offset: 0x548 */
  __IO uint32_t DMA_X_AWTC_LAT;                    /**< DMA_X Write Timing Check Latency Register, offset: 0x54C */
       uint8_t RESERVED_20[176];
  __IO uint32_t RTMCTL;                            /**< RNG TRNG Miscellaneous Control Register, offset: 0x600 */
  __IO uint32_t RTSCMISC;                          /**< RNG TRNG Statistical Check Miscellaneous Register, offset: 0x604 */
  __IO uint32_t RTPKRRNG;                          /**< RNG TRNG Poker Range Register, offset: 0x608 */
  union {                                          /* offset: 0x60C */
    __IO uint32_t RTPKRMAX;                          /**< RNG TRNG Poker Maximum Limit Register, offset: 0x60C */
    __I  uint32_t RTPKRSQ;                           /**< RNG TRNG Poker Square Calculation Result Register, offset: 0x60C */
  };
  __IO uint32_t RTSDCTL;                           /**< RNG TRNG Seed Control Register, offset: 0x610 */
  union {                                          /* offset: 0x614 */
    __IO uint32_t RTSBLIM;                           /**< RNG TRNG Sparse Bit Limit Register, offset: 0x614 */
    __I  uint32_t RTTOTSAM;                          /**< RNG TRNG Total Samples Register, offset: 0x614 */
  };
  __IO uint32_t RTFRQMIN;                          /**< RNG TRNG Frequency Count Minimum Limit Register, offset: 0x618 */
  union {                                          /* offset: 0x61C */
    struct {                                         /* offset: 0x61C */
      __I  uint32_t RTFRQCNT;                          /**< RNG TRNG Frequency Count Register, offset: 0x61C */
      __I  uint32_t RTSCMC;                            /**< RNG TRNG Statistical Check Monobit Count Register, offset: 0x620 */
      __I  uint32_t RTSCR1C;                           /**< RNG TRNG Statistical Check Run Length 1 Count Register, offset: 0x624 */
      __I  uint32_t RTSCR2C;                           /**< RNG TRNG Statistical Check Run Length 2 Count Register, offset: 0x628 */
      __I  uint32_t RTSCR3C;                           /**< RNG TRNG Statistical Check Run Length 3 Count Register, offset: 0x62C */
      __I  uint32_t RTSCR4C;                           /**< RNG TRNG Statistical Check Run Length 4 Count Register, offset: 0x630 */
      __I  uint32_t RTSCR5C;                           /**< RNG TRNG Statistical Check Run Length 5 Count Register, offset: 0x634 */
      __I  uint32_t RTSCR6PC;                          /**< RNG TRNG Statistical Check Run Length 6+ Count Register, offset: 0x638 */
    } COUNT;
    struct {                                         /* offset: 0x61C */
      __IO uint32_t RTFRQMAX;                          /**< RNG TRNG Frequency Count Maximum Limit Register, offset: 0x61C */
      __IO uint32_t RTSCML;                            /**< RNG TRNG Statistical Check Monobit Limit Register, offset: 0x620 */
      __IO uint32_t RTSCR1L;                           /**< RNG TRNG Statistical Check Run Length 1 Limit Register, offset: 0x624 */
      __IO uint32_t RTSCR2L;                           /**< RNG TRNG Statistical Check Run Length 2 Limit Register, offset: 0x628 */
      __IO uint32_t RTSCR3L;                           /**< RNG TRNG Statistical Check Run Length 3 Limit Register, offset: 0x62C */
      __IO uint32_t RTSCR4L;                           /**< RNG TRNG Statistical Check Run Length 4 Limit Register, offset: 0x630 */
      __IO uint32_t RTSCR5L;                           /**< RNG TRNG Statistical Check Run Length 5 Limit Register, offset: 0x634 */
      __IO uint32_t RTSCR6PL;                          /**< RNG TRNG Statistical Check Run Length 6+ Limit Register, offset: 0x638 */
    } LIMIT;
  };
  __I  uint32_t RTSTATUS;                          /**< RNG TRNG Status Register, offset: 0x63C */
  __I  uint32_t RTENT[16];                         /**< RNG TRNG Entropy Read Register, array offset: 0x640, array step: 0x4 */
  __I  uint32_t RTPKRCNT10;                        /**< RNG TRNG Statistical Check Poker Count 1 and 0 Register, offset: 0x680 */
  __I  uint32_t RTPKRCNT32;                        /**< RNG TRNG Statistical Check Poker Count 3 and 2 Register, offset: 0x684 */
  __I  uint32_t RTPKRCNT54;                        /**< RNG TRNG Statistical Check Poker Count 5 and 4 Register, offset: 0x688 */
  __I  uint32_t RTPKRCNT76;                        /**< RNG TRNG Statistical Check Poker Count 7 and 6 Register, offset: 0x68C */
  __I  uint32_t RTPKRCNT98;                        /**< RNG TRNG Statistical Check Poker Count 9 and 8 Register, offset: 0x690 */
  __I  uint32_t RTPKRCNTBA;                        /**< RNG TRNG Statistical Check Poker Count B and A Register, offset: 0x694 */
  __I  uint32_t RTPKRCNTDC;                        /**< RNG TRNG Statistical Check Poker Count D and C Register, offset: 0x698 */
  __I  uint32_t RTPKRCNTFE;                        /**< RNG TRNG Statistical Check Poker Count F and E Register, offset: 0x69C */
       uint8_t RESERVED_21[32];
  __I  uint32_t RDSTA;                             /**< RNG DRNG Status Register, offset: 0x6C0 */
       uint8_t RESERVED_22[12];
  __I  uint32_t RDINT0;                            /**< RNG DRNG State Handle 0 Reseed Interval Register, offset: 0x6D0 */
  __I  uint32_t RDINT1;                            /**< RNG DRNG State Handle 1 Reseed Interval Register, offset: 0x6D4 */
       uint8_t RESERVED_23[8];
  __IO uint32_t RDHCNTL;                           /**< RNG DRNG Hash Control Register, offset: 0x6E0 */
  __I  uint32_t RDHDIG;                            /**< RNG DRNG Hash Digest Register, offset: 0x6E4 */
  __O  uint32_t RDHBUF;                            /**< RNG DRNG Hash Buffer Register, offset: 0x6E8 */
       uint8_t RESERVED_24[788];
  struct {                                         /* offset: 0xA00, array step: 0x10 */
    __I  uint32_t PX_SDID_PG0;                       /**< Partition 0 SDID register..Partition 15 SDID register, array offset: 0xA00, array step: 0x10 */
    __IO uint32_t PX_SMAPR_PG0;                      /**< Secure Memory Access Permissions register, array offset: 0xA04, array step: 0x10 */
    __IO uint32_t PX_SMAG2_PG0;                      /**< Secure Memory Access Group Registers, array offset: 0xA08, array step: 0x10 */
    __IO uint32_t PX_SMAG1_PG0;                      /**< Secure Memory Access Group Registers, array offset: 0xA0C, array step: 0x10 */
  } PX_PG0[16];
  __IO uint32_t REIS;                              /**< Recoverable Error Interrupt Status, offset: 0xB00 */
  __IO uint32_t REIE;                              /**< Recoverable Error Interrupt Enable, offset: 0xB04 */
  __I  uint32_t REIF;                              /**< Recoverable Error Interrupt Force, offset: 0xB08 */
  __IO uint32_t REIH;                              /**< Recoverable Error Interrupt Halt, offset: 0xB0C */
       uint8_t RESERVED_25[192];
  __IO uint32_t SMWPJRR[4];                        /**< Secure Memory Write Protect Job Ring Register, array offset: 0xBD0, array step: 0x4 */
       uint8_t RESERVED_26[4];
  __O  uint32_t SMCR_PG0;                          /**< Secure Memory Command Register, offset: 0xBE4 */
       uint8_t RESERVED_27[4];
  __I  uint32_t SMCSR_PG0;                         /**< Secure Memory Command Status Register, offset: 0xBEC */
       uint8_t RESERVED_28[8];
  __I  uint32_t CAAMVID_MS_TRAD;                   /**< CAAM Version ID Register, most-significant half, offset: 0xBF8 */
  __I  uint32_t CAAMVID_LS_TRAD;                   /**< CAAM Version ID Register, least-significant half, offset: 0xBFC */
  struct {                                         /* offset: 0xC00, array step: 0x20 */
    __I  uint64_t HT_JD_ADDR;                        /**< Holding Tank 0 Job Descriptor Address, array offset: 0xC00, array step: 0x20 */
    __I  uint64_t HT_SD_ADDR;                        /**< Holding Tank 0 Shared Descriptor Address, array offset: 0xC08, array step: 0x20 */
    __I  uint32_t HT_JQ_CTRL_MS;                     /**< Holding Tank 0 Job Queue Control, most-significant half, array offset: 0xC10, array step: 0x20 */
    __I  uint32_t HT_JQ_CTRL_LS;                     /**< Holding Tank 0 Job Queue Control, least-significant half, array offset: 0xC14, array step: 0x20 */
         uint8_t RESERVED_0[4];
    __I  uint32_t HT_STATUS;                         /**< Holding Tank Status, array offset: 0xC1C, array step: 0x20 */
  } HTA[1];
       uint8_t RESERVED_29[4];
  __IO uint32_t JQ_DEBUG_SEL;                      /**< Job Queue Debug Select Register, offset: 0xC24 */
       uint8_t RESERVED_30[404];
  __I  uint32_t JRJIDU_LS;                         /**< Job Ring Job IDs in Use Register, least-significant half, offset: 0xDBC */
  __I  uint32_t JRJDJIFBC;                         /**< Job Ring Job-Done Job ID FIFO BC, offset: 0xDC0 */
  __I  uint32_t JRJDJIF;                           /**< Job Ring Job-Done Job ID FIFO, offset: 0xDC4 */
       uint8_t RESERVED_31[28];
  __I  uint32_t JRJDS1;                            /**< Job Ring Job-Done Source 1, offset: 0xDE4 */
       uint8_t RESERVED_32[24];
  __I  uint64_t JRJDDA[1];                         /**< Job Ring Job-Done Descriptor Address 0 Register, array offset: 0xE00, array step: 0x8 */
       uint8_t RESERVED_33[408];
  __I  uint32_t CRNR_MS;                           /**< CHA Revision Number Register, most-significant half, offset: 0xFA0 */
  __I  uint32_t CRNR_LS;                           /**< CHA Revision Number Register, least-significant half, offset: 0xFA4 */
  __I  uint32_t CTPR_MS;                           /**< Compile Time Parameters Register, most-significant half, offset: 0xFA8 */
  __I  uint32_t CTPR_LS;                           /**< Compile Time Parameters Register, least-significant half, offset: 0xFAC */
       uint8_t RESERVED_34[4];
  __I  uint32_t SMSTA;                             /**< Secure Memory Status Register, offset: 0xFB4 */
       uint8_t RESERVED_35[4];
  __I  uint32_t SMPO;                              /**< Secure Memory Partition Owners Register, offset: 0xFBC */
  __I  uint64_t FAR;                               /**< Fault Address Register, offset: 0xFC0 */
  __I  uint32_t FADID;                             /**< Fault Address DID Register, offset: 0xFC8 */
  __I  uint32_t FADR;                              /**< Fault Address Detail Register, offset: 0xFCC */
       uint8_t RESERVED_36[4];
  __I  uint32_t CSTA;                              /**< CAAM Status Register, offset: 0xFD4 */
  __I  uint32_t SMVID_MS;                          /**< Secure Memory Version ID Register, most-significant half, offset: 0xFD8 */
  __I  uint32_t SMVID_LS;                          /**< Secure Memory Version ID Register, least-significant half, offset: 0xFDC */
  __I  uint32_t RVID;                              /**< RTIC Version ID Register, offset: 0xFE0 */
  __I  uint32_t CCBVID;                            /**< CHA Cluster Block Version ID Register, offset: 0xFE4 */
  __I  uint32_t CHAVID_MS;                         /**< CHA Version ID Register, most-significant half, offset: 0xFE8 */
  __I  uint32_t CHAVID_LS;                         /**< CHA Version ID Register, least-significant half, offset: 0xFEC */
  __I  uint32_t CHANUM_MS;                         /**< CHA Number Register, most-significant half, offset: 0xFF0 */
  __I  uint32_t CHANUM_LS;                         /**< CHA Number Register, least-significant half, offset: 0xFF4 */
  __I  uint32_t CAAMVID_MS;                        /**< CAAM Version ID Register, most-significant half, offset: 0xFF8 */
  __I  uint32_t CAAMVID_LS;                        /**< CAAM Version ID Register, least-significant half, offset: 0xFFC */
       uint8_t RESERVED_37[61440];
  struct {                                         /* offset: 0x10000, array step: 0x10000 */
    __IO uint64_t IRBAR_JR;                          /**< Input Ring Base Address Register for Job Ring 0..Input Ring Base Address Register for Job Ring 3, array offset: 0x10000, array step: 0x10000 */
         uint8_t RESERVED_0[4];
    __IO uint32_t IRSR_JR;                           /**< Input Ring Size Register for Job Ring 0..Input Ring Size Register for Job Ring 3, array offset: 0x1000C, array step: 0x10000 */
         uint8_t RESERVED_1[4];
    __IO uint32_t IRSAR_JR;                          /**< Input Ring Slots Available Register for Job Ring 0..Input Ring Slots Available Register for Job Ring 3, array offset: 0x10014, array step: 0x10000 */
         uint8_t RESERVED_2[4];
    __IO uint32_t IRJAR_JR;                          /**< Input Ring Jobs Added Register for Job Ring0..Input Ring Jobs Added Register for Job Ring3, array offset: 0x1001C, array step: 0x10000 */
    __IO uint64_t ORBAR_JR;                          /**< Output Ring Base Address Register for Job Ring 0..Output Ring Base Address Register for Job Ring 3, array offset: 0x10020, array step: 0x10000 */
         uint8_t RESERVED_3[4];
    __IO uint32_t ORSR_JR;                           /**< Output Ring Size Register for Job Ring 0..Output Ring Size Register for Job Ring 3, array offset: 0x1002C, array step: 0x10000 */
         uint8_t RESERVED_4[4];
    __IO uint32_t ORJRR_JR;                          /**< Output Ring Jobs Removed Register for Job Ring 0..Output Ring Jobs Removed Register for Job Ring 3, array offset: 0x10034, array step: 0x10000 */
         uint8_t RESERVED_5[4];
    __IO uint32_t ORSFR_JR;                          /**< Output Ring Slots Full Register for Job Ring 0..Output Ring Slots Full Register for Job Ring 3, array offset: 0x1003C, array step: 0x10000 */
         uint8_t RESERVED_6[4];
    __I  uint32_t JRSTAR_JR;                         /**< Job Ring Output Status Register for Job Ring 0..Job Ring Output Status Register for Job Ring 3, array offset: 0x10044, array step: 0x10000 */
         uint8_t RESERVED_7[4];
    __IO uint32_t JRINTR_JR;                         /**< Job Ring Interrupt Status Register for Job Ring 0..Job Ring Interrupt Status Register for Job Ring 3, array offset: 0x1004C, array step: 0x10000 */
    __IO uint32_t JRCFGR_JR_MS;                      /**< Job Ring Configuration Register for Job Ring 0, most-significant half..Job Ring Configuration Register for Job Ring 3, most-significant half, array offset: 0x10050, array step: 0x10000 */
    __IO uint32_t JRCFGR_JR_LS;                      /**< Job Ring Configuration Register for Job Ring 0, least-significant half..Job Ring Configuration Register for Job Ring 3, least-significant half, array offset: 0x10054, array step: 0x10000 */
         uint8_t RESERVED_8[4];
    __IO uint32_t IRRIR_JR;                          /**< Input Ring Read Index Register for Job Ring 0..Input Ring Read Index Register for Job Ring 3, array offset: 0x1005C, array step: 0x10000 */
         uint8_t RESERVED_9[4];
    __IO uint32_t ORWIR_JR;                          /**< Output Ring Write Index Register for Job Ring 0..Output Ring Write Index Register for Job Ring 3, array offset: 0x10064, array step: 0x10000 */
         uint8_t RESERVED_10[4];
    __O  uint32_t JRCR_JR;                           /**< Job Ring Command Register for Job Ring 0..Job Ring Command Register for Job Ring 3, array offset: 0x1006C, array step: 0x10000 */
         uint8_t RESERVED_11[1684];
    __I  uint32_t JRAAV;                             /**< Job Ring 0 Address-Array Valid Register..Job Ring 3 Address-Array Valid Register, array offset: 0x10704, array step: 0x10000 */
         uint8_t RESERVED_12[248];
    __I  uint64_t JRAAA[4];                          /**< Job Ring 0 Address-Array Address 0 Register..Job Ring 3 Address-Array Address 3 Register, array offset: 0x10800, array step: index*0x10000, index2*0x8 */
         uint8_t RESERVED_13[480];
    struct {                                         /* offset: 0x10A00, array step: index*0x10000, index2*0x10 */
      __I  uint32_t PX_SDID_JR;                        /**< Partition 0 SDID register..Partition 15 SDID register, array offset: 0x10A00, array step: index*0x10000, index2*0x10 */
      __IO uint32_t PX_SMAPR_JR;                       /**< Secure Memory Access Permissions register, array offset: 0x10A04, array step: index*0x10000, index2*0x10 */
      __IO uint32_t PX_SMAG2_JR;                       /**< Secure Memory Access Group Registers, array offset: 0x10A08, array step: index*0x10000, index2*0x10 */
      __IO uint32_t PX_SMAG1_JR;                       /**< Secure Memory Access Group Registers, array offset: 0x10A0C, array step: index*0x10000, index2*0x10 */
    } PX_JR[16];
         uint8_t RESERVED_14[228];
    __O  uint32_t SMCR_JR;                           /**< Secure Memory Command Register, array offset: 0x10BE4, array step: 0x10000 */
         uint8_t RESERVED_15[4];
    __I  uint32_t SMCSR_JR;                          /**< Secure Memory Command Status Register, array offset: 0x10BEC, array step: 0x10000 */
         uint8_t RESERVED_16[528];
    __I  uint32_t REIR0JR;                           /**< Recoverable Error Interrupt Record 0 for Job Ring 0..Recoverable Error Interrupt Record 0 for Job Ring 3, array offset: 0x10E00, array step: 0x10000 */
         uint8_t RESERVED_17[4];
    __I  uint64_t REIR2JR;                           /**< Recoverable Error Interrupt Record 2 for Job Ring 0..Recoverable Error Interrupt Record 2 for Job Ring 3, array offset: 0x10E08, array step: 0x10000 */
    __I  uint32_t REIR4JR;                           /**< Recoverable Error Interrupt Record 4 for Job Ring 0..Recoverable Error Interrupt Record 4 for Job Ring 3, array offset: 0x10E10, array step: 0x10000 */
    __I  uint32_t REIR5JR;                           /**< Recoverable Error Interrupt Record 5 for Job Ring 0..Recoverable Error Interrupt Record 5 for Job Ring 3, array offset: 0x10E14, array step: 0x10000 */
         uint8_t RESERVED_18[392];
    __I  uint32_t CRNR_MS_JR;                        /**< CHA Revision Number Register, most-significant half, array offset: 0x10FA0, array step: 0x10000 */
    __I  uint32_t CRNR_LS_JR;                        /**< CHA Revision Number Register, least-significant half, array offset: 0x10FA4, array step: 0x10000 */
    __I  uint32_t CTPR_MS_JR;                        /**< Compile Time Parameters Register, most-significant half, array offset: 0x10FA8, array step: 0x10000 */
    __I  uint32_t CTPR_LS_JR;                        /**< Compile Time Parameters Register, least-significant half, array offset: 0x10FAC, array step: 0x10000 */
         uint8_t RESERVED_19[4];
    __I  uint32_t SMSTA_JR;                          /**< Secure Memory Status Register, array offset: 0x10FB4, array step: 0x10000 */
         uint8_t RESERVED_20[4];
    __I  uint32_t SMPO_JR;                           /**< Secure Memory Partition Owners Register, array offset: 0x10FBC, array step: 0x10000 */
    __I  uint64_t FAR_JR;                            /**< Fault Address Register, array offset: 0x10FC0, array step: 0x10000 */
    __I  uint32_t FADID_JR;                          /**< Fault Address DID Register, array offset: 0x10FC8, array step: 0x10000 */
    __I  uint32_t FADR_JR;                           /**< Fault Address Detail Register, array offset: 0x10FCC, array step: 0x10000 */
         uint8_t RESERVED_21[4];
    __I  uint32_t CSTA_JR;                           /**< CAAM Status Register, array offset: 0x10FD4, array step: 0x10000 */
    __I  uint32_t SMVID_MS_JR;                       /**< Secure Memory Version ID Register, most-significant half, array offset: 0x10FD8, array step: 0x10000 */
    __I  uint32_t SMVID_LS_JR;                       /**< Secure Memory Version ID Register, least-significant half, array offset: 0x10FDC, array step: 0x10000 */
    __I  uint32_t RVID_JR;                           /**< RTIC Version ID Register, array offset: 0x10FE0, array step: 0x10000 */
    __I  uint32_t CCBVID_JR;                         /**< CHA Cluster Block Version ID Register, array offset: 0x10FE4, array step: 0x10000 */
    __I  uint32_t CHAVID_MS_JR;                      /**< CHA Version ID Register, most-significant half, array offset: 0x10FE8, array step: 0x10000 */
    __I  uint32_t CHAVID_LS_JR;                      /**< CHA Version ID Register, least-significant half, array offset: 0x10FEC, array step: 0x10000 */
    __I  uint32_t CHANUM_MS_JR;                      /**< CHA Number Register, most-significant half, array offset: 0x10FF0, array step: 0x10000 */
    __I  uint32_t CHANUM_LS_JR;                      /**< CHA Number Register, least-significant half, array offset: 0x10FF4, array step: 0x10000 */
    __I  uint32_t CAAMVID_MS_JR;                     /**< CAAM Version ID Register, most-significant half, array offset: 0x10FF8, array step: 0x10000 */
    __I  uint32_t CAAMVID_LS_JR;                     /**< CAAM Version ID Register, least-significant half, array offset: 0x10FFC, array step: 0x10000 */
         uint8_t RESERVED_22[61440];
  } JOBRING[4];
       uint8_t RESERVED_38[65540];
  __I  uint32_t RSTA;                              /**< RTIC Status Register, offset: 0x60004 */
       uint8_t RESERVED_39[4];
  __IO uint32_t RCMD;                              /**< RTIC Command Register, offset: 0x6000C */
       uint8_t RESERVED_40[4];
  __IO uint32_t RCTL;                              /**< RTIC Control Register, offset: 0x60014 */
       uint8_t RESERVED_41[4];
  __IO uint32_t RTHR;                              /**< RTIC Throttle Register, offset: 0x6001C */
       uint8_t RESERVED_42[8];
  __IO uint64_t RWDOG;                             /**< RTIC Watchdog Timer, offset: 0x60028 */
       uint8_t RESERVED_43[4];
  __IO uint32_t REND;                              /**< RTIC Endian Register, offset: 0x60034 */
       uint8_t RESERVED_44[200];
  struct {                                         /* offset: 0x60100, array step: index*0x20, index2*0x10 */
    __IO uint64_t RMA;                               /**< RTIC Memory Block A Address 0 Register..RTIC Memory Block D Address 1 Register, array offset: 0x60100, array step: index*0x20, index2*0x10 */
         uint8_t RESERVED_0[4];
    __IO uint32_t RML;                               /**< RTIC Memory Block A Length 0 Register..RTIC Memory Block D Length 1 Register, array offset: 0x6010C, array step: index*0x20, index2*0x10 */
  } RM[4][2];
       uint8_t RESERVED_45[128];
  __IO uint32_t RMD[4][2][32];                     /**< RTIC Memory Block A Big Endian Hash Result Word 0..RTIC Memory Block D Little Endian Hash Result Word 31, array offset: 0x60200, array step: index*0x100, index2*0x80, index3*0x4 */
       uint8_t RESERVED_46[2048];
  __I  uint32_t REIR0RTIC;                         /**< Recoverable Error Interrupt Record 0 for RTIC, offset: 0x60E00 */
       uint8_t RESERVED_47[4];
  __I  uint64_t REIR2RTIC;                         /**< Recoverable Error Interrupt Record 2 for RTIC, offset: 0x60E08 */
  __I  uint32_t REIR4RTIC;                         /**< Recoverable Error Interrupt Record 4 for RTIC, offset: 0x60E10 */
  __I  uint32_t REIR5RTIC;                         /**< Recoverable Error Interrupt Record 5 for RTIC, offset: 0x60E14 */
       uint8_t RESERVED_48[392];
  __I  uint32_t CRNR_MS_RTIC;                      /**< CHA Revision Number Register, most-significant half, offset: 0x60FA0 */
  __I  uint32_t CRNR_LS_RTIC;                      /**< CHA Revision Number Register, least-significant half, offset: 0x60FA4 */
  __I  uint32_t CTPR_MS_RTIC;                      /**< Compile Time Parameters Register, most-significant half, offset: 0x60FA8 */
  __I  uint32_t CTPR_LS_RTIC;                      /**< Compile Time Parameters Register, least-significant half, offset: 0x60FAC */
       uint8_t RESERVED_49[4];
  __I  uint32_t SMSTA_RTIC;                        /**< Secure Memory Status Register, offset: 0x60FB4 */
       uint8_t RESERVED_50[8];
  __I  uint64_t FAR_RTIC;                          /**< Fault Address Register, offset: 0x60FC0 */
  __I  uint32_t FADID_RTIC;                        /**< Fault Address DID Register, offset: 0x60FC8 */
  __I  uint32_t FADR_RTIC;                         /**< Fault Address Detail Register, offset: 0x60FCC */
       uint8_t RESERVED_51[4];
  __I  uint32_t CSTA_RTIC;                         /**< CAAM Status Register, offset: 0x60FD4 */
  __I  uint32_t SMVID_MS_RTIC;                     /**< Secure Memory Version ID Register, most-significant half, offset: 0x60FD8 */
  __I  uint32_t SMVID_LS_RTIC;                     /**< Secure Memory Version ID Register, least-significant half, offset: 0x60FDC */
  __I  uint32_t RVID_RTIC;                         /**< RTIC Version ID Register, offset: 0x60FE0 */
  __I  uint32_t CCBVID_RTIC;                       /**< CHA Cluster Block Version ID Register, offset: 0x60FE4 */
  __I  uint32_t CHAVID_MS_RTIC;                    /**< CHA Version ID Register, most-significant half, offset: 0x60FE8 */
  __I  uint32_t CHAVID_LS_RTIC;                    /**< CHA Version ID Register, least-significant half, offset: 0x60FEC */
  __I  uint32_t CHANUM_MS_RTIC;                    /**< CHA Number Register, most-significant half, offset: 0x60FF0 */
  __I  uint32_t CHANUM_LS_RTIC;                    /**< CHA Number Register, least-significant half, offset: 0x60FF4 */
  __I  uint32_t CAAMVID_MS_RTIC;                   /**< CAAM Version ID Register, most-significant half, offset: 0x60FF8 */
  __I  uint32_t CAAMVID_LS_RTIC;                   /**< CAAM Version ID Register, least-significant half, offset: 0x60FFC */
       uint8_t RESERVED_52[126976];
  struct {                                         /* offset: 0x80000, array step: 0xE3C */
         uint8_t RESERVED_0[4];
    union {                                          /* offset: 0x80004, array step: 0xE3C */
      __IO uint32_t CC1MR;                             /**< CCB 0 Class 1 Mode Register Format for Non-Public Key Algorithms, array offset: 0x80004, array step: 0xE3C */
      __IO uint32_t CC1MR_PK;                          /**< CCB 0 Class 1 Mode Register Format for Public Key Algorithms, array offset: 0x80004, array step: 0xE3C */
      __IO uint32_t CC1MR_RNG;                         /**< CCB 0 Class 1 Mode Register Format for RNG4, array offset: 0x80004, array step: 0xE3C */
    };
         uint8_t RESERVED_1[4];
    __IO uint32_t CC1KSR;                            /**< CCB 0 Class 1 Key Size Register, array offset: 0x8000C, array step: 0xE3C */
    __IO uint64_t CC1DSR;                            /**< CCB 0 Class 1 Data Size Register, array offset: 0x80010, array step: 0xE3C */
         uint8_t RESERVED_2[4];
    __IO uint32_t CC1ICVSR;                          /**< CCB 0 Class 1 ICV Size Register, array offset: 0x8001C, array step: 0xE3C */
         uint8_t RESERVED_3[20];
    __O  uint32_t CCCTRL;                            /**< CCB 0 CHA Control Register, array offset: 0x80034, array step: 0xE3C */
         uint8_t RESERVED_4[4];
    __IO uint32_t CICTL;                             /**< CCB 0 Interrupt Control Register, array offset: 0x8003C, array step: 0xE3C */
         uint8_t RESERVED_5[4];
    __O  uint32_t CCWR;                              /**< CCB 0 Clear Written Register, array offset: 0x80044, array step: 0xE3C */
    __I  uint32_t CCSTA_MS;                          /**< CCB 0 Status and Error Register, most-significant half, array offset: 0x80048, array step: 0xE3C */
    __I  uint32_t CCSTA_LS;                          /**< CCB 0 Status and Error Register, least-significant half, array offset: 0x8004C, array step: 0xE3C */
         uint8_t RESERVED_6[12];
    __IO uint32_t CC1AADSZR;                         /**< CCB 0 Class 1 AAD Size Register, array offset: 0x8005C, array step: 0xE3C */
         uint8_t RESERVED_7[4];
    __IO uint32_t CC1IVSZR;                          /**< CCB 0 Class 1 IV Size Register, array offset: 0x80064, array step: 0xE3C */
         uint8_t RESERVED_8[28];
    __IO uint32_t CPKASZR;                           /**< PKHA A Size Register, array offset: 0x80084, array step: 0xE3C */
         uint8_t RESERVED_9[4];
    __IO uint32_t CPKBSZR;                           /**< PKHA B Size Register, array offset: 0x8008C, array step: 0xE3C */
         uint8_t RESERVED_10[4];
    __IO uint32_t CPKNSZR;                           /**< PKHA N Size Register, array offset: 0x80094, array step: 0xE3C */
         uint8_t RESERVED_11[4];
    __IO uint32_t CPKESZR;                           /**< PKHA E Size Register, array offset: 0x8009C, array step: 0xE3C */
         uint8_t RESERVED_12[96];
    __IO uint32_t CC1CTXR[16];                       /**< CCB 0 Class 1 Context Register Word 0..CCB 0 Class 1 Context Register Word 15, array offset: 0x80100, array step: index*0xE3C, index2*0x4 */
         uint8_t RESERVED_13[192];
    __IO uint32_t CC1KR[8];                          /**< CCB 0 Class 1 Key Registers Word 0..CCB 0 Class 1 Key Registers Word 7, array offset: 0x80200, array step: index*0xE3C, index2*0x4 */
         uint8_t RESERVED_14[484];
    __IO uint32_t CC2MR;                             /**< CCB 0 Class 2 Mode Register, array offset: 0x80404, array step: 0xE3C */
         uint8_t RESERVED_15[4];
    __IO uint32_t CC2KSR;                            /**< CCB 0 Class 2 Key Size Register, array offset: 0x8040C, array step: 0xE3C */
    __IO uint64_t CC2DSR;                            /**< CCB 0 Class 2 Data Size Register, array offset: 0x80410, array step: 0xE3C */
         uint8_t RESERVED_16[4];
    __IO uint32_t CC2ICVSZR;                         /**< CCB 0 Class 2 ICV Size Register, array offset: 0x8041C, array step: 0xE3C */
         uint8_t RESERVED_17[224];
    __IO uint32_t CC2CTXR[18];                       /**< CCB 0 Class 2 Context Register Word 0..CCB 0 Class 2 Context Register Word 17, array offset: 0x80500, array step: index*0xE3C, index2*0x4 */
         uint8_t RESERVED_18[184];
    __IO uint32_t CC2KEYR[32];                       /**< CCB 0 Class 2 Key Register Word 0..CCB 0 Class 2 Key Register Word 31, array offset: 0x80600, array step: index*0xE3C, index2*0x4 */
         uint8_t RESERVED_19[320];
    __I  uint32_t CFIFOSTA;                          /**< CCB 0 FIFO Status Register, array offset: 0x807C0, array step: 0xE3C */
         uint8_t RESERVED_20[12];
    union {                                          /* offset: 0x807D0, array step: 0xE3C */
      __O  uint32_t CNFIFO;                            /**< CCB 0 iNformation FIFO When STYPE != 10b, array offset: 0x807D0, array step: 0xE3C */
      __O  uint32_t CNFIFO_2;                          /**< CCB 0 iNformation FIFO When STYPE == 10b, array offset: 0x807D0, array step: 0xE3C */
    };
         uint8_t RESERVED_21[12];
    __O  uint32_t CIFIFO;                            /**< CCB 0 Input Data FIFO, array offset: 0x807E0, array step: 0xE3C */
         uint8_t RESERVED_22[12];
    __I  uint64_t COFIFO;                            /**< CCB 0 Output Data FIFO, array offset: 0x807F0, array step: 0xE3C */
         uint8_t RESERVED_23[8];
    __IO uint32_t DJQCR_MS;                          /**< DECO0 Job Queue Control Register, most-significant half, array offset: 0x80800, array step: 0xE3C */
    __I  uint32_t DJQCR_LS;                          /**< DECO0 Job Queue Control Register, least-significant half, array offset: 0x80804, array step: 0xE3C */
    __I  uint64_t DDAR;                              /**< DECO0 Descriptor Address Register, array offset: 0x80808, array step: 0xE3C */
    __I  uint32_t DOPSTA_MS;                         /**< DECO0 Operation Status Register, most-significant half, array offset: 0x80810, array step: 0xE3C */
    __I  uint32_t DOPSTA_LS;                         /**< DECO0 Operation Status Register, least-significant half, array offset: 0x80814, array step: 0xE3C */
         uint8_t RESERVED_24[8];
    __I  uint32_t DPDIDSR;                           /**< DECO0 Primary DID Status Register, array offset: 0x80820, array step: 0xE3C */
    __I  uint32_t DODIDSR;                           /**< DECO0 Output DID Status Register, array offset: 0x80824, array step: 0xE3C */
         uint8_t RESERVED_25[24];
    struct {                                         /* offset: 0x80840, array step: index*0xE3C, index2*0x8 */
      __IO uint32_t DMTH_MS;                           /**< DECO0 Math Register 0_MS..DECO0 Math Register 3_MS, array offset: 0x80840, array step: index*0xE3C, index2*0x8 */
      __IO uint32_t DMTH_LS;                           /**< DECO0 Math Register 0_LS..DECO0 Math Register 3_LS, array offset: 0x80844, array step: index*0xE3C, index2*0x8 */
    } DDMTHB[4];
         uint8_t RESERVED_26[32];
    struct {                                         /* offset: 0x80880, array step: index*0xE3C, index2*0x10 */
      __IO uint32_t DGTR_0;                            /**< DECO0 Gather Table Register 0 Word 0, array offset: 0x80880, array step: index*0xE3C, index2*0x10 */
      __IO uint32_t DGTR_1;                            /**< DECO0 Gather Table Register 0 Word 1, array offset: 0x80884, array step: index*0xE3C, index2*0x10 */
      __IO uint32_t DGTR_2;                            /**< DECO0 Gather Table Register 0 Word 2, array offset: 0x80888, array step: index*0xE3C, index2*0x10 */
      __IO uint32_t DGTR_3;                            /**< DECO0 Gather Table Register 0 Word 3, array offset: 0x8088C, array step: index*0xE3C, index2*0x10 */
    } DDGTR[1];
         uint8_t RESERVED_27[112];
    struct {                                         /* offset: 0x80900, array step: index*0xE3C, index2*0x10 */
      __IO uint32_t DSTR_0;                            /**< DECO0 Scatter Table Register 0 Word 0, array offset: 0x80900, array step: index*0xE3C, index2*0x10 */
      __IO uint32_t DSTR_1;                            /**< DECO0 Scatter Table Register 0 Word 1, array offset: 0x80904, array step: index*0xE3C, index2*0x10 */
      __IO uint32_t DSTR_2;                            /**< DECO0 Scatter Table Register 0 Word 2, array offset: 0x80908, array step: index*0xE3C, index2*0x10 */
      __IO uint32_t DSTR_3;                            /**< DECO0 Scatter Table Register 0 Word 3, array offset: 0x8090C, array step: index*0xE3C, index2*0x10 */
    } DDSTR[1];
         uint8_t RESERVED_28[240];
    __IO uint32_t DDESB[64];                         /**< DECO0 Descriptor Buffer Word 0..DECO0 Descriptor Buffer Word 63, array offset: 0x80A00, array step: index*0xE3C, index2*0x4 */
         uint8_t RESERVED_29[768];
    __I  uint32_t DDJR;                              /**< DECO0 Debug Job Register, array offset: 0x80E00, array step: 0xE3C */
    __I  uint32_t DDDR;                              /**< DECO0 Debug DECO Register, array offset: 0x80E04, array step: 0xE3C */
    __I  uint64_t DDJP;                              /**< DECO0 Debug Job Pointer, array offset: 0x80E08, array step: 0xE3C */
    __I  uint64_t DSDP;                              /**< DECO0 Debug Shared Pointer, array offset: 0x80E10, array step: 0xE3C */
    __I  uint32_t DDDR_MS;                           /**< DECO0 Debug DID, most-significant half, array offset: 0x80E18, array step: 0xE3C */
    __I  uint32_t DDDR_LS;                           /**< DECO0 Debug DID, least-significant half, array offset: 0x80E1C, array step: 0xE3C */
    __IO uint32_t SOL;                               /**< Sequence Output Length Register, array offset: 0x80E20, array step: 0xE3C */
    __IO uint32_t VSOL;                              /**< Variable Sequence Output Length Register, array offset: 0x80E24, array step: 0xE3C */
    __IO uint32_t SIL;                               /**< Sequence Input Length Register, array offset: 0x80E28, array step: 0xE3C */
    __IO uint32_t VSIL;                              /**< Variable Sequence Input Length Register, array offset: 0x80E2C, array step: 0xE3C */
    __IO uint32_t DPOVRD;                            /**< Protocol Override Register, array offset: 0x80E30, array step: 0xE3C */
    __IO uint32_t UVSOL;                             /**< Variable Sequence Output Length Register; Upper 32 bits, array offset: 0x80E34, array step: 0xE3C */
    __IO uint32_t UVSIL;                             /**< Variable Sequence Input Length Register; Upper 32 bits, array offset: 0x80E38, array step: 0xE3C */
  } DC[1];
       uint8_t RESERVED_53[356];
  __I  uint32_t CRNR_MS_DC01;                      /**< CHA Revision Number Register, most-significant half, offset: 0x80FA0 */
  __I  uint32_t CRNR_LS_DC01;                      /**< CHA Revision Number Register, least-significant half, offset: 0x80FA4 */
  __I  uint32_t CTPR_MS_DC01;                      /**< Compile Time Parameters Register, most-significant half, offset: 0x80FA8 */
  __I  uint32_t CTPR_LS_DC01;                      /**< Compile Time Parameters Register, least-significant half, offset: 0x80FAC */
       uint8_t RESERVED_54[4];
  __I  uint32_t SMSTA_DC01;                        /**< Secure Memory Status Register, offset: 0x80FB4 */
       uint8_t RESERVED_55[8];
  __I  uint64_t FAR_DC01;                          /**< Fault Address Register, offset: 0x80FC0 */
  __I  uint32_t FADID_DC01;                        /**< Fault Address DID Register, offset: 0x80FC8 */
  __I  uint32_t FADR_DC01;                         /**< Fault Address Detail Register, offset: 0x80FCC */
       uint8_t RESERVED_56[4];
  __I  uint32_t CSTA_DC01;                         /**< CAAM Status Register, offset: 0x80FD4 */
  __I  uint32_t SMVID_MS_DC01;                     /**< Secure Memory Version ID Register, most-significant half, offset: 0x80FD8 */
  __I  uint32_t SMVID_LS_DC01;                     /**< Secure Memory Version ID Register, least-significant half, offset: 0x80FDC */
  __I  uint32_t RVID_DC01;                         /**< RTIC Version ID Register, offset: 0x80FE0 */
  __I  uint32_t CCBVID_DC01;                       /**< CHA Cluster Block Version ID Register, offset: 0x80FE4 */
  __I  uint32_t CHAVID_MS_DC01;                    /**< CHA Version ID Register, most-significant half, offset: 0x80FE8 */
  __I  uint32_t CHAVID_LS_DC01;                    /**< CHA Version ID Register, least-significant half, offset: 0x80FEC */
  __I  uint32_t CHANUM_MS_DC01;                    /**< CHA Number Register, most-significant half, offset: 0x80FF0 */
  __I  uint32_t CHANUM_LS_DC01;                    /**< CHA Number Register, least-significant half, offset: 0x80FF4 */
  __I  uint32_t CAAMVID_MS_DC01;                   /**< CAAM Version ID Register, most-significant half, offset: 0x80FF8 */
  __I  uint32_t CAAMVID_LS_DC01;                   /**< CAAM Version ID Register, least-significant half, offset: 0x80FFC */
} CAAM_Type;

/* ----------------------------------------------------------------------------
   -- CAAM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAAM_Register_Masks CAAM Register Masks
 * @{
 */

/*! @name MCFGR - Master Configuration Register */
/*! @{ */

#define CAAM_MCFGR_NORMAL_BURST_MASK             (0x1U)
#define CAAM_MCFGR_NORMAL_BURST_SHIFT            (0U)
/*! NORMAL_BURST
 *  0b0..Aligned 32 byte burst size target
 *  0b1..Aligned 64 byte burst size target
 */
#define CAAM_MCFGR_NORMAL_BURST(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_MCFGR_NORMAL_BURST_SHIFT)) & CAAM_MCFGR_NORMAL_BURST_MASK)

#define CAAM_MCFGR_LARGE_BURST_MASK              (0x4U)
#define CAAM_MCFGR_LARGE_BURST_SHIFT             (2U)
#define CAAM_MCFGR_LARGE_BURST(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_MCFGR_LARGE_BURST_SHIFT)) & CAAM_MCFGR_LARGE_BURST_MASK)

#define CAAM_MCFGR_AXIPIPE_MASK                  (0xF0U)
#define CAAM_MCFGR_AXIPIPE_SHIFT                 (4U)
#define CAAM_MCFGR_AXIPIPE(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_MCFGR_AXIPIPE_SHIFT)) & CAAM_MCFGR_AXIPIPE_MASK)

#define CAAM_MCFGR_AWCACHE_MASK                  (0xF00U)
#define CAAM_MCFGR_AWCACHE_SHIFT                 (8U)
#define CAAM_MCFGR_AWCACHE(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_MCFGR_AWCACHE_SHIFT)) & CAAM_MCFGR_AWCACHE_MASK)

#define CAAM_MCFGR_ARCACHE_MASK                  (0xF000U)
#define CAAM_MCFGR_ARCACHE_SHIFT                 (12U)
#define CAAM_MCFGR_ARCACHE(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_MCFGR_ARCACHE_SHIFT)) & CAAM_MCFGR_ARCACHE_MASK)

#define CAAM_MCFGR_PS_MASK                       (0x10000U)
#define CAAM_MCFGR_PS_SHIFT                      (16U)
/*! PS
 *  0b0..Pointers fit in one 32-bit word (pointers are 32-bit addresses).
 *  0b1..Pointers require two 32-bit words (pointers are 36-bit addresses).
 */
#define CAAM_MCFGR_PS(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_MCFGR_PS_SHIFT)) & CAAM_MCFGR_PS_MASK)

#define CAAM_MCFGR_DWT_MASK                      (0x80000U)
#define CAAM_MCFGR_DWT_SHIFT                     (19U)
#define CAAM_MCFGR_DWT(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_MCFGR_DWT_SHIFT)) & CAAM_MCFGR_DWT_MASK)

#define CAAM_MCFGR_WRHD_MASK                     (0x8000000U)
#define CAAM_MCFGR_WRHD_SHIFT                    (27U)
#define CAAM_MCFGR_WRHD(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_MCFGR_WRHD_SHIFT)) & CAAM_MCFGR_WRHD_MASK)

#define CAAM_MCFGR_DMA_RST_MASK                  (0x10000000U)
#define CAAM_MCFGR_DMA_RST_SHIFT                 (28U)
#define CAAM_MCFGR_DMA_RST(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_MCFGR_DMA_RST_SHIFT)) & CAAM_MCFGR_DMA_RST_MASK)

#define CAAM_MCFGR_WDF_MASK                      (0x20000000U)
#define CAAM_MCFGR_WDF_SHIFT                     (29U)
#define CAAM_MCFGR_WDF(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_MCFGR_WDF_SHIFT)) & CAAM_MCFGR_WDF_MASK)

#define CAAM_MCFGR_WDE_MASK                      (0x40000000U)
#define CAAM_MCFGR_WDE_SHIFT                     (30U)
#define CAAM_MCFGR_WDE(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_MCFGR_WDE_SHIFT)) & CAAM_MCFGR_WDE_MASK)

#define CAAM_MCFGR_SWRST_MASK                    (0x80000000U)
#define CAAM_MCFGR_SWRST_SHIFT                   (31U)
#define CAAM_MCFGR_SWRST(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_MCFGR_SWRST_SHIFT)) & CAAM_MCFGR_SWRST_MASK)
/*! @} */

/*! @name PAGE0_SDID - Page 0 SDID Register */
/*! @{ */

#define CAAM_PAGE0_SDID_SDID_MASK                (0x7FFFU)
#define CAAM_PAGE0_SDID_SDID_SHIFT               (0U)
#define CAAM_PAGE0_SDID_SDID(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_PAGE0_SDID_SDID_SHIFT)) & CAAM_PAGE0_SDID_SDID_MASK)
/*! @} */

/*! @name SCFGR - Security Configuration Register */
/*! @{ */

#define CAAM_SCFGR_PRIBLOB_MASK                  (0x3U)
#define CAAM_SCFGR_PRIBLOB_SHIFT                 (0U)
/*! PRIBLOB
 *  0b00..Private secure boot software blobs
 *  0b01..Private provisioning type 1 blobs
 *  0b10..Private provisioning type 2 blobs
 *  0b11..Normal operation blobs
 */
#define CAAM_SCFGR_PRIBLOB(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_SCFGR_PRIBLOB_SHIFT)) & CAAM_SCFGR_PRIBLOB_MASK)

#define CAAM_SCFGR_RNGSH0_MASK                   (0x200U)
#define CAAM_SCFGR_RNGSH0_SHIFT                  (9U)
/*! RNGSH0
 *  0b0..When RNGSH0 is 0, RNG DRNG State Handle 0 can be instantiated in any mode. RNGSH0 is set to 0 only for testing.
 *  0b1..When RNGSH0 is 1, RNG DRNG State Handle 0 cannot be instantiated in deterministic (test) mode. RNGSHO
 *       should be set to 1 before the RNG is instantiated. If it is currently instantiated in a deterministic mode,
 *       it will be un-instantiated. Once this bit has been written to a 1, it cannot be changed to a 0 until the
 *       next power on reset.
 */
#define CAAM_SCFGR_RNGSH0(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_SCFGR_RNGSH0_SHIFT)) & CAAM_SCFGR_RNGSH0_MASK)

#define CAAM_SCFGR_LCK_TRNG_MASK                 (0x800U)
#define CAAM_SCFGR_LCK_TRNG_SHIFT                (11U)
#define CAAM_SCFGR_LCK_TRNG(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_SCFGR_LCK_TRNG_SHIFT)) & CAAM_SCFGR_LCK_TRNG_MASK)

#define CAAM_SCFGR_VIRT_EN_MASK                  (0x8000U)
#define CAAM_SCFGR_VIRT_EN_SHIFT                 (15U)
/*! VIRT_EN
 *  0b0..Disable job ring virtualization
 *  0b1..Enable job ring virtualization
 */
#define CAAM_SCFGR_VIRT_EN(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_SCFGR_VIRT_EN_SHIFT)) & CAAM_SCFGR_VIRT_EN_MASK)

#define CAAM_SCFGR_MPMRL_MASK                    (0x4000000U)
#define CAAM_SCFGR_MPMRL_SHIFT                   (26U)
#define CAAM_SCFGR_MPMRL(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_SCFGR_MPMRL_SHIFT)) & CAAM_SCFGR_MPMRL_MASK)

#define CAAM_SCFGR_MPPKRC_MASK                   (0x8000000U)
#define CAAM_SCFGR_MPPKRC_SHIFT                  (27U)
#define CAAM_SCFGR_MPPKRC(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_SCFGR_MPPKRC_SHIFT)) & CAAM_SCFGR_MPPKRC_MASK)

#define CAAM_SCFGR_MPCURVE_MASK                  (0xF0000000U)
#define CAAM_SCFGR_MPCURVE_SHIFT                 (28U)
#define CAAM_SCFGR_MPCURVE(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_SCFGR_MPCURVE_SHIFT)) & CAAM_SCFGR_MPCURVE_MASK)
/*! @} */

/*! @name JRDID_MS - Job Ring 0 DID Register - most significant half..Job Ring 3 DID Register - most significant half */
/*! @{ */

#define CAAM_JRDID_MS_PRIM_DID_MASK              (0xFU)
#define CAAM_JRDID_MS_PRIM_DID_SHIFT             (0U)
#define CAAM_JRDID_MS_PRIM_DID(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_JRDID_MS_PRIM_DID_SHIFT)) & CAAM_JRDID_MS_PRIM_DID_MASK)

#define CAAM_JRDID_MS_PRIM_TZ_MASK               (0x10U)
#define CAAM_JRDID_MS_PRIM_TZ_SHIFT              (4U)
#define CAAM_JRDID_MS_PRIM_TZ(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_JRDID_MS_PRIM_TZ_SHIFT)) & CAAM_JRDID_MS_PRIM_TZ_MASK)

#define CAAM_JRDID_MS_SDID_MS_MASK               (0x7FE0U)
#define CAAM_JRDID_MS_SDID_MS_SHIFT              (5U)
#define CAAM_JRDID_MS_SDID_MS(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_JRDID_MS_SDID_MS_SHIFT)) & CAAM_JRDID_MS_SDID_MS_MASK)

#define CAAM_JRDID_MS_TZ_OWN_MASK                (0x8000U)
#define CAAM_JRDID_MS_TZ_OWN_SHIFT               (15U)
#define CAAM_JRDID_MS_TZ_OWN(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_JRDID_MS_TZ_OWN_SHIFT)) & CAAM_JRDID_MS_TZ_OWN_MASK)

#define CAAM_JRDID_MS_AMTD_MASK                  (0x10000U)
#define CAAM_JRDID_MS_AMTD_SHIFT                 (16U)
#define CAAM_JRDID_MS_AMTD(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_JRDID_MS_AMTD_SHIFT)) & CAAM_JRDID_MS_AMTD_MASK)

#define CAAM_JRDID_MS_LAMTD_MASK                 (0x20000U)
#define CAAM_JRDID_MS_LAMTD_SHIFT                (17U)
#define CAAM_JRDID_MS_LAMTD(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_JRDID_MS_LAMTD_SHIFT)) & CAAM_JRDID_MS_LAMTD_MASK)

#define CAAM_JRDID_MS_PRIM_ICID_MASK             (0x3FF80000U)
#define CAAM_JRDID_MS_PRIM_ICID_SHIFT            (19U)
#define CAAM_JRDID_MS_PRIM_ICID(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_JRDID_MS_PRIM_ICID_SHIFT)) & CAAM_JRDID_MS_PRIM_ICID_MASK)

#define CAAM_JRDID_MS_USE_OUT_MASK               (0x40000000U)
#define CAAM_JRDID_MS_USE_OUT_SHIFT              (30U)
#define CAAM_JRDID_MS_USE_OUT(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_JRDID_MS_USE_OUT_SHIFT)) & CAAM_JRDID_MS_USE_OUT_MASK)

#define CAAM_JRDID_MS_LDID_MASK                  (0x80000000U)
#define CAAM_JRDID_MS_LDID_SHIFT                 (31U)
#define CAAM_JRDID_MS_LDID(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_JRDID_MS_LDID_SHIFT)) & CAAM_JRDID_MS_LDID_MASK)
/*! @} */

/* The count of CAAM_JRDID_MS */
#define CAAM_JRDID_MS_COUNT                      (4U)

/*! @name JRDID_LS - Job Ring 0 DID Register - least significant half..Job Ring 3 DID Register - least significant half */
/*! @{ */

#define CAAM_JRDID_LS_OUT_DID_MASK               (0xFU)
#define CAAM_JRDID_LS_OUT_DID_SHIFT              (0U)
#define CAAM_JRDID_LS_OUT_DID(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_JRDID_LS_OUT_DID_SHIFT)) & CAAM_JRDID_LS_OUT_DID_MASK)

#define CAAM_JRDID_LS_OUT_ICID_MASK              (0x3FF80000U)
#define CAAM_JRDID_LS_OUT_ICID_SHIFT             (19U)
#define CAAM_JRDID_LS_OUT_ICID(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_JRDID_LS_OUT_ICID_SHIFT)) & CAAM_JRDID_LS_OUT_ICID_MASK)
/*! @} */

/* The count of CAAM_JRDID_LS */
#define CAAM_JRDID_LS_COUNT                      (4U)

/*! @name DEBUGCTL - Debug Control Register */
/*! @{ */

#define CAAM_DEBUGCTL_STOP_MASK                  (0x10000U)
#define CAAM_DEBUGCTL_STOP_SHIFT                 (16U)
#define CAAM_DEBUGCTL_STOP(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_DEBUGCTL_STOP_SHIFT)) & CAAM_DEBUGCTL_STOP_MASK)

#define CAAM_DEBUGCTL_STOP_ACK_MASK              (0x20000U)
#define CAAM_DEBUGCTL_STOP_ACK_SHIFT             (17U)
#define CAAM_DEBUGCTL_STOP_ACK(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_DEBUGCTL_STOP_ACK_SHIFT)) & CAAM_DEBUGCTL_STOP_ACK_MASK)
/*! @} */

/*! @name JRSTARTR - Job Ring Start Register */
/*! @{ */

#define CAAM_JRSTARTR_Start_JR0_MASK             (0x1U)
#define CAAM_JRSTARTR_Start_JR0_SHIFT            (0U)
/*! Start_JR0
 *  0b0..Stop Mode. The JR0DID register and the SMVBA register for Job Ring 0 can be written but the IRBAR, IRSR,
 *       IRSAR, IRJAR, ORBAR, ORSR, ORJRR, ORSFR and JRSTAR for Job Ring 0 are NOT accessible. If Job Ring 0 is
 *       allocated to TrustZone SecureWorld (JR0DID[TZ]=1), the JR0DID and SMVBA register can be written only via a
 *       bus transaction that has ns=0.
 *  0b1..Start Mode. The JR0DID register and the SMVBA register for Job Ring 0 CANNOT be written but the IRBAR,
 *       IRSR, IRSAR, IRJAR, ORBAR, ORSR, ORJRR, ORSFR and JRSTAR for Job Ring 0 ARE accessible. If Job Ring 0 is
 *       allocated to TrustZone SecureWorld (JR0DID[TZ]=1), then the SMVBA, IRBAR, IRSR, IRSAR, IRJAR, ORBAR, ORSR,
 *       ORJRR, ORSFR and JRSTAR registers for Job Ring 0 can be written only via a bus transaction that has ns=0.
 */
#define CAAM_JRSTARTR_Start_JR0(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_JRSTARTR_Start_JR0_SHIFT)) & CAAM_JRSTARTR_Start_JR0_MASK)

#define CAAM_JRSTARTR_Start_JR1_MASK             (0x2U)
#define CAAM_JRSTARTR_Start_JR1_SHIFT            (1U)
/*! Start_JR1
 *  0b0..Stop Mode. The JR1DID register and the SMVBA register for Job Ring 1 can be written but the IRBAR, IRSR,
 *       IRSAR, IRJAR, ORBAR, ORSR, ORJRR, ORSFR and JRSTAR for Job Ring 1 are NOT accessible. If Job Ring 1 is
 *       allocated to TrustZone SecureWorld (JR1DID[TZ]=1), the JR1DID and SMVBA register can be written only via a
 *       bus transaction that has ns=0.
 *  0b1..Start Mode. The JR1DID register and the SMVBA register for Job Ring 1 CANNOT be written but the IRBAR,
 *       IRSR, IRSAR, IRJAR, ORBAR, ORSR, ORJRR, ORSFR and JRSTAR for Job Ring 1 ARE accessible. If Job Ring 1 is
 *       allocated to TrustZone SecureWorld (JR1DID[TZ]=1), then the SMVBA, IRBAR, IRSR, IRSAR, IRJAR, ORBAR, ORSR,
 *       ORJRR, ORSFR and JRSTAR registers for Job Ring 1 can be written only via a bus transaction that has ns=0.
 */
#define CAAM_JRSTARTR_Start_JR1(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_JRSTARTR_Start_JR1_SHIFT)) & CAAM_JRSTARTR_Start_JR1_MASK)

#define CAAM_JRSTARTR_Start_JR2_MASK             (0x4U)
#define CAAM_JRSTARTR_Start_JR2_SHIFT            (2U)
/*! Start_JR2
 *  0b0..Stop Mode. The JR2DID register and the SMVBA register for Job Ring 2 can be written but the IRBAR, IRSR,
 *       IRSAR, IRJAR, ORBAR, ORSR, ORJRR, ORSFR and JRSTAR for Job Ring 2 are NOT accessible. If Job Ring 2 is
 *       allocated to TrustZone SecureWorld (JR2DID[TZ]=1), the JR2DID and SMVBA register can be written only via a
 *       bus transaction that has ns=0.
 *  0b1..Start Mode. The JR2DID register and the SMVBA register for Job Ring 2 CANNOT be written but the IRBAR,
 *       IRSR, IRSAR, IRJAR, ORBAR, ORSR, ORJRR, ORSFR and JRSTAR for Job Ring 2 ARE accessible. If Job Ring 2 is
 *       allocated to TrustZone SecureWorld (JR2DID[TZ]=1), then the SMVBA, IRBAR, IRSR, IRSAR, IRJAR, ORBAR, ORSR,
 *       ORJRR, ORSFR and JRSTAR registers for Job Ring 2 can be written only via a bus transaction that has ns=0.
 */
#define CAAM_JRSTARTR_Start_JR2(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_JRSTARTR_Start_JR2_SHIFT)) & CAAM_JRSTARTR_Start_JR2_MASK)

#define CAAM_JRSTARTR_Start_JR3_MASK             (0x8U)
#define CAAM_JRSTARTR_Start_JR3_SHIFT            (3U)
/*! Start_JR3
 *  0b0..Stop Mode. The JR3DID register and the SMVBA register for Job Ring 3 can be written but the IRBAR, IRSR,
 *       IRSAR, IRJAR, ORBAR, ORSR, ORJRR, ORSFR and JRSTAR for Job Ring 3 are NOT accessible. If Job Ring 3 is
 *       allocated to TrustZone SecureWorld (JR3DID[TZ]=1), the JR3DID and SMVBA register can be written only via a
 *       bus transaction that has ns=0.
 *  0b1..Start Mode. The JR3DID register and the SMVBA register for Job Ring 3 CANNOT be written but the IRBAR,
 *       IRSR, IRSAR, IRJAR, ORBAR, ORSR, ORJRR, ORSFR and JRSTAR for Job Ring 3 ARE accessible. If Job Ring 3 is
 *       allocated to TrustZone SecureWorld (JR3DID[TZ]=1), then the SMVBA, IRBAR, IRSR, IRSAR, IRJAR, ORBAR, ORSR,
 *       ORJRR, ORSFR and JRSTAR registers for Job Ring 3 can be written only via a bus transaction that has ns=0.
 */
#define CAAM_JRSTARTR_Start_JR3(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_JRSTARTR_Start_JR3_SHIFT)) & CAAM_JRSTARTR_Start_JR3_MASK)
/*! @} */

/*! @name RTIC_OWN - RTIC OWN Register */
/*! @{ */

#define CAAM_RTIC_OWN_ROWN_DID_MASK              (0xFU)
#define CAAM_RTIC_OWN_ROWN_DID_SHIFT             (0U)
/*! ROWN_DID - RTIC Owner's DID
 */
#define CAAM_RTIC_OWN_ROWN_DID(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_RTIC_OWN_ROWN_DID_SHIFT)) & CAAM_RTIC_OWN_ROWN_DID_MASK)

#define CAAM_RTIC_OWN_ROWN_TZ_MASK               (0x10U)
#define CAAM_RTIC_OWN_ROWN_TZ_SHIFT              (4U)
#define CAAM_RTIC_OWN_ROWN_TZ(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTIC_OWN_ROWN_TZ_SHIFT)) & CAAM_RTIC_OWN_ROWN_TZ_MASK)

#define CAAM_RTIC_OWN_LCK_MASK                   (0x80000000U)
#define CAAM_RTIC_OWN_LCK_SHIFT                  (31U)
#define CAAM_RTIC_OWN_LCK(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_RTIC_OWN_LCK_SHIFT)) & CAAM_RTIC_OWN_LCK_MASK)
/*! @} */

/*! @name RTIC_DID - RTIC DID Register for Block A..RTIC DID Register for Block D */
/*! @{ */

#define CAAM_RTIC_DID_RTIC_DID_MASK              (0xFU)
#define CAAM_RTIC_DID_RTIC_DID_SHIFT             (0U)
#define CAAM_RTIC_DID_RTIC_DID(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_RTIC_DID_RTIC_DID_SHIFT)) & CAAM_RTIC_DID_RTIC_DID_MASK)

#define CAAM_RTIC_DID_RTIC_TZ_MASK               (0x10U)
#define CAAM_RTIC_DID_RTIC_TZ_SHIFT              (4U)
#define CAAM_RTIC_DID_RTIC_TZ(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTIC_DID_RTIC_TZ_SHIFT)) & CAAM_RTIC_DID_RTIC_TZ_MASK)

#define CAAM_RTIC_DID_RTIC_ICID_MASK             (0x3FF80000U)
#define CAAM_RTIC_DID_RTIC_ICID_SHIFT            (19U)
#define CAAM_RTIC_DID_RTIC_ICID(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_RTIC_DID_RTIC_ICID_SHIFT)) & CAAM_RTIC_DID_RTIC_ICID_MASK)
/*! @} */

/* The count of CAAM_RTIC_DID */
#define CAAM_RTIC_DID_COUNT                      (4U)

/*! @name DECORSR - DECO Request Source Register */
/*! @{ */

#define CAAM_DECORSR_JR_MASK                     (0x3U)
#define CAAM_DECORSR_JR_SHIFT                    (0U)
#define CAAM_DECORSR_JR(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_DECORSR_JR_SHIFT)) & CAAM_DECORSR_JR_MASK)

#define CAAM_DECORSR_VALID_MASK                  (0x80000000U)
#define CAAM_DECORSR_VALID_SHIFT                 (31U)
#define CAAM_DECORSR_VALID(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_DECORSR_VALID_SHIFT)) & CAAM_DECORSR_VALID_MASK)
/*! @} */

/*! @name DECORR - DECO Request Register */
/*! @{ */

#define CAAM_DECORR_RQD0_MASK                    (0x1U)
#define CAAM_DECORR_RQD0_SHIFT                   (0U)
#define CAAM_DECORR_RQD0(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_DECORR_RQD0_SHIFT)) & CAAM_DECORR_RQD0_MASK)

#define CAAM_DECORR_DEN0_MASK                    (0x10000U)
#define CAAM_DECORR_DEN0_SHIFT                   (16U)
#define CAAM_DECORR_DEN0(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_DECORR_DEN0_SHIFT)) & CAAM_DECORR_DEN0_MASK)
/*! @} */

/*! @name DECODID_MS - DECO0 DID Register - most significant half */
/*! @{ */

#define CAAM_DECODID_MS_DPRIM_DID_MASK           (0xFU)
#define CAAM_DECODID_MS_DPRIM_DID_SHIFT          (0U)
/*! DPRIM_DID - DECO Owner
 */
#define CAAM_DECODID_MS_DPRIM_DID(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_DECODID_MS_DPRIM_DID_SHIFT)) & CAAM_DECODID_MS_DPRIM_DID_MASK)

#define CAAM_DECODID_MS_D_NS_MASK                (0x10U)
#define CAAM_DECODID_MS_D_NS_SHIFT               (4U)
#define CAAM_DECODID_MS_D_NS(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_DECODID_MS_D_NS_SHIFT)) & CAAM_DECODID_MS_D_NS_MASK)

#define CAAM_DECODID_MS_LCK_MASK                 (0x80000000U)
#define CAAM_DECODID_MS_LCK_SHIFT                (31U)
#define CAAM_DECODID_MS_LCK(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_DECODID_MS_LCK_SHIFT)) & CAAM_DECODID_MS_LCK_MASK)
/*! @} */

/* The count of CAAM_DECODID_MS */
#define CAAM_DECODID_MS_COUNT                    (1U)

/*! @name DECODID_LS - DECO0 DID Register - least significant half */
/*! @{ */

#define CAAM_DECODID_LS_DSEQ_DID_MASK            (0xFU)
#define CAAM_DECODID_LS_DSEQ_DID_SHIFT           (0U)
#define CAAM_DECODID_LS_DSEQ_DID(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_DECODID_LS_DSEQ_DID_SHIFT)) & CAAM_DECODID_LS_DSEQ_DID_MASK)

#define CAAM_DECODID_LS_DSEQ_NS_MASK             (0x10U)
#define CAAM_DECODID_LS_DSEQ_NS_SHIFT            (4U)
#define CAAM_DECODID_LS_DSEQ_NS(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DECODID_LS_DSEQ_NS_SHIFT)) & CAAM_DECODID_LS_DSEQ_NS_MASK)

#define CAAM_DECODID_LS_DNSEQ_DID_MASK           (0xF0000U)
#define CAAM_DECODID_LS_DNSEQ_DID_SHIFT          (16U)
#define CAAM_DECODID_LS_DNSEQ_DID(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_DECODID_LS_DNSEQ_DID_SHIFT)) & CAAM_DECODID_LS_DNSEQ_DID_MASK)

#define CAAM_DECODID_LS_DNONSEQ_NS_MASK          (0x100000U)
#define CAAM_DECODID_LS_DNONSEQ_NS_SHIFT         (20U)
#define CAAM_DECODID_LS_DNONSEQ_NS(x)            (((uint32_t)(((uint32_t)(x)) << CAAM_DECODID_LS_DNONSEQ_NS_SHIFT)) & CAAM_DECODID_LS_DNONSEQ_NS_MASK)
/*! @} */

/* The count of CAAM_DECODID_LS */
#define CAAM_DECODID_LS_COUNT                    (1U)

/*! @name DAR - DECO Availability Register */
/*! @{ */

#define CAAM_DAR_NYA0_MASK                       (0x1U)
#define CAAM_DAR_NYA0_SHIFT                      (0U)
#define CAAM_DAR_NYA0(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_DAR_NYA0_SHIFT)) & CAAM_DAR_NYA0_MASK)
/*! @} */

/*! @name DRR - DECO Reset Register */
/*! @{ */

#define CAAM_DRR_RST0_MASK                       (0x1U)
#define CAAM_DRR_RST0_SHIFT                      (0U)
#define CAAM_DRR_RST0(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_DRR_RST0_SHIFT)) & CAAM_DRR_RST0_MASK)
/*! @} */

/*! @name JRSMVBAR - Job Ring 0 Secure Memory Virtual Base Address Register..Job Ring 3 Secure Memory Virtual Base Address Register */
/*! @{ */

#define CAAM_JRSMVBAR_SMVBA_MASK                 (0xFFFFFFFFU)
#define CAAM_JRSMVBAR_SMVBA_SHIFT                (0U)
#define CAAM_JRSMVBAR_SMVBA(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_JRSMVBAR_SMVBA_SHIFT)) & CAAM_JRSMVBAR_SMVBA_MASK)
/*! @} */

/* The count of CAAM_JRSMVBAR */
#define CAAM_JRSMVBAR_COUNT                      (4U)

/*! @name PBSL - Peak Bandwidth Smoothing Limit Register */
/*! @{ */

#define CAAM_PBSL_PBSL_MASK                      (0x7FU)
#define CAAM_PBSL_PBSL_SHIFT                     (0U)
#define CAAM_PBSL_PBSL(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_PBSL_PBSL_SHIFT)) & CAAM_PBSL_PBSL_MASK)
/*! @} */

/*! @name DMA_AIDL_MAP_MS - DMA0_AIDL_MAP_MS */
/*! @{ */

#define CAAM_DMA_AIDL_MAP_MS_AID4_BID_MASK       (0xFFU)
#define CAAM_DMA_AIDL_MAP_MS_AID4_BID_SHIFT      (0U)
#define CAAM_DMA_AIDL_MAP_MS_AID4_BID(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDL_MAP_MS_AID4_BID_SHIFT)) & CAAM_DMA_AIDL_MAP_MS_AID4_BID_MASK)

#define CAAM_DMA_AIDL_MAP_MS_AID5_BID_MASK       (0xFF00U)
#define CAAM_DMA_AIDL_MAP_MS_AID5_BID_SHIFT      (8U)
#define CAAM_DMA_AIDL_MAP_MS_AID5_BID(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDL_MAP_MS_AID5_BID_SHIFT)) & CAAM_DMA_AIDL_MAP_MS_AID5_BID_MASK)

#define CAAM_DMA_AIDL_MAP_MS_AID6_BID_MASK       (0xFF0000U)
#define CAAM_DMA_AIDL_MAP_MS_AID6_BID_SHIFT      (16U)
#define CAAM_DMA_AIDL_MAP_MS_AID6_BID(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDL_MAP_MS_AID6_BID_SHIFT)) & CAAM_DMA_AIDL_MAP_MS_AID6_BID_MASK)

#define CAAM_DMA_AIDL_MAP_MS_AID7_BID_MASK       (0xFF000000U)
#define CAAM_DMA_AIDL_MAP_MS_AID7_BID_SHIFT      (24U)
#define CAAM_DMA_AIDL_MAP_MS_AID7_BID(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDL_MAP_MS_AID7_BID_SHIFT)) & CAAM_DMA_AIDL_MAP_MS_AID7_BID_MASK)
/*! @} */

/* The count of CAAM_DMA_AIDL_MAP_MS */
#define CAAM_DMA_AIDL_MAP_MS_COUNT               (1U)

/*! @name DMA_AIDL_MAP_LS - DMA0_AIDL_MAP_LS */
/*! @{ */

#define CAAM_DMA_AIDL_MAP_LS_AID0_BID_MASK       (0xFFU)
#define CAAM_DMA_AIDL_MAP_LS_AID0_BID_SHIFT      (0U)
#define CAAM_DMA_AIDL_MAP_LS_AID0_BID(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDL_MAP_LS_AID0_BID_SHIFT)) & CAAM_DMA_AIDL_MAP_LS_AID0_BID_MASK)

#define CAAM_DMA_AIDL_MAP_LS_AID1_BID_MASK       (0xFF00U)
#define CAAM_DMA_AIDL_MAP_LS_AID1_BID_SHIFT      (8U)
#define CAAM_DMA_AIDL_MAP_LS_AID1_BID(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDL_MAP_LS_AID1_BID_SHIFT)) & CAAM_DMA_AIDL_MAP_LS_AID1_BID_MASK)

#define CAAM_DMA_AIDL_MAP_LS_AID2_BID_MASK       (0xFF0000U)
#define CAAM_DMA_AIDL_MAP_LS_AID2_BID_SHIFT      (16U)
#define CAAM_DMA_AIDL_MAP_LS_AID2_BID(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDL_MAP_LS_AID2_BID_SHIFT)) & CAAM_DMA_AIDL_MAP_LS_AID2_BID_MASK)

#define CAAM_DMA_AIDL_MAP_LS_AID3_BID_MASK       (0xFF000000U)
#define CAAM_DMA_AIDL_MAP_LS_AID3_BID_SHIFT      (24U)
#define CAAM_DMA_AIDL_MAP_LS_AID3_BID(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDL_MAP_LS_AID3_BID_SHIFT)) & CAAM_DMA_AIDL_MAP_LS_AID3_BID_MASK)
/*! @} */

/* The count of CAAM_DMA_AIDL_MAP_LS */
#define CAAM_DMA_AIDL_MAP_LS_COUNT               (1U)

/*! @name DMA_AIDM_MAP_MS - DMA0_AIDM_MAP_MS */
/*! @{ */

#define CAAM_DMA_AIDM_MAP_MS_AID12_BID_MASK      (0xFFU)
#define CAAM_DMA_AIDM_MAP_MS_AID12_BID_SHIFT     (0U)
#define CAAM_DMA_AIDM_MAP_MS_AID12_BID(x)        (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDM_MAP_MS_AID12_BID_SHIFT)) & CAAM_DMA_AIDM_MAP_MS_AID12_BID_MASK)

#define CAAM_DMA_AIDM_MAP_MS_AID13_BID_MASK      (0xFF00U)
#define CAAM_DMA_AIDM_MAP_MS_AID13_BID_SHIFT     (8U)
#define CAAM_DMA_AIDM_MAP_MS_AID13_BID(x)        (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDM_MAP_MS_AID13_BID_SHIFT)) & CAAM_DMA_AIDM_MAP_MS_AID13_BID_MASK)

#define CAAM_DMA_AIDM_MAP_MS_AID14_BID_MASK      (0xFF0000U)
#define CAAM_DMA_AIDM_MAP_MS_AID14_BID_SHIFT     (16U)
#define CAAM_DMA_AIDM_MAP_MS_AID14_BID(x)        (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDM_MAP_MS_AID14_BID_SHIFT)) & CAAM_DMA_AIDM_MAP_MS_AID14_BID_MASK)

#define CAAM_DMA_AIDM_MAP_MS_AID15_BID_MASK      (0xFF000000U)
#define CAAM_DMA_AIDM_MAP_MS_AID15_BID_SHIFT     (24U)
#define CAAM_DMA_AIDM_MAP_MS_AID15_BID(x)        (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDM_MAP_MS_AID15_BID_SHIFT)) & CAAM_DMA_AIDM_MAP_MS_AID15_BID_MASK)
/*! @} */

/* The count of CAAM_DMA_AIDM_MAP_MS */
#define CAAM_DMA_AIDM_MAP_MS_COUNT               (1U)

/*! @name DMA_AIDM_MAP_LS - DMA0_AIDM_MAP_LS */
/*! @{ */

#define CAAM_DMA_AIDM_MAP_LS_AID8_BID_MASK       (0xFFU)
#define CAAM_DMA_AIDM_MAP_LS_AID8_BID_SHIFT      (0U)
#define CAAM_DMA_AIDM_MAP_LS_AID8_BID(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDM_MAP_LS_AID8_BID_SHIFT)) & CAAM_DMA_AIDM_MAP_LS_AID8_BID_MASK)

#define CAAM_DMA_AIDM_MAP_LS_AID9_BID_MASK       (0xFF00U)
#define CAAM_DMA_AIDM_MAP_LS_AID9_BID_SHIFT      (8U)
#define CAAM_DMA_AIDM_MAP_LS_AID9_BID(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDM_MAP_LS_AID9_BID_SHIFT)) & CAAM_DMA_AIDM_MAP_LS_AID9_BID_MASK)

#define CAAM_DMA_AIDM_MAP_LS_AID10_BID_MASK      (0xFF0000U)
#define CAAM_DMA_AIDM_MAP_LS_AID10_BID_SHIFT     (16U)
#define CAAM_DMA_AIDM_MAP_LS_AID10_BID(x)        (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDM_MAP_LS_AID10_BID_SHIFT)) & CAAM_DMA_AIDM_MAP_LS_AID10_BID_MASK)

#define CAAM_DMA_AIDM_MAP_LS_AID11_BID_MASK      (0xFF000000U)
#define CAAM_DMA_AIDM_MAP_LS_AID11_BID_SHIFT     (24U)
#define CAAM_DMA_AIDM_MAP_LS_AID11_BID(x)        (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_AIDM_MAP_LS_AID11_BID_SHIFT)) & CAAM_DMA_AIDM_MAP_LS_AID11_BID_MASK)
/*! @} */

/* The count of CAAM_DMA_AIDM_MAP_LS */
#define CAAM_DMA_AIDM_MAP_LS_COUNT               (1U)

/*! @name DMA0_AID_ENB - DMA0 AXI ID Enable Register */
/*! @{ */

#define CAAM_DMA0_AID_ENB_AID0E_MASK             (0x1U)
#define CAAM_DMA0_AID_ENB_AID0E_SHIFT            (0U)
#define CAAM_DMA0_AID_ENB_AID0E(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID0E_SHIFT)) & CAAM_DMA0_AID_ENB_AID0E_MASK)

#define CAAM_DMA0_AID_ENB_AID1E_MASK             (0x2U)
#define CAAM_DMA0_AID_ENB_AID1E_SHIFT            (1U)
#define CAAM_DMA0_AID_ENB_AID1E(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID1E_SHIFT)) & CAAM_DMA0_AID_ENB_AID1E_MASK)

#define CAAM_DMA0_AID_ENB_AID2E_MASK             (0x4U)
#define CAAM_DMA0_AID_ENB_AID2E_SHIFT            (2U)
#define CAAM_DMA0_AID_ENB_AID2E(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID2E_SHIFT)) & CAAM_DMA0_AID_ENB_AID2E_MASK)

#define CAAM_DMA0_AID_ENB_AID3E_MASK             (0x8U)
#define CAAM_DMA0_AID_ENB_AID3E_SHIFT            (3U)
#define CAAM_DMA0_AID_ENB_AID3E(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID3E_SHIFT)) & CAAM_DMA0_AID_ENB_AID3E_MASK)

#define CAAM_DMA0_AID_ENB_AID4E_MASK             (0x10U)
#define CAAM_DMA0_AID_ENB_AID4E_SHIFT            (4U)
#define CAAM_DMA0_AID_ENB_AID4E(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID4E_SHIFT)) & CAAM_DMA0_AID_ENB_AID4E_MASK)

#define CAAM_DMA0_AID_ENB_AID5E_MASK             (0x20U)
#define CAAM_DMA0_AID_ENB_AID5E_SHIFT            (5U)
#define CAAM_DMA0_AID_ENB_AID5E(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID5E_SHIFT)) & CAAM_DMA0_AID_ENB_AID5E_MASK)

#define CAAM_DMA0_AID_ENB_AID6E_MASK             (0x40U)
#define CAAM_DMA0_AID_ENB_AID6E_SHIFT            (6U)
#define CAAM_DMA0_AID_ENB_AID6E(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID6E_SHIFT)) & CAAM_DMA0_AID_ENB_AID6E_MASK)

#define CAAM_DMA0_AID_ENB_AID7E_MASK             (0x80U)
#define CAAM_DMA0_AID_ENB_AID7E_SHIFT            (7U)
#define CAAM_DMA0_AID_ENB_AID7E(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID7E_SHIFT)) & CAAM_DMA0_AID_ENB_AID7E_MASK)

#define CAAM_DMA0_AID_ENB_AID8E_MASK             (0x100U)
#define CAAM_DMA0_AID_ENB_AID8E_SHIFT            (8U)
#define CAAM_DMA0_AID_ENB_AID8E(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID8E_SHIFT)) & CAAM_DMA0_AID_ENB_AID8E_MASK)

#define CAAM_DMA0_AID_ENB_AID9E_MASK             (0x200U)
#define CAAM_DMA0_AID_ENB_AID9E_SHIFT            (9U)
#define CAAM_DMA0_AID_ENB_AID9E(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID9E_SHIFT)) & CAAM_DMA0_AID_ENB_AID9E_MASK)

#define CAAM_DMA0_AID_ENB_AID10E_MASK            (0x400U)
#define CAAM_DMA0_AID_ENB_AID10E_SHIFT           (10U)
#define CAAM_DMA0_AID_ENB_AID10E(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID10E_SHIFT)) & CAAM_DMA0_AID_ENB_AID10E_MASK)

#define CAAM_DMA0_AID_ENB_AID11E_MASK            (0x800U)
#define CAAM_DMA0_AID_ENB_AID11E_SHIFT           (11U)
#define CAAM_DMA0_AID_ENB_AID11E(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID11E_SHIFT)) & CAAM_DMA0_AID_ENB_AID11E_MASK)

#define CAAM_DMA0_AID_ENB_AID12E_MASK            (0x1000U)
#define CAAM_DMA0_AID_ENB_AID12E_SHIFT           (12U)
#define CAAM_DMA0_AID_ENB_AID12E(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID12E_SHIFT)) & CAAM_DMA0_AID_ENB_AID12E_MASK)

#define CAAM_DMA0_AID_ENB_AID13E_MASK            (0x2000U)
#define CAAM_DMA0_AID_ENB_AID13E_SHIFT           (13U)
#define CAAM_DMA0_AID_ENB_AID13E(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID13E_SHIFT)) & CAAM_DMA0_AID_ENB_AID13E_MASK)

#define CAAM_DMA0_AID_ENB_AID14E_MASK            (0x4000U)
#define CAAM_DMA0_AID_ENB_AID14E_SHIFT           (14U)
#define CAAM_DMA0_AID_ENB_AID14E(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID14E_SHIFT)) & CAAM_DMA0_AID_ENB_AID14E_MASK)

#define CAAM_DMA0_AID_ENB_AID15E_MASK            (0x8000U)
#define CAAM_DMA0_AID_ENB_AID15E_SHIFT           (15U)
#define CAAM_DMA0_AID_ENB_AID15E(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AID_ENB_AID15E_SHIFT)) & CAAM_DMA0_AID_ENB_AID15E_MASK)
/*! @} */

/*! @name DMA0_ARD_TC - DMA0 AXI Read Timing Check Register */
/*! @{ */

#define CAAM_DMA0_ARD_TC_ARSC_MASK               (0xFFFFFU)
#define CAAM_DMA0_ARD_TC_ARSC_SHIFT              (0U)
#define CAAM_DMA0_ARD_TC_ARSC(x)                 (((uint64_t)(((uint64_t)(x)) << CAAM_DMA0_ARD_TC_ARSC_SHIFT)) & CAAM_DMA0_ARD_TC_ARSC_MASK)

#define CAAM_DMA0_ARD_TC_ARLC_MASK               (0xFFFFF000000U)
#define CAAM_DMA0_ARD_TC_ARLC_SHIFT              (24U)
#define CAAM_DMA0_ARD_TC_ARLC(x)                 (((uint64_t)(((uint64_t)(x)) << CAAM_DMA0_ARD_TC_ARLC_SHIFT)) & CAAM_DMA0_ARD_TC_ARLC_MASK)

#define CAAM_DMA0_ARD_TC_ARL_MASK                (0xFFF000000000000U)
#define CAAM_DMA0_ARD_TC_ARL_SHIFT               (48U)
#define CAAM_DMA0_ARD_TC_ARL(x)                  (((uint64_t)(((uint64_t)(x)) << CAAM_DMA0_ARD_TC_ARL_SHIFT)) & CAAM_DMA0_ARD_TC_ARL_MASK)

#define CAAM_DMA0_ARD_TC_ARTL_MASK               (0x1000000000000000U)
#define CAAM_DMA0_ARD_TC_ARTL_SHIFT              (60U)
#define CAAM_DMA0_ARD_TC_ARTL(x)                 (((uint64_t)(((uint64_t)(x)) << CAAM_DMA0_ARD_TC_ARTL_SHIFT)) & CAAM_DMA0_ARD_TC_ARTL_MASK)

#define CAAM_DMA0_ARD_TC_ARTT_MASK               (0x2000000000000000U)
#define CAAM_DMA0_ARD_TC_ARTT_SHIFT              (61U)
#define CAAM_DMA0_ARD_TC_ARTT(x)                 (((uint64_t)(((uint64_t)(x)) << CAAM_DMA0_ARD_TC_ARTT_SHIFT)) & CAAM_DMA0_ARD_TC_ARTT_MASK)

#define CAAM_DMA0_ARD_TC_ARCT_MASK               (0x4000000000000000U)
#define CAAM_DMA0_ARD_TC_ARCT_SHIFT              (62U)
#define CAAM_DMA0_ARD_TC_ARCT(x)                 (((uint64_t)(((uint64_t)(x)) << CAAM_DMA0_ARD_TC_ARCT_SHIFT)) & CAAM_DMA0_ARD_TC_ARCT_MASK)

#define CAAM_DMA0_ARD_TC_ARTCE_MASK              (0x8000000000000000U)
#define CAAM_DMA0_ARD_TC_ARTCE_SHIFT             (63U)
#define CAAM_DMA0_ARD_TC_ARTCE(x)                (((uint64_t)(((uint64_t)(x)) << CAAM_DMA0_ARD_TC_ARTCE_SHIFT)) & CAAM_DMA0_ARD_TC_ARTCE_MASK)
/*! @} */

/*! @name DMA0_ARD_LAT - DMA0 Read Timing Check Latency Register */
/*! @{ */

#define CAAM_DMA0_ARD_LAT_SARL_MASK              (0xFFFFFFFFU)
#define CAAM_DMA0_ARD_LAT_SARL_SHIFT             (0U)
#define CAAM_DMA0_ARD_LAT_SARL(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_ARD_LAT_SARL_SHIFT)) & CAAM_DMA0_ARD_LAT_SARL_MASK)
/*! @} */

/*! @name DMA0_AWR_TC - DMA0 AXI Write Timing Check Register */
/*! @{ */

#define CAAM_DMA0_AWR_TC_AWSC_MASK               (0xFFFFFU)
#define CAAM_DMA0_AWR_TC_AWSC_SHIFT              (0U)
#define CAAM_DMA0_AWR_TC_AWSC(x)                 (((uint64_t)(((uint64_t)(x)) << CAAM_DMA0_AWR_TC_AWSC_SHIFT)) & CAAM_DMA0_AWR_TC_AWSC_MASK)

#define CAAM_DMA0_AWR_TC_AWLC_MASK               (0xFFFFF000000U)
#define CAAM_DMA0_AWR_TC_AWLC_SHIFT              (24U)
#define CAAM_DMA0_AWR_TC_AWLC(x)                 (((uint64_t)(((uint64_t)(x)) << CAAM_DMA0_AWR_TC_AWLC_SHIFT)) & CAAM_DMA0_AWR_TC_AWLC_MASK)

#define CAAM_DMA0_AWR_TC_AWL_MASK                (0xFFF000000000000U)
#define CAAM_DMA0_AWR_TC_AWL_SHIFT               (48U)
#define CAAM_DMA0_AWR_TC_AWL(x)                  (((uint64_t)(((uint64_t)(x)) << CAAM_DMA0_AWR_TC_AWL_SHIFT)) & CAAM_DMA0_AWR_TC_AWL_MASK)

#define CAAM_DMA0_AWR_TC_AWTT_MASK               (0x2000000000000000U)
#define CAAM_DMA0_AWR_TC_AWTT_SHIFT              (61U)
#define CAAM_DMA0_AWR_TC_AWTT(x)                 (((uint64_t)(((uint64_t)(x)) << CAAM_DMA0_AWR_TC_AWTT_SHIFT)) & CAAM_DMA0_AWR_TC_AWTT_MASK)

#define CAAM_DMA0_AWR_TC_AWCT_MASK               (0x4000000000000000U)
#define CAAM_DMA0_AWR_TC_AWCT_SHIFT              (62U)
#define CAAM_DMA0_AWR_TC_AWCT(x)                 (((uint64_t)(((uint64_t)(x)) << CAAM_DMA0_AWR_TC_AWCT_SHIFT)) & CAAM_DMA0_AWR_TC_AWCT_MASK)

#define CAAM_DMA0_AWR_TC_AWTCE_MASK              (0x8000000000000000U)
#define CAAM_DMA0_AWR_TC_AWTCE_SHIFT             (63U)
#define CAAM_DMA0_AWR_TC_AWTCE(x)                (((uint64_t)(((uint64_t)(x)) << CAAM_DMA0_AWR_TC_AWTCE_SHIFT)) & CAAM_DMA0_AWR_TC_AWTCE_MASK)
/*! @} */

/*! @name DMA0_AWR_LAT - DMA0 Write Timing Check Latency Register */
/*! @{ */

#define CAAM_DMA0_AWR_LAT_SAWL_MASK              (0xFFFFFFFFU)
#define CAAM_DMA0_AWR_LAT_SAWL_SHIFT             (0U)
#define CAAM_DMA0_AWR_LAT_SAWL(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_DMA0_AWR_LAT_SAWL_SHIFT)) & CAAM_DMA0_AWR_LAT_SAWL_MASK)
/*! @} */

/*! @name MPPKR - Manufacturing Protection Private Key Register */
/*! @{ */

#define CAAM_MPPKR_MPPrivK_MASK                  (0xFFU)
#define CAAM_MPPKR_MPPrivK_SHIFT                 (0U)
#define CAAM_MPPKR_MPPrivK(x)                    (((uint8_t)(((uint8_t)(x)) << CAAM_MPPKR_MPPrivK_SHIFT)) & CAAM_MPPKR_MPPrivK_MASK)
/*! @} */

/* The count of CAAM_MPPKR */
#define CAAM_MPPKR_COUNT                         (64U)

/*! @name MPMR - Manufacturing Protection Message Register */
/*! @{ */

#define CAAM_MPMR_MPMSG_MASK                     (0xFFU)
#define CAAM_MPMR_MPMSG_SHIFT                    (0U)
#define CAAM_MPMR_MPMSG(x)                       (((uint8_t)(((uint8_t)(x)) << CAAM_MPMR_MPMSG_SHIFT)) & CAAM_MPMR_MPMSG_MASK)
/*! @} */

/* The count of CAAM_MPMR */
#define CAAM_MPMR_COUNT                          (32U)

/*! @name MPTESTR - Manufacturing Protection Test Register */
/*! @{ */

#define CAAM_MPTESTR_TEST_VALUE_MASK             (0xFFU)
#define CAAM_MPTESTR_TEST_VALUE_SHIFT            (0U)
#define CAAM_MPTESTR_TEST_VALUE(x)               (((uint8_t)(((uint8_t)(x)) << CAAM_MPTESTR_TEST_VALUE_SHIFT)) & CAAM_MPTESTR_TEST_VALUE_MASK)
/*! @} */

/* The count of CAAM_MPTESTR */
#define CAAM_MPTESTR_COUNT                       (32U)

/*! @name MPECC - Manufacturing Protection ECC Register */
/*! @{ */

#define CAAM_MPECC_MP_SYNDROME_MASK              (0x1FF0000U)
#define CAAM_MPECC_MP_SYNDROME_SHIFT             (16U)
/*! MP_SYNDROME
 *  0b000000000..The MP Key in the SFP passes the ECC check.
 *  0b000000001-0b111111111..The MP Key in the SFP fails the ECC check, and this is the ECC failure syndrome.
 */
#define CAAM_MPECC_MP_SYNDROME(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_MPECC_MP_SYNDROME_SHIFT)) & CAAM_MPECC_MP_SYNDROME_MASK)

#define CAAM_MPECC_MP_ZERO_MASK                  (0x8000000U)
#define CAAM_MPECC_MP_ZERO_SHIFT                 (27U)
/*! MP_ZERO
 *  0b0..The MP Key in the SFP has a non-zero value.
 *  0b1..The MP Key in the SFP is all zeros (unprogrammed).
 */
#define CAAM_MPECC_MP_ZERO(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_MPECC_MP_ZERO_SHIFT)) & CAAM_MPECC_MP_ZERO_MASK)
/*! @} */

/*! @name JDKEKR - Job Descriptor Key Encryption Key Register */
/*! @{ */

#define CAAM_JDKEKR_JDKEK_MASK                   (0xFFFFFFFFU)
#define CAAM_JDKEKR_JDKEK_SHIFT                  (0U)
#define CAAM_JDKEKR_JDKEK(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_JDKEKR_JDKEK_SHIFT)) & CAAM_JDKEKR_JDKEK_MASK)
/*! @} */

/* The count of CAAM_JDKEKR */
#define CAAM_JDKEKR_COUNT                        (8U)

/*! @name TDKEKR - Trusted Descriptor Key Encryption Key Register */
/*! @{ */

#define CAAM_TDKEKR_TDKEK_MASK                   (0xFFFFFFFFU)
#define CAAM_TDKEKR_TDKEK_SHIFT                  (0U)
#define CAAM_TDKEKR_TDKEK(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_TDKEKR_TDKEK_SHIFT)) & CAAM_TDKEKR_TDKEK_MASK)
/*! @} */

/* The count of CAAM_TDKEKR */
#define CAAM_TDKEKR_COUNT                        (8U)

/*! @name TDSKR - Trusted Descriptor Signing Key Register */
/*! @{ */

#define CAAM_TDSKR_TDSK_MASK                     (0xFFFFFFFFU)
#define CAAM_TDSKR_TDSK_SHIFT                    (0U)
#define CAAM_TDSKR_TDSK(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_TDSKR_TDSK_SHIFT)) & CAAM_TDSKR_TDSK_MASK)
/*! @} */

/* The count of CAAM_TDSKR */
#define CAAM_TDSKR_COUNT                         (8U)

/*! @name SKNR - Secure Key Nonce Register */
/*! @{ */

#define CAAM_SKNR_SK_NONCE_LS_MASK               (0xFFFFFFFFU)
#define CAAM_SKNR_SK_NONCE_LS_SHIFT              (0U)
#define CAAM_SKNR_SK_NONCE_LS(x)                 (((uint64_t)(((uint64_t)(x)) << CAAM_SKNR_SK_NONCE_LS_SHIFT)) & CAAM_SKNR_SK_NONCE_LS_MASK)

#define CAAM_SKNR_SK_NONCE_MS_MASK               (0x7FFF00000000U)
#define CAAM_SKNR_SK_NONCE_MS_SHIFT              (32U)
#define CAAM_SKNR_SK_NONCE_MS(x)                 (((uint64_t)(((uint64_t)(x)) << CAAM_SKNR_SK_NONCE_MS_SHIFT)) & CAAM_SKNR_SK_NONCE_MS_MASK)
/*! @} */

/*! @name DMA_STA - DMA Status Register */
/*! @{ */

#define CAAM_DMA_STA_DMA0_ETIF_MASK              (0x1FU)
#define CAAM_DMA_STA_DMA0_ETIF_SHIFT             (0U)
#define CAAM_DMA_STA_DMA0_ETIF(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_STA_DMA0_ETIF_SHIFT)) & CAAM_DMA_STA_DMA0_ETIF_MASK)

#define CAAM_DMA_STA_DMA0_ITIF_MASK              (0x20U)
#define CAAM_DMA_STA_DMA0_ITIF_SHIFT             (5U)
#define CAAM_DMA_STA_DMA0_ITIF(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_STA_DMA0_ITIF_SHIFT)) & CAAM_DMA_STA_DMA0_ITIF_MASK)

#define CAAM_DMA_STA_DMA0_IDLE_MASK              (0x80U)
#define CAAM_DMA_STA_DMA0_IDLE_SHIFT             (7U)
#define CAAM_DMA_STA_DMA0_IDLE(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_STA_DMA0_IDLE_SHIFT)) & CAAM_DMA_STA_DMA0_IDLE_MASK)
/*! @} */

/*! @name DMA_X_AID_7_4_MAP - DMA_X_AID_7_4_MAP */
/*! @{ */

#define CAAM_DMA_X_AID_7_4_MAP_AID4_BID_MASK     (0xFFU)
#define CAAM_DMA_X_AID_7_4_MAP_AID4_BID_SHIFT    (0U)
#define CAAM_DMA_X_AID_7_4_MAP_AID4_BID(x)       (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_7_4_MAP_AID4_BID_SHIFT)) & CAAM_DMA_X_AID_7_4_MAP_AID4_BID_MASK)

#define CAAM_DMA_X_AID_7_4_MAP_AID5_BID_MASK     (0xFF00U)
#define CAAM_DMA_X_AID_7_4_MAP_AID5_BID_SHIFT    (8U)
#define CAAM_DMA_X_AID_7_4_MAP_AID5_BID(x)       (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_7_4_MAP_AID5_BID_SHIFT)) & CAAM_DMA_X_AID_7_4_MAP_AID5_BID_MASK)

#define CAAM_DMA_X_AID_7_4_MAP_AID6_BID_MASK     (0xFF0000U)
#define CAAM_DMA_X_AID_7_4_MAP_AID6_BID_SHIFT    (16U)
#define CAAM_DMA_X_AID_7_4_MAP_AID6_BID(x)       (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_7_4_MAP_AID6_BID_SHIFT)) & CAAM_DMA_X_AID_7_4_MAP_AID6_BID_MASK)

#define CAAM_DMA_X_AID_7_4_MAP_AID7_BID_MASK     (0xFF000000U)
#define CAAM_DMA_X_AID_7_4_MAP_AID7_BID_SHIFT    (24U)
#define CAAM_DMA_X_AID_7_4_MAP_AID7_BID(x)       (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_7_4_MAP_AID7_BID_SHIFT)) & CAAM_DMA_X_AID_7_4_MAP_AID7_BID_MASK)
/*! @} */

/*! @name DMA_X_AID_3_0_MAP - DMA_X_AID_3_0_MAP */
/*! @{ */

#define CAAM_DMA_X_AID_3_0_MAP_AID0_BID_MASK     (0xFFU)
#define CAAM_DMA_X_AID_3_0_MAP_AID0_BID_SHIFT    (0U)
#define CAAM_DMA_X_AID_3_0_MAP_AID0_BID(x)       (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_3_0_MAP_AID0_BID_SHIFT)) & CAAM_DMA_X_AID_3_0_MAP_AID0_BID_MASK)

#define CAAM_DMA_X_AID_3_0_MAP_AID1_BID_MASK     (0xFF00U)
#define CAAM_DMA_X_AID_3_0_MAP_AID1_BID_SHIFT    (8U)
#define CAAM_DMA_X_AID_3_0_MAP_AID1_BID(x)       (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_3_0_MAP_AID1_BID_SHIFT)) & CAAM_DMA_X_AID_3_0_MAP_AID1_BID_MASK)

#define CAAM_DMA_X_AID_3_0_MAP_AID2_BID_MASK     (0xFF0000U)
#define CAAM_DMA_X_AID_3_0_MAP_AID2_BID_SHIFT    (16U)
#define CAAM_DMA_X_AID_3_0_MAP_AID2_BID(x)       (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_3_0_MAP_AID2_BID_SHIFT)) & CAAM_DMA_X_AID_3_0_MAP_AID2_BID_MASK)

#define CAAM_DMA_X_AID_3_0_MAP_AID3_BID_MASK     (0xFF000000U)
#define CAAM_DMA_X_AID_3_0_MAP_AID3_BID_SHIFT    (24U)
#define CAAM_DMA_X_AID_3_0_MAP_AID3_BID(x)       (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_3_0_MAP_AID3_BID_SHIFT)) & CAAM_DMA_X_AID_3_0_MAP_AID3_BID_MASK)
/*! @} */

/*! @name DMA_X_AID_15_12_MAP - DMA_X_AID_15_12_MAP */
/*! @{ */

#define CAAM_DMA_X_AID_15_12_MAP_AID12_BID_MASK  (0xFFU)
#define CAAM_DMA_X_AID_15_12_MAP_AID12_BID_SHIFT (0U)
#define CAAM_DMA_X_AID_15_12_MAP_AID12_BID(x)    (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_12_MAP_AID12_BID_SHIFT)) & CAAM_DMA_X_AID_15_12_MAP_AID12_BID_MASK)

#define CAAM_DMA_X_AID_15_12_MAP_AID13_BID_MASK  (0xFF00U)
#define CAAM_DMA_X_AID_15_12_MAP_AID13_BID_SHIFT (8U)
#define CAAM_DMA_X_AID_15_12_MAP_AID13_BID(x)    (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_12_MAP_AID13_BID_SHIFT)) & CAAM_DMA_X_AID_15_12_MAP_AID13_BID_MASK)

#define CAAM_DMA_X_AID_15_12_MAP_AID14_BID_MASK  (0xFF0000U)
#define CAAM_DMA_X_AID_15_12_MAP_AID14_BID_SHIFT (16U)
#define CAAM_DMA_X_AID_15_12_MAP_AID14_BID(x)    (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_12_MAP_AID14_BID_SHIFT)) & CAAM_DMA_X_AID_15_12_MAP_AID14_BID_MASK)

#define CAAM_DMA_X_AID_15_12_MAP_AID15_BID_MASK  (0xFF000000U)
#define CAAM_DMA_X_AID_15_12_MAP_AID15_BID_SHIFT (24U)
#define CAAM_DMA_X_AID_15_12_MAP_AID15_BID(x)    (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_12_MAP_AID15_BID_SHIFT)) & CAAM_DMA_X_AID_15_12_MAP_AID15_BID_MASK)
/*! @} */

/*! @name DMA_X_AID_11_8_MAP - DMA_X_AID_11_8_MAP */
/*! @{ */

#define CAAM_DMA_X_AID_11_8_MAP_AID8_BID_MASK    (0xFFU)
#define CAAM_DMA_X_AID_11_8_MAP_AID8_BID_SHIFT   (0U)
#define CAAM_DMA_X_AID_11_8_MAP_AID8_BID(x)      (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_11_8_MAP_AID8_BID_SHIFT)) & CAAM_DMA_X_AID_11_8_MAP_AID8_BID_MASK)

#define CAAM_DMA_X_AID_11_8_MAP_AID9_BID_MASK    (0xFF00U)
#define CAAM_DMA_X_AID_11_8_MAP_AID9_BID_SHIFT   (8U)
#define CAAM_DMA_X_AID_11_8_MAP_AID9_BID(x)      (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_11_8_MAP_AID9_BID_SHIFT)) & CAAM_DMA_X_AID_11_8_MAP_AID9_BID_MASK)

#define CAAM_DMA_X_AID_11_8_MAP_AID10_BID_MASK   (0xFF0000U)
#define CAAM_DMA_X_AID_11_8_MAP_AID10_BID_SHIFT  (16U)
#define CAAM_DMA_X_AID_11_8_MAP_AID10_BID(x)     (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_11_8_MAP_AID10_BID_SHIFT)) & CAAM_DMA_X_AID_11_8_MAP_AID10_BID_MASK)

#define CAAM_DMA_X_AID_11_8_MAP_AID11_BID_MASK   (0xFF000000U)
#define CAAM_DMA_X_AID_11_8_MAP_AID11_BID_SHIFT  (24U)
#define CAAM_DMA_X_AID_11_8_MAP_AID11_BID(x)     (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_11_8_MAP_AID11_BID_SHIFT)) & CAAM_DMA_X_AID_11_8_MAP_AID11_BID_MASK)
/*! @} */

/*! @name DMA_X_AID_15_0_EN - DMA_X AXI ID Map Enable Register */
/*! @{ */

#define CAAM_DMA_X_AID_15_0_EN_AID0E_MASK        (0x1U)
#define CAAM_DMA_X_AID_15_0_EN_AID0E_SHIFT       (0U)
#define CAAM_DMA_X_AID_15_0_EN_AID0E(x)          (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID0E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID0E_MASK)

#define CAAM_DMA_X_AID_15_0_EN_AID1E_MASK        (0x2U)
#define CAAM_DMA_X_AID_15_0_EN_AID1E_SHIFT       (1U)
#define CAAM_DMA_X_AID_15_0_EN_AID1E(x)          (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID1E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID1E_MASK)

#define CAAM_DMA_X_AID_15_0_EN_AID2E_MASK        (0x4U)
#define CAAM_DMA_X_AID_15_0_EN_AID2E_SHIFT       (2U)
#define CAAM_DMA_X_AID_15_0_EN_AID2E(x)          (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID2E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID2E_MASK)

#define CAAM_DMA_X_AID_15_0_EN_AID3E_MASK        (0x8U)
#define CAAM_DMA_X_AID_15_0_EN_AID3E_SHIFT       (3U)
#define CAAM_DMA_X_AID_15_0_EN_AID3E(x)          (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID3E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID3E_MASK)

#define CAAM_DMA_X_AID_15_0_EN_AID4E_MASK        (0x10U)
#define CAAM_DMA_X_AID_15_0_EN_AID4E_SHIFT       (4U)
#define CAAM_DMA_X_AID_15_0_EN_AID4E(x)          (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID4E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID4E_MASK)

#define CAAM_DMA_X_AID_15_0_EN_AID5E_MASK        (0x20U)
#define CAAM_DMA_X_AID_15_0_EN_AID5E_SHIFT       (5U)
#define CAAM_DMA_X_AID_15_0_EN_AID5E(x)          (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID5E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID5E_MASK)

#define CAAM_DMA_X_AID_15_0_EN_AID6E_MASK        (0x40U)
#define CAAM_DMA_X_AID_15_0_EN_AID6E_SHIFT       (6U)
#define CAAM_DMA_X_AID_15_0_EN_AID6E(x)          (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID6E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID6E_MASK)

#define CAAM_DMA_X_AID_15_0_EN_AID7E_MASK        (0x80U)
#define CAAM_DMA_X_AID_15_0_EN_AID7E_SHIFT       (7U)
#define CAAM_DMA_X_AID_15_0_EN_AID7E(x)          (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID7E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID7E_MASK)

#define CAAM_DMA_X_AID_15_0_EN_AID8E_MASK        (0x100U)
#define CAAM_DMA_X_AID_15_0_EN_AID8E_SHIFT       (8U)
#define CAAM_DMA_X_AID_15_0_EN_AID8E(x)          (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID8E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID8E_MASK)

#define CAAM_DMA_X_AID_15_0_EN_AID9E_MASK        (0x200U)
#define CAAM_DMA_X_AID_15_0_EN_AID9E_SHIFT       (9U)
#define CAAM_DMA_X_AID_15_0_EN_AID9E(x)          (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID9E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID9E_MASK)

#define CAAM_DMA_X_AID_15_0_EN_AID10E_MASK       (0x400U)
#define CAAM_DMA_X_AID_15_0_EN_AID10E_SHIFT      (10U)
#define CAAM_DMA_X_AID_15_0_EN_AID10E(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID10E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID10E_MASK)

#define CAAM_DMA_X_AID_15_0_EN_AID11E_MASK       (0x800U)
#define CAAM_DMA_X_AID_15_0_EN_AID11E_SHIFT      (11U)
#define CAAM_DMA_X_AID_15_0_EN_AID11E(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID11E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID11E_MASK)

#define CAAM_DMA_X_AID_15_0_EN_AID12E_MASK       (0x1000U)
#define CAAM_DMA_X_AID_15_0_EN_AID12E_SHIFT      (12U)
#define CAAM_DMA_X_AID_15_0_EN_AID12E(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID12E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID12E_MASK)

#define CAAM_DMA_X_AID_15_0_EN_AID13E_MASK       (0x2000U)
#define CAAM_DMA_X_AID_15_0_EN_AID13E_SHIFT      (13U)
#define CAAM_DMA_X_AID_15_0_EN_AID13E(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID13E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID13E_MASK)

#define CAAM_DMA_X_AID_15_0_EN_AID14E_MASK       (0x4000U)
#define CAAM_DMA_X_AID_15_0_EN_AID14E_SHIFT      (14U)
#define CAAM_DMA_X_AID_15_0_EN_AID14E(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID14E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID14E_MASK)

#define CAAM_DMA_X_AID_15_0_EN_AID15E_MASK       (0x8000U)
#define CAAM_DMA_X_AID_15_0_EN_AID15E_SHIFT      (15U)
#define CAAM_DMA_X_AID_15_0_EN_AID15E(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AID_15_0_EN_AID15E_SHIFT)) & CAAM_DMA_X_AID_15_0_EN_AID15E_MASK)
/*! @} */

/*! @name DMA_X_ARTC_CTL - DMA_X AXI Read Timing Check Control Register */
/*! @{ */

#define CAAM_DMA_X_ARTC_CTL_ART_MASK             (0xFFFU)
#define CAAM_DMA_X_ARTC_CTL_ART_SHIFT            (0U)
#define CAAM_DMA_X_ARTC_CTL_ART(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_ARTC_CTL_ART_SHIFT)) & CAAM_DMA_X_ARTC_CTL_ART_MASK)

#define CAAM_DMA_X_ARTC_CTL_ARL_MASK             (0xFFF0000U)
#define CAAM_DMA_X_ARTC_CTL_ARL_SHIFT            (16U)
#define CAAM_DMA_X_ARTC_CTL_ARL(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_ARTC_CTL_ARL_SHIFT)) & CAAM_DMA_X_ARTC_CTL_ARL_MASK)

#define CAAM_DMA_X_ARTC_CTL_ARTL_MASK            (0x10000000U)
#define CAAM_DMA_X_ARTC_CTL_ARTL_SHIFT           (28U)
#define CAAM_DMA_X_ARTC_CTL_ARTL(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_ARTC_CTL_ARTL_SHIFT)) & CAAM_DMA_X_ARTC_CTL_ARTL_MASK)

#define CAAM_DMA_X_ARTC_CTL_ARTT_MASK            (0x20000000U)
#define CAAM_DMA_X_ARTC_CTL_ARTT_SHIFT           (29U)
#define CAAM_DMA_X_ARTC_CTL_ARTT(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_ARTC_CTL_ARTT_SHIFT)) & CAAM_DMA_X_ARTC_CTL_ARTT_MASK)

#define CAAM_DMA_X_ARTC_CTL_ARCT_MASK            (0x40000000U)
#define CAAM_DMA_X_ARTC_CTL_ARCT_SHIFT           (30U)
#define CAAM_DMA_X_ARTC_CTL_ARCT(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_ARTC_CTL_ARCT_SHIFT)) & CAAM_DMA_X_ARTC_CTL_ARCT_MASK)

#define CAAM_DMA_X_ARTC_CTL_ARTCE_MASK           (0x80000000U)
#define CAAM_DMA_X_ARTC_CTL_ARTCE_SHIFT          (31U)
#define CAAM_DMA_X_ARTC_CTL_ARTCE(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_ARTC_CTL_ARTCE_SHIFT)) & CAAM_DMA_X_ARTC_CTL_ARTCE_MASK)
/*! @} */

/*! @name DMA_X_ARTC_LC - DMA_X AXI Read Timing Check Late Count Register */
/*! @{ */

#define CAAM_DMA_X_ARTC_LC_ARLC_MASK             (0xFFFFFU)
#define CAAM_DMA_X_ARTC_LC_ARLC_SHIFT            (0U)
#define CAAM_DMA_X_ARTC_LC_ARLC(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_ARTC_LC_ARLC_SHIFT)) & CAAM_DMA_X_ARTC_LC_ARLC_MASK)
/*! @} */

/*! @name DMA_X_ARTC_SC - DMA_X AXI Read Timing Check Sample Count Register */
/*! @{ */

#define CAAM_DMA_X_ARTC_SC_ARSC_MASK             (0xFFFFFU)
#define CAAM_DMA_X_ARTC_SC_ARSC_SHIFT            (0U)
#define CAAM_DMA_X_ARTC_SC_ARSC(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_ARTC_SC_ARSC_SHIFT)) & CAAM_DMA_X_ARTC_SC_ARSC_MASK)
/*! @} */

/*! @name DMA_X_ARTC_LAT - DMA_X Read Timing Check Latency Register */
/*! @{ */

#define CAAM_DMA_X_ARTC_LAT_SARL_MASK            (0xFFFFFFFFU)
#define CAAM_DMA_X_ARTC_LAT_SARL_SHIFT           (0U)
#define CAAM_DMA_X_ARTC_LAT_SARL(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_ARTC_LAT_SARL_SHIFT)) & CAAM_DMA_X_ARTC_LAT_SARL_MASK)
/*! @} */

/*! @name DMA_X_AWTC_CTL - DMA_X AXI Write Timing Check Control Register */
/*! @{ */

#define CAAM_DMA_X_AWTC_CTL_AWT_MASK             (0xFFFU)
#define CAAM_DMA_X_AWTC_CTL_AWT_SHIFT            (0U)
#define CAAM_DMA_X_AWTC_CTL_AWT(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AWTC_CTL_AWT_SHIFT)) & CAAM_DMA_X_AWTC_CTL_AWT_MASK)

#define CAAM_DMA_X_AWTC_CTL_AWL_MASK             (0xFFF0000U)
#define CAAM_DMA_X_AWTC_CTL_AWL_SHIFT            (16U)
#define CAAM_DMA_X_AWTC_CTL_AWL(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AWTC_CTL_AWL_SHIFT)) & CAAM_DMA_X_AWTC_CTL_AWL_MASK)

#define CAAM_DMA_X_AWTC_CTL_AWTT_MASK            (0x20000000U)
#define CAAM_DMA_X_AWTC_CTL_AWTT_SHIFT           (29U)
#define CAAM_DMA_X_AWTC_CTL_AWTT(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AWTC_CTL_AWTT_SHIFT)) & CAAM_DMA_X_AWTC_CTL_AWTT_MASK)

#define CAAM_DMA_X_AWTC_CTL_AWCT_MASK            (0x40000000U)
#define CAAM_DMA_X_AWTC_CTL_AWCT_SHIFT           (30U)
#define CAAM_DMA_X_AWTC_CTL_AWCT(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AWTC_CTL_AWCT_SHIFT)) & CAAM_DMA_X_AWTC_CTL_AWCT_MASK)

#define CAAM_DMA_X_AWTC_CTL_AWTCE_MASK           (0x80000000U)
#define CAAM_DMA_X_AWTC_CTL_AWTCE_SHIFT          (31U)
#define CAAM_DMA_X_AWTC_CTL_AWTCE(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AWTC_CTL_AWTCE_SHIFT)) & CAAM_DMA_X_AWTC_CTL_AWTCE_MASK)
/*! @} */

/*! @name DMA_X_AWTC_LC - DMA_X AXI Write Timing Check Late Count Register */
/*! @{ */

#define CAAM_DMA_X_AWTC_LC_AWLC_MASK             (0xFFFFFU)
#define CAAM_DMA_X_AWTC_LC_AWLC_SHIFT            (0U)
#define CAAM_DMA_X_AWTC_LC_AWLC(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AWTC_LC_AWLC_SHIFT)) & CAAM_DMA_X_AWTC_LC_AWLC_MASK)
/*! @} */

/*! @name DMA_X_AWTC_SC - DMA_X AXI Write Timing Check Sample Count Register */
/*! @{ */

#define CAAM_DMA_X_AWTC_SC_AWSC_MASK             (0xFFFFFU)
#define CAAM_DMA_X_AWTC_SC_AWSC_SHIFT            (0U)
#define CAAM_DMA_X_AWTC_SC_AWSC(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AWTC_SC_AWSC_SHIFT)) & CAAM_DMA_X_AWTC_SC_AWSC_MASK)
/*! @} */

/*! @name DMA_X_AWTC_LAT - DMA_X Write Timing Check Latency Register */
/*! @{ */

#define CAAM_DMA_X_AWTC_LAT_SAWL_MASK            (0xFFFFFFFFU)
#define CAAM_DMA_X_AWTC_LAT_SAWL_SHIFT           (0U)
#define CAAM_DMA_X_AWTC_LAT_SAWL(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_DMA_X_AWTC_LAT_SAWL_SHIFT)) & CAAM_DMA_X_AWTC_LAT_SAWL_MASK)
/*! @} */

/*! @name RTMCTL - RNG TRNG Miscellaneous Control Register */
/*! @{ */

#define CAAM_RTMCTL_SAMP_MODE_MASK               (0x3U)
#define CAAM_RTMCTL_SAMP_MODE_SHIFT              (0U)
/*! SAMP_MODE
 *  0b00..use Von Neumann data into both Entropy shifter and Statistical Checker
 *  0b01..use raw data into both Entropy shifter and Statistical Checker
 *  0b10..use Von Neumann data into Entropy shifter. Use raw data into Statistical Checker
 *  0b11..undefined/reserved.
 */
#define CAAM_RTMCTL_SAMP_MODE(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTMCTL_SAMP_MODE_SHIFT)) & CAAM_RTMCTL_SAMP_MODE_MASK)

#define CAAM_RTMCTL_OSC_DIV_MASK                 (0xCU)
#define CAAM_RTMCTL_OSC_DIV_SHIFT                (2U)
/*! OSC_DIV
 *  0b00..use ring oscillator with no divide
 *  0b01..use ring oscillator divided-by-2
 *  0b10..use ring oscillator divided-by-4
 *  0b11..use ring oscillator divided-by-8
 */
#define CAAM_RTMCTL_OSC_DIV(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_RTMCTL_OSC_DIV_SHIFT)) & CAAM_RTMCTL_OSC_DIV_MASK)

#define CAAM_RTMCTL_CLK_OUT_EN_MASK              (0x10U)
#define CAAM_RTMCTL_CLK_OUT_EN_SHIFT             (4U)
#define CAAM_RTMCTL_CLK_OUT_EN(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_RTMCTL_CLK_OUT_EN_SHIFT)) & CAAM_RTMCTL_CLK_OUT_EN_MASK)

#define CAAM_RTMCTL_TRNG_ACC_MASK                (0x20U)
#define CAAM_RTMCTL_TRNG_ACC_SHIFT               (5U)
#define CAAM_RTMCTL_TRNG_ACC(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_RTMCTL_TRNG_ACC_SHIFT)) & CAAM_RTMCTL_TRNG_ACC_MASK)

#define CAAM_RTMCTL_RST_DEF_MASK                 (0x40U)
#define CAAM_RTMCTL_RST_DEF_SHIFT                (6U)
#define CAAM_RTMCTL_RST_DEF(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_RTMCTL_RST_DEF_SHIFT)) & CAAM_RTMCTL_RST_DEF_MASK)

#define CAAM_RTMCTL_FORCE_SYSCLK_MASK            (0x80U)
#define CAAM_RTMCTL_FORCE_SYSCLK_SHIFT           (7U)
#define CAAM_RTMCTL_FORCE_SYSCLK(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_RTMCTL_FORCE_SYSCLK_SHIFT)) & CAAM_RTMCTL_FORCE_SYSCLK_MASK)

#define CAAM_RTMCTL_FCT_FAIL_MASK                (0x100U)
#define CAAM_RTMCTL_FCT_FAIL_SHIFT               (8U)
#define CAAM_RTMCTL_FCT_FAIL(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_RTMCTL_FCT_FAIL_SHIFT)) & CAAM_RTMCTL_FCT_FAIL_MASK)

#define CAAM_RTMCTL_FCT_VAL_MASK                 (0x200U)
#define CAAM_RTMCTL_FCT_VAL_SHIFT                (9U)
#define CAAM_RTMCTL_FCT_VAL(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_RTMCTL_FCT_VAL_SHIFT)) & CAAM_RTMCTL_FCT_VAL_MASK)

#define CAAM_RTMCTL_ENT_VAL_MASK                 (0x400U)
#define CAAM_RTMCTL_ENT_VAL_SHIFT                (10U)
#define CAAM_RTMCTL_ENT_VAL(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_RTMCTL_ENT_VAL_SHIFT)) & CAAM_RTMCTL_ENT_VAL_MASK)

#define CAAM_RTMCTL_TST_OUT_MASK                 (0x800U)
#define CAAM_RTMCTL_TST_OUT_SHIFT                (11U)
#define CAAM_RTMCTL_TST_OUT(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_RTMCTL_TST_OUT_SHIFT)) & CAAM_RTMCTL_TST_OUT_MASK)

#define CAAM_RTMCTL_ERR_MASK                     (0x1000U)
#define CAAM_RTMCTL_ERR_SHIFT                    (12U)
#define CAAM_RTMCTL_ERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_RTMCTL_ERR_SHIFT)) & CAAM_RTMCTL_ERR_MASK)

#define CAAM_RTMCTL_TSTOP_OK_MASK                (0x2000U)
#define CAAM_RTMCTL_TSTOP_OK_SHIFT               (13U)
#define CAAM_RTMCTL_TSTOP_OK(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_RTMCTL_TSTOP_OK_SHIFT)) & CAAM_RTMCTL_TSTOP_OK_MASK)

#define CAAM_RTMCTL_PRGM_MASK                    (0x10000U)
#define CAAM_RTMCTL_PRGM_SHIFT                   (16U)
#define CAAM_RTMCTL_PRGM(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_RTMCTL_PRGM_SHIFT)) & CAAM_RTMCTL_PRGM_MASK)
/*! @} */

/*! @name RTSCMISC - RNG TRNG Statistical Check Miscellaneous Register */
/*! @{ */

#define CAAM_RTSCMISC_LRUN_MAX_MASK              (0xFFU)
#define CAAM_RTSCMISC_LRUN_MAX_SHIFT             (0U)
#define CAAM_RTSCMISC_LRUN_MAX(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCMISC_LRUN_MAX_SHIFT)) & CAAM_RTSCMISC_LRUN_MAX_MASK)

#define CAAM_RTSCMISC_RTY_CNT_MASK               (0xF0000U)
#define CAAM_RTSCMISC_RTY_CNT_SHIFT              (16U)
#define CAAM_RTSCMISC_RTY_CNT(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCMISC_RTY_CNT_SHIFT)) & CAAM_RTSCMISC_RTY_CNT_MASK)
/*! @} */

/*! @name RTPKRRNG - RNG TRNG Poker Range Register */
/*! @{ */

#define CAAM_RTPKRRNG_PKR_RNG_MASK               (0xFFFFU)
#define CAAM_RTPKRRNG_PKR_RNG_SHIFT              (0U)
#define CAAM_RTPKRRNG_PKR_RNG(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRRNG_PKR_RNG_SHIFT)) & CAAM_RTPKRRNG_PKR_RNG_MASK)
/*! @} */

/*! @name RTPKRMAX - RNG TRNG Poker Maximum Limit Register */
/*! @{ */

#define CAAM_RTPKRMAX_PKR_MAX_MASK               (0xFFFFFFU)
#define CAAM_RTPKRMAX_PKR_MAX_SHIFT              (0U)
#define CAAM_RTPKRMAX_PKR_MAX(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRMAX_PKR_MAX_SHIFT)) & CAAM_RTPKRMAX_PKR_MAX_MASK)
/*! @} */

/*! @name RTPKRSQ - RNG TRNG Poker Square Calculation Result Register */
/*! @{ */

#define CAAM_RTPKRSQ_PKR_SQ_MASK                 (0xFFFFFFU)
#define CAAM_RTPKRSQ_PKR_SQ_SHIFT                (0U)
#define CAAM_RTPKRSQ_PKR_SQ(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRSQ_PKR_SQ_SHIFT)) & CAAM_RTPKRSQ_PKR_SQ_MASK)
/*! @} */

/*! @name RTSDCTL - RNG TRNG Seed Control Register */
/*! @{ */

#define CAAM_RTSDCTL_SAMP_SIZE_MASK              (0xFFFFU)
#define CAAM_RTSDCTL_SAMP_SIZE_SHIFT             (0U)
#define CAAM_RTSDCTL_SAMP_SIZE(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_RTSDCTL_SAMP_SIZE_SHIFT)) & CAAM_RTSDCTL_SAMP_SIZE_MASK)

#define CAAM_RTSDCTL_ENT_DLY_MASK                (0xFFFF0000U)
#define CAAM_RTSDCTL_ENT_DLY_SHIFT               (16U)
#define CAAM_RTSDCTL_ENT_DLY(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_RTSDCTL_ENT_DLY_SHIFT)) & CAAM_RTSDCTL_ENT_DLY_MASK)
/*! @} */

/*! @name RTSBLIM - RNG TRNG Sparse Bit Limit Register */
/*! @{ */

#define CAAM_RTSBLIM_SB_LIM_MASK                 (0x3FFU)
#define CAAM_RTSBLIM_SB_LIM_SHIFT                (0U)
#define CAAM_RTSBLIM_SB_LIM(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_RTSBLIM_SB_LIM_SHIFT)) & CAAM_RTSBLIM_SB_LIM_MASK)
/*! @} */

/*! @name RTTOTSAM - RNG TRNG Total Samples Register */
/*! @{ */

#define CAAM_RTTOTSAM_TOT_SAM_MASK               (0xFFFFFU)
#define CAAM_RTTOTSAM_TOT_SAM_SHIFT              (0U)
#define CAAM_RTTOTSAM_TOT_SAM(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTTOTSAM_TOT_SAM_SHIFT)) & CAAM_RTTOTSAM_TOT_SAM_MASK)
/*! @} */

/*! @name RTFRQMIN - RNG TRNG Frequency Count Minimum Limit Register */
/*! @{ */

#define CAAM_RTFRQMIN_FRQ_MIN_MASK               (0x3FFFFFU)
#define CAAM_RTFRQMIN_FRQ_MIN_SHIFT              (0U)
#define CAAM_RTFRQMIN_FRQ_MIN(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTFRQMIN_FRQ_MIN_SHIFT)) & CAAM_RTFRQMIN_FRQ_MIN_MASK)
/*! @} */

/*! @name RTFRQCNT - RNG TRNG Frequency Count Register */
/*! @{ */

#define CAAM_RTFRQCNT_FRQ_CNT_MASK               (0x3FFFFFU)
#define CAAM_RTFRQCNT_FRQ_CNT_SHIFT              (0U)
#define CAAM_RTFRQCNT_FRQ_CNT(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTFRQCNT_FRQ_CNT_SHIFT)) & CAAM_RTFRQCNT_FRQ_CNT_MASK)
/*! @} */

/*! @name RTSCMC - RNG TRNG Statistical Check Monobit Count Register */
/*! @{ */

#define CAAM_RTSCMC_MONO_CNT_MASK                (0xFFFFU)
#define CAAM_RTSCMC_MONO_CNT_SHIFT               (0U)
#define CAAM_RTSCMC_MONO_CNT(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCMC_MONO_CNT_SHIFT)) & CAAM_RTSCMC_MONO_CNT_MASK)
/*! @} */

/*! @name RTSCR1C - RNG TRNG Statistical Check Run Length 1 Count Register */
/*! @{ */

#define CAAM_RTSCR1C_R1_0_COUNT_MASK             (0x7FFFU)
#define CAAM_RTSCR1C_R1_0_COUNT_SHIFT            (0U)
#define CAAM_RTSCR1C_R1_0_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR1C_R1_0_COUNT_SHIFT)) & CAAM_RTSCR1C_R1_0_COUNT_MASK)

#define CAAM_RTSCR1C_R1_1_COUNT_MASK             (0x7FFF0000U)
#define CAAM_RTSCR1C_R1_1_COUNT_SHIFT            (16U)
#define CAAM_RTSCR1C_R1_1_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR1C_R1_1_COUNT_SHIFT)) & CAAM_RTSCR1C_R1_1_COUNT_MASK)
/*! @} */

/*! @name RTSCR2C - RNG TRNG Statistical Check Run Length 2 Count Register */
/*! @{ */

#define CAAM_RTSCR2C_R2_0_COUNT_MASK             (0x3FFFU)
#define CAAM_RTSCR2C_R2_0_COUNT_SHIFT            (0U)
#define CAAM_RTSCR2C_R2_0_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR2C_R2_0_COUNT_SHIFT)) & CAAM_RTSCR2C_R2_0_COUNT_MASK)

#define CAAM_RTSCR2C_R2_1_COUNT_MASK             (0x3FFF0000U)
#define CAAM_RTSCR2C_R2_1_COUNT_SHIFT            (16U)
#define CAAM_RTSCR2C_R2_1_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR2C_R2_1_COUNT_SHIFT)) & CAAM_RTSCR2C_R2_1_COUNT_MASK)
/*! @} */

/*! @name RTSCR3C - RNG TRNG Statistical Check Run Length 3 Count Register */
/*! @{ */

#define CAAM_RTSCR3C_R3_0_COUNT_MASK             (0x1FFFU)
#define CAAM_RTSCR3C_R3_0_COUNT_SHIFT            (0U)
#define CAAM_RTSCR3C_R3_0_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR3C_R3_0_COUNT_SHIFT)) & CAAM_RTSCR3C_R3_0_COUNT_MASK)

#define CAAM_RTSCR3C_R3_1_COUNT_MASK             (0x1FFF0000U)
#define CAAM_RTSCR3C_R3_1_COUNT_SHIFT            (16U)
#define CAAM_RTSCR3C_R3_1_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR3C_R3_1_COUNT_SHIFT)) & CAAM_RTSCR3C_R3_1_COUNT_MASK)
/*! @} */

/*! @name RTSCR4C - RNG TRNG Statistical Check Run Length 4 Count Register */
/*! @{ */

#define CAAM_RTSCR4C_R4_0_COUNT_MASK             (0xFFFU)
#define CAAM_RTSCR4C_R4_0_COUNT_SHIFT            (0U)
#define CAAM_RTSCR4C_R4_0_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR4C_R4_0_COUNT_SHIFT)) & CAAM_RTSCR4C_R4_0_COUNT_MASK)

#define CAAM_RTSCR4C_R4_1_COUNT_MASK             (0xFFF0000U)
#define CAAM_RTSCR4C_R4_1_COUNT_SHIFT            (16U)
#define CAAM_RTSCR4C_R4_1_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR4C_R4_1_COUNT_SHIFT)) & CAAM_RTSCR4C_R4_1_COUNT_MASK)
/*! @} */

/*! @name RTSCR5C - RNG TRNG Statistical Check Run Length 5 Count Register */
/*! @{ */

#define CAAM_RTSCR5C_R5_0_COUNT_MASK             (0x7FFU)
#define CAAM_RTSCR5C_R5_0_COUNT_SHIFT            (0U)
#define CAAM_RTSCR5C_R5_0_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR5C_R5_0_COUNT_SHIFT)) & CAAM_RTSCR5C_R5_0_COUNT_MASK)

#define CAAM_RTSCR5C_R5_1_COUNT_MASK             (0x7FF0000U)
#define CAAM_RTSCR5C_R5_1_COUNT_SHIFT            (16U)
#define CAAM_RTSCR5C_R5_1_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR5C_R5_1_COUNT_SHIFT)) & CAAM_RTSCR5C_R5_1_COUNT_MASK)
/*! @} */

/*! @name RTSCR6PC - RNG TRNG Statistical Check Run Length 6+ Count Register */
/*! @{ */

#define CAAM_RTSCR6PC_R6P_0_COUNT_MASK           (0x7FFU)
#define CAAM_RTSCR6PC_R6P_0_COUNT_SHIFT          (0U)
#define CAAM_RTSCR6PC_R6P_0_COUNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR6PC_R6P_0_COUNT_SHIFT)) & CAAM_RTSCR6PC_R6P_0_COUNT_MASK)

#define CAAM_RTSCR6PC_R6P_1_COUNT_MASK           (0x7FF0000U)
#define CAAM_RTSCR6PC_R6P_1_COUNT_SHIFT          (16U)
#define CAAM_RTSCR6PC_R6P_1_COUNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR6PC_R6P_1_COUNT_SHIFT)) & CAAM_RTSCR6PC_R6P_1_COUNT_MASK)
/*! @} */

/*! @name RTFRQMAX - RNG TRNG Frequency Count Maximum Limit Register */
/*! @{ */

#define CAAM_RTFRQMAX_FRQ_MAX_MASK               (0x3FFFFFU)
#define CAAM_RTFRQMAX_FRQ_MAX_SHIFT              (0U)
#define CAAM_RTFRQMAX_FRQ_MAX(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTFRQMAX_FRQ_MAX_SHIFT)) & CAAM_RTFRQMAX_FRQ_MAX_MASK)
/*! @} */

/*! @name RTSCML - RNG TRNG Statistical Check Monobit Limit Register */
/*! @{ */

#define CAAM_RTSCML_MONO_MAX_MASK                (0xFFFFU)
#define CAAM_RTSCML_MONO_MAX_SHIFT               (0U)
#define CAAM_RTSCML_MONO_MAX(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCML_MONO_MAX_SHIFT)) & CAAM_RTSCML_MONO_MAX_MASK)

#define CAAM_RTSCML_MONO_RNG_MASK                (0xFFFF0000U)
#define CAAM_RTSCML_MONO_RNG_SHIFT               (16U)
#define CAAM_RTSCML_MONO_RNG(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCML_MONO_RNG_SHIFT)) & CAAM_RTSCML_MONO_RNG_MASK)
/*! @} */

/*! @name RTSCR1L - RNG TRNG Statistical Check Run Length 1 Limit Register */
/*! @{ */

#define CAAM_RTSCR1L_RUN1_MAX_MASK               (0x7FFFU)
#define CAAM_RTSCR1L_RUN1_MAX_SHIFT              (0U)
#define CAAM_RTSCR1L_RUN1_MAX(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR1L_RUN1_MAX_SHIFT)) & CAAM_RTSCR1L_RUN1_MAX_MASK)

#define CAAM_RTSCR1L_RUN1_RNG_MASK               (0x7FFF0000U)
#define CAAM_RTSCR1L_RUN1_RNG_SHIFT              (16U)
#define CAAM_RTSCR1L_RUN1_RNG(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR1L_RUN1_RNG_SHIFT)) & CAAM_RTSCR1L_RUN1_RNG_MASK)
/*! @} */

/*! @name RTSCR2L - RNG TRNG Statistical Check Run Length 2 Limit Register */
/*! @{ */

#define CAAM_RTSCR2L_RUN2_MAX_MASK               (0x3FFFU)
#define CAAM_RTSCR2L_RUN2_MAX_SHIFT              (0U)
#define CAAM_RTSCR2L_RUN2_MAX(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR2L_RUN2_MAX_SHIFT)) & CAAM_RTSCR2L_RUN2_MAX_MASK)

#define CAAM_RTSCR2L_RUN2_RNG_MASK               (0x3FFF0000U)
#define CAAM_RTSCR2L_RUN2_RNG_SHIFT              (16U)
#define CAAM_RTSCR2L_RUN2_RNG(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR2L_RUN2_RNG_SHIFT)) & CAAM_RTSCR2L_RUN2_RNG_MASK)
/*! @} */

/*! @name RTSCR3L - RNG TRNG Statistical Check Run Length 3 Limit Register */
/*! @{ */

#define CAAM_RTSCR3L_RUN3_MAX_MASK               (0x1FFFU)
#define CAAM_RTSCR3L_RUN3_MAX_SHIFT              (0U)
#define CAAM_RTSCR3L_RUN3_MAX(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR3L_RUN3_MAX_SHIFT)) & CAAM_RTSCR3L_RUN3_MAX_MASK)

#define CAAM_RTSCR3L_RUN3_RNG_MASK               (0x1FFF0000U)
#define CAAM_RTSCR3L_RUN3_RNG_SHIFT              (16U)
#define CAAM_RTSCR3L_RUN3_RNG(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR3L_RUN3_RNG_SHIFT)) & CAAM_RTSCR3L_RUN3_RNG_MASK)
/*! @} */

/*! @name RTSCR4L - RNG TRNG Statistical Check Run Length 4 Limit Register */
/*! @{ */

#define CAAM_RTSCR4L_RUN4_MAX_MASK               (0xFFFU)
#define CAAM_RTSCR4L_RUN4_MAX_SHIFT              (0U)
#define CAAM_RTSCR4L_RUN4_MAX(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR4L_RUN4_MAX_SHIFT)) & CAAM_RTSCR4L_RUN4_MAX_MASK)

#define CAAM_RTSCR4L_RUN4_RNG_MASK               (0xFFF0000U)
#define CAAM_RTSCR4L_RUN4_RNG_SHIFT              (16U)
#define CAAM_RTSCR4L_RUN4_RNG(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR4L_RUN4_RNG_SHIFT)) & CAAM_RTSCR4L_RUN4_RNG_MASK)
/*! @} */

/*! @name RTSCR5L - RNG TRNG Statistical Check Run Length 5 Limit Register */
/*! @{ */

#define CAAM_RTSCR5L_RUN5_MAX_MASK               (0x7FFU)
#define CAAM_RTSCR5L_RUN5_MAX_SHIFT              (0U)
#define CAAM_RTSCR5L_RUN5_MAX(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR5L_RUN5_MAX_SHIFT)) & CAAM_RTSCR5L_RUN5_MAX_MASK)

#define CAAM_RTSCR5L_RUN5_RNG_MASK               (0x7FF0000U)
#define CAAM_RTSCR5L_RUN5_RNG_SHIFT              (16U)
#define CAAM_RTSCR5L_RUN5_RNG(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR5L_RUN5_RNG_SHIFT)) & CAAM_RTSCR5L_RUN5_RNG_MASK)
/*! @} */

/*! @name RTSCR6PL - RNG TRNG Statistical Check Run Length 6+ Limit Register */
/*! @{ */

#define CAAM_RTSCR6PL_RUN6P_MAX_MASK             (0x7FFU)
#define CAAM_RTSCR6PL_RUN6P_MAX_SHIFT            (0U)
#define CAAM_RTSCR6PL_RUN6P_MAX(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR6PL_RUN6P_MAX_SHIFT)) & CAAM_RTSCR6PL_RUN6P_MAX_MASK)

#define CAAM_RTSCR6PL_RUN6P_RNG_MASK             (0x7FF0000U)
#define CAAM_RTSCR6PL_RUN6P_RNG_SHIFT            (16U)
#define CAAM_RTSCR6PL_RUN6P_RNG(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_RTSCR6PL_RUN6P_RNG_SHIFT)) & CAAM_RTSCR6PL_RUN6P_RNG_MASK)
/*! @} */

/*! @name RTSTATUS - RNG TRNG Status Register */
/*! @{ */

#define CAAM_RTSTATUS_F1BR0TF_MASK               (0x1U)
#define CAAM_RTSTATUS_F1BR0TF_SHIFT              (0U)
#define CAAM_RTSTATUS_F1BR0TF(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_F1BR0TF_SHIFT)) & CAAM_RTSTATUS_F1BR0TF_MASK)

#define CAAM_RTSTATUS_F1BR1TF_MASK               (0x2U)
#define CAAM_RTSTATUS_F1BR1TF_SHIFT              (1U)
#define CAAM_RTSTATUS_F1BR1TF(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_F1BR1TF_SHIFT)) & CAAM_RTSTATUS_F1BR1TF_MASK)

#define CAAM_RTSTATUS_F2BR0TF_MASK               (0x4U)
#define CAAM_RTSTATUS_F2BR0TF_SHIFT              (2U)
#define CAAM_RTSTATUS_F2BR0TF(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_F2BR0TF_SHIFT)) & CAAM_RTSTATUS_F2BR0TF_MASK)

#define CAAM_RTSTATUS_F2BR1TF_MASK               (0x8U)
#define CAAM_RTSTATUS_F2BR1TF_SHIFT              (3U)
#define CAAM_RTSTATUS_F2BR1TF(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_F2BR1TF_SHIFT)) & CAAM_RTSTATUS_F2BR1TF_MASK)

#define CAAM_RTSTATUS_F3BR01TF_MASK              (0x10U)
#define CAAM_RTSTATUS_F3BR01TF_SHIFT             (4U)
#define CAAM_RTSTATUS_F3BR01TF(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_F3BR01TF_SHIFT)) & CAAM_RTSTATUS_F3BR01TF_MASK)

#define CAAM_RTSTATUS_F3BR1TF_MASK               (0x20U)
#define CAAM_RTSTATUS_F3BR1TF_SHIFT              (5U)
#define CAAM_RTSTATUS_F3BR1TF(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_F3BR1TF_SHIFT)) & CAAM_RTSTATUS_F3BR1TF_MASK)

#define CAAM_RTSTATUS_F4BR0TF_MASK               (0x40U)
#define CAAM_RTSTATUS_F4BR0TF_SHIFT              (6U)
#define CAAM_RTSTATUS_F4BR0TF(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_F4BR0TF_SHIFT)) & CAAM_RTSTATUS_F4BR0TF_MASK)

#define CAAM_RTSTATUS_F4BR1TF_MASK               (0x80U)
#define CAAM_RTSTATUS_F4BR1TF_SHIFT              (7U)
#define CAAM_RTSTATUS_F4BR1TF(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_F4BR1TF_SHIFT)) & CAAM_RTSTATUS_F4BR1TF_MASK)

#define CAAM_RTSTATUS_F5BR0TF_MASK               (0x100U)
#define CAAM_RTSTATUS_F5BR0TF_SHIFT              (8U)
#define CAAM_RTSTATUS_F5BR0TF(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_F5BR0TF_SHIFT)) & CAAM_RTSTATUS_F5BR0TF_MASK)

#define CAAM_RTSTATUS_F5BR1TF_MASK               (0x200U)
#define CAAM_RTSTATUS_F5BR1TF_SHIFT              (9U)
#define CAAM_RTSTATUS_F5BR1TF(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_F5BR1TF_SHIFT)) & CAAM_RTSTATUS_F5BR1TF_MASK)

#define CAAM_RTSTATUS_F6PBR0TF_MASK              (0x400U)
#define CAAM_RTSTATUS_F6PBR0TF_SHIFT             (10U)
#define CAAM_RTSTATUS_F6PBR0TF(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_F6PBR0TF_SHIFT)) & CAAM_RTSTATUS_F6PBR0TF_MASK)

#define CAAM_RTSTATUS_F6PBR1TF_MASK              (0x800U)
#define CAAM_RTSTATUS_F6PBR1TF_SHIFT             (11U)
#define CAAM_RTSTATUS_F6PBR1TF(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_F6PBR1TF_SHIFT)) & CAAM_RTSTATUS_F6PBR1TF_MASK)

#define CAAM_RTSTATUS_FSBTF_MASK                 (0x1000U)
#define CAAM_RTSTATUS_FSBTF_SHIFT                (12U)
#define CAAM_RTSTATUS_FSBTF(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_FSBTF_SHIFT)) & CAAM_RTSTATUS_FSBTF_MASK)

#define CAAM_RTSTATUS_FLRTF_MASK                 (0x2000U)
#define CAAM_RTSTATUS_FLRTF_SHIFT                (13U)
#define CAAM_RTSTATUS_FLRTF(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_FLRTF_SHIFT)) & CAAM_RTSTATUS_FLRTF_MASK)

#define CAAM_RTSTATUS_FPTF_MASK                  (0x4000U)
#define CAAM_RTSTATUS_FPTF_SHIFT                 (14U)
#define CAAM_RTSTATUS_FPTF(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_FPTF_SHIFT)) & CAAM_RTSTATUS_FPTF_MASK)

#define CAAM_RTSTATUS_FMBTF_MASK                 (0x8000U)
#define CAAM_RTSTATUS_FMBTF_SHIFT                (15U)
#define CAAM_RTSTATUS_FMBTF(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_FMBTF_SHIFT)) & CAAM_RTSTATUS_FMBTF_MASK)

#define CAAM_RTSTATUS_RETRY_COUNT_MASK           (0xF0000U)
#define CAAM_RTSTATUS_RETRY_COUNT_SHIFT          (16U)
#define CAAM_RTSTATUS_RETRY_COUNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTSTATUS_RETRY_COUNT_SHIFT)) & CAAM_RTSTATUS_RETRY_COUNT_MASK)
/*! @} */

/*! @name RTENT - RNG TRNG Entropy Read Register */
/*! @{ */

#define CAAM_RTENT_ENT_MASK                      (0xFFFFFFFFU)
#define CAAM_RTENT_ENT_SHIFT                     (0U)
#define CAAM_RTENT_ENT(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_RTENT_ENT_SHIFT)) & CAAM_RTENT_ENT_MASK)
/*! @} */

/* The count of CAAM_RTENT */
#define CAAM_RTENT_COUNT                         (16U)

/*! @name RTPKRCNT10 - RNG TRNG Statistical Check Poker Count 1 and 0 Register */
/*! @{ */

#define CAAM_RTPKRCNT10_PKR_0_CNT_MASK           (0xFFFFU)
#define CAAM_RTPKRCNT10_PKR_0_CNT_SHIFT          (0U)
#define CAAM_RTPKRCNT10_PKR_0_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNT10_PKR_0_CNT_SHIFT)) & CAAM_RTPKRCNT10_PKR_0_CNT_MASK)

#define CAAM_RTPKRCNT10_PKR_1_CNT_MASK           (0xFFFF0000U)
#define CAAM_RTPKRCNT10_PKR_1_CNT_SHIFT          (16U)
#define CAAM_RTPKRCNT10_PKR_1_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNT10_PKR_1_CNT_SHIFT)) & CAAM_RTPKRCNT10_PKR_1_CNT_MASK)
/*! @} */

/*! @name RTPKRCNT32 - RNG TRNG Statistical Check Poker Count 3 and 2 Register */
/*! @{ */

#define CAAM_RTPKRCNT32_PKR_2_CNT_MASK           (0xFFFFU)
#define CAAM_RTPKRCNT32_PKR_2_CNT_SHIFT          (0U)
#define CAAM_RTPKRCNT32_PKR_2_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNT32_PKR_2_CNT_SHIFT)) & CAAM_RTPKRCNT32_PKR_2_CNT_MASK)

#define CAAM_RTPKRCNT32_PKR_3_CNT_MASK           (0xFFFF0000U)
#define CAAM_RTPKRCNT32_PKR_3_CNT_SHIFT          (16U)
#define CAAM_RTPKRCNT32_PKR_3_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNT32_PKR_3_CNT_SHIFT)) & CAAM_RTPKRCNT32_PKR_3_CNT_MASK)
/*! @} */

/*! @name RTPKRCNT54 - RNG TRNG Statistical Check Poker Count 5 and 4 Register */
/*! @{ */

#define CAAM_RTPKRCNT54_PKR_4_CNT_MASK           (0xFFFFU)
#define CAAM_RTPKRCNT54_PKR_4_CNT_SHIFT          (0U)
#define CAAM_RTPKRCNT54_PKR_4_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNT54_PKR_4_CNT_SHIFT)) & CAAM_RTPKRCNT54_PKR_4_CNT_MASK)

#define CAAM_RTPKRCNT54_PKR_5_CNT_MASK           (0xFFFF0000U)
#define CAAM_RTPKRCNT54_PKR_5_CNT_SHIFT          (16U)
#define CAAM_RTPKRCNT54_PKR_5_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNT54_PKR_5_CNT_SHIFT)) & CAAM_RTPKRCNT54_PKR_5_CNT_MASK)
/*! @} */

/*! @name RTPKRCNT76 - RNG TRNG Statistical Check Poker Count 7 and 6 Register */
/*! @{ */

#define CAAM_RTPKRCNT76_PKR_6_CNT_MASK           (0xFFFFU)
#define CAAM_RTPKRCNT76_PKR_6_CNT_SHIFT          (0U)
#define CAAM_RTPKRCNT76_PKR_6_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNT76_PKR_6_CNT_SHIFT)) & CAAM_RTPKRCNT76_PKR_6_CNT_MASK)

#define CAAM_RTPKRCNT76_PKR_7_CNT_MASK           (0xFFFF0000U)
#define CAAM_RTPKRCNT76_PKR_7_CNT_SHIFT          (16U)
#define CAAM_RTPKRCNT76_PKR_7_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNT76_PKR_7_CNT_SHIFT)) & CAAM_RTPKRCNT76_PKR_7_CNT_MASK)
/*! @} */

/*! @name RTPKRCNT98 - RNG TRNG Statistical Check Poker Count 9 and 8 Register */
/*! @{ */

#define CAAM_RTPKRCNT98_PKR_8_CNT_MASK           (0xFFFFU)
#define CAAM_RTPKRCNT98_PKR_8_CNT_SHIFT          (0U)
#define CAAM_RTPKRCNT98_PKR_8_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNT98_PKR_8_CNT_SHIFT)) & CAAM_RTPKRCNT98_PKR_8_CNT_MASK)

#define CAAM_RTPKRCNT98_PKR_9_CNT_MASK           (0xFFFF0000U)
#define CAAM_RTPKRCNT98_PKR_9_CNT_SHIFT          (16U)
#define CAAM_RTPKRCNT98_PKR_9_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNT98_PKR_9_CNT_SHIFT)) & CAAM_RTPKRCNT98_PKR_9_CNT_MASK)
/*! @} */

/*! @name RTPKRCNTBA - RNG TRNG Statistical Check Poker Count B and A Register */
/*! @{ */

#define CAAM_RTPKRCNTBA_PKR_A_CNT_MASK           (0xFFFFU)
#define CAAM_RTPKRCNTBA_PKR_A_CNT_SHIFT          (0U)
#define CAAM_RTPKRCNTBA_PKR_A_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNTBA_PKR_A_CNT_SHIFT)) & CAAM_RTPKRCNTBA_PKR_A_CNT_MASK)

#define CAAM_RTPKRCNTBA_PKR_B_CNT_MASK           (0xFFFF0000U)
#define CAAM_RTPKRCNTBA_PKR_B_CNT_SHIFT          (16U)
#define CAAM_RTPKRCNTBA_PKR_B_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNTBA_PKR_B_CNT_SHIFT)) & CAAM_RTPKRCNTBA_PKR_B_CNT_MASK)
/*! @} */

/*! @name RTPKRCNTDC - RNG TRNG Statistical Check Poker Count D and C Register */
/*! @{ */

#define CAAM_RTPKRCNTDC_PKR_C_CNT_MASK           (0xFFFFU)
#define CAAM_RTPKRCNTDC_PKR_C_CNT_SHIFT          (0U)
#define CAAM_RTPKRCNTDC_PKR_C_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNTDC_PKR_C_CNT_SHIFT)) & CAAM_RTPKRCNTDC_PKR_C_CNT_MASK)

#define CAAM_RTPKRCNTDC_PKR_D_CNT_MASK           (0xFFFF0000U)
#define CAAM_RTPKRCNTDC_PKR_D_CNT_SHIFT          (16U)
#define CAAM_RTPKRCNTDC_PKR_D_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNTDC_PKR_D_CNT_SHIFT)) & CAAM_RTPKRCNTDC_PKR_D_CNT_MASK)
/*! @} */

/*! @name RTPKRCNTFE - RNG TRNG Statistical Check Poker Count F and E Register */
/*! @{ */

#define CAAM_RTPKRCNTFE_PKR_E_CNT_MASK           (0xFFFFU)
#define CAAM_RTPKRCNTFE_PKR_E_CNT_SHIFT          (0U)
#define CAAM_RTPKRCNTFE_PKR_E_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNTFE_PKR_E_CNT_SHIFT)) & CAAM_RTPKRCNTFE_PKR_E_CNT_MASK)

#define CAAM_RTPKRCNTFE_PKR_F_CNT_MASK           (0xFFFF0000U)
#define CAAM_RTPKRCNTFE_PKR_F_CNT_SHIFT          (16U)
#define CAAM_RTPKRCNTFE_PKR_F_CNT(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RTPKRCNTFE_PKR_F_CNT_SHIFT)) & CAAM_RTPKRCNTFE_PKR_F_CNT_MASK)
/*! @} */

/*! @name RDSTA - RNG DRNG Status Register */
/*! @{ */

#define CAAM_RDSTA_IF0_MASK                      (0x1U)
#define CAAM_RDSTA_IF0_SHIFT                     (0U)
#define CAAM_RDSTA_IF0(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_RDSTA_IF0_SHIFT)) & CAAM_RDSTA_IF0_MASK)

#define CAAM_RDSTA_IF1_MASK                      (0x2U)
#define CAAM_RDSTA_IF1_SHIFT                     (1U)
#define CAAM_RDSTA_IF1(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_RDSTA_IF1_SHIFT)) & CAAM_RDSTA_IF1_MASK)

#define CAAM_RDSTA_PR0_MASK                      (0x10U)
#define CAAM_RDSTA_PR0_SHIFT                     (4U)
#define CAAM_RDSTA_PR0(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_RDSTA_PR0_SHIFT)) & CAAM_RDSTA_PR0_MASK)

#define CAAM_RDSTA_PR1_MASK                      (0x20U)
#define CAAM_RDSTA_PR1_SHIFT                     (5U)
#define CAAM_RDSTA_PR1(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_RDSTA_PR1_SHIFT)) & CAAM_RDSTA_PR1_MASK)

#define CAAM_RDSTA_TF0_MASK                      (0x100U)
#define CAAM_RDSTA_TF0_SHIFT                     (8U)
#define CAAM_RDSTA_TF0(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_RDSTA_TF0_SHIFT)) & CAAM_RDSTA_TF0_MASK)

#define CAAM_RDSTA_TF1_MASK                      (0x200U)
#define CAAM_RDSTA_TF1_SHIFT                     (9U)
#define CAAM_RDSTA_TF1(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_RDSTA_TF1_SHIFT)) & CAAM_RDSTA_TF1_MASK)

#define CAAM_RDSTA_ERRCODE_MASK                  (0xF0000U)
#define CAAM_RDSTA_ERRCODE_SHIFT                 (16U)
#define CAAM_RDSTA_ERRCODE(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_RDSTA_ERRCODE_SHIFT)) & CAAM_RDSTA_ERRCODE_MASK)

#define CAAM_RDSTA_CE_MASK                       (0x100000U)
#define CAAM_RDSTA_CE_SHIFT                      (20U)
#define CAAM_RDSTA_CE(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_RDSTA_CE_SHIFT)) & CAAM_RDSTA_CE_MASK)

#define CAAM_RDSTA_SKVN_MASK                     (0x40000000U)
#define CAAM_RDSTA_SKVN_SHIFT                    (30U)
#define CAAM_RDSTA_SKVN(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_RDSTA_SKVN_SHIFT)) & CAAM_RDSTA_SKVN_MASK)

#define CAAM_RDSTA_SKVT_MASK                     (0x80000000U)
#define CAAM_RDSTA_SKVT_SHIFT                    (31U)
#define CAAM_RDSTA_SKVT(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_RDSTA_SKVT_SHIFT)) & CAAM_RDSTA_SKVT_MASK)
/*! @} */

/*! @name RDINT0 - RNG DRNG State Handle 0 Reseed Interval Register */
/*! @{ */

#define CAAM_RDINT0_RESINT0_MASK                 (0xFFFFFFFFU)
#define CAAM_RDINT0_RESINT0_SHIFT                (0U)
#define CAAM_RDINT0_RESINT0(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_RDINT0_RESINT0_SHIFT)) & CAAM_RDINT0_RESINT0_MASK)
/*! @} */

/*! @name RDINT1 - RNG DRNG State Handle 1 Reseed Interval Register */
/*! @{ */

#define CAAM_RDINT1_RESINT1_MASK                 (0xFFFFFFFFU)
#define CAAM_RDINT1_RESINT1_SHIFT                (0U)
#define CAAM_RDINT1_RESINT1(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_RDINT1_RESINT1_SHIFT)) & CAAM_RDINT1_RESINT1_MASK)
/*! @} */

/*! @name RDHCNTL - RNG DRNG Hash Control Register */
/*! @{ */

#define CAAM_RDHCNTL_HD_MASK                     (0x1U)
#define CAAM_RDHCNTL_HD_SHIFT                    (0U)
#define CAAM_RDHCNTL_HD(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_RDHCNTL_HD_SHIFT)) & CAAM_RDHCNTL_HD_MASK)

#define CAAM_RDHCNTL_HB_MASK                     (0x2U)
#define CAAM_RDHCNTL_HB_SHIFT                    (1U)
#define CAAM_RDHCNTL_HB(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_RDHCNTL_HB_SHIFT)) & CAAM_RDHCNTL_HB_MASK)

#define CAAM_RDHCNTL_HI_MASK                     (0x4U)
#define CAAM_RDHCNTL_HI_SHIFT                    (2U)
#define CAAM_RDHCNTL_HI(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_RDHCNTL_HI_SHIFT)) & CAAM_RDHCNTL_HI_MASK)

#define CAAM_RDHCNTL_HTM_MASK                    (0x8U)
#define CAAM_RDHCNTL_HTM_SHIFT                   (3U)
#define CAAM_RDHCNTL_HTM(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_RDHCNTL_HTM_SHIFT)) & CAAM_RDHCNTL_HTM_MASK)

#define CAAM_RDHCNTL_HTC_MASK                    (0x10U)
#define CAAM_RDHCNTL_HTC_SHIFT                   (4U)
#define CAAM_RDHCNTL_HTC(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_RDHCNTL_HTC_SHIFT)) & CAAM_RDHCNTL_HTC_MASK)
/*! @} */

/*! @name RDHDIG - RNG DRNG Hash Digest Register */
/*! @{ */

#define CAAM_RDHDIG_HASHMD_MASK                  (0xFFFFFFFFU)
#define CAAM_RDHDIG_HASHMD_SHIFT                 (0U)
#define CAAM_RDHDIG_HASHMD(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_RDHDIG_HASHMD_SHIFT)) & CAAM_RDHDIG_HASHMD_MASK)
/*! @} */

/*! @name RDHBUF - RNG DRNG Hash Buffer Register */
/*! @{ */

#define CAAM_RDHBUF_HASHBUF_MASK                 (0xFFFFFFFFU)
#define CAAM_RDHBUF_HASHBUF_SHIFT                (0U)
#define CAAM_RDHBUF_HASHBUF(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_RDHBUF_HASHBUF_SHIFT)) & CAAM_RDHBUF_HASHBUF_MASK)
/*! @} */

/*! @name PX_SDID_PG0 - Partition 0 SDID register..Partition 15 SDID register */
/*! @{ */

#define CAAM_PX_SDID_PG0_SDID_MASK               (0xFFFFU)
#define CAAM_PX_SDID_PG0_SDID_SHIFT              (0U)
#define CAAM_PX_SDID_PG0_SDID(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SDID_PG0_SDID_SHIFT)) & CAAM_PX_SDID_PG0_SDID_MASK)
/*! @} */

/* The count of CAAM_PX_SDID_PG0 */
#define CAAM_PX_SDID_PG0_COUNT                   (16U)

/*! @name PX_SMAPR_PG0 - Secure Memory Access Permissions register */
/*! @{ */

#define CAAM_PX_SMAPR_PG0_G1_READ_MASK           (0x1U)
#define CAAM_PX_SMAPR_PG0_G1_READ_SHIFT          (0U)
/*! G1_READ
 *  0b0..Instruction fetches and reads are prohibited (except that Trusted Descriptor reads (if G1_TDO=1) and
 *       key-reads are always allowed, and exporting Secure Memory Blobs is allowed if G1_SMBLOB=1 or if done by a
 *       Trusted Descriptor and G1_TDO=1).
 *  0b1..Instruction fetches and reads are allowed (but exporting a Secure Memory Blob is prohibited if
 *       G1_SMBLOB=0 and the descriptor is not a Trusted Descriptor or if G1_TDO=0).
 */
#define CAAM_PX_SMAPR_PG0_G1_READ(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_PG0_G1_READ_SHIFT)) & CAAM_PX_SMAPR_PG0_G1_READ_MASK)

#define CAAM_PX_SMAPR_PG0_G1_WRITE_MASK          (0x2U)
#define CAAM_PX_SMAPR_PG0_G1_WRITE_SHIFT         (1U)
/*! G1_WRITE
 *  0b0..Writes are prohibited (except that Trusted Descriptor writes are allowed, and importing Secure Memory
 *       Blobs is allowed if G1_SMBLOB=1 or if done by a Trusted Descriptor and G1_TDO=1).
 *  0b1..Writes are allowed (but importing a Secure Memory Blob is prohibited if G1_SMBLOB=0 and the descriptor is
 *       not a Trusted Descriptor or if G1_TDO=0).
 */
#define CAAM_PX_SMAPR_PG0_G1_WRITE(x)            (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_PG0_G1_WRITE_SHIFT)) & CAAM_PX_SMAPR_PG0_G1_WRITE_MASK)

#define CAAM_PX_SMAPR_PG0_G1_TDO_MASK            (0x4U)
#define CAAM_PX_SMAPR_PG0_G1_TDO_SHIFT           (2U)
/*! G1_TDO
 *  0b0..Trusted Descriptors have the same access privileges as Job Descriptors
 *  0b1..Trusted Descriptors are allowed to override the other access permissions, i.e. they can export blobs from
 *       or import blobs to the partition and read from and write to the partition regardless of the G1_SMBLOB,
 *       G1_WRITE and G1_READ settings.
 */
#define CAAM_PX_SMAPR_PG0_G1_TDO(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_PG0_G1_TDO_SHIFT)) & CAAM_PX_SMAPR_PG0_G1_TDO_MASK)

#define CAAM_PX_SMAPR_PG0_G1_SMBLOB_MASK         (0x8U)
#define CAAM_PX_SMAPR_PG0_G1_SMBLOB_SHIFT        (3U)
/*! G1_SMBLOB
 *  0b0..Exporting or importing Secure Memory Blobs is prohibited, unless done via a Trusted Descriptor and G1_TDO=1.
 *  0b1..Exporting or importing Secure Memory Blobs is allowed, regardless of the G1_READ and G1_WRITE settings.
 */
#define CAAM_PX_SMAPR_PG0_G1_SMBLOB(x)           (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_PG0_G1_SMBLOB_SHIFT)) & CAAM_PX_SMAPR_PG0_G1_SMBLOB_MASK)

#define CAAM_PX_SMAPR_PG0_G2_READ_MASK           (0x10U)
#define CAAM_PX_SMAPR_PG0_G2_READ_SHIFT          (4U)
/*! G2_READ
 *  0b0..Instruction fetches and reads are prohibited (except that Trusted Descriptor reads (if G2_TDO=1) and
 *       key-reads are always allowed, and exporting Secure Memory Blobs is allowed if G2_SMBLOB=1 or if done by a
 *       Trusted Descriptor and G2_TDO=1).
 *  0b1..Instruction fetches and reads are allowed (but exporting a Secure Memory Blob is prohibited if
 *       G2_SMBLOB=0 and the descriptor is not a Trusted Descriptor or if G2_TDO=0).
 */
#define CAAM_PX_SMAPR_PG0_G2_READ(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_PG0_G2_READ_SHIFT)) & CAAM_PX_SMAPR_PG0_G2_READ_MASK)

#define CAAM_PX_SMAPR_PG0_G2_WRITE_MASK          (0x20U)
#define CAAM_PX_SMAPR_PG0_G2_WRITE_SHIFT         (5U)
/*! G2_WRITE
 *  0b0..Writes are prohibited (except that Trusted Descriptor writes are allowed, and importing Secure Memory
 *       Blobs is allowed if G2_SMBLOB=1 or if done by a Trusted Descriptor and G2_TDO=1).
 *  0b1..Writes are allowed (but importing a Secure Memory Blob is prohibited if G2_SMBLOB=0 and the descriptor is
 *       not a Trusted Descriptor or if G2_TDO=0).
 */
#define CAAM_PX_SMAPR_PG0_G2_WRITE(x)            (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_PG0_G2_WRITE_SHIFT)) & CAAM_PX_SMAPR_PG0_G2_WRITE_MASK)

#define CAAM_PX_SMAPR_PG0_G2_TDO_MASK            (0x40U)
#define CAAM_PX_SMAPR_PG0_G2_TDO_SHIFT           (6U)
/*! G2_TDO
 *  0b0..Trusted Descriptors have the same access privileges as Job Descriptors
 *  0b1..Trusted Descriptors are allowed to override the other access permissions, i.e. they can export blobs from
 *       or import blobs to the partition and read from and write to the partition regardless of the G2_SMBLOB,
 *       G2_WRITE and G2_READ settings.
 */
#define CAAM_PX_SMAPR_PG0_G2_TDO(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_PG0_G2_TDO_SHIFT)) & CAAM_PX_SMAPR_PG0_G2_TDO_MASK)

#define CAAM_PX_SMAPR_PG0_G2_SMBLOB_MASK         (0x80U)
#define CAAM_PX_SMAPR_PG0_G2_SMBLOB_SHIFT        (7U)
/*! G2_SMBLOB
 *  0b0..Exporting or importing Secure Memory Blobs is prohibited, unless done via a Trusted Descriptor and G2_TDO=1.
 *  0b1..Exporting or importing Secure Memory Blobs is allowed, regardless of the G2_READ and G2_WRITE settings.
 */
#define CAAM_PX_SMAPR_PG0_G2_SMBLOB(x)           (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_PG0_G2_SMBLOB_SHIFT)) & CAAM_PX_SMAPR_PG0_G2_SMBLOB_MASK)

#define CAAM_PX_SMAPR_PG0_SMAG_LCK_MASK          (0x1000U)
#define CAAM_PX_SMAPR_PG0_SMAG_LCK_SHIFT         (12U)
/*! SMAG_LCK
 *  0b0..The SMAG2JR register and SMAG1JR register are unlocked. The partition owner can change any writable bits of these registers.
 *  0b1..The SMAG2JR register and SMAG1JR register are locked. The SMAG2JR and SMAG1JR registers cannot be changed
 *       until the partition is de-allocated or a POR occurs.
 */
#define CAAM_PX_SMAPR_PG0_SMAG_LCK(x)            (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_PG0_SMAG_LCK_SHIFT)) & CAAM_PX_SMAPR_PG0_SMAG_LCK_MASK)

#define CAAM_PX_SMAPR_PG0_SMAP_LCK_MASK          (0x2000U)
#define CAAM_PX_SMAPR_PG0_SMAP_LCK_SHIFT         (13U)
/*! SMAP_LCK
 *  0b0..The SMAP register is unlocked. The partition owner can change any writable bits of the SMAP register.
 *  0b1..The SMAP register is locked. The SMAP_LCK, CSP and PSP bits and G1 and G2 permission bits of the SMAP
 *       register cannot be changed until the partition is de-allocated or a POR occurs. The PARTITION_KMOD value can
 *       still be changed. The SMAG_LCK bit can be changed to a 1, but cannot be changed to a 0.
 */
#define CAAM_PX_SMAPR_PG0_SMAP_LCK(x)            (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_PG0_SMAP_LCK_SHIFT)) & CAAM_PX_SMAPR_PG0_SMAP_LCK_MASK)

#define CAAM_PX_SMAPR_PG0_PSP_MASK               (0x4000U)
#define CAAM_PX_SMAPR_PG0_PSP_SHIFT              (14U)
/*! PSP
 *  0b0..The partition and any of the pages allocated to the partition can be de-allocated.
 *  0b1..The partition cannot be de-allocated and the pages allocated to the partition cannot be de-allocated.
 */
#define CAAM_PX_SMAPR_PG0_PSP(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_PG0_PSP_SHIFT)) & CAAM_PX_SMAPR_PG0_PSP_MASK)

#define CAAM_PX_SMAPR_PG0_CSP_MASK               (0x8000U)
#define CAAM_PX_SMAPR_PG0_CSP_SHIFT              (15U)
/*! CSP
 *  0b0..The pages allocated to the partition will not be zeroized when they are de-allocated or the partition is
 *       released or a security alarm occurs.
 *  0b1..The pages allocated to the partition will be zeroized when they are individually de-allocated or the
 *       partition is released or a security alarm occurs.
 */
#define CAAM_PX_SMAPR_PG0_CSP(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_PG0_CSP_SHIFT)) & CAAM_PX_SMAPR_PG0_CSP_MASK)

#define CAAM_PX_SMAPR_PG0_PARTITION_KMOD_MASK    (0xFFFF0000U)
#define CAAM_PX_SMAPR_PG0_PARTITION_KMOD_SHIFT   (16U)
#define CAAM_PX_SMAPR_PG0_PARTITION_KMOD(x)      (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_PG0_PARTITION_KMOD_SHIFT)) & CAAM_PX_SMAPR_PG0_PARTITION_KMOD_MASK)
/*! @} */

/* The count of CAAM_PX_SMAPR_PG0 */
#define CAAM_PX_SMAPR_PG0_COUNT                  (16U)

/*! @name PX_SMAG2_PG0 - Secure Memory Access Group Registers */
/*! @{ */

#define CAAM_PX_SMAG2_PG0_Gx_ID00_MASK           (0x1U)
#define CAAM_PX_SMAG2_PG0_Gx_ID00_SHIFT          (0U)
#define CAAM_PX_SMAG2_PG0_Gx_ID00(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID00_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID00_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID01_MASK           (0x2U)
#define CAAM_PX_SMAG2_PG0_Gx_ID01_SHIFT          (1U)
#define CAAM_PX_SMAG2_PG0_Gx_ID01(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID01_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID01_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID02_MASK           (0x4U)
#define CAAM_PX_SMAG2_PG0_Gx_ID02_SHIFT          (2U)
#define CAAM_PX_SMAG2_PG0_Gx_ID02(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID02_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID02_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID03_MASK           (0x8U)
#define CAAM_PX_SMAG2_PG0_Gx_ID03_SHIFT          (3U)
#define CAAM_PX_SMAG2_PG0_Gx_ID03(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID03_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID03_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID04_MASK           (0x10U)
#define CAAM_PX_SMAG2_PG0_Gx_ID04_SHIFT          (4U)
#define CAAM_PX_SMAG2_PG0_Gx_ID04(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID04_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID04_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID05_MASK           (0x20U)
#define CAAM_PX_SMAG2_PG0_Gx_ID05_SHIFT          (5U)
#define CAAM_PX_SMAG2_PG0_Gx_ID05(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID05_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID05_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID06_MASK           (0x40U)
#define CAAM_PX_SMAG2_PG0_Gx_ID06_SHIFT          (6U)
#define CAAM_PX_SMAG2_PG0_Gx_ID06(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID06_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID06_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID07_MASK           (0x80U)
#define CAAM_PX_SMAG2_PG0_Gx_ID07_SHIFT          (7U)
#define CAAM_PX_SMAG2_PG0_Gx_ID07(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID07_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID07_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID08_MASK           (0x100U)
#define CAAM_PX_SMAG2_PG0_Gx_ID08_SHIFT          (8U)
#define CAAM_PX_SMAG2_PG0_Gx_ID08(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID08_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID08_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID09_MASK           (0x200U)
#define CAAM_PX_SMAG2_PG0_Gx_ID09_SHIFT          (9U)
#define CAAM_PX_SMAG2_PG0_Gx_ID09(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID09_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID09_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID10_MASK           (0x400U)
#define CAAM_PX_SMAG2_PG0_Gx_ID10_SHIFT          (10U)
#define CAAM_PX_SMAG2_PG0_Gx_ID10(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID10_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID10_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID11_MASK           (0x800U)
#define CAAM_PX_SMAG2_PG0_Gx_ID11_SHIFT          (11U)
#define CAAM_PX_SMAG2_PG0_Gx_ID11(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID11_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID11_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID12_MASK           (0x1000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID12_SHIFT          (12U)
#define CAAM_PX_SMAG2_PG0_Gx_ID12(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID12_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID12_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID13_MASK           (0x2000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID13_SHIFT          (13U)
#define CAAM_PX_SMAG2_PG0_Gx_ID13(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID13_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID13_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID14_MASK           (0x4000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID14_SHIFT          (14U)
#define CAAM_PX_SMAG2_PG0_Gx_ID14(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID14_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID14_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID15_MASK           (0x8000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID15_SHIFT          (15U)
#define CAAM_PX_SMAG2_PG0_Gx_ID15(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID15_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID15_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID16_MASK           (0x10000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID16_SHIFT          (16U)
#define CAAM_PX_SMAG2_PG0_Gx_ID16(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID16_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID16_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID17_MASK           (0x20000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID17_SHIFT          (17U)
#define CAAM_PX_SMAG2_PG0_Gx_ID17(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID17_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID17_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID18_MASK           (0x40000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID18_SHIFT          (18U)
#define CAAM_PX_SMAG2_PG0_Gx_ID18(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID18_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID18_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID19_MASK           (0x80000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID19_SHIFT          (19U)
#define CAAM_PX_SMAG2_PG0_Gx_ID19(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID19_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID19_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID20_MASK           (0x100000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID20_SHIFT          (20U)
#define CAAM_PX_SMAG2_PG0_Gx_ID20(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID20_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID20_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID21_MASK           (0x200000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID21_SHIFT          (21U)
#define CAAM_PX_SMAG2_PG0_Gx_ID21(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID21_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID21_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID22_MASK           (0x400000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID22_SHIFT          (22U)
#define CAAM_PX_SMAG2_PG0_Gx_ID22(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID22_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID22_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID23_MASK           (0x800000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID23_SHIFT          (23U)
#define CAAM_PX_SMAG2_PG0_Gx_ID23(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID23_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID23_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID24_MASK           (0x1000000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID24_SHIFT          (24U)
#define CAAM_PX_SMAG2_PG0_Gx_ID24(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID24_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID24_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID25_MASK           (0x2000000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID25_SHIFT          (25U)
#define CAAM_PX_SMAG2_PG0_Gx_ID25(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID25_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID25_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID26_MASK           (0x4000000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID26_SHIFT          (26U)
#define CAAM_PX_SMAG2_PG0_Gx_ID26(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID26_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID26_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID27_MASK           (0x8000000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID27_SHIFT          (27U)
#define CAAM_PX_SMAG2_PG0_Gx_ID27(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID27_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID27_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID28_MASK           (0x10000000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID28_SHIFT          (28U)
#define CAAM_PX_SMAG2_PG0_Gx_ID28(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID28_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID28_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID29_MASK           (0x20000000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID29_SHIFT          (29U)
#define CAAM_PX_SMAG2_PG0_Gx_ID29(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID29_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID29_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID30_MASK           (0x40000000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID30_SHIFT          (30U)
#define CAAM_PX_SMAG2_PG0_Gx_ID30(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID30_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID30_MASK)

#define CAAM_PX_SMAG2_PG0_Gx_ID31_MASK           (0x80000000U)
#define CAAM_PX_SMAG2_PG0_Gx_ID31_SHIFT          (31U)
#define CAAM_PX_SMAG2_PG0_Gx_ID31(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_PG0_Gx_ID31_SHIFT)) & CAAM_PX_SMAG2_PG0_Gx_ID31_MASK)
/*! @} */

/* The count of CAAM_PX_SMAG2_PG0 */
#define CAAM_PX_SMAG2_PG0_COUNT                  (16U)

/*! @name PX_SMAG1_PG0 - Secure Memory Access Group Registers */
/*! @{ */

#define CAAM_PX_SMAG1_PG0_Gx_ID00_MASK           (0x1U)
#define CAAM_PX_SMAG1_PG0_Gx_ID00_SHIFT          (0U)
#define CAAM_PX_SMAG1_PG0_Gx_ID00(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID00_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID00_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID01_MASK           (0x2U)
#define CAAM_PX_SMAG1_PG0_Gx_ID01_SHIFT          (1U)
#define CAAM_PX_SMAG1_PG0_Gx_ID01(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID01_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID01_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID02_MASK           (0x4U)
#define CAAM_PX_SMAG1_PG0_Gx_ID02_SHIFT          (2U)
#define CAAM_PX_SMAG1_PG0_Gx_ID02(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID02_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID02_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID03_MASK           (0x8U)
#define CAAM_PX_SMAG1_PG0_Gx_ID03_SHIFT          (3U)
#define CAAM_PX_SMAG1_PG0_Gx_ID03(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID03_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID03_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID04_MASK           (0x10U)
#define CAAM_PX_SMAG1_PG0_Gx_ID04_SHIFT          (4U)
#define CAAM_PX_SMAG1_PG0_Gx_ID04(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID04_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID04_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID05_MASK           (0x20U)
#define CAAM_PX_SMAG1_PG0_Gx_ID05_SHIFT          (5U)
#define CAAM_PX_SMAG1_PG0_Gx_ID05(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID05_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID05_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID06_MASK           (0x40U)
#define CAAM_PX_SMAG1_PG0_Gx_ID06_SHIFT          (6U)
#define CAAM_PX_SMAG1_PG0_Gx_ID06(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID06_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID06_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID07_MASK           (0x80U)
#define CAAM_PX_SMAG1_PG0_Gx_ID07_SHIFT          (7U)
#define CAAM_PX_SMAG1_PG0_Gx_ID07(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID07_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID07_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID08_MASK           (0x100U)
#define CAAM_PX_SMAG1_PG0_Gx_ID08_SHIFT          (8U)
#define CAAM_PX_SMAG1_PG0_Gx_ID08(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID08_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID08_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID09_MASK           (0x200U)
#define CAAM_PX_SMAG1_PG0_Gx_ID09_SHIFT          (9U)
#define CAAM_PX_SMAG1_PG0_Gx_ID09(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID09_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID09_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID10_MASK           (0x400U)
#define CAAM_PX_SMAG1_PG0_Gx_ID10_SHIFT          (10U)
#define CAAM_PX_SMAG1_PG0_Gx_ID10(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID10_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID10_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID11_MASK           (0x800U)
#define CAAM_PX_SMAG1_PG0_Gx_ID11_SHIFT          (11U)
#define CAAM_PX_SMAG1_PG0_Gx_ID11(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID11_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID11_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID12_MASK           (0x1000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID12_SHIFT          (12U)
#define CAAM_PX_SMAG1_PG0_Gx_ID12(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID12_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID12_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID13_MASK           (0x2000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID13_SHIFT          (13U)
#define CAAM_PX_SMAG1_PG0_Gx_ID13(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID13_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID13_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID14_MASK           (0x4000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID14_SHIFT          (14U)
#define CAAM_PX_SMAG1_PG0_Gx_ID14(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID14_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID14_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID15_MASK           (0x8000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID15_SHIFT          (15U)
#define CAAM_PX_SMAG1_PG0_Gx_ID15(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID15_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID15_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID16_MASK           (0x10000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID16_SHIFT          (16U)
#define CAAM_PX_SMAG1_PG0_Gx_ID16(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID16_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID16_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID17_MASK           (0x20000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID17_SHIFT          (17U)
#define CAAM_PX_SMAG1_PG0_Gx_ID17(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID17_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID17_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID18_MASK           (0x40000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID18_SHIFT          (18U)
#define CAAM_PX_SMAG1_PG0_Gx_ID18(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID18_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID18_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID19_MASK           (0x80000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID19_SHIFT          (19U)
#define CAAM_PX_SMAG1_PG0_Gx_ID19(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID19_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID19_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID20_MASK           (0x100000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID20_SHIFT          (20U)
#define CAAM_PX_SMAG1_PG0_Gx_ID20(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID20_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID20_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID21_MASK           (0x200000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID21_SHIFT          (21U)
#define CAAM_PX_SMAG1_PG0_Gx_ID21(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID21_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID21_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID22_MASK           (0x400000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID22_SHIFT          (22U)
#define CAAM_PX_SMAG1_PG0_Gx_ID22(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID22_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID22_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID23_MASK           (0x800000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID23_SHIFT          (23U)
#define CAAM_PX_SMAG1_PG0_Gx_ID23(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID23_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID23_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID24_MASK           (0x1000000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID24_SHIFT          (24U)
#define CAAM_PX_SMAG1_PG0_Gx_ID24(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID24_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID24_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID25_MASK           (0x2000000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID25_SHIFT          (25U)
#define CAAM_PX_SMAG1_PG0_Gx_ID25(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID25_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID25_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID26_MASK           (0x4000000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID26_SHIFT          (26U)
#define CAAM_PX_SMAG1_PG0_Gx_ID26(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID26_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID26_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID27_MASK           (0x8000000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID27_SHIFT          (27U)
#define CAAM_PX_SMAG1_PG0_Gx_ID27(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID27_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID27_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID28_MASK           (0x10000000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID28_SHIFT          (28U)
#define CAAM_PX_SMAG1_PG0_Gx_ID28(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID28_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID28_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID29_MASK           (0x20000000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID29_SHIFT          (29U)
#define CAAM_PX_SMAG1_PG0_Gx_ID29(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID29_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID29_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID30_MASK           (0x40000000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID30_SHIFT          (30U)
#define CAAM_PX_SMAG1_PG0_Gx_ID30(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID30_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID30_MASK)

#define CAAM_PX_SMAG1_PG0_Gx_ID31_MASK           (0x80000000U)
#define CAAM_PX_SMAG1_PG0_Gx_ID31_SHIFT          (31U)
#define CAAM_PX_SMAG1_PG0_Gx_ID31(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_PG0_Gx_ID31_SHIFT)) & CAAM_PX_SMAG1_PG0_Gx_ID31_MASK)
/*! @} */

/* The count of CAAM_PX_SMAG1_PG0 */
#define CAAM_PX_SMAG1_PG0_COUNT                  (16U)

/*! @name REIS - Recoverable Error Interrupt Status */
/*! @{ */

#define CAAM_REIS_CWDE_MASK                      (0x1U)
#define CAAM_REIS_CWDE_SHIFT                     (0U)
#define CAAM_REIS_CWDE(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_REIS_CWDE_SHIFT)) & CAAM_REIS_CWDE_MASK)

#define CAAM_REIS_RBAE_MASK                      (0x10000U)
#define CAAM_REIS_RBAE_SHIFT                     (16U)
#define CAAM_REIS_RBAE(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_REIS_RBAE_SHIFT)) & CAAM_REIS_RBAE_MASK)

#define CAAM_REIS_JBAE0_MASK                     (0x1000000U)
#define CAAM_REIS_JBAE0_SHIFT                    (24U)
#define CAAM_REIS_JBAE0(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIS_JBAE0_SHIFT)) & CAAM_REIS_JBAE0_MASK)

#define CAAM_REIS_JBAE1_MASK                     (0x2000000U)
#define CAAM_REIS_JBAE1_SHIFT                    (25U)
#define CAAM_REIS_JBAE1(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIS_JBAE1_SHIFT)) & CAAM_REIS_JBAE1_MASK)

#define CAAM_REIS_JBAE2_MASK                     (0x4000000U)
#define CAAM_REIS_JBAE2_SHIFT                    (26U)
#define CAAM_REIS_JBAE2(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIS_JBAE2_SHIFT)) & CAAM_REIS_JBAE2_MASK)

#define CAAM_REIS_JBAE3_MASK                     (0x8000000U)
#define CAAM_REIS_JBAE3_SHIFT                    (27U)
#define CAAM_REIS_JBAE3(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIS_JBAE3_SHIFT)) & CAAM_REIS_JBAE3_MASK)
/*! @} */

/*! @name REIE - Recoverable Error Interrupt Enable */
/*! @{ */

#define CAAM_REIE_CWDE_MASK                      (0x1U)
#define CAAM_REIE_CWDE_SHIFT                     (0U)
#define CAAM_REIE_CWDE(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_REIE_CWDE_SHIFT)) & CAAM_REIE_CWDE_MASK)

#define CAAM_REIE_RBAE_MASK                      (0x10000U)
#define CAAM_REIE_RBAE_SHIFT                     (16U)
#define CAAM_REIE_RBAE(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_REIE_RBAE_SHIFT)) & CAAM_REIE_RBAE_MASK)

#define CAAM_REIE_JBAE0_MASK                     (0x1000000U)
#define CAAM_REIE_JBAE0_SHIFT                    (24U)
#define CAAM_REIE_JBAE0(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIE_JBAE0_SHIFT)) & CAAM_REIE_JBAE0_MASK)

#define CAAM_REIE_JBAE1_MASK                     (0x2000000U)
#define CAAM_REIE_JBAE1_SHIFT                    (25U)
#define CAAM_REIE_JBAE1(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIE_JBAE1_SHIFT)) & CAAM_REIE_JBAE1_MASK)

#define CAAM_REIE_JBAE2_MASK                     (0x4000000U)
#define CAAM_REIE_JBAE2_SHIFT                    (26U)
#define CAAM_REIE_JBAE2(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIE_JBAE2_SHIFT)) & CAAM_REIE_JBAE2_MASK)

#define CAAM_REIE_JBAE3_MASK                     (0x8000000U)
#define CAAM_REIE_JBAE3_SHIFT                    (27U)
#define CAAM_REIE_JBAE3(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIE_JBAE3_SHIFT)) & CAAM_REIE_JBAE3_MASK)
/*! @} */

/*! @name REIF - Recoverable Error Interrupt Force */
/*! @{ */

#define CAAM_REIF_CWDE_MASK                      (0x1U)
#define CAAM_REIF_CWDE_SHIFT                     (0U)
#define CAAM_REIF_CWDE(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_REIF_CWDE_SHIFT)) & CAAM_REIF_CWDE_MASK)

#define CAAM_REIF_RBAE_MASK                      (0x10000U)
#define CAAM_REIF_RBAE_SHIFT                     (16U)
#define CAAM_REIF_RBAE(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_REIF_RBAE_SHIFT)) & CAAM_REIF_RBAE_MASK)

#define CAAM_REIF_JBAE0_MASK                     (0x1000000U)
#define CAAM_REIF_JBAE0_SHIFT                    (24U)
#define CAAM_REIF_JBAE0(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIF_JBAE0_SHIFT)) & CAAM_REIF_JBAE0_MASK)

#define CAAM_REIF_JBAE1_MASK                     (0x2000000U)
#define CAAM_REIF_JBAE1_SHIFT                    (25U)
#define CAAM_REIF_JBAE1(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIF_JBAE1_SHIFT)) & CAAM_REIF_JBAE1_MASK)

#define CAAM_REIF_JBAE2_MASK                     (0x4000000U)
#define CAAM_REIF_JBAE2_SHIFT                    (26U)
#define CAAM_REIF_JBAE2(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIF_JBAE2_SHIFT)) & CAAM_REIF_JBAE2_MASK)

#define CAAM_REIF_JBAE3_MASK                     (0x8000000U)
#define CAAM_REIF_JBAE3_SHIFT                    (27U)
#define CAAM_REIF_JBAE3(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIF_JBAE3_SHIFT)) & CAAM_REIF_JBAE3_MASK)
/*! @} */

/*! @name REIH - Recoverable Error Interrupt Halt */
/*! @{ */

#define CAAM_REIH_CWDE_MASK                      (0x1U)
#define CAAM_REIH_CWDE_SHIFT                     (0U)
/*! CWDE
 *  0b0..Don't halt CAAM if CAAM watchdog expired.
 *  0b1..Halt CAAM if CAAM watchdog expired..
 */
#define CAAM_REIH_CWDE(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_REIH_CWDE_SHIFT)) & CAAM_REIH_CWDE_MASK)

#define CAAM_REIH_RBAE_MASK                      (0x10000U)
#define CAAM_REIH_RBAE_SHIFT                     (16U)
/*! RBAE
 *  0b0..Don't halt CAAM if RTIC-initiated job execution caused bus access error.
 *  0b1..Halt CAAM if RTIC-initiated job execution caused bus access error.
 */
#define CAAM_REIH_RBAE(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_REIH_RBAE_SHIFT)) & CAAM_REIH_RBAE_MASK)

#define CAAM_REIH_JBAE0_MASK                     (0x1000000U)
#define CAAM_REIH_JBAE0_SHIFT                    (24U)
/*! JBAE0
 *  0b0..Don't halt CAAM if JR0-initiated job execution caused bus access error.
 *  0b1..Halt CAAM if JR0-initiated job execution caused bus access error.
 */
#define CAAM_REIH_JBAE0(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIH_JBAE0_SHIFT)) & CAAM_REIH_JBAE0_MASK)

#define CAAM_REIH_JBAE1_MASK                     (0x2000000U)
#define CAAM_REIH_JBAE1_SHIFT                    (25U)
/*! JBAE1
 *  0b0..Don't halt CAAM if JR1-initiated job execution caused bus access error.
 *  0b1..Halt CAAM if JR1-initiated job execution caused bus access error.
 */
#define CAAM_REIH_JBAE1(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIH_JBAE1_SHIFT)) & CAAM_REIH_JBAE1_MASK)

#define CAAM_REIH_JBAE2_MASK                     (0x4000000U)
#define CAAM_REIH_JBAE2_SHIFT                    (26U)
/*! JBAE2
 *  0b0..Don't halt CAAM if JR2-initiated job execution caused bus access error.
 *  0b1..Halt CAAM if JR2-initiated job execution caused bus access error.
 */
#define CAAM_REIH_JBAE2(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIH_JBAE2_SHIFT)) & CAAM_REIH_JBAE2_MASK)

#define CAAM_REIH_JBAE3_MASK                     (0x8000000U)
#define CAAM_REIH_JBAE3_SHIFT                    (27U)
/*! JBAE3
 *  0b0..Don't halt CAAM if JR3-initiated job execution caused bus access error.
 *  0b1..Halt CAAM if JR3-initiated job execution caused bus access error.
 */
#define CAAM_REIH_JBAE3(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_REIH_JBAE3_SHIFT)) & CAAM_REIH_JBAE3_MASK)
/*! @} */

/*! @name SMWPJRR - Secure Memory Write Protect Job Ring Register */
/*! @{ */

#define CAAM_SMWPJRR_SMR_WP_JRa_MASK             (0x1U)
#define CAAM_SMWPJRR_SMR_WP_JRa_SHIFT            (0U)
#define CAAM_SMWPJRR_SMR_WP_JRa(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_SMWPJRR_SMR_WP_JRa_SHIFT)) & CAAM_SMWPJRR_SMR_WP_JRa_MASK)
/*! @} */

/* The count of CAAM_SMWPJRR */
#define CAAM_SMWPJRR_COUNT                       (4U)

/*! @name SMCR_PG0 - Secure Memory Command Register */
/*! @{ */

#define CAAM_SMCR_PG0_CMD_MASK                   (0xFU)
#define CAAM_SMCR_PG0_CMD_SHIFT                  (0U)
#define CAAM_SMCR_PG0_CMD(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_SMCR_PG0_CMD_SHIFT)) & CAAM_SMCR_PG0_CMD_MASK)

#define CAAM_SMCR_PG0_PRTN_MASK                  (0xF00U)
#define CAAM_SMCR_PG0_PRTN_SHIFT                 (8U)
#define CAAM_SMCR_PG0_PRTN(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_SMCR_PG0_PRTN_SHIFT)) & CAAM_SMCR_PG0_PRTN_MASK)

#define CAAM_SMCR_PG0_PAGE_MASK                  (0xFFFF0000U)
#define CAAM_SMCR_PG0_PAGE_SHIFT                 (16U)
#define CAAM_SMCR_PG0_PAGE(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_SMCR_PG0_PAGE_SHIFT)) & CAAM_SMCR_PG0_PAGE_MASK)
/*! @} */

/*! @name SMCSR_PG0 - Secure Memory Command Status Register */
/*! @{ */

#define CAAM_SMCSR_PG0_PRTN_MASK                 (0xFU)
#define CAAM_SMCSR_PG0_PRTN_SHIFT                (0U)
#define CAAM_SMCSR_PG0_PRTN(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_SMCSR_PG0_PRTN_SHIFT)) & CAAM_SMCSR_PG0_PRTN_MASK)

#define CAAM_SMCSR_PG0_PO_MASK                   (0xC0U)
#define CAAM_SMCSR_PG0_PO_SHIFT                  (6U)
/*! PO
 *  0b00..Available; Unowned: The entity that issued the inquiry may allocate this page to a partition. No
 *        zeroization is needed since it has already been cleared, therefore no interrupt should be expected.
 *  0b01..Page does not exist in this version or is not initialized yet.
 *  0b10..Another entity owns the page. This page is unavailable to the issuer of the inquiry.
 *  0b11..Owned by the entity making the inquiry. The owner may de-allocate this page if its partition is not
 *        marked PSP. If the partition to which the page is allocated is designated as CSP, the page will be zeroized
 *        upon de-allocation.
 */
#define CAAM_SMCSR_PG0_PO(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_SMCSR_PG0_PO_SHIFT)) & CAAM_SMCSR_PG0_PO_MASK)

#define CAAM_SMCSR_PG0_AERR_MASK                 (0x3000U)
#define CAAM_SMCSR_PG0_AERR_SHIFT                (12U)
#define CAAM_SMCSR_PG0_AERR(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_SMCSR_PG0_AERR_SHIFT)) & CAAM_SMCSR_PG0_AERR_MASK)

#define CAAM_SMCSR_PG0_CERR_MASK                 (0xC000U)
#define CAAM_SMCSR_PG0_CERR_SHIFT                (14U)
/*! CERR
 *  0b00..No Error.
 *  0b01..Command has not yet completed.
 *  0b10..A security failure occurred.
 *  0b11..Command Overflow. Another command was issued by the same Job Ring owner before the owner's previous
 *        command completed. The additional command was ignored.
 */
#define CAAM_SMCSR_PG0_CERR(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_SMCSR_PG0_CERR_SHIFT)) & CAAM_SMCSR_PG0_CERR_MASK)

#define CAAM_SMCSR_PG0_PAGE_MASK                 (0xFFF0000U)
#define CAAM_SMCSR_PG0_PAGE_SHIFT                (16U)
#define CAAM_SMCSR_PG0_PAGE(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_SMCSR_PG0_PAGE_SHIFT)) & CAAM_SMCSR_PG0_PAGE_MASK)
/*! @} */

/*! @name CAAMVID_MS_TRAD - CAAM Version ID Register, most-significant half */
/*! @{ */

#define CAAM_CAAMVID_MS_TRAD_MIN_REV_MASK        (0xFFU)
#define CAAM_CAAMVID_MS_TRAD_MIN_REV_SHIFT       (0U)
#define CAAM_CAAMVID_MS_TRAD_MIN_REV(x)          (((uint32_t)(((uint32_t)(x)) << CAAM_CAAMVID_MS_TRAD_MIN_REV_SHIFT)) & CAAM_CAAMVID_MS_TRAD_MIN_REV_MASK)

#define CAAM_CAAMVID_MS_TRAD_MAJ_REV_MASK        (0xFF00U)
#define CAAM_CAAMVID_MS_TRAD_MAJ_REV_SHIFT       (8U)
#define CAAM_CAAMVID_MS_TRAD_MAJ_REV(x)          (((uint32_t)(((uint32_t)(x)) << CAAM_CAAMVID_MS_TRAD_MAJ_REV_SHIFT)) & CAAM_CAAMVID_MS_TRAD_MAJ_REV_MASK)

#define CAAM_CAAMVID_MS_TRAD_IP_ID_MASK          (0xFFFF0000U)
#define CAAM_CAAMVID_MS_TRAD_IP_ID_SHIFT         (16U)
#define CAAM_CAAMVID_MS_TRAD_IP_ID(x)            (((uint32_t)(((uint32_t)(x)) << CAAM_CAAMVID_MS_TRAD_IP_ID_SHIFT)) & CAAM_CAAMVID_MS_TRAD_IP_ID_MASK)
/*! @} */

/*! @name CAAMVID_LS_TRAD - CAAM Version ID Register, least-significant half */
/*! @{ */

#define CAAM_CAAMVID_LS_TRAD_CONFIG_OPT_MASK     (0xFFU)
#define CAAM_CAAMVID_LS_TRAD_CONFIG_OPT_SHIFT    (0U)
#define CAAM_CAAMVID_LS_TRAD_CONFIG_OPT(x)       (((uint32_t)(((uint32_t)(x)) << CAAM_CAAMVID_LS_TRAD_CONFIG_OPT_SHIFT)) & CAAM_CAAMVID_LS_TRAD_CONFIG_OPT_MASK)

#define CAAM_CAAMVID_LS_TRAD_ECO_REV_MASK        (0xFF00U)
#define CAAM_CAAMVID_LS_TRAD_ECO_REV_SHIFT       (8U)
#define CAAM_CAAMVID_LS_TRAD_ECO_REV(x)          (((uint32_t)(((uint32_t)(x)) << CAAM_CAAMVID_LS_TRAD_ECO_REV_SHIFT)) & CAAM_CAAMVID_LS_TRAD_ECO_REV_MASK)

#define CAAM_CAAMVID_LS_TRAD_INTG_OPT_MASK       (0xFF0000U)
#define CAAM_CAAMVID_LS_TRAD_INTG_OPT_SHIFT      (16U)
#define CAAM_CAAMVID_LS_TRAD_INTG_OPT(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_CAAMVID_LS_TRAD_INTG_OPT_SHIFT)) & CAAM_CAAMVID_LS_TRAD_INTG_OPT_MASK)

#define CAAM_CAAMVID_LS_TRAD_COMPILE_OPT_MASK    (0xFF000000U)
#define CAAM_CAAMVID_LS_TRAD_COMPILE_OPT_SHIFT   (24U)
#define CAAM_CAAMVID_LS_TRAD_COMPILE_OPT(x)      (((uint32_t)(((uint32_t)(x)) << CAAM_CAAMVID_LS_TRAD_COMPILE_OPT_SHIFT)) & CAAM_CAAMVID_LS_TRAD_COMPILE_OPT_MASK)
/*! @} */

/*! @name HT_JD_ADDR - Holding Tank 0 Job Descriptor Address */
/*! @{ */

#define CAAM_HT_JD_ADDR_JD_ADDR_MASK             (0xFFFFFFFFFU)
#define CAAM_HT_JD_ADDR_JD_ADDR_SHIFT            (0U)
#define CAAM_HT_JD_ADDR_JD_ADDR(x)               (((uint64_t)(((uint64_t)(x)) << CAAM_HT_JD_ADDR_JD_ADDR_SHIFT)) & CAAM_HT_JD_ADDR_JD_ADDR_MASK)
/*! @} */

/* The count of CAAM_HT_JD_ADDR */
#define CAAM_HT_JD_ADDR_COUNT                    (1U)

/*! @name HT_SD_ADDR - Holding Tank 0 Shared Descriptor Address */
/*! @{ */

#define CAAM_HT_SD_ADDR_SD_ADDR_MASK             (0xFFFFFFFFFU)
#define CAAM_HT_SD_ADDR_SD_ADDR_SHIFT            (0U)
#define CAAM_HT_SD_ADDR_SD_ADDR(x)               (((uint64_t)(((uint64_t)(x)) << CAAM_HT_SD_ADDR_SD_ADDR_SHIFT)) & CAAM_HT_SD_ADDR_SD_ADDR_MASK)
/*! @} */

/* The count of CAAM_HT_SD_ADDR */
#define CAAM_HT_SD_ADDR_COUNT                    (1U)

/*! @name HT_JQ_CTRL_MS - Holding Tank 0 Job Queue Control, most-significant half */
/*! @{ */

#define CAAM_HT_JQ_CTRL_MS_ID_MASK               (0x7U)
#define CAAM_HT_JQ_CTRL_MS_ID_SHIFT              (0U)
#define CAAM_HT_JQ_CTRL_MS_ID(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_MS_ID_SHIFT)) & CAAM_HT_JQ_CTRL_MS_ID_MASK)

#define CAAM_HT_JQ_CTRL_MS_SRC_MASK              (0x700U)
#define CAAM_HT_JQ_CTRL_MS_SRC_SHIFT             (8U)
/*! SRC
 *  0b000..Job Ring 0
 *  0b001..Job Ring 1
 *  0b010..Job Ring 2
 *  0b011..Job Ring 3
 *  0b100..RTIC
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define CAAM_HT_JQ_CTRL_MS_SRC(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_MS_SRC_SHIFT)) & CAAM_HT_JQ_CTRL_MS_SRC_MASK)

#define CAAM_HT_JQ_CTRL_MS_JDDS_MASK             (0x4000U)
#define CAAM_HT_JQ_CTRL_MS_JDDS_SHIFT            (14U)
/*! JDDS
 *  0b1..SEQ DID
 *  0b0..Non-SEQ DID
 */
#define CAAM_HT_JQ_CTRL_MS_JDDS(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_MS_JDDS_SHIFT)) & CAAM_HT_JQ_CTRL_MS_JDDS_MASK)

#define CAAM_HT_JQ_CTRL_MS_AMTD_MASK             (0x8000U)
#define CAAM_HT_JQ_CTRL_MS_AMTD_SHIFT            (15U)
#define CAAM_HT_JQ_CTRL_MS_AMTD(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_MS_AMTD_SHIFT)) & CAAM_HT_JQ_CTRL_MS_AMTD_MASK)

#define CAAM_HT_JQ_CTRL_MS_SOB_MASK              (0x10000U)
#define CAAM_HT_JQ_CTRL_MS_SOB_SHIFT             (16U)
#define CAAM_HT_JQ_CTRL_MS_SOB(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_MS_SOB_SHIFT)) & CAAM_HT_JQ_CTRL_MS_SOB_MASK)

#define CAAM_HT_JQ_CTRL_MS_HT_ERROR_MASK         (0x60000U)
#define CAAM_HT_JQ_CTRL_MS_HT_ERROR_SHIFT        (17U)
/*! HT_ERROR
 *  0b00..No error
 *  0b01..Job Descriptor or Shared Descriptor length error
 *  0b10..AXI_error while reading a Job Ring Shared Descriptor or the remainder of a Job Ring Job Descriptor
 *  0b11..reserved
 */
#define CAAM_HT_JQ_CTRL_MS_HT_ERROR(x)           (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_MS_HT_ERROR_SHIFT)) & CAAM_HT_JQ_CTRL_MS_HT_ERROR_MASK)

#define CAAM_HT_JQ_CTRL_MS_DWORD_SWAP_MASK       (0x80000U)
#define CAAM_HT_JQ_CTRL_MS_DWORD_SWAP_SHIFT      (19U)
/*! DWORD_SWAP
 *  0b0..DWords are in the order most-significant word, least-significant word.
 *  0b1..DWords are in the order least-significant word, most-significant word.
 */
#define CAAM_HT_JQ_CTRL_MS_DWORD_SWAP(x)         (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_MS_DWORD_SWAP_SHIFT)) & CAAM_HT_JQ_CTRL_MS_DWORD_SWAP_MASK)

#define CAAM_HT_JQ_CTRL_MS_SHR_FROM_MASK         (0x7C00000U)
#define CAAM_HT_JQ_CTRL_MS_SHR_FROM_SHIFT        (22U)
#define CAAM_HT_JQ_CTRL_MS_SHR_FROM(x)           (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_MS_SHR_FROM_SHIFT)) & CAAM_HT_JQ_CTRL_MS_SHR_FROM_MASK)

#define CAAM_HT_JQ_CTRL_MS_ILE_MASK              (0x8000000U)
#define CAAM_HT_JQ_CTRL_MS_ILE_SHIFT             (27U)
/*! ILE
 *  0b0..No byte-swapping is performed for immediate data transferred to or from the Descriptor Buffer.
 *  0b1..Byte-swapping is performed for immediate data transferred to or from the Descriptor Buffer.
 */
#define CAAM_HT_JQ_CTRL_MS_ILE(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_MS_ILE_SHIFT)) & CAAM_HT_JQ_CTRL_MS_ILE_MASK)

#define CAAM_HT_JQ_CTRL_MS_FOUR_MASK             (0x10000000U)
#define CAAM_HT_JQ_CTRL_MS_FOUR_SHIFT            (28U)
#define CAAM_HT_JQ_CTRL_MS_FOUR(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_MS_FOUR_SHIFT)) & CAAM_HT_JQ_CTRL_MS_FOUR_MASK)

#define CAAM_HT_JQ_CTRL_MS_WHL_MASK              (0x20000000U)
#define CAAM_HT_JQ_CTRL_MS_WHL_SHIFT             (29U)
#define CAAM_HT_JQ_CTRL_MS_WHL(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_MS_WHL_SHIFT)) & CAAM_HT_JQ_CTRL_MS_WHL_MASK)
/*! @} */

/* The count of CAAM_HT_JQ_CTRL_MS */
#define CAAM_HT_JQ_CTRL_MS_COUNT                 (1U)

/*! @name HT_JQ_CTRL_LS - Holding Tank 0 Job Queue Control, least-significant half */
/*! @{ */

#define CAAM_HT_JQ_CTRL_LS_PRIM_DID_MASK         (0xFU)
#define CAAM_HT_JQ_CTRL_LS_PRIM_DID_SHIFT        (0U)
#define CAAM_HT_JQ_CTRL_LS_PRIM_DID(x)           (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_LS_PRIM_DID_SHIFT)) & CAAM_HT_JQ_CTRL_LS_PRIM_DID_MASK)

#define CAAM_HT_JQ_CTRL_LS_PRIM_TZ_MASK          (0x10U)
#define CAAM_HT_JQ_CTRL_LS_PRIM_TZ_SHIFT         (4U)
/*! PRIM_TZ
 *  0b0..TrustZone NonSecureWorld
 *  0b1..TrustZone SecureWorld
 */
#define CAAM_HT_JQ_CTRL_LS_PRIM_TZ(x)            (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_LS_PRIM_TZ_SHIFT)) & CAAM_HT_JQ_CTRL_LS_PRIM_TZ_MASK)

#define CAAM_HT_JQ_CTRL_LS_PRIM_ICID_MASK        (0xFFE0U)
#define CAAM_HT_JQ_CTRL_LS_PRIM_ICID_SHIFT       (5U)
#define CAAM_HT_JQ_CTRL_LS_PRIM_ICID(x)          (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_LS_PRIM_ICID_SHIFT)) & CAAM_HT_JQ_CTRL_LS_PRIM_ICID_MASK)

#define CAAM_HT_JQ_CTRL_LS_OUT_DID_MASK          (0xF0000U)
#define CAAM_HT_JQ_CTRL_LS_OUT_DID_SHIFT         (16U)
#define CAAM_HT_JQ_CTRL_LS_OUT_DID(x)            (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_LS_OUT_DID_SHIFT)) & CAAM_HT_JQ_CTRL_LS_OUT_DID_MASK)

#define CAAM_HT_JQ_CTRL_LS_OUT_ICID_MASK         (0xFFE00000U)
#define CAAM_HT_JQ_CTRL_LS_OUT_ICID_SHIFT        (21U)
#define CAAM_HT_JQ_CTRL_LS_OUT_ICID(x)           (((uint32_t)(((uint32_t)(x)) << CAAM_HT_JQ_CTRL_LS_OUT_ICID_SHIFT)) & CAAM_HT_JQ_CTRL_LS_OUT_ICID_MASK)
/*! @} */

/* The count of CAAM_HT_JQ_CTRL_LS */
#define CAAM_HT_JQ_CTRL_LS_COUNT                 (1U)

/*! @name HT_STATUS - Holding Tank Status */
/*! @{ */

#define CAAM_HT_STATUS_PEND_0_MASK               (0x1U)
#define CAAM_HT_STATUS_PEND_0_SHIFT              (0U)
#define CAAM_HT_STATUS_PEND_0(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_HT_STATUS_PEND_0_SHIFT)) & CAAM_HT_STATUS_PEND_0_MASK)

#define CAAM_HT_STATUS_IN_USE_MASK               (0x40000000U)
#define CAAM_HT_STATUS_IN_USE_SHIFT              (30U)
#define CAAM_HT_STATUS_IN_USE(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_HT_STATUS_IN_USE_SHIFT)) & CAAM_HT_STATUS_IN_USE_MASK)

#define CAAM_HT_STATUS_BC_MASK                   (0x80000000U)
#define CAAM_HT_STATUS_BC_SHIFT                  (31U)
#define CAAM_HT_STATUS_BC(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_HT_STATUS_BC_SHIFT)) & CAAM_HT_STATUS_BC_MASK)
/*! @} */

/* The count of CAAM_HT_STATUS */
#define CAAM_HT_STATUS_COUNT                     (1U)

/*! @name JQ_DEBUG_SEL - Job Queue Debug Select Register */
/*! @{ */

#define CAAM_JQ_DEBUG_SEL_HT_SEL_MASK            (0x1U)
#define CAAM_JQ_DEBUG_SEL_HT_SEL_SHIFT           (0U)
#define CAAM_JQ_DEBUG_SEL_HT_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_JQ_DEBUG_SEL_HT_SEL_SHIFT)) & CAAM_JQ_DEBUG_SEL_HT_SEL_MASK)

#define CAAM_JQ_DEBUG_SEL_JOB_ID_MASK            (0x70000U)
#define CAAM_JQ_DEBUG_SEL_JOB_ID_SHIFT           (16U)
#define CAAM_JQ_DEBUG_SEL_JOB_ID(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_JQ_DEBUG_SEL_JOB_ID_SHIFT)) & CAAM_JQ_DEBUG_SEL_JOB_ID_MASK)
/*! @} */

/*! @name JRJIDU_LS - Job Ring Job IDs in Use Register, least-significant half */
/*! @{ */

#define CAAM_JRJIDU_LS_JID00_MASK                (0x1U)
#define CAAM_JRJIDU_LS_JID00_SHIFT               (0U)
#define CAAM_JRJIDU_LS_JID00(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_JRJIDU_LS_JID00_SHIFT)) & CAAM_JRJIDU_LS_JID00_MASK)

#define CAAM_JRJIDU_LS_JID01_MASK                (0x2U)
#define CAAM_JRJIDU_LS_JID01_SHIFT               (1U)
#define CAAM_JRJIDU_LS_JID01(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_JRJIDU_LS_JID01_SHIFT)) & CAAM_JRJIDU_LS_JID01_MASK)

#define CAAM_JRJIDU_LS_JID02_MASK                (0x4U)
#define CAAM_JRJIDU_LS_JID02_SHIFT               (2U)
#define CAAM_JRJIDU_LS_JID02(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_JRJIDU_LS_JID02_SHIFT)) & CAAM_JRJIDU_LS_JID02_MASK)

#define CAAM_JRJIDU_LS_JID03_MASK                (0x8U)
#define CAAM_JRJIDU_LS_JID03_SHIFT               (3U)
#define CAAM_JRJIDU_LS_JID03(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_JRJIDU_LS_JID03_SHIFT)) & CAAM_JRJIDU_LS_JID03_MASK)
/*! @} */

/*! @name JRJDJIFBC - Job Ring Job-Done Job ID FIFO BC */
/*! @{ */

#define CAAM_JRJDJIFBC_BC_MASK                   (0x80000000U)
#define CAAM_JRJDJIFBC_BC_SHIFT                  (31U)
#define CAAM_JRJDJIFBC_BC(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_JRJDJIFBC_BC_SHIFT)) & CAAM_JRJDJIFBC_BC_MASK)
/*! @} */

/*! @name JRJDJIF - Job Ring Job-Done Job ID FIFO */
/*! @{ */

#define CAAM_JRJDJIF_JOB_ID_ENTRY_MASK           (0x7U)
#define CAAM_JRJDJIF_JOB_ID_ENTRY_SHIFT          (0U)
#define CAAM_JRJDJIF_JOB_ID_ENTRY(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_JRJDJIF_JOB_ID_ENTRY_SHIFT)) & CAAM_JRJDJIF_JOB_ID_ENTRY_MASK)
/*! @} */

/*! @name JRJDS1 - Job Ring Job-Done Source 1 */
/*! @{ */

#define CAAM_JRJDS1_SRC_MASK                     (0x3U)
#define CAAM_JRJDS1_SRC_SHIFT                    (0U)
#define CAAM_JRJDS1_SRC(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_JRJDS1_SRC_SHIFT)) & CAAM_JRJDS1_SRC_MASK)

#define CAAM_JRJDS1_VALID_MASK                   (0x80000000U)
#define CAAM_JRJDS1_VALID_SHIFT                  (31U)
#define CAAM_JRJDS1_VALID(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_JRJDS1_VALID_SHIFT)) & CAAM_JRJDS1_VALID_MASK)
/*! @} */

/*! @name JRJDDA - Job Ring Job-Done Descriptor Address 0 Register */
/*! @{ */

#define CAAM_JRJDDA_JD_ADDR_MASK                 (0xFFFFFFFFFU)
#define CAAM_JRJDDA_JD_ADDR_SHIFT                (0U)
#define CAAM_JRJDDA_JD_ADDR(x)                   (((uint64_t)(((uint64_t)(x)) << CAAM_JRJDDA_JD_ADDR_SHIFT)) & CAAM_JRJDDA_JD_ADDR_MASK)
/*! @} */

/* The count of CAAM_JRJDDA */
#define CAAM_JRJDDA_COUNT                        (1U)

/*! @name CRNR_MS - CHA Revision Number Register, most-significant half */
/*! @{ */

#define CAAM_CRNR_MS_CRCRN_MASK                  (0xFU)
#define CAAM_CRNR_MS_CRCRN_SHIFT                 (0U)
#define CAAM_CRNR_MS_CRCRN(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CRNR_MS_CRCRN_SHIFT)) & CAAM_CRNR_MS_CRCRN_MASK)

#define CAAM_CRNR_MS_SNW9RN_MASK                 (0xF0U)
#define CAAM_CRNR_MS_SNW9RN_SHIFT                (4U)
#define CAAM_CRNR_MS_SNW9RN(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_CRNR_MS_SNW9RN_SHIFT)) & CAAM_CRNR_MS_SNW9RN_MASK)

#define CAAM_CRNR_MS_ZERN_MASK                   (0xF00U)
#define CAAM_CRNR_MS_ZERN_SHIFT                  (8U)
#define CAAM_CRNR_MS_ZERN(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CRNR_MS_ZERN_SHIFT)) & CAAM_CRNR_MS_ZERN_MASK)

#define CAAM_CRNR_MS_ZARN_MASK                   (0xF000U)
#define CAAM_CRNR_MS_ZARN_SHIFT                  (12U)
#define CAAM_CRNR_MS_ZARN(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CRNR_MS_ZARN_SHIFT)) & CAAM_CRNR_MS_ZARN_MASK)

#define CAAM_CRNR_MS_DECORN_MASK                 (0xF000000U)
#define CAAM_CRNR_MS_DECORN_SHIFT                (24U)
#define CAAM_CRNR_MS_DECORN(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_CRNR_MS_DECORN_SHIFT)) & CAAM_CRNR_MS_DECORN_MASK)

#define CAAM_CRNR_MS_JRRN_MASK                   (0xF0000000U)
#define CAAM_CRNR_MS_JRRN_SHIFT                  (28U)
#define CAAM_CRNR_MS_JRRN(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CRNR_MS_JRRN_SHIFT)) & CAAM_CRNR_MS_JRRN_MASK)
/*! @} */

/*! @name CRNR_LS - CHA Revision Number Register, least-significant half */
/*! @{ */

#define CAAM_CRNR_LS_AESRN_MASK                  (0xFU)
#define CAAM_CRNR_LS_AESRN_SHIFT                 (0U)
#define CAAM_CRNR_LS_AESRN(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CRNR_LS_AESRN_SHIFT)) & CAAM_CRNR_LS_AESRN_MASK)

#define CAAM_CRNR_LS_DESRN_MASK                  (0xF0U)
#define CAAM_CRNR_LS_DESRN_SHIFT                 (4U)
#define CAAM_CRNR_LS_DESRN(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CRNR_LS_DESRN_SHIFT)) & CAAM_CRNR_LS_DESRN_MASK)

#define CAAM_CRNR_LS_MDRN_MASK                   (0xF000U)
#define CAAM_CRNR_LS_MDRN_SHIFT                  (12U)
#define CAAM_CRNR_LS_MDRN(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CRNR_LS_MDRN_SHIFT)) & CAAM_CRNR_LS_MDRN_MASK)

#define CAAM_CRNR_LS_RNGRN_MASK                  (0xF0000U)
#define CAAM_CRNR_LS_RNGRN_SHIFT                 (16U)
#define CAAM_CRNR_LS_RNGRN(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CRNR_LS_RNGRN_SHIFT)) & CAAM_CRNR_LS_RNGRN_MASK)

#define CAAM_CRNR_LS_SNW8RN_MASK                 (0xF00000U)
#define CAAM_CRNR_LS_SNW8RN_SHIFT                (20U)
#define CAAM_CRNR_LS_SNW8RN(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_CRNR_LS_SNW8RN_SHIFT)) & CAAM_CRNR_LS_SNW8RN_MASK)

#define CAAM_CRNR_LS_KASRN_MASK                  (0xF000000U)
#define CAAM_CRNR_LS_KASRN_SHIFT                 (24U)
#define CAAM_CRNR_LS_KASRN(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CRNR_LS_KASRN_SHIFT)) & CAAM_CRNR_LS_KASRN_MASK)

#define CAAM_CRNR_LS_PKRN_MASK                   (0xF0000000U)
#define CAAM_CRNR_LS_PKRN_SHIFT                  (28U)
/*! PKRN
 *  0b0000..PKHA-SDv1
 *  0b0001..PKHA-SDv2
 *  0b0010..PKHA-SDv3
 *  0b0011..PKHA-SDv4
 */
#define CAAM_CRNR_LS_PKRN(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CRNR_LS_PKRN_SHIFT)) & CAAM_CRNR_LS_PKRN_MASK)
/*! @} */

/*! @name CTPR_MS - Compile Time Parameters Register, most-significant half */
/*! @{ */

#define CAAM_CTPR_MS_VIRT_EN_INCL_MASK           (0x1U)
#define CAAM_CTPR_MS_VIRT_EN_INCL_SHIFT          (0U)
#define CAAM_CTPR_MS_VIRT_EN_INCL(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_VIRT_EN_INCL_SHIFT)) & CAAM_CTPR_MS_VIRT_EN_INCL_MASK)

#define CAAM_CTPR_MS_VIRT_EN_POR_VALUE_MASK      (0x2U)
#define CAAM_CTPR_MS_VIRT_EN_POR_VALUE_SHIFT     (1U)
#define CAAM_CTPR_MS_VIRT_EN_POR_VALUE(x)        (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_VIRT_EN_POR_VALUE_SHIFT)) & CAAM_CTPR_MS_VIRT_EN_POR_VALUE_MASK)

#define CAAM_CTPR_MS_REG_PG_SIZE_MASK            (0x10U)
#define CAAM_CTPR_MS_REG_PG_SIZE_SHIFT           (4U)
#define CAAM_CTPR_MS_REG_PG_SIZE(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_REG_PG_SIZE_SHIFT)) & CAAM_CTPR_MS_REG_PG_SIZE_MASK)

#define CAAM_CTPR_MS_RNG_I_MASK                  (0x700U)
#define CAAM_CTPR_MS_RNG_I_SHIFT                 (8U)
#define CAAM_CTPR_MS_RNG_I(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_RNG_I_SHIFT)) & CAAM_CTPR_MS_RNG_I_MASK)

#define CAAM_CTPR_MS_AI_INCL_MASK                (0x800U)
#define CAAM_CTPR_MS_AI_INCL_SHIFT               (11U)
#define CAAM_CTPR_MS_AI_INCL(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_AI_INCL_SHIFT)) & CAAM_CTPR_MS_AI_INCL_MASK)

#define CAAM_CTPR_MS_DPAA2_MASK                  (0x2000U)
#define CAAM_CTPR_MS_DPAA2_SHIFT                 (13U)
#define CAAM_CTPR_MS_DPAA2(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_DPAA2_SHIFT)) & CAAM_CTPR_MS_DPAA2_MASK)

#define CAAM_CTPR_MS_IP_CLK_MASK                 (0x4000U)
#define CAAM_CTPR_MS_IP_CLK_SHIFT                (14U)
#define CAAM_CTPR_MS_IP_CLK(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_IP_CLK_SHIFT)) & CAAM_CTPR_MS_IP_CLK_MASK)

#define CAAM_CTPR_MS_MCFG_BURST_MASK             (0x10000U)
#define CAAM_CTPR_MS_MCFG_BURST_SHIFT            (16U)
#define CAAM_CTPR_MS_MCFG_BURST(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_MCFG_BURST_SHIFT)) & CAAM_CTPR_MS_MCFG_BURST_MASK)

#define CAAM_CTPR_MS_MCFG_PS_MASK                (0x20000U)
#define CAAM_CTPR_MS_MCFG_PS_SHIFT               (17U)
#define CAAM_CTPR_MS_MCFG_PS(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_MCFG_PS_SHIFT)) & CAAM_CTPR_MS_MCFG_PS_MASK)

#define CAAM_CTPR_MS_SG8_MASK                    (0x40000U)
#define CAAM_CTPR_MS_SG8_SHIFT                   (18U)
#define CAAM_CTPR_MS_SG8(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_SG8_SHIFT)) & CAAM_CTPR_MS_SG8_MASK)

#define CAAM_CTPR_MS_PM_EVT_BUS_MASK             (0x80000U)
#define CAAM_CTPR_MS_PM_EVT_BUS_SHIFT            (19U)
#define CAAM_CTPR_MS_PM_EVT_BUS(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_PM_EVT_BUS_SHIFT)) & CAAM_CTPR_MS_PM_EVT_BUS_MASK)

#define CAAM_CTPR_MS_DECO_WD_MASK                (0x100000U)
#define CAAM_CTPR_MS_DECO_WD_SHIFT               (20U)
#define CAAM_CTPR_MS_DECO_WD(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_DECO_WD_SHIFT)) & CAAM_CTPR_MS_DECO_WD_MASK)

#define CAAM_CTPR_MS_PC_MASK                     (0x200000U)
#define CAAM_CTPR_MS_PC_SHIFT                    (21U)
#define CAAM_CTPR_MS_PC(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_PC_SHIFT)) & CAAM_CTPR_MS_PC_MASK)

#define CAAM_CTPR_MS_C1C2_MASK                   (0x800000U)
#define CAAM_CTPR_MS_C1C2_SHIFT                  (23U)
#define CAAM_CTPR_MS_C1C2(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_C1C2_SHIFT)) & CAAM_CTPR_MS_C1C2_MASK)

#define CAAM_CTPR_MS_ACC_CTL_MASK                (0x1000000U)
#define CAAM_CTPR_MS_ACC_CTL_SHIFT               (24U)
#define CAAM_CTPR_MS_ACC_CTL(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_ACC_CTL_SHIFT)) & CAAM_CTPR_MS_ACC_CTL_MASK)

#define CAAM_CTPR_MS_QI_MASK                     (0x2000000U)
#define CAAM_CTPR_MS_QI_SHIFT                    (25U)
#define CAAM_CTPR_MS_QI(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_QI_SHIFT)) & CAAM_CTPR_MS_QI_MASK)

#define CAAM_CTPR_MS_AXI_PRI_MASK                (0x4000000U)
#define CAAM_CTPR_MS_AXI_PRI_SHIFT               (26U)
#define CAAM_CTPR_MS_AXI_PRI(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_AXI_PRI_SHIFT)) & CAAM_CTPR_MS_AXI_PRI_MASK)

#define CAAM_CTPR_MS_AXI_LIODN_MASK              (0x8000000U)
#define CAAM_CTPR_MS_AXI_LIODN_SHIFT             (27U)
#define CAAM_CTPR_MS_AXI_LIODN(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_AXI_LIODN_SHIFT)) & CAAM_CTPR_MS_AXI_LIODN_MASK)

#define CAAM_CTPR_MS_AXI_PIPE_DEPTH_MASK         (0xF0000000U)
#define CAAM_CTPR_MS_AXI_PIPE_DEPTH_SHIFT        (28U)
#define CAAM_CTPR_MS_AXI_PIPE_DEPTH(x)           (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_MS_AXI_PIPE_DEPTH_SHIFT)) & CAAM_CTPR_MS_AXI_PIPE_DEPTH_MASK)
/*! @} */

/*! @name CTPR_LS - Compile Time Parameters Register, least-significant half */
/*! @{ */

#define CAAM_CTPR_LS_KG_DS_MASK                  (0x1U)
#define CAAM_CTPR_LS_KG_DS_SHIFT                 (0U)
/*! KG_DS
 *  0b0..CAAM does not implement specialized support for Public Key Generation and Digital Signatures.
 *  0b1..CAAM implements specialized support for Public Key Generation and Digital Signatures.
 */
#define CAAM_CTPR_LS_KG_DS(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_LS_KG_DS_SHIFT)) & CAAM_CTPR_LS_KG_DS_MASK)

#define CAAM_CTPR_LS_BLOB_MASK                   (0x2U)
#define CAAM_CTPR_LS_BLOB_SHIFT                  (1U)
/*! BLOB
 *  0b0..CAAM does not implement specialized support for encapsulating and decapsulating cryptographic blobs.
 *  0b1..CAAM implements specialized support for encapsulating and decapsulating cryptographic blobs.
 */
#define CAAM_CTPR_LS_BLOB(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_LS_BLOB_SHIFT)) & CAAM_CTPR_LS_BLOB_MASK)

#define CAAM_CTPR_LS_WIFI_MASK                   (0x4U)
#define CAAM_CTPR_LS_WIFI_SHIFT                  (2U)
/*! WIFI
 *  0b0..CAAM does not implement specialized support for the WIFI protocol.
 *  0b1..CAAM implements specialized support for the WIFI protocol.
 */
#define CAAM_CTPR_LS_WIFI(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_LS_WIFI_SHIFT)) & CAAM_CTPR_LS_WIFI_MASK)

#define CAAM_CTPR_LS_WIMAX_MASK                  (0x8U)
#define CAAM_CTPR_LS_WIMAX_SHIFT                 (3U)
/*! WIMAX
 *  0b0..CAAM does not implement specialized support for the WIMAX protocol.
 *  0b1..CAAM implements specialized support for the WIMAX protocol.
 */
#define CAAM_CTPR_LS_WIMAX(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_LS_WIMAX_SHIFT)) & CAAM_CTPR_LS_WIMAX_MASK)

#define CAAM_CTPR_LS_SRTP_MASK                   (0x10U)
#define CAAM_CTPR_LS_SRTP_SHIFT                  (4U)
/*! SRTP
 *  0b0..CAAM does not implement specialized support for the SRTP protocol.
 *  0b1..CAAM implements specialized support for the SRTP protocol.
 */
#define CAAM_CTPR_LS_SRTP(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_LS_SRTP_SHIFT)) & CAAM_CTPR_LS_SRTP_MASK)

#define CAAM_CTPR_LS_IPSEC_MASK                  (0x20U)
#define CAAM_CTPR_LS_IPSEC_SHIFT                 (5U)
/*! IPSEC
 *  0b0..CAAM does not implement specialized support for the IPSEC protocol.
 *  0b1..CAAM implements specialized support for the IPSEC protocol.
 */
#define CAAM_CTPR_LS_IPSEC(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_LS_IPSEC_SHIFT)) & CAAM_CTPR_LS_IPSEC_MASK)

#define CAAM_CTPR_LS_IKE_MASK                    (0x40U)
#define CAAM_CTPR_LS_IKE_SHIFT                   (6U)
/*! IKE
 *  0b0..CAAM does not implement specialized support for the IKE protocol.
 *  0b1..CAAM implements specialized support for the IKE protocol.
 */
#define CAAM_CTPR_LS_IKE(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_LS_IKE_SHIFT)) & CAAM_CTPR_LS_IKE_MASK)

#define CAAM_CTPR_LS_SSL_TLS_MASK                (0x80U)
#define CAAM_CTPR_LS_SSL_TLS_SHIFT               (7U)
/*! SSL_TLS
 *  0b0..CAAM does not implement specialized support for the SSL and TLS protocols.
 *  0b1..CAAM implements specialized support for the SSL and TLS protocols.
 */
#define CAAM_CTPR_LS_SSL_TLS(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_LS_SSL_TLS_SHIFT)) & CAAM_CTPR_LS_SSL_TLS_MASK)

#define CAAM_CTPR_LS_TLS_PRF_MASK                (0x100U)
#define CAAM_CTPR_LS_TLS_PRF_SHIFT               (8U)
/*! TLS_PRF
 *  0b0..CAAM does not implement specialized support for the TLS protocol pseudo-random function.
 *  0b1..CAAM implements specialized support for the TLS protocol pseudo-random function.
 */
#define CAAM_CTPR_LS_TLS_PRF(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_LS_TLS_PRF_SHIFT)) & CAAM_CTPR_LS_TLS_PRF_MASK)

#define CAAM_CTPR_LS_MACSEC_MASK                 (0x200U)
#define CAAM_CTPR_LS_MACSEC_SHIFT                (9U)
/*! MACSEC
 *  0b0..CAAM does not implement specialized support for the MACSEC protocol.
 *  0b1..CAAM implements specialized support for the MACSEC protocol.
 */
#define CAAM_CTPR_LS_MACSEC(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_LS_MACSEC_SHIFT)) & CAAM_CTPR_LS_MACSEC_MASK)

#define CAAM_CTPR_LS_RSA_MASK                    (0x400U)
#define CAAM_CTPR_LS_RSA_SHIFT                   (10U)
/*! RSA
 *  0b0..CAAM does not implement specialized support for RSA encrypt and decrypt operations.
 *  0b1..CAAM implements specialized support for RSA encrypt and decrypt operations.
 */
#define CAAM_CTPR_LS_RSA(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_LS_RSA_SHIFT)) & CAAM_CTPR_LS_RSA_MASK)

#define CAAM_CTPR_LS_P3G_LTE_MASK                (0x800U)
#define CAAM_CTPR_LS_P3G_LTE_SHIFT               (11U)
/*! P3G_LTE
 *  0b0..CAAM does not implement specialized support for 3G and LTE protocols.
 *  0b1..CAAM implements specialized support for 3G and LTE protocols.
 */
#define CAAM_CTPR_LS_P3G_LTE(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_LS_P3G_LTE_SHIFT)) & CAAM_CTPR_LS_P3G_LTE_MASK)

#define CAAM_CTPR_LS_DBL_CRC_MASK                (0x1000U)
#define CAAM_CTPR_LS_DBL_CRC_SHIFT               (12U)
/*! DBL_CRC
 *  0b0..CAAM does not implement specialized support for Double CRC.
 *  0b1..CAAM implements specialized support for Double CRC.
 */
#define CAAM_CTPR_LS_DBL_CRC(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_LS_DBL_CRC_SHIFT)) & CAAM_CTPR_LS_DBL_CRC_MASK)

#define CAAM_CTPR_LS_MAN_PROT_MASK               (0x2000U)
#define CAAM_CTPR_LS_MAN_PROT_SHIFT              (13U)
/*! MAN_PROT
 *  0b0..CAAM does not implement Manufacturing Protection functions.
 *  0b1..CAAM implements Manufacturing Protection functions.
 */
#define CAAM_CTPR_LS_MAN_PROT(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_LS_MAN_PROT_SHIFT)) & CAAM_CTPR_LS_MAN_PROT_MASK)

#define CAAM_CTPR_LS_DKP_MASK                    (0x4000U)
#define CAAM_CTPR_LS_DKP_SHIFT                   (14U)
/*! DKP
 *  0b0..CAAM does not implement the Derived Key Protocol.
 *  0b1..CAAM implements the Derived Key Protocol.
 */
#define CAAM_CTPR_LS_DKP(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CTPR_LS_DKP_SHIFT)) & CAAM_CTPR_LS_DKP_MASK)
/*! @} */

/*! @name SMSTA - Secure Memory Status Register */
/*! @{ */

#define CAAM_SMSTA_STATE_MASK                    (0xFU)
#define CAAM_SMSTA_STATE_SHIFT                   (0U)
/*! STATE
 *  0b0000..Reset State
 *  0b0001..Initialize State
 *  0b0010..Normal State
 *  0b0011..Fail State
 */
#define CAAM_SMSTA_STATE(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_SMSTA_STATE_SHIFT)) & CAAM_SMSTA_STATE_MASK)

#define CAAM_SMSTA_ACCERR_MASK                   (0xF0U)
#define CAAM_SMSTA_ACCERR_SHIFT                  (4U)
/*! ACCERR
 *  0b0000..No error occurred
 *  0b0001..A bus transaction attempted to access a page in Secure Memory, but the page was not allocated to any partition.
 *  0b0010..A bus transaction attempted to access a partition, but the transaction's TrustZone World, DID was not
 *          granted access to the partition in the partition's SMAG2/1JR registers.
 *  0b0011..A bus transaction attempted to read, but reads from this partition are not allowed.
 *  0b0100..A bus transaction attempted to write, but writes to this partition are not allowed.
 *  0b0110..A bus transaction attempted a non-key read, but the only reads permitted from this partition are key reads.
 *  0b1001..Secure Memory Blob import or export was attempted, but Secure Memory Blob access is not allowed for this partition.
 *  0b1010..A Descriptor attempted a Secure Memory Blob import or export, but not all of the pages referenced were from the same partition.
 *  0b1011..A memory access was directed to Secure Memory, but the specified address is not implemented in Secure
 *          Memory. The address was either outside the address range occupied by Secure Memory, or was within an
 *          unimplemented portion of the 4kbyte address block occupied by a 1Kbyte or 2Kbyte Secure Memory page.
 *  0b1100..A bus transaction was attempted, but the burst would have crossed a page boundary.
 *  0b1101..An attempt was made to access a page while it was still being initialized.
 */
#define CAAM_SMSTA_ACCERR(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_SMSTA_ACCERR_SHIFT)) & CAAM_SMSTA_ACCERR_MASK)

#define CAAM_SMSTA_DID_MASK                      (0xF00U)
#define CAAM_SMSTA_DID_SHIFT                     (8U)
#define CAAM_SMSTA_DID(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_SMSTA_DID_SHIFT)) & CAAM_SMSTA_DID_MASK)

#define CAAM_SMSTA_NS_MASK                       (0x1000U)
#define CAAM_SMSTA_NS_SHIFT                      (12U)
#define CAAM_SMSTA_NS(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_SMSTA_NS_SHIFT)) & CAAM_SMSTA_NS_MASK)

#define CAAM_SMSTA_SMR_WP_MASK                   (0x8000U)
#define CAAM_SMSTA_SMR_WP_SHIFT                  (15U)
#define CAAM_SMSTA_SMR_WP(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_SMSTA_SMR_WP_SHIFT)) & CAAM_SMSTA_SMR_WP_MASK)

#define CAAM_SMSTA_PAGE_MASK                     (0x7FF0000U)
#define CAAM_SMSTA_PAGE_SHIFT                    (16U)
#define CAAM_SMSTA_PAGE(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_SMSTA_PAGE_SHIFT)) & CAAM_SMSTA_PAGE_MASK)

#define CAAM_SMSTA_PART_MASK                     (0xF0000000U)
#define CAAM_SMSTA_PART_SHIFT                    (28U)
#define CAAM_SMSTA_PART(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_SMSTA_PART_SHIFT)) & CAAM_SMSTA_PART_MASK)
/*! @} */

/*! @name SMPO - Secure Memory Partition Owners Register */
/*! @{ */

#define CAAM_SMPO_PO0_MASK                       (0x3U)
#define CAAM_SMPO_PO0_SHIFT                      (0U)
/*! PO0
 *  0b00..Available; Unowned. A Job Ring owner may claim partition 0 by writing to the appropriate SMAPJR register
 *        address alias. Note that the entire register will return all 0s if read by a entity that does not own
 *        the Job Ring associated with the SMPO address alias that was read.
 *  0b01..Partition 0 does not exist in this version
 *  0b10..Another entity owns partition 0. Partition 0 is unavailable to the reader. If the reader attempts to
 *        de-allocate partition 0 or write to the SMAPJR register or SMAGJR register for partition 0 or allocate a
 *        page to or de-allocate a page from partition 0 the command will be ignored. (Note that if a CSP partition is
 *        de-allocated, all entities (including the owner that de-allocated the partition) will see a 0b10 value
 *        for that partition until all its pages have been zeroized.)
 *  0b11..The entity that read the SMPO register owns partition 0. Ownership is claimed when the access
 *        permissions register (SMAPJR) of an available partition is first written.
 */
#define CAAM_SMPO_PO0(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO0_SHIFT)) & CAAM_SMPO_PO0_MASK)

#define CAAM_SMPO_PO1_MASK                       (0xCU)
#define CAAM_SMPO_PO1_SHIFT                      (2U)
#define CAAM_SMPO_PO1(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO1_SHIFT)) & CAAM_SMPO_PO1_MASK)

#define CAAM_SMPO_PO2_MASK                       (0x30U)
#define CAAM_SMPO_PO2_SHIFT                      (4U)
#define CAAM_SMPO_PO2(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO2_SHIFT)) & CAAM_SMPO_PO2_MASK)

#define CAAM_SMPO_PO3_MASK                       (0xC0U)
#define CAAM_SMPO_PO3_SHIFT                      (6U)
#define CAAM_SMPO_PO3(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO3_SHIFT)) & CAAM_SMPO_PO3_MASK)

#define CAAM_SMPO_PO4_MASK                       (0x300U)
#define CAAM_SMPO_PO4_SHIFT                      (8U)
#define CAAM_SMPO_PO4(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO4_SHIFT)) & CAAM_SMPO_PO4_MASK)

#define CAAM_SMPO_PO5_MASK                       (0xC00U)
#define CAAM_SMPO_PO5_SHIFT                      (10U)
#define CAAM_SMPO_PO5(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO5_SHIFT)) & CAAM_SMPO_PO5_MASK)

#define CAAM_SMPO_PO6_MASK                       (0x3000U)
#define CAAM_SMPO_PO6_SHIFT                      (12U)
#define CAAM_SMPO_PO6(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO6_SHIFT)) & CAAM_SMPO_PO6_MASK)

#define CAAM_SMPO_PO7_MASK                       (0xC000U)
#define CAAM_SMPO_PO7_SHIFT                      (14U)
#define CAAM_SMPO_PO7(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO7_SHIFT)) & CAAM_SMPO_PO7_MASK)

#define CAAM_SMPO_PO8_MASK                       (0x30000U)
#define CAAM_SMPO_PO8_SHIFT                      (16U)
#define CAAM_SMPO_PO8(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO8_SHIFT)) & CAAM_SMPO_PO8_MASK)

#define CAAM_SMPO_PO9_MASK                       (0xC0000U)
#define CAAM_SMPO_PO9_SHIFT                      (18U)
#define CAAM_SMPO_PO9(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO9_SHIFT)) & CAAM_SMPO_PO9_MASK)

#define CAAM_SMPO_PO10_MASK                      (0x300000U)
#define CAAM_SMPO_PO10_SHIFT                     (20U)
#define CAAM_SMPO_PO10(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO10_SHIFT)) & CAAM_SMPO_PO10_MASK)

#define CAAM_SMPO_PO11_MASK                      (0xC00000U)
#define CAAM_SMPO_PO11_SHIFT                     (22U)
#define CAAM_SMPO_PO11(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO11_SHIFT)) & CAAM_SMPO_PO11_MASK)

#define CAAM_SMPO_PO12_MASK                      (0x3000000U)
#define CAAM_SMPO_PO12_SHIFT                     (24U)
#define CAAM_SMPO_PO12(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO12_SHIFT)) & CAAM_SMPO_PO12_MASK)

#define CAAM_SMPO_PO13_MASK                      (0xC000000U)
#define CAAM_SMPO_PO13_SHIFT                     (26U)
#define CAAM_SMPO_PO13(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO13_SHIFT)) & CAAM_SMPO_PO13_MASK)

#define CAAM_SMPO_PO14_MASK                      (0x30000000U)
#define CAAM_SMPO_PO14_SHIFT                     (28U)
#define CAAM_SMPO_PO14(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO14_SHIFT)) & CAAM_SMPO_PO14_MASK)

#define CAAM_SMPO_PO15_MASK                      (0xC0000000U)
#define CAAM_SMPO_PO15_SHIFT                     (30U)
#define CAAM_SMPO_PO15(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_SMPO_PO15_SHIFT)) & CAAM_SMPO_PO15_MASK)
/*! @} */

/*! @name FAR - Fault Address Register */
/*! @{ */

#define CAAM_FAR_FAR_MASK                        (0xFFFFFFFFFU)
#define CAAM_FAR_FAR_SHIFT                       (0U)
#define CAAM_FAR_FAR(x)                          (((uint64_t)(((uint64_t)(x)) << CAAM_FAR_FAR_SHIFT)) & CAAM_FAR_FAR_MASK)
/*! @} */

/*! @name FADID - Fault Address DID Register */
/*! @{ */

#define CAAM_FADID_FDID_MASK                     (0xFU)
#define CAAM_FADID_FDID_SHIFT                    (0U)
#define CAAM_FADID_FDID(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_FADID_FDID_SHIFT)) & CAAM_FADID_FDID_MASK)

#define CAAM_FADID_FNS_MASK                      (0x10U)
#define CAAM_FADID_FNS_SHIFT                     (4U)
#define CAAM_FADID_FNS(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_FADID_FNS_SHIFT)) & CAAM_FADID_FNS_MASK)

#define CAAM_FADID_FICID_MASK                    (0xFFE0U)
#define CAAM_FADID_FICID_SHIFT                   (5U)
#define CAAM_FADID_FICID(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_FADID_FICID_SHIFT)) & CAAM_FADID_FICID_MASK)
/*! @} */

/*! @name FADR - Fault Address Detail Register */
/*! @{ */

#define CAAM_FADR_FSZ_MASK                       (0x7FU)
#define CAAM_FADR_FSZ_SHIFT                      (0U)
#define CAAM_FADR_FSZ(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_FADR_FSZ_SHIFT)) & CAAM_FADR_FSZ_MASK)

#define CAAM_FADR_TYP_MASK                       (0x80U)
#define CAAM_FADR_TYP_SHIFT                      (7U)
/*! TYP
 *  0b0..Read.
 *  0b1..Write.
 */
#define CAAM_FADR_TYP(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_FADR_TYP_SHIFT)) & CAAM_FADR_TYP_MASK)

#define CAAM_FADR_BLKID_MASK                     (0xF00U)
#define CAAM_FADR_BLKID_SHIFT                    (8U)
/*! BLKID
 *  0b0100..job queue controller Burst Buffer
 *  0b0101..One of the Job Rings (see JSRC field)
 *  0b1000..DECO0
 */
#define CAAM_FADR_BLKID(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_FADR_BLKID_SHIFT)) & CAAM_FADR_BLKID_MASK)

#define CAAM_FADR_JSRC_MASK                      (0x7000U)
#define CAAM_FADR_JSRC_SHIFT                     (12U)
/*! JSRC
 *  0b000..Job Ring 0
 *  0b001..Job Ring 1
 *  0b010..Job Ring 2
 *  0b011..Job Ring 3
 *  0b100..RTIC
 *  0b101..reserved
 *  0b110..reserved
 *  0b111..reserved
 */
#define CAAM_FADR_JSRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_FADR_JSRC_SHIFT)) & CAAM_FADR_JSRC_MASK)

#define CAAM_FADR_DTYP_MASK                      (0x8000U)
#define CAAM_FADR_DTYP_SHIFT                     (15U)
/*! DTYP
 *  0b0..message data
 *  0b1..control data
 */
#define CAAM_FADR_DTYP(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_FADR_DTYP_SHIFT)) & CAAM_FADR_DTYP_MASK)

#define CAAM_FADR_FSZ_EXT_MASK                   (0x70000U)
#define CAAM_FADR_FSZ_EXT_SHIFT                  (16U)
#define CAAM_FADR_FSZ_EXT(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_FADR_FSZ_EXT_SHIFT)) & CAAM_FADR_FSZ_EXT_MASK)

#define CAAM_FADR_FKMOD_MASK                     (0x1000000U)
#define CAAM_FADR_FKMOD_SHIFT                    (24U)
/*! FKMOD
 *  0b0..CAAM DMA was not attempting to read the key modifier from Secure Memory at the time that the DMA error occurred.
 *  0b1..CAAM DMA was attempting to read the key modifier from Secure Memory at the time that the DMA error occurred.
 */
#define CAAM_FADR_FKMOD(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_FADR_FKMOD_SHIFT)) & CAAM_FADR_FKMOD_MASK)

#define CAAM_FADR_FKEY_MASK                      (0x2000000U)
#define CAAM_FADR_FKEY_SHIFT                     (25U)
/*! FKEY
 *  0b0..CAAM DMA was not attempting to perform a key read from Secure Memory at the time of the DMA error.
 *  0b1..CAAM DMA was attempting to perform a key read from Secure Memory at the time of the DMA error.
 */
#define CAAM_FADR_FKEY(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_FADR_FKEY_SHIFT)) & CAAM_FADR_FKEY_MASK)

#define CAAM_FADR_FTDSC_MASK                     (0x4000000U)
#define CAAM_FADR_FTDSC_SHIFT                    (26U)
/*! FTDSC
 *  0b0..CAAM DMA was not executing a Trusted Descriptor at the time of the DMA error.
 *  0b1..CAAM DMA was executing a Trusted Descriptor at the time of the DMA error.
 */
#define CAAM_FADR_FTDSC(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_FADR_FTDSC_SHIFT)) & CAAM_FADR_FTDSC_MASK)

#define CAAM_FADR_FBNDG_MASK                     (0x8000000U)
#define CAAM_FADR_FBNDG_SHIFT                    (27U)
/*! FBNDG
 *  0b0..CAAM DMA was not reading access permissions from a Secure Memory partition at the time of the DMA error.
 *  0b1..CAAM DMA was reading access permissions from a Secure Memory partition at the time of the DMA error.
 */
#define CAAM_FADR_FBNDG(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_FADR_FBNDG_SHIFT)) & CAAM_FADR_FBNDG_MASK)

#define CAAM_FADR_FNS_MASK                       (0x10000000U)
#define CAAM_FADR_FNS_SHIFT                      (28U)
/*! FNS
 *  0b0..CAAM DMA was asserting ns=0 at the time of the DMA error.
 *  0b1..CAAM DMA was asserting ns=1 at the time of the DMA error.
 */
#define CAAM_FADR_FNS(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_FADR_FNS_SHIFT)) & CAAM_FADR_FNS_MASK)

#define CAAM_FADR_FERR_MASK                      (0xC0000000U)
#define CAAM_FADR_FERR_SHIFT                     (30U)
/*! FERR
 *  0b00..OKAY - Normal Access
 *  0b01..Reserved
 *  0b10..SLVERR - Slave Error
 *  0b11..DECERR - Decode Error
 */
#define CAAM_FADR_FERR(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_FADR_FERR_SHIFT)) & CAAM_FADR_FERR_MASK)
/*! @} */

/*! @name CSTA - CAAM Status Register */
/*! @{ */

#define CAAM_CSTA_BSY_MASK                       (0x1U)
#define CAAM_CSTA_BSY_SHIFT                      (0U)
#define CAAM_CSTA_BSY(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CSTA_BSY_SHIFT)) & CAAM_CSTA_BSY_MASK)

#define CAAM_CSTA_IDLE_MASK                      (0x2U)
#define CAAM_CSTA_IDLE_SHIFT                     (1U)
#define CAAM_CSTA_IDLE(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CSTA_IDLE_SHIFT)) & CAAM_CSTA_IDLE_MASK)

#define CAAM_CSTA_TRNG_IDLE_MASK                 (0x4U)
#define CAAM_CSTA_TRNG_IDLE_SHIFT                (2U)
#define CAAM_CSTA_TRNG_IDLE(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_CSTA_TRNG_IDLE_SHIFT)) & CAAM_CSTA_TRNG_IDLE_MASK)

#define CAAM_CSTA_MOO_MASK                       (0x300U)
#define CAAM_CSTA_MOO_SHIFT                      (8U)
/*! MOO
 *  0b00..Non-Secure
 *  0b01..Secure
 *  0b10..Trusted
 *  0b11..Fail
 */
#define CAAM_CSTA_MOO(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CSTA_MOO_SHIFT)) & CAAM_CSTA_MOO_MASK)

#define CAAM_CSTA_PLEND_MASK                     (0x400U)
#define CAAM_CSTA_PLEND_SHIFT                    (10U)
/*! PLEND
 *  0b0..Platform default is Little Endian
 *  0b1..Platform default is Big Endian
 */
#define CAAM_CSTA_PLEND(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CSTA_PLEND_SHIFT)) & CAAM_CSTA_PLEND_MASK)
/*! @} */

/*! @name SMVID_MS - Secure Memory Version ID Register, most-significant half */
/*! @{ */

#define CAAM_SMVID_MS_NPAG_MASK                  (0x3FFU)
#define CAAM_SMVID_MS_NPAG_SHIFT                 (0U)
#define CAAM_SMVID_MS_NPAG(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_SMVID_MS_NPAG_SHIFT)) & CAAM_SMVID_MS_NPAG_MASK)

#define CAAM_SMVID_MS_NPRT_MASK                  (0xF000U)
#define CAAM_SMVID_MS_NPRT_SHIFT                 (12U)
#define CAAM_SMVID_MS_NPRT(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_SMVID_MS_NPRT_SHIFT)) & CAAM_SMVID_MS_NPRT_MASK)

#define CAAM_SMVID_MS_MAX_NPAG_MASK              (0x3FF0000U)
#define CAAM_SMVID_MS_MAX_NPAG_SHIFT             (16U)
#define CAAM_SMVID_MS_MAX_NPAG(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_SMVID_MS_MAX_NPAG_SHIFT)) & CAAM_SMVID_MS_MAX_NPAG_MASK)
/*! @} */

/*! @name SMVID_LS - Secure Memory Version ID Register, least-significant half */
/*! @{ */

#define CAAM_SMVID_LS_SMNV_MASK                  (0xFFU)
#define CAAM_SMVID_LS_SMNV_SHIFT                 (0U)
#define CAAM_SMVID_LS_SMNV(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_SMVID_LS_SMNV_SHIFT)) & CAAM_SMVID_LS_SMNV_MASK)

#define CAAM_SMVID_LS_SMJV_MASK                  (0xFF00U)
#define CAAM_SMVID_LS_SMJV_SHIFT                 (8U)
#define CAAM_SMVID_LS_SMJV(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_SMVID_LS_SMJV_SHIFT)) & CAAM_SMVID_LS_SMJV_MASK)

#define CAAM_SMVID_LS_PSIZ_MASK                  (0x70000U)
#define CAAM_SMVID_LS_PSIZ_SHIFT                 (16U)
#define CAAM_SMVID_LS_PSIZ(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_SMVID_LS_PSIZ_SHIFT)) & CAAM_SMVID_LS_PSIZ_MASK)
/*! @} */

/*! @name RVID - RTIC Version ID Register */
/*! @{ */

#define CAAM_RVID_RMNV_MASK                      (0xFFU)
#define CAAM_RVID_RMNV_SHIFT                     (0U)
#define CAAM_RVID_RMNV(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_RVID_RMNV_SHIFT)) & CAAM_RVID_RMNV_MASK)

#define CAAM_RVID_RMJV_MASK                      (0xFF00U)
#define CAAM_RVID_RMJV_SHIFT                     (8U)
#define CAAM_RVID_RMJV(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_RVID_RMJV_SHIFT)) & CAAM_RVID_RMJV_MASK)

#define CAAM_RVID_SHA_256_MASK                   (0x20000U)
#define CAAM_RVID_SHA_256_SHIFT                  (17U)
/*! SHA_256
 *  0b0..RTIC cannot use the SHA-256 hashing algorithm.
 *  0b1..RTIC can use the SHA-256 hashing algorithm.
 */
#define CAAM_RVID_SHA_256(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_RVID_SHA_256_SHIFT)) & CAAM_RVID_SHA_256_MASK)

#define CAAM_RVID_SHA_512_MASK                   (0x80000U)
#define CAAM_RVID_SHA_512_SHIFT                  (19U)
/*! SHA_512
 *  0b0..RTIC cannot use the SHA-512 hashing algorithm.
 *  0b1..RTIC can use the SHA-512 hashing algorithm.
 */
#define CAAM_RVID_SHA_512(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_RVID_SHA_512_SHIFT)) & CAAM_RVID_SHA_512_MASK)

#define CAAM_RVID_MA_MASK                        (0x1000000U)
#define CAAM_RVID_MA_SHIFT                       (24U)
#define CAAM_RVID_MA(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_RVID_MA_SHIFT)) & CAAM_RVID_MA_MASK)

#define CAAM_RVID_MB_MASK                        (0x2000000U)
#define CAAM_RVID_MB_SHIFT                       (25U)
#define CAAM_RVID_MB(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_RVID_MB_SHIFT)) & CAAM_RVID_MB_MASK)

#define CAAM_RVID_MC_MASK                        (0x4000000U)
#define CAAM_RVID_MC_SHIFT                       (26U)
#define CAAM_RVID_MC(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_RVID_MC_SHIFT)) & CAAM_RVID_MC_MASK)

#define CAAM_RVID_MD_MASK                        (0x8000000U)
#define CAAM_RVID_MD_SHIFT                       (27U)
#define CAAM_RVID_MD(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_RVID_MD_SHIFT)) & CAAM_RVID_MD_MASK)
/*! @} */

/*! @name CCBVID - CHA Cluster Block Version ID Register */
/*! @{ */

#define CAAM_CCBVID_AMNV_MASK                    (0xFFU)
#define CAAM_CCBVID_AMNV_SHIFT                   (0U)
#define CAAM_CCBVID_AMNV(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CCBVID_AMNV_SHIFT)) & CAAM_CCBVID_AMNV_MASK)

#define CAAM_CCBVID_AMJV_MASK                    (0xFF00U)
#define CAAM_CCBVID_AMJV_SHIFT                   (8U)
#define CAAM_CCBVID_AMJV(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CCBVID_AMJV_SHIFT)) & CAAM_CCBVID_AMJV_MASK)

#define CAAM_CCBVID_CAAM_ERA_MASK                (0xFF000000U)
#define CAAM_CCBVID_CAAM_ERA_SHIFT               (24U)
#define CAAM_CCBVID_CAAM_ERA(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CCBVID_CAAM_ERA_SHIFT)) & CAAM_CCBVID_CAAM_ERA_MASK)
/*! @} */

/*! @name CHAVID_MS - CHA Version ID Register, most-significant half */
/*! @{ */

#define CAAM_CHAVID_MS_CRCVID_MASK               (0xFU)
#define CAAM_CHAVID_MS_CRCVID_SHIFT              (0U)
#define CAAM_CHAVID_MS_CRCVID(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_CHAVID_MS_CRCVID_SHIFT)) & CAAM_CHAVID_MS_CRCVID_MASK)

#define CAAM_CHAVID_MS_SNW9VID_MASK              (0xF0U)
#define CAAM_CHAVID_MS_SNW9VID_SHIFT             (4U)
#define CAAM_CHAVID_MS_SNW9VID(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_CHAVID_MS_SNW9VID_SHIFT)) & CAAM_CHAVID_MS_SNW9VID_MASK)

#define CAAM_CHAVID_MS_ZEVID_MASK                (0xF00U)
#define CAAM_CHAVID_MS_ZEVID_SHIFT               (8U)
#define CAAM_CHAVID_MS_ZEVID(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CHAVID_MS_ZEVID_SHIFT)) & CAAM_CHAVID_MS_ZEVID_MASK)

#define CAAM_CHAVID_MS_ZAVID_MASK                (0xF000U)
#define CAAM_CHAVID_MS_ZAVID_SHIFT               (12U)
#define CAAM_CHAVID_MS_ZAVID(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CHAVID_MS_ZAVID_SHIFT)) & CAAM_CHAVID_MS_ZAVID_MASK)

#define CAAM_CHAVID_MS_DECOVID_MASK              (0xF000000U)
#define CAAM_CHAVID_MS_DECOVID_SHIFT             (24U)
#define CAAM_CHAVID_MS_DECOVID(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_CHAVID_MS_DECOVID_SHIFT)) & CAAM_CHAVID_MS_DECOVID_MASK)

#define CAAM_CHAVID_MS_JRVID_MASK                (0xF0000000U)
#define CAAM_CHAVID_MS_JRVID_SHIFT               (28U)
#define CAAM_CHAVID_MS_JRVID(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CHAVID_MS_JRVID_SHIFT)) & CAAM_CHAVID_MS_JRVID_MASK)
/*! @} */

/*! @name CHAVID_LS - CHA Version ID Register, least-significant half */
/*! @{ */

#define CAAM_CHAVID_LS_AESVID_MASK               (0xFU)
#define CAAM_CHAVID_LS_AESVID_SHIFT              (0U)
/*! AESVID
 *  0b0100..High-performance AESA, implementing ECB, CBC, CBC-CS2, CFB128, OFB, CTR, CCM, CMAC, XCBC-MAC, CBCXCBC, CTRXCBC, XTS, and GCM modes
 *  0b0011..Low-power AESA, implementing ECB, CBC, CBC-CS2, CFB128, OFB, CTR, CCM, CMAC, XCBC-MAC, and GCM modes
 */
#define CAAM_CHAVID_LS_AESVID(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_CHAVID_LS_AESVID_SHIFT)) & CAAM_CHAVID_LS_AESVID_MASK)

#define CAAM_CHAVID_LS_DESVID_MASK               (0xF0U)
#define CAAM_CHAVID_LS_DESVID_SHIFT              (4U)
#define CAAM_CHAVID_LS_DESVID(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_CHAVID_LS_DESVID_SHIFT)) & CAAM_CHAVID_LS_DESVID_MASK)

#define CAAM_CHAVID_LS_MDVID_MASK                (0xF000U)
#define CAAM_CHAVID_LS_MDVID_SHIFT               (12U)
/*! MDVID
 *  0b0000..Low-power MDHA, with SHA-1, SHA-256, SHA 224, MD5 and HMAC
 *  0b0001..Low-power MDHA, with SHA-1, SHA-256, SHA 224, SHA-512, SHA-512/224, SHA-512/256, SHA-384, MD5 and HMAC
 *  0b0010..Medium-performance MDHA, with SHA-1, SHA-256, SHA 224, SHA-512, SHA-512/224, SHA-512/256, SHA-384, MD5, HMAC & SMAC
 *  0b0011..High-performance MDHA, with SHA-1, SHA-256, SHA 224, SHA-512, SHA-512/224, SHA-512/256, SHA-384, MD5, HMAC & SMAC
 */
#define CAAM_CHAVID_LS_MDVID(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CHAVID_LS_MDVID_SHIFT)) & CAAM_CHAVID_LS_MDVID_MASK)

#define CAAM_CHAVID_LS_RNGVID_MASK               (0xF0000U)
#define CAAM_CHAVID_LS_RNGVID_SHIFT              (16U)
/*! RNGVID
 *  0b0010..RNGB
 *  0b0100..RNG4
 */
#define CAAM_CHAVID_LS_RNGVID(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_CHAVID_LS_RNGVID_SHIFT)) & CAAM_CHAVID_LS_RNGVID_MASK)

#define CAAM_CHAVID_LS_SNW8VID_MASK              (0xF00000U)
#define CAAM_CHAVID_LS_SNW8VID_SHIFT             (20U)
#define CAAM_CHAVID_LS_SNW8VID(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_CHAVID_LS_SNW8VID_SHIFT)) & CAAM_CHAVID_LS_SNW8VID_MASK)

#define CAAM_CHAVID_LS_KASVID_MASK               (0xF000000U)
#define CAAM_CHAVID_LS_KASVID_SHIFT              (24U)
#define CAAM_CHAVID_LS_KASVID(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_CHAVID_LS_KASVID_SHIFT)) & CAAM_CHAVID_LS_KASVID_MASK)

#define CAAM_CHAVID_LS_PKVID_MASK                (0xF0000000U)
#define CAAM_CHAVID_LS_PKVID_SHIFT               (28U)
/*! PKVID
 *  0b0000..PKHA-XT (32-bit); minimum modulus five bytes
 *  0b0001..PKHA-SD (32-bit)
 *  0b0010..PKHA-SD (64-bit)
 *  0b0011..PKHA-SD (128-bit)
 */
#define CAAM_CHAVID_LS_PKVID(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CHAVID_LS_PKVID_SHIFT)) & CAAM_CHAVID_LS_PKVID_MASK)
/*! @} */

/*! @name CHANUM_MS - CHA Number Register, most-significant half */
/*! @{ */

#define CAAM_CHANUM_MS_CRCNUM_MASK               (0xFU)
#define CAAM_CHANUM_MS_CRCNUM_SHIFT              (0U)
#define CAAM_CHANUM_MS_CRCNUM(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_CHANUM_MS_CRCNUM_SHIFT)) & CAAM_CHANUM_MS_CRCNUM_MASK)

#define CAAM_CHANUM_MS_SNW9NUM_MASK              (0xF0U)
#define CAAM_CHANUM_MS_SNW9NUM_SHIFT             (4U)
#define CAAM_CHANUM_MS_SNW9NUM(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_CHANUM_MS_SNW9NUM_SHIFT)) & CAAM_CHANUM_MS_SNW9NUM_MASK)

#define CAAM_CHANUM_MS_ZENUM_MASK                (0xF00U)
#define CAAM_CHANUM_MS_ZENUM_SHIFT               (8U)
#define CAAM_CHANUM_MS_ZENUM(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CHANUM_MS_ZENUM_SHIFT)) & CAAM_CHANUM_MS_ZENUM_MASK)

#define CAAM_CHANUM_MS_ZANUM_MASK                (0xF000U)
#define CAAM_CHANUM_MS_ZANUM_SHIFT               (12U)
#define CAAM_CHANUM_MS_ZANUM(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CHANUM_MS_ZANUM_SHIFT)) & CAAM_CHANUM_MS_ZANUM_MASK)

#define CAAM_CHANUM_MS_DECONUM_MASK              (0xF000000U)
#define CAAM_CHANUM_MS_DECONUM_SHIFT             (24U)
#define CAAM_CHANUM_MS_DECONUM(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_CHANUM_MS_DECONUM_SHIFT)) & CAAM_CHANUM_MS_DECONUM_MASK)

#define CAAM_CHANUM_MS_JRNUM_MASK                (0xF0000000U)
#define CAAM_CHANUM_MS_JRNUM_SHIFT               (28U)
#define CAAM_CHANUM_MS_JRNUM(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CHANUM_MS_JRNUM_SHIFT)) & CAAM_CHANUM_MS_JRNUM_MASK)
/*! @} */

/*! @name CHANUM_LS - CHA Number Register, least-significant half */
/*! @{ */

#define CAAM_CHANUM_LS_AESNUM_MASK               (0xFU)
#define CAAM_CHANUM_LS_AESNUM_SHIFT              (0U)
#define CAAM_CHANUM_LS_AESNUM(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_CHANUM_LS_AESNUM_SHIFT)) & CAAM_CHANUM_LS_AESNUM_MASK)

#define CAAM_CHANUM_LS_DESNUM_MASK               (0xF0U)
#define CAAM_CHANUM_LS_DESNUM_SHIFT              (4U)
#define CAAM_CHANUM_LS_DESNUM(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_CHANUM_LS_DESNUM_SHIFT)) & CAAM_CHANUM_LS_DESNUM_MASK)

#define CAAM_CHANUM_LS_ARC4NUM_MASK              (0xF00U)
#define CAAM_CHANUM_LS_ARC4NUM_SHIFT             (8U)
#define CAAM_CHANUM_LS_ARC4NUM(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_CHANUM_LS_ARC4NUM_SHIFT)) & CAAM_CHANUM_LS_ARC4NUM_MASK)

#define CAAM_CHANUM_LS_MDNUM_MASK                (0xF000U)
#define CAAM_CHANUM_LS_MDNUM_SHIFT               (12U)
#define CAAM_CHANUM_LS_MDNUM(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CHANUM_LS_MDNUM_SHIFT)) & CAAM_CHANUM_LS_MDNUM_MASK)

#define CAAM_CHANUM_LS_RNGNUM_MASK               (0xF0000U)
#define CAAM_CHANUM_LS_RNGNUM_SHIFT              (16U)
#define CAAM_CHANUM_LS_RNGNUM(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_CHANUM_LS_RNGNUM_SHIFT)) & CAAM_CHANUM_LS_RNGNUM_MASK)

#define CAAM_CHANUM_LS_SNW8NUM_MASK              (0xF00000U)
#define CAAM_CHANUM_LS_SNW8NUM_SHIFT             (20U)
#define CAAM_CHANUM_LS_SNW8NUM(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_CHANUM_LS_SNW8NUM_SHIFT)) & CAAM_CHANUM_LS_SNW8NUM_MASK)

#define CAAM_CHANUM_LS_KASNUM_MASK               (0xF000000U)
#define CAAM_CHANUM_LS_KASNUM_SHIFT              (24U)
#define CAAM_CHANUM_LS_KASNUM(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_CHANUM_LS_KASNUM_SHIFT)) & CAAM_CHANUM_LS_KASNUM_MASK)

#define CAAM_CHANUM_LS_PKNUM_MASK                (0xF0000000U)
#define CAAM_CHANUM_LS_PKNUM_SHIFT               (28U)
#define CAAM_CHANUM_LS_PKNUM(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CHANUM_LS_PKNUM_SHIFT)) & CAAM_CHANUM_LS_PKNUM_MASK)
/*! @} */

/*! @name IRBAR_JR - Input Ring Base Address Register for Job Ring 0..Input Ring Base Address Register for Job Ring 3 */
/*! @{ */

#define CAAM_IRBAR_JR_IRBA_MASK                  (0xFFFFFFFFFU)
#define CAAM_IRBAR_JR_IRBA_SHIFT                 (0U)
#define CAAM_IRBAR_JR_IRBA(x)                    (((uint64_t)(((uint64_t)(x)) << CAAM_IRBAR_JR_IRBA_SHIFT)) & CAAM_IRBAR_JR_IRBA_MASK)
/*! @} */

/* The count of CAAM_IRBAR_JR */
#define CAAM_IRBAR_JR_COUNT                      (4U)

/*! @name IRSR_JR - Input Ring Size Register for Job Ring 0..Input Ring Size Register for Job Ring 3 */
/*! @{ */

#define CAAM_IRSR_JR_IRS_MASK                    (0x3FFU)
#define CAAM_IRSR_JR_IRS_SHIFT                   (0U)
#define CAAM_IRSR_JR_IRS(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_IRSR_JR_IRS_SHIFT)) & CAAM_IRSR_JR_IRS_MASK)
/*! @} */

/* The count of CAAM_IRSR_JR */
#define CAAM_IRSR_JR_COUNT                       (4U)

/*! @name IRSAR_JR - Input Ring Slots Available Register for Job Ring 0..Input Ring Slots Available Register for Job Ring 3 */
/*! @{ */

#define CAAM_IRSAR_JR_IRSA_MASK                  (0x3FFU)
#define CAAM_IRSAR_JR_IRSA_SHIFT                 (0U)
#define CAAM_IRSAR_JR_IRSA(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_IRSAR_JR_IRSA_SHIFT)) & CAAM_IRSAR_JR_IRSA_MASK)
/*! @} */

/* The count of CAAM_IRSAR_JR */
#define CAAM_IRSAR_JR_COUNT                      (4U)

/*! @name IRJAR_JR - Input Ring Jobs Added Register for Job Ring0..Input Ring Jobs Added Register for Job Ring3 */
/*! @{ */

#define CAAM_IRJAR_JR_IRJA_MASK                  (0x3FFU)
#define CAAM_IRJAR_JR_IRJA_SHIFT                 (0U)
#define CAAM_IRJAR_JR_IRJA(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_IRJAR_JR_IRJA_SHIFT)) & CAAM_IRJAR_JR_IRJA_MASK)
/*! @} */

/* The count of CAAM_IRJAR_JR */
#define CAAM_IRJAR_JR_COUNT                      (4U)

/*! @name ORBAR_JR - Output Ring Base Address Register for Job Ring 0..Output Ring Base Address Register for Job Ring 3 */
/*! @{ */

#define CAAM_ORBAR_JR_ORBA_MASK                  (0xFFFFFFFFFU)
#define CAAM_ORBAR_JR_ORBA_SHIFT                 (0U)
#define CAAM_ORBAR_JR_ORBA(x)                    (((uint64_t)(((uint64_t)(x)) << CAAM_ORBAR_JR_ORBA_SHIFT)) & CAAM_ORBAR_JR_ORBA_MASK)
/*! @} */

/* The count of CAAM_ORBAR_JR */
#define CAAM_ORBAR_JR_COUNT                      (4U)

/*! @name ORSR_JR - Output Ring Size Register for Job Ring 0..Output Ring Size Register for Job Ring 3 */
/*! @{ */

#define CAAM_ORSR_JR_ORS_MASK                    (0x3FFU)
#define CAAM_ORSR_JR_ORS_SHIFT                   (0U)
#define CAAM_ORSR_JR_ORS(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_ORSR_JR_ORS_SHIFT)) & CAAM_ORSR_JR_ORS_MASK)
/*! @} */

/* The count of CAAM_ORSR_JR */
#define CAAM_ORSR_JR_COUNT                       (4U)

/*! @name ORJRR_JR - Output Ring Jobs Removed Register for Job Ring 0..Output Ring Jobs Removed Register for Job Ring 3 */
/*! @{ */

#define CAAM_ORJRR_JR_ORJR_MASK                  (0x3FFU)
#define CAAM_ORJRR_JR_ORJR_SHIFT                 (0U)
#define CAAM_ORJRR_JR_ORJR(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_ORJRR_JR_ORJR_SHIFT)) & CAAM_ORJRR_JR_ORJR_MASK)
/*! @} */

/* The count of CAAM_ORJRR_JR */
#define CAAM_ORJRR_JR_COUNT                      (4U)

/*! @name ORSFR_JR - Output Ring Slots Full Register for Job Ring 0..Output Ring Slots Full Register for Job Ring 3 */
/*! @{ */

#define CAAM_ORSFR_JR_ORSF_MASK                  (0x3FFU)
#define CAAM_ORSFR_JR_ORSF_SHIFT                 (0U)
#define CAAM_ORSFR_JR_ORSF(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_ORSFR_JR_ORSF_SHIFT)) & CAAM_ORSFR_JR_ORSF_MASK)
/*! @} */

/* The count of CAAM_ORSFR_JR */
#define CAAM_ORSFR_JR_COUNT                      (4U)

/*! @name JRSTAR_JR - Job Ring Output Status Register for Job Ring 0..Job Ring Output Status Register for Job Ring 3 */
/*! @{ */

#define CAAM_JRSTAR_JR_SSED_MASK                 (0xFFFFFFFU)
#define CAAM_JRSTAR_JR_SSED_SHIFT                (0U)
#define CAAM_JRSTAR_JR_SSED(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_JRSTAR_JR_SSED_SHIFT)) & CAAM_JRSTAR_JR_SSED_MASK)

#define CAAM_JRSTAR_JR_SSRC_MASK                 (0xF0000000U)
#define CAAM_JRSTAR_JR_SSRC_SHIFT                (28U)
/*! SSRC
 *  0b0000..No Status Source (No Error or Status Reported)
 *  0b0001..Reserved
 *  0b0010..CCB Status Source (CCB Error Reported)
 *  0b0011..Jump Halt User Status Source (User-Provided Status Reported)
 *  0b0100..DECO Status Source (DECO Error Reported)
 *  0b0101..Reserved
 *  0b0110..Job Ring Status Source (Job Ring Error Reported)
 *  0b0111..Jump Halt Condition Codes (Condition Code Status Reported)
 */
#define CAAM_JRSTAR_JR_SSRC(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_JRSTAR_JR_SSRC_SHIFT)) & CAAM_JRSTAR_JR_SSRC_MASK)
/*! @} */

/* The count of CAAM_JRSTAR_JR */
#define CAAM_JRSTAR_JR_COUNT                     (4U)

/*! @name JRINTR_JR - Job Ring Interrupt Status Register for Job Ring 0..Job Ring Interrupt Status Register for Job Ring 3 */
/*! @{ */

#define CAAM_JRINTR_JR_JRI_MASK                  (0x1U)
#define CAAM_JRINTR_JR_JRI_SHIFT                 (0U)
#define CAAM_JRINTR_JR_JRI(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_JRINTR_JR_JRI_SHIFT)) & CAAM_JRINTR_JR_JRI_MASK)

#define CAAM_JRINTR_JR_JRE_MASK                  (0x2U)
#define CAAM_JRINTR_JR_JRE_SHIFT                 (1U)
#define CAAM_JRINTR_JR_JRE(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_JRINTR_JR_JRE_SHIFT)) & CAAM_JRINTR_JR_JRE_MASK)

#define CAAM_JRINTR_JR_HALT_MASK                 (0xCU)
#define CAAM_JRINTR_JR_HALT_SHIFT                (2U)
#define CAAM_JRINTR_JR_HALT(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_JRINTR_JR_HALT_SHIFT)) & CAAM_JRINTR_JR_HALT_MASK)

#define CAAM_JRINTR_JR_ENTER_FAIL_MASK           (0x10U)
#define CAAM_JRINTR_JR_ENTER_FAIL_SHIFT          (4U)
#define CAAM_JRINTR_JR_ENTER_FAIL(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_JRINTR_JR_ENTER_FAIL_SHIFT)) & CAAM_JRINTR_JR_ENTER_FAIL_MASK)

#define CAAM_JRINTR_JR_EXIT_FAIL_MASK            (0x20U)
#define CAAM_JRINTR_JR_EXIT_FAIL_SHIFT           (5U)
#define CAAM_JRINTR_JR_EXIT_FAIL(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_JRINTR_JR_EXIT_FAIL_SHIFT)) & CAAM_JRINTR_JR_EXIT_FAIL_MASK)

#define CAAM_JRINTR_JR_ERR_TYPE_MASK             (0x1F00U)
#define CAAM_JRINTR_JR_ERR_TYPE_SHIFT            (8U)
/*! ERR_TYPE
 *  0b00001..Error writing status to Output Ring
 *  0b00011..Bad input ring base address (not on a 4-byte boundary).
 *  0b00100..Bad output ring base address (not on a 4-byte boundary).
 *  0b00101..Invalid write to Input Ring Base Address Register or Input Ring Size Register. Can be written when
 *           there are no jobs in the input ring or when the Job Ring is halted. These are fatal and will likely
 *           result in not being able to get all jobs out into the output ring for processing by software. Resetting
 *           the job ring will almost certainly be necessary.
 *  0b00110..Invalid write to Output Ring Base Address Register or Output Ring Size Register. Can be written when
 *           there are no jobs in the output ring and no jobs from this queue are already processing in CAAM (in
 *           the holding tanks or DECOs), or when the Job Ring is halted.
 *  0b00111..Job Ring reset released before Job Ring is halted.
 *  0b01000..Removed too many jobs (ORJRR larger than ORSFR).
 *  0b01001..Added too many jobs (IRJAR larger than IRSAR).
 *  0b01010..Writing ORSF > ORS In these error cases the write is ignored, the interrupt is asserted (unless
 *           masked) and the error bit and error_type fields are set in the Job Ring Interrupt Status Register.
 *  0b01011..Writing IRSA > IRS
 *  0b01100..Writing ORWI > ORS in bytes
 *  0b01101..Writing IRRI > IRS in bytes
 *  0b01110..Writing IRSA when ring is active
 *  0b01111..Writing IRRI when ring is active
 *  0b10000..Writing ORSF when ring is active
 *  0b10001..Writing ORWI when ring is active
 */
#define CAAM_JRINTR_JR_ERR_TYPE(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_JRINTR_JR_ERR_TYPE_SHIFT)) & CAAM_JRINTR_JR_ERR_TYPE_MASK)

#define CAAM_JRINTR_JR_ERR_ORWI_MASK             (0x3FFF0000U)
#define CAAM_JRINTR_JR_ERR_ORWI_SHIFT            (16U)
#define CAAM_JRINTR_JR_ERR_ORWI(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_JRINTR_JR_ERR_ORWI_SHIFT)) & CAAM_JRINTR_JR_ERR_ORWI_MASK)
/*! @} */

/* The count of CAAM_JRINTR_JR */
#define CAAM_JRINTR_JR_COUNT                     (4U)

/*! @name JRCFGR_JR_MS - Job Ring Configuration Register for Job Ring 0, most-significant half..Job Ring Configuration Register for Job Ring 3, most-significant half */
/*! @{ */

#define CAAM_JRCFGR_JR_MS_MBSI_MASK              (0x1U)
#define CAAM_JRCFGR_JR_MS_MBSI_SHIFT             (0U)
#define CAAM_JRCFGR_JR_MS_MBSI(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_MBSI_SHIFT)) & CAAM_JRCFGR_JR_MS_MBSI_MASK)

#define CAAM_JRCFGR_JR_MS_MHWSI_MASK             (0x2U)
#define CAAM_JRCFGR_JR_MS_MHWSI_SHIFT            (1U)
#define CAAM_JRCFGR_JR_MS_MHWSI(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_MHWSI_SHIFT)) & CAAM_JRCFGR_JR_MS_MHWSI_MASK)

#define CAAM_JRCFGR_JR_MS_MWSI_MASK              (0x4U)
#define CAAM_JRCFGR_JR_MS_MWSI_SHIFT             (2U)
#define CAAM_JRCFGR_JR_MS_MWSI(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_MWSI_SHIFT)) & CAAM_JRCFGR_JR_MS_MWSI_MASK)

#define CAAM_JRCFGR_JR_MS_CBSI_MASK              (0x10U)
#define CAAM_JRCFGR_JR_MS_CBSI_SHIFT             (4U)
#define CAAM_JRCFGR_JR_MS_CBSI(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_CBSI_SHIFT)) & CAAM_JRCFGR_JR_MS_CBSI_MASK)

#define CAAM_JRCFGR_JR_MS_CHWSI_MASK             (0x20U)
#define CAAM_JRCFGR_JR_MS_CHWSI_SHIFT            (5U)
#define CAAM_JRCFGR_JR_MS_CHWSI(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_CHWSI_SHIFT)) & CAAM_JRCFGR_JR_MS_CHWSI_MASK)

#define CAAM_JRCFGR_JR_MS_CWSI_MASK              (0x40U)
#define CAAM_JRCFGR_JR_MS_CWSI_SHIFT             (6U)
#define CAAM_JRCFGR_JR_MS_CWSI(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_CWSI_SHIFT)) & CAAM_JRCFGR_JR_MS_CWSI_MASK)

#define CAAM_JRCFGR_JR_MS_MBSO_MASK              (0x100U)
#define CAAM_JRCFGR_JR_MS_MBSO_SHIFT             (8U)
#define CAAM_JRCFGR_JR_MS_MBSO(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_MBSO_SHIFT)) & CAAM_JRCFGR_JR_MS_MBSO_MASK)

#define CAAM_JRCFGR_JR_MS_MHWSO_MASK             (0x200U)
#define CAAM_JRCFGR_JR_MS_MHWSO_SHIFT            (9U)
#define CAAM_JRCFGR_JR_MS_MHWSO(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_MHWSO_SHIFT)) & CAAM_JRCFGR_JR_MS_MHWSO_MASK)

#define CAAM_JRCFGR_JR_MS_MWSO_MASK              (0x400U)
#define CAAM_JRCFGR_JR_MS_MWSO_SHIFT             (10U)
#define CAAM_JRCFGR_JR_MS_MWSO(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_MWSO_SHIFT)) & CAAM_JRCFGR_JR_MS_MWSO_MASK)

#define CAAM_JRCFGR_JR_MS_CBSO_MASK              (0x1000U)
#define CAAM_JRCFGR_JR_MS_CBSO_SHIFT             (12U)
#define CAAM_JRCFGR_JR_MS_CBSO(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_CBSO_SHIFT)) & CAAM_JRCFGR_JR_MS_CBSO_MASK)

#define CAAM_JRCFGR_JR_MS_CHWSO_MASK             (0x2000U)
#define CAAM_JRCFGR_JR_MS_CHWSO_SHIFT            (13U)
#define CAAM_JRCFGR_JR_MS_CHWSO(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_CHWSO_SHIFT)) & CAAM_JRCFGR_JR_MS_CHWSO_MASK)

#define CAAM_JRCFGR_JR_MS_CWSO_MASK              (0x4000U)
#define CAAM_JRCFGR_JR_MS_CWSO_SHIFT             (14U)
#define CAAM_JRCFGR_JR_MS_CWSO(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_CWSO_SHIFT)) & CAAM_JRCFGR_JR_MS_CWSO_MASK)

#define CAAM_JRCFGR_JR_MS_DMBS_MASK              (0x10000U)
#define CAAM_JRCFGR_JR_MS_DMBS_SHIFT             (16U)
#define CAAM_JRCFGR_JR_MS_DMBS(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_DMBS_SHIFT)) & CAAM_JRCFGR_JR_MS_DMBS_MASK)

#define CAAM_JRCFGR_JR_MS_PEO_MASK               (0x20000U)
#define CAAM_JRCFGR_JR_MS_PEO_SHIFT              (17U)
#define CAAM_JRCFGR_JR_MS_PEO(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_PEO_SHIFT)) & CAAM_JRCFGR_JR_MS_PEO_MASK)

#define CAAM_JRCFGR_JR_MS_DWSO_MASK              (0x40000U)
#define CAAM_JRCFGR_JR_MS_DWSO_SHIFT             (18U)
#define CAAM_JRCFGR_JR_MS_DWSO(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_DWSO_SHIFT)) & CAAM_JRCFGR_JR_MS_DWSO_MASK)

#define CAAM_JRCFGR_JR_MS_FAIL_MODE_MASK         (0x20000000U)
#define CAAM_JRCFGR_JR_MS_FAIL_MODE_SHIFT        (29U)
#define CAAM_JRCFGR_JR_MS_FAIL_MODE(x)           (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_FAIL_MODE_SHIFT)) & CAAM_JRCFGR_JR_MS_FAIL_MODE_MASK)

#define CAAM_JRCFGR_JR_MS_INCL_SEQ_OUT_MASK      (0x40000000U)
#define CAAM_JRCFGR_JR_MS_INCL_SEQ_OUT_SHIFT     (30U)
#define CAAM_JRCFGR_JR_MS_INCL_SEQ_OUT(x)        (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_MS_INCL_SEQ_OUT_SHIFT)) & CAAM_JRCFGR_JR_MS_INCL_SEQ_OUT_MASK)
/*! @} */

/* The count of CAAM_JRCFGR_JR_MS */
#define CAAM_JRCFGR_JR_MS_COUNT                  (4U)

/*! @name JRCFGR_JR_LS - Job Ring Configuration Register for Job Ring 0, least-significant half..Job Ring Configuration Register for Job Ring 3, least-significant half */
/*! @{ */

#define CAAM_JRCFGR_JR_LS_IMSK_MASK              (0x1U)
#define CAAM_JRCFGR_JR_LS_IMSK_SHIFT             (0U)
/*! IMSK
 *  0b0..Interrupt enabled.
 *  0b1..Interrupt masked.
 */
#define CAAM_JRCFGR_JR_LS_IMSK(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_LS_IMSK_SHIFT)) & CAAM_JRCFGR_JR_LS_IMSK_MASK)

#define CAAM_JRCFGR_JR_LS_ICEN_MASK              (0x2U)
#define CAAM_JRCFGR_JR_LS_ICEN_SHIFT             (1U)
/*! ICEN
 *  0b0..Interrupt coalescing is disabled. If the IMSK bit is cleared, an interrupt is asserted whenever a job is
 *       written to the output ring. ICDCT is ignored. Note that if software removes one or more jobs and clears
 *       the interrupt but the output rings slots full is still greater than 0 (ORSF > 0), then the interrupt will
 *       clear but reassert on the next clock cycle.
 *  0b1..Interrupt coalescing is enabled. If the IMSK bit is cleared, an interrupt is asserted whenever the
 *       threshold number of frames is reached (ICDCT) or when the threshold timer expires (ICTT). Note that if software
 *       removes one or more jobs and clears the interrupt but the interrupt coalescing threshold is still met
 *       (ORSF >= ICDCT), then the interrupt will clear but reassert on the next clock cycle.
 */
#define CAAM_JRCFGR_JR_LS_ICEN(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_LS_ICEN_SHIFT)) & CAAM_JRCFGR_JR_LS_ICEN_MASK)

#define CAAM_JRCFGR_JR_LS_ICDCT_MASK             (0xFF00U)
#define CAAM_JRCFGR_JR_LS_ICDCT_SHIFT            (8U)
#define CAAM_JRCFGR_JR_LS_ICDCT(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_LS_ICDCT_SHIFT)) & CAAM_JRCFGR_JR_LS_ICDCT_MASK)

#define CAAM_JRCFGR_JR_LS_ICTT_MASK              (0xFFFF0000U)
#define CAAM_JRCFGR_JR_LS_ICTT_SHIFT             (16U)
#define CAAM_JRCFGR_JR_LS_ICTT(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_JRCFGR_JR_LS_ICTT_SHIFT)) & CAAM_JRCFGR_JR_LS_ICTT_MASK)
/*! @} */

/* The count of CAAM_JRCFGR_JR_LS */
#define CAAM_JRCFGR_JR_LS_COUNT                  (4U)

/*! @name IRRIR_JR - Input Ring Read Index Register for Job Ring 0..Input Ring Read Index Register for Job Ring 3 */
/*! @{ */

#define CAAM_IRRIR_JR_IRRI_MASK                  (0x1FFFU)
#define CAAM_IRRIR_JR_IRRI_SHIFT                 (0U)
#define CAAM_IRRIR_JR_IRRI(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_IRRIR_JR_IRRI_SHIFT)) & CAAM_IRRIR_JR_IRRI_MASK)
/*! @} */

/* The count of CAAM_IRRIR_JR */
#define CAAM_IRRIR_JR_COUNT                      (4U)

/*! @name ORWIR_JR - Output Ring Write Index Register for Job Ring 0..Output Ring Write Index Register for Job Ring 3 */
/*! @{ */

#define CAAM_ORWIR_JR_ORWI_MASK                  (0x3FFFU)
#define CAAM_ORWIR_JR_ORWI_SHIFT                 (0U)
#define CAAM_ORWIR_JR_ORWI(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_ORWIR_JR_ORWI_SHIFT)) & CAAM_ORWIR_JR_ORWI_MASK)
/*! @} */

/* The count of CAAM_ORWIR_JR */
#define CAAM_ORWIR_JR_COUNT                      (4U)

/*! @name JRCR_JR - Job Ring Command Register for Job Ring 0..Job Ring Command Register for Job Ring 3 */
/*! @{ */

#define CAAM_JRCR_JR_RESET_MASK                  (0x1U)
#define CAAM_JRCR_JR_RESET_SHIFT                 (0U)
#define CAAM_JRCR_JR_RESET(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_JRCR_JR_RESET_SHIFT)) & CAAM_JRCR_JR_RESET_MASK)

#define CAAM_JRCR_JR_PARK_MASK                   (0x2U)
#define CAAM_JRCR_JR_PARK_SHIFT                  (1U)
#define CAAM_JRCR_JR_PARK(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_JRCR_JR_PARK_SHIFT)) & CAAM_JRCR_JR_PARK_MASK)
/*! @} */

/* The count of CAAM_JRCR_JR */
#define CAAM_JRCR_JR_COUNT                       (4U)

/*! @name JRAAV - Job Ring 0 Address-Array Valid Register..Job Ring 3 Address-Array Valid Register */
/*! @{ */

#define CAAM_JRAAV_V0_MASK                       (0x1U)
#define CAAM_JRAAV_V0_SHIFT                      (0U)
#define CAAM_JRAAV_V0(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_JRAAV_V0_SHIFT)) & CAAM_JRAAV_V0_MASK)

#define CAAM_JRAAV_V1_MASK                       (0x2U)
#define CAAM_JRAAV_V1_SHIFT                      (1U)
#define CAAM_JRAAV_V1(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_JRAAV_V1_SHIFT)) & CAAM_JRAAV_V1_MASK)

#define CAAM_JRAAV_V2_MASK                       (0x4U)
#define CAAM_JRAAV_V2_SHIFT                      (2U)
#define CAAM_JRAAV_V2(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_JRAAV_V2_SHIFT)) & CAAM_JRAAV_V2_MASK)

#define CAAM_JRAAV_V3_MASK                       (0x8U)
#define CAAM_JRAAV_V3_SHIFT                      (3U)
#define CAAM_JRAAV_V3(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_JRAAV_V3_SHIFT)) & CAAM_JRAAV_V3_MASK)

#define CAAM_JRAAV_BC_MASK                       (0x80000000U)
#define CAAM_JRAAV_BC_SHIFT                      (31U)
#define CAAM_JRAAV_BC(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_JRAAV_BC_SHIFT)) & CAAM_JRAAV_BC_MASK)
/*! @} */

/* The count of CAAM_JRAAV */
#define CAAM_JRAAV_COUNT                         (4U)

/*! @name JRAAA - Job Ring 0 Address-Array Address 0 Register..Job Ring 3 Address-Array Address 3 Register */
/*! @{ */

#define CAAM_JRAAA_JD_ADDR_MASK                  (0xFFFFFFFFFU)
#define CAAM_JRAAA_JD_ADDR_SHIFT                 (0U)
#define CAAM_JRAAA_JD_ADDR(x)                    (((uint64_t)(((uint64_t)(x)) << CAAM_JRAAA_JD_ADDR_SHIFT)) & CAAM_JRAAA_JD_ADDR_MASK)
/*! @} */

/* The count of CAAM_JRAAA */
#define CAAM_JRAAA_COUNT                         (4U)

/* The count of CAAM_JRAAA */
#define CAAM_JRAAA_COUNT2                        (4U)

/*! @name PX_SDID_JR - Partition 0 SDID register..Partition 15 SDID register */
/*! @{ */

#define CAAM_PX_SDID_JR_SDID_MASK                (0xFFFFU)
#define CAAM_PX_SDID_JR_SDID_SHIFT               (0U)
#define CAAM_PX_SDID_JR_SDID(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SDID_JR_SDID_SHIFT)) & CAAM_PX_SDID_JR_SDID_MASK)
/*! @} */

/* The count of CAAM_PX_SDID_JR */
#define CAAM_PX_SDID_JR_COUNT                    (4U)

/* The count of CAAM_PX_SDID_JR */
#define CAAM_PX_SDID_JR_COUNT2                   (16U)

/*! @name PX_SMAPR_JR - Secure Memory Access Permissions register */
/*! @{ */

#define CAAM_PX_SMAPR_JR_G1_READ_MASK            (0x1U)
#define CAAM_PX_SMAPR_JR_G1_READ_SHIFT           (0U)
/*! G1_READ
 *  0b0..Instruction fetches and reads are prohibited (except that Trusted Descriptor reads (if G1_TDO=1) and
 *       key-reads are always allowed, and exporting Secure Memory Blobs is allowed if G1_SMBLOB=1 or if done by a
 *       Trusted Descriptor and G1_TDO=1).
 *  0b1..Instruction fetches and reads are allowed (but exporting a Secure Memory Blob is prohibited if
 *       G1_SMBLOB=0 and the descriptor is not a Trusted Descriptor or if G1_TDO=0).
 */
#define CAAM_PX_SMAPR_JR_G1_READ(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_JR_G1_READ_SHIFT)) & CAAM_PX_SMAPR_JR_G1_READ_MASK)

#define CAAM_PX_SMAPR_JR_G1_WRITE_MASK           (0x2U)
#define CAAM_PX_SMAPR_JR_G1_WRITE_SHIFT          (1U)
/*! G1_WRITE
 *  0b0..Writes are prohibited (except that Trusted Descriptor writes are allowed, and importing Secure Memory
 *       Blobs is allowed if G1_SMBLOB=1 or if done by a Trusted Descriptor and G1_TDO=1).
 *  0b1..Writes are allowed (but importing a Secure Memory Blob is prohibited if G1_SMBLOB=0 and the descriptor is
 *       not a Trusted Descriptor or if G1_TDO=0).
 */
#define CAAM_PX_SMAPR_JR_G1_WRITE(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_JR_G1_WRITE_SHIFT)) & CAAM_PX_SMAPR_JR_G1_WRITE_MASK)

#define CAAM_PX_SMAPR_JR_G1_TDO_MASK             (0x4U)
#define CAAM_PX_SMAPR_JR_G1_TDO_SHIFT            (2U)
/*! G1_TDO
 *  0b0..Trusted Descriptors have the same access privileges as Job Descriptors
 *  0b1..Trusted Descriptors are allowed to override the other access permissions, i.e. they can export blobs from
 *       or import blobs to the partition and read from and write to the partition regardless of the G1_SMBLOB,
 *       G1_WRITE and G1_READ settings.
 */
#define CAAM_PX_SMAPR_JR_G1_TDO(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_JR_G1_TDO_SHIFT)) & CAAM_PX_SMAPR_JR_G1_TDO_MASK)

#define CAAM_PX_SMAPR_JR_G1_SMBLOB_MASK          (0x8U)
#define CAAM_PX_SMAPR_JR_G1_SMBLOB_SHIFT         (3U)
/*! G1_SMBLOB
 *  0b0..Exporting or importing Secure Memory Blobs is prohibited, unless done via a Trusted Descriptor and G1_TDO=1.
 *  0b1..Exporting or importing Secure Memory Blobs is allowed, regardless of the G1_READ and G1_WRITE settings.
 */
#define CAAM_PX_SMAPR_JR_G1_SMBLOB(x)            (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_JR_G1_SMBLOB_SHIFT)) & CAAM_PX_SMAPR_JR_G1_SMBLOB_MASK)

#define CAAM_PX_SMAPR_JR_G2_READ_MASK            (0x10U)
#define CAAM_PX_SMAPR_JR_G2_READ_SHIFT           (4U)
/*! G2_READ
 *  0b0..Instruction fetches and reads are prohibited (except that Trusted Descriptor reads (if G2_TDO=1) and
 *       key-reads are always allowed, and exporting Secure Memory Blobs is allowed if G2_SMBLOB=1 or if done by a
 *       Trusted Descriptor and G2_TDO=1).
 *  0b1..Instruction fetches and reads are allowed (but exporting a Secure Memory Blob is prohibited if
 *       G2_SMBLOB=0 and the descriptor is not a Trusted Descriptor or if G2_TDO=0).
 */
#define CAAM_PX_SMAPR_JR_G2_READ(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_JR_G2_READ_SHIFT)) & CAAM_PX_SMAPR_JR_G2_READ_MASK)

#define CAAM_PX_SMAPR_JR_G2_WRITE_MASK           (0x20U)
#define CAAM_PX_SMAPR_JR_G2_WRITE_SHIFT          (5U)
/*! G2_WRITE
 *  0b0..Writes are prohibited (except that Trusted Descriptor writes are allowed, and importing Secure Memory
 *       Blobs is allowed if G2_SMBLOB=1 or if done by a Trusted Descriptor and G2_TDO=1).
 *  0b1..Writes are allowed (but importing a Secure Memory Blob is prohibited if G2_SMBLOB=0 and the descriptor is
 *       not a Trusted Descriptor or if G2_TDO=0).
 */
#define CAAM_PX_SMAPR_JR_G2_WRITE(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_JR_G2_WRITE_SHIFT)) & CAAM_PX_SMAPR_JR_G2_WRITE_MASK)

#define CAAM_PX_SMAPR_JR_G2_TDO_MASK             (0x40U)
#define CAAM_PX_SMAPR_JR_G2_TDO_SHIFT            (6U)
/*! G2_TDO
 *  0b0..Trusted Descriptors have the same access privileges as Job Descriptors
 *  0b1..Trusted Descriptors are allowed to override the other access permissions, i.e. they can export blobs from
 *       or import blobs to the partition and read from and write to the partition regardless of the G2_SMBLOB,
 *       G2_WRITE and G2_READ settings.
 */
#define CAAM_PX_SMAPR_JR_G2_TDO(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_JR_G2_TDO_SHIFT)) & CAAM_PX_SMAPR_JR_G2_TDO_MASK)

#define CAAM_PX_SMAPR_JR_G2_SMBLOB_MASK          (0x80U)
#define CAAM_PX_SMAPR_JR_G2_SMBLOB_SHIFT         (7U)
/*! G2_SMBLOB
 *  0b0..Exporting or importing Secure Memory Blobs is prohibited, unless done via a Trusted Descriptor and G2_TDO=1.
 *  0b1..Exporting or importing Secure Memory Blobs is allowed, regardless of the G2_READ and G2_WRITE settings.
 */
#define CAAM_PX_SMAPR_JR_G2_SMBLOB(x)            (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_JR_G2_SMBLOB_SHIFT)) & CAAM_PX_SMAPR_JR_G2_SMBLOB_MASK)

#define CAAM_PX_SMAPR_JR_SMAG_LCK_MASK           (0x1000U)
#define CAAM_PX_SMAPR_JR_SMAG_LCK_SHIFT          (12U)
/*! SMAG_LCK
 *  0b0..The SMAG2JR register and SMAG1JR register are unlocked. The partition owner can change any writable bits of these registers.
 *  0b1..The SMAG2JR register and SMAG1JR register are locked. The SMAG2JR and SMAG1JR registers cannot be changed
 *       until the partition is de-allocated or a POR occurs.
 */
#define CAAM_PX_SMAPR_JR_SMAG_LCK(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_JR_SMAG_LCK_SHIFT)) & CAAM_PX_SMAPR_JR_SMAG_LCK_MASK)

#define CAAM_PX_SMAPR_JR_SMAP_LCK_MASK           (0x2000U)
#define CAAM_PX_SMAPR_JR_SMAP_LCK_SHIFT          (13U)
/*! SMAP_LCK
 *  0b0..The SMAP register is unlocked. The partition owner can change any writable bits of the SMAP register.
 *  0b1..The SMAP register is locked. The SMAP_LCK, CSP and PSP bits and G1 and G2 permission bits of the SMAP
 *       register cannot be changed until the partition is de-allocated or a POR occurs. The PARTITION_KMOD value can
 *       still be changed. The SMAG_LCK bit can be changed to a 1, but cannot be changed to a 0.
 */
#define CAAM_PX_SMAPR_JR_SMAP_LCK(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_JR_SMAP_LCK_SHIFT)) & CAAM_PX_SMAPR_JR_SMAP_LCK_MASK)

#define CAAM_PX_SMAPR_JR_PSP_MASK                (0x4000U)
#define CAAM_PX_SMAPR_JR_PSP_SHIFT               (14U)
/*! PSP
 *  0b0..The partition and any of the pages allocated to the partition can be de-allocated.
 *  0b1..The partition cannot be de-allocated and the pages allocated to the partition cannot be de-allocated.
 */
#define CAAM_PX_SMAPR_JR_PSP(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_JR_PSP_SHIFT)) & CAAM_PX_SMAPR_JR_PSP_MASK)

#define CAAM_PX_SMAPR_JR_CSP_MASK                (0x8000U)
#define CAAM_PX_SMAPR_JR_CSP_SHIFT               (15U)
/*! CSP
 *  0b0..The pages allocated to the partition will not be zeroized when they are de-allocated or the partition is
 *       released or a security alarm occurs.
 *  0b1..The pages allocated to the partition will be zeroized when they are individually de-allocated or the
 *       partition is released or a security alarm occurs.
 */
#define CAAM_PX_SMAPR_JR_CSP(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_JR_CSP_SHIFT)) & CAAM_PX_SMAPR_JR_CSP_MASK)

#define CAAM_PX_SMAPR_JR_PARTITION_KMOD_MASK     (0xFFFF0000U)
#define CAAM_PX_SMAPR_JR_PARTITION_KMOD_SHIFT    (16U)
#define CAAM_PX_SMAPR_JR_PARTITION_KMOD(x)       (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAPR_JR_PARTITION_KMOD_SHIFT)) & CAAM_PX_SMAPR_JR_PARTITION_KMOD_MASK)
/*! @} */

/* The count of CAAM_PX_SMAPR_JR */
#define CAAM_PX_SMAPR_JR_COUNT                   (4U)

/* The count of CAAM_PX_SMAPR_JR */
#define CAAM_PX_SMAPR_JR_COUNT2                  (16U)

/*! @name PX_SMAG2_JR - Secure Memory Access Group Registers */
/*! @{ */

#define CAAM_PX_SMAG2_JR_Gx_ID00_MASK            (0x1U)
#define CAAM_PX_SMAG2_JR_Gx_ID00_SHIFT           (0U)
#define CAAM_PX_SMAG2_JR_Gx_ID00(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID00_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID00_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID01_MASK            (0x2U)
#define CAAM_PX_SMAG2_JR_Gx_ID01_SHIFT           (1U)
#define CAAM_PX_SMAG2_JR_Gx_ID01(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID01_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID01_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID02_MASK            (0x4U)
#define CAAM_PX_SMAG2_JR_Gx_ID02_SHIFT           (2U)
#define CAAM_PX_SMAG2_JR_Gx_ID02(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID02_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID02_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID03_MASK            (0x8U)
#define CAAM_PX_SMAG2_JR_Gx_ID03_SHIFT           (3U)
#define CAAM_PX_SMAG2_JR_Gx_ID03(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID03_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID03_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID04_MASK            (0x10U)
#define CAAM_PX_SMAG2_JR_Gx_ID04_SHIFT           (4U)
#define CAAM_PX_SMAG2_JR_Gx_ID04(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID04_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID04_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID05_MASK            (0x20U)
#define CAAM_PX_SMAG2_JR_Gx_ID05_SHIFT           (5U)
#define CAAM_PX_SMAG2_JR_Gx_ID05(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID05_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID05_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID06_MASK            (0x40U)
#define CAAM_PX_SMAG2_JR_Gx_ID06_SHIFT           (6U)
#define CAAM_PX_SMAG2_JR_Gx_ID06(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID06_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID06_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID07_MASK            (0x80U)
#define CAAM_PX_SMAG2_JR_Gx_ID07_SHIFT           (7U)
#define CAAM_PX_SMAG2_JR_Gx_ID07(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID07_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID07_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID08_MASK            (0x100U)
#define CAAM_PX_SMAG2_JR_Gx_ID08_SHIFT           (8U)
#define CAAM_PX_SMAG2_JR_Gx_ID08(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID08_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID08_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID09_MASK            (0x200U)
#define CAAM_PX_SMAG2_JR_Gx_ID09_SHIFT           (9U)
#define CAAM_PX_SMAG2_JR_Gx_ID09(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID09_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID09_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID10_MASK            (0x400U)
#define CAAM_PX_SMAG2_JR_Gx_ID10_SHIFT           (10U)
#define CAAM_PX_SMAG2_JR_Gx_ID10(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID10_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID10_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID11_MASK            (0x800U)
#define CAAM_PX_SMAG2_JR_Gx_ID11_SHIFT           (11U)
#define CAAM_PX_SMAG2_JR_Gx_ID11(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID11_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID11_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID12_MASK            (0x1000U)
#define CAAM_PX_SMAG2_JR_Gx_ID12_SHIFT           (12U)
#define CAAM_PX_SMAG2_JR_Gx_ID12(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID12_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID12_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID13_MASK            (0x2000U)
#define CAAM_PX_SMAG2_JR_Gx_ID13_SHIFT           (13U)
#define CAAM_PX_SMAG2_JR_Gx_ID13(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID13_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID13_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID14_MASK            (0x4000U)
#define CAAM_PX_SMAG2_JR_Gx_ID14_SHIFT           (14U)
#define CAAM_PX_SMAG2_JR_Gx_ID14(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID14_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID14_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID15_MASK            (0x8000U)
#define CAAM_PX_SMAG2_JR_Gx_ID15_SHIFT           (15U)
#define CAAM_PX_SMAG2_JR_Gx_ID15(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID15_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID15_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID16_MASK            (0x10000U)
#define CAAM_PX_SMAG2_JR_Gx_ID16_SHIFT           (16U)
#define CAAM_PX_SMAG2_JR_Gx_ID16(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID16_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID16_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID17_MASK            (0x20000U)
#define CAAM_PX_SMAG2_JR_Gx_ID17_SHIFT           (17U)
#define CAAM_PX_SMAG2_JR_Gx_ID17(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID17_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID17_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID18_MASK            (0x40000U)
#define CAAM_PX_SMAG2_JR_Gx_ID18_SHIFT           (18U)
#define CAAM_PX_SMAG2_JR_Gx_ID18(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID18_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID18_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID19_MASK            (0x80000U)
#define CAAM_PX_SMAG2_JR_Gx_ID19_SHIFT           (19U)
#define CAAM_PX_SMAG2_JR_Gx_ID19(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID19_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID19_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID20_MASK            (0x100000U)
#define CAAM_PX_SMAG2_JR_Gx_ID20_SHIFT           (20U)
#define CAAM_PX_SMAG2_JR_Gx_ID20(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID20_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID20_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID21_MASK            (0x200000U)
#define CAAM_PX_SMAG2_JR_Gx_ID21_SHIFT           (21U)
#define CAAM_PX_SMAG2_JR_Gx_ID21(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID21_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID21_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID22_MASK            (0x400000U)
#define CAAM_PX_SMAG2_JR_Gx_ID22_SHIFT           (22U)
#define CAAM_PX_SMAG2_JR_Gx_ID22(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID22_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID22_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID23_MASK            (0x800000U)
#define CAAM_PX_SMAG2_JR_Gx_ID23_SHIFT           (23U)
#define CAAM_PX_SMAG2_JR_Gx_ID23(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID23_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID23_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID24_MASK            (0x1000000U)
#define CAAM_PX_SMAG2_JR_Gx_ID24_SHIFT           (24U)
#define CAAM_PX_SMAG2_JR_Gx_ID24(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID24_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID24_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID25_MASK            (0x2000000U)
#define CAAM_PX_SMAG2_JR_Gx_ID25_SHIFT           (25U)
#define CAAM_PX_SMAG2_JR_Gx_ID25(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID25_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID25_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID26_MASK            (0x4000000U)
#define CAAM_PX_SMAG2_JR_Gx_ID26_SHIFT           (26U)
#define CAAM_PX_SMAG2_JR_Gx_ID26(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID26_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID26_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID27_MASK            (0x8000000U)
#define CAAM_PX_SMAG2_JR_Gx_ID27_SHIFT           (27U)
#define CAAM_PX_SMAG2_JR_Gx_ID27(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID27_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID27_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID28_MASK            (0x10000000U)
#define CAAM_PX_SMAG2_JR_Gx_ID28_SHIFT           (28U)
#define CAAM_PX_SMAG2_JR_Gx_ID28(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID28_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID28_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID29_MASK            (0x20000000U)
#define CAAM_PX_SMAG2_JR_Gx_ID29_SHIFT           (29U)
#define CAAM_PX_SMAG2_JR_Gx_ID29(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID29_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID29_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID30_MASK            (0x40000000U)
#define CAAM_PX_SMAG2_JR_Gx_ID30_SHIFT           (30U)
#define CAAM_PX_SMAG2_JR_Gx_ID30(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID30_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID30_MASK)

#define CAAM_PX_SMAG2_JR_Gx_ID31_MASK            (0x80000000U)
#define CAAM_PX_SMAG2_JR_Gx_ID31_SHIFT           (31U)
#define CAAM_PX_SMAG2_JR_Gx_ID31(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG2_JR_Gx_ID31_SHIFT)) & CAAM_PX_SMAG2_JR_Gx_ID31_MASK)
/*! @} */

/* The count of CAAM_PX_SMAG2_JR */
#define CAAM_PX_SMAG2_JR_COUNT                   (4U)

/* The count of CAAM_PX_SMAG2_JR */
#define CAAM_PX_SMAG2_JR_COUNT2                  (16U)

/*! @name PX_SMAG1_JR - Secure Memory Access Group Registers */
/*! @{ */

#define CAAM_PX_SMAG1_JR_Gx_ID00_MASK            (0x1U)
#define CAAM_PX_SMAG1_JR_Gx_ID00_SHIFT           (0U)
#define CAAM_PX_SMAG1_JR_Gx_ID00(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID00_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID00_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID01_MASK            (0x2U)
#define CAAM_PX_SMAG1_JR_Gx_ID01_SHIFT           (1U)
#define CAAM_PX_SMAG1_JR_Gx_ID01(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID01_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID01_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID02_MASK            (0x4U)
#define CAAM_PX_SMAG1_JR_Gx_ID02_SHIFT           (2U)
#define CAAM_PX_SMAG1_JR_Gx_ID02(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID02_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID02_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID03_MASK            (0x8U)
#define CAAM_PX_SMAG1_JR_Gx_ID03_SHIFT           (3U)
#define CAAM_PX_SMAG1_JR_Gx_ID03(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID03_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID03_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID04_MASK            (0x10U)
#define CAAM_PX_SMAG1_JR_Gx_ID04_SHIFT           (4U)
#define CAAM_PX_SMAG1_JR_Gx_ID04(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID04_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID04_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID05_MASK            (0x20U)
#define CAAM_PX_SMAG1_JR_Gx_ID05_SHIFT           (5U)
#define CAAM_PX_SMAG1_JR_Gx_ID05(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID05_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID05_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID06_MASK            (0x40U)
#define CAAM_PX_SMAG1_JR_Gx_ID06_SHIFT           (6U)
#define CAAM_PX_SMAG1_JR_Gx_ID06(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID06_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID06_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID07_MASK            (0x80U)
#define CAAM_PX_SMAG1_JR_Gx_ID07_SHIFT           (7U)
#define CAAM_PX_SMAG1_JR_Gx_ID07(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID07_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID07_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID08_MASK            (0x100U)
#define CAAM_PX_SMAG1_JR_Gx_ID08_SHIFT           (8U)
#define CAAM_PX_SMAG1_JR_Gx_ID08(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID08_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID08_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID09_MASK            (0x200U)
#define CAAM_PX_SMAG1_JR_Gx_ID09_SHIFT           (9U)
#define CAAM_PX_SMAG1_JR_Gx_ID09(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID09_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID09_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID10_MASK            (0x400U)
#define CAAM_PX_SMAG1_JR_Gx_ID10_SHIFT           (10U)
#define CAAM_PX_SMAG1_JR_Gx_ID10(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID10_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID10_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID11_MASK            (0x800U)
#define CAAM_PX_SMAG1_JR_Gx_ID11_SHIFT           (11U)
#define CAAM_PX_SMAG1_JR_Gx_ID11(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID11_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID11_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID12_MASK            (0x1000U)
#define CAAM_PX_SMAG1_JR_Gx_ID12_SHIFT           (12U)
#define CAAM_PX_SMAG1_JR_Gx_ID12(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID12_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID12_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID13_MASK            (0x2000U)
#define CAAM_PX_SMAG1_JR_Gx_ID13_SHIFT           (13U)
#define CAAM_PX_SMAG1_JR_Gx_ID13(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID13_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID13_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID14_MASK            (0x4000U)
#define CAAM_PX_SMAG1_JR_Gx_ID14_SHIFT           (14U)
#define CAAM_PX_SMAG1_JR_Gx_ID14(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID14_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID14_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID15_MASK            (0x8000U)
#define CAAM_PX_SMAG1_JR_Gx_ID15_SHIFT           (15U)
#define CAAM_PX_SMAG1_JR_Gx_ID15(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID15_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID15_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID16_MASK            (0x10000U)
#define CAAM_PX_SMAG1_JR_Gx_ID16_SHIFT           (16U)
#define CAAM_PX_SMAG1_JR_Gx_ID16(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID16_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID16_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID17_MASK            (0x20000U)
#define CAAM_PX_SMAG1_JR_Gx_ID17_SHIFT           (17U)
#define CAAM_PX_SMAG1_JR_Gx_ID17(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID17_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID17_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID18_MASK            (0x40000U)
#define CAAM_PX_SMAG1_JR_Gx_ID18_SHIFT           (18U)
#define CAAM_PX_SMAG1_JR_Gx_ID18(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID18_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID18_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID19_MASK            (0x80000U)
#define CAAM_PX_SMAG1_JR_Gx_ID19_SHIFT           (19U)
#define CAAM_PX_SMAG1_JR_Gx_ID19(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID19_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID19_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID20_MASK            (0x100000U)
#define CAAM_PX_SMAG1_JR_Gx_ID20_SHIFT           (20U)
#define CAAM_PX_SMAG1_JR_Gx_ID20(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID20_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID20_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID21_MASK            (0x200000U)
#define CAAM_PX_SMAG1_JR_Gx_ID21_SHIFT           (21U)
#define CAAM_PX_SMAG1_JR_Gx_ID21(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID21_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID21_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID22_MASK            (0x400000U)
#define CAAM_PX_SMAG1_JR_Gx_ID22_SHIFT           (22U)
#define CAAM_PX_SMAG1_JR_Gx_ID22(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID22_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID22_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID23_MASK            (0x800000U)
#define CAAM_PX_SMAG1_JR_Gx_ID23_SHIFT           (23U)
#define CAAM_PX_SMAG1_JR_Gx_ID23(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID23_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID23_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID24_MASK            (0x1000000U)
#define CAAM_PX_SMAG1_JR_Gx_ID24_SHIFT           (24U)
#define CAAM_PX_SMAG1_JR_Gx_ID24(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID24_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID24_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID25_MASK            (0x2000000U)
#define CAAM_PX_SMAG1_JR_Gx_ID25_SHIFT           (25U)
#define CAAM_PX_SMAG1_JR_Gx_ID25(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID25_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID25_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID26_MASK            (0x4000000U)
#define CAAM_PX_SMAG1_JR_Gx_ID26_SHIFT           (26U)
#define CAAM_PX_SMAG1_JR_Gx_ID26(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID26_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID26_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID27_MASK            (0x8000000U)
#define CAAM_PX_SMAG1_JR_Gx_ID27_SHIFT           (27U)
#define CAAM_PX_SMAG1_JR_Gx_ID27(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID27_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID27_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID28_MASK            (0x10000000U)
#define CAAM_PX_SMAG1_JR_Gx_ID28_SHIFT           (28U)
#define CAAM_PX_SMAG1_JR_Gx_ID28(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID28_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID28_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID29_MASK            (0x20000000U)
#define CAAM_PX_SMAG1_JR_Gx_ID29_SHIFT           (29U)
#define CAAM_PX_SMAG1_JR_Gx_ID29(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID29_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID29_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID30_MASK            (0x40000000U)
#define CAAM_PX_SMAG1_JR_Gx_ID30_SHIFT           (30U)
#define CAAM_PX_SMAG1_JR_Gx_ID30(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID30_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID30_MASK)

#define CAAM_PX_SMAG1_JR_Gx_ID31_MASK            (0x80000000U)
#define CAAM_PX_SMAG1_JR_Gx_ID31_SHIFT           (31U)
#define CAAM_PX_SMAG1_JR_Gx_ID31(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_PX_SMAG1_JR_Gx_ID31_SHIFT)) & CAAM_PX_SMAG1_JR_Gx_ID31_MASK)
/*! @} */

/* The count of CAAM_PX_SMAG1_JR */
#define CAAM_PX_SMAG1_JR_COUNT                   (4U)

/* The count of CAAM_PX_SMAG1_JR */
#define CAAM_PX_SMAG1_JR_COUNT2                  (16U)

/*! @name SMCR_JR - Secure Memory Command Register */
/*! @{ */

#define CAAM_SMCR_JR_CMD_MASK                    (0xFU)
#define CAAM_SMCR_JR_CMD_SHIFT                   (0U)
#define CAAM_SMCR_JR_CMD(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_SMCR_JR_CMD_SHIFT)) & CAAM_SMCR_JR_CMD_MASK)

#define CAAM_SMCR_JR_PRTN_MASK                   (0xF00U)
#define CAAM_SMCR_JR_PRTN_SHIFT                  (8U)
#define CAAM_SMCR_JR_PRTN(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_SMCR_JR_PRTN_SHIFT)) & CAAM_SMCR_JR_PRTN_MASK)

#define CAAM_SMCR_JR_PAGE_MASK                   (0xFFFF0000U)
#define CAAM_SMCR_JR_PAGE_SHIFT                  (16U)
#define CAAM_SMCR_JR_PAGE(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_SMCR_JR_PAGE_SHIFT)) & CAAM_SMCR_JR_PAGE_MASK)
/*! @} */

/* The count of CAAM_SMCR_JR */
#define CAAM_SMCR_JR_COUNT                       (4U)

/*! @name SMCSR_JR - Secure Memory Command Status Register */
/*! @{ */

#define CAAM_SMCSR_JR_PRTN_MASK                  (0xFU)
#define CAAM_SMCSR_JR_PRTN_SHIFT                 (0U)
#define CAAM_SMCSR_JR_PRTN(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_SMCSR_JR_PRTN_SHIFT)) & CAAM_SMCSR_JR_PRTN_MASK)

#define CAAM_SMCSR_JR_PO_MASK                    (0xC0U)
#define CAAM_SMCSR_JR_PO_SHIFT                   (6U)
/*! PO
 *  0b00..Available; Unowned: The entity that issued the inquiry may allocate this page to a partition. No
 *        zeroization is needed since it has already been cleared, therefore no interrupt should be expected.
 *  0b01..Page does not exist in this version or is not initialized yet.
 *  0b10..Another entity owns the page. This page is unavailable to the issuer of the inquiry.
 *  0b11..Owned by the entity making the inquiry. The owner may de-allocate this page if its partition is not
 *        marked PSP. If the partition to which the page is allocated is designated as CSP, the page will be zeroized
 *        upon de-allocation.
 */
#define CAAM_SMCSR_JR_PO(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_SMCSR_JR_PO_SHIFT)) & CAAM_SMCSR_JR_PO_MASK)

#define CAAM_SMCSR_JR_AERR_MASK                  (0x3000U)
#define CAAM_SMCSR_JR_AERR_SHIFT                 (12U)
#define CAAM_SMCSR_JR_AERR(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_SMCSR_JR_AERR_SHIFT)) & CAAM_SMCSR_JR_AERR_MASK)

#define CAAM_SMCSR_JR_CERR_MASK                  (0xC000U)
#define CAAM_SMCSR_JR_CERR_SHIFT                 (14U)
/*! CERR
 *  0b00..No Error.
 *  0b01..Command has not yet completed.
 *  0b10..A security failure occurred.
 *  0b11..Command Overflow. Another command was issued by the same Job Ring owner before the owner's previous
 *        command completed. The additional command was ignored.
 */
#define CAAM_SMCSR_JR_CERR(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_SMCSR_JR_CERR_SHIFT)) & CAAM_SMCSR_JR_CERR_MASK)

#define CAAM_SMCSR_JR_PAGE_MASK                  (0xFFF0000U)
#define CAAM_SMCSR_JR_PAGE_SHIFT                 (16U)
#define CAAM_SMCSR_JR_PAGE(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_SMCSR_JR_PAGE_SHIFT)) & CAAM_SMCSR_JR_PAGE_MASK)
/*! @} */

/* The count of CAAM_SMCSR_JR */
#define CAAM_SMCSR_JR_COUNT                      (4U)

/*! @name REIR0JR - Recoverable Error Interrupt Record 0 for Job Ring 0..Recoverable Error Interrupt Record 0 for Job Ring 3 */
/*! @{ */

#define CAAM_REIR0JR_TYPE_MASK                   (0x3000000U)
#define CAAM_REIR0JR_TYPE_SHIFT                  (24U)
#define CAAM_REIR0JR_TYPE(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_REIR0JR_TYPE_SHIFT)) & CAAM_REIR0JR_TYPE_MASK)

#define CAAM_REIR0JR_MISS_MASK                   (0x80000000U)
#define CAAM_REIR0JR_MISS_SHIFT                  (31U)
#define CAAM_REIR0JR_MISS(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_REIR0JR_MISS_SHIFT)) & CAAM_REIR0JR_MISS_MASK)
/*! @} */

/* The count of CAAM_REIR0JR */
#define CAAM_REIR0JR_COUNT                       (4U)

/*! @name REIR2JR - Recoverable Error Interrupt Record 2 for Job Ring 0..Recoverable Error Interrupt Record 2 for Job Ring 3 */
/*! @{ */

#define CAAM_REIR2JR_ADDR_MASK                   (0xFFFFFFFFFU)
#define CAAM_REIR2JR_ADDR_SHIFT                  (0U)
#define CAAM_REIR2JR_ADDR(x)                     (((uint64_t)(((uint64_t)(x)) << CAAM_REIR2JR_ADDR_SHIFT)) & CAAM_REIR2JR_ADDR_MASK)
/*! @} */

/* The count of CAAM_REIR2JR */
#define CAAM_REIR2JR_COUNT                       (4U)

/*! @name REIR4JR - Recoverable Error Interrupt Record 4 for Job Ring 0..Recoverable Error Interrupt Record 4 for Job Ring 3 */
/*! @{ */

#define CAAM_REIR4JR_ICID_MASK                   (0x7FFU)
#define CAAM_REIR4JR_ICID_SHIFT                  (0U)
#define CAAM_REIR4JR_ICID(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_REIR4JR_ICID_SHIFT)) & CAAM_REIR4JR_ICID_MASK)

#define CAAM_REIR4JR_DID_MASK                    (0x7800U)
#define CAAM_REIR4JR_DID_SHIFT                   (11U)
#define CAAM_REIR4JR_DID(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_REIR4JR_DID_SHIFT)) & CAAM_REIR4JR_DID_MASK)

#define CAAM_REIR4JR_AXCACHE_MASK                (0xF0000U)
#define CAAM_REIR4JR_AXCACHE_SHIFT               (16U)
#define CAAM_REIR4JR_AXCACHE(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_REIR4JR_AXCACHE_SHIFT)) & CAAM_REIR4JR_AXCACHE_MASK)

#define CAAM_REIR4JR_AXPROT_MASK                 (0x700000U)
#define CAAM_REIR4JR_AXPROT_SHIFT                (20U)
#define CAAM_REIR4JR_AXPROT(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_REIR4JR_AXPROT_SHIFT)) & CAAM_REIR4JR_AXPROT_MASK)

#define CAAM_REIR4JR_RWB_MASK                    (0x800000U)
#define CAAM_REIR4JR_RWB_SHIFT                   (23U)
#define CAAM_REIR4JR_RWB(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_REIR4JR_RWB_SHIFT)) & CAAM_REIR4JR_RWB_MASK)

#define CAAM_REIR4JR_ERR_MASK                    (0x30000000U)
#define CAAM_REIR4JR_ERR_SHIFT                   (28U)
#define CAAM_REIR4JR_ERR(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_REIR4JR_ERR_SHIFT)) & CAAM_REIR4JR_ERR_MASK)

#define CAAM_REIR4JR_MIX_MASK                    (0xC0000000U)
#define CAAM_REIR4JR_MIX_SHIFT                   (30U)
#define CAAM_REIR4JR_MIX(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_REIR4JR_MIX_SHIFT)) & CAAM_REIR4JR_MIX_MASK)
/*! @} */

/* The count of CAAM_REIR4JR */
#define CAAM_REIR4JR_COUNT                       (4U)

/*! @name REIR5JR - Recoverable Error Interrupt Record 5 for Job Ring 0..Recoverable Error Interrupt Record 5 for Job Ring 3 */
/*! @{ */

#define CAAM_REIR5JR_BID_MASK                    (0xF0000U)
#define CAAM_REIR5JR_BID_SHIFT                   (16U)
#define CAAM_REIR5JR_BID(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_REIR5JR_BID_SHIFT)) & CAAM_REIR5JR_BID_MASK)

#define CAAM_REIR5JR_BNDG_MASK                   (0x2000000U)
#define CAAM_REIR5JR_BNDG_SHIFT                  (25U)
#define CAAM_REIR5JR_BNDG(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_REIR5JR_BNDG_SHIFT)) & CAAM_REIR5JR_BNDG_MASK)

#define CAAM_REIR5JR_TDSC_MASK                   (0x4000000U)
#define CAAM_REIR5JR_TDSC_SHIFT                  (26U)
#define CAAM_REIR5JR_TDSC(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_REIR5JR_TDSC_SHIFT)) & CAAM_REIR5JR_TDSC_MASK)

#define CAAM_REIR5JR_KMOD_MASK                   (0x8000000U)
#define CAAM_REIR5JR_KMOD_SHIFT                  (27U)
#define CAAM_REIR5JR_KMOD(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_REIR5JR_KMOD_SHIFT)) & CAAM_REIR5JR_KMOD_MASK)

#define CAAM_REIR5JR_KEY_MASK                    (0x10000000U)
#define CAAM_REIR5JR_KEY_SHIFT                   (28U)
#define CAAM_REIR5JR_KEY(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_REIR5JR_KEY_SHIFT)) & CAAM_REIR5JR_KEY_MASK)

#define CAAM_REIR5JR_SMA_MASK                    (0x20000000U)
#define CAAM_REIR5JR_SMA_SHIFT                   (29U)
#define CAAM_REIR5JR_SMA(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_REIR5JR_SMA_SHIFT)) & CAAM_REIR5JR_SMA_MASK)
/*! @} */

/* The count of CAAM_REIR5JR */
#define CAAM_REIR5JR_COUNT                       (4U)

/*! @name RSTA - RTIC Status Register */
/*! @{ */

#define CAAM_RSTA_BSY_MASK                       (0x1U)
#define CAAM_RSTA_BSY_SHIFT                      (0U)
/*! BSY
 *  0b0..RTIC Idle.
 *  0b1..RTIC Busy.
 */
#define CAAM_RSTA_BSY(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_RSTA_BSY_SHIFT)) & CAAM_RSTA_BSY_MASK)

#define CAAM_RSTA_HD_MASK                        (0x2U)
#define CAAM_RSTA_HD_SHIFT                       (1U)
/*! HD
 *  0b0..Boot authentication disabled
 *  0b1..Authenticate code/generate reference hash value. This bit cannot be modified during run-time checking mode.
 */
#define CAAM_RSTA_HD(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_RSTA_HD_SHIFT)) & CAAM_RSTA_HD_MASK)

#define CAAM_RSTA_SV_MASK                        (0x4U)
#define CAAM_RSTA_SV_SHIFT                       (2U)
/*! SV
 *  0b0..Memory block contents authenticated.
 *  0b1..Memory block hash doesn't match reference value.
 */
#define CAAM_RSTA_SV(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_RSTA_SV_SHIFT)) & CAAM_RSTA_SV_MASK)

#define CAAM_RSTA_HE_MASK                        (0x8U)
#define CAAM_RSTA_HE_SHIFT                       (3U)
/*! HE
 *  0b0..Memory block contents authenticated.
 *  0b1..Memory block hash doesn't match reference value.
 */
#define CAAM_RSTA_HE(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_RSTA_HE_SHIFT)) & CAAM_RSTA_HE_MASK)

#define CAAM_RSTA_MIS_MASK                       (0xF0U)
#define CAAM_RSTA_MIS_SHIFT                      (4U)
/*! MIS
 *  0b0000..Memory Block X is valid or state unknown
 *  0b0001..Memory Block X has been corrupted
 */
#define CAAM_RSTA_MIS(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_RSTA_MIS_SHIFT)) & CAAM_RSTA_MIS_MASK)

#define CAAM_RSTA_AE_MASK                        (0xF00U)
#define CAAM_RSTA_AE_SHIFT                       (8U)
/*! AE
 *  0b0000..All reads by RTIC were valid.
 *  0b0001..An illegal address was accessed by the RTIC
 */
#define CAAM_RSTA_AE(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_RSTA_AE_SHIFT)) & CAAM_RSTA_AE_MASK)

#define CAAM_RSTA_WE_MASK                        (0x10000U)
#define CAAM_RSTA_WE_SHIFT                       (16U)
/*! WE
 *  0b0..No RTIC Watchdog timer error has occurred.
 *  0b1..RTIC Watchdog timer has expired prior to completing a round of hashing.
 */
#define CAAM_RSTA_WE(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_RSTA_WE_SHIFT)) & CAAM_RSTA_WE_MASK)

#define CAAM_RSTA_ABH_MASK                       (0x20000U)
#define CAAM_RSTA_ABH_SHIFT                      (17U)
#define CAAM_RSTA_ABH(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_RSTA_ABH_SHIFT)) & CAAM_RSTA_ABH_MASK)

#define CAAM_RSTA_HOD_MASK                       (0x40000U)
#define CAAM_RSTA_HOD_SHIFT                      (18U)
#define CAAM_RSTA_HOD(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_RSTA_HOD_SHIFT)) & CAAM_RSTA_HOD_MASK)

#define CAAM_RSTA_RTD_MASK                       (0x80000U)
#define CAAM_RSTA_RTD_SHIFT                      (19U)
#define CAAM_RSTA_RTD(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_RSTA_RTD_SHIFT)) & CAAM_RSTA_RTD_MASK)

#define CAAM_RSTA_CS_MASK                        (0x6000000U)
#define CAAM_RSTA_CS_SHIFT                       (25U)
/*! CS
 *  0b00..Idle State
 *  0b01..Single Hash State
 *  0b10..Run-time State
 *  0b11..Error State
 */
#define CAAM_RSTA_CS(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_RSTA_CS_SHIFT)) & CAAM_RSTA_CS_MASK)
/*! @} */

/*! @name RCMD - RTIC Command Register */
/*! @{ */

#define CAAM_RCMD_CINT_MASK                      (0x1U)
#define CAAM_RCMD_CINT_SHIFT                     (0U)
/*! CINT
 *  0b0..Do not clear interrupt
 *  0b1..Clear interrupt. This bit cannot be modified during run-time checking mode
 */
#define CAAM_RCMD_CINT(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_RCMD_CINT_SHIFT)) & CAAM_RCMD_CINT_MASK)

#define CAAM_RCMD_HO_MASK                        (0x2U)
#define CAAM_RCMD_HO_SHIFT                       (1U)
/*! HO
 *  0b0..Boot authentication disabled
 *  0b1..Authenticate code/generate reference hash value. This bit cannot be modified during run-time checking mode.
 */
#define CAAM_RCMD_HO(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_RCMD_HO_SHIFT)) & CAAM_RCMD_HO_MASK)

#define CAAM_RCMD_RTC_MASK                       (0x4U)
#define CAAM_RCMD_RTC_SHIFT                      (2U)
/*! RTC
 *  0b0..Run-time checking disabled
 *  0b1..Verify run-time memory blocks continually
 */
#define CAAM_RCMD_RTC(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_RCMD_RTC_SHIFT)) & CAAM_RCMD_RTC_MASK)

#define CAAM_RCMD_RTD_MASK                       (0x8U)
#define CAAM_RCMD_RTD_SHIFT                      (3U)
/*! RTD
 *  0b0..Allow Run Time Mode
 *  0b1..Prevent Run Time Mode
 */
#define CAAM_RCMD_RTD(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_RCMD_RTD_SHIFT)) & CAAM_RCMD_RTD_MASK)
/*! @} */

/*! @name RCTL - RTIC Control Register */
/*! @{ */

#define CAAM_RCTL_IE_MASK                        (0x1U)
#define CAAM_RCTL_IE_SHIFT                       (0U)
/*! IE
 *  0b0..Interrupts disabled
 *  0b1..Interrupts enabled
 */
#define CAAM_RCTL_IE(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_RCTL_IE_SHIFT)) & CAAM_RCTL_IE_MASK)

#define CAAM_RCTL_RREQS_MASK                     (0xEU)
#define CAAM_RCTL_RREQS_SHIFT                    (1U)
#define CAAM_RCTL_RREQS(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_RCTL_RREQS_SHIFT)) & CAAM_RCTL_RREQS_MASK)

#define CAAM_RCTL_HOME_MASK                      (0xF0U)
#define CAAM_RCTL_HOME_SHIFT                     (4U)
#define CAAM_RCTL_HOME(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_RCTL_HOME_SHIFT)) & CAAM_RCTL_HOME_MASK)

#define CAAM_RCTL_RTME_MASK                      (0xF00U)
#define CAAM_RCTL_RTME_SHIFT                     (8U)
#define CAAM_RCTL_RTME(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_RCTL_RTME_SHIFT)) & CAAM_RCTL_RTME_MASK)

#define CAAM_RCTL_RTMU_MASK                      (0xF000U)
#define CAAM_RCTL_RTMU_SHIFT                     (12U)
#define CAAM_RCTL_RTMU(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_RCTL_RTMU_SHIFT)) & CAAM_RCTL_RTMU_MASK)

#define CAAM_RCTL_RALG_MASK                      (0xF0000U)
#define CAAM_RCTL_RALG_SHIFT                     (16U)
#define CAAM_RCTL_RALG(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_RCTL_RALG_SHIFT)) & CAAM_RCTL_RALG_MASK)

#define CAAM_RCTL_RIDLE_MASK                     (0x100000U)
#define CAAM_RCTL_RIDLE_SHIFT                    (20U)
#define CAAM_RCTL_RIDLE(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_RCTL_RIDLE_SHIFT)) & CAAM_RCTL_RIDLE_MASK)
/*! @} */

/*! @name RTHR - RTIC Throttle Register */
/*! @{ */

#define CAAM_RTHR_RTHR_MASK                      (0xFFFFU)
#define CAAM_RTHR_RTHR_SHIFT                     (0U)
#define CAAM_RTHR_RTHR(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_RTHR_RTHR_SHIFT)) & CAAM_RTHR_RTHR_MASK)
/*! @} */

/*! @name RWDOG - RTIC Watchdog Timer */
/*! @{ */

#define CAAM_RWDOG_RWDOG_MASK                    (0xFFFFFFFFU)
#define CAAM_RWDOG_RWDOG_SHIFT                   (0U)
#define CAAM_RWDOG_RWDOG(x)                      (((uint64_t)(((uint64_t)(x)) << CAAM_RWDOG_RWDOG_SHIFT)) & CAAM_RWDOG_RWDOG_MASK)
/*! @} */

/*! @name REND - RTIC Endian Register */
/*! @{ */

#define CAAM_REND_REPO_MASK                      (0xFU)
#define CAAM_REND_REPO_SHIFT                     (0U)
/*! REPO
 *  0bxxx1..Byte Swap Memory Block A
 *  0bxx1x..Byte Swap Memory Block B
 *  0bx1xx..Byte Swap Memory Block C
 *  0b1xxx..Byte Swap Memory Block D
 */
#define CAAM_REND_REPO(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_REND_REPO_SHIFT)) & CAAM_REND_REPO_MASK)

#define CAAM_REND_RBS_MASK                       (0xF0U)
#define CAAM_REND_RBS_SHIFT                      (4U)
/*! RBS
 *  0bxxx1..Byte Swap Memory Block A
 *  0bxx1x..Byte Swap Memory Block B
 *  0bx1xx..Byte Swap Memory Block C
 *  0b1xxx..Byte Swap Memory Block D
 */
#define CAAM_REND_RBS(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_REND_RBS_SHIFT)) & CAAM_REND_RBS_MASK)

#define CAAM_REND_RHWS_MASK                      (0xF00U)
#define CAAM_REND_RHWS_SHIFT                     (8U)
/*! RHWS
 *  0bxxx1..Half-Word Swap Memory Block A
 *  0bxx1x..Half-Word Swap Memory Block B
 *  0bx1xx..Half-Word Swap Memory Block C
 *  0b1xxx..Half-Word Swap Memory Block D
 */
#define CAAM_REND_RHWS(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_REND_RHWS_SHIFT)) & CAAM_REND_RHWS_MASK)

#define CAAM_REND_RWS_MASK                       (0xF000U)
#define CAAM_REND_RWS_SHIFT                      (12U)
/*! RWS
 *  0bxxx1..Word Swap Memory Block A
 *  0bxx1x..Word Swap Memory Block B
 *  0bx1xx..Word Swap Memory Block C
 *  0b1xxx..Word Swap Memory Block D
 */
#define CAAM_REND_RWS(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_REND_RWS_SHIFT)) & CAAM_REND_RWS_MASK)
/*! @} */

/*! @name RMA - RTIC Memory Block A Address 0 Register..RTIC Memory Block D Address 1 Register */
/*! @{ */

#define CAAM_RMA_MEMBLKADDR_MASK                 (0xFFFFFFFFFU)
#define CAAM_RMA_MEMBLKADDR_SHIFT                (0U)
#define CAAM_RMA_MEMBLKADDR(x)                   (((uint64_t)(((uint64_t)(x)) << CAAM_RMA_MEMBLKADDR_SHIFT)) & CAAM_RMA_MEMBLKADDR_MASK)
/*! @} */

/* The count of CAAM_RMA */
#define CAAM_RMA_COUNT                           (4U)

/* The count of CAAM_RMA */
#define CAAM_RMA_COUNT2                          (2U)

/*! @name RML - RTIC Memory Block A Length 0 Register..RTIC Memory Block D Length 1 Register */
/*! @{ */

#define CAAM_RML_MEMBLKLEN_MASK                  (0xFFFFFFFFU)
#define CAAM_RML_MEMBLKLEN_SHIFT                 (0U)
#define CAAM_RML_MEMBLKLEN(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_RML_MEMBLKLEN_SHIFT)) & CAAM_RML_MEMBLKLEN_MASK)
/*! @} */

/* The count of CAAM_RML */
#define CAAM_RML_COUNT                           (4U)

/* The count of CAAM_RML */
#define CAAM_RML_COUNT2                          (2U)

/*! @name RMD - RTIC Memory Block A Big Endian Hash Result Word 0..RTIC Memory Block D Little Endian Hash Result Word 31 */
/*! @{ */

#define CAAM_RMD_RTIC_Hash_Result_MASK           (0xFFFFFFFFU)
#define CAAM_RMD_RTIC_Hash_Result_SHIFT          (0U)
#define CAAM_RMD_RTIC_Hash_Result(x)             (((uint32_t)(((uint32_t)(x)) << CAAM_RMD_RTIC_Hash_Result_SHIFT)) & CAAM_RMD_RTIC_Hash_Result_MASK)
/*! @} */

/* The count of CAAM_RMD */
#define CAAM_RMD_COUNT                           (4U)

/* The count of CAAM_RMD */
#define CAAM_RMD_COUNT2                          (2U)

/* The count of CAAM_RMD */
#define CAAM_RMD_COUNT3                          (32U)

/*! @name REIR0RTIC - Recoverable Error Interrupt Record 0 for RTIC */
/*! @{ */

#define CAAM_REIR0RTIC_TYPE_MASK                 (0x3000000U)
#define CAAM_REIR0RTIC_TYPE_SHIFT                (24U)
#define CAAM_REIR0RTIC_TYPE(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_REIR0RTIC_TYPE_SHIFT)) & CAAM_REIR0RTIC_TYPE_MASK)

#define CAAM_REIR0RTIC_MISS_MASK                 (0x80000000U)
#define CAAM_REIR0RTIC_MISS_SHIFT                (31U)
#define CAAM_REIR0RTIC_MISS(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_REIR0RTIC_MISS_SHIFT)) & CAAM_REIR0RTIC_MISS_MASK)
/*! @} */

/*! @name REIR2RTIC - Recoverable Error Interrupt Record 2 for RTIC */
/*! @{ */

#define CAAM_REIR2RTIC_ADDR_MASK                 (0xFFFFFFFFFFFFFFFFU)
#define CAAM_REIR2RTIC_ADDR_SHIFT                (0U)
#define CAAM_REIR2RTIC_ADDR(x)                   (((uint64_t)(((uint64_t)(x)) << CAAM_REIR2RTIC_ADDR_SHIFT)) & CAAM_REIR2RTIC_ADDR_MASK)
/*! @} */

/*! @name REIR4RTIC - Recoverable Error Interrupt Record 4 for RTIC */
/*! @{ */

#define CAAM_REIR4RTIC_ICID_MASK                 (0x7FFU)
#define CAAM_REIR4RTIC_ICID_SHIFT                (0U)
#define CAAM_REIR4RTIC_ICID(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_REIR4RTIC_ICID_SHIFT)) & CAAM_REIR4RTIC_ICID_MASK)

#define CAAM_REIR4RTIC_DID_MASK                  (0x7800U)
#define CAAM_REIR4RTIC_DID_SHIFT                 (11U)
#define CAAM_REIR4RTIC_DID(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_REIR4RTIC_DID_SHIFT)) & CAAM_REIR4RTIC_DID_MASK)

#define CAAM_REIR4RTIC_AXCACHE_MASK              (0xF0000U)
#define CAAM_REIR4RTIC_AXCACHE_SHIFT             (16U)
#define CAAM_REIR4RTIC_AXCACHE(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_REIR4RTIC_AXCACHE_SHIFT)) & CAAM_REIR4RTIC_AXCACHE_MASK)

#define CAAM_REIR4RTIC_AXPROT_MASK               (0x700000U)
#define CAAM_REIR4RTIC_AXPROT_SHIFT              (20U)
#define CAAM_REIR4RTIC_AXPROT(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_REIR4RTIC_AXPROT_SHIFT)) & CAAM_REIR4RTIC_AXPROT_MASK)

#define CAAM_REIR4RTIC_RWB_MASK                  (0x800000U)
#define CAAM_REIR4RTIC_RWB_SHIFT                 (23U)
#define CAAM_REIR4RTIC_RWB(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_REIR4RTIC_RWB_SHIFT)) & CAAM_REIR4RTIC_RWB_MASK)

#define CAAM_REIR4RTIC_ERR_MASK                  (0x30000000U)
#define CAAM_REIR4RTIC_ERR_SHIFT                 (28U)
#define CAAM_REIR4RTIC_ERR(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_REIR4RTIC_ERR_SHIFT)) & CAAM_REIR4RTIC_ERR_MASK)

#define CAAM_REIR4RTIC_MIX_MASK                  (0xC0000000U)
#define CAAM_REIR4RTIC_MIX_SHIFT                 (30U)
#define CAAM_REIR4RTIC_MIX(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_REIR4RTIC_MIX_SHIFT)) & CAAM_REIR4RTIC_MIX_MASK)
/*! @} */

/*! @name REIR5RTIC - Recoverable Error Interrupt Record 5 for RTIC */
/*! @{ */

#define CAAM_REIR5RTIC_BID_MASK                  (0xF0000U)
#define CAAM_REIR5RTIC_BID_SHIFT                 (16U)
#define CAAM_REIR5RTIC_BID(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_REIR5RTIC_BID_SHIFT)) & CAAM_REIR5RTIC_BID_MASK)

#define CAAM_REIR5RTIC_SAFE_MASK                 (0x1000000U)
#define CAAM_REIR5RTIC_SAFE_SHIFT                (24U)
#define CAAM_REIR5RTIC_SAFE(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_REIR5RTIC_SAFE_SHIFT)) & CAAM_REIR5RTIC_SAFE_MASK)

#define CAAM_REIR5RTIC_SMA_MASK                  (0x2000000U)
#define CAAM_REIR5RTIC_SMA_SHIFT                 (25U)
#define CAAM_REIR5RTIC_SMA(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_REIR5RTIC_SMA_SHIFT)) & CAAM_REIR5RTIC_SMA_MASK)
/*! @} */

/*! @name CC1MR - CCB 0 Class 1 Mode Register Format for Non-Public Key Algorithms */
/*! @{ */

#define CAAM_CC1MR_ENC_MASK                      (0x1U)
#define CAAM_CC1MR_ENC_SHIFT                     (0U)
/*! ENC
 *  0b0..Decrypt.
 *  0b1..Encrypt.
 */
#define CAAM_CC1MR_ENC(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_ENC_SHIFT)) & CAAM_CC1MR_ENC_MASK)

#define CAAM_CC1MR_ICV_TEST_MASK                 (0x2U)
#define CAAM_CC1MR_ICV_TEST_SHIFT                (1U)
#define CAAM_CC1MR_ICV_TEST(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_ICV_TEST_SHIFT)) & CAAM_CC1MR_ICV_TEST_MASK)

#define CAAM_CC1MR_AS_MASK                       (0xCU)
#define CAAM_CC1MR_AS_SHIFT                      (2U)
/*! AS
 *  0b00..Update
 *  0b01..Initialize
 *  0b10..Finalize
 *  0b11..Initialize/Finalize
 */
#define CAAM_CC1MR_AS(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_AS_SHIFT)) & CAAM_CC1MR_AS_MASK)

#define CAAM_CC1MR_AAI_MASK                      (0x1FF0U)
#define CAAM_CC1MR_AAI_SHIFT                     (4U)
#define CAAM_CC1MR_AAI(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_AAI_SHIFT)) & CAAM_CC1MR_AAI_MASK)

#define CAAM_CC1MR_ALG_MASK                      (0xFF0000U)
#define CAAM_CC1MR_ALG_SHIFT                     (16U)
/*! ALG
 *  0b00010000..AES
 *  0b00100000..DES
 *  0b00100001..3DES
 *  0b01010000..RNG
 */
#define CAAM_CC1MR_ALG(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_ALG_SHIFT)) & CAAM_CC1MR_ALG_MASK)
/*! @} */

/* The count of CAAM_CC1MR */
#define CAAM_CC1MR_COUNT                         (1U)

/*! @name CC1MR_PK - CCB 0 Class 1 Mode Register Format for Public Key Algorithms */
/*! @{ */

#define CAAM_CC1MR_PK_PKHA_MODE_LS_MASK          (0xFFFU)
#define CAAM_CC1MR_PK_PKHA_MODE_LS_SHIFT         (0U)
#define CAAM_CC1MR_PK_PKHA_MODE_LS(x)            (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_PK_PKHA_MODE_LS_SHIFT)) & CAAM_CC1MR_PK_PKHA_MODE_LS_MASK)

#define CAAM_CC1MR_PK_PKHA_MODE_MS_MASK          (0xF0000U)
#define CAAM_CC1MR_PK_PKHA_MODE_MS_SHIFT         (16U)
#define CAAM_CC1MR_PK_PKHA_MODE_MS(x)            (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_PK_PKHA_MODE_MS_SHIFT)) & CAAM_CC1MR_PK_PKHA_MODE_MS_MASK)
/*! @} */

/* The count of CAAM_CC1MR_PK */
#define CAAM_CC1MR_PK_COUNT                      (1U)

/*! @name CC1MR_RNG - CCB 0 Class 1 Mode Register Format for RNG4 */
/*! @{ */

#define CAAM_CC1MR_RNG_TST_MASK                  (0x1U)
#define CAAM_CC1MR_RNG_TST_SHIFT                 (0U)
#define CAAM_CC1MR_RNG_TST(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_RNG_TST_SHIFT)) & CAAM_CC1MR_RNG_TST_MASK)

#define CAAM_CC1MR_RNG_PR_MASK                   (0x2U)
#define CAAM_CC1MR_RNG_PR_SHIFT                  (1U)
#define CAAM_CC1MR_RNG_PR(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_RNG_PR_SHIFT)) & CAAM_CC1MR_RNG_PR_MASK)

#define CAAM_CC1MR_RNG_AS_MASK                   (0xCU)
#define CAAM_CC1MR_RNG_AS_SHIFT                  (2U)
#define CAAM_CC1MR_RNG_AS(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_RNG_AS_SHIFT)) & CAAM_CC1MR_RNG_AS_MASK)

#define CAAM_CC1MR_RNG_SH_MASK                   (0x30U)
#define CAAM_CC1MR_RNG_SH_SHIFT                  (4U)
/*! SH
 *  0b00..State Handle 0
 *  0b01..State Handle 1
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define CAAM_CC1MR_RNG_SH(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_RNG_SH_SHIFT)) & CAAM_CC1MR_RNG_SH_MASK)

#define CAAM_CC1MR_RNG_NZB_MASK                  (0x100U)
#define CAAM_CC1MR_RNG_NZB_SHIFT                 (8U)
/*! NZB
 *  0b0..Generate random data with all-zero bytes permitted.
 *  0b1..Generate random data without any all-zero bytes.
 */
#define CAAM_CC1MR_RNG_NZB(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_RNG_NZB_SHIFT)) & CAAM_CC1MR_RNG_NZB_MASK)

#define CAAM_CC1MR_RNG_OBP_MASK                  (0x200U)
#define CAAM_CC1MR_RNG_OBP_SHIFT                 (9U)
/*! OBP
 *  0b0..No odd byte parity.
 *  0b1..Generate random data with odd byte parity.
 */
#define CAAM_CC1MR_RNG_OBP(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_RNG_OBP_SHIFT)) & CAAM_CC1MR_RNG_OBP_MASK)

#define CAAM_CC1MR_RNG_PS_MASK                   (0x400U)
#define CAAM_CC1MR_RNG_PS_SHIFT                  (10U)
/*! PS
 *  0b0..No personalization string is included.
 *  0b1..A personalization string is included.
 */
#define CAAM_CC1MR_RNG_PS(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_RNG_PS_SHIFT)) & CAAM_CC1MR_RNG_PS_MASK)

#define CAAM_CC1MR_RNG_AI_MASK                   (0x800U)
#define CAAM_CC1MR_RNG_AI_SHIFT                  (11U)
/*! AI
 *  0b0..No additional entropy input has been provided.
 *  0b1..Additional entropy input has been provided.
 */
#define CAAM_CC1MR_RNG_AI(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_RNG_AI_SHIFT)) & CAAM_CC1MR_RNG_AI_MASK)

#define CAAM_CC1MR_RNG_SK_MASK                   (0x1000U)
#define CAAM_CC1MR_RNG_SK_SHIFT                  (12U)
/*! SK
 *  0b0..The destination for the RNG data is specified by the FIFO STORE command.
 *  0b1..The RNG data will go to the JDKEKR, TDKEKR and DSKR.
 */
#define CAAM_CC1MR_RNG_SK(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_RNG_SK_SHIFT)) & CAAM_CC1MR_RNG_SK_MASK)

#define CAAM_CC1MR_RNG_ALG_MASK                  (0xFF0000U)
#define CAAM_CC1MR_RNG_ALG_SHIFT                 (16U)
/*! ALG
 *  0b01010000..RNG
 */
#define CAAM_CC1MR_RNG_ALG(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CC1MR_RNG_ALG_SHIFT)) & CAAM_CC1MR_RNG_ALG_MASK)
/*! @} */

/* The count of CAAM_CC1MR_RNG */
#define CAAM_CC1MR_RNG_COUNT                     (1U)

/*! @name CC1KSR - CCB 0 Class 1 Key Size Register */
/*! @{ */

#define CAAM_CC1KSR_C1KS_MASK                    (0x7FU)
#define CAAM_CC1KSR_C1KS_SHIFT                   (0U)
#define CAAM_CC1KSR_C1KS(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CC1KSR_C1KS_SHIFT)) & CAAM_CC1KSR_C1KS_MASK)
/*! @} */

/* The count of CAAM_CC1KSR */
#define CAAM_CC1KSR_COUNT                        (1U)

/*! @name CC1DSR - CCB 0 Class 1 Data Size Register */
/*! @{ */

#define CAAM_CC1DSR_C1DS_MASK                    (0xFFFFFFFFU)
#define CAAM_CC1DSR_C1DS_SHIFT                   (0U)
#define CAAM_CC1DSR_C1DS(x)                      (((uint64_t)(((uint64_t)(x)) << CAAM_CC1DSR_C1DS_SHIFT)) & CAAM_CC1DSR_C1DS_MASK)

#define CAAM_CC1DSR_C1CY_MASK                    (0x100000000U)
#define CAAM_CC1DSR_C1CY_SHIFT                   (32U)
/*! C1CY
 *  0b0..No carry out of the C1 Data Size Reg.
 *  0b1..There was a carry out of the C1 Data Size Reg.
 */
#define CAAM_CC1DSR_C1CY(x)                      (((uint64_t)(((uint64_t)(x)) << CAAM_CC1DSR_C1CY_SHIFT)) & CAAM_CC1DSR_C1CY_MASK)

#define CAAM_CC1DSR_NUMBITS_MASK                 (0xE000000000000000U)
#define CAAM_CC1DSR_NUMBITS_SHIFT                (61U)
#define CAAM_CC1DSR_NUMBITS(x)                   (((uint64_t)(((uint64_t)(x)) << CAAM_CC1DSR_NUMBITS_SHIFT)) & CAAM_CC1DSR_NUMBITS_MASK)
/*! @} */

/* The count of CAAM_CC1DSR */
#define CAAM_CC1DSR_COUNT                        (1U)

/*! @name CC1ICVSR - CCB 0 Class 1 ICV Size Register */
/*! @{ */

#define CAAM_CC1ICVSR_C1ICVS_MASK                (0x1FU)
#define CAAM_CC1ICVSR_C1ICVS_SHIFT               (0U)
#define CAAM_CC1ICVSR_C1ICVS(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CC1ICVSR_C1ICVS_SHIFT)) & CAAM_CC1ICVSR_C1ICVS_MASK)
/*! @} */

/* The count of CAAM_CC1ICVSR */
#define CAAM_CC1ICVSR_COUNT                      (1U)

/*! @name CCCTRL - CCB 0 CHA Control Register */
/*! @{ */

#define CAAM_CCCTRL_CCB_MASK                     (0x1U)
#define CAAM_CCCTRL_CCB_SHIFT                    (0U)
/*! CCB
 *  0b0..Do Not Reset
 *  0b1..Reset CCB
 */
#define CAAM_CCCTRL_CCB(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_CCB_SHIFT)) & CAAM_CCCTRL_CCB_MASK)

#define CAAM_CCCTRL_AES_MASK                     (0x2U)
#define CAAM_CCCTRL_AES_SHIFT                    (1U)
/*! AES
 *  0b0..Do Not Reset
 *  0b1..Reset AES Accelerator
 */
#define CAAM_CCCTRL_AES(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_AES_SHIFT)) & CAAM_CCCTRL_AES_MASK)

#define CAAM_CCCTRL_DES_MASK                     (0x4U)
#define CAAM_CCCTRL_DES_SHIFT                    (2U)
/*! DES
 *  0b0..Do Not Reset
 *  0b1..Reset DES Accelerator
 */
#define CAAM_CCCTRL_DES(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_DES_SHIFT)) & CAAM_CCCTRL_DES_MASK)

#define CAAM_CCCTRL_PK_MASK                      (0x40U)
#define CAAM_CCCTRL_PK_SHIFT                     (6U)
/*! PK
 *  0b0..Do Not Reset
 *  0b1..Reset Public Key Hardware Accelerator
 */
#define CAAM_CCCTRL_PK(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_PK_SHIFT)) & CAAM_CCCTRL_PK_MASK)

#define CAAM_CCCTRL_MD_MASK                      (0x80U)
#define CAAM_CCCTRL_MD_SHIFT                     (7U)
/*! MD
 *  0b0..Do Not Reset
 *  0b1..Reset Message Digest Hardware Accelerator
 */
#define CAAM_CCCTRL_MD(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_MD_SHIFT)) & CAAM_CCCTRL_MD_MASK)

#define CAAM_CCCTRL_CRC_MASK                     (0x100U)
#define CAAM_CCCTRL_CRC_SHIFT                    (8U)
/*! CRC
 *  0b0..Do Not Reset
 *  0b1..Reset CRC Accelerator
 */
#define CAAM_CCCTRL_CRC(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_CRC_SHIFT)) & CAAM_CCCTRL_CRC_MASK)

#define CAAM_CCCTRL_RNG_MASK                     (0x200U)
#define CAAM_CCCTRL_RNG_SHIFT                    (9U)
/*! RNG
 *  0b0..Do Not Reset
 *  0b1..Reset Random Number Generator Block.
 */
#define CAAM_CCCTRL_RNG(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_RNG_SHIFT)) & CAAM_CCCTRL_RNG_MASK)

#define CAAM_CCCTRL_UA0_MASK                     (0x10000U)
#define CAAM_CCCTRL_UA0_SHIFT                    (16U)
/*! UA0
 *  0b0..Don't unload the PKHA A0 Memory.
 *  0b1..Unload the PKHA A0 Memory into OFIFO.
 */
#define CAAM_CCCTRL_UA0(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_UA0_SHIFT)) & CAAM_CCCTRL_UA0_MASK)

#define CAAM_CCCTRL_UA1_MASK                     (0x20000U)
#define CAAM_CCCTRL_UA1_SHIFT                    (17U)
/*! UA1
 *  0b0..Don't unload the PKHA A1 Memory.
 *  0b1..Unload the PKHA A1 Memory into OFIFO.
 */
#define CAAM_CCCTRL_UA1(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_UA1_SHIFT)) & CAAM_CCCTRL_UA1_MASK)

#define CAAM_CCCTRL_UA2_MASK                     (0x40000U)
#define CAAM_CCCTRL_UA2_SHIFT                    (18U)
/*! UA2
 *  0b0..Don't unload the PKHA A2 Memory.
 *  0b1..Unload the PKHA A2 Memory into OFIFO.
 */
#define CAAM_CCCTRL_UA2(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_UA2_SHIFT)) & CAAM_CCCTRL_UA2_MASK)

#define CAAM_CCCTRL_UA3_MASK                     (0x80000U)
#define CAAM_CCCTRL_UA3_SHIFT                    (19U)
/*! UA3
 *  0b0..Don't unload the PKHA A3 Memory.
 *  0b1..Unload the PKHA A3 Memory into OFIFO.
 */
#define CAAM_CCCTRL_UA3(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_UA3_SHIFT)) & CAAM_CCCTRL_UA3_MASK)

#define CAAM_CCCTRL_UB0_MASK                     (0x100000U)
#define CAAM_CCCTRL_UB0_SHIFT                    (20U)
/*! UB0
 *  0b0..Don't unload the PKHA B0 Memory.
 *  0b1..Unload the PKHA B0 Memory into OFIFO.
 */
#define CAAM_CCCTRL_UB0(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_UB0_SHIFT)) & CAAM_CCCTRL_UB0_MASK)

#define CAAM_CCCTRL_UB1_MASK                     (0x200000U)
#define CAAM_CCCTRL_UB1_SHIFT                    (21U)
/*! UB1
 *  0b0..Don't unload the PKHA B1 Memory.
 *  0b1..Unload the PKHA B1 Memory into OFIFO.
 */
#define CAAM_CCCTRL_UB1(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_UB1_SHIFT)) & CAAM_CCCTRL_UB1_MASK)

#define CAAM_CCCTRL_UB2_MASK                     (0x400000U)
#define CAAM_CCCTRL_UB2_SHIFT                    (22U)
/*! UB2
 *  0b0..Don't unload the PKHA B2 Memory.
 *  0b1..Unload the PKHA B2 Memory into OFIFO.
 */
#define CAAM_CCCTRL_UB2(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_UB2_SHIFT)) & CAAM_CCCTRL_UB2_MASK)

#define CAAM_CCCTRL_UB3_MASK                     (0x800000U)
#define CAAM_CCCTRL_UB3_SHIFT                    (23U)
/*! UB3
 *  0b0..Don't unload the PKHA B3 Memory.
 *  0b1..Unload the PKHA B3 Memory into OFIFO.
 */
#define CAAM_CCCTRL_UB3(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_UB3_SHIFT)) & CAAM_CCCTRL_UB3_MASK)

#define CAAM_CCCTRL_UN_MASK                      (0x1000000U)
#define CAAM_CCCTRL_UN_SHIFT                     (24U)
/*! UN
 *  0b0..Don't unload the PKHA N Memory.
 *  0b1..Unload the PKHA N Memory into OFIFO.
 */
#define CAAM_CCCTRL_UN(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_UN_SHIFT)) & CAAM_CCCTRL_UN_MASK)

#define CAAM_CCCTRL_UA_MASK                      (0x4000000U)
#define CAAM_CCCTRL_UA_SHIFT                     (26U)
/*! UA
 *  0b0..Don't unload the PKHA A Memory.
 *  0b1..Unload the PKHA A Memory into OFIFO.
 */
#define CAAM_CCCTRL_UA(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_UA_SHIFT)) & CAAM_CCCTRL_UA_MASK)

#define CAAM_CCCTRL_UB_MASK                      (0x8000000U)
#define CAAM_CCCTRL_UB_SHIFT                     (27U)
/*! UB
 *  0b0..Don't unload the PKHA B Memory.
 *  0b1..Unload the PKHA B Memory into OFIFO.
 */
#define CAAM_CCCTRL_UB(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CCCTRL_UB_SHIFT)) & CAAM_CCCTRL_UB_MASK)
/*! @} */

/* The count of CAAM_CCCTRL */
#define CAAM_CCCTRL_COUNT                        (1U)

/*! @name CICTL - CCB 0 Interrupt Control Register */
/*! @{ */

#define CAAM_CICTL_ADI_MASK                      (0x2U)
#define CAAM_CICTL_ADI_SHIFT                     (1U)
#define CAAM_CICTL_ADI(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CICTL_ADI_SHIFT)) & CAAM_CICTL_ADI_MASK)

#define CAAM_CICTL_DDI_MASK                      (0x4U)
#define CAAM_CICTL_DDI_SHIFT                     (2U)
#define CAAM_CICTL_DDI(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CICTL_DDI_SHIFT)) & CAAM_CICTL_DDI_MASK)

#define CAAM_CICTL_PDI_MASK                      (0x40U)
#define CAAM_CICTL_PDI_SHIFT                     (6U)
#define CAAM_CICTL_PDI(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CICTL_PDI_SHIFT)) & CAAM_CICTL_PDI_MASK)

#define CAAM_CICTL_MDI_MASK                      (0x80U)
#define CAAM_CICTL_MDI_SHIFT                     (7U)
#define CAAM_CICTL_MDI(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CICTL_MDI_SHIFT)) & CAAM_CICTL_MDI_MASK)

#define CAAM_CICTL_CDI_MASK                      (0x100U)
#define CAAM_CICTL_CDI_SHIFT                     (8U)
#define CAAM_CICTL_CDI(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CICTL_CDI_SHIFT)) & CAAM_CICTL_CDI_MASK)

#define CAAM_CICTL_RNDI_MASK                     (0x200U)
#define CAAM_CICTL_RNDI_SHIFT                    (9U)
#define CAAM_CICTL_RNDI(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CICTL_RNDI_SHIFT)) & CAAM_CICTL_RNDI_MASK)

#define CAAM_CICTL_AEI_MASK                      (0x20000U)
#define CAAM_CICTL_AEI_SHIFT                     (17U)
/*! AEI
 *  0b0..No AESA error detected
 *  0b1..AESA error detected
 */
#define CAAM_CICTL_AEI(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CICTL_AEI_SHIFT)) & CAAM_CICTL_AEI_MASK)

#define CAAM_CICTL_DEI_MASK                      (0x40000U)
#define CAAM_CICTL_DEI_SHIFT                     (18U)
/*! DEI
 *  0b0..No DESA error detected
 *  0b1..DESA error detected
 */
#define CAAM_CICTL_DEI(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CICTL_DEI_SHIFT)) & CAAM_CICTL_DEI_MASK)

#define CAAM_CICTL_PEI_MASK                      (0x400000U)
#define CAAM_CICTL_PEI_SHIFT                     (22U)
/*! PEI
 *  0b0..No PKHA error detected
 *  0b1..PKHA error detected
 */
#define CAAM_CICTL_PEI(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CICTL_PEI_SHIFT)) & CAAM_CICTL_PEI_MASK)

#define CAAM_CICTL_MEI_MASK                      (0x800000U)
#define CAAM_CICTL_MEI_SHIFT                     (23U)
/*! MEI
 *  0b0..No MDHA error detected
 *  0b1..MDHA error detected
 */
#define CAAM_CICTL_MEI(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CICTL_MEI_SHIFT)) & CAAM_CICTL_MEI_MASK)

#define CAAM_CICTL_CEI_MASK                      (0x1000000U)
#define CAAM_CICTL_CEI_SHIFT                     (24U)
/*! CEI
 *  0b0..No CRCA error detected
 *  0b1..CRCA error detected
 */
#define CAAM_CICTL_CEI(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CICTL_CEI_SHIFT)) & CAAM_CICTL_CEI_MASK)

#define CAAM_CICTL_RNEI_MASK                     (0x2000000U)
#define CAAM_CICTL_RNEI_SHIFT                    (25U)
/*! RNEI
 *  0b0..No RNG error detected
 *  0b1..RNG error detected
 */
#define CAAM_CICTL_RNEI(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CICTL_RNEI_SHIFT)) & CAAM_CICTL_RNEI_MASK)
/*! @} */

/* The count of CAAM_CICTL */
#define CAAM_CICTL_COUNT                         (1U)

/*! @name CCWR - CCB 0 Clear Written Register */
/*! @{ */

#define CAAM_CCWR_C1M_MASK                       (0x1U)
#define CAAM_CCWR_C1M_SHIFT                      (0U)
/*! C1M
 *  0b0..Don't clear the Class 1 Mode Register.
 *  0b1..Clear the Class 1 Mode Register.
 */
#define CAAM_CCWR_C1M(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_C1M_SHIFT)) & CAAM_CCWR_C1M_MASK)

#define CAAM_CCWR_C1DS_MASK                      (0x4U)
#define CAAM_CCWR_C1DS_SHIFT                     (2U)
/*! C1DS
 *  0b0..Don't clear the Class 1 Data Size Register.
 *  0b1..Clear the Class 1 Data Size Register.
 */
#define CAAM_CCWR_C1DS(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_C1DS_SHIFT)) & CAAM_CCWR_C1DS_MASK)

#define CAAM_CCWR_C1ICV_MASK                     (0x8U)
#define CAAM_CCWR_C1ICV_SHIFT                    (3U)
/*! C1ICV
 *  0b0..Don't clear the Class 1 ICV Size Register.
 *  0b1..Clear the Class 1 ICV Size Register.
 */
#define CAAM_CCWR_C1ICV(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_C1ICV_SHIFT)) & CAAM_CCWR_C1ICV_MASK)

#define CAAM_CCWR_C1C_MASK                       (0x20U)
#define CAAM_CCWR_C1C_SHIFT                      (5U)
/*! C1C
 *  0b0..Don't clear the Class 1 Context Register.
 *  0b1..Clear the Class 1 Context Register.
 */
#define CAAM_CCWR_C1C(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_C1C_SHIFT)) & CAAM_CCWR_C1C_MASK)

#define CAAM_CCWR_C1K_MASK                       (0x40U)
#define CAAM_CCWR_C1K_SHIFT                      (6U)
/*! C1K
 *  0b0..Don't clear the Class 1 Key Register.
 *  0b1..Clear the Class 1 Key Register.
 */
#define CAAM_CCWR_C1K(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_C1K_SHIFT)) & CAAM_CCWR_C1K_MASK)

#define CAAM_CCWR_CPKA_MASK                      (0x1000U)
#define CAAM_CCWR_CPKA_SHIFT                     (12U)
/*! CPKA
 *  0b0..Don't clear the PKHA A Size Register.
 *  0b1..Clear the PKHA A Size Register.
 */
#define CAAM_CCWR_CPKA(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_CPKA_SHIFT)) & CAAM_CCWR_CPKA_MASK)

#define CAAM_CCWR_CPKB_MASK                      (0x2000U)
#define CAAM_CCWR_CPKB_SHIFT                     (13U)
/*! CPKB
 *  0b0..Don't clear the PKHA B Size Register.
 *  0b1..Clear the PKHA B Size Register.
 */
#define CAAM_CCWR_CPKB(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_CPKB_SHIFT)) & CAAM_CCWR_CPKB_MASK)

#define CAAM_CCWR_CPKN_MASK                      (0x4000U)
#define CAAM_CCWR_CPKN_SHIFT                     (14U)
/*! CPKN
 *  0b0..Don't clear the PKHA N Size Register.
 *  0b1..Clear the PKHA N Size Register.
 */
#define CAAM_CCWR_CPKN(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_CPKN_SHIFT)) & CAAM_CCWR_CPKN_MASK)

#define CAAM_CCWR_CPKE_MASK                      (0x8000U)
#define CAAM_CCWR_CPKE_SHIFT                     (15U)
/*! CPKE
 *  0b0..Don't clear the PKHA E Size Register..
 *  0b1..Clear the PKHA E Size Register.
 */
#define CAAM_CCWR_CPKE(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_CPKE_SHIFT)) & CAAM_CCWR_CPKE_MASK)

#define CAAM_CCWR_C2M_MASK                       (0x10000U)
#define CAAM_CCWR_C2M_SHIFT                      (16U)
/*! C2M
 *  0b0..Don't clear the Class 2 Mode Register.
 *  0b1..Clear the Class 2 Mode Register.
 */
#define CAAM_CCWR_C2M(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_C2M_SHIFT)) & CAAM_CCWR_C2M_MASK)

#define CAAM_CCWR_C2DS_MASK                      (0x40000U)
#define CAAM_CCWR_C2DS_SHIFT                     (18U)
/*! C2DS
 *  0b0..Don't clear the Class 2 Data Size Register.
 *  0b1..Clear the Class 2 Data Size Register.
 */
#define CAAM_CCWR_C2DS(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_C2DS_SHIFT)) & CAAM_CCWR_C2DS_MASK)

#define CAAM_CCWR_C2C_MASK                       (0x200000U)
#define CAAM_CCWR_C2C_SHIFT                      (21U)
/*! C2C
 *  0b0..Don't clear the Class 2 Context Register.
 *  0b1..Clear the Class 2 Context Register.
 */
#define CAAM_CCWR_C2C(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_C2C_SHIFT)) & CAAM_CCWR_C2C_MASK)

#define CAAM_CCWR_C2K_MASK                       (0x400000U)
#define CAAM_CCWR_C2K_SHIFT                      (22U)
/*! C2K
 *  0b0..Don't clear the Class 2 Key Register.
 *  0b1..Clear the Class 2 Key Register.
 */
#define CAAM_CCWR_C2K(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_C2K_SHIFT)) & CAAM_CCWR_C2K_MASK)

#define CAAM_CCWR_CDS_MASK                       (0x2000000U)
#define CAAM_CCWR_CDS_SHIFT                      (25U)
/*! CDS
 *  0b0..Don't clear the shared descriptor signal.
 *  0b1..Clear the shared descriptor signal.
 */
#define CAAM_CCWR_CDS(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_CDS_SHIFT)) & CAAM_CCWR_CDS_MASK)

#define CAAM_CCWR_C2D_MASK                       (0x4000000U)
#define CAAM_CCWR_C2D_SHIFT                      (26U)
/*! C2D
 *  0b0..Don't clear the Class 2 done interrrupt.
 *  0b1..Clear the Class 2 done interrrupt.
 */
#define CAAM_CCWR_C2D(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_C2D_SHIFT)) & CAAM_CCWR_C2D_MASK)

#define CAAM_CCWR_C1D_MASK                       (0x8000000U)
#define CAAM_CCWR_C1D_SHIFT                      (27U)
/*! C1D
 *  0b0..Don't clear the Class 1 done interrrupt.
 *  0b1..Clear the Class 1 done interrrupt.
 */
#define CAAM_CCWR_C1D(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_C1D_SHIFT)) & CAAM_CCWR_C1D_MASK)

#define CAAM_CCWR_C2RST_MASK                     (0x10000000U)
#define CAAM_CCWR_C2RST_SHIFT                    (28U)
/*! C2RST
 *  0b0..Don't reset the Class 2 CHA.
 *  0b1..Reset the Class 2 CHA.
 */
#define CAAM_CCWR_C2RST(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_C2RST_SHIFT)) & CAAM_CCWR_C2RST_MASK)

#define CAAM_CCWR_C1RST_MASK                     (0x20000000U)
#define CAAM_CCWR_C1RST_SHIFT                    (29U)
/*! C1RST
 *  0b0..Don't reset the Class 1 CHA.
 *  0b1..Reset the Class 1 CHA.
 */
#define CAAM_CCWR_C1RST(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_C1RST_SHIFT)) & CAAM_CCWR_C1RST_MASK)

#define CAAM_CCWR_COF_MASK                       (0x40000000U)
#define CAAM_CCWR_COF_SHIFT                      (30U)
/*! COF
 *  0b0..Don't clear the OFIFO.
 *  0b1..Clear the OFIFO.
 */
#define CAAM_CCWR_COF(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_COF_SHIFT)) & CAAM_CCWR_COF_MASK)

#define CAAM_CCWR_CIF_MASK                       (0x80000000U)
#define CAAM_CCWR_CIF_SHIFT                      (31U)
/*! CIF
 *  0b0..Don't clear the IFIFO.
 *  0b1..Clear the IFIFO.
 */
#define CAAM_CCWR_CIF(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CCWR_CIF_SHIFT)) & CAAM_CCWR_CIF_MASK)
/*! @} */

/* The count of CAAM_CCWR */
#define CAAM_CCWR_COUNT                          (1U)

/*! @name CCSTA_MS - CCB 0 Status and Error Register, most-significant half */
/*! @{ */

#define CAAM_CCSTA_MS_ERRID1_MASK                (0xFU)
#define CAAM_CCSTA_MS_ERRID1_SHIFT               (0U)
/*! ERRID1
 *  0b0001..Mode Error
 *  0b0010..Data Size Error, including PKHA N Memory Size Error
 *  0b0011..Key Size Error, including PKHA E Memory Size Error
 *  0b0100..PKHA A Memory Size Error
 *  0b0101..PKHA B Memory Size Error
 *  0b0110..Data Arrived out of Sequence Error
 *  0b0111..PKHA Divide by Zero Error
 *  0b1000..PKHA Modulus Even Error
 *  0b1001..DES Key Parity Error
 *  0b1010..ICV Check Failed
 *  0b1011..Internal Hardware Failure
 *  0b1100..CCM AAD Size Error (either 1. AAD flag in B0 =1 and no AAD type provided, 2. AAD flag in B0 = 0 and
 *          AAD provided, or 3. AAD flag in B0 =1 and not enough AAD provided - expecting more based on AAD size.)
 *  0b1101..Class 1 CHA is not reset
 *  0b1110..Invalid CHA combination was selected
 *  0b1111..Invalid CHA Selected
 */
#define CAAM_CCSTA_MS_ERRID1(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_MS_ERRID1_SHIFT)) & CAAM_CCSTA_MS_ERRID1_MASK)

#define CAAM_CCSTA_MS_CL1_MASK                   (0xF000U)
#define CAAM_CCSTA_MS_CL1_SHIFT                  (12U)
/*! CL1
 *  0b0001..AES
 *  0b0010..DES
 *  0b0101..RNG
 *  0b1000..Public Key
 */
#define CAAM_CCSTA_MS_CL1(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_MS_CL1_SHIFT)) & CAAM_CCSTA_MS_CL1_MASK)

#define CAAM_CCSTA_MS_ERRID2_MASK                (0xF0000U)
#define CAAM_CCSTA_MS_ERRID2_SHIFT               (16U)
/*! ERRID2
 *  0b0001..Mode Error
 *  0b0010..Data Size Error
 *  0b0011..Key Size Error
 *  0b0110..Data Arrived out of Sequence Error
 *  0b1010..ICV Check Failed
 *  0b1011..Internal Hardware Failure
 *  0b1110..Invalid CHA combination was selected.
 *  0b1111..Invalid CHA Selected
 */
#define CAAM_CCSTA_MS_ERRID2(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_MS_ERRID2_SHIFT)) & CAAM_CCSTA_MS_ERRID2_MASK)

#define CAAM_CCSTA_MS_CL2_MASK                   (0xF0000000U)
#define CAAM_CCSTA_MS_CL2_SHIFT                  (28U)
/*! CL2
 *  0b0100..MD5, SHA-1, SHA-224, SHA-256, SHA-384, SHA-512 and SHA-512/224, SHA-512/256
 *  0b1001..CRC
 */
#define CAAM_CCSTA_MS_CL2(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_MS_CL2_SHIFT)) & CAAM_CCSTA_MS_CL2_MASK)
/*! @} */

/* The count of CAAM_CCSTA_MS */
#define CAAM_CCSTA_MS_COUNT                      (1U)

/*! @name CCSTA_LS - CCB 0 Status and Error Register, least-significant half */
/*! @{ */

#define CAAM_CCSTA_LS_AB_MASK                    (0x2U)
#define CAAM_CCSTA_LS_AB_SHIFT                   (1U)
/*! AB
 *  0b0..AESA Idle
 *  0b1..AESA Busy
 */
#define CAAM_CCSTA_LS_AB(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_LS_AB_SHIFT)) & CAAM_CCSTA_LS_AB_MASK)

#define CAAM_CCSTA_LS_DB_MASK                    (0x4U)
#define CAAM_CCSTA_LS_DB_SHIFT                   (2U)
/*! DB
 *  0b0..DESA Idle
 *  0b1..DESA Busy
 */
#define CAAM_CCSTA_LS_DB(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_LS_DB_SHIFT)) & CAAM_CCSTA_LS_DB_MASK)

#define CAAM_CCSTA_LS_PB_MASK                    (0x40U)
#define CAAM_CCSTA_LS_PB_SHIFT                   (6U)
/*! PB
 *  0b0..PKHA Idle
 *  0b1..PKHA Busy
 */
#define CAAM_CCSTA_LS_PB(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_LS_PB_SHIFT)) & CAAM_CCSTA_LS_PB_MASK)

#define CAAM_CCSTA_LS_MB_MASK                    (0x80U)
#define CAAM_CCSTA_LS_MB_SHIFT                   (7U)
/*! MB
 *  0b0..MDHA Idle
 *  0b1..MDHA Busy
 */
#define CAAM_CCSTA_LS_MB(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_LS_MB_SHIFT)) & CAAM_CCSTA_LS_MB_MASK)

#define CAAM_CCSTA_LS_CB_MASK                    (0x100U)
#define CAAM_CCSTA_LS_CB_SHIFT                   (8U)
/*! CB
 *  0b0..CRCA Idle
 *  0b1..CRCA Busy
 */
#define CAAM_CCSTA_LS_CB(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_LS_CB_SHIFT)) & CAAM_CCSTA_LS_CB_MASK)

#define CAAM_CCSTA_LS_RNB_MASK                   (0x200U)
#define CAAM_CCSTA_LS_RNB_SHIFT                  (9U)
/*! RNB
 *  0b0..RNG Idle
 *  0b1..RNG Busy
 */
#define CAAM_CCSTA_LS_RNB(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_LS_RNB_SHIFT)) & CAAM_CCSTA_LS_RNB_MASK)

#define CAAM_CCSTA_LS_PDI_MASK                   (0x10000U)
#define CAAM_CCSTA_LS_PDI_SHIFT                  (16U)
/*! PDI
 *  0b0..Not Done
 *  0b1..Done Interrupt
 */
#define CAAM_CCSTA_LS_PDI(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_LS_PDI_SHIFT)) & CAAM_CCSTA_LS_PDI_MASK)

#define CAAM_CCSTA_LS_SDI_MASK                   (0x20000U)
#define CAAM_CCSTA_LS_SDI_SHIFT                  (17U)
/*! SDI
 *  0b0..Not Done
 *  0b1..Done Interrupt
 */
#define CAAM_CCSTA_LS_SDI(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_LS_SDI_SHIFT)) & CAAM_CCSTA_LS_SDI_MASK)

#define CAAM_CCSTA_LS_PEI_MASK                   (0x100000U)
#define CAAM_CCSTA_LS_PEI_SHIFT                  (20U)
/*! PEI
 *  0b0..No Error
 *  0b1..Error Interrupt
 */
#define CAAM_CCSTA_LS_PEI(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_LS_PEI_SHIFT)) & CAAM_CCSTA_LS_PEI_MASK)

#define CAAM_CCSTA_LS_SEI_MASK                   (0x200000U)
#define CAAM_CCSTA_LS_SEI_SHIFT                  (21U)
/*! SEI
 *  0b0..No Error
 *  0b1..Error Interrupt
 */
#define CAAM_CCSTA_LS_SEI(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_LS_SEI_SHIFT)) & CAAM_CCSTA_LS_SEI_MASK)

#define CAAM_CCSTA_LS_PRM_MASK                   (0x10000000U)
#define CAAM_CCSTA_LS_PRM_SHIFT                  (28U)
/*! PRM
 *  0b0..The given number is NOT prime.
 *  0b1..The given number is probably prime.
 */
#define CAAM_CCSTA_LS_PRM(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_LS_PRM_SHIFT)) & CAAM_CCSTA_LS_PRM_MASK)

#define CAAM_CCSTA_LS_GCD_MASK                   (0x20000000U)
#define CAAM_CCSTA_LS_GCD_SHIFT                  (29U)
/*! GCD
 *  0b0..The greatest common divisor of two numbers is NOT one.
 *  0b1..The greatest common divisor of two numbers is one.
 */
#define CAAM_CCSTA_LS_GCD(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_LS_GCD_SHIFT)) & CAAM_CCSTA_LS_GCD_MASK)

#define CAAM_CCSTA_LS_PIZ_MASK                   (0x40000000U)
#define CAAM_CCSTA_LS_PIZ_SHIFT                  (30U)
/*! PIZ
 *  0b0..The result of a Public Key operation is not zero.
 *  0b1..The result of a Public Key operation is zero.
 */
#define CAAM_CCSTA_LS_PIZ(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CCSTA_LS_PIZ_SHIFT)) & CAAM_CCSTA_LS_PIZ_MASK)
/*! @} */

/* The count of CAAM_CCSTA_LS */
#define CAAM_CCSTA_LS_COUNT                      (1U)

/*! @name CC1AADSZR - CCB 0 Class 1 AAD Size Register */
/*! @{ */

#define CAAM_CC1AADSZR_AASZ_MASK                 (0xFU)
#define CAAM_CC1AADSZR_AASZ_SHIFT                (0U)
#define CAAM_CC1AADSZR_AASZ(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_CC1AADSZR_AASZ_SHIFT)) & CAAM_CC1AADSZR_AASZ_MASK)
/*! @} */

/* The count of CAAM_CC1AADSZR */
#define CAAM_CC1AADSZR_COUNT                     (1U)

/*! @name CC1IVSZR - CCB 0 Class 1 IV Size Register */
/*! @{ */

#define CAAM_CC1IVSZR_IVSZ_MASK                  (0xFU)
#define CAAM_CC1IVSZR_IVSZ_SHIFT                 (0U)
#define CAAM_CC1IVSZR_IVSZ(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CC1IVSZR_IVSZ_SHIFT)) & CAAM_CC1IVSZR_IVSZ_MASK)
/*! @} */

/* The count of CAAM_CC1IVSZR */
#define CAAM_CC1IVSZR_COUNT                      (1U)

/*! @name CPKASZR - PKHA A Size Register */
/*! @{ */

#define CAAM_CPKASZR_PKASZ_MASK                  (0x3FFU)
#define CAAM_CPKASZR_PKASZ_SHIFT                 (0U)
#define CAAM_CPKASZR_PKASZ(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CPKASZR_PKASZ_SHIFT)) & CAAM_CPKASZR_PKASZ_MASK)
/*! @} */

/* The count of CAAM_CPKASZR */
#define CAAM_CPKASZR_COUNT                       (1U)

/*! @name CPKBSZR - PKHA B Size Register */
/*! @{ */

#define CAAM_CPKBSZR_PKBSZ_MASK                  (0x3FFU)
#define CAAM_CPKBSZR_PKBSZ_SHIFT                 (0U)
#define CAAM_CPKBSZR_PKBSZ(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CPKBSZR_PKBSZ_SHIFT)) & CAAM_CPKBSZR_PKBSZ_MASK)
/*! @} */

/* The count of CAAM_CPKBSZR */
#define CAAM_CPKBSZR_COUNT                       (1U)

/*! @name CPKNSZR - PKHA N Size Register */
/*! @{ */

#define CAAM_CPKNSZR_PKNSZ_MASK                  (0x3FFU)
#define CAAM_CPKNSZR_PKNSZ_SHIFT                 (0U)
#define CAAM_CPKNSZR_PKNSZ(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CPKNSZR_PKNSZ_SHIFT)) & CAAM_CPKNSZR_PKNSZ_MASK)
/*! @} */

/* The count of CAAM_CPKNSZR */
#define CAAM_CPKNSZR_COUNT                       (1U)

/*! @name CPKESZR - PKHA E Size Register */
/*! @{ */

#define CAAM_CPKESZR_PKESZ_MASK                  (0x3FFU)
#define CAAM_CPKESZR_PKESZ_SHIFT                 (0U)
#define CAAM_CPKESZR_PKESZ(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CPKESZR_PKESZ_SHIFT)) & CAAM_CPKESZR_PKESZ_MASK)
/*! @} */

/* The count of CAAM_CPKESZR */
#define CAAM_CPKESZR_COUNT                       (1U)

/*! @name CC1CTXR - CCB 0 Class 1 Context Register Word 0..CCB 0 Class 1 Context Register Word 15 */
/*! @{ */

#define CAAM_CC1CTXR_C1CTX_MASK                  (0xFFFFFFFFU)
#define CAAM_CC1CTXR_C1CTX_SHIFT                 (0U)
#define CAAM_CC1CTXR_C1CTX(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CC1CTXR_C1CTX_SHIFT)) & CAAM_CC1CTXR_C1CTX_MASK)
/*! @} */

/* The count of CAAM_CC1CTXR */
#define CAAM_CC1CTXR_COUNT                       (1U)

/* The count of CAAM_CC1CTXR */
#define CAAM_CC1CTXR_COUNT2                      (16U)

/*! @name CC1KR - CCB 0 Class 1 Key Registers Word 0..CCB 0 Class 1 Key Registers Word 7 */
/*! @{ */

#define CAAM_CC1KR_C1KEY_MASK                    (0xFFFFFFFFU)
#define CAAM_CC1KR_C1KEY_SHIFT                   (0U)
#define CAAM_CC1KR_C1KEY(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CC1KR_C1KEY_SHIFT)) & CAAM_CC1KR_C1KEY_MASK)
/*! @} */

/* The count of CAAM_CC1KR */
#define CAAM_CC1KR_COUNT                         (1U)

/* The count of CAAM_CC1KR */
#define CAAM_CC1KR_COUNT2                        (8U)

/*! @name CC2MR - CCB 0 Class 2 Mode Register */
/*! @{ */

#define CAAM_CC2MR_AP_MASK                       (0x1U)
#define CAAM_CC2MR_AP_SHIFT                      (0U)
/*! AP
 *  0b0..Authenticate
 *  0b1..Protect
 */
#define CAAM_CC2MR_AP(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CC2MR_AP_SHIFT)) & CAAM_CC2MR_AP_MASK)

#define CAAM_CC2MR_ICV_MASK                      (0x2U)
#define CAAM_CC2MR_ICV_SHIFT                     (1U)
/*! ICV
 *  0b0..Don't compare the calculated ICV against a received ICV.
 *  0b1..Compare the calculated ICV against a received ICV.
 */
#define CAAM_CC2MR_ICV(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CC2MR_ICV_SHIFT)) & CAAM_CC2MR_ICV_MASK)

#define CAAM_CC2MR_AS_MASK                       (0xCU)
#define CAAM_CC2MR_AS_SHIFT                      (2U)
/*! AS
 *  0b00..Update.
 *  0b01..Initialize.
 *  0b10..Finalize.
 *  0b11..Initialize/Finalize.
 */
#define CAAM_CC2MR_AS(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_CC2MR_AS_SHIFT)) & CAAM_CC2MR_AS_MASK)

#define CAAM_CC2MR_AAI_MASK                      (0x1FF0U)
#define CAAM_CC2MR_AAI_SHIFT                     (4U)
#define CAAM_CC2MR_AAI(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CC2MR_AAI_SHIFT)) & CAAM_CC2MR_AAI_MASK)

#define CAAM_CC2MR_ALG_MASK                      (0xFF0000U)
#define CAAM_CC2MR_ALG_SHIFT                     (16U)
/*! ALG
 *  0b01000000..MD5
 *  0b01000001..SHA-1
 *  0b01000010..SHA-224
 *  0b01000011..SHA-256
 *  0b01000100..SHA-384
 *  0b01000101..SHA-512
 *  0b01000110..SHA-512/224
 *  0b01000111..SHA-512/256
 *  0b10010000..CRC
 */
#define CAAM_CC2MR_ALG(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CC2MR_ALG_SHIFT)) & CAAM_CC2MR_ALG_MASK)
/*! @} */

/* The count of CAAM_CC2MR */
#define CAAM_CC2MR_COUNT                         (1U)

/*! @name CC2KSR - CCB 0 Class 2 Key Size Register */
/*! @{ */

#define CAAM_CC2KSR_C2KS_MASK                    (0xFFU)
#define CAAM_CC2KSR_C2KS_SHIFT                   (0U)
#define CAAM_CC2KSR_C2KS(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CC2KSR_C2KS_SHIFT)) & CAAM_CC2KSR_C2KS_MASK)
/*! @} */

/* The count of CAAM_CC2KSR */
#define CAAM_CC2KSR_COUNT                        (1U)

/*! @name CC2DSR - CCB 0 Class 2 Data Size Register */
/*! @{ */

#define CAAM_CC2DSR_C2DS_MASK                    (0xFFFFFFFFU)
#define CAAM_CC2DSR_C2DS_SHIFT                   (0U)
#define CAAM_CC2DSR_C2DS(x)                      (((uint64_t)(((uint64_t)(x)) << CAAM_CC2DSR_C2DS_SHIFT)) & CAAM_CC2DSR_C2DS_MASK)

#define CAAM_CC2DSR_C2CY_MASK                    (0x100000000U)
#define CAAM_CC2DSR_C2CY_SHIFT                   (32U)
/*! C2CY
 *  0b0..A write to the Class 2 Data Size Register did not cause a carry.
 *  0b1..A write to the Class 2 Data Size Register caused a carry.
 */
#define CAAM_CC2DSR_C2CY(x)                      (((uint64_t)(((uint64_t)(x)) << CAAM_CC2DSR_C2CY_SHIFT)) & CAAM_CC2DSR_C2CY_MASK)

#define CAAM_CC2DSR_NUMBITS_MASK                 (0xE000000000000000U)
#define CAAM_CC2DSR_NUMBITS_SHIFT                (61U)
#define CAAM_CC2DSR_NUMBITS(x)                   (((uint64_t)(((uint64_t)(x)) << CAAM_CC2DSR_NUMBITS_SHIFT)) & CAAM_CC2DSR_NUMBITS_MASK)
/*! @} */

/* The count of CAAM_CC2DSR */
#define CAAM_CC2DSR_COUNT                        (1U)

/*! @name CC2ICVSZR - CCB 0 Class 2 ICV Size Register */
/*! @{ */

#define CAAM_CC2ICVSZR_ICVSZ_MASK                (0xFU)
#define CAAM_CC2ICVSZR_ICVSZ_SHIFT               (0U)
#define CAAM_CC2ICVSZR_ICVSZ(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_CC2ICVSZR_ICVSZ_SHIFT)) & CAAM_CC2ICVSZR_ICVSZ_MASK)
/*! @} */

/* The count of CAAM_CC2ICVSZR */
#define CAAM_CC2ICVSZR_COUNT                     (1U)

/*! @name CC2CTXR - CCB 0 Class 2 Context Register Word 0..CCB 0 Class 2 Context Register Word 17 */
/*! @{ */

#define CAAM_CC2CTXR_C2CTXR_MASK                 (0xFFFFFFFFU)
#define CAAM_CC2CTXR_C2CTXR_SHIFT                (0U)
#define CAAM_CC2CTXR_C2CTXR(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_CC2CTXR_C2CTXR_SHIFT)) & CAAM_CC2CTXR_C2CTXR_MASK)
/*! @} */

/* The count of CAAM_CC2CTXR */
#define CAAM_CC2CTXR_COUNT                       (1U)

/* The count of CAAM_CC2CTXR */
#define CAAM_CC2CTXR_COUNT2                      (18U)

/*! @name CC2KEYR - CCB 0 Class 2 Key Register Word 0..CCB 0 Class 2 Key Register Word 31 */
/*! @{ */

#define CAAM_CC2KEYR_C2KEY_MASK                  (0xFFFFFFFFU)
#define CAAM_CC2KEYR_C2KEY_SHIFT                 (0U)
#define CAAM_CC2KEYR_C2KEY(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CC2KEYR_C2KEY_SHIFT)) & CAAM_CC2KEYR_C2KEY_MASK)
/*! @} */

/* The count of CAAM_CC2KEYR */
#define CAAM_CC2KEYR_COUNT                       (1U)

/* The count of CAAM_CC2KEYR */
#define CAAM_CC2KEYR_COUNT2                      (32U)

/*! @name CFIFOSTA - CCB 0 FIFO Status Register */
/*! @{ */

#define CAAM_CFIFOSTA_DECOOQHEAD_MASK            (0xFFU)
#define CAAM_CFIFOSTA_DECOOQHEAD_SHIFT           (0U)
#define CAAM_CFIFOSTA_DECOOQHEAD(x)              (((uint32_t)(((uint32_t)(x)) << CAAM_CFIFOSTA_DECOOQHEAD_SHIFT)) & CAAM_CFIFOSTA_DECOOQHEAD_MASK)

#define CAAM_CFIFOSTA_DMAOQHEAD_MASK             (0xFF00U)
#define CAAM_CFIFOSTA_DMAOQHEAD_SHIFT            (8U)
#define CAAM_CFIFOSTA_DMAOQHEAD(x)               (((uint32_t)(((uint32_t)(x)) << CAAM_CFIFOSTA_DMAOQHEAD_SHIFT)) & CAAM_CFIFOSTA_DMAOQHEAD_MASK)

#define CAAM_CFIFOSTA_C2IQHEAD_MASK              (0xFF0000U)
#define CAAM_CFIFOSTA_C2IQHEAD_SHIFT             (16U)
#define CAAM_CFIFOSTA_C2IQHEAD(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_CFIFOSTA_C2IQHEAD_SHIFT)) & CAAM_CFIFOSTA_C2IQHEAD_MASK)

#define CAAM_CFIFOSTA_C1IQHEAD_MASK              (0xFF000000U)
#define CAAM_CFIFOSTA_C1IQHEAD_SHIFT             (24U)
#define CAAM_CFIFOSTA_C1IQHEAD(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_CFIFOSTA_C1IQHEAD_SHIFT)) & CAAM_CFIFOSTA_C1IQHEAD_MASK)
/*! @} */

/* The count of CAAM_CFIFOSTA */
#define CAAM_CFIFOSTA_COUNT                      (1U)

/*! @name CNFIFO - CCB 0 iNformation FIFO When STYPE != 10b */
/*! @{ */

#define CAAM_CNFIFO_DL_MASK                      (0xFFFU)
#define CAAM_CNFIFO_DL_SHIFT                     (0U)
#define CAAM_CNFIFO_DL(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_DL_SHIFT)) & CAAM_CNFIFO_DL_MASK)

#define CAAM_CNFIFO_AST_MASK                     (0x4000U)
#define CAAM_CNFIFO_AST_SHIFT                    (14U)
#define CAAM_CNFIFO_AST(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_AST_SHIFT)) & CAAM_CNFIFO_AST_MASK)

#define CAAM_CNFIFO_OC_MASK                      (0x8000U)
#define CAAM_CNFIFO_OC_SHIFT                     (15U)
/*! OC
 *  0b0..Allow the final word to be popped from the Output Data FIFO.
 *  0b1..Don't pop the final word from the Output Data FIFO.
 */
#define CAAM_CNFIFO_OC(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_OC_SHIFT)) & CAAM_CNFIFO_OC_MASK)

#define CAAM_CNFIFO_PTYPE_MASK                   (0x70000U)
#define CAAM_CNFIFO_PTYPE_SHIFT                  (16U)
#define CAAM_CNFIFO_PTYPE(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_PTYPE_SHIFT)) & CAAM_CNFIFO_PTYPE_MASK)

#define CAAM_CNFIFO_BND_MASK                     (0x80000U)
#define CAAM_CNFIFO_BND_SHIFT                    (19U)
/*! BND
 *  0b0..Don't pad.
 *  0b1..Pad to the next 16-byte boundary.
 */
#define CAAM_CNFIFO_BND(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_BND_SHIFT)) & CAAM_CNFIFO_BND_MASK)

#define CAAM_CNFIFO_DTYPE_MASK                   (0xF00000U)
#define CAAM_CNFIFO_DTYPE_SHIFT                  (20U)
#define CAAM_CNFIFO_DTYPE(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_DTYPE_SHIFT)) & CAAM_CNFIFO_DTYPE_MASK)

#define CAAM_CNFIFO_STYPE_MASK                   (0x3000000U)
#define CAAM_CNFIFO_STYPE_SHIFT                  (24U)
#define CAAM_CNFIFO_STYPE(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_STYPE_SHIFT)) & CAAM_CNFIFO_STYPE_MASK)

#define CAAM_CNFIFO_FC1_MASK                     (0x4000000U)
#define CAAM_CNFIFO_FC1_SHIFT                    (26U)
/*! FC1
 *  0b0..Don't flush Class 1 data.
 *  0b1..Flush Class 1 data.
 */
#define CAAM_CNFIFO_FC1(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_FC1_SHIFT)) & CAAM_CNFIFO_FC1_MASK)

#define CAAM_CNFIFO_FC2_MASK                     (0x8000000U)
#define CAAM_CNFIFO_FC2_SHIFT                    (27U)
/*! FC2
 *  0b0..Don't flush Class 2 data.
 *  0b1..Flush Class 2 data.
 */
#define CAAM_CNFIFO_FC2(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_FC2_SHIFT)) & CAAM_CNFIFO_FC2_MASK)

#define CAAM_CNFIFO_LC1_MASK                     (0x10000000U)
#define CAAM_CNFIFO_LC1_SHIFT                    (28U)
/*! LC1
 *  0b0..This is not the last Class 1 data.
 *  0b1..This is the last Class 1 data.
 */
#define CAAM_CNFIFO_LC1(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_LC1_SHIFT)) & CAAM_CNFIFO_LC1_MASK)

#define CAAM_CNFIFO_LC2_MASK                     (0x20000000U)
#define CAAM_CNFIFO_LC2_SHIFT                    (29U)
/*! LC2
 *  0b0..This is not the last Class 2 data.
 *  0b1..This is the last Class 2 data.
 */
#define CAAM_CNFIFO_LC2(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_LC2_SHIFT)) & CAAM_CNFIFO_LC2_MASK)

#define CAAM_CNFIFO_DEST_MASK                    (0xC0000000U)
#define CAAM_CNFIFO_DEST_SHIFT                   (30U)
/*! DEST
 *  0b00..DECO Alignment Block. If DTYPE == Eh, data sent to the DECO Alignment Block is dropped. This is used to
 *        skip over input data. An error is generated if a DTYPE other than Eh (drop) or Fh (message) is used with
 *        the DECO Alignment Block destination.
 *  0b01..Class 1.
 *  0b10..Class 2.
 *  0b11..Both Class 1 and Class 2.
 */
#define CAAM_CNFIFO_DEST(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_DEST_SHIFT)) & CAAM_CNFIFO_DEST_MASK)
/*! @} */

/* The count of CAAM_CNFIFO */
#define CAAM_CNFIFO_COUNT                        (1U)

/*! @name CNFIFO_2 - CCB 0 iNformation FIFO When STYPE == 10b */
/*! @{ */

#define CAAM_CNFIFO_2_PL_MASK                    (0x7FU)
#define CAAM_CNFIFO_2_PL_SHIFT                   (0U)
#define CAAM_CNFIFO_2_PL(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_2_PL_SHIFT)) & CAAM_CNFIFO_2_PL_MASK)

#define CAAM_CNFIFO_2_PS_MASK                    (0x400U)
#define CAAM_CNFIFO_2_PS_SHIFT                   (10U)
/*! PS
 *  0b0..C2 CHA snoops pad data from padding block.
 *  0b1..C2 CHA snoops pad data from OFIFO.
 */
#define CAAM_CNFIFO_2_PS(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_2_PS_SHIFT)) & CAAM_CNFIFO_2_PS_MASK)

#define CAAM_CNFIFO_2_BM_MASK                    (0x800U)
#define CAAM_CNFIFO_2_BM_SHIFT                   (11U)
/*! BM
 *  0b0..When padding, pad to power-of-2 boundary.
 *  0b1..When padding, pad to power-of-2 boundary minus 1 byte.
 */
#define CAAM_CNFIFO_2_BM(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_2_BM_SHIFT)) & CAAM_CNFIFO_2_BM_MASK)

#define CAAM_CNFIFO_2_PR_MASK                    (0x8000U)
#define CAAM_CNFIFO_2_PR_SHIFT                   (15U)
/*! PR
 *  0b0..No prediction resistance.
 *  0b1..Prediction resistance.
 */
#define CAAM_CNFIFO_2_PR(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_2_PR_SHIFT)) & CAAM_CNFIFO_2_PR_MASK)

#define CAAM_CNFIFO_2_PTYPE_MASK                 (0x70000U)
#define CAAM_CNFIFO_2_PTYPE_SHIFT                (16U)
/*! PTYPE
 *  0b000..All Zero.
 *  0b001..Random with nonzero bytes.
 *  0b010..Incremented (starting with 01h), followed by a byte containing the value N-1, i.e., if N==1, a single byte is output with value 0h.
 *  0b011..Random.
 *  0b100..All Zero with last byte containing the number of 0 bytes, i.e., if N==1, a single byte is output with value 0h.
 *  0b101..Random with nonzero bytes with last byte 0.
 *  0b110..N bytes of padding all containing the value N-1.
 *  0b111..Random with nonzero bytes, with the last byte containing the value N-1.
 */
#define CAAM_CNFIFO_2_PTYPE(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_2_PTYPE_SHIFT)) & CAAM_CNFIFO_2_PTYPE_MASK)

#define CAAM_CNFIFO_2_BND_MASK                   (0x80000U)
#define CAAM_CNFIFO_2_BND_SHIFT                  (19U)
/*! BND
 *  0b0..Don't add boundary padding.
 *  0b1..Add boundary padding.
 */
#define CAAM_CNFIFO_2_BND(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_2_BND_SHIFT)) & CAAM_CNFIFO_2_BND_MASK)

#define CAAM_CNFIFO_2_DTYPE_MASK                 (0xF00000U)
#define CAAM_CNFIFO_2_DTYPE_SHIFT                (20U)
#define CAAM_CNFIFO_2_DTYPE(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_2_DTYPE_SHIFT)) & CAAM_CNFIFO_2_DTYPE_MASK)

#define CAAM_CNFIFO_2_STYPE_MASK                 (0x3000000U)
#define CAAM_CNFIFO_2_STYPE_SHIFT                (24U)
#define CAAM_CNFIFO_2_STYPE(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_2_STYPE_SHIFT)) & CAAM_CNFIFO_2_STYPE_MASK)

#define CAAM_CNFIFO_2_FC1_MASK                   (0x4000000U)
#define CAAM_CNFIFO_2_FC1_SHIFT                  (26U)
/*! FC1
 *  0b0..Don't flush the Class 1 data.
 *  0b1..Flush the Class 1 data.
 */
#define CAAM_CNFIFO_2_FC1(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_2_FC1_SHIFT)) & CAAM_CNFIFO_2_FC1_MASK)

#define CAAM_CNFIFO_2_FC2_MASK                   (0x8000000U)
#define CAAM_CNFIFO_2_FC2_SHIFT                  (27U)
/*! FC2
 *  0b0..Don't flush the Class 2 data.
 *  0b1..Flush the Class 2 data.
 */
#define CAAM_CNFIFO_2_FC2(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_2_FC2_SHIFT)) & CAAM_CNFIFO_2_FC2_MASK)

#define CAAM_CNFIFO_2_LC1_MASK                   (0x10000000U)
#define CAAM_CNFIFO_2_LC1_SHIFT                  (28U)
/*! LC1
 *  0b0..This is not the last Class 1 data.
 *  0b1..This is the last Class 1 data.
 */
#define CAAM_CNFIFO_2_LC1(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_2_LC1_SHIFT)) & CAAM_CNFIFO_2_LC1_MASK)

#define CAAM_CNFIFO_2_LC2_MASK                   (0x20000000U)
#define CAAM_CNFIFO_2_LC2_SHIFT                  (29U)
/*! LC2
 *  0b0..This is not the last Class 2 data.
 *  0b1..This is the last Class 2 data.
 */
#define CAAM_CNFIFO_2_LC2(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_2_LC2_SHIFT)) & CAAM_CNFIFO_2_LC2_MASK)

#define CAAM_CNFIFO_2_DEST_MASK                  (0xC0000000U)
#define CAAM_CNFIFO_2_DEST_SHIFT                 (30U)
/*! DEST
 *  0b00..DECO Alignment Block. If DTYPE is Eh, data sent to the DECO Alignment Block is dropped. This is used to
 *        skip over input data. An error is generated if a DTYPE other than Eh (drop) or Fh (message) is used with
 *        the DECO Alignment Block destination.
 *  0b01..Class 1.
 *  0b10..Class 2.
 *  0b11..Both Class 1 and Class 2.
 */
#define CAAM_CNFIFO_2_DEST(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_CNFIFO_2_DEST_SHIFT)) & CAAM_CNFIFO_2_DEST_MASK)
/*! @} */

/* The count of CAAM_CNFIFO_2 */
#define CAAM_CNFIFO_2_COUNT                      (1U)

/*! @name CIFIFO - CCB 0 Input Data FIFO */
/*! @{ */

#define CAAM_CIFIFO_IFIFO_MASK                   (0xFFFFFFFFU)
#define CAAM_CIFIFO_IFIFO_SHIFT                  (0U)
#define CAAM_CIFIFO_IFIFO(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_CIFIFO_IFIFO_SHIFT)) & CAAM_CIFIFO_IFIFO_MASK)
/*! @} */

/* The count of CAAM_CIFIFO */
#define CAAM_CIFIFO_COUNT                        (1U)

/*! @name COFIFO - CCB 0 Output Data FIFO */
/*! @{ */

#define CAAM_COFIFO_OFIFO_MASK                   (0xFFFFFFFFFFFFFFFFU)
#define CAAM_COFIFO_OFIFO_SHIFT                  (0U)
#define CAAM_COFIFO_OFIFO(x)                     (((uint64_t)(((uint64_t)(x)) << CAAM_COFIFO_OFIFO_SHIFT)) & CAAM_COFIFO_OFIFO_MASK)
/*! @} */

/* The count of CAAM_COFIFO */
#define CAAM_COFIFO_COUNT                        (1U)

/*! @name DJQCR_MS - DECO0 Job Queue Control Register, most-significant half */
/*! @{ */

#define CAAM_DJQCR_MS_ID_MASK                    (0x7U)
#define CAAM_DJQCR_MS_ID_SHIFT                   (0U)
#define CAAM_DJQCR_MS_ID(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_DJQCR_MS_ID_SHIFT)) & CAAM_DJQCR_MS_ID_MASK)

#define CAAM_DJQCR_MS_SRC_MASK                   (0x700U)
#define CAAM_DJQCR_MS_SRC_SHIFT                  (8U)
/*! SRC
 *  0b000..Job Ring 0
 *  0b001..Job Ring 1
 *  0b010..Job Ring 2
 *  0b011..Job Ring 3
 *  0b100..RTIC
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define CAAM_DJQCR_MS_SRC(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_DJQCR_MS_SRC_SHIFT)) & CAAM_DJQCR_MS_SRC_MASK)

#define CAAM_DJQCR_MS_AMTD_MASK                  (0x8000U)
#define CAAM_DJQCR_MS_AMTD_SHIFT                 (15U)
/*! AMTD
 *  0b0..The Allowed Make Trusted Descriptor bit was NOT set.
 *  0b1..The Allowed Make Trusted Descriptor bit was set.
 */
#define CAAM_DJQCR_MS_AMTD(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_DJQCR_MS_AMTD_SHIFT)) & CAAM_DJQCR_MS_AMTD_MASK)

#define CAAM_DJQCR_MS_SOB_MASK                   (0x10000U)
#define CAAM_DJQCR_MS_SOB_SHIFT                  (16U)
/*! SOB
 *  0b0..Shared Descriptor has NOT been loaded.
 *  0b1..Shared Descriptor HAS been loaded.
 */
#define CAAM_DJQCR_MS_SOB(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_DJQCR_MS_SOB_SHIFT)) & CAAM_DJQCR_MS_SOB_MASK)

#define CAAM_DJQCR_MS_DWS_MASK                   (0x80000U)
#define CAAM_DJQCR_MS_DWS_SHIFT                  (19U)
/*! DWS
 *  0b0..Double Word Swap is NOT set.
 *  0b1..Double Word Swap is set.
 */
#define CAAM_DJQCR_MS_DWS(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_DJQCR_MS_DWS_SHIFT)) & CAAM_DJQCR_MS_DWS_MASK)

#define CAAM_DJQCR_MS_SHR_FROM_MASK              (0x7000000U)
#define CAAM_DJQCR_MS_SHR_FROM_SHIFT             (24U)
#define CAAM_DJQCR_MS_SHR_FROM(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_DJQCR_MS_SHR_FROM_SHIFT)) & CAAM_DJQCR_MS_SHR_FROM_MASK)

#define CAAM_DJQCR_MS_ILE_MASK                   (0x8000000U)
#define CAAM_DJQCR_MS_ILE_SHIFT                  (27U)
/*! ILE
 *  0b0..No byte-swapping is performed for immediate data transferred to or from the Descriptor Buffer.
 *  0b1..Byte-swapping is performed for immediate data transferred to or from the Descriptor Buffer.
 */
#define CAAM_DJQCR_MS_ILE(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_DJQCR_MS_ILE_SHIFT)) & CAAM_DJQCR_MS_ILE_MASK)

#define CAAM_DJQCR_MS_FOUR_MASK                  (0x10000000U)
#define CAAM_DJQCR_MS_FOUR_SHIFT                 (28U)
/*! FOUR
 *  0b0..DECO has not been given at least four words of the descriptor.
 *  0b1..DECO has been given at least four words of the descriptor.
 */
#define CAAM_DJQCR_MS_FOUR(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_DJQCR_MS_FOUR_SHIFT)) & CAAM_DJQCR_MS_FOUR_MASK)

#define CAAM_DJQCR_MS_WHL_MASK                   (0x20000000U)
#define CAAM_DJQCR_MS_WHL_SHIFT                  (29U)
/*! WHL
 *  0b0..DECO has not been given the whole descriptor.
 *  0b1..DECO has been given the whole descriptor.
 */
#define CAAM_DJQCR_MS_WHL(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_DJQCR_MS_WHL_SHIFT)) & CAAM_DJQCR_MS_WHL_MASK)

#define CAAM_DJQCR_MS_SING_MASK                  (0x40000000U)
#define CAAM_DJQCR_MS_SING_SHIFT                 (30U)
/*! SING
 *  0b0..Do not tell DECO to execute the descriptor in single-step mode.
 *  0b1..Tell DECO to execute the descriptor in single-step mode.
 */
#define CAAM_DJQCR_MS_SING(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_DJQCR_MS_SING_SHIFT)) & CAAM_DJQCR_MS_SING_MASK)

#define CAAM_DJQCR_MS_STEP_MASK                  (0x80000000U)
#define CAAM_DJQCR_MS_STEP_SHIFT                 (31U)
/*! STEP
 *  0b0..DECO has not been told to execute the next command in the descriptor.
 *  0b1..DECO has been told to execute the next command in the descriptor.
 */
#define CAAM_DJQCR_MS_STEP(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_DJQCR_MS_STEP_SHIFT)) & CAAM_DJQCR_MS_STEP_MASK)
/*! @} */

/* The count of CAAM_DJQCR_MS */
#define CAAM_DJQCR_MS_COUNT                      (1U)

/*! @name DJQCR_LS - DECO0 Job Queue Control Register, least-significant half */
/*! @{ */

#define CAAM_DJQCR_LS_CMD_MASK                   (0xFFFFFFFFU)
#define CAAM_DJQCR_LS_CMD_SHIFT                  (0U)
#define CAAM_DJQCR_LS_CMD(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_DJQCR_LS_CMD_SHIFT)) & CAAM_DJQCR_LS_CMD_MASK)
/*! @} */

/* The count of CAAM_DJQCR_LS */
#define CAAM_DJQCR_LS_COUNT                      (1U)

/*! @name DDAR - DECO0 Descriptor Address Register */
/*! @{ */

#define CAAM_DDAR_DPTR_MASK                      (0xFFFFFFFFFU)
#define CAAM_DDAR_DPTR_SHIFT                     (0U)
#define CAAM_DDAR_DPTR(x)                        (((uint64_t)(((uint64_t)(x)) << CAAM_DDAR_DPTR_SHIFT)) & CAAM_DDAR_DPTR_MASK)
/*! @} */

/* The count of CAAM_DDAR */
#define CAAM_DDAR_COUNT                          (1U)

/*! @name DOPSTA_MS - DECO0 Operation Status Register, most-significant half */
/*! @{ */

#define CAAM_DOPSTA_MS_STATUS_MASK               (0xFFU)
#define CAAM_DOPSTA_MS_STATUS_SHIFT              (0U)
#define CAAM_DOPSTA_MS_STATUS(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_DOPSTA_MS_STATUS_SHIFT)) & CAAM_DOPSTA_MS_STATUS_MASK)

#define CAAM_DOPSTA_MS_COMMAND_INDEX_MASK        (0x7F00U)
#define CAAM_DOPSTA_MS_COMMAND_INDEX_SHIFT       (8U)
#define CAAM_DOPSTA_MS_COMMAND_INDEX(x)          (((uint32_t)(((uint32_t)(x)) << CAAM_DOPSTA_MS_COMMAND_INDEX_SHIFT)) & CAAM_DOPSTA_MS_COMMAND_INDEX_MASK)

#define CAAM_DOPSTA_MS_NLJ_MASK                  (0x8000000U)
#define CAAM_DOPSTA_MS_NLJ_SHIFT                 (27U)
/*! NLJ
 *  0b0..The original job descriptor running in this DECO has not caused another job descriptor to be executed.
 *  0b1..The original job descriptor running in this DECO has caused another job descriptor to be executed.
 */
#define CAAM_DOPSTA_MS_NLJ(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_DOPSTA_MS_NLJ_SHIFT)) & CAAM_DOPSTA_MS_NLJ_MASK)

#define CAAM_DOPSTA_MS_STATUS_TYPE_MASK          (0xF0000000U)
#define CAAM_DOPSTA_MS_STATUS_TYPE_SHIFT         (28U)
/*! STATUS_TYPE
 *  0b0000..no error
 *  0b0001..DMA error
 *  0b0010..CCB error
 *  0b0011..Jump Halt User Status
 *  0b0100..DECO error
 *  0b0101, 0b0110..Reserved
 *  0b0111..Jump Halt Condition Code
 */
#define CAAM_DOPSTA_MS_STATUS_TYPE(x)            (((uint32_t)(((uint32_t)(x)) << CAAM_DOPSTA_MS_STATUS_TYPE_SHIFT)) & CAAM_DOPSTA_MS_STATUS_TYPE_MASK)
/*! @} */

/* The count of CAAM_DOPSTA_MS */
#define CAAM_DOPSTA_MS_COUNT                     (1U)

/*! @name DOPSTA_LS - DECO0 Operation Status Register, least-significant half */
/*! @{ */

#define CAAM_DOPSTA_LS_OUT_CT_MASK               (0xFFFFFFFFU)
#define CAAM_DOPSTA_LS_OUT_CT_SHIFT              (0U)
#define CAAM_DOPSTA_LS_OUT_CT(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_DOPSTA_LS_OUT_CT_SHIFT)) & CAAM_DOPSTA_LS_OUT_CT_MASK)
/*! @} */

/* The count of CAAM_DOPSTA_LS */
#define CAAM_DOPSTA_LS_COUNT                     (1U)

/*! @name DPDIDSR - DECO0 Primary DID Status Register */
/*! @{ */

#define CAAM_DPDIDSR_PRIM_DID_MASK               (0xFU)
#define CAAM_DPDIDSR_PRIM_DID_SHIFT              (0U)
#define CAAM_DPDIDSR_PRIM_DID(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_DPDIDSR_PRIM_DID_SHIFT)) & CAAM_DPDIDSR_PRIM_DID_MASK)

#define CAAM_DPDIDSR_PRIM_ICID_MASK              (0x3FF80000U)
#define CAAM_DPDIDSR_PRIM_ICID_SHIFT             (19U)
#define CAAM_DPDIDSR_PRIM_ICID(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_DPDIDSR_PRIM_ICID_SHIFT)) & CAAM_DPDIDSR_PRIM_ICID_MASK)
/*! @} */

/* The count of CAAM_DPDIDSR */
#define CAAM_DPDIDSR_COUNT                       (1U)

/*! @name DODIDSR - DECO0 Output DID Status Register */
/*! @{ */

#define CAAM_DODIDSR_OUT_DID_MASK                (0xFU)
#define CAAM_DODIDSR_OUT_DID_SHIFT               (0U)
#define CAAM_DODIDSR_OUT_DID(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_DODIDSR_OUT_DID_SHIFT)) & CAAM_DODIDSR_OUT_DID_MASK)

#define CAAM_DODIDSR_OUT_ICID_MASK               (0x3FF80000U)
#define CAAM_DODIDSR_OUT_ICID_SHIFT              (19U)
#define CAAM_DODIDSR_OUT_ICID(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_DODIDSR_OUT_ICID_SHIFT)) & CAAM_DODIDSR_OUT_ICID_MASK)
/*! @} */

/* The count of CAAM_DODIDSR */
#define CAAM_DODIDSR_COUNT                       (1U)

/*! @name DMTH_MS - DECO0 Math Register 0_MS..DECO0 Math Register 3_MS */
/*! @{ */

#define CAAM_DMTH_MS_MATH_MS_MASK                (0xFFFFFFFFU)
#define CAAM_DMTH_MS_MATH_MS_SHIFT               (0U)
#define CAAM_DMTH_MS_MATH_MS(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_DMTH_MS_MATH_MS_SHIFT)) & CAAM_DMTH_MS_MATH_MS_MASK)
/*! @} */

/* The count of CAAM_DMTH_MS */
#define CAAM_DMTH_MS_COUNT                       (1U)

/* The count of CAAM_DMTH_MS */
#define CAAM_DMTH_MS_COUNT2                      (4U)

/*! @name DMTH_LS - DECO0 Math Register 0_LS..DECO0 Math Register 3_LS */
/*! @{ */

#define CAAM_DMTH_LS_MATH_LS_MASK                (0xFFFFFFFFU)
#define CAAM_DMTH_LS_MATH_LS_SHIFT               (0U)
#define CAAM_DMTH_LS_MATH_LS(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_DMTH_LS_MATH_LS_SHIFT)) & CAAM_DMTH_LS_MATH_LS_MASK)
/*! @} */

/* The count of CAAM_DMTH_LS */
#define CAAM_DMTH_LS_COUNT                       (1U)

/* The count of CAAM_DMTH_LS */
#define CAAM_DMTH_LS_COUNT2                      (4U)

/*! @name DGTR_0 - DECO0 Gather Table Register 0 Word 0 */
/*! @{ */

#define CAAM_DGTR_0_ADDRESS_POINTER_MASK         (0xFU)
#define CAAM_DGTR_0_ADDRESS_POINTER_SHIFT        (0U)
/*! ADDRESS_POINTER - most-significant bits of memory address pointed to by table entry
 */
#define CAAM_DGTR_0_ADDRESS_POINTER(x)           (((uint32_t)(((uint32_t)(x)) << CAAM_DGTR_0_ADDRESS_POINTER_SHIFT)) & CAAM_DGTR_0_ADDRESS_POINTER_MASK)
/*! @} */

/* The count of CAAM_DGTR_0 */
#define CAAM_DGTR_0_COUNT                        (1U)

/* The count of CAAM_DGTR_0 */
#define CAAM_DGTR_0_COUNT2                       (1U)

/*! @name DGTR_1 - DECO0 Gather Table Register 0 Word 1 */
/*! @{ */

#define CAAM_DGTR_1_ADDRESS_POINTER_MASK         (0xFFFFFFFFU)
#define CAAM_DGTR_1_ADDRESS_POINTER_SHIFT        (0U)
#define CAAM_DGTR_1_ADDRESS_POINTER(x)           (((uint32_t)(((uint32_t)(x)) << CAAM_DGTR_1_ADDRESS_POINTER_SHIFT)) & CAAM_DGTR_1_ADDRESS_POINTER_MASK)
/*! @} */

/* The count of CAAM_DGTR_1 */
#define CAAM_DGTR_1_COUNT                        (1U)

/* The count of CAAM_DGTR_1 */
#define CAAM_DGTR_1_COUNT2                       (1U)

/*! @name DGTR_2 - DECO0 Gather Table Register 0 Word 2 */
/*! @{ */

#define CAAM_DGTR_2_Length_MASK                  (0x3FFFFFFFU)
#define CAAM_DGTR_2_Length_SHIFT                 (0U)
#define CAAM_DGTR_2_Length(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_DGTR_2_Length_SHIFT)) & CAAM_DGTR_2_Length_MASK)

#define CAAM_DGTR_2_F_MASK                       (0x40000000U)
#define CAAM_DGTR_2_F_SHIFT                      (30U)
/*! F
 *  0b0..This is not the last entry of the SGT.
 *  0b1..This is the last entry of the SGT.
 */
#define CAAM_DGTR_2_F(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_DGTR_2_F_SHIFT)) & CAAM_DGTR_2_F_MASK)

#define CAAM_DGTR_2_E_MASK                       (0x80000000U)
#define CAAM_DGTR_2_E_SHIFT                      (31U)
/*! E
 *  0b0..Address Pointer points to a memory buffer.
 *  0b1..Address Pointer points to a Scatter/Gather Table Entry.
 */
#define CAAM_DGTR_2_E(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_DGTR_2_E_SHIFT)) & CAAM_DGTR_2_E_MASK)
/*! @} */

/* The count of CAAM_DGTR_2 */
#define CAAM_DGTR_2_COUNT                        (1U)

/* The count of CAAM_DGTR_2 */
#define CAAM_DGTR_2_COUNT2                       (1U)

/*! @name DGTR_3 - DECO0 Gather Table Register 0 Word 3 */
/*! @{ */

#define CAAM_DGTR_3_Offset_MASK                  (0x1FFFU)
#define CAAM_DGTR_3_Offset_SHIFT                 (0U)
#define CAAM_DGTR_3_Offset(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_DGTR_3_Offset_SHIFT)) & CAAM_DGTR_3_Offset_MASK)
/*! @} */

/* The count of CAAM_DGTR_3 */
#define CAAM_DGTR_3_COUNT                        (1U)

/* The count of CAAM_DGTR_3 */
#define CAAM_DGTR_3_COUNT2                       (1U)

/*! @name DSTR_0 - DECO0 Scatter Table Register 0 Word 0 */
/*! @{ */

#define CAAM_DSTR_0_ADDRESS_POINTER_MASK         (0xFU)
#define CAAM_DSTR_0_ADDRESS_POINTER_SHIFT        (0U)
/*! ADDRESS_POINTER - most-significant bits of memory address pointed to by table entry
 */
#define CAAM_DSTR_0_ADDRESS_POINTER(x)           (((uint32_t)(((uint32_t)(x)) << CAAM_DSTR_0_ADDRESS_POINTER_SHIFT)) & CAAM_DSTR_0_ADDRESS_POINTER_MASK)
/*! @} */

/* The count of CAAM_DSTR_0 */
#define CAAM_DSTR_0_COUNT                        (1U)

/* The count of CAAM_DSTR_0 */
#define CAAM_DSTR_0_COUNT2                       (1U)

/*! @name DSTR_1 - DECO0 Scatter Table Register 0 Word 1 */
/*! @{ */

#define CAAM_DSTR_1_ADDRESS_POINTER_MASK         (0xFFFFFFFFU)
#define CAAM_DSTR_1_ADDRESS_POINTER_SHIFT        (0U)
#define CAAM_DSTR_1_ADDRESS_POINTER(x)           (((uint32_t)(((uint32_t)(x)) << CAAM_DSTR_1_ADDRESS_POINTER_SHIFT)) & CAAM_DSTR_1_ADDRESS_POINTER_MASK)
/*! @} */

/* The count of CAAM_DSTR_1 */
#define CAAM_DSTR_1_COUNT                        (1U)

/* The count of CAAM_DSTR_1 */
#define CAAM_DSTR_1_COUNT2                       (1U)

/*! @name DSTR_2 - DECO0 Scatter Table Register 0 Word 2 */
/*! @{ */

#define CAAM_DSTR_2_Length_MASK                  (0x3FFFFFFFU)
#define CAAM_DSTR_2_Length_SHIFT                 (0U)
#define CAAM_DSTR_2_Length(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_DSTR_2_Length_SHIFT)) & CAAM_DSTR_2_Length_MASK)

#define CAAM_DSTR_2_F_MASK                       (0x40000000U)
#define CAAM_DSTR_2_F_SHIFT                      (30U)
/*! F
 *  0b0..This is not the last entry of the SGT.
 *  0b1..This is the last entry of the SGT.
 */
#define CAAM_DSTR_2_F(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_DSTR_2_F_SHIFT)) & CAAM_DSTR_2_F_MASK)

#define CAAM_DSTR_2_E_MASK                       (0x80000000U)
#define CAAM_DSTR_2_E_SHIFT                      (31U)
/*! E
 *  0b0..Address Pointer points to a memory buffer.
 *  0b1..Address Pointer points to a Scatter/Gather Table Entry.
 */
#define CAAM_DSTR_2_E(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_DSTR_2_E_SHIFT)) & CAAM_DSTR_2_E_MASK)
/*! @} */

/* The count of CAAM_DSTR_2 */
#define CAAM_DSTR_2_COUNT                        (1U)

/* The count of CAAM_DSTR_2 */
#define CAAM_DSTR_2_COUNT2                       (1U)

/*! @name DSTR_3 - DECO0 Scatter Table Register 0 Word 3 */
/*! @{ */

#define CAAM_DSTR_3_Offset_MASK                  (0x1FFFU)
#define CAAM_DSTR_3_Offset_SHIFT                 (0U)
#define CAAM_DSTR_3_Offset(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_DSTR_3_Offset_SHIFT)) & CAAM_DSTR_3_Offset_MASK)
/*! @} */

/* The count of CAAM_DSTR_3 */
#define CAAM_DSTR_3_COUNT                        (1U)

/* The count of CAAM_DSTR_3 */
#define CAAM_DSTR_3_COUNT2                       (1U)

/*! @name DDESB - DECO0 Descriptor Buffer Word 0..DECO0 Descriptor Buffer Word 63 */
/*! @{ */

#define CAAM_DDESB_DESBW_MASK                    (0xFFFFFFFFU)
#define CAAM_DDESB_DESBW_SHIFT                   (0U)
#define CAAM_DDESB_DESBW(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_DDESB_DESBW_SHIFT)) & CAAM_DDESB_DESBW_MASK)
/*! @} */

/* The count of CAAM_DDESB */
#define CAAM_DDESB_COUNT                         (1U)

/* The count of CAAM_DDESB */
#define CAAM_DDESB_COUNT2                        (64U)

/*! @name DDJR - DECO0 Debug Job Register */
/*! @{ */

#define CAAM_DDJR_ID_MASK                        (0x7U)
#define CAAM_DDJR_ID_SHIFT                       (0U)
#define CAAM_DDJR_ID(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_DDJR_ID_SHIFT)) & CAAM_DDJR_ID_MASK)

#define CAAM_DDJR_SRC_MASK                       (0x700U)
#define CAAM_DDJR_SRC_SHIFT                      (8U)
/*! SRC
 *  0b000..Job Ring 0
 *  0b001..Job Ring 1
 *  0b010..Job Ring 2
 *  0b011..Job Ring 3
 *  0b100..RTIC
 *  0b101, 0b110, 0b111..Reserved
 */
#define CAAM_DDJR_SRC(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_DDJR_SRC_SHIFT)) & CAAM_DDJR_SRC_MASK)

#define CAAM_DDJR_JDDS_MASK                      (0x4000U)
#define CAAM_DDJR_JDDS_SHIFT                     (14U)
/*! JDDS
 *  0b1..SEQ DID
 *  0b0..Non-SEQ DID
 */
#define CAAM_DDJR_JDDS(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_DDJR_JDDS_SHIFT)) & CAAM_DDJR_JDDS_MASK)

#define CAAM_DDJR_AMTD_MASK                      (0x8000U)
#define CAAM_DDJR_AMTD_SHIFT                     (15U)
/*! AMTD
 *  0b0..The Allowed Make Trusted Descriptor bit was NOT set.
 *  0b1..The Allowed Make Trusted Descriptor bit was set.
 */
#define CAAM_DDJR_AMTD(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_DDJR_AMTD_SHIFT)) & CAAM_DDJR_AMTD_MASK)

#define CAAM_DDJR_GSD_MASK                       (0x10000U)
#define CAAM_DDJR_GSD_SHIFT                      (16U)
/*! GSD
 *  0b0..Shared Descriptor was NOT obtained from another DECO.
 *  0b1..Shared Descriptor was obtained from another DECO.
 */
#define CAAM_DDJR_GSD(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_DDJR_GSD_SHIFT)) & CAAM_DDJR_GSD_MASK)

#define CAAM_DDJR_DWS_MASK                       (0x80000U)
#define CAAM_DDJR_DWS_SHIFT                      (19U)
/*! DWS
 *  0b0..Double Word Swap is NOT set.
 *  0b1..Double Word Swap is set.
 */
#define CAAM_DDJR_DWS(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_DDJR_DWS_SHIFT)) & CAAM_DDJR_DWS_MASK)

#define CAAM_DDJR_SHR_FROM_MASK                  (0x7000000U)
#define CAAM_DDJR_SHR_FROM_SHIFT                 (24U)
#define CAAM_DDJR_SHR_FROM(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_DDJR_SHR_FROM_SHIFT)) & CAAM_DDJR_SHR_FROM_MASK)

#define CAAM_DDJR_ILE_MASK                       (0x8000000U)
#define CAAM_DDJR_ILE_SHIFT                      (27U)
/*! ILE
 *  0b0..No byte-swapping is performed for immediate data transferred to or from the Descriptor Buffer.
 *  0b1..Byte-swapping is performed for immediate data transferred to or from the Descriptor Buffer.
 */
#define CAAM_DDJR_ILE(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_DDJR_ILE_SHIFT)) & CAAM_DDJR_ILE_MASK)

#define CAAM_DDJR_FOUR_MASK                      (0x10000000U)
#define CAAM_DDJR_FOUR_SHIFT                     (28U)
/*! FOUR
 *  0b0..DECO has not been given at least four words of the descriptor.
 *  0b1..DECO has been given at least four words of the descriptor.
 */
#define CAAM_DDJR_FOUR(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_DDJR_FOUR_SHIFT)) & CAAM_DDJR_FOUR_MASK)

#define CAAM_DDJR_WHL_MASK                       (0x20000000U)
#define CAAM_DDJR_WHL_SHIFT                      (29U)
/*! WHL
 *  0b0..DECO has not been given the whole descriptor.
 *  0b1..DECO has been given the whole descriptor.
 */
#define CAAM_DDJR_WHL(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_DDJR_WHL_SHIFT)) & CAAM_DDJR_WHL_MASK)

#define CAAM_DDJR_SING_MASK                      (0x40000000U)
#define CAAM_DDJR_SING_SHIFT                     (30U)
/*! SING
 *  0b0..DECO has not been told to execute the descriptor in single-step mode.
 *  0b1..DECO has been told to execute the descriptor in single-step mode.
 */
#define CAAM_DDJR_SING(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_DDJR_SING_SHIFT)) & CAAM_DDJR_SING_MASK)

#define CAAM_DDJR_STEP_MASK                      (0x80000000U)
#define CAAM_DDJR_STEP_SHIFT                     (31U)
/*! STEP
 *  0b0..DECO has not been told to execute the next command in the descriptor.
 *  0b1..DECO has been told to execute the next command in the descriptor.
 */
#define CAAM_DDJR_STEP(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_DDJR_STEP_SHIFT)) & CAAM_DDJR_STEP_MASK)
/*! @} */

/* The count of CAAM_DDJR */
#define CAAM_DDJR_COUNT                          (1U)

/*! @name DDDR - DECO0 Debug DECO Register */
/*! @{ */

#define CAAM_DDDR_CT_MASK                        (0x1U)
#define CAAM_DDDR_CT_SHIFT                       (0U)
/*! CT
 *  0b0..This DECO is NOTcurrently generating the signature of a Trusted Descriptor.
 *  0b1..This DECO is currently generating the signature of a Trusted Descriptor.
 */
#define CAAM_DDDR_CT(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_CT_SHIFT)) & CAAM_DDDR_CT_MASK)

#define CAAM_DDDR_BRB_MASK                       (0x2U)
#define CAAM_DDDR_BRB_SHIFT                      (1U)
/*! BRB
 *  0b0..The READ machine in the Burster is not busy.
 *  0b1..The READ machine in the Burster is busy.
 */
#define CAAM_DDDR_BRB(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_BRB_SHIFT)) & CAAM_DDDR_BRB_MASK)

#define CAAM_DDDR_BWB_MASK                       (0x4U)
#define CAAM_DDDR_BWB_SHIFT                      (2U)
/*! BWB
 *  0b0..The WRITE machine in the Burster is not busy.
 *  0b1..The WRITE machine in the Burster is busy.
 */
#define CAAM_DDDR_BWB(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_BWB_SHIFT)) & CAAM_DDDR_BWB_MASK)

#define CAAM_DDDR_NC_MASK                        (0x8U)
#define CAAM_DDDR_NC_SHIFT                       (3U)
/*! NC
 *  0b0..This DECO is currently executing a command.
 *  0b1..This DECO is not currently executing a command.
 */
#define CAAM_DDDR_NC(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_NC_SHIFT)) & CAAM_DDDR_NC_MASK)

#define CAAM_DDDR_CSA_MASK                       (0x10U)
#define CAAM_DDDR_CSA_SHIFT                      (4U)
#define CAAM_DDDR_CSA(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_CSA_SHIFT)) & CAAM_DDDR_CSA_MASK)

#define CAAM_DDDR_CMD_STAGE_MASK                 (0xE0U)
#define CAAM_DDDR_CMD_STAGE_SHIFT                (5U)
#define CAAM_DDDR_CMD_STAGE(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_CMD_STAGE_SHIFT)) & CAAM_DDDR_CMD_STAGE_MASK)

#define CAAM_DDDR_CMD_INDEX_MASK                 (0x3F00U)
#define CAAM_DDDR_CMD_INDEX_SHIFT                (8U)
#define CAAM_DDDR_CMD_INDEX(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_CMD_INDEX_SHIFT)) & CAAM_DDDR_CMD_INDEX_MASK)

#define CAAM_DDDR_NLJ_MASK                       (0x4000U)
#define CAAM_DDDR_NLJ_SHIFT                      (14U)
/*! NLJ
 *  0b0..The original job descriptor running in this DECO has not caused another job descriptor to be executed.
 *  0b1..The original job descriptor running in this DECO has caused another job descriptor to be executed.
 */
#define CAAM_DDDR_NLJ(x)                         (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_NLJ_SHIFT)) & CAAM_DDDR_NLJ_MASK)

#define CAAM_DDDR_PTCL_RUN_MASK                  (0x8000U)
#define CAAM_DDDR_PTCL_RUN_SHIFT                 (15U)
/*! PTCL_RUN
 *  0b0..No protocol is running in this DECO.
 *  0b1..A protocol is running in this DECO.
 */
#define CAAM_DDDR_PTCL_RUN(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_PTCL_RUN_SHIFT)) & CAAM_DDDR_PTCL_RUN_MASK)

#define CAAM_DDDR_PDB_STALL_MASK                 (0x30000U)
#define CAAM_DDDR_PDB_STALL_SHIFT                (16U)
#define CAAM_DDDR_PDB_STALL(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_PDB_STALL_SHIFT)) & CAAM_DDDR_PDB_STALL_MASK)

#define CAAM_DDDR_PDB_WB_ST_MASK                 (0xC0000U)
#define CAAM_DDDR_PDB_WB_ST_SHIFT                (18U)
#define CAAM_DDDR_PDB_WB_ST(x)                   (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_PDB_WB_ST_SHIFT)) & CAAM_DDDR_PDB_WB_ST_MASK)

#define CAAM_DDDR_DECO_STATE_MASK                (0xF00000U)
#define CAAM_DDDR_DECO_STATE_SHIFT               (20U)
#define CAAM_DDDR_DECO_STATE(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_DECO_STATE_SHIFT)) & CAAM_DDDR_DECO_STATE_MASK)

#define CAAM_DDDR_NSEQLSEL_MASK                  (0x3000000U)
#define CAAM_DDDR_NSEQLSEL_SHIFT                 (24U)
/*! NSEQLSEL
 *  0b01..SEQ DID
 *  0b10..Non-SEQ DID
 *  0b11..Trusted DID
 */
#define CAAM_DDDR_NSEQLSEL(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_NSEQLSEL_SHIFT)) & CAAM_DDDR_NSEQLSEL_MASK)

#define CAAM_DDDR_SEQLSEL_MASK                   (0xC000000U)
#define CAAM_DDDR_SEQLSEL_SHIFT                  (26U)
/*! SEQLSEL
 *  0b01..SEQ DID
 *  0b10..Non-SEQ DID
 *  0b11..Trusted DID
 */
#define CAAM_DDDR_SEQLSEL(x)                     (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_SEQLSEL_SHIFT)) & CAAM_DDDR_SEQLSEL_MASK)

#define CAAM_DDDR_TRCT_MASK                      (0x30000000U)
#define CAAM_DDDR_TRCT_SHIFT                     (28U)
#define CAAM_DDDR_TRCT(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_TRCT_SHIFT)) & CAAM_DDDR_TRCT_MASK)

#define CAAM_DDDR_SD_MASK                        (0x40000000U)
#define CAAM_DDDR_SD_SHIFT                       (30U)
/*! SD
 *  0b0..This DECO has not received a shared descriptor from another DECO.
 *  0b1..This DECO has received a shared descriptor from another DECO.
 */
#define CAAM_DDDR_SD(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_SD_SHIFT)) & CAAM_DDDR_SD_MASK)

#define CAAM_DDDR_VALID_MASK                     (0x80000000U)
#define CAAM_DDDR_VALID_SHIFT                    (31U)
/*! VALID
 *  0b0..No descriptor is currently running in this DECO.
 *  0b1..There is currently a descriptor running in this DECO.
 */
#define CAAM_DDDR_VALID(x)                       (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_VALID_SHIFT)) & CAAM_DDDR_VALID_MASK)
/*! @} */

/* The count of CAAM_DDDR */
#define CAAM_DDDR_COUNT                          (1U)

/*! @name DDJP - DECO0 Debug Job Pointer */
/*! @{ */

#define CAAM_DDJP_JDPTR_MASK                     (0xFFFFFFFFFU)
#define CAAM_DDJP_JDPTR_SHIFT                    (0U)
#define CAAM_DDJP_JDPTR(x)                       (((uint64_t)(((uint64_t)(x)) << CAAM_DDJP_JDPTR_SHIFT)) & CAAM_DDJP_JDPTR_MASK)
/*! @} */

/* The count of CAAM_DDJP */
#define CAAM_DDJP_COUNT                          (1U)

/*! @name DSDP - DECO0 Debug Shared Pointer */
/*! @{ */

#define CAAM_DSDP_SDPTR_MASK                     (0xFFFFFFFFFU)
#define CAAM_DSDP_SDPTR_SHIFT                    (0U)
#define CAAM_DSDP_SDPTR(x)                       (((uint64_t)(((uint64_t)(x)) << CAAM_DSDP_SDPTR_SHIFT)) & CAAM_DSDP_SDPTR_MASK)
/*! @} */

/* The count of CAAM_DSDP */
#define CAAM_DSDP_COUNT                          (1U)

/*! @name DDDR_MS - DECO0 Debug DID, most-significant half */
/*! @{ */

#define CAAM_DDDR_MS_PRIM_DID_MASK               (0xFU)
#define CAAM_DDDR_MS_PRIM_DID_SHIFT              (0U)
#define CAAM_DDDR_MS_PRIM_DID(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_MS_PRIM_DID_SHIFT)) & CAAM_DDDR_MS_PRIM_DID_MASK)

#define CAAM_DDDR_MS_PRIM_TZ_MASK                (0x10U)
#define CAAM_DDDR_MS_PRIM_TZ_SHIFT               (4U)
/*! PRIM_TZ
 *  0b0..TrustZone NonSecureWorld
 *  0b1..TrustZone SecureWorld
 */
#define CAAM_DDDR_MS_PRIM_TZ(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_MS_PRIM_TZ_SHIFT)) & CAAM_DDDR_MS_PRIM_TZ_MASK)

#define CAAM_DDDR_MS_PRIM_ICID_MASK              (0xFFE0U)
#define CAAM_DDDR_MS_PRIM_ICID_SHIFT             (5U)
#define CAAM_DDDR_MS_PRIM_ICID(x)                (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_MS_PRIM_ICID_SHIFT)) & CAAM_DDDR_MS_PRIM_ICID_MASK)

#define CAAM_DDDR_MS_OUT_DID_MASK                (0xF0000U)
#define CAAM_DDDR_MS_OUT_DID_SHIFT               (16U)
#define CAAM_DDDR_MS_OUT_DID(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_MS_OUT_DID_SHIFT)) & CAAM_DDDR_MS_OUT_DID_MASK)

#define CAAM_DDDR_MS_OUT_ICID_MASK               (0xFFE00000U)
#define CAAM_DDDR_MS_OUT_ICID_SHIFT              (21U)
#define CAAM_DDDR_MS_OUT_ICID(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_MS_OUT_ICID_SHIFT)) & CAAM_DDDR_MS_OUT_ICID_MASK)
/*! @} */

/* The count of CAAM_DDDR_MS */
#define CAAM_DDDR_MS_COUNT                       (1U)

/*! @name DDDR_LS - DECO0 Debug DID, least-significant half */
/*! @{ */

#define CAAM_DDDR_LS_OUT_DID_MASK                (0xFU)
#define CAAM_DDDR_LS_OUT_DID_SHIFT               (0U)
#define CAAM_DDDR_LS_OUT_DID(x)                  (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_LS_OUT_DID_SHIFT)) & CAAM_DDDR_LS_OUT_DID_MASK)

#define CAAM_DDDR_LS_OUT_ICID_MASK               (0x3FF80000U)
#define CAAM_DDDR_LS_OUT_ICID_SHIFT              (19U)
#define CAAM_DDDR_LS_OUT_ICID(x)                 (((uint32_t)(((uint32_t)(x)) << CAAM_DDDR_LS_OUT_ICID_SHIFT)) & CAAM_DDDR_LS_OUT_ICID_MASK)
/*! @} */

/* The count of CAAM_DDDR_LS */
#define CAAM_DDDR_LS_COUNT                       (1U)

/*! @name SOL - Sequence Output Length Register */
/*! @{ */

#define CAAM_SOL_SOL_MASK                        (0xFFFFFFFFU)
#define CAAM_SOL_SOL_SHIFT                       (0U)
#define CAAM_SOL_SOL(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_SOL_SOL_SHIFT)) & CAAM_SOL_SOL_MASK)
/*! @} */

/* The count of CAAM_SOL */
#define CAAM_SOL_COUNT                           (1U)

/*! @name VSOL - Variable Sequence Output Length Register */
/*! @{ */

#define CAAM_VSOL_VSOL_MASK                      (0xFFFFFFFFU)
#define CAAM_VSOL_VSOL_SHIFT                     (0U)
#define CAAM_VSOL_VSOL(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_VSOL_VSOL_SHIFT)) & CAAM_VSOL_VSOL_MASK)
/*! @} */

/* The count of CAAM_VSOL */
#define CAAM_VSOL_COUNT                          (1U)

/*! @name SIL - Sequence Input Length Register */
/*! @{ */

#define CAAM_SIL_SIL_MASK                        (0xFFFFFFFFU)
#define CAAM_SIL_SIL_SHIFT                       (0U)
#define CAAM_SIL_SIL(x)                          (((uint32_t)(((uint32_t)(x)) << CAAM_SIL_SIL_SHIFT)) & CAAM_SIL_SIL_MASK)
/*! @} */

/* The count of CAAM_SIL */
#define CAAM_SIL_COUNT                           (1U)

/*! @name VSIL - Variable Sequence Input Length Register */
/*! @{ */

#define CAAM_VSIL_VSIL_MASK                      (0xFFFFFFFFU)
#define CAAM_VSIL_VSIL_SHIFT                     (0U)
#define CAAM_VSIL_VSIL(x)                        (((uint32_t)(((uint32_t)(x)) << CAAM_VSIL_VSIL_SHIFT)) & CAAM_VSIL_VSIL_MASK)
/*! @} */

/* The count of CAAM_VSIL */
#define CAAM_VSIL_COUNT                          (1U)

/*! @name DPOVRD - Protocol Override Register */
/*! @{ */

#define CAAM_DPOVRD_DPOVRD_MASK                  (0xFFFFFFFFU)
#define CAAM_DPOVRD_DPOVRD_SHIFT                 (0U)
#define CAAM_DPOVRD_DPOVRD(x)                    (((uint32_t)(((uint32_t)(x)) << CAAM_DPOVRD_DPOVRD_SHIFT)) & CAAM_DPOVRD_DPOVRD_MASK)
/*! @} */

/* The count of CAAM_DPOVRD */
#define CAAM_DPOVRD_COUNT                        (1U)

/*! @name UVSOL - Variable Sequence Output Length Register; Upper 32 bits */
/*! @{ */

#define CAAM_UVSOL_UVSOL_MASK                    (0xFFFFFFFFU)
#define CAAM_UVSOL_UVSOL_SHIFT                   (0U)
#define CAAM_UVSOL_UVSOL(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_UVSOL_UVSOL_SHIFT)) & CAAM_UVSOL_UVSOL_MASK)
/*! @} */

/* The count of CAAM_UVSOL */
#define CAAM_UVSOL_COUNT                         (1U)

/*! @name UVSIL - Variable Sequence Input Length Register; Upper 32 bits */
/*! @{ */

#define CAAM_UVSIL_UVSIL_MASK                    (0xFFFFFFFFU)
#define CAAM_UVSIL_UVSIL_SHIFT                   (0U)
#define CAAM_UVSIL_UVSIL(x)                      (((uint32_t)(((uint32_t)(x)) << CAAM_UVSIL_UVSIL_SHIFT)) & CAAM_UVSIL_UVSIL_MASK)
/*! @} */

/* The count of CAAM_UVSIL */
#define CAAM_UVSIL_COUNT                         (1U)


/*!
 * @}
 */ /* end of group CAAM_Register_Masks */


/* CAAM - Peripheral instance base addresses */
/** Peripheral CAAM base address */
#define CAAM_BASE                                (0x40440000u)
/** Peripheral CAAM base pointer */
#define CAAM                                     ((CAAM_Type *)CAAM_BASE)
/** Array initializer of CAAM peripheral base addresses */
#define CAAM_BASE_ADDRS                          { CAAM_BASE }
/** Array initializer of CAAM peripheral base pointers */
#define CAAM_BASE_PTRS                           { CAAM }

/*!
 * @}
 */ /* end of group CAAM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CAN Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Peripheral_Access_Layer CAN Peripheral Access Layer
 * @{
 */

/** CAN - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR;                               /**< Module Configuration register, offset: 0x0 */
  __IO uint32_t CTRL1;                             /**< Control 1 register, offset: 0x4 */
  __IO uint32_t TIMER;                             /**< Free Running Timer, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __IO uint32_t RXMGMASK;                          /**< Rx Mailboxes Global Mask register, offset: 0x10 */
  __IO uint32_t RX14MASK;                          /**< Rx 14 Mask register, offset: 0x14 */
  __IO uint32_t RX15MASK;                          /**< Rx 15 Mask register, offset: 0x18 */
  __IO uint32_t ECR;                               /**< Error Counter, offset: 0x1C */
  __IO uint32_t ESR1;                              /**< Error and Status 1 register, offset: 0x20 */
  __IO uint32_t IMASK2;                            /**< Interrupt Masks 2 register, offset: 0x24 */
  __IO uint32_t IMASK1;      