/*
*         Copyright (c), NXP Semiconductors Caen / France
*
*                     (C)NXP Semiconductors
*       All rights are reserved. Reproduction in whole or in part is
*      prohibited without the written consent of the copyright owner.
*  NXP reserves the right to make changes without notice at any time.
* NXP makes no warranty, expressed, implied or statutory, including but
* not limited to any implied warranty of merchantability or fitness for any
*particular purpose, or that the use will not infringe any third party patent,
* copyright or trademark. NXP must not be liable for any loss or damage
*                          arising from its use.
*/

#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <tool.h>
#include <tml.h>
#include <sFwu.h>

#define FORCE_DWL false

extern uint8_t gphDnldNfc_DlSequence[];
extern uint16_t gphDnldNfc_DlSeqSz;

void GetFWversion(sFWu_version_t *pVer)
{
    uint8_t error;

    error = sFWu_GetVersion(pVer);
    if (error)
    {
        PRINTF("Error getting version: 0x%.2X\n", error);
    }
    else
    {
        PRINTF("Current version: %02X.%02X.%02X\n", pVer->ROM, pVer->MAJ, pVer->MIN);
    }
}

void nfc_example(void)
{
    uint8_t error;
    sFWu_version_t Ver = {0};

    tml_Connect();
    tml_EnterDwlMode();

    /* Retrieve current FW version in IC */
    GetFWversion(&Ver);

    /* Check current FW version from binary */
    if ((Ver.MAJ == gphDnldNfc_DlSequence[5]) && (Ver.MIN == gphDnldNfc_DlSequence[4]) && (FORCE_DWL == false))
    {
        PRINTF("FW already up to date\n");
    }
    else
    {
        /* Downloading FW according sequence from FW c file */
        PRINTF("Downloading FW version %.2X.%.2X\n", gphDnldNfc_DlSequence[5], gphDnldNfc_DlSequence[4]);
        error = sFWu_Download(gphDnldNfc_DlSequence, gphDnldNfc_DlSeqSz);
        if (error)
        {
            PRINTF("Error downloading: 0x%.2X\n", error);
        }
        else
        {
            PRINTF("Download succeed\n");
            /* Retrieve current FW version in IC */
            GetFWversion(&Ver);
        }
    }

    tml_LeaveDwlMode();
    tml_Disconnect();
}
