#ifndef LPC43xx_GPIO_H
#define LPC43xx_GPIO_H

/* Includes ------------------------------------------------------------------- */
#include "lpc43xx.h"
#include "lpc_types.h"

#ifdef __cplusplus
extern "C"
{
#endif



typedef enum {
	GPIO_INPUT = 0,
	GPIO_OUTPUT,	

} LPC43XX_GPIO_DIR;

#define LPC43XX_SET_GPIO_OUTPUT(group, bit)(LPC_GPIO_PORT->DIR[group] |= (uint32_t)(1 << bit))
#define LPC43XX_SET_GPIO_INPUT(group, bit)(LPC_GPIO_PORT->DIR[group] &= ~(uint32_t)(1 << bit))
#define LPC43XX_SET_GPO_HI(group, bit) (LPC_GPIO_PORT->SET[group] |= (uint32_t)(1 << bit))
#define LPC43XX_SET_GPO_LO(group, bit) (LPC_GPIO_PORT->CLR[group] |= (uint32_t)(1 << bit))

#ifdef __cplusplus
}
#endif


#endif /* LPC43xx_GPIO_H */

