#ifndef _APPCFG_H_
#define _APPCFG_H_

// configurations goes from here
// MAKE SURE YOUR PIN CONFIGURATIONS FITS TO YOUR BOARD CONNECTION!
// otherwise not only no image, but also can damage camera!

// define this macro to non-zero after you have configured
#define IS_CFG_DONE 	1

// 0 = color, non-0 = grayscale
#define IS_GRAYSCALE	0


// the following 5 configurations have different combinations, you can test with different values
// and there are up to 384 different combinations that works, with different phenomenon
// default is:
//	IS_M0_HANDLE_SGPIO = 1, IS_USE_ANTI_TEAR = 1, IS_TWIN_RXBUF = 1, FRABUF_Q_CAPACITY = 2, TEST_MODE = TEST_NONE
//	usually, you should always set IS_USE_ANTI_TEAR to 1 (of course!), IS_TWIN_RXBUF = 1, FRABUF_Q_CAPACITY >= 2
#define SCT_MODULE 1
#define SGPIO_MODULE 0


// whether use M0 to handle SGPIO, M0 can offload M4 and make FPS higher
// seems always need to use M0 if running from SPIFI
#define IS_M0_HANDLE_SGPIO	1

// set to non-zero if you want anti-tearing enabled, should always be the case unless you want to reproduce the tearing effect
#define IS_USE_ANTI_TEAR	1

// use twin receving buffers or not
// this has NOTHING to do with tearing effect
// but twin receiving buffer can make FPS higher by eliminating "1 frame latency",
// this is achieved by allowing camera to "pre-fetch" new image
#define IS_TWIN_RXBUF		1	// 0 = single receiving buffer, !0 = twin receiving buffer

// define capacity of LCD framebuffer queue, 
//	>3 is in most cases, just killing memory (if you envy them that they are always free from work:) ) ;
//		or if you work on a unstable network, to cache recent images
//		but it will introduce latency if framebuffer consume speed is lower than produce speed, ---- test with "TEST_OVERRUN"
//		in this case, larger number introduce more latency, but less possibility of framebuffer getting starved.
//		note : latency is only introduced if framebuffer production is the bottleneck!
//	3 is the equivalent of triple buffering, required on plain LCD ctrlr., but don't required on LPC's LCD ctrlr.
//	2 is the equivalent of double buffering, recommendded on LPC
//	1 is similar to 2, but will slightly lower FPS, because it disables parallisim of LCD refreshing and framebuffer preparing
//  Hint: 2 is almost always enough, 3 is really always enough
#define FRABUF_Q_CAPACITY	2 // 2




// >>> following configuration must match your board and camera, unlike the above 5 configurations that you can set to anything as you wish!

#define CAMERA_SEL	CAMERA_OV7670


#define LCD_PANEL_MCB4300	1
#define LCD_PANEL	LCD_PANEL_MCB4300

/*! @brief width (in pixel) of preview rectangle on LCD
*
* Must <= CAM_CAP_W and <= CAM_LCD_W */
#define CAM_PREVIEW_W	320
/*! @brief height (in line) of preview rectangle on LCD
*
* Must <= CAM_CAP_H and <= CAM_LCD_W */
#define CAM_PREVIEW_H	240
//! width of video capture, limited by camera resolution
#define CAM_CAP_W		320
//! height of video capture, limited by camera resolution
#define CAM_CAP_H		240


#define MICROSEC_PER_TICK	250		// better do NOT change this setting!


// >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
// >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
// >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

// Pin configurations goes from here



// following are pin and function configurations, the naming convention is:
// 
// (mandatory)  SPT_XXX : XXX in SCU Port number 	(0x0 - 0xF for general pins, 0x10 - 0x1A for special pins)
// (mandatory)  SPN_XXX : XXX in SCU pin number 		(0 - 31)
// (mandatory)  ALT_XXX : XXX in SCU's alternate function number (0-7). If used as GPIO, define it to GLT_XXX (see following)
// (optional, only applicable if a pin is used as GPIO)   GPT_XXX : XXX in GPIO port number
// (optional, only applicable if a pin is used as GPIO)   GPN_XXX : XXX in GPIO pin number
// (optional, only applicable if a pin is used as GPIO)   GLT_XXX : XXX in SCU's alternate function number, WHEN USED AS GPIO
// (optional, only applicable if a pin is used as SGPIO)  SLC_XXX : XXX in SGPIO slice number (0-15, but not recommendded to use numbers directly)
// (optional, only applicable if a pin is used as SGPIO)  SGP_XXX : XXX in SGPIO pin number (0-15)
// (optional, only applicable if a pin is used to trigger GPIO pin interrupt)  PIQ_XXX : XXX in pin interrupt IRQ number (0-7)
//		warning: Unless others, PIQ_XXX can't assure correct initialization of pin interrupt, since each pin IRQ
//		requires 8 bits to designate selection and there are 2 registers in SCU on it: (PIntSel0&1)
#if SGPIO_MODULE 

#define SPT_SGPD0		9
#define SPN_SGPD0		0
#define ALT_SGPD0		6
#define SLC_SGPD0		pin0Slice
	
#define SPT_SGPD1		9
#define SPN_SGPD1		1
#define ALT_SGPD1		6
#define SLC_SGPD1		pin1Slice
	
#define SPT_SGPD2		9
#define SPN_SGPD2		2
#define ALT_SGPD2		6
#define SLC_SGPD2		pin2Slice
	
#define SPT_SGPD3		9
#define SPN_SGPD3		5
#define ALT_SGPD3		6
#define SLC_SGPD3		pin3Slice
	
#define SPT_SGPD4		6
#define SPN_SGPD4		3
#define ALT_SGPD4		2
#define SLC_SGPD4		pin4Slice
	
#define SPT_SGPD5		0x6
#define SPN_SGPD5		6
#define ALT_SGPD5		2
#define SLC_SGPD5		pin5Slice
	
#define SPT_SGPD6		0xF
#define SPN_SGPD6		7
#define ALT_SGPD6		6
#define SLC_SGPD6		pin6Slice
	
#define SPT_SGPD7		0xF
#define SPN_SGPD7		8
#define ALT_SGPD7		6
#define SLC_SGPD7		pin7Slice
	
	// PCLK is both connected to SCT.IN and SGPIO pin as external shift clock
#define SPT_SGPPXCLK	0x9
#define SPN_SGPPXCLK	0x6
#define ALT_SGPPXCLK	6
#define SLC_SGPPXCLK	pin8Slice
#define SGP_SGPPXCLK	8
	
	// HSYNC is both connected to SCT.IN and SGPIO pin as clock qualifier.
#define SPT_SGPHSYNC	0x8
#define SPN_SGPHSYNC	0x1
#define ALT_SGPHSYNC	4
#define SLC_SGPHSYNC	pin9Slice
#define SGP_SGPHSYNC	9

	
//#define SPT_VSYNC		1
//#define SPN_VSYNC		20
#define GPT_VSYNC		0
#define GPN_VSYNC		15
#define GLT_VSYNC		0
//#define ALT_VSYNC		GLT_VSYNC
#define PIQ_VSYNC		6		// Pin IRQ of VSync is slot 6
	
//! MCLK hasn't GPIO relationship
#define SPT_MCLK		0xA
#define SPN_MCLK		0
#define ALT_MCLK		6

// required for some cameras (E.g., YACBA21), not often required
#define SPT_LDO_EN		0x1
#define SPN_LDO_EN		17
#define GPT_LDO_EN		0        
#define GPN_LDO_EN		12           
#define GLT_LDO_EN		0
#define ALT_LDO_EN		GLT_LDO_EN
	
#define SPT_CHIP_ENB	0xC
#define SPN_CHIP_ENB	10
#define GPT_CHIP_ENB	6
#define GPN_CHIP_ENB	9
#define GLT_CHIP_ENB	4
#define ALT_CHIP_ENB	GLT_CHIP_ENB
	



#endif
#if SCT_MODULE
/*! @name PinDefMacros
 * @brief pin definition macros. Every pin has up to 6 aspects, refer to comments for "IMGD0" pin
*/
///@{

//! port number in SCU
#define SPT_IMGD0		0xC		// SCU Port
//! pin number in SCU
#define SPN_IMGD0		1		// SCU Pin
//! port number in GPIO
#define GPT_IMGD0		6		// GPIO Port
//! pin number in GPIO
#define GPN_IMGD0		0		// GPIO Pin
//! alternate function index of GPIO mode
#define GALT_IMGD0		4		// Alternative function for GPIO
//! alternate function index needed for IMGD0
#define ALT_IMGD0		GALT_IMGD0	// Alternative function for use as IMGD0


#define SPT_LDO_EN		0x8
#define SPN_LDO_EN		1
#define GPT_LDO_EN		4
#define GPN_LDO_EN		1
#define GALT_LDO_EN		0
#define ALT_LDO_EN		GALT_LDO_EN

#define SPT_CHIP_ENB	0xC
#define SPN_CHIP_ENB	10
#define GPT_CHIP_ENB	6
#define GPN_CHIP_ENB	9
#define GALT_CHIP_ENB	4
#define ALT_CHIP_ENB	GALT_CHIP_ENB

#define SPT_FLHLIGHT	0x2
#define SPN_FLHLIGHT	3
#define GPT_FLHLIGHT	5
#define GPN_FLHLIGHT	3
#define GALT_FLHLIGHT	4
#define ALT_FLHLIGHT	GALT_FLHLIGHT

#define SPT_VSYNC		0x2
#define SPN_VSYNC		4
#define ALT_VSYNC		3
//! SCT.Input0
#define CTIN_VSYNC		0	// SCT.IN0

#define SPT_HSYNC		0x7
#define SPN_HSYNC		3
#define GPT_HSYNC		3
#define GPN_HSYNC		11
#define ALT_HSYNC		1
#define GALT_HSYNC		0
//! SCT.Input3
#define CTIN_HSYNC		3	// SCT.IN3


#define SPT_PXCLK		0x4
#define SPN_PXCLK		8
#define GPT_PXCLK		5
#define GPN_PXCLK		12
#define GALT_PXCLK		4
#define ALT_PXCLK		1
//! SCT.Input5
#define CTIN_PXCLK		5	// SCT.IN5

#if 0
//! MCLK hasn't GPIO relationship
#define SPT_MCLK		0x1
#define SPN_MCLK		19
//#define ALT_MCLK		4
///@}
#else
//! MCLK hasn't GPIO relationship
#define SPT_MCLK		0xA
#define SPN_MCLK		0
#define ALT_MCLK		6
#endif

//					  DisPullDn | DisPullUp | NromalSlew| InputBufNCare	| DisGlitchFilter
#define SPNCFG_OUT_GNRC	0UL<<3 	| 1UL<<4 	| 0UL<<5 	| 0UL<<6 		| 1UL<<7

//					  DisPullDn | DisPullUp | HiSpdSlew | InputBufNCare	| DisGlitchFilter
#define SPNCFG_OUT_HSPD	0UL<<3 	| 1UL<<4 	| 1UL<<5 	| 0UL<<6 		| 1UL<<7


//					  DisPullDn | DisPullUp | N.C. 		| InputBufEn	| N.C.
#define SPNCFG_IN_GNRC	0UL<<3 	| 1UL<<4 	| 0UL<<5 	| 1UL<<6 		| 0UL<<7


//					  DisPullDn | EnPullUp  | N.C. 		| InputBufEn	| N.C.
#define SPNCFG_IN_PUP	0UL<<3 	| 0UL<<4 	| 0UL<<5 	| 1UL<<6 		| 0UL<<7
//! signal is direct through
#define GIMACFG_DIRECT	0
#endif
#endif
