#include "MAC57D54H.h"
#include "smc.h"

#define SMC_MCCC(x) (*(&SMC.MCCC3.R + (4 * (x / 4)) + (3 - (x % 4))))
#define SMC_MCDC(x) (*(&SMC.MCDC1.R + (2 * (x / 2)) + (1 - (x % 2))))

void smc_init(void)
{
    int i;

    /* set the period to 0 to shut off all channels */
    smc_set_period(0);
    
    /*
     * initialize all channels for...
     * - dual full H-bridge mode
     * - left aligned
     * - 0 clock delay
     *
     * ... and also suppply an initial duty cycle for each channel
     */
    for (i = 0; i < 12; i++) {
        smc_set_ch_duty(i, (i << 4) + 1);
        SMC_MCCC(i) = 0xDC;
    }

    /* turn on channels and set period */
    smc_set_period(0x400);
}

uint16_t smc_set_period(uint16_t period)
{
    SMC.MCPER.R = period;
    return SMC.MCPER.R;
}

uint16_t smc_set_ch_duty(uint8_t channel, uint16_t duty)
{
    SMC_MCDC(channel) = duty;
    return SMC_MCDC(channel);
}
