#include "MAC57D54H.h"
#include "mscm.h"

#define CM4_PERSONALITY  0x434D34
#define CA5_PERSONALITY  0x434135
#define CM0P_PERSONALITY 0x434D30

enum mscm_cpu mscm_whoami(void)
{
    enum mscm_cpu cpu;
    
    switch (MSCM.CPxTYPE.B.Personality) {
    case CM4_PERSONALITY:
        cpu = MSCM_CPU_CM4;
        break;
    case CA5_PERSONALITY:
        cpu = MSCM_CPU_CA5;
        break;
    case CM0P_PERSONALITY:
        cpu = MSCM_CPU_CM0P;
        break;
    }

    return cpu;
}

void mscm_interrupt_cpu(enum mscm_cpu cpu, uint8_t int_num)
{
    MSCM.IRCPGIR.R = (1 << ((int)cpu + 16)) | int_num;        
}

void mscm_interrupt_other_cpus(uint8_t int_num)
{
    int preshift_mask;

    preshift_mask = 0x7 ^ (1 << (int)mscm_whoami());

    MSCM.IRCPGIR.R = (preshift_mask << 16) | int_num;
}

void mscm_clear_cpu_interrupt(uint8_t int_num)
{
    *(&MSCM.IRCP0IR.R + (int)mscm_whoami()) = (1 << int_num);
}

void mscm_route_interrupt(uint8_t int_num)
{
    MSCM.IRSPRC[int_num].R |= 1 << (int)mscm_whoami();
}
