/*
 * File:        sysinit.c
 *
 * Notes:
 *
 */

#include "MAC57D54H.h"
#include "sysinit.h"

void sysinit (void)
{

  /***** 
  CLKCONFIG:
  CA5: 320MHz
  DDR: 320MHz
  BUS: 160MHz
  IPS: 80MHz
  IOP: 80MHz
  CM4: 160MHz
  ******/
  
	/* enable permissions for masters to access peripherals */
	AIPS_0.MPRA.R = 0x77777777;
	AIPS_0.MPRB.R = 0x77000000;
	AIPS_1.MPRA.R = 0x77777777;
	AIPS_1.MPRB.R = 0x77000000;
		
  /* Calculations Based on 40MHz input XTAL (as per 208QFP validaiton board) */

  /* Setup System Clock dividers: */
  /* SOME OF THESE VALUES ARE ACTUALLY THE DEFAULTS SO THE WRITES WOULD NOT BE NEEDED - KEEPING IN FOR BACKUP */
  //MC_CGM.SC_DC0.R = 0x80010000; /* set DDR/SDR div to 2 */
  MC_CGM.SC_DC1.R = 0x80010000; /* set CA5 div to 2 */
  MC_CGM.SC_DC2.R = 0x80030000; /* set CM4/Platform div to 4 */
  MC_CGM.SC_DC3.R = 0x80070000; /* set Peripherals div to 8 */
  MC_CGM.SC_DC4.R = 0x80070000; /* set IOP div to 8 */
  MC_CGM.SC_DC5.R = 0x80010000; /* set 2xPlatform div to 2 */
  
  /* enable all modes, enable all peripherals */
  MC_ME.ME.R = 0x0000A5FF;
  MC_ME.RUN_PC[0].R = 0x000000FE;
  
  MC_ME.DRUN_MC.R = 0x00130030;
  MC_ME.MCTL.R = 0x30005AF0;
  MC_ME.MCTL.R = 0x3000A50F;
  while(MC_ME.GS.B.S_MTRANS == 1);      /* Wait for mode transition complete */
  
  MC_CGM.AC0_SC.B.SELCTL = 1; /* change PLL source to FXOSC */
  while(MC_CGM.AC0_SC.B.SELCTL == 0);/* ensure that change has occured - for test purposes only */     

  // 240MHz
  PLLDIG_0.PLLDV.R = 0x04001018;
  PLLDIG_0.PLLCAL3.R = 0x09C3C000;
  PLLDIG_0.PLLFD.B.SMDEN = 1;//sigma delta modulation disabled
  
  /* switch to PLL */
  PFLASH.PFCR1.B.RWSC = 4;/* enable required wait states on flash */
  MC_ME.DRUN_MC.R = 0x00130134;
  MC_ME.MCTL.R = 0x30005AF0;
  MC_ME.MCTL.R = 0x3000A50F;
  while(MC_ME.GS.B.S_MTRANS == 1);      /* Wait for mode transition complete */

}


void disable_wdog()
{
	SWT_0.SR.R = 0xC520; //key
	SWT_0.SR.R = 0xD928; //key
	SWT_0.CR.R = 0xFF00010A;
}

void ecc_init()
{
	uint32_t* k;
	uint32_t i;
	uint32_t j[8] __attribute__((aligned(8))); //needs to be 64bit aligned for DMA transfer
	/* initialise TCML (32bit parity) */
	for (k=(uint32_t *)0x1e000000; k<(uint32_t *)0x1E007FFF; k++)
		*k = 0xFFFFFFFF; 
	/* initialise TCMU (32bit parity) */
	for (k=(uint32_t *)0x3e000000; k<(uint32_t *)0x3E007FFF; k++)
		*k = 0xFFFFFFFF; 
	/* initialise IOP (32bit ECC) */
	for (k=(uint32_t *)0x3e400000; k<(uint32_t *)0x3E407FFF; k++)
		*k = 0xFFFFFFFF; 
		
	/* use DMA to initialise SRAM ECC (64bit) */
	/* initialise array */
	for(i=0;i<8;i++)
		j[i] = 0xffffffff;
	
	/* 32-byte (4x 64-bit burst) */
	DMA_1.TCD[0].SADDR.B.SADDR            = (uint32_t)&j;                
	DMA_1.TCD[0].SOFF.B.SOFF                   = 0;                      //32byte source offset
	DMA_1.TCD[0].ATTR.B.SMOD                = 0;                      
	DMA_1.TCD[0].ATTR.B.SSIZE                  = 3;                      //0x5 => 32byte, 0x3=>64bit
	DMA_1.TCD[0].ATTR.B.DMOD                = 0;                                         
	DMA_1.TCD[0].ATTR.B.DSIZE                  = 3;                       //0x5 => 32byte, 0x3=>64bit
	DMA_1.TCD[0].NBYTES.MLNO.B.NBYTES           = 0x100000;                                                                    //1MB                                                                      
	DMA_1.TCD[0].SLAST.B.SLAST                = 0;                                                                                   
	DMA_1.TCD[0].DADDR.B.DADDR           = 0x3EF00000;  
	DMA_1.TCD[0].DOFF.B.DOFF                  = 8;//32;                                                                                 //32byte destination offset          
	DMA_1.TCD[0].CITER.ELINKNO.B.ELINK             = 0;                                                                                                                 
	DMA_1.TCD[0].CITER.ELINKNO.B.CITER             = 1;                                      
	DMA_1.TCD[0].DLASTSGA.B.DLASTSGA               = 0;
	DMA_1.TCD[0].BITER.ELINKNO.B.ELINK             = 0;                                                                                                  
	DMA_1.TCD[0].BITER.ELINKNO.B.BITER             = 1;                              
	DMA_1.TCD[0].CSR.R = 0;  
	DMA_1.SERQ.R = 0; /* set TCD0 enable */
	DMA_1.TCD[0].CSR.B.START           = 1; /* start TCD0 */
	//DMA_1.SSRT.R = 0; /* start TCD0 */  
	while(DMA_1.TCD[0].CSR.B.DONE !=1); /* wait until init is complete */
	
}