#include "MAC57D54H.h"
#include <stdio.h>
#include "m4_cache.h"
#include "halo_ports.h"

;
extern const void* __vector_table;
extern void sysinit();
extern void disable_wdog();
extern void ecc_init();
void rtc_test_interrupt();


/* Frequency of external crystal in MHZ */
#define XOSC_FREQ 40

/* Enum for which subclock to test */
typedef enum subclock_t {
    SCLK_NONE,
    SCLK_FIRC,
    SCLK_SIRC,
    SCLK_32KHZ
} subclock;

/* Enum for calibration mode */
typedef enum sccu_mode_t {
    CALIB_EACH_WKPU,          /* Calibrate on wakeup timer expiery */
    CALIB_EACH_SECOND,      /* Calibrate every second */
} sccu_mode;

/* ISR Variables */
volatile int rtc_isr_flag = 0;
volatile uint32_t rtc_isr_status = 0;

/* rtc_isr
 * ISR for RTC interrupt, increments counter.
 */
void rtc_isr() {
    /* Set ISR Flag */
    rtc_isr_flag |= 0x1;
    
    /* Save status register */
    rtc_isr_status = RTC.STATUS.R;
    
    /* Clear flags by writing 1 to all w1c bits */
    RTC.STATUS.R = 0x000080fc;	
}


int main(int argc, char *argv[])
{
	uint32_t i,j;
	disable_wdog();
	write_vtor((uint32_t)&__vector_table); /* configure vector table address */
	asm(" CPSIE i"); //enable interrupts (if required)
	//m4_cache_init(CODE_CACHE);
	//m4_cache_init(SYS_CACHE);
	sysinit();
	ecc_init();
	
	rtc_test_interrupt();
	

    while(1);
}


void rtc_test_interrupt() {
    /* Setup RTC */
    RTC.CTRL.B.SCLKSEL = 0x00;	/* No subclock */
    RTC.CTRL.B.PREDIV  = 0x28;	/* Divide by 40 as 40Mhz Clock */
    RTC.CTRL.B.PREDIV  = XOSC_FREQ;	/* Divide by 40 as 40Mhz Clock */
    RTC.CTRL.B.FRZEN   = 0x1;	/* Stop RTC during debug freeze */
    RTC.CTRL.B.CLKSEL  = 0x0;	/* Select 40Mhz crystal as clock */

    /* Enable RTC interrupt in NVIC, Vector = 46, ID = 30 */
    route_interrupt(30, 1);
    enable_irq(30);
    
    /*** SUB SECOND INTERRUPT ***/
    RTC.CTRL.B.SSECEN = 0x1;    /* Enable Sub Second Interrupt */
    RTC.CTRL.B.RTCEN = 0x1;	/* Enable RTC */
    while(rtc_isr_flag==0);	/* Wait for interrupt */
    rtc_isr_flag = 0;     	/* Clear ISR flag */
    RTC.CTRL.B.RTCEN = 0x0;	/* Disable RTC */
    RTC.CTRL.B.SSECEN = 0x0;	/* Disable Sub Second Interrupt */
    assert((rtc_isr_status & 0x04)==0x04 ); /* Check Sub Second status flag was set */

    /*** SECOND INTERRUPT ***/
    RTC.CTRL.B.SECEN = 0x1;     /* Enable Second Interrupt */
    RTC.CTRL.B.RTCEN = 0x1;	/* Enable RTC */
    while(rtc_isr_flag==0);	/* Wait for interrupt */
    rtc_isr_flag = 0;     	/* Clear ISR flag */
    RTC.CTRL.B.RTCEN = 0x0;	/* Disable RTC */
    RTC.CTRL.B.SECEN = 0x0;	/* Disable Second Interrupt */
    assert((rtc_isr_status & 0x08)==0x08 ); /* Check Second status flag was set */

    /*** MINUTE INTERRUPT ***/
    RTC.CTRL.B.MINEN = 0x1;     /* Enable Minute Interrupt */
    RTC.TOD.B.SEC_CNT = 59;	/* Set seconds to 59 so we dont have to wait */
    RTC.CTRL.B.RTCEN = 0x1;	/* Enable RTC */
    while(rtc_isr_flag==0);	/* Wait for interrupt */
    rtc_isr_flag = 0;     	/* Clear ISR flag */
    RTC.CTRL.B.RTCEN = 0x0;	/* Disable RTC */
    RTC.CTRL.B.MINEN = 0x0;	/* Disable Minute Interrupt */
    assert((rtc_isr_status & 0x10)==0x10 ); /* Check Minute status flag was set */

    /*** HOUR INTERRUPT ***/
    RTC.CTRL.B.HOUREN = 0x1;    /* Enable Hour Interrupt */
    RTC.TOD.B.MIN_CNT = 59;	/* Set minutes to 59 */
    RTC.TOD.B.SEC_CNT = 59;	/* Set seconds to 59 */
    RTC.CTRL.B.RTCEN = 0x1;	/* Enable RTC */
    while(rtc_isr_flag==0);	/* Wait for interrupt */
    rtc_isr_flag = 0;     	/* Clear ISR flag */
    RTC.CTRL.B.RTCEN = 0x0;	/* Disable RTC */
    RTC.CTRL.B.HOUREN = 0x0;	/* Disable Hour Interrupt */
    assert((rtc_isr_status & 0x20)==0x20 ); /* Check Hour status flag was set */

    /*** DAY INTERRUPT ***/
    RTC.CTRL.B.DAYEN = 0x1;    	/* Enable Day Interrupt */
    RTC.TOD.B.HOUR_CNT = 23;	/* Set hours to 23 */
    RTC.TOD.B.MIN_CNT = 59;	/* Set minutes to 59 */
    RTC.TOD.B.SEC_CNT = 59;	/* Set seconds to 59 */
    RTC.CTRL.B.RTCEN = 0x1;	/* Enable RTC */
    while(rtc_isr_flag==0);	/* Wait for interrupt */
    rtc_isr_flag = 0;     	/* Clear ISR flag */
    RTC.CTRL.B.RTCEN = 0x0;	/* Disable RTC */
    RTC.CTRL.B.DAYEN = 0x0;	/* Disable Day Interrupt */
    assert((rtc_isr_status & 0x40)==0x40 ); /* Check Day status flag was set */

    /*** WAKEUP INTERRUPT ***/
    RTC.CTRL.B.WKP_RES = 0x0;	  /* Set wakeup resolution as sub second */
    RTC.CTRL.B.WKP_CLK_SEL = 0x0; /* Set timer clock as wakeup clock */
    RTC.CTRL.B.WKPEN = 0x1;	  /* Enable Wakeup Interrupt */
    RTC.WKEUP.R = 0x04;		  /* Set wakeup period to minimum value, 4 */
    RTC.CTRL.B.RTCEN = 0x1;	  /* Enable RTC */
    while(rtc_isr_flag==0);	  /* Wait for interrupt */
    rtc_isr_flag = 0;     	  /* Clear ISR flag */
    RTC.CTRL.B.RTCEN = 0x0;	  /* Disable RTC */
    RTC.CTRL.B.WKPEN = 0x0;	  /* Disable Wakeup Interrupt */
    assert((rtc_isr_status & 0x80)==0x80 ); /* Check Wakeup flag was set */

    /*** API INTERRUPT ***/
    RTC.CTRL.B.APIEN = 0x1;	/* Enable API Function */
    RTC.CTRL.B.APIIE = 0x1;     /* Enable API Interrupt */
    RTC.APIVAL.R = 4;		/* Set APIVAL to minimum value, 4 */
    RTC.CTRL.B.RTCEN = 0x1;	/* Enable RTC */
    while(rtc_isr_flag==0);	/* Wait for interrupt */
    rtc_isr_flag = 0;		/* Clear ISR flag */
    RTC.CTRL.B.RTCEN = 0x0;	/* Disable RTC */
    RTC.CTRL.B.APIIE = 0x0;	/* Disable API Interrupt */
    RTC.CTRL.B.APIEN = 0x0;	/* Disable API Function */
    assert((rtc_isr_status & 0x8000)==0x8000 ); /* Check API flag was set */
    
    /*** PASS ***/
    while(1);
}
