/*
 ****************************************************************************
 * Copyright(c) 2017 NXP Semiconductors                                     *
 * All rights are reserved.                                                 *
 *                                                                          *
 * Software that is described herein is for illustrative purposes only.     *
 * This software is supplied "AS IS" without any warranties of any kind,    *
 * and NXP Semiconductors disclaims any and all warranties, express or      *
 * implied, including all implied warranties of merchantability,            *
 * fitness for a particular purpose and non-infringement of intellectual    *
 * property rights.  NXP Semiconductors assumes no responsibility           *
 * or liability for the use of the software, conveys no license or          *
 * rights under any patent, copyright, mask work right, or any other        *
 * intellectual property rights in or to any products. NXP Semiconductors   *
 * reserves the right to make changes in the software without notification. *
 * NXP Semiconductors also makes no representation or warranty that such    *
 * application will be suitable for the specified use without further       *
 * testing or modification.                                                 *
 *                                                                          *
 * Permission to use, copy, modify, and distribute this software and its    *
 * documentation is hereby granted, under NXP Semiconductors' relevant      *
 * copyrights in the software, without fee, provided that it is used in     *
 * conjunction with NXP Semiconductor products(UCODE I2C, NTAG I2C, LPC8N04)*
 * This  copyright, permission, and disclaimer notice must appear in all    *
 * copies of this code.                                                     *
 ****************************************************************************
 */

package com.nxp.lpc8nxxnfcdemo.fragments;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.os.Bundle;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.nxp.lpc8nxxnfcdemo.activities.MainActivity;
import com.nxp.lpc8nxxnfcdemo.reader.Nfc_lpc8nxx_Demo;
import com.nxp.lpc8nxxnfcdemo.utils.FileChooser;
import com.nxp.lpc8nxxnfcdemo.utils.FileChooser.FileSelectedListener;
import com.nxp.lpc8nxxnfcdemo.R;

import org.w3c.dom.Text;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

import static com.nxp.lpc8nxxnfcdemo.activities.MainActivity.demo;

public class OtaUpdateFragment extends Fragment{

    private static final int MY_PERMISSIONS_REQUEST_READ_STORAGE = 1;
    private static Context mContext;
    private static Button selectFileButton;
    private static Button flashButton;
    private static TextView filePath;
    private static TextView otatextbox;
    private static Button readDeviceImageVer;
    private static int perm;
    private static byte[] binaryFileBytes = null;
    private static ProgressBar downloadprogressbar;
    private static TextView downloadprogresspercentage;
    private static Drawable progbarDrawable;
    private static Drawable progbarIndeterDrawable;
    private static final int PROGRESSBARFAIL = 2;
    private static final int PROGRESSBARPASS = 1;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRetainInstance(true);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View layout = inflater
                .inflate(R.layout.ota_update, container, false);

        // Get the context reference
        mContext = getActivity();

        //Reset fields in the view
        downloadprogressbar = (ProgressBar) layout.findViewById(R.id.updateprogressbar);
        progbarDrawable = downloadprogressbar.getProgressDrawable();
        progbarIndeterDrawable = downloadprogressbar.getIndeterminateDrawable();
        downloadprogresspercentage = (TextView) layout.findViewById(R.id.updatepercentage);
        filePath = (TextView) layout.findViewById(R.id.file_path);
        otatextbox = (TextView)layout.findViewById(R.id.ota_editextbox);
        flashButton = (Button) layout.findViewById(R.id.Flashbutton);
        selectFileButton = (Button)layout.findViewById(R.id.SelectFile);
        readDeviceImageVer = (Button) layout.findViewById(R.id.readDeviceImageversion);
        downloadprogressbar.setVisibility(View.INVISIBLE);
        downloadprogresspercentage.setVisibility(View.INVISIBLE);

        MainActivity.demo.OtaFinish();

        readDeviceImageVer.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                MainActivity.demo.OtaFinish();
                demo.readImageVersionfromDevice();
            }
        });

        selectFileButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                //Reset fields in the view
                MainActivity.demo.OtaFinish();
                perm = ContextCompat.checkSelfPermission(mContext, Manifest.permission.READ_EXTERNAL_STORAGE);
                if (perm != PackageManager.PERMISSION_GRANTED) {
                    // Permission is not granted
                    // Request the permission
                    OtaUpdateFragment.this.requestPermissions(new String[]{Manifest.permission.READ_EXTERNAL_STORAGE}, MY_PERMISSIONS_REQUEST_READ_STORAGE);
                }
                else
                {
                    fileSelection();
                }
            }
        });

        flashButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(binaryFileBytes == null || binaryFileBytes.length == 0)
                {
                    otatextbox.setText("No file selected. Cannot perform flash operation");
                }
                else {
                    resetProgressBar();
                    demo.flashMemoryOTA();
                }

            }
        });

        return layout;
    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           String permissions[], int[] grantResults) {
        switch (requestCode) {
            case MY_PERMISSIONS_REQUEST_READ_STORAGE: {
                // If request is cancelled, the result arrays are empty.
                if (grantResults.length > 0
                        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {

                    // permission was granted
                    fileSelection();

                } else {

                    // permission denied,
                }
                return;
            }
            // other 'case' lines to check for other
            // permissions this app might request.
        }
    }

    private void fileSelection(){
        FileChooser chooser = new FileChooser(this.getActivity());
        chooser.setExtension("bin");
        chooser.setFileListener(new FileSelectedListener() {
            @Override
            public void fileSelected(File file) {
                try {
                    // Check if file is valid
                    checkFileValid(file);
                } catch (IOException e) {
                    e.printStackTrace();
                    binaryFileBytes = null;
                    otatextbox.setText("Error ! Could not open file");
                }
            }
        }).showDialog();
    }

    /* Check if Selected File is valid */
    private void checkFileValid(File file) throws IOException {
        String path = file.getAbsolutePath();
        binaryFileBytes = readFileMemory(path);

        // check if firmware binary is multiple of 260 bytes.
        //  binaryFileBytes = firmware binary which is n * 260 bytes
        if((binaryFileBytes == null) || (binaryFileBytes.length == 0) || ((binaryFileBytes.length) % 260 != 0))
        {
            // Invalid File
            otatextbox.setText("Error ! File Size invalid. Select a valid file.");
            binaryFileBytes = null;
        }
        else
        {
            // Valid File
            filePath.setText(path);
            otatextbox.setText("File Selected :  " + file.getName().toString());
        }
    }

    // Retrieve the memory from the Internal Storage
    private byte[] readFileMemory(String path) throws IOException {
        File file = new File(path);
        if(!file.exists()) {
            return null;
        }

        // Open file
        RandomAccessFile f = new RandomAccessFile(file, "r");
        try {
            // Get and check length
            long longlength = f.length();
            int length = (int) longlength;
            if (length != longlength) {
                throw new IOException("File size >= 2 GB");
            }
            // Read file and return data
            byte[] data = new byte[length];
            f.readFully(data);
            return data;
        } finally {
            f.close();
        }
    }




    public static void setOtaTextBox(final String text) {
        otatextbox.setText(text);

    }
    public static byte[] getBinaryFileBytes() {
        return binaryFileBytes;
    }
    public static void setProgressBar(int value)
    {
        downloadprogressbar.setProgress(value);
    }
    public static void setProgressBarVisibility(int visibility)
    {
        downloadprogressbar.setVisibility(visibility);
    }

    public static void resetProgressBar()
    {
        setOtaTextBox("");
        downloadprogressbar.setProgress(0);
        downloadprogressbar.getProgressDrawable().setColorFilter(Color.DKGRAY,PorterDuff.Mode.DST_IN);
        downloadprogressbar.setVisibility(View.VISIBLE);

        setProgressPercentage(0);
        downloadprogresspercentage.setVisibility(View.VISIBLE);
    }

    public static void disableButtons()
    {

        flashButton.setClickable(false);
        flashButton.setFocusable(false);
        readDeviceImageVer.setClickable(false);
        readDeviceImageVer.setFocusable(false);
        selectFileButton.setClickable(false);
        selectFileButton.setFocusable(false);
    }

    public static void enableButtons()
    {
        flashButton.setClickable(true);
        flashButton.setFocusable(true);
        readDeviceImageVer.setClickable(true);
        readDeviceImageVer.setFocusable(true);
        selectFileButton.setClickable(true);
        selectFileButton.setFocusable(true);
    }
    public static void setProgressBarColor(int color)
    {
        if(color == PROGRESSBARFAIL)
        {
            downloadprogressbar.getProgressDrawable().setColorFilter(Color.RED,PorterDuff.Mode.SRC_IN);
        }
        if(color == PROGRESSBARPASS)
        {
            downloadprogressbar.getProgressDrawable().setColorFilter(Color.GREEN,PorterDuff.Mode.SRC_IN);
        }

    }
    public static void setProgressPercentage(Integer value)
    {
        String buffer = value + "%";
        downloadprogresspercentage.setText(buffer);
    }
    public static void setProgressPercentageVisibility(int visibility)
    {
        downloadprogresspercentage.setVisibility(visibility);
    }

    public static void resetOtaDemo()
    {
        filePath.setText(mContext.getString(R.string.file_default_demo));
        otatextbox.setText("");
        binaryFileBytes = null;
        downloadprogresspercentage.setVisibility(View.INVISIBLE);
        downloadprogressbar.setVisibility(View.INVISIBLE);
    }
}
