/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v5.0
processor: LPC845
package_id: LPC845M301JBD48
mcu_data: ksdk2_0
processor_version: 0.0.14
pin_labels:
- {pin_num: '11', pin_signal: PIO1_0/CAPT_X1, label: GREEN, identifier: GREEN}
- {pin_num: '14', pin_signal: PIO1_1/CAPT_X2, label: BLUE, identifier: BLUE}
- {pin_num: '16', pin_signal: PIO1_2/CAPT_X3, label: RED, identifier: RED}
- {pin_num: '6', pin_signal: PIO0_4/ADC_11, label: USER, identifier: USER}
- {pin_num: '4', pin_signal: PIO0_12, label: USER, identifier: USERB}
- {pin_num: '33', pin_signal: PIO0_7/ADC_0, label: ADC, identifier: ADC}
- {pin_num: '9', pin_signal: PIO0_31/CAPT_X0, label: CAPX, identifier: CAPX}
- {pin_num: '42', pin_signal: PIO0_30/ACMP_I5, label: CAPY, identifier: CAPY}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_iocon.h"
#include "fsl_swm.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '11', peripheral: GPIO, signal: 'PIO1, 0', pin_signal: PIO1_0/CAPT_X1, direction: OUTPUT}
  - {pin_num: '14', peripheral: GPIO, signal: 'PIO1, 1', pin_signal: PIO1_1/CAPT_X2, direction: OUTPUT}
  - {pin_num: '16', peripheral: GPIO, signal: 'PIO1, 2', pin_signal: PIO1_2/CAPT_X3, direction: OUTPUT}
  - {pin_num: '6', peripheral: PINT, signal: 'PINT, 0', pin_signal: PIO0_4/ADC_11}
  - {pin_num: '4', peripheral: PINT, signal: 'PINT, 1', pin_signal: PIO0_12}
  - {pin_num: '33', peripheral: ADC0, signal: 'CH, 0', pin_signal: PIO0_7/ADC_0}
  - {pin_num: '9', peripheral: CAPT, signal: 'CAPTX, 0', pin_signal: PIO0_31/CAPT_X0}
  - {pin_num: '42', peripheral: ACMP, signal: ACMP_IN5, pin_signal: PIO0_30/ACMP_I5}
  - {pin_num: '20', peripheral: USART0, signal: RXD, pin_signal: PIO0_24}
  - {pin_num: '19', peripheral: USART0, signal: TXD, pin_signal: PIO0_25}
  - {pin_num: '44', peripheral: SPI1, signal: MOSI, pin_signal: PIO0_21/ADC_5, mode: pullUp, invert: disabled, hysteresis: enabled, opendrain: disabled, smode: bypass,
    clkdiv: div0}
  - {pin_num: '45', peripheral: SPI1, signal: SSEL0, pin_signal: PIO0_20/ADC_6, mode: pullUp, invert: disabled, hysteresis: enabled, opendrain: disabled, smode: bypass,
    clkdiv: div0}
  - {pin_num: '46', peripheral: SPI1, signal: MISO, pin_signal: PIO0_19/ADC_7}
  - {pin_num: '18', peripheral: SPI1, signal: SCK, pin_signal: PIO0_26}
  - {pin_num: '24', peripheral: GPIO, signal: 'PIO0, 1', pin_signal: PIO0_1/ACMP_I2/CLKIN}
  - {pin_num: '15', peripheral: GPIO, signal: 'PIO0, 16', pin_signal: PIO0_16}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M0P */
void BOARD_InitPins(void)
{
    /* Enables clock for IOCON.: enable */
    CLOCK_EnableClock(kCLOCK_Iocon);
    /* Enables clock for switch matrix.: enable */
    CLOCK_EnableClock(kCLOCK_Swm);

    GPIO->DIR[1] = ((GPIO->DIR[1] &
                     /* Mask bits to zero which are setting */
                     (~(GPIO_DIR_DIRP_MASK)))

                    /* Selects pin direction for pin PIOm_n (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins
                     * depends on the specific device and package. 0 = input. 1 = output.: 0x07u */
                    | GPIO_DIR_DIRP(0x07u));

    const uint32_t IOCON_INDEX_PIO0_20_config = (/* Selects pull-up function */
                                                 IOCON_PIO_MODE_PULLUP |
                                                 /* Enable hysteresis */
                                                 IOCON_PIO_HYS_EN |
                                                 /* Input not invert */
                                                 IOCON_PIO_INV_DI |
                                                 /* Disables Open-drain function */
                                                 IOCON_PIO_OD_DI |
                                                 /* Bypass input filter */
                                                 IOCON_PIO_SMODE_BYPASS |
                                                 /* IOCONCLKDIV0 */
                                                 IOCON_PIO_CLKDIV0);
    /* PORT0 PIN20 (coords: ) is configured as  */
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_20, IOCON_INDEX_PIO0_20_config);

    const uint32_t IOCON_INDEX_PIO0_21_config = (/* Selects pull-up function */
                                                 IOCON_PIO_MODE_PULLUP |
                                                 /* Enable hysteresis */
                                                 IOCON_PIO_HYS_EN |
                                                 /* Input not invert */
                                                 IOCON_PIO_INV_DI |
                                                 /* Disables Open-drain function */
                                                 IOCON_PIO_OD_DI |
                                                 /* Bypass input filter */
                                                 IOCON_PIO_SMODE_BYPASS |
                                                 /* IOCONCLKDIV0 */
                                                 IOCON_PIO_CLKDIV0);
    /* PORT0 PIN21 (coords: ) is configured as  */
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_21, IOCON_INDEX_PIO0_21_config);

    /* USART0_TXD connect to P0_25 */
    SWM_SetMovablePinSelect(SWM0, kSWM_USART0_TXD, kSWM_PortPin_P0_25);

    /* USART0_RXD connect to P0_24 */
    SWM_SetMovablePinSelect(SWM0, kSWM_USART0_RXD, kSWM_PortPin_P0_24);

    /* SPI1_SCK connect to P0_26 */
    SWM_SetMovablePinSelect(SWM0, kSWM_SPI1_SCK, kSWM_PortPin_P0_26);

    /* SPI1_MOSI connect to P0_21 */
    SWM_SetMovablePinSelect(SWM0, kSWM_SPI1_MOSI, kSWM_PortPin_P0_21);

    /* SPI1_MISO connect to P0_19 */
    SWM_SetMovablePinSelect(SWM0, kSWM_SPI1_MISO, kSWM_PortPin_P0_19);

    /* SPI1_SSEL0 connect to P0_20 */
    SWM_SetMovablePinSelect(SWM0, kSWM_SPI1_SSEL0, kSWM_PortPin_P0_20);

    /* ACMP_INPUT5 connect to P0_30 */
    SWM_SetFixedPinSelect(SWM0, kSWM_ACMP_INPUT5, true);

    /* ADC_CHN0 connect to P0_7 */
    SWM_SetFixedPinSelect(SWM0, kSWM_ADC_CHN0, true);

    /* CAPT_X0 connect to P0_31 */
    SWM_SetFixedPinSelect(SWM0, kSWM_CAPT_X0, true);

    SYSCON->PINTSEL[0] = ((SYSCON->PINTSEL[0] &
                           /* Mask bits to zero which are setting */
                           (~(SYSCON_PINTSEL_INTPIN_MASK)))

                          /* Pin number select for pin interrupt or pattern match engine input. (PIO0_0 to
                           * PIO0_31correspond to numbers 0 to 31 and PIO1_0 to PIO1_31 correspond to numbers 32 to
                           * 63).: 0x04u */
                          | SYSCON_PINTSEL_INTPIN(0x04u));

    SYSCON->PINTSEL[1] = ((SYSCON->PINTSEL[1] &
                           /* Mask bits to zero which are setting */
                           (~(SYSCON_PINTSEL_INTPIN_MASK)))

                          /* Pin number select for pin interrupt or pattern match engine input. (PIO0_0 to
                           * PIO0_31correspond to numbers 0 to 31 and PIO1_0 to PIO1_31 correspond to numbers 32 to
                           * 63).: 0x0Cu */
                          | SYSCON_PINTSEL_INTPIN(0x0Cu));

    /* Disable clock for switch matrix. */
    CLOCK_DisableClock(kCLOCK_Swm);
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
