/*
===============================================================================
 Name        : main.c
 Author      : $(author)
 Version     :
 Copyright   : $(copyright)
 Description : main definition
===============================================================================
*/
#include "touch_task.h"
#include "comm_task.h"
#include "lcd.h"

extern void Init_Touch(void);

void SysTick_Handler(void)
{
    if (sys.service_timer > 0)
        sys.service_timer --;

    if (service_comm_timer > 0)
        service_comm_timer --;

    if (service_lcd_timer > 0)
        service_lcd_timer --;
}

int main(void)
{
//  SystemCoreClockUpdate();

    COM_Init();
    Init_LcdTask();
    Init_Touch();

    SysTick_Config(SystemCoreClock/1000);          // Generate interrupt each 1 ms

    while (1)
    {
        vLcdTask();
        COM_Task();
        if (sys.service_timer == 0)
            Touch_Task();

        __WFI();
    }
}        
