/******************************************************************************
*  LPC8xx_Touch_Solution.h
*
*   This file has declarations of touch routines and data structures that
*   that are used by user applications.
*   These routines and structures activate/deactivate the Touch Solution
*   library under control from a host application layer.
*
*    copyright NXP Semiconductors 2014 (C)
*
******************************************************************************/
#define MAX_SENS_CNT            9                   // maximum nr of sensors
#define MAX_ROW_CNT             3                   // max nr of sensor rows
#define MAX_COL_CNT             3                   // max nr of sensor columns

typedef enum {EV_START=0, EV_DATA, EV_END}        EVENTS_T;
typedef enum {HORIZONTAL=0, VERTICAL, DIRECT}     SCAN_MODES_T;
typedef enum {ONE_DIMENSIONAL=0, TWO_DIMENSIONAL} TOUCH_MODES_T;

typedef struct {
	uint8_t  ROW_CNT;                               // number of sensor rows in matrix
	uint8_t  COL_CNT;                               // number of sensor columns in matrix
    uint8_t  X[MAX_ROW_CNT][MAX_COL_CNT];           // array of X line port pin numbers
	uint8_t  YL;                                    // YL port pin number
	uint8_t  ACMP_Ix;                               // analog comperator input used 
	uint8_t  YH;                                    // YH port pin number
} TOUCH_CFG_T;

typedef struct {
	uint8_t  touch_mode;                            // touch mode (one - or two dimensional)
	uint8_t  agc_mode;                              // automatic gain control
	uint16_t agc_min;                               // min value for Reference Integration Cycles in agc mode
	uint16_t agc_max;                               // max value for Reference Integration Cycles in agc mode
	uint8_t  system_gain;                           // analog comparator input gain
	uint8_t  dt_mode;                               // automatic or dynamic Touch Sensitivity Calibration Status
                                                    // when Active, Detection threshold swings between min and
                                                    // max Sense Threshold value */
	uint16_t dt_min;                                // minimum limit for difference between Reference & Raw touch
                                                    // cycles for Touch Event to be detected. Set as Default
                                                    // detection threshold value, when Dynamic sensitivity is
                                                    // switched-off
	uint16_t dt_max;                                // maximum limit for difference between Reference & Raw touch
                                                    // cycles for Touch Event to be detected.
	uint8_t  fd_raw;                                // touch raw integration cycles averaging coefficient
	uint8_t  fd_ref;                                // touch reference integration cycles averaging coefficient
	uint8_t  fd_pos;                                // touch position averaging coefficient
} TOUCH_PAR_T;

typedef struct {
	uint8_t  service_timer;                         // touch task service timer in msec
	uint16_t version;                               // touch library version number
    uint8_t  system_grounded;                       // grounded or contactless system
	uint8_t  scan_mode;                             // scanning mode (direct, vertical, horizontal)
	uint8_t  use_square;                            // use non-linear amplification ? 
	uint8_t  use_equalization;                      // use reference based equalization ?
	uint8_t  ghost_touch_suppression;               // enables ghost touch suppression
	uint8_t  use_nearest_neighbor;                  // noise suppression of sensors far away ?
	void    (*cb_func) (uint8_t e, uint8_t b[4]);   // pointer to touch event call back handler
} TOUCH_SYS_T;

extern       TOUCH_SYS_T sys;                       // global pointer to sensor system configuration
extern       TOUCH_PAR_T par;                       // global pointer to sensor parameter definition

extern void  Touch_Init(const TOUCH_CFG_T *c);
extern void  Touch_Update(void);
extern void  Touch_Task(void);

// default touch parameters for LPC8xx Touch Solution board
#define USE_AGC                0                    // automatic gain control
#define AGC_MIN_CYCLES         2000                 // min value for Reference Integration Cycles in agc mode
                                                    // range from 500 - 7000
#define AGC_MAX_CYCLES         2500                 // max value for Reference Integration Cycles in agc mode
                                                    // range from 1000 - 8000
#define SYSTEM_GAIN            18                   // analog comparator input gain
#define USE_DDT                0                    // dynamic detection threshold calibration?
#define DDT_MIN_LIMIT          1000                 // minimum limit for difference between Reference & Raw touch
                                                    // range from 50 - 1500
#define DDT_MAX_LIMIT          1200                 // maximum limit for difference between Reference & Raw touch
                                                    // range from 100 - 2000
#define DEBOUNCE_THRES         3                    // number of touch events Ignored before concluding it as
                                                    // valid touch, range from 0 - 5
#define RAW_FILTER             1                    // touch raw integration cycles averaging coefficient
                                                    // range from 0 - 3
#define REF_FILTER             5                    // touch reference integration cycles averaging coefficient
                                                    // range from 0 - 8
#define POS_FILTER             2                    // touch position averaging coefficient
                                                    // range from 0 - 5
#define PARAM_BUF_LEN          15                   // size of parameter memory block
