
/*
*         Copyright (c), NXP Semiconductors Gratkorn / Austria
*
*                     (C)NXP Semiconductors
*       All rights are reserved. Reproduction in whole or in part is
*      prohibited without the written consent of the copyright owner.
*  NXP reserves the right to make changes without notice at any time.
* NXP makes no warranty, expressed, implied or statutory, including but
* not limited to any implied warranty of merchantability or fitness for any
*particular purpose, or that the use will not infringe any third party patent,
* copyright or trademark. NXP must not be liable for any loss or damage
*                          arising from its use.
*/

/** \file
* Secure Firmware Update Library.
* $Author: Vinay Singh (nxp74831) $
* $Revision: 2917 $
* $Date: 2016-03-02 15:17:26 +0200 (Mi, 02 Mar 2016) $
*
* History:
*
*/

#ifndef DL_HALCONFIG_LPC1769_H
#define DL_HALCONFIG_LPC1769_H







/**
* \name general ports definition
*/
/*@{*/
#define LPC_PORT0              ((uint8_t)0)		/**< Download  Request pin is connected to this port. */
#define LPC_PORT2              ((uint8_t)2)		/**< Reset pin is connected to this port. */
/*@}*/


/**
* \name value/state definition
*/
/*@{*/

//#define SET_OUT            ((uint8_t)1)     	/**< A pin configured to output direction. */
/*@}*/

/**
* \name Bgeneral Pin numbers definition
*/
/*@{*/

#define PIN_RESET           ((uint8_t)(1 << 5))		/**< . This is the reset pin*/
#define PIN_DWL_REQ         ((uint8_t)(1 << 21))	/**< . This is the Download request pin*/
/*@}*/



/**
 * \brief Enters or Exits download mode.
 * This function can be used to enter or exit from download mode.
 * \return Status Code
 * \retval #PH_ERR_SUCCESS when the operation was successful.
 */
phStatus_t phDlhalHw_Pn5180_DownloadMode( uint8_t bEnable);	/**<[In] Download mode is enabled when 1 else disabled when 0. */


/**
 * \brief This function resets Pn5180.
 * This function can be used to reset the Pn5180 with the Download Request pin low.
 * \return void
 */
void phDlhalHw_Pn5180_ResetDevice(void);


#endif	/*DL_HALCONFIG_LPC1769_H*/
