
/*
*         Copyright (c), NXP Semiconductors Gratkorn / Austria
*
*                     (C)NXP Semiconductors
*       All rights are reserved. Reproduction in whole or in part is
*      prohibited without the written consent of the copyright owner.
*  NXP reserves the right to make changes without notice at any time.
* NXP makes no warranty, expressed, implied or statutory, including but
* not limited to any implied warranty of merchantability or fitness for any
*particular purpose, or that the use will not infringe any third party patent,
* copyright or trademark. NXP must not be liable for any loss or damage
*                          arising from its use.
*/

/** \file
* Secure Firmware Update Library.
* $Author: Vinay Singh (nxp74831) $
* $Revision: 2917 $
* $Date: 2016-03-02 15:17:26 +0200 (Mi, 02 Mar 2016) $
*
* History:
*
*/


#include <ph_TypeDefs.h>

#include "lpc17xx_gpio.h"
#include <phDlHalConfig_LPC1769.h>







phStatus_t phDlhalHw_Pn5180_DownloadMode( uint8_t bEnable)
{
	uint32_t volatile i;
	phStatus_t status = PH_ERR_SUCCESS;

	/* Set port pin - DWL_REQ to output */
	GPIO_SetDir(LPC_PORT0, PIN_DWL_REQ, SET_OUT );

	if(bEnable)
	{
		/* DWL_REQ low and keep low forever */
		GPIO_SetValue(LPC_PORT0, PIN_DWL_REQ);
	}
	else
	{
		GPIO_ClearValue(LPC_PORT0, PIN_DWL_REQ);
	}

	/* Set port pin - NRESET to output */
	GPIO_SetDir(LPC_PORT2, PIN_RESET, SET_OUT );
	/* Set port pin - NRESET to output */

	/* send the reset pulse 0-1-0 to reset device */
	/* RSET signal low - PDOWN to '0' */
	GPIO_ClearValue(LPC_PORT2, PIN_RESET);

	/* delay of ~1,2 ms */
	for (i = 0x2800; i > 0; i --);

	/* RSET signal high to reset the PN5180 IC - PDOWN to '1' */
	GPIO_SetValue(LPC_PORT2, PIN_RESET);

	/* delay of ~1,2 ms */
	for (i = 0x2800; i > 0; i --);

   	return status;
}


/*==============================================================================
 * Function:    phDlhalHw_Pn5180_ResetDevice
 *
 * brief:   This function resets an attached reader IC. In PIN_RESET macro is a
 *          correct pin .
 *
 * ---------------------------------------------------------------------------*/
void phDlhalHw_Pn5180_ResetDevice(void)
{
	uint32_t volatile i;

    /* Set port pin - DWL_REQ to output */
    GPIO_SetDir(LPC_PORT0, PIN_DWL_REQ, SET_OUT );

    /* DWL_REQ low and keep low forever */
    GPIO_ClearValue(LPC_PORT0, PIN_DWL_REQ);

    /* Set port pin - NRESET to output */
    GPIO_SetDir(LPC_PORT2, PIN_RESET, SET_OUT );
    /* Set port pin - NRESET to output */

    /* send the reset pulse 0-1-0 to reset device */
    /* RSET signal low - PDOWN to '0' */
    GPIO_ClearValue(LPC_PORT2, PIN_RESET);

    /* delay of ~1,2 ms */
    for (i = 0x2800; i > 0; i --);

    /* RSET signal high to reset the PN5180 IC - PDOWN to '1' */
    GPIO_SetValue(LPC_PORT2, PIN_RESET);

    /* delay of ~1,2 ms */
    for (i = 0x2800; i > 0; i --);

}
