/*******************************************************************************
 *   config.h:  config file for example for NXP LPC122x Family
 *   Microprocessors
 *
 *   Copyright(C) 2008, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2012.07.20  ver 1.00    First Release
 *
 ******************************************************************************/

#ifndef __PHLPC1768_BUILD_H__
#define __PHLPC1768_BUILD_H__

/*******************************************************************************
 **    Global macros and definitions
 ******************************************************************************/

#define SPI_USED
/*#define I2C_USED*/

#if defined (SPI_USED) && defined (I2C_USED)
#error ** Mismatch interface definition - I2C and SPI not alloved together **
#endif

#ifdef SPI_USED
#define PHHAL_HW_BUS    PHHAL_HW_BAL_CONNECTION_SPI
#endif /* SPI_USED */
#ifdef I2C_USED
#define PHHAL_HW_BUS    PHHAL_HW_BAL_CONNECTION_I2C
#endif /* I2C_USED */

/* ------------------------------------------------ */
/* pins definition                                  */
/* ------------------------------------------------ */
#define ADDR_CLEAR          0
#define ADDR_SET            1

#define SSEL_ASR            0
#define SSEL_DEASR          1
#define READER_CHIP_ADDR    0x50

#define I2C_SDA             1 << 10
#define I2C_SCL             1 << 11

#define MOSI_PINNUM_SSP1    9
#define MISO_PINNUM_SSP1    8
#define SCK_PINNUM_SSP1     7
#define SSEL_PINNUM_SSP1    10

#define MOSI_PINNUM_SSP0    18
#define MISO_PINNUM_SSP0    17
#define SCK_PINNUM_SSP0     15
#define SSEL_PINNUM_SSP0    16

#endif    /* __PHLPC1768_BUILD_H__ */
